#!/usr/bin/perl

use	strict	;

my	$gui	= "kde"	;
my	$qt	= ""	;
my	$prefix	= undef	;
my	$debug	= "no"	;
my	@t	= localtime (time) ;
my	$date	= sprintf "%02d%02d%02d", $t[5] - 100, $t[4] + 1, $t[3] ;

A : while ($#ARGV >= 0)
{
	if ($ARGV[0] eq "-qt3")
	{
		$gui	= "qt3"	;
		$qt	= "qt"	;
		$prefix	= "/usr/local/rekallqt" ;
		shift	;
		next A	;
	}
	if ($ARGV[0] eq "-kde3")
	{
		$gui	= "kde3" ;
		shift	;
		next A	;
	}

	print	STDERR	"mkspec.pl: unknown option: $ARGV[0]\n" ;
	exit	1 ;
}

my	%subs	=
(
	mdk91	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/usr",
		SGMLPFX	=> "--with-sgml-prefix=/usr",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	mdk92	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/usr",
		SGMLPFX	=> "--with-sgml-prefix=/usr",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	mdk100	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/usr",
		SGMLPFX	=> "--with-sgml-prefix=/usr",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	mdk101	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/usr",
		SGMLPFX	=> "--with-sgml-prefix=/usr",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	rh80	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/usr",
		SGMLPFX	=> "--with-sgml-prefix=/usr",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	rh90	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/usr",
		SGMLPFX	=> "--with-sgml-prefix=/usr",
		QTDIR	=> "--with-qt-dir=/usr/lib/qt-3.1",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	fc2	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/usr",
		SGMLPFX	=> "--with-sgml-prefix=/usr",
		QTDIR	=> "--with-qt-dir=/usr/lib/qt-3.3",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	fc3	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/usr",
		SGMLPFX	=> "--with-sgml-prefix=/usr",
		QTDIR	=> "--with-qt-dir=/usr/lib/qt-3.3",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	fc4	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/usr",
		SGMLPFX	=> "--with-sgml-prefix=/usr",
		QTDIR	=> "--with-qt-dir=/usr/lib/qt-3.3",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	slak90	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/opt/kde",
		SGMLPFX	=> "--with-sgml-prefix=/opt/kde",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	slak91	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/opt/kde",
		SGMLPFX	=> "--with-sgml-prefix=/opt/kde",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	suse82	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/opt/kde3",
		SGMLPFX	=> "--with-sgml-prefix=/opt/kde3",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	suse90	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/opt/kde3",
		SGMLPFX	=> "--with-sgml-prefix=/opt/kde3",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	suse91	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/opt/kde3",
		SGMLPFX	=> "--with-sgml-prefix=/opt/kde3",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	suse92	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/opt/kde3",
		SGMLPFX	=> "--with-sgml-prefix=/opt/kde3",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	},

	suse93	=>
	{
		PREFIX	=> defined $prefix ? $prefix : "/opt/kde3",
		SGMLPFX	=> "--with-sgml-prefix=/opt/kde3",
		QTDIR	=> "",
		DOCFIX	=> ":",
		GUI	=> $gui,
		QT	=> $qt,
		DEBUG	=> $debug
	}
)	;

foreach	my $dist (keys %subs)
{
	my	$text	;

	open	SKEL, "skeleton.spec" ;
	$text	= join "", <SKEL> ;
	close	SKEL ;

	$text  =~ s/!\{DIST}/$dist/ ;
	$text  =~ s/!\{DATE}/$date/ ;

	foreach	my $key (keys % {$subs{$dist}})
	{
		my $repl = $subs{$dist}->{$key} ;

		$text =~ s/!\{$key}/$repl/g ;
	}

	open	DIST, ">$dist.spec" ;
	print	DIST $text ;
	close	DIST ;
}
