/***************************************************************************
    file	         : kb_buttonproxy.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<kjs/global.h>
#include	<kjs/interpreter.h>
#include	<kjs/lookup.h>
#include	<kjs/object.h>
#include	<kjs/operations.h>
#include	<kjs/types.h>
#include	<kjs/ustring.h>
#include	<kjs/value.h>

#include	"kb_classes.h"
#include	"kb_button.h"

#include	"kb_idbase.h"
#include	"kb_objectproxy.h"
#include	"kb_buttonproxy.h"
#include	"kb_kjsregister.h"


extern	QString kjsStringArg	(KJS::ExecState *, const KJS::List &, int) ;


/*  KBButtonProxy							*/
/*  KBButtonProxy: Constructor for rekall button proxy			*/
/*  interp	 : KJS::Interpreter *	: Intepreter object		*/
/*  button	 : KBButton *		: Rekall button			*/
/*  (returns)	 : KBOButtonProxy	:				*/

KBButtonProxy::KBButtonProxy
	(	KJS::Interpreter	*interp,
		KBButton		*button
	)
	:
	KBObjectProxy	(interp, button)
{
}

/*  KBButtonProxy							*/
/* ~KBButtonProxy: Destructor for rekall button proxy			*/
/*  (returns)	 :		:					*/

KBButtonProxy::~KBButtonProxy ()
{
}

/*  KBButtonProxy							*/
/*  addBindings	: Add proxy bindings to specified button		*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  object	: KJS::Object &		: Object to which to add	*/
/*  (returns)	: void			:				*/

void	KBButtonProxy::addBindings
	(	KJS::ExecState	*exec,
		KJS::Object	&object
	)
{
	KBObjectProxy::addBindings (exec, object) ;
}

/*  KBButtonProxy							*/
/*  get		: Get property value					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  property	: constKJS::UString &	: Property name			*/
/*  (returns)	: KJS::Value		: Result			*/

KJS::Value
	KBButtonProxy::get
	(	KJS::ExecState		*exec,
		const KJS::UString	&property
	)
	const
{
	QString	p = property.qstring() ;

	if (p == "text")
		return	KJS::String(m_object->getAttrVal("text")) ;

	return	KBObjectProxy::get (exec, property) ;
}

/*  KBButtonProxy							*/
/*  put		: Set property value					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  property	: const KJS::UString &	: Property name			*/
/*  value	: const KJS::Value &	: Value				*/
/*  attr	: int			:				*/
/*  (returns)	: void			:				*/

void	KBButtonProxy::put
	(	KJS::ExecState		*exec,
		const KJS::UString	&property,
		const KJS::Value	&value,
		int			attr
	)
{
	QString	p = property.qstring() ;

	if (p == "text")
	{
		((KBButton *)m_object)->setText (value.toString(exec).qstring()) ;
		return	;
	}

	KBObjectProxy::put (exec, property, value, attr) ;
}




/*  ------------------------------------------------------------------  */

KBButtonProxy::MethodImp::MethodImp
	(	uint			id,
		const KBButtonProxy	*button
	)
	:
	KBObjectProxy::MethodImp(id, button),
	m_button		(button)
{
}

KJS::Value
	KBButtonProxy::MethodImp::call
	(	KJS::ExecState		*exec,
		KJS::Object		&object,
		const KJS::List		&args
	)
{
	return	KBObjectProxy::MethodImp::call (exec, object, args) ;
}



KBObjectProxy
	*makeButtonProxy
	(	KJS::Interpreter	*interp,
		KBNode			*node
	)
{
	return	new KBButtonProxy (interp, (KBButton *)node) ;
}

static	KBKJSRegister	_buttonReg ("KBButton", makeButtonProxy) ;
