/***************************************************************************
    file	         : kb_pydebug.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_python.h"

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_dbinfo.h"

#include	"tk_icons.h"
#include	"tk_config.h"
#include	"kb_gui.h"

#include	"kb_pyscript.h"

#ifndef 	_WIN32
#include	"kb_pydebug.moc"
#else
#include	"kb_pydebug.h"
#endif




static	GUIElement debugGUI[] =
{
//	GType		GGroup		Enable	Text			Icon		Accelerator	Slot			    Element name	Code		Tool Tip
{	GTAction,	KB::GRNone,	true,	"Exception skip list",	"options",	ACCEL(NoAccel),	SLOT(setExcSkipList     ()),"KB_excskiplist",	0,		"Set exception skip list"	},
{	GTAction,	KB::GRNone,	true,	"Abort",		"abort",	ACCEL(NoAccel),	SLOT(breakAction     (int)),"KB_abort",		OptAbort,	"Abort execution"		},
{	GTAction,	KB::GRNone,	true,	"Step",			"nextrecord",	ACCEL(NoAccel),	SLOT(breakAction     (int)),"KB_step",		OptStep,	"Single step"			},
{	GTAction,	KB::GRNone,	true,	"Continue",		"lastrecord",	ACCEL(NoAccel),	SLOT(breakAction     (int)),"KB_continue",	OptContinue,	"Continue execution"		},
{	GTAction,	KB::GRNone,	true,	"Toggle breakpoint",	"togglebpt",	ACCEL(NoAccel),	SLOT(toggleBreakpoint   ()),"KB_toggleBpt",	0,		"Toggle breakpoint"		},
{	GTToggle,	KB::GRNone,	true,	"Trap exceptions",	"trapexcept",	ACCEL(NoAccel),	SLOT(trapExceptions (bool)),"KB_trapexc",	0,		"Trap exceptions"		},
{	GTNone,		KB::GRNone,	false,	0,			0,		ACCEL(NoAccel),	0,			  0,		 	0,		0				}
}	;


/*  KBPYDebug	: 							*/
/*  KBPYDebug	: Constructor for python debugger			*/
/*  action	: TKToggleAction *: Show/hide action for this window	*/
/*  ok		: bool &	  : Success				*/
/*  (returns)	: KBPYDebug	  :					*/

KBPYDebug::KBPYDebug
	(	TKToggleAction	*action,
		bool		&ok
	)
	:
	KBDebug	(action, "py")
{
	KBError	error	  ;

	if ((m_scrIface = KBPYScriptIF::getIface ()) == 0)
	{
		KBError::EError
		(	"Python script interface not initialised?",
			QString::null,
			__ERRLOCN
		)	;
		ok = false ;
		return	;
	}

	setLocalGUISpec	(&debugGUI[0]) ;
	setGUI	  (m_gui = new KBaseGUI (this, this, "rekallui.pydebug")) ;

	m_debWidget = new TKCPyDebugWidget (m_partWidget, getMainWindow()) ;
	m_topWidget = m_debWidget ;

	TKConfig *config = getConfig() ;
	m_size	 = config->readSizeEntry ("Geometry" ) ;

	if (m_size == QSize()) m_size = QSize (600, 500) ;

	m_partWidget->resize	(m_size.width(), m_size.height(), true, false) ;
	m_partWidget->setIcon	(getSmallIcon ("shellscript")) ;
	m_partWidget->setCaption("Debugger: Python") ;
	m_partWidget->show	()  ;

	m_debWidget ->init 	(config) ;

	m_debWidget ->trapExceptions (true) ;
	m_gui       ->setChecked     ("trapexcept", true) ;

	connect	(m_debWidget, SIGNAL(showingFile(bool)),	     SLOT(showingFile(bool))) ;
	connect	(m_debWidget, SIGNAL(fileChanged(bool)),	     SLOT(fileChanged(bool))) ;
	connect	(m_debWidget, SIGNAL(enterTrap  (bool, bool, bool)), SLOT(enterTrap  (bool, bool, bool))) ;
	connect	(m_debWidget, SIGNAL(exitTrap       ()),	     SLOT(exitTrap       ())) ;

	exitTrap	()	;
	showingFile	(false)	;

	ok	  = true ;
}

/*  KBPYDebug	: 							*/
/*  ~KBPYDebug	: Destructor for simple script editor			*/
/*  (returns)	:		:					*/

KBPYDebug::~KBPYDebug ()
{
}

/*  KBPYDebug								*/
/*  queryClose	: Check whether OK to close				*/
/*  (returns)	: bool		: OK					*/

bool	KBPYDebug::queryClose ()
{
	if (KBDebug::queryClose ())
	{
		TKConfig *config = getConfig () ;

		config     ->writeEntry ("Geometry", m_size) ;
		m_debWidget->save	(config) ;
		config     ->sync	() ;
		return	true ;
	}

	return	false	;
}


/*  KBPYDebug								*/
/*  debugScript	: Load script into debugger				*/
/*  location	: KBLocation &	: Script location			*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBPYDebug::debugScript
	(	KBLocation	&location,
		KBError		&pError
	)
{
	return	KBPYScriptIF::getIface()->debugScript (location, pError) ;
}


void	KBPYDebug::slotClose ()
{
	if (m_debWidget != 0) m_debWidget->closeModule () ;
}

void	KBPYDebug::saveDocument ()
{
	if (m_debWidget != 0) m_debWidget->saveModule  () ;
}

void	KBPYDebug::doCompile ()
{
	if (m_debWidget != 0) m_debWidget->doCompile   () ;
}

void	KBPYDebug::breakAction
	(	int	action
	)
{
	if (m_debWidget != 0) m_debWidget->breakAction    (action) ;
}

void	KBPYDebug::setExcSkipList ()
{
	if (m_debWidget != 0) m_debWidget->setExcSkipList () ;
}

void	KBPYDebug::trapExceptions
	(	bool	trap
	)
{
	fprintf	(stderr, "KBPYDebug::trapExceptions(%d) called\n", trap) ;
	if (m_debWidget != 0) m_debWidget->trapExceptions (trap) ;
}

void	KBPYDebug::toggleBreakpoint ()
{
	if (m_debWidget != 0) m_debWidget->toggleBreakpoint () ;
}

void	KBPYDebug::showingFile
	(	bool	showing
	)
{
	m_gui->setEnabled ("KB_closeDoc",  showing) ;
	m_gui->setEnabled ("KB_compile",   showing) ;
	m_gui->setEnabled ("KB_toggleBpt", showing) ;
}

void	KBPYDebug::fileChanged
	(	bool	changed
	)
{
	m_gui->setEnabled ("KB_saveDoc",  changed) ;
}

void	KBPYDebug::enterTrap
	(	bool	canAbort,
		bool	canContinue,
		bool	canStep
	)
{
	m_gui->setEnabled ("KB_abort",	  canAbort   ) ;
	m_gui->setEnabled ("KB_continue", canContinue) ;
	m_gui->setEnabled ("KB_step",	  canStep    ) ;
}

void	KBPYDebug::exitTrap ()
{
	m_gui->setEnabled ("KB_abort",	  false) ;
	m_gui->setEnabled ("KB_continue", false) ;
	m_gui->setEnabled ("KB_step",	  false) ;
}
