/***************************************************************************
    file	         : tkc_pydebug.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_location.h"

#include	"tkc_pydebug.h"
#include	"tkc_pydebugwidget.h"



void	TKCPyDebugError
	(	const QString	&error,
		const QString	&details,
		bool		fatal
	)
{
	KBError	(	fatal ? KBError::Error : KBError::Fault,
			error,
			details,
			__ERRLOCN
		)
		.DISPLAY () ;
}


TKCPyRekallCookie::TKCPyRekallCookie
	(	KBLocation	&location
	)
	:
	location (location)
{
}

TKCPyRekallCookie::~TKCPyRekallCookie ()
{
}

bool	TKCPyRekallCookie::put
	(	const QString	&text,
		QString		&eError,
		QString		&eDetails
	)
{
	KBError	error	;

	if (!location.save (QString::null, QString::null, text, error))
	{
		eError	 = error.getMessage () ;
		eDetails = error.getDetails () ;
		return	 false	;
	}

	return	true	;
}

bool	TKCPyRekallCookie::get
	(	QString		&text,
		QString		&eError,
		QString		&eDetails
	)
{
	KBError	error	;

	if ((text = location.contents(error)) == QString::null)
	{
		eError   = error.getMessage () ;
		eDetails = error.getDetails () ;
		return	 false	;
	}

	return	text	;
}

TKCPyCookie
	*TKCPyRekallCookie::replicate ()
{
	return	new TKCPyRekallCookie (location) ;
}


QString	TKCPyRekallCookie::title ()
{
	return	location.title () ;
}


bool	TKCPyRekallCookie::operator==
	(	const TKCPyCookie	&other
	)
{
	return	location == ((TKCPyRekallCookie *)&other)->location ;
}

/*  TKCPyDebug								*/
/*  funcTraceHook: Python function call tracing hook			*/
/*  pyFrame	 : PyObject *	 : Call frame				*/
/*  pyMsg	 : PyObject *	 : Trace message			*/
/*  pyArg	 : PyObject *	 : Trace arguments			*/
/*  userPtr	 : void *	 : User supplied pointer		*/
/*  (returns)	 : TKCPyTraceOpt : Trace continuation code		*/

TKCPyTraceOpt
	TKCPyDebug::funcTraceHook
	(	PyObject	*pyFrame,
		PyObject	*pyMsg,
		PyObject	*pyArg,
		void		*userPtr
	)
{
	TKCPyDebugWidget	*debWidget ;

	fprintf	(stderr, "TKCPyDebug::frameTraceHook() called\n") ;

	if ((debWidget = TKCPyDebugWidget::widget()) != 0)
		return	debWidget->doFuncTrace (pyFrame, pyMsg, pyArg, userPtr) ;

	return	OptContinue ;
}

/*  TKCPyDebug								*/
/*  lineTraceHook: Python line tracing hook				*/
/*  pyFrame	 : PyObject *	 : Call frame				*/
/*  pyMsg	 : PyObject *	 : Trace message			*/
/*  pyArg	 : PyObject *	 : Trace arguments			*/
/*  userPtr	 : void *	 : User supplied pointer		*/
/*  (returns)	 : TKCPyTraceOpt : Trace continuation code		*/

TKCPyTraceOpt
	TKCPyDebug::lineTraceHook
	(	PyObject	*pyFrame,
		PyObject	*pyMsg,
		PyObject	*pyArg,
		void		*userPtr
	)
{
	TKCPyDebugWidget	*debWidget ;

	fprintf	(stderr, "TKCPyDebug::lineTraceHook() called\n") ;

	if ((debWidget = TKCPyDebugWidget::widget()) != 0)
		return	debWidget->doLineTrace (pyFrame, pyMsg, pyArg, userPtr) ;

	return	OptContinue ;
}

/*  TKCPyDebug								*/
/*  profTraceHook: Python profile tracing hook				*/
/*  pyFrame	 : PyObject *	 : Call frame				*/
/*  pyMsg	 : PyObject *	 : Trace message			*/
/*  pyArg	 : PyObject *	 : Trace arguments			*/
/*  userPtr	 : void *	 : User supplied pointer		*/
/*  (returns)	 : TKCPyTraceOpt : Trace continuation code		*/

TKCPyTraceOpt
	TKCPyDebug::profTraceHook
	(	PyObject	*pyFrame,
		PyObject	*pyMsg,
		PyObject	*pyArg,
		void		*userPtr
	)
{
	TKCPyDebugWidget	*debWidget ;

	fprintf	(stderr, "TKCPyDebug::profTraceHook() called\n") ;

	if ((debWidget = TKCPyDebugWidget::widget()) != 0)
		return	debWidget->doProfTrace (pyFrame, pyMsg, pyArg, userPtr) ;

	return	OptContinue ;
}

TKCPyTraceOpt
	TKCPyDebug::doDebugHook
	(	PY_FRAME_TYPE	*pyFrame,
		const char	*msg
	)
{
	TKCPyDebugWidget	*debWidget ;

	fprintf	(stderr, "TKCPyDebug::debugHook() called\n") ;

	if ((debWidget = TKCPyDebugWidget::widget()) != 0)
		return	debWidget->doDebugHook (pyFrame, msg) ;

	return	OptContinue ;
}

