/***************************************************************************
    file	         : tkc_pyeditor.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"tkc_pydebugbase.h"

#ifndef 	_WIN32
#include	"tkc_pyeditor.moc"
#else
#include 	"tkc_pyeditor.h"
#endif

#include	"kb_options.h"
#include	"kb_font.h"
#include	"kb_dialog.h"

#include	"kb_locator.h"



TKTextEditorManager *getTextManager ()
{
	static TKTextEditorManager *manager ;

	if (manager == 0)
	{
		QString	hldir	= locateDir
				  (	"appdata",
					"highlight/global/nohighlight"
				  )
				  + "highlight/"   ;

		manager = new TKTextEditorManager  ;

		manager->setResourcesDir	   (hldir) ;
		manager->setOverwriteMode	   (false) ;
		manager->setIndicatorMarginVisible (false) ;
		manager->setLinuNumberMarginVisible(true ) ;
		manager->setSelectionMarginVisible (true ) ;

		manager->setFont
		(	KBFont::specToFont(KBOptions::getScriptFont())
		)	;
	}

	return	manager	;
}

/*  TKCPyEditor								*/
/*  TKCPyEditor	: Constructor for debug/editor widget			*/
/*  parent	: QWidget *	     : Parent widget			*/
/*  debug	: TKCPyDebugWidget * : Parent debugger			*/
/*  module	: TKCPyCookie *	     : Module				*/
/*  (returns)	: TKCPyDebugWidget   :					*/

TKCPyEditor::TKCPyEditor
	(	QWidget		 	*parent,
		TKCPyDebugWidget 	*debug,
		TKCPyCookie		*module
	)
	:
	TKTextEditor
	(	new TKTextDocument (getTextManager()),
		parent
	),
	mapper	(this),
	debug	(debug),
	module	(module->replicate())
{
	setHighlight ("Python") ;

	connect	(this, 	SIGNAL(marginRightClick(int,int,ButtonState)),
		 this,	SLOT  (onRightClick    (int,int,ButtonState))) ;

	curLineNo = 0 ;
}

/*  TKCPyEditor								*/
/*  TKCPyEditor	: Destructor for debug/editor widget			*/
/*  (returns)	:   		:					*/

TKCPyEditor::~TKCPyEditor ()
{
	/* Clear all line breaks associated with the module and delete	*/
	/* the cookie copy which we have.				*/
	debug->clearBreakpoints (module) ;

	if(module != 0)
		delete	module	;

	module = 0;
}

/*  TKCPyEditor								*/
/*  setCurrentLine: Set current line marker				*/
/*  lineNo	  : uint	: Line number				*/
/*  (returns)	  : void	:					*/

void	TKCPyEditor::setCurrentLine
	(	uint	lineNo
	)
{
	fprintf	(stderr, "TKCPyEditor::setCurrentLine (%u) (was %d)\n",
			 lineNo,
			 curLineNo
		) ;

	if (curLineNo != 0)
	{
		document->setMarked
		(	curLineNo - 1,
			document->marked(curLineNo - 1) & ~0x2
		)	;
		curLineNo = 0 ;
	}


	if (lineNo != 0)
	{	
		document->setMarked
		(	lineNo - 1,
			document->marked(lineNo - 1) |  0x2
		)	;

		moveCursor (lineNo - 1, 0) ;

		curLineNo = lineNo ;
	}
}

/*  TKCPyEditor								*/
/*  getCurrentLine: Get current line marker				*/
/*  (returns)	  : uint	: Line number				*/

uint	TKCPyEditor::getCurrentLine ()
{
	return	line () + 1 ;
}

/*  TKCPyEditor								*/
/*  setBreakpoint: Set a breakpoint marker				*/
/*  lineNo	 : uint		: Line number				*/
/*  (returns)	 : void		:					*/

void	TKCPyEditor::setBreakpoint
	(	uint	lineNo
	)
{
	document->setMarked
	(	lineNo - 1,
		document->marked(lineNo - 1) |  0x1
	)	;

	int	idx	;
	if ((idx = bptList.findIndex (lineNo)) < 0) bptList.append (lineNo) ;
}

/*  TKCPyEditor								*/
/*  clearBreakpoint							*/
/*		: Set a breakpoint marker				*/
/*  lineNo	: uint		: Line number				*/
/*  (returns)	: void		:					*/

void	TKCPyEditor::clearBreakpoint
	(	uint	lineNo
	)
{
	document->setMarked
	(	lineNo - 1,
		document->marked(lineNo - 1) & ~0x1
	)	;

	bptList.remove (lineNo) ;
}


/*  TKCPyEditor								*/
/*  showText	: Show specified text					*/
/*  _content	: const QString & : Module text				*/
/*  (returns)	: void		  :					*/

void	TKCPyEditor::showText
	(	const QString	&_content
	)
{
	setText	(_content) ;

	QValueList<int>::Iterator iter ;
	for (iter = bptList.begin() ; iter != bptList.end() ; ++iter)
		document->setMarked
		(	*iter - 1,
			document->marked (*iter - 1) | 0x1
		)	;
}

/*  TKCPyEditor								*/
/*  save	: Save document						*/
/*  eText	: QString &	: Error text				*/
/*  eDetails	: QString &	: Error details				*/
/*  (return)	: bool		: Success				*/

bool	TKCPyEditor::save
	(	QString		&eText,
		QString		&eDetails
	)
{
	return	module->put (text(), eText, eDetails) ;
}

/*  TKCPyEditor								*/
/*  onRightClick: Handle right-mouse click in margin			*/
/*  		: int		: Margin number				*/
/*  pos		: int		: Character position			*/
/*  		: ButtonState	: Shift/ctrl/alt state			*/
/*  (returns)	: void		:					*/

void	TKCPyEditor::onRightClick
	(	int		,
		int		,
		ButtonState	
	)
{
}

/*  TKCPyEditor								*/
/*  gotoLine	: Move cursor to specified line				*/
/*  lno		: uint		: Line number				*/
/*  (returns)	: void		:					*/

void	TKCPyEditor::gotoLine
	(	uint	lno
	)
{
	moveCursor (lno, 0)	;
	TKTextEditor::setFocus();
}
