/***************************************************************************
    file	         : tkc_pydebugwidget.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TKC_PYDEBUGWIDGET_H
#define	__TKC_PYDEBUGWIDGET_H


#include	<qsplitter.h>
#include	<qlayout.h>
#include	<qlistview.h>
#include	<qpushbutton.h>
#include	<qlabel.h>
#include	<qdialog.h>
#include	<qtabwidget.h>
#include	<qlistbox.h>
#include	<qpopupmenu.h>
#include	<qwidgetlist.h>
#include	<qregexp.h>
#include	<qtabwidget.h>

#include	"kb_python.h"


#include	"tkc_labeller.h"
#include	"tkc_pyvalue.h"
#include	"tkc_pyvaluelist.h"
#include	"tkc_pyfunclist.h"
#include	"tkc_pytracelist.h"
#include	"tkc_pystacklist.h"

#include	"kb_classes.h"
#include	"kb_gui.h"
#include	"kb_partwidget.h"
#include	"kb_part.h"



class	TKCPyEditor		;
class	TKCPyDebugDialog	;
class 	QGridLayout		;
class	TKTextEditorManager	;


/*  TKCPyDebugWidget							*/
/*  ----------------							*/
/*  This is the widget that provides the GUI interface to the python	*/
/*  debugger. Normally, it is non-modal, however inside a breakpoint it	*/
/*  is embedded into a QDialog and becomes effectively modal		*/

class	TKCPyDebugWidget : public QWidget
{
	Q_OBJECT

	QWidget			*parent			;
	KBSDIMainWindow		*window			;

	QLabel			*m_pReason		;

#if	__KB_EMBEDDED
#else
	QSplitter		*m_pSplitMain		;
#endif
	QSplitter		*m_pSplitRight		;
	QWidget			*m_pRightSide		;
	QTabWidget   		*m_pDockTabGroup	;

	TKCPyValueList		*m_pObjectView		;
	TKCPyFuncList		*m_pFuncView		;
	TKCPyValueList		*m_pTraceView		;
	TKCPyValueList		*m_pStackView		;

	QTabWidget		*m_pEditors		;
	QListBox		*m_pErrWin		;

	QVBoxLayout		*m_pLayMain		;
	QVBoxLayout		*m_pLayRight		;
	TKCPyDebugDialog	*inDialog		;

	TKTextEditorManager	*m_pManager		;
	QList<TKCPyEditor>	editList		;

	TKCPyValueItem		*popItem		;
	TKCPyTraceItem		*traceItem		;

	bool			inModalLoop		;
	TKCPyTraceOpt		modalEndRC		;
	uint			aborting		;
	bool			m_excTrap		;

	QRegExp			errExp			;

	TKCPyEditor		*showObjectCode	   (PyObject *) ;
	TKCPyCookie		*getObjectModule   (PyObject *, uint &) ;

	void			setTraceMessage	   (const QString &) ;
	void			loadErrorText	   (const QString &) ;
	void			showEvent	   (QShowEvent	  *) ;
	void			showTrace	   (PyFrameObject *, const QString &) ;
	PyObject		*getCode	   (PyObject      *) ;
	void			addBreakOptions	   (QPopupMenu &, PyObject *) ;

	TKCPyTraceOpt		showAsDialog	   (bool) ;

signals :

	void	showingFile		(bool)	;
	void	fileChanged		(bool)	;
	void	enterTrap		(bool, bool, bool) ;
	void	exitTrap		()	;

private slots :

	void	showSource		()	;

	void	setBreakpoint		()	;
	void	setWatchpoint		()	;
	void	enableBreakpoint	()	;
	void	disableBreakpoint	()	;
	void	removeWatchpoint	()	;

	void	showContextMenu		(int, QListViewItem *, const QPoint &, int) ;


	void	editorChanged		(QWidget *) ;
	void	moduleChanged		(int)	;

	void	errSelected		(int)	;

public	:

	TKCPyDebugWidget (QWidget *, KBSDIMainWindow *) ;
       ~TKCPyDebugWidget () ;

	TKCPyTraceOpt	doFuncTrace 	(PyObject *, PyObject *, PyObject *, void *) ;
	TKCPyTraceOpt	doLineTrace	(PyObject *, PyObject *, PyObject *, void *) ;
	TKCPyTraceOpt	doProfTrace	(PyObject *, PyObject *, PyObject *, void *) ;
	TKCPyTraceOpt	doDebugHook	(PY_FRAME_TYPE *, const char *) ;

	void		dropSource	(TKCPyCookie *) ;
	void		init		(TKConfig *) ;
	void		save		(TKConfig *) ;
	void		codeLoaded	() ;
	void		clearBreakpoints(TKCPyCookie *) ;
	void		toggleBreakpoint(TKCPyCookie *, uint, TKCPyEditor *) ;
	void		toggleBreakpoint()	;

	void		breakAction	(int)	;
	void		setExcSkipList	()	;
	bool		saveModule	()	;
	void		doCompile	()	;
	void		closeModule	()	;

	TKCPyEditor	*editModule	(TKCPyCookie *, const QString     &) ;

	void		trapExceptions	(bool)	;


	static	TKCPyDebugWidget	*debWidget ;
	static	TKCPyDebugWidget	*widget () ;
}	;

#endif	// __TKC_PYDEBUGWIDGET_H
