/***************************************************************************
    file	         : pychoice.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYCHOICE_H
#define	__KB_PYCHOICE_H

#include	"kb_choice.h"

class	PyKBChoice : public PyKBItem
{
public	:

	inline	PyKBChoice
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBItem (_cookie, _ptr, _name)
	{
	}

	inline	void	setValues
		(	const QStringList &vals
		)
	{
		KBChoice *ptr = (KBChoice *)getPtr() ;
		if (ptr != 0) ptr->setValues (vals)  ;
	}

	const QStringList &getValues ()
	{
		static	QStringList aQStringList ;
		if (!isValid()) return aQStringList ;
		return	((KBChoice *)getPtr())->getValues() ;
	}

	inline	int	currentItem
		(	uint		qrow
		)
	{
		KBChoice *ptr = (KBChoice *)getPtr() ;
		return ptr == 0 ? -1 : (int)ptr->currentItem (qrow) ;
	}

	inline	void	setCurrentItem
		(	uint		qrow,
			int		index
		)
	{
		KBChoice *ptr = (KBChoice *)getPtr() ;
		if (ptr != 0) ptr->setCurrentItem (qrow, index) ;
	}

}	;

#endif	// __KB_PYCHOICE_H
