/***************************************************************************
    file	         : pydblink.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_PYDBLINK_H
#define	__KB_PYDBLINK_H

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"pybase.h"

class	PyKBDBLink : public PyKBBase
{
public	:

	inline	PyKBDBLink
		(	long		_cookie,
			long		_ptr,
			const char	*_name
		)
		:
		PyKBBase (_cookie, _ptr, _name)
	{
	}

	inline	~PyKBDBLink ()
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink != 0) delete dbLink ;
	}

	inline	cchar	*listTypes ()
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return 0 ;
		return	dbLink->listTypes () ;
	}

	inline	cchar	*getDBType ()
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return 0 ;
		return	dbLink->getDBType () ;
	}

	inline	cchar	*rekallPrefix
		(	cchar	*name
		)
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return 0 ;
		static	QString	pfxName	  ;
		pfxName	= dbLink->rekallPrefix (name) ;
		return	(cchar *)pfxName  ;
	}

	inline	cchar	*placeHolder
		(	uint	place
		)
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return "?" ;
		static	QString	placeText   ;
		placeText = dbLink->placeHolder (place) ;
		return	(cchar *)placeText  ;
	}

	inline	bool	keepsCase ()
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return 0 ;
		return	dbLink->keepsCase () ;
	}

	inline	cchar	*fixCase
		(	cchar	*name
		)
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return 0 ;
		static	QString	fixed	  ;
		fixed	= dbLink->fixCase (name) ;
		return	(cchar *)fixed    ;
	}

//	inline	bool	connect
//		(	KBDBInfo	*dbInfo,
//			const QString	&svrName,
//		)
//	{
//		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
//		if (dbLink == 0) return false ;
//		return	dbLink->connect (dbInfo, svrName, true) ;
//	}

	inline	KBSQLSelect *qrySelect
		(	const QString	&query
		)
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return 0 ;
		return	dbLink->qrySelect (true, query) ;
	}

	inline	KBSQLInsert *qryInsert
		(	const QString	&query,
			const QString	&table
		)
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return 0 ;
		return	dbLink->qryInsert (true, query, table) ;
	}

	inline	KBSQLUpdate *qryUpdate
		(	const QString	&query,
			const QString	&table
		)
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return 0 ;
		return	dbLink->qryUpdate (true, query, table) ;
	}

	inline	KBSQLDelete *qryDelete
		(	const QString	&query,
			const QString	&table
		)
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return 0 ;
		return	dbLink->qryDelete (true, query, table) ;
	}

	inline	uint	getColumnWidth
		(	const QString	&tabName,
			const QString	&colName
		)
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return 0 ;
		return	dbLink->getColumnWidth (tabName, colName) ;
	}

	inline	void	setColumnWidth
		(	const QString	&tabName,
			const QString	&colName,
			uint		width
		)
	{
		KBDBLink *dbLink = (KBDBLink *)getPtr() ;
		if (dbLink == 0) return ;
		dbLink->setColumnWidth (tabName, colName, width) ;
	}
}	;

#endif	// __KB_PYDBLINK_H
