/***************************************************************************
    file	         : copier.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>

#if		__KB_KDE
#include	<kapp.h>
#include	<klocale.h>
#include	<kaboutdata.h>
#include	<kcmdlineargs.h>
#endif

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_copybase.h"
#include	"kb_copyfile.h"

void	showError
	(	cchar		*where,
		KBError		&error
	)
{
	fprintf	(stderr, "Error: %s\n", where) ;
	fprintf	(stderr, "     : %s\n", (cchar *)error.getMessage()) ;
	fprintf	(stderr, "     : %s\n", (cchar *)error.getDetails()) ;
}

int	main
	(	int	argc,
		char	*argv[]
	)
{
	KBError		error	;

#if	__KB_KDE
	char *dummy[2]	;

	dummy[0] = (char *)"driver" ;
	dummy[1] = 0	;

	KAboutData about ("rekall",
			  I18N_NOOP("RekallCopierTest"),
			  "0.0.0",
			  I18N_NOOP("Rekall: Copier test harness"),
			  KAboutData::License_Unknown,
			  "(c) 2000,2001,2002 by theKompany.com",
			  0,
			  "http://www.rekall.a-i-s.co.uk",
			  "mike@quaking.demon.co.uk"
			 ) ;
	about.addAuthor  ("Mike Richardson", 0, "mike@quaking.demon.co.uk") ; 
	about.addAuthor  ("John Dean", 	     0, "john@rygannon.com") ; 

	KCmdLineArgs::init (2, dummy, &about) ;

	KApplication	app	;
#endif

	KBLocation	locn	;
	KBCopyFile	copier	(true, locn) ;

	copier.setFile	(argc > 1 ? argv[1] : "copier.1.in")	;
	copier.setDelim	("," )	;
	copier.setQualif("\"")	;
	copier.setErrOpt(0)	;

	const QDict<QString>	pDict	;

	if (!copier.prepare (pDict))
	{
		error = copier.lastError() ;
		showError ("Prepare", error) ;
		exit	  (1) ;
	}

	printf	("NumCols: %d\n", copier.getNumCols()) ;

	KBValue	values[256] ;
	int	aCols	    ;
	bool	ok	    ;
	uint	rowNo	    = 0 ;

	while ((aCols = copier.getRow (values, 256, ok, 0)) >= 0)
	{
		printf	("RowNum: %d, cols=%d\n", rowNo, aCols) ;
		rowNo	+= 1 ;

		for (int idx = 0 ; idx < aCols ; idx += 1)
			printf	("--->[%s]\n", (cchar *)values[idx].getRawText()) ;
	}

	if (!ok)
	{
		error = copier.lastError() ;
		showError ("Copy", error) ;
		exit	  (1) ;
	}

	exit	(0) ;
}
