import logging
import os 
import sys
from constants import DEFAULT_DATA_PATH
from qt import QFont

debug = logging.getLogger("settings").debug
error = logging.getLogger("settings").error

def get_font_value(s):
    if s in ('0', 'False'): return 0
    else:                   return 1

class Settings(dict):
    def __init__(self, filename=None, autocreate=False):
        dict.__init__(self)
        self.filename = filename
        self.autocreate = autocreate
        if filename:
            self.loadSettings()

    def __getitem__(self, k):
        try:
            return dict.__getitem__(self, k)
        except:
            error("Could not locate setting %s", k)
            return ""


    def getFilename(self):
        return self.filename


    def setFilename(self, filename):
        self.filename = filename


    def loadSettings(self):
        if not self.filename:
            error("Cannot loadSettings")
            return

        if not os.access(self.filename, os.R_OK) and self.autocreate:
            self.createInitialSettings()

        fp = None
        try:
            fp = open(self.filename, "r")
            for line in fp:
                line = line.strip()
                if not line or line[0] == '#': continue
                name, value = line.split(':', 1)
                name = name.strip().lower()
                value = value.strip()
                dict.__setitem__(self, name, value)
            fp.close()
            debug("Loaded settings from: %s", self.filename)
        except Exception, e:
            error(e)
        if fp: fp.close()    

    
    def saveSettings(self):
        fp = None
        err = None
        try:
            fp = open(self.filename, "w")
            
            for k,v in self.items():
                fp.write("%s: %s\n" % (k,v))
                
        except Exception, e:
            error("Could not saveSettings: %s", e)
            err = e
        if fp: fp.close()
        return err
            
    def createInitialSettings(self):
        try:
            fp = open(self.filename, "w")
        except Exception, e:
            error("Could not write file: %s - %s", self.filename, str(e))
            print
            print "ReleaseForge could not create it's configuration file:", self.filename
            print "ReleaseForge will attempt to create a configuration file if"
            print "it does not already exist.  If it's unable to do so you can"
            print "specify an alternate path for this file using the -c flag"
            print "      eg. releaseforge.py -c $HOME/releaseforge.cfg"
            print "Please refer to the ReleaseForge FAQ for more information:"
            print "      http://releaseforge.sourceforge.net/faq.html"
            sys.exit(1)          

        try:
            data_path = os.path.join(os.environ['HOME'], DEFAULT_DATA_PATH)
        except:
            data_path = os.path.join(os.getcwd(), DEFAULT_DATA_PATH)

        debug("Using %s as the data_path in %s", data_path, self.filename)
        fp.write("data_path: %s\n" % data_path)
        fp.close()
                 
        
    def parseFontStr(self, fontstr):
        # parse a font in the form: family:pt size:bold:italic:underline:strikeout
        fontstr = fontstr.strip()
        parts = fontstr.split(":")
        if len(parts) != 6: raise Exception, "Invalid font spec"


        f = QFont()
        f.setFamily(parts[0])
        f.setPointSize(int(parts[1]))
        f.setBold(get_font_value(parts[2]))
        f.setItalic(get_font_value(parts[3]))
        f.setUnderline(get_font_value(parts[4]))
        f.setStrikeOut(get_font_value(parts[5]))
        return f        

    def getFont(self, name):
        try:
            fstr = self.__getitem__(name)
            font = self.parseFontStr(fstr)
            return font
        except Exception, e:
            error(e)
            return None

    def setFont(self, name, font):
        value = "%s:%s:%s:%s:%s:%s" % (font.family(), font.pointSize(),
                                       font.bold(), font.italic(),
                                       font.underline(), font.strikeOut())
        dict.__setitem__(self, name, value)        
