#!/usr/bin/env python
import sys
import os
#############################################################

from modules.constants import LOGGER_CONFIG_FILENAME, RELEASEFORGE_CONFIG_FILENAME
import logging, logging.config

# try to locate logger.ini
paths = ("", "/usr/share/releaseforge", "/usr/local/releaseforge")
for p in paths:
    loggerpath = os.path.join(p, LOGGER_CONFIG_FILENAME)
    if os.access(loggerpath, os.R_OK): break

try:
    logging.config.fileConfig(loggerpath)
except:
    try:
        # python 2.4
        logging.basicConfig(format="%(asctime)s - %(levelname)s - %(name)s - %(message)s")
    except:
        # python 2.3
        logging.basicConfig()


#############################################################

from qt import QApplication
from modules.mainWindow import mainWindow
from modules.settings import Settings
from optparse import OptionParser

from modules.version import VERSION

#############################################################

def check_version():
    version_tuple = sys.version_info
    version = version_tuple[0] * 100 + version_tuple[1]
    if version < 203:
        print "Python >= 2.3 required.  You are using:", sys.version
        print
        sys.exit(1)

check_version()

#############################################################

if __name__ == '__main__':
    debug = logging.getLogger("releaseforge").debug
    debug("ReleaseForge v%s starting up..." % VERSION)
    parser = OptionParser()
    parser.add_option("-c", "--config",
                      dest="settings",
                      default=RELEASEFORGE_CONFIG_FILENAME,
                      metavar=RELEASEFORGE_CONFIG_FILENAME,
                      help="Specify the path of the configuration file")

    (options, args) = parser.parse_args()

    settings = Settings(options.settings, True)
    try:
        os.makedirs(settings.get('data_path'))
    except Exception, e:
        if e[0] != 17:
            print e
            sys.exit(1)


    qApp = QApplication(sys.argv)
    mw = mainWindow(settings)

    qApp.setMainWidget(mw)
    qApp.exec_loop()   
