from qt import *
from preferencesBA import PreferencesBA
from help import Help

class Preferences(PreferencesBA):
    def __init__(self, parent, settings, username):
        self.parent = parent
        self.settings = settings
        PreferencesBA.__init__(self, parent)        

        self.init_general()
        self.init_network()
        self.init_email(username)

        self.dataPathPushButton.hide()
        
        self.resize(QSize(500, 300))       
        self.show()


    def init_general(self):
        settings = self.settings

        self.dataPathLineEdit.setText(settings['data_path'])       
        try:
            font = self.settings.parseFontStr(settings['main_font'])
        except:
            font = self.parent.font()
        self.setFontButtonText(self.mainFontPushButton, font)


    def init_network(self):
        #########################
        # not currently supported
        #self.tabWidget.setTabEnabled(self.tabWidget.page(2), False)
        self.tabWidget.removePage(self.tabWidget.page(2))
        return
        #########################

        
        if self.settings['use_proxy'] in ('1', 'True'):
            self.proxyRadioButton.setChecked(True)
            self.show_proxy()
        
        self.httpServerLineEdit.setText(self.settings['http_server'])
        self.httpPortLineEdit.setText(self.settings['http_port'])
        self.sslServerLineEdit.setText(self.settings['ssl_server'])        
        self.sslPortLineEdit.setText(self.settings['ssl_port'])        
        self.ftpServerLineEdit.setText(self.settings['ftp_server'])
        self.ftpPortLineEdit.setText(self.settings['ftp_port'])

        # temp: until proxy ftp implemented
        self.ftpServerLineEdit.hide()
        self.ftpPortLineEdit.hide()
        self.ftpTextLabel.hide()


    def init_email(self, username):
        email_address = self.settings['email_address'] or "%s@users.sourceforge.net" % username
                                            
        self.emailLineEdit.setText(email_address)
        self.smtpLineEdit.setText(self.settings['smtp_server'])


    def set_general(self):
        self.settings.setFont('main_font', self.mainFontPushButton.font())


    def set_network(self):
        #############
        # currently not implemented
        return
        #############
    
        self.settings['use_proxy'] = str(self.proxyRadioButton.isChecked())
        self.settings['http_server'] = str(self.httpServerLineEdit.text())
        self.settings['http_port'] = str(self.httpPortLineEdit.text())
        self.settings['ssl_server'] = str(self.sslServerLineEdit.text())
        self.settings['ssl_port'] = str(self.sslPortLineEdit.text())
        self.settings['ftp_server'] = str(self.ftpServerLineEdit.text())
        self.settings['ftp_port'] = str(self.ftpPortLineEdit.text())
        self.parent.setProxy()        


    def set_email(self):
        self.settings['email_address'] = str(self.emailLineEdit.text())
        self.settings['smtp_server'] = str(self.smtpLineEdit.text())
        

    def accept(self):
##        data_path = str(self.dataPathLineEdit.text())
##        if not data_path:
##            QMessageBox.critical(self,
##                                 "Data Path Error",
##                                 "Data path cannot be blank")
##            return


        self.set_general()
        self.set_network()
        self.set_email()
        
        self.parent.setMainFont()
        self.parent.settings = self.settings
        self.parent.address_book_action_toggle()
        
        err = self.settings.saveSettings()
        if err:
            QMessageBox.critical(self,
                                 "Error Saving Configuration File",
                                 str(err))
            return


        PreferencesBA.accept(self)


    def setFontButtonText(self, button, font):
        #self.fontButton.setText("%s %s" % (str(font.family()),font.pointSize() ))
        button.setText("%s %s" % (str(font.family()),font.pointSize() ))


    def chooseMainFont(self):
        (font, ok) = QFontDialog.getFont(self.parent.font())
        if ok:
            self.mainFontPushButton.setFont(font)
            self.setFontButtonText(self.mainFontPushButton, font)


##    def chooseConfigFile(self):
##        fn = QFileDialog.getOpenFileName(self.configFileLineEdit.text(), "*.cfg\nAll (*)",
##                                         self, "Choose ReleaseForge configuration file")
##        if not fn.isEmpty():
##            self.configFileLineEdit.setText(fn)


##    def chooseDataPath(self):
##        dn = QFileDialog.getExistingDirectory(self.dataPathLineEdit.text(), 
##                                         self, "Choose location for ReleaseForge data")
##        if not dn.isEmpty():
##            self.dataPathLineEdit.setText(dn)


    def help(self):
        self._help = Help(self, "preferences.html")       

    def hide_proxy(self):
        self.proxyGroupBox.setEnabled(False)

    def show_proxy(self):
        self.proxyGroupBox.setEnabled(True)



