#!/bin/env python2.4
import logging
import os

debug = logging.getLogger("sf").debug
error = logging.getLogger("sf").error

from constants import PROJECTS_FILENAME
from sfcomm import SFComm
from ProjectVO import ProjectVO
from PackageVO import PackageVO
from messageQueue import mainMessageQueue
from sfurls import MY_PROJECTS_URL

try:
    set = set
except:
    from sets import Set
    set = Set

NO_CONNECT_DEBUG = 0

class SF:
    def __init__(self, data_path, sf_comm=None, username=None, password=None):
        self.projects_path = os.path.join(data_path, PROJECTS_FILENAME)
        self.projects = None
        self.sf_comm = sf_comm or SFComm(data_path)
        if username and password:
            self.initialize(username, password)

    def initialize(self, username, password):
        debug("Initializing")
        # retrieve the saved projects, if any
        projects = self.load_projects()
        
        # get the current projects on sourceforge
        if NO_CONNECT_DEBUG: sf_projects = projects
        else: sf_projects = self.sf_comm.login(username, password, MY_PROJECTS_URL)

        # get the projects that are not saved
        missing_projects = sf_projects - projects

        # for each of the missing_projects get the
        # packages then add it to the project set
        for project in missing_projects:
            mainMessageQueue.put("Fetching packages for: %s" % project.getProjectName())
            packages = self.sf_comm.get_packages(project.getGroupId())
            project.setPackages(packages)
            projects.add(project)

        self.projects = projects
        if missing_projects:
            self.save_projects()
        return self.projects


    def __get_saved_dict(self, parts):
        d = {}
        for p in parts:
            key, val = p.split("=")
            key = key.strip()
            val = val.strip().replace('"', '')
            d[key] = val
        return d


    def load_projects(self):
        debug("Loading projects from %s" % self.projects_path)
        projects = set()
        try:
            fp = open(self.projects_path, "r")
            project = None
            for line in fp:
                parts = line.strip().split(":")
                if parts[0] == 'PROJECT':
                    pdict = self.__get_saved_dict(parts[1:])
                    project = ProjectVO(pdict['projectname'],
                                        pdict['unixname'],
                                        pdict['groupid'])
                    packages = set()
                elif parts[0] == 'PACKAGE':
                    pdict = self.__get_saved_dict(parts[1:])
                    package = PackageVO(pdict['packagename'],
                                        pdict['packageid'],
                                        pdict['status'],
                                        pdict['fullaccess'])
                    packages.add(package)
                elif parts[0] == '/PROJECT':
                    project.setPackages(packages)
                    projects.add(project)
                    
            fp.close()
        except Exception, e:
            error(e)
        debug("Loaded %d projects", len(projects))
        return projects


    def save_projects(self, projects=None):
        debug("Saving projects to %s", self.projects_path)
        if not projects: projects = self.projects
        try:
            fp = open(self.projects_path, "w")
            for project in projects:
                #print project
                fp.write('PROJECT: projectname="%s": unixname="%s": groupid="%s"\n' % (project.getProjectName(), project.getUnixName(), project.getGroupId()))
                packages = project.getPackages()
                for package in packages:
                    fp.write('  PACKAGE: packagename="%s": packageid="%s": status="%s": fullaccess="%s"\n' % (package.getPackageName(), package.getPackageId(), package.getPackageStatus(), package.getFullAccess()))
                fp.write("/PROJECT\n")
            fp.close()
        except Exception, e:
            error(e)
            return

##    def save_projects_xml(self, projects=None):
##        if not projects: projects = self.projects
##        try:
##            fp = open(self.data_path, "w")
##            for project in projects:
##                print project
##                fp.write('<project projectname="%s" unixname="%s" groupid="%s">\n' % (project.getProjectName(), project.getUnixName(), project.getGroupId()))
##                packages = project.getPackages()
##                for package in packages:
##                    fp.write('\t<package packagename="%s" packageid="%s">\n' % (package.getPackageName(), package.getPackageId()))
##                    fp.write("\t</package>\n")
##                fp.write("</project>\n")
##            fp.close()
##        except Exception, e:
##            print e
##            return




if __name__ == '__main__':
    pass


