/* error.c - Error-management and messaging routines.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __ERROR_H__
#define __ERROR_H__

#include <stdarg.h>
#include <errno.h>		/* for errno below */
#include "common.h"

extern void (*program_termination_hook)(void);

void internal_error(const char *msg, ...) __attribute__ ((noreturn));
void die(const char *msg, ...) __attribute__ ((noreturn));
void die_errno(const char *msg, ...) __attribute__ ((noreturn));
void warn(const char *msg, ...);
void warn_errno(const char *msg, ...);
void set_message_header(const char *msg, ...);
void restore_message_header(void);
extern inline void die_memory(void) __attribute__ ((noreturn));
extern inline void *check_memory(void *mem);

void set_error(const char *msg, ...);
const char *get_error(void);
char *remove_error(void);
void die_error(void) __attribute__ ((noreturn));

void free_error(void);

/**
 * @note This function is also defined in error.c
 */
extern inline void
die_memory(void)
{
	errno = ENOMEM;
	die_errno(NULL);
}

/**
 * @note This function is also defined in error.c
 */
extern inline void *
check_memory(void *mem)
{
	if (mem == NULL)
		die_memory();
	return mem;
}

#endif
