//
// Metal.hpp
//
// Autogenerated on December 09, 2021.
//
// Copyright 2020-2021 Apple Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

#pragma once

#define _NS_WEAK_IMPORT __attribute__((weak_import))
#define _NS_EXPORT __attribute__((visibility("default")))
#define _NS_EXTERN extern "C" _NS_EXPORT
#define _NS_INLINE inline __attribute__((always_inline))
#define _NS_PACKED __attribute__((packed))

#define _NS_CONST(type, name) _NS_EXTERN type const name;
#define _NS_ENUM(type, name) enum name : type
#define _NS_OPTIONS(type, name) \
    using name = type;          \
    enum : name

#define _NS_CAST_TO_UINT(value) static_cast<NS::UInteger>(value)
#define _NS_VALIDATE_SIZE(ns, name) static_assert(sizeof(ns::name) == sizeof(ns##name), "size mismatch " #ns "::" #name)
#define _NS_VALIDATE_ENUM(ns, name) static_assert(_NS_CAST_TO_UINT(ns::name) == _NS_CAST_TO_UINT(ns##name), "value mismatch " #ns "::" #name)

#include <objc/runtime.h>

#define _NS_PRIVATE_CLS(symbol) (Private::Class::s_k##symbol)
#define _NS_PRIVATE_SEL(accessor) (Private::Selector::s_k##accessor)

#if defined(NS_PRIVATE_IMPLEMENTATION)

#define _NS_PRIVATE_VISIBILITY __attribute__((visibility("default")))
#define _NS_PRIVATE_IMPORT __attribute__((weak_import))

#if __OBJC__
#define _NS_PRIVATE_OBJC_LOOKUP_CLASS(symbol) ((__bridge void*)objc_lookUpClass(#symbol))
#else
#define _NS_PRIVATE_OBJC_LOOKUP_CLASS(symbol) objc_lookUpClass(#symbol)
#endif // __OBJC__

#define _NS_PRIVATE_DEF_CLS(symbol) void* s_k##symbol _NS_PRIVATE_VISIBILITY = _NS_PRIVATE_OBJC_LOOKUP_CLASS(symbol);
#define _NS_PRIVATE_DEF_PRO(symbol)
#define _NS_PRIVATE_DEF_SEL(accessor, symbol) SEL s_k##accessor _NS_PRIVATE_VISIBILITY = sel_registerName(symbol);
#define _NS_PRIVATE_DEF_CONST(type, symbol)              \
    _NS_EXTERN type const NS##symbol _NS_PRIVATE_IMPORT; \
    type const                       NS::symbol = (nullptr != &NS##symbol) ? NS##symbol : nullptr;

#else

#define _NS_PRIVATE_DEF_CLS(symbol) extern void* s_k##symbol;
#define _NS_PRIVATE_DEF_PRO(symbol)
#define _NS_PRIVATE_DEF_SEL(accessor, symbol) extern SEL s_k##accessor;
#define _NS_PRIVATE_DEF_CONST(type, symbol)

#endif // NS_PRIVATE_IMPLEMENTATION

namespace NS
{
namespace Private
{
    namespace Class
    {

        _NS_PRIVATE_DEF_CLS(NSArray);
        _NS_PRIVATE_DEF_CLS(NSAutoreleasePool);
        _NS_PRIVATE_DEF_CLS(NSBundle);
        _NS_PRIVATE_DEF_CLS(NSCondition);
        _NS_PRIVATE_DEF_CLS(NSDate);
        _NS_PRIVATE_DEF_CLS(NSDictionary);
        _NS_PRIVATE_DEF_CLS(NSError);
        _NS_PRIVATE_DEF_CLS(NSNumber);
        _NS_PRIVATE_DEF_CLS(NSObject);
        _NS_PRIVATE_DEF_CLS(NSProcessInfo);
        _NS_PRIVATE_DEF_CLS(NSString);
        _NS_PRIVATE_DEF_CLS(NSURL);
        _NS_PRIVATE_DEF_CLS(NSValue);

    } // Class
} // Private
} // MTL

namespace NS
{
namespace Private
{
    namespace Protocol
    {

    } // Protocol
} // Private
} // NS

namespace NS
{
namespace Private
{
    namespace Selector
    {

        _NS_PRIVATE_DEF_SEL(addObject_,
            "addObject:");
        _NS_PRIVATE_DEF_SEL(activeProcessorCount,
            "activeProcessorCount");
        _NS_PRIVATE_DEF_SEL(allBundles,
            "allBundles");
        _NS_PRIVATE_DEF_SEL(allFrameworks,
            "allFrameworks");
        _NS_PRIVATE_DEF_SEL(allObjects,
            "allObjects");
        _NS_PRIVATE_DEF_SEL(alloc,
            "alloc");
        _NS_PRIVATE_DEF_SEL(appStoreReceiptURL,
            "appStoreReceiptURL");
        _NS_PRIVATE_DEF_SEL(arguments,
            "arguments");
        _NS_PRIVATE_DEF_SEL(array,
            "array");
        _NS_PRIVATE_DEF_SEL(arrayWithObject_,
            "arrayWithObject:");
        _NS_PRIVATE_DEF_SEL(arrayWithObjects_count_,
            "arrayWithObjects:count:");
        _NS_PRIVATE_DEF_SEL(automaticTerminationSupportEnabled,
            "automaticTerminationSupportEnabled");
        _NS_PRIVATE_DEF_SEL(autorelease,
            "autorelease");
        _NS_PRIVATE_DEF_SEL(beginActivityWithOptions_reason_,
            "beginActivityWithOptions:reason:");
        _NS_PRIVATE_DEF_SEL(boolValue,
            "boolValue");
        _NS_PRIVATE_DEF_SEL(broadcast,
            "broadcast");
        _NS_PRIVATE_DEF_SEL(builtInPlugInsPath,
            "builtInPlugInsPath");
        _NS_PRIVATE_DEF_SEL(builtInPlugInsURL,
            "builtInPlugInsURL");
        _NS_PRIVATE_DEF_SEL(bundleIdentifier,
            "bundleIdentifier");
        _NS_PRIVATE_DEF_SEL(bundlePath,
            "bundlePath");
        _NS_PRIVATE_DEF_SEL(bundleURL,
            "bundleURL");
        _NS_PRIVATE_DEF_SEL(bundleWithPath_,
            "bundleWithPath:");
        _NS_PRIVATE_DEF_SEL(bundleWithURL_,
            "bundleWithURL:");
        _NS_PRIVATE_DEF_SEL(characterAtIndex_,
            "characterAtIndex:");
        _NS_PRIVATE_DEF_SEL(charValue,
            "charValue");
        _NS_PRIVATE_DEF_SEL(countByEnumeratingWithState_objects_count_,
            "countByEnumeratingWithState:objects:count:");
        _NS_PRIVATE_DEF_SEL(cStringUsingEncoding_,
            "cStringUsingEncoding:");
        _NS_PRIVATE_DEF_SEL(code,
            "code");
        _NS_PRIVATE_DEF_SEL(compare_,
            "compare:");
        _NS_PRIVATE_DEF_SEL(copy,
            "copy");
        _NS_PRIVATE_DEF_SEL(count,
            "count");
        _NS_PRIVATE_DEF_SEL(dateWithTimeIntervalSinceNow_,
            "dateWithTimeIntervalSinceNow:");
        _NS_PRIVATE_DEF_SEL(descriptionWithLocale_,
            "descriptionWithLocale:");
        _NS_PRIVATE_DEF_SEL(disableAutomaticTermination_,
            "disableAutomaticTermination:");
        _NS_PRIVATE_DEF_SEL(disableSuddenTermination,
            "disableSuddenTermination");
        _NS_PRIVATE_DEF_SEL(debugDescription,
            "debugDescription");
        _NS_PRIVATE_DEF_SEL(description,
            "description");
        _NS_PRIVATE_DEF_SEL(dictionary,
            "dictionary");
        _NS_PRIVATE_DEF_SEL(dictionaryWithObject_forKey_,
            "dictionaryWithObject:forKey:");
        _NS_PRIVATE_DEF_SEL(dictionaryWithObjects_forKeys_count_,
            "dictionaryWithObjects:forKeys:count:");
        _NS_PRIVATE_DEF_SEL(domain,
            "domain");
        _NS_PRIVATE_DEF_SEL(doubleValue,
            "doubleValue");
        _NS_PRIVATE_DEF_SEL(drain,
            "drain");
        _NS_PRIVATE_DEF_SEL(enableAutomaticTermination_,
            "enableAutomaticTermination:");
        _NS_PRIVATE_DEF_SEL(enableSuddenTermination,
            "enableSuddenTermination");
        _NS_PRIVATE_DEF_SEL(endActivity_,
            "endActivity:");
        _NS_PRIVATE_DEF_SEL(environment,
            "environment");
        _NS_PRIVATE_DEF_SEL(errorWithDomain_code_userInfo_,
            "errorWithDomain:code:userInfo:");
        _NS_PRIVATE_DEF_SEL(executablePath,
            "executablePath");
        _NS_PRIVATE_DEF_SEL(executableURL,
            "executableURL");
        _NS_PRIVATE_DEF_SEL(fileSystemRepresentation,
            "fileSystemRepresentation");
        _NS_PRIVATE_DEF_SEL(fileURLWithPath_,
            "fileURLWithPath:");
        _NS_PRIVATE_DEF_SEL(floatValue,
            "floatValue");
        _NS_PRIVATE_DEF_SEL(fullUserName,
            "fullUserName");
        _NS_PRIVATE_DEF_SEL(getValue_size_,
            "getValue:size:");
        _NS_PRIVATE_DEF_SEL(globallyUniqueString,
            "globallyUniqueString");
        _NS_PRIVATE_DEF_SEL(hash,
            "hash");
        _NS_PRIVATE_DEF_SEL(hostName,
            "hostName");
        _NS_PRIVATE_DEF_SEL(infoDictionary,
            "infoDictionary");
        _NS_PRIVATE_DEF_SEL(init,
            "init");
        _NS_PRIVATE_DEF_SEL(initFileURLWithPath_,
            "initFileURLWithPath:");
        _NS_PRIVATE_DEF_SEL(initWithBool_,
            "initWithBool:");
        _NS_PRIVATE_DEF_SEL(initWithBytes_objCType_,
            "initWithBytes:objCType:");
        _NS_PRIVATE_DEF_SEL(initWithBytesNoCopy_length_encoding_freeWhenDone_,
            "initWithBytesNoCopy:length:encoding:freeWhenDone:");
        _NS_PRIVATE_DEF_SEL(initWithChar_,
            "initWithChar:");
        _NS_PRIVATE_DEF_SEL(initWithCoder_,
            "initWithCoder:");
        _NS_PRIVATE_DEF_SEL(initWithCString_encoding_,
            "initWithCString:encoding:");
        _NS_PRIVATE_DEF_SEL(initWithDomain_code_userInfo_,
            "initWithDomain:code:userInfo:");
        _NS_PRIVATE_DEF_SEL(initWithDouble_,
            "initWithDouble:");
        _NS_PRIVATE_DEF_SEL(initWithFloat_,
            "initWithFloat:");
        _NS_PRIVATE_DEF_SEL(initWithInt_,
            "initWithInt:");
        _NS_PRIVATE_DEF_SEL(initWithLong_,
            "initWithLong:");
        _NS_PRIVATE_DEF_SEL(initWithLongLong_,
            "initWithLongLong:");
        _NS_PRIVATE_DEF_SEL(initWithObjects_count_,
            "initWithObjects:count:");
        _NS_PRIVATE_DEF_SEL(initWithObjects_forKeys_count_,
            "initWithObjects:forKeys:count:");
        _NS_PRIVATE_DEF_SEL(initWithPath_,
            "initWithPath:");
        _NS_PRIVATE_DEF_SEL(initWithShort_,
            "initWithShort:");
        _NS_PRIVATE_DEF_SEL(initWithString_,
            "initWithString:");
        _NS_PRIVATE_DEF_SEL(initWithUnsignedChar_,
            "initWithUnsignedChar:");
        _NS_PRIVATE_DEF_SEL(initWithUnsignedInt_,
            "initWithUnsignedInt:");
        _NS_PRIVATE_DEF_SEL(initWithUnsignedLong_,
            "initWithUnsignedLong:");
        _NS_PRIVATE_DEF_SEL(initWithUnsignedLongLong_,
            "initWithUnsignedLongLong:");
        _NS_PRIVATE_DEF_SEL(initWithUnsignedShort_,
            "initWithUnsignedShort:");
        _NS_PRIVATE_DEF_SEL(initWithURL_,
            "initWithURL:");
        _NS_PRIVATE_DEF_SEL(integerValue,
            "integerValue");
        _NS_PRIVATE_DEF_SEL(intValue,
            "intValue");
        _NS_PRIVATE_DEF_SEL(isEqual_,
            "isEqual:");
        _NS_PRIVATE_DEF_SEL(isEqualToNumber_,
            "isEqualToNumber:");
        _NS_PRIVATE_DEF_SEL(isEqualToString_,
            "isEqualToString:");
        _NS_PRIVATE_DEF_SEL(isEqualToValue_,
            "isEqualToValue:");
        _NS_PRIVATE_DEF_SEL(isiOSAppOnMac,
            "isiOSAppOnMac");
        _NS_PRIVATE_DEF_SEL(isLoaded,
            "isLoaded");
        _NS_PRIVATE_DEF_SEL(isLowPowerModeEnabled,
            "isLowPowerModeEnabled");
        _NS_PRIVATE_DEF_SEL(isMacCatalystApp,
            "isMacCatalystApp");
        _NS_PRIVATE_DEF_SEL(isOperatingSystemAtLeastVersion_,
            "isOperatingSystemAtLeastVersion:");
        _NS_PRIVATE_DEF_SEL(keyEnumerator,
            "keyEnumerator");
        _NS_PRIVATE_DEF_SEL(length,
            "length");
        _NS_PRIVATE_DEF_SEL(lengthOfBytesUsingEncoding_,
            "lengthOfBytesUsingEncoding:");
        _NS_PRIVATE_DEF_SEL(load,
            "load");
        _NS_PRIVATE_DEF_SEL(loadAndReturnError_,
            "loadAndReturnError:");
        _NS_PRIVATE_DEF_SEL(localizedDescription,
            "localizedDescription");
        _NS_PRIVATE_DEF_SEL(localizedFailureReason,
            "localizedFailureReason");
        _NS_PRIVATE_DEF_SEL(localizedInfoDictionary,
            "localizedInfoDictionary");
        _NS_PRIVATE_DEF_SEL(localizedRecoveryOptions,
            "localizedRecoveryOptions");
        _NS_PRIVATE_DEF_SEL(localizedRecoverySuggestion,
            "localizedRecoverySuggestion");
        _NS_PRIVATE_DEF_SEL(localizedStringForKey_value_table_,
            "localizedStringForKey:value:table:");
        _NS_PRIVATE_DEF_SEL(lock,
            "lock");
        _NS_PRIVATE_DEF_SEL(longValue,
            "longValue");
        _NS_PRIVATE_DEF_SEL(longLongValue,
            "longLongValue");
        _NS_PRIVATE_DEF_SEL(mainBundle,
            "mainBundle");
        _NS_PRIVATE_DEF_SEL(maximumLengthOfBytesUsingEncoding_,
            "maximumLengthOfBytesUsingEncoding:");
        _NS_PRIVATE_DEF_SEL(methodSignatureForSelector_,
            "methodSignatureForSelector:");
        _NS_PRIVATE_DEF_SEL(mutableBytes,
            "mutableBytes");
        _NS_PRIVATE_DEF_SEL(name,
            "name");
        _NS_PRIVATE_DEF_SEL(nextObject,
            "nextObject");
        _NS_PRIVATE_DEF_SEL(numberWithBool_,
            "numberWithBool:");
        _NS_PRIVATE_DEF_SEL(numberWithChar_,
            "numberWithChar:");
        _NS_PRIVATE_DEF_SEL(numberWithDouble_,
            "numberWithDouble:");
        _NS_PRIVATE_DEF_SEL(numberWithFloat_,
            "numberWithFloat:");
        _NS_PRIVATE_DEF_SEL(numberWithInt_,
            "numberWithInt:");
        _NS_PRIVATE_DEF_SEL(numberWithLong_,
            "numberWithLong:");
        _NS_PRIVATE_DEF_SEL(numberWithLongLong_,
            "numberWithLongLong:");
        _NS_PRIVATE_DEF_SEL(numberWithShort_,
            "numberWithShort:");
        _NS_PRIVATE_DEF_SEL(numberWithUnsignedChar_,
            "numberWithUnsignedChar:");
        _NS_PRIVATE_DEF_SEL(numberWithUnsignedInt_,
            "numberWithUnsignedInt:");
        _NS_PRIVATE_DEF_SEL(numberWithUnsignedLong_,
            "numberWithUnsignedLong:");
        _NS_PRIVATE_DEF_SEL(numberWithUnsignedLongLong_,
            "numberWithUnsignedLongLong:");
        _NS_PRIVATE_DEF_SEL(numberWithUnsignedShort_,
            "numberWithUnsignedShort:");
        _NS_PRIVATE_DEF_SEL(objCType,
            "objCType");
        _NS_PRIVATE_DEF_SEL(object,
            "object");
        _NS_PRIVATE_DEF_SEL(objectAtIndex_,
            "objectAtIndex:");
        _NS_PRIVATE_DEF_SEL(objectForInfoDictionaryKey_,
            "objectForInfoDictionaryKey:");
        _NS_PRIVATE_DEF_SEL(objectForKey_,
            "objectForKey:");
        _NS_PRIVATE_DEF_SEL(operatingSystem,
            "operatingSystem");
        _NS_PRIVATE_DEF_SEL(operatingSystemVersion,
            "operatingSystemVersion");
        _NS_PRIVATE_DEF_SEL(operatingSystemVersionString,
            "operatingSystemVersionString");
        _NS_PRIVATE_DEF_SEL(pathForAuxiliaryExecutable_,
            "pathForAuxiliaryExecutable:");
        _NS_PRIVATE_DEF_SEL(performActivityWithOptions_reason_usingBlock_,
            "performActivityWithOptions:reason:usingBlock:");
        _NS_PRIVATE_DEF_SEL(performExpiringActivityWithReason_usingBlock_,
            "performExpiringActivityWithReason:usingBlock:");
        _NS_PRIVATE_DEF_SEL(physicalMemory,
            "physicalMemory");
        _NS_PRIVATE_DEF_SEL(pointerValue,
            "pointerValue");
        _NS_PRIVATE_DEF_SEL(preflightAndReturnError_,
            "preflightAndReturnError:");
        _NS_PRIVATE_DEF_SEL(privateFrameworksPath,
            "privateFrameworksPath");
        _NS_PRIVATE_DEF_SEL(privateFrameworksURL,
            "privateFrameworksURL");
        _NS_PRIVATE_DEF_SEL(processIdentifier,
            "processIdentifier");
        _NS_PRIVATE_DEF_SEL(processInfo,
            "processInfo");
        _NS_PRIVATE_DEF_SEL(processName,
            "processName");
        _NS_PRIVATE_DEF_SEL(processorCount,
            "processorCount");
        _NS_PRIVATE_DEF_SEL(rangeOfString_options_,
            "rangeOfString:options:");
        _NS_PRIVATE_DEF_SEL(release,
            "release");
        _NS_PRIVATE_DEF_SEL(resourcePath,
            "resourcePath");
        _NS_PRIVATE_DEF_SEL(resourceURL,
            "resourceURL");
        _NS_PRIVATE_DEF_SEL(respondsToSelector_,
            "respondsToSelector:");
        _NS_PRIVATE_DEF_SEL(retain,
            "retain");
        _NS_PRIVATE_DEF_SEL(retainCount,
            "retainCount");
        _NS_PRIVATE_DEF_SEL(setAutomaticTerminationSupportEnabled_,
            "setAutomaticTerminationSupportEnabled:");
        _NS_PRIVATE_DEF_SEL(setProcessName_,
            "setProcessName:");
        _NS_PRIVATE_DEF_SEL(sharedFrameworksPath,
            "sharedFrameworksPath");
        _NS_PRIVATE_DEF_SEL(sharedFrameworksURL,
            "sharedFrameworksURL");
        _NS_PRIVATE_DEF_SEL(sharedSupportPath,
            "sharedSupportPath");
        _NS_PRIVATE_DEF_SEL(sharedSupportURL,
            "sharedSupportURL");
        _NS_PRIVATE_DEF_SEL(shortValue,
            "shortValue");
        _NS_PRIVATE_DEF_SEL(showPools,
            "showPools");
        _NS_PRIVATE_DEF_SEL(signal,
            "signal");
        _NS_PRIVATE_DEF_SEL(string,
            "string");
        _NS_PRIVATE_DEF_SEL(stringValue,
            "stringValue");
        _NS_PRIVATE_DEF_SEL(stringWithString_,
            "stringWithString:");
        _NS_PRIVATE_DEF_SEL(stringWithCString_encoding_,
            "stringWithCString:encoding:");
        _NS_PRIVATE_DEF_SEL(stringByAppendingString_,
            "stringByAppendingString:");
        _NS_PRIVATE_DEF_SEL(systemUptime,
            "systemUptime");
        _NS_PRIVATE_DEF_SEL(thermalState,
            "thermalState");
        _NS_PRIVATE_DEF_SEL(unload,
            "unload");
        _NS_PRIVATE_DEF_SEL(unlock,
            "unlock");
        _NS_PRIVATE_DEF_SEL(unsignedCharValue,
            "unsignedCharValue");
        _NS_PRIVATE_DEF_SEL(unsignedIntegerValue,
            "unsignedIntegerValue");
        _NS_PRIVATE_DEF_SEL(unsignedIntValue,
            "unsignedIntValue");
        _NS_PRIVATE_DEF_SEL(unsignedLongValue,
            "unsignedLongValue");
        _NS_PRIVATE_DEF_SEL(unsignedLongLongValue,
            "unsignedLongLongValue");
        _NS_PRIVATE_DEF_SEL(unsignedShortValue,
            "unsignedShortValue");
        _NS_PRIVATE_DEF_SEL(URLForAuxiliaryExecutable_,
            "URLForAuxiliaryExecutable:");
        _NS_PRIVATE_DEF_SEL(userInfo,
            "userInfo");
        _NS_PRIVATE_DEF_SEL(userName,
            "userName");
        _NS_PRIVATE_DEF_SEL(UTF8String,
            "UTF8String");
        _NS_PRIVATE_DEF_SEL(valueWithBytes_objCType_,
            "valueWithBytes:objCType:");
        _NS_PRIVATE_DEF_SEL(valueWithPointer_,
            "valueWithPointer:");
        _NS_PRIVATE_DEF_SEL(wait,
            "wait");
        _NS_PRIVATE_DEF_SEL(waitUntilDate_,
            "waitUntilDate:");
    } // Class
} // Private
} // MTL

#include <CoreFoundation/CoreFoundation.h>
#include <cstdint>

namespace NS
{
using TimeInterval = double;

using Integer = std::int64_t;
using UInteger = std::uint64_t;

const Integer  IntegerMax = INTPTR_MAX;
const Integer  IntegerMin = INTPTR_MIN;
const UInteger UIntegerMax = UINTPTR_MAX;

struct OperatingSystemVersion
{
    Integer majorVersion;
    Integer minorVersion;
    Integer patchVersion;
} _NS_PACKED;
}

#include <objc/message.h>
#include <objc/runtime.h>

#include <type_traits>

namespace NS
{
template <class _Class, class _Base = class Object>
class Referencing : public _Base
{
public:
    _Class*  retain();
    void     release();

    _Class*  autorelease();

    UInteger retainCount() const;
};

template <class _Class, class _Base = class Object>
class Copying : public Referencing<_Class, _Base>
{
public:
    _Class* copy() const;
};

class Object : public Referencing<Object, objc_object>
{
public:
    UInteger      hash() const;
    bool          isEqual(const Object* pObject) const;

    class String* description() const;
    class String* debugDescription() const;

protected:
    friend class Referencing<Object, objc_object>;

    template <class _Class>
    static _Class* alloc(const char* pClassName);
    template <class _Class>
    static _Class* alloc(const void* pClass);
    template <class _Class>
    _Class* init();

    template <class _Dst>
    static _Dst                   bridgingCast(const void* pObj);
    static class MethodSignature* methodSignatureForSelector(const void* pObj, SEL selector);
    static bool                   respondsToSelector(const void* pObj, SEL selector);
    template <typename _Type>
    static constexpr bool doesRequireMsgSendStret();
    template <typename _Ret, typename... _Args>
    static _Ret sendMessage(const void* pObj, SEL selector, _Args... args);
    template <typename _Ret, typename... _Args>
    static _Ret sendMessageSafe(const void* pObj, SEL selector, _Args... args);

private:
    Object() = delete;
    Object(const Object&) = delete;
    ~Object() = delete;

    Object& operator=(const Object&) = delete;
};
}

template <class _Class, class _Base /* = Object */>
_NS_INLINE _Class* NS::Referencing<_Class, _Base>::retain()
{
    return Object::sendMessage<_Class*>(this, _NS_PRIVATE_SEL(retain));
}

template <class _Class, class _Base /* = Object */>
_NS_INLINE void NS::Referencing<_Class, _Base>::release()
{
    Object::sendMessage<void>(this, _NS_PRIVATE_SEL(release));
}

template <class _Class, class _Base /* = Object */>
_NS_INLINE _Class* NS::Referencing<_Class, _Base>::autorelease()
{
    return Object::sendMessage<_Class*>(this, _NS_PRIVATE_SEL(autorelease));
}

template <class _Class, class _Base /* = Object */>
_NS_INLINE NS::UInteger NS::Referencing<_Class, _Base>::retainCount() const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(retainCount));
}

template <class _Class, class _Base /* = Object */>
_NS_INLINE _Class* NS::Copying<_Class, _Base>::copy() const
{
    return Object::sendMessage<_Class*>(this, _NS_PRIVATE_SEL(copy));
}

template <class _Dst>
_NS_INLINE _Dst NS::Object::bridgingCast(const void* pObj)
{
#if __OBJC__
    return (__bridge _Dst)pObj;
#else
    return (_Dst)pObj;
#endif // __OBJC__
}

template <typename _Type>
_NS_INLINE constexpr bool NS::Object::doesRequireMsgSendStret()
{
#if (defined(__i386__) || defined(__x86_64__))
    constexpr size_t kStructLimit = (sizeof(std::uintptr_t) << 1);

    return sizeof(_Type) > kStructLimit;
#elif defined(__arm64__)
    return false;
#elif defined(__arm__)
    constexpr size_t kStructLimit = sizeof(std::uintptr_t);

    return std::is_class(_Type) && (sizeof(_Type) > kStructLimit);
#else
#error "Unsupported architecture!"
#endif
}

template <>
_NS_INLINE constexpr bool NS::Object::doesRequireMsgSendStret<void>()
{
    return false;
}

template <typename _Ret, typename... _Args>
_NS_INLINE _Ret NS::Object::sendMessage(const void* pObj, SEL selector, _Args... args)
{
#if (defined(__i386__) || defined(__x86_64__))
    if constexpr (std::is_floating_point<_Ret>())
    {
        using SendMessageProcFpret = _Ret (*)(const void*, SEL, _Args...);

        const SendMessageProcFpret pProc = reinterpret_cast<SendMessageProcFpret>(&objc_msgSend_fpret);

        return (*pProc)(pObj, selector, args...);
    }
    else
#endif // ( defined( __i386__ )  || defined( __x86_64__ )  )
#if !defined(__arm64__)
        if constexpr (doesRequireMsgSendStret<_Ret>())
    {
        using SendMessageProcStret = void (*)(_Ret*, const void*, SEL, _Args...);

        const SendMessageProcStret pProc = reinterpret_cast<SendMessageProcStret>(&objc_msgSend_stret);
        _Ret                       ret;

        (*pProc)(&ret, pObj, selector, args...);

        return ret;
    }
    else
#endif // !defined( __arm64__ )
    {
        using SendMessageProc = _Ret (*)(const void*, SEL, _Args...);

        const SendMessageProc pProc = reinterpret_cast<SendMessageProc>(&objc_msgSend);

        return (*pProc)(pObj, selector, args...);
    }
}

_NS_INLINE NS::MethodSignature* NS::Object::methodSignatureForSelector(const void* pObj, SEL selector)
{
    return sendMessage<MethodSignature*>(pObj, _NS_PRIVATE_SEL(methodSignatureForSelector_), selector);
}

_NS_INLINE bool NS::Object::respondsToSelector(const void* pObj, SEL selector)
{
    return sendMessage<bool>(pObj, _NS_PRIVATE_SEL(respondsToSelector_), selector);
}

template <typename _Ret, typename... _Args>
_NS_INLINE _Ret NS::Object::sendMessageSafe(const void* pObj, SEL selector, _Args... args)
{
    if ((respondsToSelector(pObj, selector)) || (nullptr != methodSignatureForSelector(pObj, selector)))
    {
        return sendMessage<_Ret>(pObj, selector, args...);
    }

    if constexpr (!std::is_void<_Ret>::value)
    {
        return 0;
    }
}

template <class _Class>
_NS_INLINE _Class* NS::Object::alloc(const char* pClassName)
{
    return sendMessage<_Class*>(objc_lookUpClass(pClassName), _NS_PRIVATE_SEL(alloc));
}

template <class _Class>
_NS_INLINE _Class* NS::Object::alloc(const void* pClass)
{
    return sendMessage<_Class*>(pClass, _NS_PRIVATE_SEL(alloc));
}

template <class _Class>
_NS_INLINE _Class* NS::Object::init()
{
    return sendMessage<_Class*>(this, _NS_PRIVATE_SEL(init));
}

_NS_INLINE NS::UInteger NS::Object::hash() const
{
    return sendMessage<UInteger>(this, _NS_PRIVATE_SEL(hash));
}

_NS_INLINE bool NS::Object::isEqual(const Object* pObject) const
{
    return sendMessage<bool>(this, _NS_PRIVATE_SEL(isEqual_), pObject);
}

_NS_INLINE NS::String* NS::Object::description() const
{
    return sendMessage<String*>(this, _NS_PRIVATE_SEL(description));
}

_NS_INLINE NS::String* NS::Object::debugDescription() const
{
    return sendMessageSafe<String*>(this, _NS_PRIVATE_SEL(debugDescription));
}

namespace NS
{
class Array : public Copying<Array>
{
public:
    static Array* array();
    static Array* array(const Object* pObject);
    static Array* array(const Object* const* pObjects, UInteger count);

    static Array* alloc();

    Array*        init();
    Array*        init(const Object* const* pObjects, UInteger count);
    Array*        init(const class Coder* pCoder);

    template <class _Object = Object>
    _Object* object(UInteger index) const;
    UInteger count() const;
};
}

_NS_INLINE NS::Array* NS::Array::array()
{
    return Object::sendMessage<Array*>(_NS_PRIVATE_CLS(NSArray), _NS_PRIVATE_SEL(array));
}

_NS_INLINE NS::Array* NS::Array::array(const Object* pObject)
{
    return Object::sendMessage<Array*>(_NS_PRIVATE_CLS(NSArray), _NS_PRIVATE_SEL(arrayWithObject_), pObject);
}

_NS_INLINE NS::Array* NS::Array::array(const Object* const* pObjects, UInteger count)
{
    return Object::sendMessage<Array*>(_NS_PRIVATE_CLS(NSArray), _NS_PRIVATE_SEL(arrayWithObjects_count_), pObjects, count);
}

_NS_INLINE NS::Array* NS::Array::alloc()
{
    return NS::Object::alloc<Array>(_NS_PRIVATE_CLS(NSArray));
}

_NS_INLINE NS::Array* NS::Array::init()
{
    return NS::Object::init<Array>();
}

_NS_INLINE NS::Array* NS::Array::init(const Object* const* pObjects, UInteger count)
{
    return Object::sendMessage<Array*>(this, _NS_PRIVATE_SEL(initWithObjects_count_), pObjects, count);
}

_NS_INLINE NS::Array* NS::Array::init(const class Coder* pCoder)
{
    return Object::sendMessage<Array*>(this, _NS_PRIVATE_SEL(initWithCoder_), pCoder);
}

_NS_INLINE NS::UInteger NS::Array::count() const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(count));
}

template <class _Object>
_NS_INLINE _Object* NS::Array::object(UInteger index) const
{
    return Object::sendMessage<_Object*>(this, _NS_PRIVATE_SEL(objectAtIndex_), index);
}

namespace NS
{
class AutoreleasePool : public Object
{
public:
    static AutoreleasePool* alloc();
    AutoreleasePool*        init();

    void                    drain();

    void                    addObject(Object* pObject);

    static void             showPools();
};
}

_NS_INLINE NS::AutoreleasePool* NS::AutoreleasePool::alloc()
{
    return NS::Object::alloc<AutoreleasePool>(_NS_PRIVATE_CLS(NSAutoreleasePool));
}

_NS_INLINE NS::AutoreleasePool* NS::AutoreleasePool::init()
{
    return NS::Object::init<AutoreleasePool>();
}

_NS_INLINE void NS::AutoreleasePool::drain()
{
    Object::sendMessage<void>(this, _NS_PRIVATE_SEL(drain));
}

_NS_INLINE void NS::AutoreleasePool::addObject(Object* pObject)
{
    Object::sendMessage<void>(this, _NS_PRIVATE_SEL(addObject_), pObject);
}

_NS_INLINE void NS::AutoreleasePool::showPools()
{
    Object::sendMessage<void>(_NS_PRIVATE_CLS(NSAutoreleasePool), _NS_PRIVATE_SEL(showPools));
}

namespace NS
{
struct FastEnumerationState
{
    unsigned long  state;
    Object**       itemsPtr;
    unsigned long* mutationsPtr;
    unsigned long  extra[5];
} _NS_PACKED;

class FastEnumeration : public Referencing<FastEnumeration>
{
public:
    NS::UInteger countByEnumerating(FastEnumerationState* pState, Object** pBuffer, NS::UInteger len);
};

template <class _ObjectType>
class Enumerator : public Referencing<Enumerator<_ObjectType>, FastEnumeration>
{
public:
    _ObjectType* nextObject();
    class Array* allObjects();
};
}

_NS_INLINE NS::UInteger NS::FastEnumeration::countByEnumerating(FastEnumerationState* pState, Object** pBuffer, NS::UInteger len)
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(countByEnumeratingWithState_objects_count_), pState, pBuffer, len);
}

template <class _ObjectType>
_NS_INLINE _ObjectType* NS::Enumerator<_ObjectType>::nextObject()
{
    return Object::sendMessage<_ObjectType*>(this, _NS_PRIVATE_SEL(nextObject));
}

template <class _ObjectType>
_NS_INLINE NS::Array* NS::Enumerator<_ObjectType>::allObjects()
{
    return Object::sendMessage<Array*>(this, _NS_PRIVATE_SEL(allObjects));
}

namespace NS
{
class Dictionary : public NS::Copying<Dictionary>
{
public:
    static Dictionary* dictionary();
    static Dictionary* dictionary(const Object* pObject, const Object* pKey);
    static Dictionary* dictionary(const Object* const* pObjects, const Object* const* pKeys, UInteger count);

    static Dictionary* alloc();

    Dictionary*        init();
    Dictionary*        init(const Object* const* pObjects, const Object* const* pKeys, UInteger count);
    Dictionary*        init(const class Coder* pCoder);

    template <class _KeyType = Object>
    Enumerator<_KeyType>* keyEnumerator() const;

    template <class _Object = Object>
    _Object* object(const Object* pKey) const;
    UInteger count() const;
};
}

_NS_INLINE NS::Dictionary* NS::Dictionary::dictionary()
{
    return Object::sendMessage<Dictionary*>(_NS_PRIVATE_CLS(NSDictionary), _NS_PRIVATE_SEL(dictionary));
}

_NS_INLINE NS::Dictionary* NS::Dictionary::dictionary(const Object* pObject, const Object* pKey)
{
    return Object::sendMessage<Dictionary*>(_NS_PRIVATE_CLS(NSDictionary), _NS_PRIVATE_SEL(dictionaryWithObject_forKey_), pObject, pKey);
}

_NS_INLINE NS::Dictionary* NS::Dictionary::dictionary(const Object* const* pObjects, const Object* const* pKeys, UInteger count)
{
    return Object::sendMessage<Dictionary*>(_NS_PRIVATE_CLS(NSDictionary), _NS_PRIVATE_SEL(dictionaryWithObjects_forKeys_count_),
        pObjects, pKeys, count);
}

_NS_INLINE NS::Dictionary* NS::Dictionary::alloc()
{
    return NS::Object::alloc<Dictionary>(_NS_PRIVATE_CLS(NSDictionary));
}

_NS_INLINE NS::Dictionary* NS::Dictionary::init()
{
    return NS::Object::init<Dictionary>();
}

_NS_INLINE NS::Dictionary* NS::Dictionary::init(const Object* const* pObjects, const Object* const* pKeys, UInteger count)
{
    return Object::sendMessage<Dictionary*>(this, _NS_PRIVATE_SEL(initWithObjects_forKeys_count_), pObjects, pKeys, count);
}

_NS_INLINE NS::Dictionary* NS::Dictionary::init(const class Coder* pCoder)
{
    return Object::sendMessage<Dictionary*>(this, _NS_PRIVATE_SEL(initWithCoder_), pCoder);
}

template <class _KeyType>
_NS_INLINE NS::Enumerator<_KeyType>* NS::Dictionary::keyEnumerator() const
{
    return Object::sendMessage<Enumerator<_KeyType>*>(this, _NS_PRIVATE_SEL(keyEnumerator));
}

template <class _Object>
_NS_INLINE _Object* NS::Dictionary::object(const Object* pKey) const
{
    return Object::sendMessage<_Object*>(this, _NS_PRIVATE_SEL(objectForKey_), pKey);
}

_NS_INLINE NS::UInteger NS::Dictionary::count() const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(count));
}

namespace NS
{
struct Range
{
    static Range Make(UInteger loc, UInteger len);

    Range(UInteger loc, UInteger len);

    bool     Equal(const Range& range) const;
    bool     LocationInRange(UInteger loc) const;
    UInteger Max() const;

    UInteger location;
    UInteger length;
} _NS_PACKED;
}

_NS_INLINE NS::Range::Range(UInteger loc, UInteger len)
    : location(loc)
    , length(len)
{
}

_NS_INLINE NS::Range NS::Range::Make(UInteger loc, UInteger len)
{
    return Range(loc, len);
}

_NS_INLINE bool NS::Range::Equal(const Range& range) const
{
    return (location == range.location) && (length == range.length);
}

_NS_INLINE bool NS::Range::LocationInRange(UInteger loc) const
{
    return (!(loc < location)) && ((loc - location) < length);
}

_NS_INLINE NS::UInteger NS::Range::Max() const
{
    return location + length;
}

namespace NS
{
_NS_ENUM(NS::UInteger, StringEncoding) {
    ASCIIStringEncoding = 1,
    NEXTSTEPStringEncoding = 2,
    JapaneseEUCStringEncoding = 3,
    UTF8StringEncoding = 4,
    ISOLatin1StringEncoding = 5,
    SymbolStringEncoding = 6,
    NonLossyASCIIStringEncoding = 7,
    ShiftJISStringEncoding = 8,
    ISOLatin2StringEncoding = 9,
    UnicodeStringEncoding = 10,
    WindowsCP1251StringEncoding = 11,
    WindowsCP1252StringEncoding = 12,
    WindowsCP1253StringEncoding = 13,
    WindowsCP1254StringEncoding = 14,
    WindowsCP1250StringEncoding = 15,
    ISO2022JPStringEncoding = 21,
    MacOSRomanStringEncoding = 30,

    UTF16StringEncoding = UnicodeStringEncoding,

    UTF16BigEndianStringEncoding = 0x90000100,
    UTF16LittleEndianStringEncoding = 0x94000100,

    UTF32StringEncoding = 0x8c000100,
    UTF32BigEndianStringEncoding = 0x98000100,
    UTF32LittleEndianStringEncoding = 0x9c000100
};

_NS_OPTIONS(NS::UInteger, StringCompareOptions) {
    CaseInsensitiveSearch = 1,
    LiteralSearch = 2,
    BackwardsSearch = 4,
    AnchoredSearch = 8,
    NumericSearch = 64,
    DiacriticInsensitiveSearch = 128,
    WidthInsensitiveSearch = 256,
    ForcedOrderingSearch = 512,
    RegularExpressionSearch = 1024
};

using unichar = unsigned short;

class String : public Copying<String>
{
public:
    static String* string();
    static String* string(const String* pString);
    static String* string(const char* pString, StringEncoding encoding);

    static String* alloc();
    String*        init();
    String*        init(const String* pString);
    String*        init(const char* pString, StringEncoding encoding);
    String*        init(void* pBytes, UInteger len, StringEncoding encoding, bool freeBuffer);

    unichar        character(UInteger index) const;
    UInteger       length() const;

    const char*    cString(StringEncoding encoding) const;
    const char*    utf8String() const;
    UInteger       maximumLengthOfBytes(StringEncoding encoding) const;
    UInteger       lengthOfBytes(StringEncoding encoding) const;

    bool           isEqualToString(const String* pString) const;
    Range          rangeOfString(const String* pString, StringCompareOptions options) const;

    const char*    fileSystemRepresentation() const;

    String*        stringByAppendingString(const String* pString) const;

};

template< std::size_t _StringLen >
constexpr const String* MakeConstantString( const char ( &str )[_StringLen] )
{
    return reinterpret_cast< const String* >( __CFStringMakeConstantString( str ) );
}

}

_NS_INLINE NS::String* NS::String::string()
{
    return Object::sendMessage<String*>(_NS_PRIVATE_CLS(NSString), _NS_PRIVATE_SEL(string));
}

_NS_INLINE NS::String* NS::String::string(const String* pString)
{
    return Object::sendMessage<String*>(_NS_PRIVATE_CLS(NSString), _NS_PRIVATE_SEL(stringWithString_), pString);
}

_NS_INLINE NS::String* NS::String::string(const char* pString, StringEncoding encoding)
{
    return Object::sendMessage<String*>(_NS_PRIVATE_CLS(NSString), _NS_PRIVATE_SEL(stringWithCString_encoding_), pString, encoding);
}

_NS_INLINE NS::String* NS::String::alloc()
{
    return Object::alloc<String>(_NS_PRIVATE_CLS(NSString));
}

_NS_INLINE NS::String* NS::String::init()
{
    return Object::init<String>();
}

_NS_INLINE NS::String* NS::String::init(const String* pString)
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(initWithString_), pString);
}

_NS_INLINE NS::String* NS::String::init(const char* pString, StringEncoding encoding)
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(initWithCString_encoding_), pString, encoding);
}

_NS_INLINE NS::String* NS::String::init(void* pBytes, UInteger len, StringEncoding encoding, bool freeBuffer)
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(initWithBytesNoCopy_length_encoding_freeWhenDone_), pBytes, len, encoding, freeBuffer);
}

_NS_INLINE NS::unichar NS::String::character(UInteger index) const
{
    return Object::sendMessage<unichar>(this, _NS_PRIVATE_SEL(characterAtIndex_), index);
}

_NS_INLINE NS::UInteger NS::String::length() const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(length));
}

_NS_INLINE const char* NS::String::cString(StringEncoding encoding) const
{
    return Object::sendMessage<const char*>(this, _NS_PRIVATE_SEL(cStringUsingEncoding_), encoding);
}

_NS_INLINE const char* NS::String::utf8String() const
{
    return Object::sendMessage<const char*>(this, _NS_PRIVATE_SEL(UTF8String));
}

_NS_INLINE NS::UInteger NS::String::maximumLengthOfBytes(StringEncoding encoding) const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(maximumLengthOfBytesUsingEncoding_), encoding);
}

_NS_INLINE NS::UInteger NS::String::lengthOfBytes(StringEncoding encoding) const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(lengthOfBytesUsingEncoding_), encoding);
}

_NS_INLINE bool NS::String::isEqualToString(const NS::String* pString) const
{
    return Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(isEqualToString_), pString);
}

_NS_INLINE NS::Range NS::String::rangeOfString(const NS::String* pString, NS::StringCompareOptions options) const
{
    return Object::sendMessage<Range>(this, _NS_PRIVATE_SEL(rangeOfString_options_), pString, options);
}

_NS_INLINE const char* NS::String::fileSystemRepresentation() const
{
    return Object::sendMessage<const char*>(this, _NS_PRIVATE_SEL(fileSystemRepresentation));
}

_NS_INLINE NS::String* NS::String::stringByAppendingString(const String* pString) const
{
    return Object::sendMessage<NS::String*>(this, _NS_PRIVATE_SEL(stringByAppendingString_), pString);
}

namespace NS
{
using NotificationName = class String*;

class Notification : public NS::Referencing<Notification>
{
public:
    NS::String*     name() const;
    NS::Object*     object() const;
    NS::Dictionary* userInfo() const;
};
}

_NS_INLINE NS::String* NS::Notification::name() const
{
    return Object::sendMessage<NS::String*>(this, _NS_PRIVATE_SEL(name));
}

_NS_INLINE NS::Object* NS::Notification::object() const
{
    return Object::sendMessage<NS::Object*>(this, _NS_PRIVATE_SEL(object));
}

_NS_INLINE NS::Dictionary* NS::Notification::userInfo() const
{
    return Object::sendMessage<NS::Dictionary*>(this, _NS_PRIVATE_SEL(userInfo));
}

namespace NS
{
_NS_CONST(NotificationName, BundleDidLoadNotification);
_NS_CONST(NotificationName, BundleResourceRequestLowDiskSpaceNotification);

class String* LocalizedString(const String* pKey, const String*);
class String* LocalizedStringFromTable(const String* pKey, const String* pTbl, const String*);
class String* LocalizedStringFromTableInBundle(const String* pKey, const String* pTbl, const class Bundle* pBdle, const String*);
class String* LocalizedStringWithDefaultValue(const String* pKey, const String* pTbl, const class Bundle* pBdle, const String* pVal, const String*);

class Bundle : public Referencing<Bundle>
{
public:
    static Bundle*    mainBundle();

    static Bundle*    bundle(const class String* pPath);
    static Bundle*    bundle(const class URL* pURL);

    static Bundle*    alloc();

    Bundle*           init(const class String* pPath);
    Bundle*           init(const class URL* pURL);

    class Array*      allBundles() const;
    class Array*      allFrameworks() const;

    bool              load();
    bool              unload();

    bool              isLoaded() const;

    bool              preflightAndReturnError(class Error** pError) const;
    bool              loadAndReturnError(class Error** pError);

    class URL*        bundleURL() const;
    class URL*        resourceURL() const;
    class URL*        executableURL() const;
    class URL*        URLForAuxiliaryExecutable(const class String* pExecutableName) const;

    class URL*        privateFrameworksURL() const;
    class URL*        sharedFrameworksURL() const;
    class URL*        sharedSupportURL() const;
    class URL*        builtInPlugInsURL() const;
    class URL*        appStoreReceiptURL() const;

    class String*     bundlePath() const;
    class String*     resourcePath() const;
    class String*     executablePath() const;
    class String*     pathForAuxiliaryExecutable(const class String* pExecutableName) const;

    class String*     privateFrameworksPath() const;
    class String*     sharedFrameworksPath() const;
    class String*     sharedSupportPath() const;
    class String*     builtInPlugInsPath() const;

    class String*     bundleIdentifier() const;
    class Dictionary* infoDictionary() const;
    class Dictionary* localizedInfoDictionary() const;
    class Object*     objectForInfoDictionaryKey(const class String* pKey);

    class String*     localizedString(const class String* pKey, const class String* pValue = nullptr, const class String* pTableName = nullptr) const;
};
}

_NS_PRIVATE_DEF_CONST(NS::NotificationName, BundleDidLoadNotification);
_NS_PRIVATE_DEF_CONST(NS::NotificationName, BundleResourceRequestLowDiskSpaceNotification);

_NS_INLINE NS::String* NS::LocalizedString(const String* pKey, const String*)
{
    return Bundle::mainBundle()->localizedString(pKey, nullptr, nullptr);
}

_NS_INLINE NS::String* NS::LocalizedStringFromTable(const String* pKey, const String* pTbl, const String*)
{
    return Bundle::mainBundle()->localizedString(pKey, nullptr, pTbl);
}

_NS_INLINE NS::String* NS::LocalizedStringFromTableInBundle(const String* pKey, const String* pTbl, const Bundle* pBdl, const String*)
{
    return pBdl->localizedString(pKey, nullptr, pTbl);
}

_NS_INLINE NS::String* NS::LocalizedStringWithDefaultValue(const String* pKey, const String* pTbl, const Bundle* pBdl, const String* pVal, const String*)
{
    return pBdl->localizedString(pKey, pVal, pTbl);
}

_NS_INLINE NS::Bundle* NS::Bundle::mainBundle()
{
    return Object::sendMessage<Bundle*>(_NS_PRIVATE_CLS(NSBundle), _NS_PRIVATE_SEL(mainBundle));
}

_NS_INLINE NS::Bundle* NS::Bundle::bundle(const class String* pPath)
{
    return Object::sendMessage<Bundle*>(_NS_PRIVATE_CLS(NSBundle), _NS_PRIVATE_SEL(bundleWithPath_), pPath);
}

_NS_INLINE NS::Bundle* NS::Bundle::bundle(const class URL* pURL)
{
    return Object::sendMessage<Bundle*>(_NS_PRIVATE_CLS(NSBundle), _NS_PRIVATE_SEL(bundleWithURL_), pURL);
}

_NS_INLINE NS::Bundle* NS::Bundle::alloc()
{
    return Object::sendMessage<Bundle*>(_NS_PRIVATE_CLS(NSBundle), _NS_PRIVATE_SEL(alloc));
}

_NS_INLINE NS::Bundle* NS::Bundle::init(const String* pPath)
{
    return Object::sendMessage<Bundle*>(this, _NS_PRIVATE_SEL(initWithPath_), pPath);
}

_NS_INLINE NS::Bundle* NS::Bundle::init(const URL* pURL)
{
    return Object::sendMessage<Bundle*>(this, _NS_PRIVATE_SEL(initWithURL_), pURL);
}

_NS_INLINE NS::Array* NS::Bundle::allBundles() const
{
    return Object::sendMessage<Array*>(this, _NS_PRIVATE_SEL(allBundles));
}

_NS_INLINE NS::Array* NS::Bundle::allFrameworks() const
{
    return Object::sendMessage<Array*>(this, _NS_PRIVATE_SEL(allFrameworks));
}

_NS_INLINE bool NS::Bundle::load()
{
    return Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(load));
}

_NS_INLINE bool NS::Bundle::unload()
{
    return Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(unload));
}

_NS_INLINE bool NS::Bundle::isLoaded() const
{
    return Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(isLoaded));
}

_NS_INLINE bool NS::Bundle::preflightAndReturnError(Error** pError) const
{
    return Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(preflightAndReturnError_), pError);
}

_NS_INLINE bool NS::Bundle::loadAndReturnError(Error** pError)
{
    return Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(loadAndReturnError_), pError);
}

_NS_INLINE NS::URL* NS::Bundle::bundleURL() const
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(bundleURL));
}

_NS_INLINE NS::URL* NS::Bundle::resourceURL() const
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(resourceURL));
}

_NS_INLINE NS::URL* NS::Bundle::executableURL() const
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(executableURL));
}

_NS_INLINE NS::URL* NS::Bundle::URLForAuxiliaryExecutable(const String* pExecutableName) const
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(URLForAuxiliaryExecutable_), pExecutableName);
}

_NS_INLINE NS::URL* NS::Bundle::privateFrameworksURL() const
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(privateFrameworksURL));
}

_NS_INLINE NS::URL* NS::Bundle::sharedFrameworksURL() const
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(sharedFrameworksURL));
}

_NS_INLINE NS::URL* NS::Bundle::sharedSupportURL() const
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(sharedSupportURL));
}

_NS_INLINE NS::URL* NS::Bundle::builtInPlugInsURL() const
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(builtInPlugInsURL));
}

_NS_INLINE NS::URL* NS::Bundle::appStoreReceiptURL() const
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(appStoreReceiptURL));
}

_NS_INLINE NS::String* NS::Bundle::bundlePath() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(bundlePath));
}

_NS_INLINE NS::String* NS::Bundle::resourcePath() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(resourcePath));
}

_NS_INLINE NS::String* NS::Bundle::executablePath() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(executablePath));
}

_NS_INLINE NS::String* NS::Bundle::pathForAuxiliaryExecutable(const String* pExecutableName) const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(pathForAuxiliaryExecutable_), pExecutableName);
}

_NS_INLINE NS::String* NS::Bundle::privateFrameworksPath() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(privateFrameworksPath));
}

_NS_INLINE NS::String* NS::Bundle::sharedFrameworksPath() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(sharedFrameworksPath));
}

_NS_INLINE NS::String* NS::Bundle::sharedSupportPath() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(sharedSupportPath));
}

_NS_INLINE NS::String* NS::Bundle::builtInPlugInsPath() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(builtInPlugInsPath));
}

_NS_INLINE NS::String* NS::Bundle::bundleIdentifier() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(bundleIdentifier));
}

_NS_INLINE NS::Dictionary* NS::Bundle::infoDictionary() const
{
    return Object::sendMessage<Dictionary*>(this, _NS_PRIVATE_SEL(infoDictionary));
}

_NS_INLINE NS::Dictionary* NS::Bundle::localizedInfoDictionary() const
{
    return Object::sendMessage<Dictionary*>(this, _NS_PRIVATE_SEL(localizedInfoDictionary));
}

_NS_INLINE NS::Object* NS::Bundle::objectForInfoDictionaryKey(const String* pKey)
{
    return Object::sendMessage<Object*>(this, _NS_PRIVATE_SEL(objectForInfoDictionaryKey_), pKey);
}

_NS_INLINE NS::String* NS::Bundle::localizedString(const String* pKey, const String* pValue /* = nullptr */, const String* pTableName /* = nullptr */) const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(localizedStringForKey_value_table_), pKey, pValue, pTableName);
}

namespace NS
{
class Data : public Copying<Data>
{
public:
    void*    mutableBytes() const;
    UInteger length() const;
};
}

_NS_INLINE void* NS::Data::mutableBytes() const
{
    return Object::sendMessage<void*>(this, _NS_PRIVATE_SEL(mutableBytes));
}

_NS_INLINE NS::UInteger NS::Data::length() const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(length));
}

namespace NS
{

using TimeInterval = double;

class Date : public Copying<Date>
{
public:
    static Date* dateWithTimeIntervalSinceNow(TimeInterval secs);
};

} // NS

_NS_INLINE NS::Date* NS::Date::dateWithTimeIntervalSinceNow(NS::TimeInterval secs)
{
    return NS::Object::sendMessage<NS::Date*>(_NS_PRIVATE_CLS(NSDate), _NS_PRIVATE_SEL(dateWithTimeIntervalSinceNow_), secs);
}

//-------------------------------------------------------------------------------------------------------------------------------------------------------------

namespace NS
{
using ErrorDomain = class String*;

_NS_CONST(ErrorDomain, CocoaErrorDomain);
_NS_CONST(ErrorDomain, POSIXErrorDomain);
_NS_CONST(ErrorDomain, OSStatusErrorDomain);
_NS_CONST(ErrorDomain, MachErrorDomain);

using ErrorUserInfoKey = class String*;

_NS_CONST(ErrorUserInfoKey, UnderlyingErrorKey);
_NS_CONST(ErrorUserInfoKey, LocalizedDescriptionKey);
_NS_CONST(ErrorUserInfoKey, LocalizedFailureReasonErrorKey);
_NS_CONST(ErrorUserInfoKey, LocalizedRecoverySuggestionErrorKey);
_NS_CONST(ErrorUserInfoKey, LocalizedRecoveryOptionsErrorKey);
_NS_CONST(ErrorUserInfoKey, RecoveryAttempterErrorKey);
_NS_CONST(ErrorUserInfoKey, HelpAnchorErrorKey);
_NS_CONST(ErrorUserInfoKey, DebugDescriptionErrorKey);
_NS_CONST(ErrorUserInfoKey, LocalizedFailureErrorKey);
_NS_CONST(ErrorUserInfoKey, StringEncodingErrorKey);
_NS_CONST(ErrorUserInfoKey, URLErrorKey);
_NS_CONST(ErrorUserInfoKey, FilePathErrorKey);

class Error : public Copying<Error>
{
public:
    static Error*     error(ErrorDomain domain, Integer code, class Dictionary* pDictionary);

    static Error*     alloc();
    Error*            init();
    Error*            init(ErrorDomain domain, Integer code, class Dictionary* pDictionary);

    Integer           code() const;
    ErrorDomain       domain() const;
    class Dictionary* userInfo() const;

    class String*     localizedDescription() const;
    class Array*      localizedRecoveryOptions() const;
    class String*     localizedRecoverySuggestion() const;
    class String*     localizedFailureReason() const;
};
}

_NS_PRIVATE_DEF_CONST(NS::ErrorDomain, CocoaErrorDomain);
_NS_PRIVATE_DEF_CONST(NS::ErrorDomain, POSIXErrorDomain);
_NS_PRIVATE_DEF_CONST(NS::ErrorDomain, OSStatusErrorDomain);
_NS_PRIVATE_DEF_CONST(NS::ErrorDomain, MachErrorDomain);

_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, UnderlyingErrorKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, LocalizedDescriptionKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, LocalizedFailureReasonErrorKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, LocalizedRecoverySuggestionErrorKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, LocalizedRecoveryOptionsErrorKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, RecoveryAttempterErrorKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, HelpAnchorErrorKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, DebugDescriptionErrorKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, LocalizedFailureErrorKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, StringEncodingErrorKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, URLErrorKey);
_NS_PRIVATE_DEF_CONST(NS::ErrorUserInfoKey, FilePathErrorKey);

_NS_INLINE NS::Error* NS::Error::error(ErrorDomain domain, Integer code, class Dictionary* pDictionary)
{
    return Object::sendMessage<Error*>(_NS_PRIVATE_CLS(NSError), _NS_PRIVATE_SEL(errorWithDomain_code_userInfo_), domain, code, pDictionary);
}

_NS_INLINE NS::Error* NS::Error::alloc()
{
    return Object::alloc<Error>(_NS_PRIVATE_CLS(NSError));
}

_NS_INLINE NS::Error* NS::Error::init()
{
    return Object::init<Error>();
}

_NS_INLINE NS::Error* NS::Error::init(ErrorDomain domain, Integer code, class Dictionary* pDictionary)
{
    return Object::sendMessage<Error*>(this, _NS_PRIVATE_SEL(initWithDomain_code_userInfo_), domain, code, pDictionary);
}

_NS_INLINE NS::Integer NS::Error::code() const
{
    return Object::sendMessage<Integer>(this, _NS_PRIVATE_SEL(code));
}

_NS_INLINE NS::ErrorDomain NS::Error::domain() const
{
    return Object::sendMessage<ErrorDomain>(this, _NS_PRIVATE_SEL(domain));
}

_NS_INLINE NS::Dictionary* NS::Error::userInfo() const
{
    return Object::sendMessage<Dictionary*>(this, _NS_PRIVATE_SEL(userInfo));
}

_NS_INLINE NS::String* NS::Error::localizedDescription() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(localizedDescription));
}

_NS_INLINE NS::Array* NS::Error::localizedRecoveryOptions() const
{
    return Object::sendMessage<Array*>(this, _NS_PRIVATE_SEL(localizedRecoveryOptions));
}

_NS_INLINE NS::String* NS::Error::localizedRecoverySuggestion() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(localizedRecoverySuggestion));
}

_NS_INLINE NS::String* NS::Error::localizedFailureReason() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(localizedFailureReason));
}

namespace NS
{

template <class _Class, class _Base = class Object>
class Locking : public _Base
{
public:
    void lock();
    void unlock();
};

class Condition : public Locking<Condition>
{
public:
    static Condition* alloc();

    Condition*        init();

    void              wait();
    bool              waitUntilDate(Date* pLimit);
    void              signal();
    void              broadcast();
};

} // NS

template<class _Class, class _Base /* = NS::Object */>
_NS_INLINE void NS::Locking<_Class, _Base>::lock()
{
    NS::Object::sendMessage<void>(this, _NS_PRIVATE_SEL(lock));
}

template<class _Class, class _Base /* = NS::Object */>
_NS_INLINE void NS::Locking<_Class, _Base>::unlock()
{
    NS::Object::sendMessage<void>(this, _NS_PRIVATE_SEL(unlock));
}

_NS_INLINE NS::Condition* NS::Condition::alloc()
{
    return NS::Object::alloc<NS::Condition>(_NS_PRIVATE_CLS(NSCondition));
}

_NS_INLINE NS::Condition* NS::Condition::init()
{
    return NS::Object::init<NS::Condition>();
}

_NS_INLINE void NS::Condition::wait()
{
    NS::Object::sendMessage<void>(this, _NS_PRIVATE_SEL(wait));
}

_NS_INLINE bool NS::Condition::waitUntilDate(NS::Date* pLimit)
{
    return NS::Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(waitUntilDate_), pLimit);
}

_NS_INLINE void NS::Condition::signal()
{
    NS::Object::sendMessage<void>(this, _NS_PRIVATE_SEL(signal));
}

_NS_INLINE void NS::Condition::broadcast()
{
    NS::Object::sendMessage<void>(this, _NS_PRIVATE_SEL(broadcast));
}

//-------------------------------------------------------------------------------------------------------------------------------------------------------------

namespace NS
{

_NS_ENUM(Integer, ComparisonResult) {
    OrderedAscending = -1,
    OrderedSame = 0,
    OrderedDescending = 1,
};

const Integer NotFound = IntegerMax;

}

namespace NS
{
class Value : public Copying<Value>
{
public:
    static Value* value(const void* pValue, const char* pType);
    static Value* value(const void* pPointer);

    static Value* alloc();

    Value*        init(const void* pValue, const char* pType);
    Value*        init(const class Coder* pCoder);

    void          getValue(void* pValue, UInteger size) const;
    const char*   objCType() const;

    bool          isEqualToValue(Value* pValue) const;
    void*         pointerValue() const;
};

class Number : public Copying<Number, Value>
{
public:
    static Number*     number(char value);
    static Number*     number(unsigned char value);
    static Number*     number(short value);
    static Number*     number(unsigned short value);
    static Number*     number(int value);
    static Number*     number(unsigned int value);
    static Number*     number(long value);
    static Number*     number(unsigned long value);
    static Number*     number(long long value);
    static Number*     number(unsigned long long value);
    static Number*     number(float value);
    static Number*     number(double value);
    static Number*     number(bool value);

    static Number*     alloc();

    Number*            init(const class Coder* pCoder);
    Number*            init(char value);
    Number*            init(unsigned char value);
    Number*            init(short value);
    Number*            init(unsigned short value);
    Number*            init(int value);
    Number*            init(unsigned int value);
    Number*            init(long value);
    Number*            init(unsigned long value);
    Number*            init(long long value);
    Number*            init(unsigned long long value);
    Number*            init(float value);
    Number*            init(double value);
    Number*            init(bool value);

    char               charValue() const;
    unsigned char      unsignedCharValue() const;
    short              shortValue() const;
    unsigned short     unsignedShortValue() const;
    int                intValue() const;
    unsigned int       unsignedIntValue() const;
    long               longValue() const;
    unsigned long      unsignedLongValue() const;
    long long          longLongValue() const;
    unsigned long long unsignedLongLongValue() const;
    float              floatValue() const;
    double             doubleValue() const;
    bool               boolValue() const;
    Integer            integerValue() const;
    UInteger           unsignedIntegerValue() const;
    class String*      stringValue() const;

    ComparisonResult   compare(const Number* pOtherNumber) const;
    bool               isEqualToNumber(const Number* pNumber) const;

    class String*      descriptionWithLocale(const Object* pLocale) const;
};
}

_NS_INLINE NS::Value* NS::Value::value(const void* pValue, const char* pType)
{
    return Object::sendMessage<Value*>(_NS_PRIVATE_CLS(NSValue), _NS_PRIVATE_SEL(valueWithBytes_objCType_), pValue, pType);
}

_NS_INLINE NS::Value* NS::Value::value(const void* pPointer)
{
    return Object::sendMessage<Value*>(_NS_PRIVATE_CLS(NSValue), _NS_PRIVATE_SEL(valueWithPointer_), pPointer);
}

_NS_INLINE NS::Value* NS::Value::alloc()
{
    return NS::Object::alloc<Value>(_NS_PRIVATE_CLS(NSValue));
}

_NS_INLINE NS::Value* NS::Value::init(const void* pValue, const char* pType)
{
    return Object::sendMessage<Value*>(this, _NS_PRIVATE_SEL(initWithBytes_objCType_), pValue, pType);
}

_NS_INLINE NS::Value* NS::Value::init(const class Coder* pCoder)
{
    return Object::sendMessage<Value*>(this, _NS_PRIVATE_SEL(initWithCoder_), pCoder);
}

_NS_INLINE void NS::Value::getValue(void* pValue, UInteger size) const
{
    Object::sendMessage<void>(this, _NS_PRIVATE_SEL(getValue_size_), pValue, size);
}

_NS_INLINE const char* NS::Value::objCType() const
{
    return Object::sendMessage<const char*>(this, _NS_PRIVATE_SEL(objCType));
}

_NS_INLINE bool NS::Value::isEqualToValue(Value* pValue) const
{
    return Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(isEqualToValue_), pValue);
}

_NS_INLINE void* NS::Value::pointerValue() const
{
    return Object::sendMessage<void*>(this, _NS_PRIVATE_SEL(pointerValue));
}

_NS_INLINE NS::Number* NS::Number::number(char value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithChar_), value);
}

_NS_INLINE NS::Number* NS::Number::number(unsigned char value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithUnsignedChar_), value);
}

_NS_INLINE NS::Number* NS::Number::number(short value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithShort_), value);
}

_NS_INLINE NS::Number* NS::Number::number(unsigned short value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithUnsignedShort_), value);
}

_NS_INLINE NS::Number* NS::Number::number(int value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithInt_), value);
}

_NS_INLINE NS::Number* NS::Number::number(unsigned int value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithUnsignedInt_), value);
}

_NS_INLINE NS::Number* NS::Number::number(long value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithLong_), value);
}

_NS_INLINE NS::Number* NS::Number::number(unsigned long value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithUnsignedLong_), value);
}

_NS_INLINE NS::Number* NS::Number::number(long long value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithLongLong_), value);
}

_NS_INLINE NS::Number* NS::Number::number(unsigned long long value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithUnsignedLongLong_), value);
}

_NS_INLINE NS::Number* NS::Number::number(float value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithFloat_), value);
}

_NS_INLINE NS::Number* NS::Number::number(double value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithDouble_), value);
}

_NS_INLINE NS::Number* NS::Number::number(bool value)
{
    return Object::sendMessage<Number*>(_NS_PRIVATE_CLS(NSNumber), _NS_PRIVATE_SEL(numberWithBool_), value);
}

_NS_INLINE NS::Number* NS::Number::alloc()
{
    return NS::Object::alloc<Number>(_NS_PRIVATE_CLS(NSNumber));
}

_NS_INLINE NS::Number* NS::Number::init(const Coder* pCoder)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithCoder_), pCoder);
}

_NS_INLINE NS::Number* NS::Number::init(char value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithChar_), value);
}

_NS_INLINE NS::Number* NS::Number::init(unsigned char value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithUnsignedChar_), value);
}

_NS_INLINE NS::Number* NS::Number::init(short value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithShort_), value);
}

_NS_INLINE NS::Number* NS::Number::init(unsigned short value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithUnsignedShort_), value);
}

_NS_INLINE NS::Number* NS::Number::init(int value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithInt_), value);
}

_NS_INLINE NS::Number* NS::Number::init(unsigned int value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithUnsignedInt_), value);
}

_NS_INLINE NS::Number* NS::Number::init(long value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithLong_), value);
}

_NS_INLINE NS::Number* NS::Number::init(unsigned long value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithUnsignedLong_), value);
}

_NS_INLINE NS::Number* NS::Number::init(long long value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithLongLong_), value);
}

_NS_INLINE NS::Number* NS::Number::init(unsigned long long value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithUnsignedLongLong_), value);
}

_NS_INLINE NS::Number* NS::Number::init(float value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithFloat_), value);
}

_NS_INLINE NS::Number* NS::Number::init(double value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithDouble_), value);
}

_NS_INLINE NS::Number* NS::Number::init(bool value)
{
    return Object::sendMessage<Number*>(this, _NS_PRIVATE_SEL(initWithBool_), value);
}

_NS_INLINE char NS::Number::charValue() const
{
    return Object::sendMessage<char>(this, _NS_PRIVATE_SEL(charValue));
}

_NS_INLINE unsigned char NS::Number::unsignedCharValue() const
{
    return Object::sendMessage<unsigned char>(this, _NS_PRIVATE_SEL(unsignedCharValue));
}

_NS_INLINE short NS::Number::shortValue() const
{
    return Object::sendMessage<short>(this, _NS_PRIVATE_SEL(shortValue));
}

_NS_INLINE unsigned short NS::Number::unsignedShortValue() const
{
    return Object::sendMessage<unsigned short>(this, _NS_PRIVATE_SEL(unsignedShortValue));
}

_NS_INLINE int NS::Number::intValue() const
{
    return Object::sendMessage<int>(this, _NS_PRIVATE_SEL(intValue));
}

_NS_INLINE unsigned int NS::Number::unsignedIntValue() const
{
    return Object::sendMessage<unsigned int>(this, _NS_PRIVATE_SEL(unsignedIntValue));
}

_NS_INLINE long NS::Number::longValue() const
{
    return Object::sendMessage<long>(this, _NS_PRIVATE_SEL(longValue));
}

_NS_INLINE unsigned long NS::Number::unsignedLongValue() const
{
    return Object::sendMessage<unsigned long>(this, _NS_PRIVATE_SEL(unsignedLongValue));
}

_NS_INLINE long long NS::Number::longLongValue() const
{
    return Object::sendMessage<long long>(this, _NS_PRIVATE_SEL(longLongValue));
}

_NS_INLINE unsigned long long NS::Number::unsignedLongLongValue() const
{
    return Object::sendMessage<unsigned long long>(this, _NS_PRIVATE_SEL(unsignedLongLongValue));
}

_NS_INLINE float NS::Number::floatValue() const
{
    return Object::sendMessage<float>(this, _NS_PRIVATE_SEL(floatValue));
}

_NS_INLINE double NS::Number::doubleValue() const
{
    return Object::sendMessage<double>(this, _NS_PRIVATE_SEL(doubleValue));
}

_NS_INLINE bool NS::Number::boolValue() const
{
    return Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(boolValue));
}

_NS_INLINE NS::Integer NS::Number::integerValue() const
{
    return Object::sendMessage<Integer>(this, _NS_PRIVATE_SEL(integerValue));
}

_NS_INLINE NS::UInteger NS::Number::unsignedIntegerValue() const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(unsignedIntegerValue));
}

_NS_INLINE NS::String* NS::Number::stringValue() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(stringValue));
}

_NS_INLINE NS::ComparisonResult NS::Number::compare(const Number* pOtherNumber) const
{
    return Object::sendMessage<ComparisonResult>(this, _NS_PRIVATE_SEL(compare_), pOtherNumber);
}

_NS_INLINE bool NS::Number::isEqualToNumber(const Number* pNumber) const
{
    return Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(isEqualToNumber_), pNumber);
}

_NS_INLINE NS::String* NS::Number::descriptionWithLocale(const Object* pLocale) const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(descriptionWithLocale_), pLocale);
}

#include <functional>

namespace NS
{
_NS_CONST(NotificationName, ProcessInfoThermalStateDidChangeNotification);
_NS_CONST(NotificationName, ProcessInfoPowerStateDidChangeNotification);

_NS_ENUM(NS::Integer, ProcessInfoThermalState) {
    ProcessInfoThermalStateNominal = 0,
    ProcessInfoThermalStateFair = 1,
    ProcessInfoThermalStateSerious = 2,
    ProcessInfoThermalStateCritical = 3
};

_NS_OPTIONS(std::uint64_t, ActivityOptions) {
    ActivityIdleDisplaySleepDisabled = (1ULL << 40),
    ActivityIdleSystemSleepDisabled = (1ULL << 20),
    ActivitySuddenTerminationDisabled = (1ULL << 14),
    ActivityAutomaticTerminationDisabled = (1ULL << 15),
    ActivityUserInitiated = (0x00FFFFFFULL | ActivityIdleSystemSleepDisabled),
    ActivityUserInitiatedAllowingIdleSystemSleep = (ActivityUserInitiated & ~ActivityIdleSystemSleepDisabled),
    ActivityBackground = 0x000000FFULL,
    ActivityLatencyCritical = 0xFF00000000ULL,
};

class ProcessInfo : public Referencing<ProcessInfo>
{
public:
    static ProcessInfo*     processInfo();

    class Array*            arguments() const;
    class Dictionary*       environment() const;
    class String*           hostName() const;
    class String*           processName() const;
    void                    setProcessName(const String* pString);
    int                     processIdentifier() const;
    class String*           globallyUniqueString() const;

    class String*           userName() const;
    class String*           fullUserName() const;

    UInteger                operatingSystem() const;
    OperatingSystemVersion  operatingSystemVersion() const;
    class String*           operatingSystemVersionString() const;
    bool                    isOperatingSystemAtLeastVersion(OperatingSystemVersion version) const;

    UInteger                processorCount() const;
    UInteger                activeProcessorCount() const;
    unsigned long long      physicalMemory() const;
    TimeInterval            systemUptime() const;

    void                    disableSuddenTermination();
    void                    enableSuddenTermination();

    void                    disableAutomaticTermination(const class String* pReason);
    void                    enableAutomaticTermination(const class String* pReason);
    bool                    automaticTerminationSupportEnabled() const;
    void                    setAutomaticTerminationSupportEnabled(bool enabled);

    class Object*           beginActivity(ActivityOptions options, const class String* pReason);
    void                    endActivity(class Object* pActivity);
    void                    performActivity(ActivityOptions options, const class String* pReason, void (^block)(void));
    void                    performActivity(ActivityOptions options, const class String* pReason, const std::function<void()>& func);
    void                    performExpiringActivity(const class String* pReason, void (^block)(bool expired));
    void                    performExpiringActivity(const class String* pReason, const std::function<void(bool expired)>& func);

    ProcessInfoThermalState thermalState() const;
    bool                    isLowPowerModeEnabled() const;

    bool                    isiOSAppOnMac() const;
    bool                    isMacCatalystApp() const;
};
}

_NS_PRIVATE_DEF_CONST(NS::NotificationName, ProcessInfoThermalStateDidChangeNotification);
_NS_PRIVATE_DEF_CONST(NS::NotificationName, ProcessInfoPowerStateDidChangeNotification);

_NS_INLINE NS::ProcessInfo* NS::ProcessInfo::processInfo()
{
    return Object::sendMessage<ProcessInfo*>(_NS_PRIVATE_CLS(NSProcessInfo), _NS_PRIVATE_SEL(processInfo));
}

_NS_INLINE NS::Array* NS::ProcessInfo::arguments() const
{
    return Object::sendMessage<Array*>(this, _NS_PRIVATE_SEL(arguments));
}

_NS_INLINE NS::Dictionary* NS::ProcessInfo::environment() const
{
    return Object::sendMessage<Dictionary*>(this, _NS_PRIVATE_SEL(environment));
}

_NS_INLINE NS::String* NS::ProcessInfo::hostName() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(hostName));
}

_NS_INLINE NS::String* NS::ProcessInfo::processName() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(processName));
}

_NS_INLINE void NS::ProcessInfo::setProcessName(const String* pString)
{
    Object::sendMessage<void>(this, _NS_PRIVATE_SEL(setProcessName_), pString);
}

_NS_INLINE int NS::ProcessInfo::processIdentifier() const
{
    return Object::sendMessage<int>(this, _NS_PRIVATE_SEL(processIdentifier));
}

_NS_INLINE NS::String* NS::ProcessInfo::globallyUniqueString() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(globallyUniqueString));
}

_NS_INLINE NS::String* NS::ProcessInfo::userName() const
{
    return Object::sendMessageSafe<String*>(this, _NS_PRIVATE_SEL(userName));
}

_NS_INLINE NS::String* NS::ProcessInfo::fullUserName() const
{
    return Object::sendMessageSafe<String*>(this, _NS_PRIVATE_SEL(fullUserName));
}

_NS_INLINE NS::UInteger NS::ProcessInfo::operatingSystem() const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(operatingSystem));
}

_NS_INLINE NS::OperatingSystemVersion NS::ProcessInfo::operatingSystemVersion() const
{
    return Object::sendMessage<OperatingSystemVersion>(this, _NS_PRIVATE_SEL(operatingSystemVersion));
}

_NS_INLINE NS::String* NS::ProcessInfo::operatingSystemVersionString() const
{
    return Object::sendMessage<String*>(this, _NS_PRIVATE_SEL(operatingSystemVersionString));
}

_NS_INLINE bool NS::ProcessInfo::isOperatingSystemAtLeastVersion(OperatingSystemVersion version) const
{
    return Object::sendMessage<bool>(this, _NS_PRIVATE_SEL(isOperatingSystemAtLeastVersion_), version);
}

_NS_INLINE NS::UInteger NS::ProcessInfo::processorCount() const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(processorCount));
}

_NS_INLINE NS::UInteger NS::ProcessInfo::activeProcessorCount() const
{
    return Object::sendMessage<UInteger>(this, _NS_PRIVATE_SEL(activeProcessorCount));
}

_NS_INLINE unsigned long long NS::ProcessInfo::physicalMemory() const
{
    return Object::sendMessage<unsigned long long>(this, _NS_PRIVATE_SEL(physicalMemory));
}

_NS_INLINE NS::TimeInterval NS::ProcessInfo::systemUptime() const
{
    return Object::sendMessage<TimeInterval>(this, _NS_PRIVATE_SEL(systemUptime));
}

_NS_INLINE void NS::ProcessInfo::disableSuddenTermination()
{
    Object::sendMessageSafe<void>(this, _NS_PRIVATE_SEL(disableSuddenTermination));
}

_NS_INLINE void NS::ProcessInfo::enableSuddenTermination()
{
    Object::sendMessageSafe<void>(this, _NS_PRIVATE_SEL(enableSuddenTermination));
}

_NS_INLINE void NS::ProcessInfo::disableAutomaticTermination(const String* pReason)
{
    Object::sendMessageSafe<void>(this, _NS_PRIVATE_SEL(disableAutomaticTermination_), pReason);
}

_NS_INLINE void NS::ProcessInfo::enableAutomaticTermination(const String* pReason)
{
    Object::sendMessageSafe<void>(this, _NS_PRIVATE_SEL(enableAutomaticTermination_), pReason);
}

_NS_INLINE bool NS::ProcessInfo::automaticTerminationSupportEnabled() const
{
    return Object::sendMessageSafe<bool>(this, _NS_PRIVATE_SEL(automaticTerminationSupportEnabled));
}

_NS_INLINE void NS::ProcessInfo::setAutomaticTerminationSupportEnabled(bool enabled)
{
    Object::sendMessageSafe<void>(this, _NS_PRIVATE_SEL(setAutomaticTerminationSupportEnabled_), enabled);
}

_NS_INLINE NS::Object* NS::ProcessInfo::beginActivity(ActivityOptions options, const String* pReason)
{
    return Object::sendMessage<Object*>(this, _NS_PRIVATE_SEL(beginActivityWithOptions_reason_), options, pReason);
}

_NS_INLINE void NS::ProcessInfo::endActivity(Object* pActivity)
{
    Object::sendMessage<void>(this, _NS_PRIVATE_SEL(endActivity_), pActivity);
}

_NS_INLINE void NS::ProcessInfo::performActivity(ActivityOptions options, const String* pReason, void (^block)(void))
{
    Object::sendMessage<void>(this, _NS_PRIVATE_SEL(performActivityWithOptions_reason_usingBlock_), options, pReason, block);
}

_NS_INLINE void NS::ProcessInfo::performActivity(ActivityOptions options, const String* pReason, const std::function<void()>& function)
{
    __block std::function<void()> blockFunction = function;

    performActivity(options, pReason, ^() { blockFunction(); });
}

_NS_INLINE void NS::ProcessInfo::performExpiringActivity(const String* pReason, void (^block)(bool expired))
{
    Object::sendMessageSafe<void>(this, _NS_PRIVATE_SEL(performExpiringActivityWithReason_usingBlock_), pReason, block);
}

_NS_INLINE void NS::ProcessInfo::performExpiringActivity(const String* pReason, const std::function<void(bool expired)>& function)
{
    __block std::function<void(bool expired)> blockFunction = function;

    performExpiringActivity(pReason, ^(bool expired) { blockFunction(expired); });
}

_NS_INLINE NS::ProcessInfoThermalState NS::ProcessInfo::thermalState() const
{
    return Object::sendMessage<ProcessInfoThermalState>(this, _NS_PRIVATE_SEL(thermalState));
}

_NS_INLINE bool NS::ProcessInfo::isLowPowerModeEnabled() const
{
    return Object::sendMessageSafe<bool>(this, _NS_PRIVATE_SEL(isLowPowerModeEnabled));
}

_NS_INLINE bool NS::ProcessInfo::isiOSAppOnMac() const
{
    return Object::sendMessageSafe<bool>(this, _NS_PRIVATE_SEL(isiOSAppOnMac));
}

_NS_INLINE bool NS::ProcessInfo::isMacCatalystApp() const
{
    return Object::sendMessageSafe<bool>(this, _NS_PRIVATE_SEL(isMacCatalystApp));
}

namespace NS
{
class URL : public Copying<URL>
{
public:
    static URL* fileURLWithPath(const class String* pPath);

    static URL* alloc();
    URL*        init();
    URL*        init(const class String* pString);
    URL*        initFileURLWithPath(const class String* pPath);

    const char* fileSystemRepresentation() const;
};
}

_NS_INLINE NS::URL* NS::URL::fileURLWithPath(const String* pPath)
{
    return Object::sendMessage<URL*>(_NS_PRIVATE_CLS(NSURL), _NS_PRIVATE_SEL(fileURLWithPath_), pPath);
}

_NS_INLINE NS::URL* NS::URL::alloc()
{
    return Object::alloc<URL>(_NS_PRIVATE_CLS(NSURL));
}

_NS_INLINE NS::URL* NS::URL::init()
{
    return Object::init<URL>();
}

_NS_INLINE NS::URL* NS::URL::init(const String* pString)
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(initWithString_), pString);
}

_NS_INLINE NS::URL* NS::URL::initFileURLWithPath(const String* pPath)
{
    return Object::sendMessage<URL*>(this, _NS_PRIVATE_SEL(initFileURLWithPath_), pPath);
}

_NS_INLINE const char* NS::URL::fileSystemRepresentation() const
{
    return Object::sendMessage<const char*>(this, _NS_PRIVATE_SEL(fileSystemRepresentation));
}

#pragma once

#define _MTL_EXPORT _NS_EXPORT
#define _MTL_EXTERN _NS_EXTERN
#define _MTL_INLINE _NS_INLINE
#define _MTL_PACKED _NS_PACKED

#define _MTL_CONST(type, name) _NS_CONST(type, name)
#define _MTL_ENUM(type, name) _NS_ENUM(type, name)
#define _MTL_OPTIONS(type, name) _NS_ENUM(type, name)

#define _MTL_VALIDATE_SIZE(ns, name) _NS_VALIDATE_SIZE(ns, name)
#define _MTL_VALIDATE_ENUM(ns, name) _NS_VALIDATE_ENUM(ns, name)

#pragma once

#include <objc/runtime.h>

#define _MTL_PRIVATE_CLS(symbol) (Private::Class::s_k##symbol)
#define _MTL_PRIVATE_SEL(accessor) (Private::Selector::s_k##accessor)

#if defined(MTL_PRIVATE_IMPLEMENTATION)

#define _MTL_PRIVATE_VISIBILITY __attribute__((visibility("default")))
#define _MTL_PRIVATE_IMPORT __attribute__((weak_import))

#if __OBJC__
#define _MTL_PRIVATE_OBJC_LOOKUP_CLASS(symbol) ((__bridge void*)objc_lookUpClass(#symbol))
#else
#define _MTL_PRIVATE_OBJC_LOOKUP_CLASS(symbol) objc_lookUpClass(#symbol)
#endif // __OBJC__

#define _MTL_PRIVATE_DEF_CLS(symbol) void* s_k##symbol _MTL_PRIVATE_VISIBILITY = _MTL_PRIVATE_OBJC_LOOKUP_CLASS(symbol);
#define _MTL_PRIVATE_DEF_PRO(symbol)
#define _MTL_PRIVATE_DEF_SEL(accessor, symbol) SEL s_k##accessor _MTL_PRIVATE_VISIBILITY = sel_registerName(symbol);

#if defined(__MAC_10_16) || defined(__MAC_11_0) || defined(__MAC_12_0) || defined(__IPHONE_14_0) || defined(__IPHONE_15_0) || defined(__TVOS_14_0) || defined(__TVOS_15_0)

#define _MTL_PRIVATE_DEF_STR(type, symbol)                  \
    _MTL_EXTERN type const MTL##symbol _MTL_PRIVATE_IMPORT; \
    type const                         MTL::symbol = (nullptr != &MTL##symbol) ? MTL##symbol : nullptr;

#else

#include <dlfcn.h>

namespace MTL
{
namespace Private
{

    template <typename _Type>
    inline _Type const LoadSymbol(const char* pSymbol)
    {
        const _Type* pAddress = static_cast<_Type*>(dlsym(RTLD_DEFAULT, pSymbol));

        return pAddress ? *pAddress : nullptr;
    }

} // Private
} // MTL

#define _MTL_PRIVATE_DEF_STR(type, symbol) \
    _MTL_EXTERN type const MTL##symbol;    \
    type const             MTL::symbol = Private::LoadSymbol<type>("MTL" #symbol);

#endif // defined(__MAC_10_16) || defined(__MAC_11_0) || defined(__MAC_12_0) || defined(__IPHONE_14_0) || defined(__IPHONE_15_0) || defined(__TVOS_14_0) || defined(__TVOS_15_0)

#else

#define _MTL_PRIVATE_DEF_CLS(symbol) extern void* s_k##symbol;
#define _MTL_PRIVATE_DEF_PRO(symbol)
#define _MTL_PRIVATE_DEF_SEL(accessor, symbol) extern SEL s_k##accessor;
#define _MTL_PRIVATE_DEF_STR(type, symbol)

#endif // MTL_PRIVATE_IMPLEMENTATION

namespace MTL
{
namespace Private
{
    namespace Class
    {

    } // Class
} // Private
} // MTL

namespace MTL
{
namespace Private
{
    namespace Protocol
    {

    } // Protocol
} // Private
} // MTL

namespace MTL
{
namespace Private
{
    namespace Selector
    {

        _MTL_PRIVATE_DEF_SEL(beginScope,
            "beginScope");
        _MTL_PRIVATE_DEF_SEL(endScope,
            "endScope");
    } // Class
} // Private
} // MTL

namespace MTL::Private::Class
{

_MTL_PRIVATE_DEF_CLS(MTLAccelerationStructureBoundingBoxGeometryDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLAccelerationStructureDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLAccelerationStructureGeometryDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLAccelerationStructureMotionBoundingBoxGeometryDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLAccelerationStructureMotionTriangleGeometryDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLAccelerationStructureTriangleGeometryDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLArgument);
_MTL_PRIVATE_DEF_CLS(MTLArgumentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLArrayType);
_MTL_PRIVATE_DEF_CLS(MTLAttribute);
_MTL_PRIVATE_DEF_CLS(MTLAttributeDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLAttributeDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLBinaryArchiveDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLBlitPassDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLBlitPassSampleBufferAttachmentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLBlitPassSampleBufferAttachmentDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLBufferLayoutDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLBufferLayoutDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLCaptureDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLCaptureManager);
_MTL_PRIVATE_DEF_CLS(MTLCommandBufferDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLCompileOptions);
_MTL_PRIVATE_DEF_CLS(MTLComputePassDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLComputePassSampleBufferAttachmentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLComputePassSampleBufferAttachmentDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLComputePipelineDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLComputePipelineReflection);
_MTL_PRIVATE_DEF_CLS(MTLCounterSampleBufferDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLDepthStencilDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLFunctionConstant);
_MTL_PRIVATE_DEF_CLS(MTLFunctionConstantValues);
_MTL_PRIVATE_DEF_CLS(MTLFunctionDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLFunctionStitchingAttributeAlwaysInline);
_MTL_PRIVATE_DEF_CLS(MTLFunctionStitchingFunctionNode);
_MTL_PRIVATE_DEF_CLS(MTLFunctionStitchingGraph);
_MTL_PRIVATE_DEF_CLS(MTLFunctionStitchingInputNode);
_MTL_PRIVATE_DEF_CLS(MTLHeapDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLIndirectCommandBufferDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLInstanceAccelerationStructureDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLIntersectionFunctionDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLIntersectionFunctionTableDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLLinkedFunctions);
_MTL_PRIVATE_DEF_CLS(MTLMotionKeyframeData);
_MTL_PRIVATE_DEF_CLS(MTLPipelineBufferDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLPipelineBufferDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLPointerType);
_MTL_PRIVATE_DEF_CLS(MTLPrimitiveAccelerationStructureDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRasterizationRateLayerArray);
_MTL_PRIVATE_DEF_CLS(MTLRasterizationRateLayerDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRasterizationRateMapDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRasterizationRateSampleArray);
_MTL_PRIVATE_DEF_CLS(MTLRenderPassAttachmentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRenderPassColorAttachmentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRenderPassColorAttachmentDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLRenderPassDepthAttachmentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRenderPassDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRenderPassSampleBufferAttachmentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRenderPassSampleBufferAttachmentDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLRenderPassStencilAttachmentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRenderPipelineColorAttachmentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRenderPipelineColorAttachmentDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLRenderPipelineDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRenderPipelineFunctionsDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLRenderPipelineReflection);
_MTL_PRIVATE_DEF_CLS(MTLResourceStatePassDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLResourceStatePassSampleBufferAttachmentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLResourceStatePassSampleBufferAttachmentDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLSamplerDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLSharedEventHandle);
_MTL_PRIVATE_DEF_CLS(MTLSharedEventListener);
_MTL_PRIVATE_DEF_CLS(MTLSharedTextureHandle);
_MTL_PRIVATE_DEF_CLS(MTLStageInputOutputDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLStencilDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLStitchedLibraryDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLStructMember);
_MTL_PRIVATE_DEF_CLS(MTLStructType);
_MTL_PRIVATE_DEF_CLS(MTLTextureDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLTextureReferenceType);
_MTL_PRIVATE_DEF_CLS(MTLTileRenderPipelineColorAttachmentDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLTileRenderPipelineColorAttachmentDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLTileRenderPipelineDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLType);
_MTL_PRIVATE_DEF_CLS(MTLVertexAttribute);
_MTL_PRIVATE_DEF_CLS(MTLVertexAttributeDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLVertexAttributeDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLVertexBufferLayoutDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLVertexBufferLayoutDescriptorArray);
_MTL_PRIVATE_DEF_CLS(MTLVertexDescriptor);
_MTL_PRIVATE_DEF_CLS(MTLVisibleFunctionTableDescriptor);

}

namespace MTL::Private::Protocol
{

_MTL_PRIVATE_DEF_PRO(MTLAccelerationStructure);
_MTL_PRIVATE_DEF_PRO(MTLAccelerationStructureCommandEncoder);
_MTL_PRIVATE_DEF_PRO(MTLArgumentEncoder);
_MTL_PRIVATE_DEF_PRO(MTLBinaryArchive);
_MTL_PRIVATE_DEF_PRO(MTLBlitCommandEncoder);
_MTL_PRIVATE_DEF_PRO(MTLBuffer);
_MTL_PRIVATE_DEF_PRO(MTLCommandBuffer);
_MTL_PRIVATE_DEF_PRO(MTLCommandBufferEncoderInfo);
_MTL_PRIVATE_DEF_PRO(MTLCommandEncoder);
_MTL_PRIVATE_DEF_PRO(MTLCommandQueue);
_MTL_PRIVATE_DEF_PRO(MTLComputeCommandEncoder);
_MTL_PRIVATE_DEF_PRO(MTLComputePipelineState);
_MTL_PRIVATE_DEF_PRO(MTLCounter);
_MTL_PRIVATE_DEF_PRO(MTLCounterSampleBuffer);
_MTL_PRIVATE_DEF_PRO(MTLCounterSet);
_MTL_PRIVATE_DEF_PRO(MTLDepthStencilState);
_MTL_PRIVATE_DEF_PRO(MTLDevice);
_MTL_PRIVATE_DEF_PRO(MTLDrawable);
_MTL_PRIVATE_DEF_PRO(MTLDynamicLibrary);
_MTL_PRIVATE_DEF_PRO(MTLEvent);
_MTL_PRIVATE_DEF_PRO(MTLFence);
_MTL_PRIVATE_DEF_PRO(MTLFunction);
_MTL_PRIVATE_DEF_PRO(MTLFunctionHandle);
_MTL_PRIVATE_DEF_PRO(MTLFunctionLog);
_MTL_PRIVATE_DEF_PRO(MTLFunctionLogDebugLocation);
_MTL_PRIVATE_DEF_PRO(MTLFunctionStitchingAttribute);
_MTL_PRIVATE_DEF_PRO(MTLFunctionStitchingNode);
_MTL_PRIVATE_DEF_PRO(MTLHeap);
_MTL_PRIVATE_DEF_PRO(MTLIndirectCommandBuffer);
_MTL_PRIVATE_DEF_PRO(MTLIndirectComputeCommand);
_MTL_PRIVATE_DEF_PRO(MTLIndirectRenderCommand);
_MTL_PRIVATE_DEF_PRO(MTLIntersectionFunctionTable);
_MTL_PRIVATE_DEF_PRO(MTLLibrary);
_MTL_PRIVATE_DEF_PRO(MTLLogContainer);
_MTL_PRIVATE_DEF_PRO(MTLParallelRenderCommandEncoder);
_MTL_PRIVATE_DEF_PRO(MTLRasterizationRateMap);
_MTL_PRIVATE_DEF_PRO(MTLRenderCommandEncoder);
_MTL_PRIVATE_DEF_PRO(MTLRenderPipelineState);
_MTL_PRIVATE_DEF_PRO(MTLResource);
_MTL_PRIVATE_DEF_PRO(MTLResourceStateCommandEncoder);
_MTL_PRIVATE_DEF_PRO(MTLSamplerState);
_MTL_PRIVATE_DEF_PRO(MTLSharedEvent);
_MTL_PRIVATE_DEF_PRO(MTLTexture);
_MTL_PRIVATE_DEF_PRO(MTLVisibleFunctionTable);

}

namespace MTL::Private::Selector
{

_MTL_PRIVATE_DEF_SEL(GPUEndTime,
    "GPUEndTime");
_MTL_PRIVATE_DEF_SEL(GPUStartTime,
    "GPUStartTime");
_MTL_PRIVATE_DEF_SEL(URL,
    "URL");
_MTL_PRIVATE_DEF_SEL(accelerationStructureCommandEncoder,
    "accelerationStructureCommandEncoder");
_MTL_PRIVATE_DEF_SEL(accelerationStructureSizesWithDescriptor_,
    "accelerationStructureSizesWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(access,
    "access");
_MTL_PRIVATE_DEF_SEL(addCompletedHandler_,
    "addCompletedHandler:");
_MTL_PRIVATE_DEF_SEL(addComputePipelineFunctionsWithDescriptor_error_,
    "addComputePipelineFunctionsWithDescriptor:error:");
_MTL_PRIVATE_DEF_SEL(addDebugMarker_range_,
    "addDebugMarker:range:");
_MTL_PRIVATE_DEF_SEL(addFunctionWithDescriptor_library_error_,
    "addFunctionWithDescriptor:library:error:");
_MTL_PRIVATE_DEF_SEL(addPresentedHandler_,
    "addPresentedHandler:");
_MTL_PRIVATE_DEF_SEL(addRenderPipelineFunctionsWithDescriptor_error_,
    "addRenderPipelineFunctionsWithDescriptor:error:");
_MTL_PRIVATE_DEF_SEL(addScheduledHandler_,
    "addScheduledHandler:");
_MTL_PRIVATE_DEF_SEL(addTileRenderPipelineFunctionsWithDescriptor_error_,
    "addTileRenderPipelineFunctionsWithDescriptor:error:");
_MTL_PRIVATE_DEF_SEL(alignment,
    "alignment");
_MTL_PRIVATE_DEF_SEL(allocatedSize,
    "allocatedSize");
_MTL_PRIVATE_DEF_SEL(allowDuplicateIntersectionFunctionInvocation,
    "allowDuplicateIntersectionFunctionInvocation");
_MTL_PRIVATE_DEF_SEL(allowGPUOptimizedContents,
    "allowGPUOptimizedContents");
_MTL_PRIVATE_DEF_SEL(alphaBlendOperation,
    "alphaBlendOperation");
_MTL_PRIVATE_DEF_SEL(areBarycentricCoordsSupported,
    "areBarycentricCoordsSupported");
_MTL_PRIVATE_DEF_SEL(areProgrammableSamplePositionsSupported,
    "areProgrammableSamplePositionsSupported");
_MTL_PRIVATE_DEF_SEL(areRasterOrderGroupsSupported,
    "areRasterOrderGroupsSupported");
_MTL_PRIVATE_DEF_SEL(argumentBuffersSupport,
    "argumentBuffersSupport");
_MTL_PRIVATE_DEF_SEL(argumentDescriptor,
    "argumentDescriptor");
_MTL_PRIVATE_DEF_SEL(argumentIndex,
    "argumentIndex");
_MTL_PRIVATE_DEF_SEL(argumentIndexStride,
    "argumentIndexStride");
_MTL_PRIVATE_DEF_SEL(arguments,
    "arguments");
_MTL_PRIVATE_DEF_SEL(arrayLength,
    "arrayLength");
_MTL_PRIVATE_DEF_SEL(arrayType,
    "arrayType");
_MTL_PRIVATE_DEF_SEL(attributeIndex,
    "attributeIndex");
_MTL_PRIVATE_DEF_SEL(attributeType,
    "attributeType");
_MTL_PRIVATE_DEF_SEL(attributes,
    "attributes");
_MTL_PRIVATE_DEF_SEL(backFaceStencil,
    "backFaceStencil");
_MTL_PRIVATE_DEF_SEL(binaryArchives,
    "binaryArchives");
_MTL_PRIVATE_DEF_SEL(binaryFunctions,
    "binaryFunctions");
_MTL_PRIVATE_DEF_SEL(blitCommandEncoder,
    "blitCommandEncoder");
_MTL_PRIVATE_DEF_SEL(blitCommandEncoderWithDescriptor_,
    "blitCommandEncoderWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(blitPassDescriptor,
    "blitPassDescriptor");
_MTL_PRIVATE_DEF_SEL(borderColor,
    "borderColor");
_MTL_PRIVATE_DEF_SEL(boundingBoxBuffer,
    "boundingBoxBuffer");
_MTL_PRIVATE_DEF_SEL(boundingBoxBufferOffset,
    "boundingBoxBufferOffset");
_MTL_PRIVATE_DEF_SEL(boundingBoxBuffers,
    "boundingBoxBuffers");
_MTL_PRIVATE_DEF_SEL(boundingBoxCount,
    "boundingBoxCount");
_MTL_PRIVATE_DEF_SEL(boundingBoxStride,
    "boundingBoxStride");
_MTL_PRIVATE_DEF_SEL(buffer,
    "buffer");
_MTL_PRIVATE_DEF_SEL(bufferAlignment,
    "bufferAlignment");
_MTL_PRIVATE_DEF_SEL(bufferBytesPerRow,
    "bufferBytesPerRow");
_MTL_PRIVATE_DEF_SEL(bufferDataSize,
    "bufferDataSize");
_MTL_PRIVATE_DEF_SEL(bufferDataType,
    "bufferDataType");
_MTL_PRIVATE_DEF_SEL(bufferIndex,
    "bufferIndex");
_MTL_PRIVATE_DEF_SEL(bufferOffset,
    "bufferOffset");
_MTL_PRIVATE_DEF_SEL(bufferPointerType,
    "bufferPointerType");
_MTL_PRIVATE_DEF_SEL(bufferStructType,
    "bufferStructType");
_MTL_PRIVATE_DEF_SEL(buffers,
    "buffers");
_MTL_PRIVATE_DEF_SEL(buildAccelerationStructure_descriptor_scratchBuffer_scratchBufferOffset_,
    "buildAccelerationStructure:descriptor:scratchBuffer:scratchBufferOffset:");
_MTL_PRIVATE_DEF_SEL(captureObject,
    "captureObject");
_MTL_PRIVATE_DEF_SEL(clearBarrier,
    "clearBarrier");
_MTL_PRIVATE_DEF_SEL(clearColor,
    "clearColor");
_MTL_PRIVATE_DEF_SEL(clearDepth,
    "clearDepth");
_MTL_PRIVATE_DEF_SEL(clearStencil,
    "clearStencil");
_MTL_PRIVATE_DEF_SEL(colorAttachments,
    "colorAttachments");
_MTL_PRIVATE_DEF_SEL(column,
    "column");
_MTL_PRIVATE_DEF_SEL(commandBuffer,
    "commandBuffer");
_MTL_PRIVATE_DEF_SEL(commandBufferWithDescriptor_,
    "commandBufferWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(commandBufferWithUnretainedReferences,
    "commandBufferWithUnretainedReferences");
_MTL_PRIVATE_DEF_SEL(commandQueue,
    "commandQueue");
_MTL_PRIVATE_DEF_SEL(commandTypes,
    "commandTypes");
_MTL_PRIVATE_DEF_SEL(commit,
    "commit");
_MTL_PRIVATE_DEF_SEL(compareFunction,
    "compareFunction");
_MTL_PRIVATE_DEF_SEL(computeCommandEncoder,
    "computeCommandEncoder");
_MTL_PRIVATE_DEF_SEL(computeCommandEncoderWithDescriptor_,
    "computeCommandEncoderWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(computeCommandEncoderWithDispatchType_,
    "computeCommandEncoderWithDispatchType:");
_MTL_PRIVATE_DEF_SEL(computeFunction,
    "computeFunction");
_MTL_PRIVATE_DEF_SEL(computePassDescriptor,
    "computePassDescriptor");
_MTL_PRIVATE_DEF_SEL(concurrentDispatchThreadgroups_threadsPerThreadgroup_,
    "concurrentDispatchThreadgroups:threadsPerThreadgroup:");
_MTL_PRIVATE_DEF_SEL(concurrentDispatchThreads_threadsPerThreadgroup_,
    "concurrentDispatchThreads:threadsPerThreadgroup:");
_MTL_PRIVATE_DEF_SEL(constantBlockAlignment,
    "constantBlockAlignment");
_MTL_PRIVATE_DEF_SEL(constantDataAtIndex_,
    "constantDataAtIndex:");
_MTL_PRIVATE_DEF_SEL(constantValues,
    "constantValues");
_MTL_PRIVATE_DEF_SEL(contents,
    "contents");
_MTL_PRIVATE_DEF_SEL(controlDependencies,
    "controlDependencies");
_MTL_PRIVATE_DEF_SEL(convertSparsePixelRegions_toTileRegions_withTileSize_alignmentMode_numRegions_,
    "convertSparsePixelRegions:toTileRegions:withTileSize:alignmentMode:numRegions:");
_MTL_PRIVATE_DEF_SEL(convertSparseTileRegions_toPixelRegions_withTileSize_numRegions_,
    "convertSparseTileRegions:toPixelRegions:withTileSize:numRegions:");
_MTL_PRIVATE_DEF_SEL(copyAccelerationStructure_toAccelerationStructure_,
    "copyAccelerationStructure:toAccelerationStructure:");
_MTL_PRIVATE_DEF_SEL(copyAndCompactAccelerationStructure_toAccelerationStructure_,
    "copyAndCompactAccelerationStructure:toAccelerationStructure:");
_MTL_PRIVATE_DEF_SEL(copyFromBuffer_sourceOffset_sourceBytesPerRow_sourceBytesPerImage_sourceSize_toTexture_destinationSlice_destinationLevel_destinationOrigin_,
    "copyFromBuffer:sourceOffset:sourceBytesPerRow:sourceBytesPerImage:sourceSize:toTexture:destinationSlice:destinationLevel:destinationOrigin:");
_MTL_PRIVATE_DEF_SEL(copyFromBuffer_sourceOffset_sourceBytesPerRow_sourceBytesPerImage_sourceSize_toTexture_destinationSlice_destinationLevel_destinationOrigin_options_,
    "copyFromBuffer:sourceOffset:sourceBytesPerRow:sourceBytesPerImage:sourceSize:toTexture:destinationSlice:destinationLevel:destinationOrigin:options:");
_MTL_PRIVATE_DEF_SEL(copyFromBuffer_sourceOffset_toBuffer_destinationOffset_size_,
    "copyFromBuffer:sourceOffset:toBuffer:destinationOffset:size:");
_MTL_PRIVATE_DEF_SEL(copyFromTexture_sourceSlice_sourceLevel_sourceOrigin_sourceSize_toBuffer_destinationOffset_destinationBytesPerRow_destinationBytesPerImage_,
    "copyFromTexture:sourceSlice:sourceLevel:sourceOrigin:sourceSize:toBuffer:destinationOffset:destinationBytesPerRow:destinationBytesPerImage:");
_MTL_PRIVATE_DEF_SEL(copyFromTexture_sourceSlice_sourceLevel_sourceOrigin_sourceSize_toBuffer_destinationOffset_destinationBytesPerRow_destinationBytesPerImage_options_,
    "copyFromTexture:sourceSlice:sourceLevel:sourceOrigin:sourceSize:toBuffer:destinationOffset:destinationBytesPerRow:destinationBytesPerImage:options:");
_MTL_PRIVATE_DEF_SEL(copyFromTexture_sourceSlice_sourceLevel_sourceOrigin_sourceSize_toTexture_destinationSlice_destinationLevel_destinationOrigin_,
    "copyFromTexture:sourceSlice:sourceLevel:sourceOrigin:sourceSize:toTexture:destinationSlice:destinationLevel:destinationOrigin:");
_MTL_PRIVATE_DEF_SEL(copyFromTexture_sourceSlice_sourceLevel_toTexture_destinationSlice_destinationLevel_sliceCount_levelCount_,
    "copyFromTexture:sourceSlice:sourceLevel:toTexture:destinationSlice:destinationLevel:sliceCount:levelCount:");
_MTL_PRIVATE_DEF_SEL(copyFromTexture_toTexture_,
    "copyFromTexture:toTexture:");
_MTL_PRIVATE_DEF_SEL(copyIndirectCommandBuffer_sourceRange_destination_destinationIndex_,
    "copyIndirectCommandBuffer:sourceRange:destination:destinationIndex:");
_MTL_PRIVATE_DEF_SEL(copyParameterDataToBuffer_offset_,
    "copyParameterDataToBuffer:offset:");
_MTL_PRIVATE_DEF_SEL(counterSet,
    "counterSet");
_MTL_PRIVATE_DEF_SEL(counterSets,
    "counterSets");
_MTL_PRIVATE_DEF_SEL(counters,
    "counters");
_MTL_PRIVATE_DEF_SEL(cpuCacheMode,
    "cpuCacheMode");
_MTL_PRIVATE_DEF_SEL(currentAllocatedSize,
    "currentAllocatedSize");
_MTL_PRIVATE_DEF_SEL(data,
    "data");
_MTL_PRIVATE_DEF_SEL(dataSize,
    "dataSize");
_MTL_PRIVATE_DEF_SEL(dataType,
    "dataType");
_MTL_PRIVATE_DEF_SEL(dealloc,
    "dealloc");
_MTL_PRIVATE_DEF_SEL(debugLocation,
    "debugLocation");
_MTL_PRIVATE_DEF_SEL(debugSignposts,
    "debugSignposts");
_MTL_PRIVATE_DEF_SEL(defaultCaptureScope,
    "defaultCaptureScope");
_MTL_PRIVATE_DEF_SEL(defaultRasterSampleCount,
    "defaultRasterSampleCount");
_MTL_PRIVATE_DEF_SEL(depth,
    "depth");
_MTL_PRIVATE_DEF_SEL(depthAttachment,
    "depthAttachment");
_MTL_PRIVATE_DEF_SEL(depthAttachmentPixelFormat,
    "depthAttachmentPixelFormat");
_MTL_PRIVATE_DEF_SEL(depthCompareFunction,
    "depthCompareFunction");
_MTL_PRIVATE_DEF_SEL(depthFailureOperation,
    "depthFailureOperation");
_MTL_PRIVATE_DEF_SEL(depthPlane,
    "depthPlane");
_MTL_PRIVATE_DEF_SEL(depthResolveFilter,
    "depthResolveFilter");
_MTL_PRIVATE_DEF_SEL(depthStencilPassOperation,
    "depthStencilPassOperation");
_MTL_PRIVATE_DEF_SEL(descriptor,
    "descriptor");
_MTL_PRIVATE_DEF_SEL(destination,
    "destination");
_MTL_PRIVATE_DEF_SEL(destinationAlphaBlendFactor,
    "destinationAlphaBlendFactor");
_MTL_PRIVATE_DEF_SEL(destinationRGBBlendFactor,
    "destinationRGBBlendFactor");
_MTL_PRIVATE_DEF_SEL(device,
    "device");
_MTL_PRIVATE_DEF_SEL(didModifyRange_,
    "didModifyRange:");
_MTL_PRIVATE_DEF_SEL(dispatchQueue,
    "dispatchQueue");
_MTL_PRIVATE_DEF_SEL(dispatchThreadgroups_threadsPerThreadgroup_,
    "dispatchThreadgroups:threadsPerThreadgroup:");
_MTL_PRIVATE_DEF_SEL(dispatchThreadgroupsWithIndirectBuffer_indirectBufferOffset_threadsPerThreadgroup_,
    "dispatchThreadgroupsWithIndirectBuffer:indirectBufferOffset:threadsPerThreadgroup:");
_MTL_PRIVATE_DEF_SEL(dispatchThreads_threadsPerThreadgroup_,
    "dispatchThreads:threadsPerThreadgroup:");
_MTL_PRIVATE_DEF_SEL(dispatchThreadsPerTile_,
    "dispatchThreadsPerTile:");
_MTL_PRIVATE_DEF_SEL(dispatchType,
    "dispatchType");
_MTL_PRIVATE_DEF_SEL(drawIndexedPatches_patchIndexBuffer_patchIndexBufferOffset_controlPointIndexBuffer_controlPointIndexBufferOffset_indirectBuffer_indirectBufferOffset_,
    "drawIndexedPatches:patchIndexBuffer:patchIndexBufferOffset:controlPointIndexBuffer:controlPointIndexBufferOffset:indirectBuffer:indirectBufferOffset:");
_MTL_PRIVATE_DEF_SEL(drawIndexedPatches_patchStart_patchCount_patchIndexBuffer_patchIndexBufferOffset_controlPointIndexBuffer_controlPointIndexBufferOffset_instanceCount_baseInstance_,
    "drawIndexedPatches:patchStart:patchCount:patchIndexBuffer:patchIndexBufferOffset:controlPointIndexBuffer:controlPointIndexBufferOffset:instanceCount:baseInstance:");
_MTL_PRIVATE_DEF_SEL(drawIndexedPatches_patchStart_patchCount_patchIndexBuffer_patchIndexBufferOffset_controlPointIndexBuffer_controlPointIndexBufferOffset_instanceCount_baseInstance_tessellationFactorBuffer_tessellationFactorBufferOffset_tessellationFactorBufferInstanceStride_,
    "drawIndexedPatches:patchStart:patchCount:patchIndexBuffer:patchIndexBufferOffset:controlPointIndexBuffer:controlPointIndexBufferOffset:instanceCount:baseInstance:tessellationFactorBuffer:tessellationFactorBufferOffset:tessellationFactorBufferInstanceStride:");
_MTL_PRIVATE_DEF_SEL(drawIndexedPrimitives_indexCount_indexType_indexBuffer_indexBufferOffset_,
    "drawIndexedPrimitives:indexCount:indexType:indexBuffer:indexBufferOffset:");
_MTL_PRIVATE_DEF_SEL(drawIndexedPrimitives_indexCount_indexType_indexBuffer_indexBufferOffset_instanceCount_,
    "drawIndexedPrimitives:indexCount:indexType:indexBuffer:indexBufferOffset:instanceCount:");
_MTL_PRIVATE_DEF_SEL(drawIndexedPrimitives_indexCount_indexType_indexBuffer_indexBufferOffset_instanceCount_baseVertex_baseInstance_,
    "drawIndexedPrimitives:indexCount:indexType:indexBuffer:indexBufferOffset:instanceCount:baseVertex:baseInstance:");
_MTL_PRIVATE_DEF_SEL(drawIndexedPrimitives_indexType_indexBuffer_indexBufferOffset_indirectBuffer_indirectBufferOffset_,
    "drawIndexedPrimitives:indexType:indexBuffer:indexBufferOffset:indirectBuffer:indirectBufferOffset:");
_MTL_PRIVATE_DEF_SEL(drawPatches_patchIndexBuffer_patchIndexBufferOffset_indirectBuffer_indirectBufferOffset_,
    "drawPatches:patchIndexBuffer:patchIndexBufferOffset:indirectBuffer:indirectBufferOffset:");
_MTL_PRIVATE_DEF_SEL(drawPatches_patchStart_patchCount_patchIndexBuffer_patchIndexBufferOffset_instanceCount_baseInstance_,
    "drawPatches:patchStart:patchCount:patchIndexBuffer:patchIndexBufferOffset:instanceCount:baseInstance:");
_MTL_PRIVATE_DEF_SEL(drawPatches_patchStart_patchCount_patchIndexBuffer_patchIndexBufferOffset_instanceCount_baseInstance_tessellationFactorBuffer_tessellationFactorBufferOffset_tessellationFactorBufferInstanceStride_,
    "drawPatches:patchStart:patchCount:patchIndexBuffer:patchIndexBufferOffset:instanceCount:baseInstance:tessellationFactorBuffer:tessellationFactorBufferOffset:tessellationFactorBufferInstanceStride:");
_MTL_PRIVATE_DEF_SEL(drawPrimitives_indirectBuffer_indirectBufferOffset_,
    "drawPrimitives:indirectBuffer:indirectBufferOffset:");
_MTL_PRIVATE_DEF_SEL(drawPrimitives_vertexStart_vertexCount_,
    "drawPrimitives:vertexStart:vertexCount:");
_MTL_PRIVATE_DEF_SEL(drawPrimitives_vertexStart_vertexCount_instanceCount_,
    "drawPrimitives:vertexStart:vertexCount:instanceCount:");
_MTL_PRIVATE_DEF_SEL(drawPrimitives_vertexStart_vertexCount_instanceCount_baseInstance_,
    "drawPrimitives:vertexStart:vertexCount:instanceCount:baseInstance:");
_MTL_PRIVATE_DEF_SEL(drawableID,
    "drawableID");
_MTL_PRIVATE_DEF_SEL(elementArrayType,
    "elementArrayType");
_MTL_PRIVATE_DEF_SEL(elementIsArgumentBuffer,
    "elementIsArgumentBuffer");
_MTL_PRIVATE_DEF_SEL(elementPointerType,
    "elementPointerType");
_MTL_PRIVATE_DEF_SEL(elementStructType,
    "elementStructType");
_MTL_PRIVATE_DEF_SEL(elementTextureReferenceType,
    "elementTextureReferenceType");
_MTL_PRIVATE_DEF_SEL(elementType,
    "elementType");
_MTL_PRIVATE_DEF_SEL(encodeSignalEvent_value_,
    "encodeSignalEvent:value:");
_MTL_PRIVATE_DEF_SEL(encodeWaitForEvent_value_,
    "encodeWaitForEvent:value:");
_MTL_PRIVATE_DEF_SEL(encodedLength,
    "encodedLength");
_MTL_PRIVATE_DEF_SEL(encoderLabel,
    "encoderLabel");
_MTL_PRIVATE_DEF_SEL(endEncoding,
    "endEncoding");
_MTL_PRIVATE_DEF_SEL(endOfEncoderSampleIndex,
    "endOfEncoderSampleIndex");
_MTL_PRIVATE_DEF_SEL(endOfFragmentSampleIndex,
    "endOfFragmentSampleIndex");
_MTL_PRIVATE_DEF_SEL(endOfVertexSampleIndex,
    "endOfVertexSampleIndex");
_MTL_PRIVATE_DEF_SEL(enqueue,
    "enqueue");
_MTL_PRIVATE_DEF_SEL(error,
    "error");
_MTL_PRIVATE_DEF_SEL(errorOptions,
    "errorOptions");
_MTL_PRIVATE_DEF_SEL(errorState,
    "errorState");
_MTL_PRIVATE_DEF_SEL(executeCommandsInBuffer_indirectBuffer_indirectBufferOffset_,
    "executeCommandsInBuffer:indirectBuffer:indirectBufferOffset:");
_MTL_PRIVATE_DEF_SEL(executeCommandsInBuffer_withRange_,
    "executeCommandsInBuffer:withRange:");
_MTL_PRIVATE_DEF_SEL(fastMathEnabled,
    "fastMathEnabled");
_MTL_PRIVATE_DEF_SEL(fillBuffer_range_value_,
    "fillBuffer:range:value:");
_MTL_PRIVATE_DEF_SEL(firstMipmapInTail,
    "firstMipmapInTail");
_MTL_PRIVATE_DEF_SEL(format,
    "format");
_MTL_PRIVATE_DEF_SEL(fragmentAdditionalBinaryFunctions,
    "fragmentAdditionalBinaryFunctions");
_MTL_PRIVATE_DEF_SEL(fragmentArguments,
    "fragmentArguments");
_MTL_PRIVATE_DEF_SEL(fragmentBuffers,
    "fragmentBuffers");
_MTL_PRIVATE_DEF_SEL(fragmentFunction,
    "fragmentFunction");
_MTL_PRIVATE_DEF_SEL(fragmentLinkedFunctions,
    "fragmentLinkedFunctions");
_MTL_PRIVATE_DEF_SEL(fragmentPreloadedLibraries,
    "fragmentPreloadedLibraries");
_MTL_PRIVATE_DEF_SEL(frontFaceStencil,
    "frontFaceStencil");
_MTL_PRIVATE_DEF_SEL(function,
    "function");
_MTL_PRIVATE_DEF_SEL(functionConstantsDictionary,
    "functionConstantsDictionary");
_MTL_PRIVATE_DEF_SEL(functionCount,
    "functionCount");
_MTL_PRIVATE_DEF_SEL(functionDescriptor,
    "functionDescriptor");
_MTL_PRIVATE_DEF_SEL(functionGraphs,
    "functionGraphs");
_MTL_PRIVATE_DEF_SEL(functionHandleWithFunction_,
    "functionHandleWithFunction:");
_MTL_PRIVATE_DEF_SEL(functionHandleWithFunction_stage_,
    "functionHandleWithFunction:stage:");
_MTL_PRIVATE_DEF_SEL(functionName,
    "functionName");
_MTL_PRIVATE_DEF_SEL(functionNames,
    "functionNames");
_MTL_PRIVATE_DEF_SEL(functionType,
    "functionType");
_MTL_PRIVATE_DEF_SEL(functions,
    "functions");
_MTL_PRIVATE_DEF_SEL(generateMipmapsForTexture_,
    "generateMipmapsForTexture:");
_MTL_PRIVATE_DEF_SEL(geometryDescriptors,
    "geometryDescriptors");
_MTL_PRIVATE_DEF_SEL(getBytes_bytesPerRow_bytesPerImage_fromRegion_mipmapLevel_slice_,
    "getBytes:bytesPerRow:bytesPerImage:fromRegion:mipmapLevel:slice:");
_MTL_PRIVATE_DEF_SEL(getBytes_bytesPerRow_fromRegion_mipmapLevel_,
    "getBytes:bytesPerRow:fromRegion:mipmapLevel:");
_MTL_PRIVATE_DEF_SEL(getDefaultSamplePositions_count_,
    "getDefaultSamplePositions:count:");
_MTL_PRIVATE_DEF_SEL(getSamplePositions_count_,
    "getSamplePositions:count:");
_MTL_PRIVATE_DEF_SEL(getTextureAccessCounters_region_mipLevel_slice_resetCounters_countersBuffer_countersBufferOffset_,
    "getTextureAccessCounters:region:mipLevel:slice:resetCounters:countersBuffer:countersBufferOffset:");
_MTL_PRIVATE_DEF_SEL(groups,
    "groups");
_MTL_PRIVATE_DEF_SEL(hasUnifiedMemory,
    "hasUnifiedMemory");
_MTL_PRIVATE_DEF_SEL(hazardTrackingMode,
    "hazardTrackingMode");
_MTL_PRIVATE_DEF_SEL(heap,
    "heap");
_MTL_PRIVATE_DEF_SEL(heapBufferSizeAndAlignWithLength_options_,
    "heapBufferSizeAndAlignWithLength:options:");
_MTL_PRIVATE_DEF_SEL(heapOffset,
    "heapOffset");
_MTL_PRIVATE_DEF_SEL(heapTextureSizeAndAlignWithDescriptor_,
    "heapTextureSizeAndAlignWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(height,
    "height");
_MTL_PRIVATE_DEF_SEL(horizontal,
    "horizontal");
_MTL_PRIVATE_DEF_SEL(horizontalSampleStorage,
    "horizontalSampleStorage");
_MTL_PRIVATE_DEF_SEL(imageblockMemoryLengthForDimensions_,
    "imageblockMemoryLengthForDimensions:");
_MTL_PRIVATE_DEF_SEL(imageblockSampleLength,
    "imageblockSampleLength");
_MTL_PRIVATE_DEF_SEL(index,
    "index");
_MTL_PRIVATE_DEF_SEL(indexBuffer,
    "indexBuffer");
_MTL_PRIVATE_DEF_SEL(indexBufferIndex,
    "indexBufferIndex");
_MTL_PRIVATE_DEF_SEL(indexBufferOffset,
    "indexBufferOffset");
_MTL_PRIVATE_DEF_SEL(indexType,
    "indexType");
_MTL_PRIVATE_DEF_SEL(indirectComputeCommandAtIndex_,
    "indirectComputeCommandAtIndex:");
_MTL_PRIVATE_DEF_SEL(indirectRenderCommandAtIndex_,
    "indirectRenderCommandAtIndex:");
_MTL_PRIVATE_DEF_SEL(inheritBuffers,
    "inheritBuffers");
_MTL_PRIVATE_DEF_SEL(inheritPipelineState,
    "inheritPipelineState");
_MTL_PRIVATE_DEF_SEL(init,
    "init");
_MTL_PRIVATE_DEF_SEL(initWithArgumentIndex_,
    "initWithArgumentIndex:");
_MTL_PRIVATE_DEF_SEL(initWithDispatchQueue_,
    "initWithDispatchQueue:");
_MTL_PRIVATE_DEF_SEL(initWithFunctionName_nodes_outputNode_attributes_,
    "initWithFunctionName:nodes:outputNode:attributes:");
_MTL_PRIVATE_DEF_SEL(initWithName_arguments_controlDependencies_,
    "initWithName:arguments:controlDependencies:");
_MTL_PRIVATE_DEF_SEL(initWithSampleCount_,
    "initWithSampleCount:");
_MTL_PRIVATE_DEF_SEL(initWithSampleCount_horizontal_vertical_,
    "initWithSampleCount:horizontal:vertical:");
_MTL_PRIVATE_DEF_SEL(inputPrimitiveTopology,
    "inputPrimitiveTopology");
_MTL_PRIVATE_DEF_SEL(insertDebugCaptureBoundary,
    "insertDebugCaptureBoundary");
_MTL_PRIVATE_DEF_SEL(insertDebugSignpost_,
    "insertDebugSignpost:");
_MTL_PRIVATE_DEF_SEL(insertLibraries,
    "insertLibraries");
_MTL_PRIVATE_DEF_SEL(installName,
    "installName");
_MTL_PRIVATE_DEF_SEL(instanceCount,
    "instanceCount");
_MTL_PRIVATE_DEF_SEL(instanceDescriptorBuffer,
    "instanceDescriptorBuffer");
_MTL_PRIVATE_DEF_SEL(instanceDescriptorBufferOffset,
    "instanceDescriptorBufferOffset");
_MTL_PRIVATE_DEF_SEL(instanceDescriptorStride,
    "instanceDescriptorStride");
_MTL_PRIVATE_DEF_SEL(instanceDescriptorType,
    "instanceDescriptorType");
_MTL_PRIVATE_DEF_SEL(instancedAccelerationStructures,
    "instancedAccelerationStructures");
_MTL_PRIVATE_DEF_SEL(intersectionFunctionTableDescriptor,
    "intersectionFunctionTableDescriptor");
_MTL_PRIVATE_DEF_SEL(intersectionFunctionTableOffset,
    "intersectionFunctionTableOffset");
_MTL_PRIVATE_DEF_SEL(iosurface,
    "iosurface");
_MTL_PRIVATE_DEF_SEL(iosurfacePlane,
    "iosurfacePlane");
_MTL_PRIVATE_DEF_SEL(isActive,
    "isActive");
_MTL_PRIVATE_DEF_SEL(isAliasable,
    "isAliasable");
_MTL_PRIVATE_DEF_SEL(isAlphaToCoverageEnabled,
    "isAlphaToCoverageEnabled");
_MTL_PRIVATE_DEF_SEL(isAlphaToOneEnabled,
    "isAlphaToOneEnabled");
_MTL_PRIVATE_DEF_SEL(isBlendingEnabled,
    "isBlendingEnabled");
_MTL_PRIVATE_DEF_SEL(isCapturing,
    "isCapturing");
_MTL_PRIVATE_DEF_SEL(isDepth24Stencil8PixelFormatSupported,
    "isDepth24Stencil8PixelFormatSupported");
_MTL_PRIVATE_DEF_SEL(isDepthTexture,
    "isDepthTexture");
_MTL_PRIVATE_DEF_SEL(isDepthWriteEnabled,
    "isDepthWriteEnabled");
_MTL_PRIVATE_DEF_SEL(isFramebufferOnly,
    "isFramebufferOnly");
_MTL_PRIVATE_DEF_SEL(isHeadless,
    "isHeadless");
_MTL_PRIVATE_DEF_SEL(isLowPower,
    "isLowPower");
_MTL_PRIVATE_DEF_SEL(isPatchControlPointData,
    "isPatchControlPointData");
_MTL_PRIVATE_DEF_SEL(isPatchData,
    "isPatchData");
_MTL_PRIVATE_DEF_SEL(isRasterizationEnabled,
    "isRasterizationEnabled");
_MTL_PRIVATE_DEF_SEL(isRemovable,
    "isRemovable");
_MTL_PRIVATE_DEF_SEL(isShareable,
    "isShareable");
_MTL_PRIVATE_DEF_SEL(isSparse,
    "isSparse");
_MTL_PRIVATE_DEF_SEL(isTessellationFactorScaleEnabled,
    "isTessellationFactorScaleEnabled");
_MTL_PRIVATE_DEF_SEL(kernelEndTime,
    "kernelEndTime");
_MTL_PRIVATE_DEF_SEL(kernelStartTime,
    "kernelStartTime");
_MTL_PRIVATE_DEF_SEL(label,
    "label");
_MTL_PRIVATE_DEF_SEL(languageVersion,
    "languageVersion");
_MTL_PRIVATE_DEF_SEL(layerAtIndex_,
    "layerAtIndex:");
_MTL_PRIVATE_DEF_SEL(layerCount,
    "layerCount");
_MTL_PRIVATE_DEF_SEL(layers,
    "layers");
_MTL_PRIVATE_DEF_SEL(layouts,
    "layouts");
_MTL_PRIVATE_DEF_SEL(length,
    "length");
_MTL_PRIVATE_DEF_SEL(level,
    "level");
_MTL_PRIVATE_DEF_SEL(libraries,
    "libraries");
_MTL_PRIVATE_DEF_SEL(libraryType,
    "libraryType");
_MTL_PRIVATE_DEF_SEL(line,
    "line");
_MTL_PRIVATE_DEF_SEL(linkedFunctions,
    "linkedFunctions");
_MTL_PRIVATE_DEF_SEL(loadAction,
    "loadAction");
_MTL_PRIVATE_DEF_SEL(location,
    "location");
_MTL_PRIVATE_DEF_SEL(locationNumber,
    "locationNumber");
_MTL_PRIVATE_DEF_SEL(lodAverage,
    "lodAverage");
_MTL_PRIVATE_DEF_SEL(lodMaxClamp,
    "lodMaxClamp");
_MTL_PRIVATE_DEF_SEL(lodMinClamp,
    "lodMinClamp");
_MTL_PRIVATE_DEF_SEL(logs,
    "logs");
_MTL_PRIVATE_DEF_SEL(magFilter,
    "magFilter");
_MTL_PRIVATE_DEF_SEL(makeAliasable,
    "makeAliasable");
_MTL_PRIVATE_DEF_SEL(mapPhysicalToScreenCoordinates_forLayer_,
    "mapPhysicalToScreenCoordinates:forLayer:");
_MTL_PRIVATE_DEF_SEL(mapScreenToPhysicalCoordinates_forLayer_,
    "mapScreenToPhysicalCoordinates:forLayer:");
_MTL_PRIVATE_DEF_SEL(maxAnisotropy,
    "maxAnisotropy");
_MTL_PRIVATE_DEF_SEL(maxArgumentBufferSamplerCount,
    "maxArgumentBufferSamplerCount");
_MTL_PRIVATE_DEF_SEL(maxAvailableSizeWithAlignment_,
    "maxAvailableSizeWithAlignment:");
_MTL_PRIVATE_DEF_SEL(maxBufferLength,
    "maxBufferLength");
_MTL_PRIVATE_DEF_SEL(maxCallStackDepth,
    "maxCallStackDepth");
_MTL_PRIVATE_DEF_SEL(maxFragmentBufferBindCount,
    "maxFragmentBufferBindCount");
_MTL_PRIVATE_DEF_SEL(maxFragmentCallStackDepth,
    "maxFragmentCallStackDepth");
_MTL_PRIVATE_DEF_SEL(maxKernelBufferBindCount,
    "maxKernelBufferBindCount");
_MTL_PRIVATE_DEF_SEL(maxSampleCount,
    "maxSampleCount");
_MTL_PRIVATE_DEF_SEL(maxTessellationFactor,
    "maxTessellationFactor");
_MTL_PRIVATE_DEF_SEL(maxThreadgroupMemoryLength,
    "maxThreadgroupMemoryLength");
_MTL_PRIVATE_DEF_SEL(maxThreadsPerThreadgroup,
    "maxThreadsPerThreadgroup");
_MTL_PRIVATE_DEF_SEL(maxTotalThreadsPerThreadgroup,
    "maxTotalThreadsPerThreadgroup");
_MTL_PRIVATE_DEF_SEL(maxTransferRate,
    "maxTransferRate");
_MTL_PRIVATE_DEF_SEL(maxVertexAmplificationCount,
    "maxVertexAmplificationCount");
_MTL_PRIVATE_DEF_SEL(maxVertexBufferBindCount,
    "maxVertexBufferBindCount");
_MTL_PRIVATE_DEF_SEL(maxVertexCallStackDepth,
    "maxVertexCallStackDepth");
_MTL_PRIVATE_DEF_SEL(memberByName_,
    "memberByName:");
_MTL_PRIVATE_DEF_SEL(members,
    "members");
_MTL_PRIVATE_DEF_SEL(memoryBarrierWithResources_count_,
    "memoryBarrierWithResources:count:");
_MTL_PRIVATE_DEF_SEL(memoryBarrierWithResources_count_afterStages_beforeStages_,
    "memoryBarrierWithResources:count:afterStages:beforeStages:");
_MTL_PRIVATE_DEF_SEL(memoryBarrierWithScope_,
    "memoryBarrierWithScope:");
_MTL_PRIVATE_DEF_SEL(memoryBarrierWithScope_afterStages_beforeStages_,
    "memoryBarrierWithScope:afterStages:beforeStages:");
_MTL_PRIVATE_DEF_SEL(minFilter,
    "minFilter");
_MTL_PRIVATE_DEF_SEL(minimumLinearTextureAlignmentForPixelFormat_,
    "minimumLinearTextureAlignmentForPixelFormat:");
_MTL_PRIVATE_DEF_SEL(minimumTextureBufferAlignmentForPixelFormat_,
    "minimumTextureBufferAlignmentForPixelFormat:");
_MTL_PRIVATE_DEF_SEL(mipFilter,
    "mipFilter");
_MTL_PRIVATE_DEF_SEL(mipmapLevelCount,
    "mipmapLevelCount");
_MTL_PRIVATE_DEF_SEL(motionEndBorderMode,
    "motionEndBorderMode");
_MTL_PRIVATE_DEF_SEL(motionEndTime,
    "motionEndTime");
_MTL_PRIVATE_DEF_SEL(motionKeyframeCount,
    "motionKeyframeCount");
_MTL_PRIVATE_DEF_SEL(motionStartBorderMode,
    "motionStartBorderMode");
_MTL_PRIVATE_DEF_SEL(motionStartTime,
    "motionStartTime");
_MTL_PRIVATE_DEF_SEL(motionTransformBuffer,
    "motionTransformBuffer");
_MTL_PRIVATE_DEF_SEL(motionTransformBufferOffset,
    "motionTransformBufferOffset");
_MTL_PRIVATE_DEF_SEL(motionTransformCount,
    "motionTransformCount");
_MTL_PRIVATE_DEF_SEL(mutability,
    "mutability");
_MTL_PRIVATE_DEF_SEL(name,
    "name");
_MTL_PRIVATE_DEF_SEL(newAccelerationStructureWithDescriptor_,
    "newAccelerationStructureWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(newAccelerationStructureWithSize_,
    "newAccelerationStructureWithSize:");
_MTL_PRIVATE_DEF_SEL(newArgumentEncoderForBufferAtIndex_,
    "newArgumentEncoderForBufferAtIndex:");
_MTL_PRIVATE_DEF_SEL(newArgumentEncoderWithArguments_,
    "newArgumentEncoderWithArguments:");
_MTL_PRIVATE_DEF_SEL(newArgumentEncoderWithBufferIndex_,
    "newArgumentEncoderWithBufferIndex:");
_MTL_PRIVATE_DEF_SEL(newArgumentEncoderWithBufferIndex_reflection_,
    "newArgumentEncoderWithBufferIndex:reflection:");
_MTL_PRIVATE_DEF_SEL(newBinaryArchiveWithDescriptor_error_,
    "newBinaryArchiveWithDescriptor:error:");
_MTL_PRIVATE_DEF_SEL(newBufferWithBytes_length_options_,
    "newBufferWithBytes:length:options:");
_MTL_PRIVATE_DEF_SEL(newBufferWithBytesNoCopy_length_options_deallocator_,
    "newBufferWithBytesNoCopy:length:options:deallocator:");
_MTL_PRIVATE_DEF_SEL(newBufferWithLength_options_,
    "newBufferWithLength:options:");
_MTL_PRIVATE_DEF_SEL(newBufferWithLength_options_offset_,
    "newBufferWithLength:options:offset:");
_MTL_PRIVATE_DEF_SEL(newCaptureScopeWithCommandQueue_,
    "newCaptureScopeWithCommandQueue:");
_MTL_PRIVATE_DEF_SEL(newCaptureScopeWithDevice_,
    "newCaptureScopeWithDevice:");
_MTL_PRIVATE_DEF_SEL(newCommandQueue,
    "newCommandQueue");
_MTL_PRIVATE_DEF_SEL(newCommandQueueWithMaxCommandBufferCount_,
    "newCommandQueueWithMaxCommandBufferCount:");
_MTL_PRIVATE_DEF_SEL(newComputePipelineStateWithAdditionalBinaryFunctions_error_,
    "newComputePipelineStateWithAdditionalBinaryFunctions:error:");
_MTL_PRIVATE_DEF_SEL(newComputePipelineStateWithDescriptor_options_completionHandler_,
    "newComputePipelineStateWithDescriptor:options:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newComputePipelineStateWithDescriptor_options_reflection_error_,
    "newComputePipelineStateWithDescriptor:options:reflection:error:");
_MTL_PRIVATE_DEF_SEL(newComputePipelineStateWithFunction_completionHandler_,
    "newComputePipelineStateWithFunction:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newComputePipelineStateWithFunction_error_,
    "newComputePipelineStateWithFunction:error:");
_MTL_PRIVATE_DEF_SEL(newComputePipelineStateWithFunction_options_completionHandler_,
    "newComputePipelineStateWithFunction:options:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newComputePipelineStateWithFunction_options_reflection_error_,
    "newComputePipelineStateWithFunction:options:reflection:error:");
_MTL_PRIVATE_DEF_SEL(newCounterSampleBufferWithDescriptor_error_,
    "newCounterSampleBufferWithDescriptor:error:");
_MTL_PRIVATE_DEF_SEL(newDefaultLibrary,
    "newDefaultLibrary");
_MTL_PRIVATE_DEF_SEL(newDefaultLibraryWithBundle_error_,
    "newDefaultLibraryWithBundle:error:");
_MTL_PRIVATE_DEF_SEL(newDepthStencilStateWithDescriptor_,
    "newDepthStencilStateWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(newDynamicLibrary_error_,
    "newDynamicLibrary:error:");
_MTL_PRIVATE_DEF_SEL(newDynamicLibraryWithURL_error_,
    "newDynamicLibraryWithURL:error:");
_MTL_PRIVATE_DEF_SEL(newEvent,
    "newEvent");
_MTL_PRIVATE_DEF_SEL(newFence,
    "newFence");
_MTL_PRIVATE_DEF_SEL(newFunctionWithDescriptor_completionHandler_,
    "newFunctionWithDescriptor:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newFunctionWithDescriptor_error_,
    "newFunctionWithDescriptor:error:");
_MTL_PRIVATE_DEF_SEL(newFunctionWithName_,
    "newFunctionWithName:");
_MTL_PRIVATE_DEF_SEL(newFunctionWithName_constantValues_completionHandler_,
    "newFunctionWithName:constantValues:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newFunctionWithName_constantValues_error_,
    "newFunctionWithName:constantValues:error:");
_MTL_PRIVATE_DEF_SEL(newHeapWithDescriptor_,
    "newHeapWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(newIndirectCommandBufferWithDescriptor_maxCommandCount_options_,
    "newIndirectCommandBufferWithDescriptor:maxCommandCount:options:");
_MTL_PRIVATE_DEF_SEL(newIntersectionFunctionTableWithDescriptor_,
    "newIntersectionFunctionTableWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(newIntersectionFunctionTableWithDescriptor_stage_,
    "newIntersectionFunctionTableWithDescriptor:stage:");
_MTL_PRIVATE_DEF_SEL(newIntersectionFunctionWithDescriptor_completionHandler_,
    "newIntersectionFunctionWithDescriptor:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newIntersectionFunctionWithDescriptor_error_,
    "newIntersectionFunctionWithDescriptor:error:");
_MTL_PRIVATE_DEF_SEL(newLibraryWithData_error_,
    "newLibraryWithData:error:");
_MTL_PRIVATE_DEF_SEL(newLibraryWithFile_error_,
    "newLibraryWithFile:error:");
_MTL_PRIVATE_DEF_SEL(newLibraryWithSource_options_completionHandler_,
    "newLibraryWithSource:options:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newLibraryWithSource_options_error_,
    "newLibraryWithSource:options:error:");
_MTL_PRIVATE_DEF_SEL(newLibraryWithStitchedDescriptor_completionHandler_,
    "newLibraryWithStitchedDescriptor:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newLibraryWithStitchedDescriptor_error_,
    "newLibraryWithStitchedDescriptor:error:");
_MTL_PRIVATE_DEF_SEL(newLibraryWithURL_error_,
    "newLibraryWithURL:error:");
_MTL_PRIVATE_DEF_SEL(newRasterizationRateMapWithDescriptor_,
    "newRasterizationRateMapWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(newRemoteBufferViewForDevice_,
    "newRemoteBufferViewForDevice:");
_MTL_PRIVATE_DEF_SEL(newRemoteTextureViewForDevice_,
    "newRemoteTextureViewForDevice:");
_MTL_PRIVATE_DEF_SEL(newRenderPipelineStateWithAdditionalBinaryFunctions_error_,
    "newRenderPipelineStateWithAdditionalBinaryFunctions:error:");
_MTL_PRIVATE_DEF_SEL(newRenderPipelineStateWithDescriptor_completionHandler_,
    "newRenderPipelineStateWithDescriptor:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newRenderPipelineStateWithDescriptor_error_,
    "newRenderPipelineStateWithDescriptor:error:");
_MTL_PRIVATE_DEF_SEL(newRenderPipelineStateWithDescriptor_options_completionHandler_,
    "newRenderPipelineStateWithDescriptor:options:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newRenderPipelineStateWithDescriptor_options_reflection_error_,
    "newRenderPipelineStateWithDescriptor:options:reflection:error:");
_MTL_PRIVATE_DEF_SEL(newRenderPipelineStateWithTileDescriptor_options_completionHandler_,
    "newRenderPipelineStateWithTileDescriptor:options:completionHandler:");
_MTL_PRIVATE_DEF_SEL(newRenderPipelineStateWithTileDescriptor_options_reflection_error_,
    "newRenderPipelineStateWithTileDescriptor:options:reflection:error:");
_MTL_PRIVATE_DEF_SEL(newSamplerStateWithDescriptor_,
    "newSamplerStateWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(newSharedEvent,
    "newSharedEvent");
_MTL_PRIVATE_DEF_SEL(newSharedEventHandle,
    "newSharedEventHandle");
_MTL_PRIVATE_DEF_SEL(newSharedEventWithHandle_,
    "newSharedEventWithHandle:");
_MTL_PRIVATE_DEF_SEL(newSharedTextureHandle,
    "newSharedTextureHandle");
_MTL_PRIVATE_DEF_SEL(newSharedTextureWithDescriptor_,
    "newSharedTextureWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(newSharedTextureWithHandle_,
    "newSharedTextureWithHandle:");
_MTL_PRIVATE_DEF_SEL(newTextureViewWithPixelFormat_,
    "newTextureViewWithPixelFormat:");
_MTL_PRIVATE_DEF_SEL(newTextureViewWithPixelFormat_textureType_levels_slices_,
    "newTextureViewWithPixelFormat:textureType:levels:slices:");
_MTL_PRIVATE_DEF_SEL(newTextureViewWithPixelFormat_textureType_levels_slices_swizzle_,
    "newTextureViewWithPixelFormat:textureType:levels:slices:swizzle:");
_MTL_PRIVATE_DEF_SEL(newTextureWithDescriptor_,
    "newTextureWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(newTextureWithDescriptor_iosurface_plane_,
    "newTextureWithDescriptor:iosurface:plane:");
_MTL_PRIVATE_DEF_SEL(newTextureWithDescriptor_offset_,
    "newTextureWithDescriptor:offset:");
_MTL_PRIVATE_DEF_SEL(newTextureWithDescriptor_offset_bytesPerRow_,
    "newTextureWithDescriptor:offset:bytesPerRow:");
_MTL_PRIVATE_DEF_SEL(newVisibleFunctionTableWithDescriptor_,
    "newVisibleFunctionTableWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(newVisibleFunctionTableWithDescriptor_stage_,
    "newVisibleFunctionTableWithDescriptor:stage:");
_MTL_PRIVATE_DEF_SEL(nodes,
    "nodes");
_MTL_PRIVATE_DEF_SEL(normalizedCoordinates,
    "normalizedCoordinates");
_MTL_PRIVATE_DEF_SEL(notifyListener_atValue_block_,
    "notifyListener:atValue:block:");
_MTL_PRIVATE_DEF_SEL(objectAtIndexedSubscript_,
    "objectAtIndexedSubscript:");
_MTL_PRIVATE_DEF_SEL(offset,
    "offset");
_MTL_PRIVATE_DEF_SEL(opaque,
    "opaque");
_MTL_PRIVATE_DEF_SEL(optimizeContentsForCPUAccess_,
    "optimizeContentsForCPUAccess:");
_MTL_PRIVATE_DEF_SEL(optimizeContentsForCPUAccess_slice_level_,
    "optimizeContentsForCPUAccess:slice:level:");
_MTL_PRIVATE_DEF_SEL(optimizeContentsForGPUAccess_,
    "optimizeContentsForGPUAccess:");
_MTL_PRIVATE_DEF_SEL(optimizeContentsForGPUAccess_slice_level_,
    "optimizeContentsForGPUAccess:slice:level:");
_MTL_PRIVATE_DEF_SEL(optimizeIndirectCommandBuffer_withRange_,
    "optimizeIndirectCommandBuffer:withRange:");
_MTL_PRIVATE_DEF_SEL(options,
    "options");
_MTL_PRIVATE_DEF_SEL(outputNode,
    "outputNode");
_MTL_PRIVATE_DEF_SEL(outputURL,
    "outputURL");
_MTL_PRIVATE_DEF_SEL(parallelRenderCommandEncoderWithDescriptor_,
    "parallelRenderCommandEncoderWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(parameterBufferSizeAndAlign,
    "parameterBufferSizeAndAlign");
_MTL_PRIVATE_DEF_SEL(parentRelativeLevel,
    "parentRelativeLevel");
_MTL_PRIVATE_DEF_SEL(parentRelativeSlice,
    "parentRelativeSlice");
_MTL_PRIVATE_DEF_SEL(parentTexture,
    "parentTexture");
_MTL_PRIVATE_DEF_SEL(patchControlPointCount,
    "patchControlPointCount");
_MTL_PRIVATE_DEF_SEL(patchType,
    "patchType");
_MTL_PRIVATE_DEF_SEL(peerCount,
    "peerCount");
_MTL_PRIVATE_DEF_SEL(peerGroupID,
    "peerGroupID");
_MTL_PRIVATE_DEF_SEL(peerIndex,
    "peerIndex");
_MTL_PRIVATE_DEF_SEL(physicalGranularity,
    "physicalGranularity");
_MTL_PRIVATE_DEF_SEL(physicalSizeForLayer_,
    "physicalSizeForLayer:");
_MTL_PRIVATE_DEF_SEL(pixelFormat,
    "pixelFormat");
_MTL_PRIVATE_DEF_SEL(pointerType,
    "pointerType");
_MTL_PRIVATE_DEF_SEL(popDebugGroup,
    "popDebugGroup");
_MTL_PRIVATE_DEF_SEL(preloadedLibraries,
    "preloadedLibraries");
_MTL_PRIVATE_DEF_SEL(preprocessorMacros,
    "preprocessorMacros");
_MTL_PRIVATE_DEF_SEL(present,
    "present");
_MTL_PRIVATE_DEF_SEL(presentAfterMinimumDuration_,
    "presentAfterMinimumDuration:");
_MTL_PRIVATE_DEF_SEL(presentAtTime_,
    "presentAtTime:");
_MTL_PRIVATE_DEF_SEL(presentDrawable_,
    "presentDrawable:");
_MTL_PRIVATE_DEF_SEL(presentDrawable_afterMinimumDuration_,
    "presentDrawable:afterMinimumDuration:");
_MTL_PRIVATE_DEF_SEL(presentDrawable_atTime_,
    "presentDrawable:atTime:");
_MTL_PRIVATE_DEF_SEL(presentedTime,
    "presentedTime");
_MTL_PRIVATE_DEF_SEL(preserveInvariance,
    "preserveInvariance");
_MTL_PRIVATE_DEF_SEL(privateFunctions,
    "privateFunctions");
_MTL_PRIVATE_DEF_SEL(pushDebugGroup_,
    "pushDebugGroup:");
_MTL_PRIVATE_DEF_SEL(rAddressMode,
    "rAddressMode");
_MTL_PRIVATE_DEF_SEL(rasterSampleCount,
    "rasterSampleCount");
_MTL_PRIVATE_DEF_SEL(rasterizationRateMap,
    "rasterizationRateMap");
_MTL_PRIVATE_DEF_SEL(rasterizationRateMapDescriptorWithScreenSize_,
    "rasterizationRateMapDescriptorWithScreenSize:");
_MTL_PRIVATE_DEF_SEL(rasterizationRateMapDescriptorWithScreenSize_layer_,
    "rasterizationRateMapDescriptorWithScreenSize:layer:");
_MTL_PRIVATE_DEF_SEL(rasterizationRateMapDescriptorWithScreenSize_layerCount_layers_,
    "rasterizationRateMapDescriptorWithScreenSize:layerCount:layers:");
_MTL_PRIVATE_DEF_SEL(readMask,
    "readMask");
_MTL_PRIVATE_DEF_SEL(readWriteTextureSupport,
    "readWriteTextureSupport");
_MTL_PRIVATE_DEF_SEL(recommendedMaxWorkingSetSize,
    "recommendedMaxWorkingSetSize");
_MTL_PRIVATE_DEF_SEL(refitAccelerationStructure_descriptor_destination_scratchBuffer_scratchBufferOffset_,
    "refitAccelerationStructure:descriptor:destination:scratchBuffer:scratchBufferOffset:");
_MTL_PRIVATE_DEF_SEL(registryID,
    "registryID");
_MTL_PRIVATE_DEF_SEL(remoteStorageBuffer,
    "remoteStorageBuffer");
_MTL_PRIVATE_DEF_SEL(remoteStorageTexture,
    "remoteStorageTexture");
_MTL_PRIVATE_DEF_SEL(removeAllDebugMarkers,
    "removeAllDebugMarkers");
_MTL_PRIVATE_DEF_SEL(renderCommandEncoder,
    "renderCommandEncoder");
_MTL_PRIVATE_DEF_SEL(renderCommandEncoderWithDescriptor_,
    "renderCommandEncoderWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(renderPassDescriptor,
    "renderPassDescriptor");
_MTL_PRIVATE_DEF_SEL(renderTargetArrayLength,
    "renderTargetArrayLength");
_MTL_PRIVATE_DEF_SEL(renderTargetHeight,
    "renderTargetHeight");
_MTL_PRIVATE_DEF_SEL(renderTargetWidth,
    "renderTargetWidth");
_MTL_PRIVATE_DEF_SEL(replaceRegion_mipmapLevel_slice_withBytes_bytesPerRow_bytesPerImage_,
    "replaceRegion:mipmapLevel:slice:withBytes:bytesPerRow:bytesPerImage:");
_MTL_PRIVATE_DEF_SEL(replaceRegion_mipmapLevel_withBytes_bytesPerRow_,
    "replaceRegion:mipmapLevel:withBytes:bytesPerRow:");
_MTL_PRIVATE_DEF_SEL(required,
    "required");
_MTL_PRIVATE_DEF_SEL(reset,
    "reset");
_MTL_PRIVATE_DEF_SEL(resetCommandsInBuffer_withRange_,
    "resetCommandsInBuffer:withRange:");
_MTL_PRIVATE_DEF_SEL(resetTextureAccessCounters_region_mipLevel_slice_,
    "resetTextureAccessCounters:region:mipLevel:slice:");
_MTL_PRIVATE_DEF_SEL(resetWithRange_,
    "resetWithRange:");
_MTL_PRIVATE_DEF_SEL(resolveCounterRange_,
    "resolveCounterRange:");
_MTL_PRIVATE_DEF_SEL(resolveCounters_inRange_destinationBuffer_destinationOffset_,
    "resolveCounters:inRange:destinationBuffer:destinationOffset:");
_MTL_PRIVATE_DEF_SEL(resolveDepthPlane,
    "resolveDepthPlane");
_MTL_PRIVATE_DEF_SEL(resolveLevel,
    "resolveLevel");
_MTL_PRIVATE_DEF_SEL(resolveSlice,
    "resolveSlice");
_MTL_PRIVATE_DEF_SEL(resolveTexture,
    "resolveTexture");
_MTL_PRIVATE_DEF_SEL(resourceOptions,
    "resourceOptions");
_MTL_PRIVATE_DEF_SEL(resourceStateCommandEncoder,
    "resourceStateCommandEncoder");
_MTL_PRIVATE_DEF_SEL(resourceStateCommandEncoderWithDescriptor_,
    "resourceStateCommandEncoderWithDescriptor:");
_MTL_PRIVATE_DEF_SEL(resourceStatePassDescriptor,
    "resourceStatePassDescriptor");
_MTL_PRIVATE_DEF_SEL(retainedReferences,
    "retainedReferences");
_MTL_PRIVATE_DEF_SEL(rgbBlendOperation,
    "rgbBlendOperation");
_MTL_PRIVATE_DEF_SEL(rootResource,
    "rootResource");
_MTL_PRIVATE_DEF_SEL(sAddressMode,
    "sAddressMode");
_MTL_PRIVATE_DEF_SEL(sampleBuffer,
    "sampleBuffer");
_MTL_PRIVATE_DEF_SEL(sampleBufferAttachments,
    "sampleBufferAttachments");
_MTL_PRIVATE_DEF_SEL(sampleCount,
    "sampleCount");
_MTL_PRIVATE_DEF_SEL(sampleCountersInBuffer_atSampleIndex_withBarrier_,
    "sampleCountersInBuffer:atSampleIndex:withBarrier:");
_MTL_PRIVATE_DEF_SEL(sampleTimestamps_gpuTimestamp_,
    "sampleTimestamps:gpuTimestamp:");
_MTL_PRIVATE_DEF_SEL(screenSize,
    "screenSize");
_MTL_PRIVATE_DEF_SEL(serializeToURL_error_,
    "serializeToURL:error:");
_MTL_PRIVATE_DEF_SEL(setAccelerationStructure_atBufferIndex_,
    "setAccelerationStructure:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setAccelerationStructure_atIndex_,
    "setAccelerationStructure:atIndex:");
_MTL_PRIVATE_DEF_SEL(setAccess_,
    "setAccess:");
_MTL_PRIVATE_DEF_SEL(setAllowDuplicateIntersectionFunctionInvocation_,
    "setAllowDuplicateIntersectionFunctionInvocation:");
_MTL_PRIVATE_DEF_SEL(setAllowGPUOptimizedContents_,
    "setAllowGPUOptimizedContents:");
_MTL_PRIVATE_DEF_SEL(setAlphaBlendOperation_,
    "setAlphaBlendOperation:");
_MTL_PRIVATE_DEF_SEL(setAlphaToCoverageEnabled_,
    "setAlphaToCoverageEnabled:");
_MTL_PRIVATE_DEF_SEL(setAlphaToOneEnabled_,
    "setAlphaToOneEnabled:");
_MTL_PRIVATE_DEF_SEL(setArgumentBuffer_offset_,
    "setArgumentBuffer:offset:");
_MTL_PRIVATE_DEF_SEL(setArgumentBuffer_startOffset_arrayElement_,
    "setArgumentBuffer:startOffset:arrayElement:");
_MTL_PRIVATE_DEF_SEL(setArgumentIndex_,
    "setArgumentIndex:");
_MTL_PRIVATE_DEF_SEL(setArguments_,
    "setArguments:");
_MTL_PRIVATE_DEF_SEL(setArrayLength_,
    "setArrayLength:");
_MTL_PRIVATE_DEF_SEL(setAttributes_,
    "setAttributes:");
_MTL_PRIVATE_DEF_SEL(setBackFaceStencil_,
    "setBackFaceStencil:");
_MTL_PRIVATE_DEF_SEL(setBarrier,
    "setBarrier");
_MTL_PRIVATE_DEF_SEL(setBinaryArchives_,
    "setBinaryArchives:");
_MTL_PRIVATE_DEF_SEL(setBinaryFunctions_,
    "setBinaryFunctions:");
_MTL_PRIVATE_DEF_SEL(setBlendColorRed_green_blue_alpha_,
    "setBlendColorRed:green:blue:alpha:");
_MTL_PRIVATE_DEF_SEL(setBlendingEnabled_,
    "setBlendingEnabled:");
_MTL_PRIVATE_DEF_SEL(setBorderColor_,
    "setBorderColor:");
_MTL_PRIVATE_DEF_SEL(setBoundingBoxBuffer_,
    "setBoundingBoxBuffer:");
_MTL_PRIVATE_DEF_SEL(setBoundingBoxBufferOffset_,
    "setBoundingBoxBufferOffset:");
_MTL_PRIVATE_DEF_SEL(setBoundingBoxBuffers_,
    "setBoundingBoxBuffers:");
_MTL_PRIVATE_DEF_SEL(setBoundingBoxCount_,
    "setBoundingBoxCount:");
_MTL_PRIVATE_DEF_SEL(setBoundingBoxStride_,
    "setBoundingBoxStride:");
_MTL_PRIVATE_DEF_SEL(setBuffer_,
    "setBuffer:");
_MTL_PRIVATE_DEF_SEL(setBuffer_offset_atIndex_,
    "setBuffer:offset:atIndex:");
_MTL_PRIVATE_DEF_SEL(setBufferIndex_,
    "setBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setBufferOffset_atIndex_,
    "setBufferOffset:atIndex:");
_MTL_PRIVATE_DEF_SEL(setBuffers_offsets_withRange_,
    "setBuffers:offsets:withRange:");
_MTL_PRIVATE_DEF_SEL(setBytes_length_atIndex_,
    "setBytes:length:atIndex:");
_MTL_PRIVATE_DEF_SEL(setCaptureObject_,
    "setCaptureObject:");
_MTL_PRIVATE_DEF_SEL(setClearColor_,
    "setClearColor:");
_MTL_PRIVATE_DEF_SEL(setClearDepth_,
    "setClearDepth:");
_MTL_PRIVATE_DEF_SEL(setClearStencil_,
    "setClearStencil:");
_MTL_PRIVATE_DEF_SEL(setColorStoreAction_atIndex_,
    "setColorStoreAction:atIndex:");
_MTL_PRIVATE_DEF_SEL(setColorStoreActionOptions_atIndex_,
    "setColorStoreActionOptions:atIndex:");
_MTL_PRIVATE_DEF_SEL(setCommandTypes_,
    "setCommandTypes:");
_MTL_PRIVATE_DEF_SEL(setCompareFunction_,
    "setCompareFunction:");
_MTL_PRIVATE_DEF_SEL(setComputeFunction_,
    "setComputeFunction:");
_MTL_PRIVATE_DEF_SEL(setComputePipelineState_,
    "setComputePipelineState:");
_MTL_PRIVATE_DEF_SEL(setComputePipelineState_atIndex_,
    "setComputePipelineState:atIndex:");
_MTL_PRIVATE_DEF_SEL(setComputePipelineStates_withRange_,
    "setComputePipelineStates:withRange:");
_MTL_PRIVATE_DEF_SEL(setConstantBlockAlignment_,
    "setConstantBlockAlignment:");
_MTL_PRIVATE_DEF_SEL(setConstantValue_type_atIndex_,
    "setConstantValue:type:atIndex:");
_MTL_PRIVATE_DEF_SEL(setConstantValue_type_withName_,
    "setConstantValue:type:withName:");
_MTL_PRIVATE_DEF_SEL(setConstantValues_,
    "setConstantValues:");
_MTL_PRIVATE_DEF_SEL(setConstantValues_type_withRange_,
    "setConstantValues:type:withRange:");
_MTL_PRIVATE_DEF_SEL(setControlDependencies_,
    "setControlDependencies:");
_MTL_PRIVATE_DEF_SEL(setCounterSet_,
    "setCounterSet:");
_MTL_PRIVATE_DEF_SEL(setCpuCacheMode_,
    "setCpuCacheMode:");
_MTL_PRIVATE_DEF_SEL(setCullMode_,
    "setCullMode:");
_MTL_PRIVATE_DEF_SEL(setDataType_,
    "setDataType:");
_MTL_PRIVATE_DEF_SEL(setDefaultCaptureScope_,
    "setDefaultCaptureScope:");
_MTL_PRIVATE_DEF_SEL(setDefaultRasterSampleCount_,
    "setDefaultRasterSampleCount:");
_MTL_PRIVATE_DEF_SEL(setDepth_,
    "setDepth:");
_MTL_PRIVATE_DEF_SEL(setDepthAttachment_,
    "setDepthAttachment:");
_MTL_PRIVATE_DEF_SEL(setDepthAttachmentPixelFormat_,
    "setDepthAttachmentPixelFormat:");
_MTL_PRIVATE_DEF_SEL(setDepthBias_slopeScale_clamp_,
    "setDepthBias:slopeScale:clamp:");
_MTL_PRIVATE_DEF_SEL(setDepthClipMode_,
    "setDepthClipMode:");
_MTL_PRIVATE_DEF_SEL(setDepthCompareFunction_,
    "setDepthCompareFunction:");
_MTL_PRIVATE_DEF_SEL(setDepthFailureOperation_,
    "setDepthFailureOperation:");
_MTL_PRIVATE_DEF_SEL(setDepthPlane_,
    "setDepthPlane:");
_MTL_PRIVATE_DEF_SEL(setDepthResolveFilter_,
    "setDepthResolveFilter:");
_MTL_PRIVATE_DEF_SEL(setDepthStencilPassOperation_,
    "setDepthStencilPassOperation:");
_MTL_PRIVATE_DEF_SEL(setDepthStencilState_,
    "setDepthStencilState:");
_MTL_PRIVATE_DEF_SEL(setDepthStoreAction_,
    "setDepthStoreAction:");
_MTL_PRIVATE_DEF_SEL(setDepthStoreActionOptions_,
    "setDepthStoreActionOptions:");
_MTL_PRIVATE_DEF_SEL(setDepthWriteEnabled_,
    "setDepthWriteEnabled:");
_MTL_PRIVATE_DEF_SEL(setDestination_,
    "setDestination:");
_MTL_PRIVATE_DEF_SEL(setDestinationAlphaBlendFactor_,
    "setDestinationAlphaBlendFactor:");
_MTL_PRIVATE_DEF_SEL(setDestinationRGBBlendFactor_,
    "setDestinationRGBBlendFactor:");
_MTL_PRIVATE_DEF_SEL(setDispatchType_,
    "setDispatchType:");
_MTL_PRIVATE_DEF_SEL(setEndOfEncoderSampleIndex_,
    "setEndOfEncoderSampleIndex:");
_MTL_PRIVATE_DEF_SEL(setEndOfFragmentSampleIndex_,
    "setEndOfFragmentSampleIndex:");
_MTL_PRIVATE_DEF_SEL(setEndOfVertexSampleIndex_,
    "setEndOfVertexSampleIndex:");
_MTL_PRIVATE_DEF_SEL(setErrorOptions_,
    "setErrorOptions:");
_MTL_PRIVATE_DEF_SEL(setFastMathEnabled_,
    "setFastMathEnabled:");
_MTL_PRIVATE_DEF_SEL(setFormat_,
    "setFormat:");
_MTL_PRIVATE_DEF_SEL(setFragmentAccelerationStructure_atBufferIndex_,
    "setFragmentAccelerationStructure:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setFragmentAdditionalBinaryFunctions_,
    "setFragmentAdditionalBinaryFunctions:");
_MTL_PRIVATE_DEF_SEL(setFragmentBuffer_offset_atIndex_,
    "setFragmentBuffer:offset:atIndex:");
_MTL_PRIVATE_DEF_SEL(setFragmentBufferOffset_atIndex_,
    "setFragmentBufferOffset:atIndex:");
_MTL_PRIVATE_DEF_SEL(setFragmentBuffers_offsets_withRange_,
    "setFragmentBuffers:offsets:withRange:");
_MTL_PRIVATE_DEF_SEL(setFragmentBytes_length_atIndex_,
    "setFragmentBytes:length:atIndex:");
_MTL_PRIVATE_DEF_SEL(setFragmentFunction_,
    "setFragmentFunction:");
_MTL_PRIVATE_DEF_SEL(setFragmentIntersectionFunctionTable_atBufferIndex_,
    "setFragmentIntersectionFunctionTable:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setFragmentIntersectionFunctionTables_withBufferRange_,
    "setFragmentIntersectionFunctionTables:withBufferRange:");
_MTL_PRIVATE_DEF_SEL(setFragmentLinkedFunctions_,
    "setFragmentLinkedFunctions:");
_MTL_PRIVATE_DEF_SEL(setFragmentPreloadedLibraries_,
    "setFragmentPreloadedLibraries:");
_MTL_PRIVATE_DEF_SEL(setFragmentSamplerState_atIndex_,
    "setFragmentSamplerState:atIndex:");
_MTL_PRIVATE_DEF_SEL(setFragmentSamplerState_lodMinClamp_lodMaxClamp_atIndex_,
    "setFragmentSamplerState:lodMinClamp:lodMaxClamp:atIndex:");
_MTL_PRIVATE_DEF_SEL(setFragmentSamplerStates_lodMinClamps_lodMaxClamps_withRange_,
    "setFragmentSamplerStates:lodMinClamps:lodMaxClamps:withRange:");
_MTL_PRIVATE_DEF_SEL(setFragmentSamplerStates_withRange_,
    "setFragmentSamplerStates:withRange:");
_MTL_PRIVATE_DEF_SEL(setFragmentTexture_atIndex_,
    "setFragmentTexture:atIndex:");
_MTL_PRIVATE_DEF_SEL(setFragmentTextures_withRange_,
    "setFragmentTextures:withRange:");
_MTL_PRIVATE_DEF_SEL(setFragmentVisibleFunctionTable_atBufferIndex_,
    "setFragmentVisibleFunctionTable:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setFragmentVisibleFunctionTables_withBufferRange_,
    "setFragmentVisibleFunctionTables:withBufferRange:");
_MTL_PRIVATE_DEF_SEL(setFrontFaceStencil_,
    "setFrontFaceStencil:");
_MTL_PRIVATE_DEF_SEL(setFrontFacingWinding_,
    "setFrontFacingWinding:");
_MTL_PRIVATE_DEF_SEL(setFunction_atIndex_,
    "setFunction:atIndex:");
_MTL_PRIVATE_DEF_SEL(setFunctionCount_,
    "setFunctionCount:");
_MTL_PRIVATE_DEF_SEL(setFunctionGraphs_,
    "setFunctionGraphs:");
_MTL_PRIVATE_DEF_SEL(setFunctionName_,
    "setFunctionName:");
_MTL_PRIVATE_DEF_SEL(setFunctions_,
    "setFunctions:");
_MTL_PRIVATE_DEF_SEL(setFunctions_withRange_,
    "setFunctions:withRange:");
_MTL_PRIVATE_DEF_SEL(setGeometryDescriptors_,
    "setGeometryDescriptors:");
_MTL_PRIVATE_DEF_SEL(setGroups_,
    "setGroups:");
_MTL_PRIVATE_DEF_SEL(setHazardTrackingMode_,
    "setHazardTrackingMode:");
_MTL_PRIVATE_DEF_SEL(setHeight_,
    "setHeight:");
_MTL_PRIVATE_DEF_SEL(setImageblockSampleLength_,
    "setImageblockSampleLength:");
_MTL_PRIVATE_DEF_SEL(setImageblockWidth_height_,
    "setImageblockWidth:height:");
_MTL_PRIVATE_DEF_SEL(setIndex_,
    "setIndex:");
_MTL_PRIVATE_DEF_SEL(setIndexBuffer_,
    "setIndexBuffer:");
_MTL_PRIVATE_DEF_SEL(setIndexBufferIndex_,
    "setIndexBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setIndexBufferOffset_,
    "setIndexBufferOffset:");
_MTL_PRIVATE_DEF_SEL(setIndexType_,
    "setIndexType:");
_MTL_PRIVATE_DEF_SEL(setIndirectCommandBuffer_atIndex_,
    "setIndirectCommandBuffer:atIndex:");
_MTL_PRIVATE_DEF_SEL(setIndirectCommandBuffers_withRange_,
    "setIndirectCommandBuffers:withRange:");
_MTL_PRIVATE_DEF_SEL(setInheritBuffers_,
    "setInheritBuffers:");
_MTL_PRIVATE_DEF_SEL(setInheritPipelineState_,
    "setInheritPipelineState:");
_MTL_PRIVATE_DEF_SEL(setInputPrimitiveTopology_,
    "setInputPrimitiveTopology:");
_MTL_PRIVATE_DEF_SEL(setInsertLibraries_,
    "setInsertLibraries:");
_MTL_PRIVATE_DEF_SEL(setInstallName_,
    "setInstallName:");
_MTL_PRIVATE_DEF_SEL(setInstanceCount_,
    "setInstanceCount:");
_MTL_PRIVATE_DEF_SEL(setInstanceDescriptorBuffer_,
    "setInstanceDescriptorBuffer:");
_MTL_PRIVATE_DEF_SEL(setInstanceDescriptorBufferOffset_,
    "setInstanceDescriptorBufferOffset:");
_MTL_PRIVATE_DEF_SEL(setInstanceDescriptorStride_,
    "setInstanceDescriptorStride:");
_MTL_PRIVATE_DEF_SEL(setInstanceDescriptorType_,
    "setInstanceDescriptorType:");
_MTL_PRIVATE_DEF_SEL(setInstancedAccelerationStructures_,
    "setInstancedAccelerationStructures:");
_MTL_PRIVATE_DEF_SEL(setIntersectionFunctionTable_atBufferIndex_,
    "setIntersectionFunctionTable:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setIntersectionFunctionTable_atIndex_,
    "setIntersectionFunctionTable:atIndex:");
_MTL_PRIVATE_DEF_SEL(setIntersectionFunctionTableOffset_,
    "setIntersectionFunctionTableOffset:");
_MTL_PRIVATE_DEF_SEL(setIntersectionFunctionTables_withBufferRange_,
    "setIntersectionFunctionTables:withBufferRange:");
_MTL_PRIVATE_DEF_SEL(setIntersectionFunctionTables_withRange_,
    "setIntersectionFunctionTables:withRange:");
_MTL_PRIVATE_DEF_SEL(setKernelBuffer_offset_atIndex_,
    "setKernelBuffer:offset:atIndex:");
_MTL_PRIVATE_DEF_SEL(setLabel_,
    "setLabel:");
_MTL_PRIVATE_DEF_SEL(setLanguageVersion_,
    "setLanguageVersion:");
_MTL_PRIVATE_DEF_SEL(setLayer_atIndex_,
    "setLayer:atIndex:");
_MTL_PRIVATE_DEF_SEL(setLevel_,
    "setLevel:");
_MTL_PRIVATE_DEF_SEL(setLibraries_,
    "setLibraries:");
_MTL_PRIVATE_DEF_SEL(setLibraryType_,
    "setLibraryType:");
_MTL_PRIVATE_DEF_SEL(setLinkedFunctions_,
    "setLinkedFunctions:");
_MTL_PRIVATE_DEF_SEL(setLoadAction_,
    "setLoadAction:");
_MTL_PRIVATE_DEF_SEL(setLodAverage_,
    "setLodAverage:");
_MTL_PRIVATE_DEF_SEL(setLodMaxClamp_,
    "setLodMaxClamp:");
_MTL_PRIVATE_DEF_SEL(setLodMinClamp_,
    "setLodMinClamp:");
_MTL_PRIVATE_DEF_SEL(setMagFilter_,
    "setMagFilter:");
_MTL_PRIVATE_DEF_SEL(setMaxAnisotropy_,
    "setMaxAnisotropy:");
_MTL_PRIVATE_DEF_SEL(setMaxCallStackDepth_,
    "setMaxCallStackDepth:");
_MTL_PRIVATE_DEF_SEL(setMaxFragmentBufferBindCount_,
    "setMaxFragmentBufferBindCount:");
_MTL_PRIVATE_DEF_SEL(setMaxFragmentCallStackDepth_,
    "setMaxFragmentCallStackDepth:");
_MTL_PRIVATE_DEF_SEL(setMaxKernelBufferBindCount_,
    "setMaxKernelBufferBindCount:");
_MTL_PRIVATE_DEF_SEL(setMaxTessellationFactor_,
    "setMaxTessellationFactor:");
_MTL_PRIVATE_DEF_SEL(setMaxTotalThreadsPerThreadgroup_,
    "setMaxTotalThreadsPerThreadgroup:");
_MTL_PRIVATE_DEF_SEL(setMaxVertexAmplificationCount_,
    "setMaxVertexAmplificationCount:");
_MTL_PRIVATE_DEF_SEL(setMaxVertexBufferBindCount_,
    "setMaxVertexBufferBindCount:");
_MTL_PRIVATE_DEF_SEL(setMaxVertexCallStackDepth_,
    "setMaxVertexCallStackDepth:");
_MTL_PRIVATE_DEF_SEL(setMinFilter_,
    "setMinFilter:");
_MTL_PRIVATE_DEF_SEL(setMipFilter_,
    "setMipFilter:");
_MTL_PRIVATE_DEF_SEL(setMipmapLevelCount_,
    "setMipmapLevelCount:");
_MTL_PRIVATE_DEF_SEL(setMotionEndBorderMode_,
    "setMotionEndBorderMode:");
_MTL_PRIVATE_DEF_SEL(setMotionEndTime_,
    "setMotionEndTime:");
_MTL_PRIVATE_DEF_SEL(setMotionKeyframeCount_,
    "setMotionKeyframeCount:");
_MTL_PRIVATE_DEF_SEL(setMotionStartBorderMode_,
    "setMotionStartBorderMode:");
_MTL_PRIVATE_DEF_SEL(setMotionStartTime_,
    "setMotionStartTime:");
_MTL_PRIVATE_DEF_SEL(setMotionTransformBuffer_,
    "setMotionTransformBuffer:");
_MTL_PRIVATE_DEF_SEL(setMotionTransformBufferOffset_,
    "setMotionTransformBufferOffset:");
_MTL_PRIVATE_DEF_SEL(setMotionTransformCount_,
    "setMotionTransformCount:");
_MTL_PRIVATE_DEF_SEL(setMutability_,
    "setMutability:");
_MTL_PRIVATE_DEF_SEL(setName_,
    "setName:");
_MTL_PRIVATE_DEF_SEL(setNodes_,
    "setNodes:");
_MTL_PRIVATE_DEF_SEL(setNormalizedCoordinates_,
    "setNormalizedCoordinates:");
_MTL_PRIVATE_DEF_SEL(setObject_atIndexedSubscript_,
    "setObject:atIndexedSubscript:");
_MTL_PRIVATE_DEF_SEL(setOffset_,
    "setOffset:");
_MTL_PRIVATE_DEF_SEL(setOpaque_,
    "setOpaque:");
_MTL_PRIVATE_DEF_SEL(setOpaqueTriangleIntersectionFunctionWithSignature_atIndex_,
    "setOpaqueTriangleIntersectionFunctionWithSignature:atIndex:");
_MTL_PRIVATE_DEF_SEL(setOpaqueTriangleIntersectionFunctionWithSignature_withRange_,
    "setOpaqueTriangleIntersectionFunctionWithSignature:withRange:");
_MTL_PRIVATE_DEF_SEL(setOptions_,
    "setOptions:");
_MTL_PRIVATE_DEF_SEL(setOutputNode_,
    "setOutputNode:");
_MTL_PRIVATE_DEF_SEL(setOutputURL_,
    "setOutputURL:");
_MTL_PRIVATE_DEF_SEL(setPixelFormat_,
    "setPixelFormat:");
_MTL_PRIVATE_DEF_SEL(setPreloadedLibraries_,
    "setPreloadedLibraries:");
_MTL_PRIVATE_DEF_SEL(setPreprocessorMacros_,
    "setPreprocessorMacros:");
_MTL_PRIVATE_DEF_SEL(setPreserveInvariance_,
    "setPreserveInvariance:");
_MTL_PRIVATE_DEF_SEL(setPrivateFunctions_,
    "setPrivateFunctions:");
_MTL_PRIVATE_DEF_SEL(setPurgeableState_,
    "setPurgeableState:");
_MTL_PRIVATE_DEF_SEL(setRAddressMode_,
    "setRAddressMode:");
_MTL_PRIVATE_DEF_SEL(setRasterSampleCount_,
    "setRasterSampleCount:");
_MTL_PRIVATE_DEF_SEL(setRasterizationEnabled_,
    "setRasterizationEnabled:");
_MTL_PRIVATE_DEF_SEL(setRasterizationRateMap_,
    "setRasterizationRateMap:");
_MTL_PRIVATE_DEF_SEL(setReadMask_,
    "setReadMask:");
_MTL_PRIVATE_DEF_SEL(setRenderPipelineState_,
    "setRenderPipelineState:");
_MTL_PRIVATE_DEF_SEL(setRenderPipelineState_atIndex_,
    "setRenderPipelineState:atIndex:");
_MTL_PRIVATE_DEF_SEL(setRenderPipelineStates_withRange_,
    "setRenderPipelineStates:withRange:");
_MTL_PRIVATE_DEF_SEL(setRenderTargetArrayLength_,
    "setRenderTargetArrayLength:");
_MTL_PRIVATE_DEF_SEL(setRenderTargetHeight_,
    "setRenderTargetHeight:");
_MTL_PRIVATE_DEF_SEL(setRenderTargetWidth_,
    "setRenderTargetWidth:");
_MTL_PRIVATE_DEF_SEL(setResolveDepthPlane_,
    "setResolveDepthPlane:");
_MTL_PRIVATE_DEF_SEL(setResolveLevel_,
    "setResolveLevel:");
_MTL_PRIVATE_DEF_SEL(setResolveSlice_,
    "setResolveSlice:");
_MTL_PRIVATE_DEF_SEL(setResolveTexture_,
    "setResolveTexture:");
_MTL_PRIVATE_DEF_SEL(setResourceOptions_,
    "setResourceOptions:");
_MTL_PRIVATE_DEF_SEL(setRetainedReferences_,
    "setRetainedReferences:");
_MTL_PRIVATE_DEF_SEL(setRgbBlendOperation_,
    "setRgbBlendOperation:");
_MTL_PRIVATE_DEF_SEL(setSAddressMode_,
    "setSAddressMode:");
_MTL_PRIVATE_DEF_SEL(setSampleBuffer_,
    "setSampleBuffer:");
_MTL_PRIVATE_DEF_SEL(setSampleCount_,
    "setSampleCount:");
_MTL_PRIVATE_DEF_SEL(setSamplePositions_count_,
    "setSamplePositions:count:");
_MTL_PRIVATE_DEF_SEL(setSamplerState_atIndex_,
    "setSamplerState:atIndex:");
_MTL_PRIVATE_DEF_SEL(setSamplerState_lodMinClamp_lodMaxClamp_atIndex_,
    "setSamplerState:lodMinClamp:lodMaxClamp:atIndex:");
_MTL_PRIVATE_DEF_SEL(setSamplerStates_lodMinClamps_lodMaxClamps_withRange_,
    "setSamplerStates:lodMinClamps:lodMaxClamps:withRange:");
_MTL_PRIVATE_DEF_SEL(setSamplerStates_withRange_,
    "setSamplerStates:withRange:");
_MTL_PRIVATE_DEF_SEL(setScissorRect_,
    "setScissorRect:");
_MTL_PRIVATE_DEF_SEL(setScissorRects_count_,
    "setScissorRects:count:");
_MTL_PRIVATE_DEF_SEL(setScreenSize_,
    "setScreenSize:");
_MTL_PRIVATE_DEF_SEL(setSignaledValue_,
    "setSignaledValue:");
_MTL_PRIVATE_DEF_SEL(setSize_,
    "setSize:");
_MTL_PRIVATE_DEF_SEL(setSlice_,
    "setSlice:");
_MTL_PRIVATE_DEF_SEL(setSourceAlphaBlendFactor_,
    "setSourceAlphaBlendFactor:");
_MTL_PRIVATE_DEF_SEL(setSourceRGBBlendFactor_,
    "setSourceRGBBlendFactor:");
_MTL_PRIVATE_DEF_SEL(setSpecializedName_,
    "setSpecializedName:");
_MTL_PRIVATE_DEF_SEL(setStageInRegion_,
    "setStageInRegion:");
_MTL_PRIVATE_DEF_SEL(setStageInRegionWithIndirectBuffer_indirectBufferOffset_,
    "setStageInRegionWithIndirectBuffer:indirectBufferOffset:");
_MTL_PRIVATE_DEF_SEL(setStageInputDescriptor_,
    "setStageInputDescriptor:");
_MTL_PRIVATE_DEF_SEL(setStartOfEncoderSampleIndex_,
    "setStartOfEncoderSampleIndex:");
_MTL_PRIVATE_DEF_SEL(setStartOfFragmentSampleIndex_,
    "setStartOfFragmentSampleIndex:");
_MTL_PRIVATE_DEF_SEL(setStartOfVertexSampleIndex_,
    "setStartOfVertexSampleIndex:");
_MTL_PRIVATE_DEF_SEL(setStencilAttachment_,
    "setStencilAttachment:");
_MTL_PRIVATE_DEF_SEL(setStencilAttachmentPixelFormat_,
    "setStencilAttachmentPixelFormat:");
_MTL_PRIVATE_DEF_SEL(setStencilCompareFunction_,
    "setStencilCompareFunction:");
_MTL_PRIVATE_DEF_SEL(setStencilFailureOperation_,
    "setStencilFailureOperation:");
_MTL_PRIVATE_DEF_SEL(setStencilFrontReferenceValue_backReferenceValue_,
    "setStencilFrontReferenceValue:backReferenceValue:");
_MTL_PRIVATE_DEF_SEL(setStencilReferenceValue_,
    "setStencilReferenceValue:");
_MTL_PRIVATE_DEF_SEL(setStencilResolveFilter_,
    "setStencilResolveFilter:");
_MTL_PRIVATE_DEF_SEL(setStencilStoreAction_,
    "setStencilStoreAction:");
_MTL_PRIVATE_DEF_SEL(setStencilStoreActionOptions_,
    "setStencilStoreActionOptions:");
_MTL_PRIVATE_DEF_SEL(setStepFunction_,
    "setStepFunction:");
_MTL_PRIVATE_DEF_SEL(setStepRate_,
    "setStepRate:");
_MTL_PRIVATE_DEF_SEL(setStorageMode_,
    "setStorageMode:");
_MTL_PRIVATE_DEF_SEL(setStoreAction_,
    "setStoreAction:");
_MTL_PRIVATE_DEF_SEL(setStoreActionOptions_,
    "setStoreActionOptions:");
_MTL_PRIVATE_DEF_SEL(setStride_,
    "setStride:");
_MTL_PRIVATE_DEF_SEL(setSupportAddingBinaryFunctions_,
    "setSupportAddingBinaryFunctions:");
_MTL_PRIVATE_DEF_SEL(setSupportAddingFragmentBinaryFunctions_,
    "setSupportAddingFragmentBinaryFunctions:");
_MTL_PRIVATE_DEF_SEL(setSupportAddingVertexBinaryFunctions_,
    "setSupportAddingVertexBinaryFunctions:");
_MTL_PRIVATE_DEF_SEL(setSupportArgumentBuffers_,
    "setSupportArgumentBuffers:");
_MTL_PRIVATE_DEF_SEL(setSupportIndirectCommandBuffers_,
    "setSupportIndirectCommandBuffers:");
_MTL_PRIVATE_DEF_SEL(setSwizzle_,
    "setSwizzle:");
_MTL_PRIVATE_DEF_SEL(setTAddressMode_,
    "setTAddressMode:");
_MTL_PRIVATE_DEF_SEL(setTessellationControlPointIndexType_,
    "setTessellationControlPointIndexType:");
_MTL_PRIVATE_DEF_SEL(setTessellationFactorBuffer_offset_instanceStride_,
    "setTessellationFactorBuffer:offset:instanceStride:");
_MTL_PRIVATE_DEF_SEL(setTessellationFactorFormat_,
    "setTessellationFactorFormat:");
_MTL_PRIVATE_DEF_SEL(setTessellationFactorScale_,
    "setTessellationFactorScale:");
_MTL_PRIVATE_DEF_SEL(setTessellationFactorScaleEnabled_,
    "setTessellationFactorScaleEnabled:");
_MTL_PRIVATE_DEF_SEL(setTessellationFactorStepFunction_,
    "setTessellationFactorStepFunction:");
_MTL_PRIVATE_DEF_SEL(setTessellationOutputWindingOrder_,
    "setTessellationOutputWindingOrder:");
_MTL_PRIVATE_DEF_SEL(setTessellationPartitionMode_,
    "setTessellationPartitionMode:");
_MTL_PRIVATE_DEF_SEL(setTexture_,
    "setTexture:");
_MTL_PRIVATE_DEF_SEL(setTexture_atIndex_,
    "setTexture:atIndex:");
_MTL_PRIVATE_DEF_SEL(setTextureType_,
    "setTextureType:");
_MTL_PRIVATE_DEF_SEL(setTextures_withRange_,
    "setTextures:withRange:");
_MTL_PRIVATE_DEF_SEL(setThreadGroupSizeIsMultipleOfThreadExecutionWidth_,
    "setThreadGroupSizeIsMultipleOfThreadExecutionWidth:");
_MTL_PRIVATE_DEF_SEL(setThreadgroupMemoryLength_,
    "setThreadgroupMemoryLength:");
_MTL_PRIVATE_DEF_SEL(setThreadgroupMemoryLength_atIndex_,
    "setThreadgroupMemoryLength:atIndex:");
_MTL_PRIVATE_DEF_SEL(setThreadgroupMemoryLength_offset_atIndex_,
    "setThreadgroupMemoryLength:offset:atIndex:");
_MTL_PRIVATE_DEF_SEL(setThreadgroupSizeMatchesTileSize_,
    "setThreadgroupSizeMatchesTileSize:");
_MTL_PRIVATE_DEF_SEL(setTileAccelerationStructure_atBufferIndex_,
    "setTileAccelerationStructure:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setTileAdditionalBinaryFunctions_,
    "setTileAdditionalBinaryFunctions:");
_MTL_PRIVATE_DEF_SEL(setTileBuffer_offset_atIndex_,
    "setTileBuffer:offset:atIndex:");
_MTL_PRIVATE_DEF_SEL(setTileBufferOffset_atIndex_,
    "setTileBufferOffset:atIndex:");
_MTL_PRIVATE_DEF_SEL(setTileBuffers_offsets_withRange_,
    "setTileBuffers:offsets:withRange:");
_MTL_PRIVATE_DEF_SEL(setTileBytes_length_atIndex_,
    "setTileBytes:length:atIndex:");
_MTL_PRIVATE_DEF_SEL(setTileFunction_,
    "setTileFunction:");
_MTL_PRIVATE_DEF_SEL(setTileHeight_,
    "setTileHeight:");
_MTL_PRIVATE_DEF_SEL(setTileIntersectionFunctionTable_atBufferIndex_,
    "setTileIntersectionFunctionTable:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setTileIntersectionFunctionTables_withBufferRange_,
    "setTileIntersectionFunctionTables:withBufferRange:");
_MTL_PRIVATE_DEF_SEL(setTileSamplerState_atIndex_,
    "setTileSamplerState:atIndex:");
_MTL_PRIVATE_DEF_SEL(setTileSamplerState_lodMinClamp_lodMaxClamp_atIndex_,
    "setTileSamplerState:lodMinClamp:lodMaxClamp:atIndex:");
_MTL_PRIVATE_DEF_SEL(setTileSamplerStates_lodMinClamps_lodMaxClamps_withRange_,
    "setTileSamplerStates:lodMinClamps:lodMaxClamps:withRange:");
_MTL_PRIVATE_DEF_SEL(setTileSamplerStates_withRange_,
    "setTileSamplerStates:withRange:");
_MTL_PRIVATE_DEF_SEL(setTileTexture_atIndex_,
    "setTileTexture:atIndex:");
_MTL_PRIVATE_DEF_SEL(setTileTextures_withRange_,
    "setTileTextures:withRange:");
_MTL_PRIVATE_DEF_SEL(setTileVisibleFunctionTable_atBufferIndex_,
    "setTileVisibleFunctionTable:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setTileVisibleFunctionTables_withBufferRange_,
    "setTileVisibleFunctionTables:withBufferRange:");
_MTL_PRIVATE_DEF_SEL(setTileWidth_,
    "setTileWidth:");
_MTL_PRIVATE_DEF_SEL(setTriangleCount_,
    "setTriangleCount:");
_MTL_PRIVATE_DEF_SEL(setTriangleFillMode_,
    "setTriangleFillMode:");
_MTL_PRIVATE_DEF_SEL(setType_,
    "setType:");
_MTL_PRIVATE_DEF_SEL(setUrl_,
    "setUrl:");
_MTL_PRIVATE_DEF_SEL(setUsage_,
    "setUsage:");
_MTL_PRIVATE_DEF_SEL(setVertexAccelerationStructure_atBufferIndex_,
    "setVertexAccelerationStructure:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setVertexAdditionalBinaryFunctions_,
    "setVertexAdditionalBinaryFunctions:");
_MTL_PRIVATE_DEF_SEL(setVertexAmplificationCount_viewMappings_,
    "setVertexAmplificationCount:viewMappings:");
_MTL_PRIVATE_DEF_SEL(setVertexBuffer_,
    "setVertexBuffer:");
_MTL_PRIVATE_DEF_SEL(setVertexBuffer_offset_atIndex_,
    "setVertexBuffer:offset:atIndex:");
_MTL_PRIVATE_DEF_SEL(setVertexBufferOffset_,
    "setVertexBufferOffset:");
_MTL_PRIVATE_DEF_SEL(setVertexBufferOffset_atIndex_,
    "setVertexBufferOffset:atIndex:");
_MTL_PRIVATE_DEF_SEL(setVertexBuffers_,
    "setVertexBuffers:");
_MTL_PRIVATE_DEF_SEL(setVertexBuffers_offsets_withRange_,
    "setVertexBuffers:offsets:withRange:");
_MTL_PRIVATE_DEF_SEL(setVertexBytes_length_atIndex_,
    "setVertexBytes:length:atIndex:");
_MTL_PRIVATE_DEF_SEL(setVertexDescriptor_,
    "setVertexDescriptor:");
_MTL_PRIVATE_DEF_SEL(setVertexFunction_,
    "setVertexFunction:");
_MTL_PRIVATE_DEF_SEL(setVertexIntersectionFunctionTable_atBufferIndex_,
    "setVertexIntersectionFunctionTable:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setVertexIntersectionFunctionTables_withBufferRange_,
    "setVertexIntersectionFunctionTables:withBufferRange:");
_MTL_PRIVATE_DEF_SEL(setVertexLinkedFunctions_,
    "setVertexLinkedFunctions:");
_MTL_PRIVATE_DEF_SEL(setVertexPreloadedLibraries_,
    "setVertexPreloadedLibraries:");
_MTL_PRIVATE_DEF_SEL(setVertexSamplerState_atIndex_,
    "setVertexSamplerState:atIndex:");
_MTL_PRIVATE_DEF_SEL(setVertexSamplerState_lodMinClamp_lodMaxClamp_atIndex_,
    "setVertexSamplerState:lodMinClamp:lodMaxClamp:atIndex:");
_MTL_PRIVATE_DEF_SEL(setVertexSamplerStates_lodMinClamps_lodMaxClamps_withRange_,
    "setVertexSamplerStates:lodMinClamps:lodMaxClamps:withRange:");
_MTL_PRIVATE_DEF_SEL(setVertexSamplerStates_withRange_,
    "setVertexSamplerStates:withRange:");
_MTL_PRIVATE_DEF_SEL(setVertexStride_,
    "setVertexStride:");
_MTL_PRIVATE_DEF_SEL(setVertexTexture_atIndex_,
    "setVertexTexture:atIndex:");
_MTL_PRIVATE_DEF_SEL(setVertexTextures_withRange_,
    "setVertexTextures:withRange:");
_MTL_PRIVATE_DEF_SEL(setVertexVisibleFunctionTable_atBufferIndex_,
    "setVertexVisibleFunctionTable:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setVertexVisibleFunctionTables_withBufferRange_,
    "setVertexVisibleFunctionTables:withBufferRange:");
_MTL_PRIVATE_DEF_SEL(setViewport_,
    "setViewport:");
_MTL_PRIVATE_DEF_SEL(setViewports_count_,
    "setViewports:count:");
_MTL_PRIVATE_DEF_SEL(setVisibilityResultBuffer_,
    "setVisibilityResultBuffer:");
_MTL_PRIVATE_DEF_SEL(setVisibilityResultMode_offset_,
    "setVisibilityResultMode:offset:");
_MTL_PRIVATE_DEF_SEL(setVisibleFunctionTable_atBufferIndex_,
    "setVisibleFunctionTable:atBufferIndex:");
_MTL_PRIVATE_DEF_SEL(setVisibleFunctionTable_atIndex_,
    "setVisibleFunctionTable:atIndex:");
_MTL_PRIVATE_DEF_SEL(setVisibleFunctionTables_withBufferRange_,
    "setVisibleFunctionTables:withBufferRange:");
_MTL_PRIVATE_DEF_SEL(setVisibleFunctionTables_withRange_,
    "setVisibleFunctionTables:withRange:");
_MTL_PRIVATE_DEF_SEL(setWidth_,
    "setWidth:");
_MTL_PRIVATE_DEF_SEL(setWriteMask_,
    "setWriteMask:");
_MTL_PRIVATE_DEF_SEL(sharedCaptureManager,
    "sharedCaptureManager");
_MTL_PRIVATE_DEF_SEL(signaledValue,
    "signaledValue");
_MTL_PRIVATE_DEF_SEL(size,
    "size");
_MTL_PRIVATE_DEF_SEL(slice,
    "slice");
_MTL_PRIVATE_DEF_SEL(sourceAlphaBlendFactor,
    "sourceAlphaBlendFactor");
_MTL_PRIVATE_DEF_SEL(sourceRGBBlendFactor,
    "sourceRGBBlendFactor");
_MTL_PRIVATE_DEF_SEL(sparseTileSizeInBytes,
    "sparseTileSizeInBytes");
_MTL_PRIVATE_DEF_SEL(sparseTileSizeWithTextureType_pixelFormat_sampleCount_,
    "sparseTileSizeWithTextureType:pixelFormat:sampleCount:");
_MTL_PRIVATE_DEF_SEL(specializedName,
    "specializedName");
_MTL_PRIVATE_DEF_SEL(stageInputAttributes,
    "stageInputAttributes");
_MTL_PRIVATE_DEF_SEL(stageInputDescriptor,
    "stageInputDescriptor");
_MTL_PRIVATE_DEF_SEL(stageInputOutputDescriptor,
    "stageInputOutputDescriptor");
_MTL_PRIVATE_DEF_SEL(startCaptureWithCommandQueue_,
    "startCaptureWithCommandQueue:");
_MTL_PRIVATE_DEF_SEL(startCaptureWithDescriptor_error_,
    "startCaptureWithDescriptor:error:");
_MTL_PRIVATE_DEF_SEL(startCaptureWithDevice_,
    "startCaptureWithDevice:");
_MTL_PRIVATE_DEF_SEL(startCaptureWithScope_,
    "startCaptureWithScope:");
_MTL_PRIVATE_DEF_SEL(startOfEncoderSampleIndex,
    "startOfEncoderSampleIndex");
_MTL_PRIVATE_DEF_SEL(startOfFragmentSampleIndex,
    "startOfFragmentSampleIndex");
_MTL_PRIVATE_DEF_SEL(startOfVertexSampleIndex,
    "startOfVertexSampleIndex");
_MTL_PRIVATE_DEF_SEL(staticThreadgroupMemoryLength,
    "staticThreadgroupMemoryLength");
_MTL_PRIVATE_DEF_SEL(status,
    "status");
_MTL_PRIVATE_DEF_SEL(stencilAttachment,
    "stencilAttachment");
_MTL_PRIVATE_DEF_SEL(stencilAttachmentPixelFormat,
    "stencilAttachmentPixelFormat");
_MTL_PRIVATE_DEF_SEL(stencilCompareFunction,
    "stencilCompareFunction");
_MTL_PRIVATE_DEF_SEL(stencilFailureOperation,
    "stencilFailureOperation");
_MTL_PRIVATE_DEF_SEL(stencilResolveFilter,
    "stencilResolveFilter");
_MTL_PRIVATE_DEF_SEL(stepFunction,
    "stepFunction");
_MTL_PRIVATE_DEF_SEL(stepRate,
    "stepRate");
_MTL_PRIVATE_DEF_SEL(stopCapture,
    "stopCapture");
_MTL_PRIVATE_DEF_SEL(storageMode,
    "storageMode");
_MTL_PRIVATE_DEF_SEL(storeAction,
    "storeAction");
_MTL_PRIVATE_DEF_SEL(storeActionOptions,
    "storeActionOptions");
_MTL_PRIVATE_DEF_SEL(stride,
    "stride");
_MTL_PRIVATE_DEF_SEL(structType,
    "structType");
_MTL_PRIVATE_DEF_SEL(supportAddingBinaryFunctions,
    "supportAddingBinaryFunctions");
_MTL_PRIVATE_DEF_SEL(supportAddingFragmentBinaryFunctions,
    "supportAddingFragmentBinaryFunctions");
_MTL_PRIVATE_DEF_SEL(supportAddingVertexBinaryFunctions,
    "supportAddingVertexBinaryFunctions");
_MTL_PRIVATE_DEF_SEL(supportArgumentBuffers,
    "supportArgumentBuffers");
_MTL_PRIVATE_DEF_SEL(supportIndirectCommandBuffers,
    "supportIndirectCommandBuffers");
_MTL_PRIVATE_DEF_SEL(supports32BitFloatFiltering,
    "supports32BitFloatFiltering");
_MTL_PRIVATE_DEF_SEL(supports32BitMSAA,
    "supports32BitMSAA");
_MTL_PRIVATE_DEF_SEL(supportsBCTextureCompression,
    "supportsBCTextureCompression");
_MTL_PRIVATE_DEF_SEL(supportsCounterSampling_,
    "supportsCounterSampling:");
_MTL_PRIVATE_DEF_SEL(supportsDestination_,
    "supportsDestination:");
_MTL_PRIVATE_DEF_SEL(supportsDynamicLibraries,
    "supportsDynamicLibraries");
_MTL_PRIVATE_DEF_SEL(supportsFamily_,
    "supportsFamily:");
_MTL_PRIVATE_DEF_SEL(supportsFeatureSet_,
    "supportsFeatureSet:");
_MTL_PRIVATE_DEF_SEL(supportsFunctionPointers,
    "supportsFunctionPointers");
_MTL_PRIVATE_DEF_SEL(supportsFunctionPointersFromRender,
    "supportsFunctionPointersFromRender");
_MTL_PRIVATE_DEF_SEL(supportsPrimitiveMotionBlur,
    "supportsPrimitiveMotionBlur");
_MTL_PRIVATE_DEF_SEL(supportsPullModelInterpolation,
    "supportsPullModelInterpolation");
_MTL_PRIVATE_DEF_SEL(supportsQueryTextureLOD,
    "supportsQueryTextureLOD");
_MTL_PRIVATE_DEF_SEL(supportsRasterizationRateMapWithLayerCount_,
    "supportsRasterizationRateMapWithLayerCount:");
_MTL_PRIVATE_DEF_SEL(supportsRaytracing,
    "supportsRaytracing");
_MTL_PRIVATE_DEF_SEL(supportsRaytracingFromRender,
    "supportsRaytracingFromRender");
_MTL_PRIVATE_DEF_SEL(supportsRenderDynamicLibraries,
    "supportsRenderDynamicLibraries");
_MTL_PRIVATE_DEF_SEL(supportsShaderBarycentricCoordinates,
    "supportsShaderBarycentricCoordinates");
_MTL_PRIVATE_DEF_SEL(supportsTextureSampleCount_,
    "supportsTextureSampleCount:");
_MTL_PRIVATE_DEF_SEL(supportsVertexAmplificationCount_,
    "supportsVertexAmplificationCount:");
_MTL_PRIVATE_DEF_SEL(swizzle,
    "swizzle");
_MTL_PRIVATE_DEF_SEL(synchronizeResource_,
    "synchronizeResource:");
_MTL_PRIVATE_DEF_SEL(synchronizeTexture_slice_level_,
    "synchronizeTexture:slice:level:");
_MTL_PRIVATE_DEF_SEL(tAddressMode,
    "tAddressMode");
_MTL_PRIVATE_DEF_SEL(tailSizeInBytes,
    "tailSizeInBytes");
_MTL_PRIVATE_DEF_SEL(tessellationControlPointIndexType,
    "tessellationControlPointIndexType");
_MTL_PRIVATE_DEF_SEL(tessellationFactorFormat,
    "tessellationFactorFormat");
_MTL_PRIVATE_DEF_SEL(tessellationFactorStepFunction,
    "tessellationFactorStepFunction");
_MTL_PRIVATE_DEF_SEL(tessellationOutputWindingOrder,
    "tessellationOutputWindingOrder");
_MTL_PRIVATE_DEF_SEL(tessellationPartitionMode,
    "tessellationPartitionMode");
_MTL_PRIVATE_DEF_SEL(texture,
    "texture");
_MTL_PRIVATE_DEF_SEL(texture2DDescriptorWithPixelFormat_width_height_mipmapped_,
    "texture2DDescriptorWithPixelFormat:width:height:mipmapped:");
_MTL_PRIVATE_DEF_SEL(textureBarrier,
    "textureBarrier");
_MTL_PRIVATE_DEF_SEL(textureBufferDescriptorWithPixelFormat_width_resourceOptions_usage_,
    "textureBufferDescriptorWithPixelFormat:width:resourceOptions:usage:");
_MTL_PRIVATE_DEF_SEL(textureCubeDescriptorWithPixelFormat_size_mipmapped_,
    "textureCubeDescriptorWithPixelFormat:size:mipmapped:");
_MTL_PRIVATE_DEF_SEL(textureDataType,
    "textureDataType");
_MTL_PRIVATE_DEF_SEL(textureReferenceType,
    "textureReferenceType");
_MTL_PRIVATE_DEF_SEL(textureType,
    "textureType");
_MTL_PRIVATE_DEF_SEL(threadExecutionWidth,
    "threadExecutionWidth");
_MTL_PRIVATE_DEF_SEL(threadGroupSizeIsMultipleOfThreadExecutionWidth,
    "threadGroupSizeIsMultipleOfThreadExecutionWidth");
_MTL_PRIVATE_DEF_SEL(threadgroupMemoryAlignment,
    "threadgroupMemoryAlignment");
_MTL_PRIVATE_DEF_SEL(threadgroupMemoryDataSize,
    "threadgroupMemoryDataSize");
_MTL_PRIVATE_DEF_SEL(threadgroupMemoryLength,
    "threadgroupMemoryLength");
_MTL_PRIVATE_DEF_SEL(threadgroupSizeMatchesTileSize,
    "threadgroupSizeMatchesTileSize");
_MTL_PRIVATE_DEF_SEL(tileAdditionalBinaryFunctions,
    "tileAdditionalBinaryFunctions");
_MTL_PRIVATE_DEF_SEL(tileArguments,
    "tileArguments");
_MTL_PRIVATE_DEF_SEL(tileBuffers,
    "tileBuffers");
_MTL_PRIVATE_DEF_SEL(tileFunction,
    "tileFunction");
_MTL_PRIVATE_DEF_SEL(tileHeight,
    "tileHeight");
_MTL_PRIVATE_DEF_SEL(tileWidth,
    "tileWidth");
_MTL_PRIVATE_DEF_SEL(triangleCount,
    "triangleCount");
_MTL_PRIVATE_DEF_SEL(type,
    "type");
_MTL_PRIVATE_DEF_SEL(updateFence_,
    "updateFence:");
_MTL_PRIVATE_DEF_SEL(updateFence_afterStages_,
    "updateFence:afterStages:");
_MTL_PRIVATE_DEF_SEL(updateTextureMapping_mode_indirectBuffer_indirectBufferOffset_,
    "updateTextureMapping:mode:indirectBuffer:indirectBufferOffset:");
_MTL_PRIVATE_DEF_SEL(updateTextureMapping_mode_region_mipLevel_slice_,
    "updateTextureMapping:mode:region:mipLevel:slice:");
_MTL_PRIVATE_DEF_SEL(updateTextureMappings_mode_regions_mipLevels_slices_numRegions_,
    "updateTextureMappings:mode:regions:mipLevels:slices:numRegions:");
_MTL_PRIVATE_DEF_SEL(url,
    "url");
_MTL_PRIVATE_DEF_SEL(usage,
    "usage");
_MTL_PRIVATE_DEF_SEL(useHeap_,
    "useHeap:");
_MTL_PRIVATE_DEF_SEL(useHeap_stages_,
    "useHeap:stages:");
_MTL_PRIVATE_DEF_SEL(useHeaps_count_,
    "useHeaps:count:");
_MTL_PRIVATE_DEF_SEL(useHeaps_count_stages_,
    "useHeaps:count:stages:");
_MTL_PRIVATE_DEF_SEL(useResource_usage_,
    "useResource:usage:");
_MTL_PRIVATE_DEF_SEL(useResource_usage_stages_,
    "useResource:usage:stages:");
_MTL_PRIVATE_DEF_SEL(useResources_count_usage_,
    "useResources:count:usage:");
_MTL_PRIVATE_DEF_SEL(useResources_count_usage_stages_,
    "useResources:count:usage:stages:");
_MTL_PRIVATE_DEF_SEL(usedSize,
    "usedSize");
_MTL_PRIVATE_DEF_SEL(vertexAdditionalBinaryFunctions,
    "vertexAdditionalBinaryFunctions");
_MTL_PRIVATE_DEF_SEL(vertexArguments,
    "vertexArguments");
_MTL_PRIVATE_DEF_SEL(vertexAttributes,
    "vertexAttributes");
_MTL_PRIVATE_DEF_SEL(vertexBuffer,
    "vertexBuffer");
_MTL_PRIVATE_DEF_SEL(vertexBufferOffset,
    "vertexBufferOffset");
_MTL_PRIVATE_DEF_SEL(vertexBuffers,
    "vertexBuffers");
_MTL_PRIVATE_DEF_SEL(vertexDescriptor,
    "vertexDescriptor");
_MTL_PRIVATE_DEF_SEL(vertexFunction,
    "vertexFunction");
_MTL_PRIVATE_DEF_SEL(vertexLinkedFunctions,
    "vertexLinkedFunctions");
_MTL_PRIVATE_DEF_SEL(vertexPreloadedLibraries,
    "vertexPreloadedLibraries");
_MTL_PRIVATE_DEF_SEL(vertexStride,
    "vertexStride");
_MTL_PRIVATE_DEF_SEL(vertical,
    "vertical");
_MTL_PRIVATE_DEF_SEL(verticalSampleStorage,
    "verticalSampleStorage");
_MTL_PRIVATE_DEF_SEL(visibilityResultBuffer,
    "visibilityResultBuffer");
_MTL_PRIVATE_DEF_SEL(visibleFunctionTableDescriptor,
    "visibleFunctionTableDescriptor");
_MTL_PRIVATE_DEF_SEL(waitForFence_,
    "waitForFence:");
_MTL_PRIVATE_DEF_SEL(waitForFence_beforeStages_,
    "waitForFence:beforeStages:");
_MTL_PRIVATE_DEF_SEL(waitUntilCompleted,
    "waitUntilCompleted");
_MTL_PRIVATE_DEF_SEL(waitUntilScheduled,
    "waitUntilScheduled");
_MTL_PRIVATE_DEF_SEL(width,
    "width");
_MTL_PRIVATE_DEF_SEL(writeCompactedAccelerationStructureSize_toBuffer_offset_,
    "writeCompactedAccelerationStructureSize:toBuffer:offset:");
_MTL_PRIVATE_DEF_SEL(writeCompactedAccelerationStructureSize_toBuffer_offset_sizeDataType_,
    "writeCompactedAccelerationStructureSize:toBuffer:offset:sizeDataType:");
_MTL_PRIVATE_DEF_SEL(writeMask,
    "writeMask");

}

#include <CoreFoundation/CoreFoundation.h>
#include <functional>

namespace MTL
{
class Drawable;
using DrawablePresentedHandler = void (^)(class Drawable*);

using DrawablePresentedHandlerFunction = std::function<void(class Drawable*)>;

class Drawable : public NS::Referencing<Drawable>
{
public:
    void           addPresentedHandler(const MTL::DrawablePresentedHandlerFunction& function);

    void           present();

    void           presentAtTime(CFTimeInterval presentationTime);

    void           presentAfterMinimumDuration(CFTimeInterval duration);

    void           addPresentedHandler(const MTL::DrawablePresentedHandler block);

    CFTimeInterval presentedTime() const;

    NS::UInteger   drawableID() const;
};

}

_MTL_INLINE void MTL::Drawable::addPresentedHandler(const MTL::DrawablePresentedHandlerFunction& function)
{
    __block DrawablePresentedHandlerFunction blockFunction = function;

    addPresentedHandler(^(Drawable* pDrawable) { blockFunction(pDrawable); });
}

_MTL_INLINE void MTL::Drawable::present()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(present));
}

_MTL_INLINE void MTL::Drawable::presentAtTime(CFTimeInterval presentationTime)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(presentAtTime_), presentationTime);
}

_MTL_INLINE void MTL::Drawable::presentAfterMinimumDuration(CFTimeInterval duration)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(presentAfterMinimumDuration_), duration);
}

_MTL_INLINE void MTL::Drawable::addPresentedHandler(const MTL::DrawablePresentedHandler block)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(addPresentedHandler_), block);
}

_MTL_INLINE CFTimeInterval MTL::Drawable::presentedTime() const
{
    return Object::sendMessage<CFTimeInterval>(this, _MTL_PRIVATE_SEL(presentedTime));
}

_MTL_INLINE NS::UInteger MTL::Drawable::drawableID() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(drawableID));
}

#pragma once

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, PixelFormat) {
    PixelFormatInvalid = 0,
    PixelFormatA8Unorm = 1,
    PixelFormatR8Unorm = 10,
    PixelFormatR8Unorm_sRGB = 11,
    PixelFormatR8Snorm = 12,
    PixelFormatR8Uint = 13,
    PixelFormatR8Sint = 14,
    PixelFormatR16Unorm = 20,
    PixelFormatR16Snorm = 22,
    PixelFormatR16Uint = 23,
    PixelFormatR16Sint = 24,
    PixelFormatR16Float = 25,
    PixelFormatRG8Unorm = 30,
    PixelFormatRG8Unorm_sRGB = 31,
    PixelFormatRG8Snorm = 32,
    PixelFormatRG8Uint = 33,
    PixelFormatRG8Sint = 34,
    PixelFormatB5G6R5Unorm = 40,
    PixelFormatA1BGR5Unorm = 41,
    PixelFormatABGR4Unorm = 42,
    PixelFormatBGR5A1Unorm = 43,
    PixelFormatR32Uint = 53,
    PixelFormatR32Sint = 54,
    PixelFormatR32Float = 55,
    PixelFormatRG16Unorm = 60,
    PixelFormatRG16Snorm = 62,
    PixelFormatRG16Uint = 63,
    PixelFormatRG16Sint = 64,
    PixelFormatRG16Float = 65,
    PixelFormatRGBA8Unorm = 70,
    PixelFormatRGBA8Unorm_sRGB = 71,
    PixelFormatRGBA8Snorm = 72,
    PixelFormatRGBA8Uint = 73,
    PixelFormatRGBA8Sint = 74,
    PixelFormatBGRA8Unorm = 80,
    PixelFormatBGRA8Unorm_sRGB = 81,
    PixelFormatRGB10A2Unorm = 90,
    PixelFormatRGB10A2Uint = 91,
    PixelFormatRG11B10Float = 92,
    PixelFormatRGB9E5Float = 93,
    PixelFormatBGR10A2Unorm = 94,
    PixelFormatRG32Uint = 103,
    PixelFormatRG32Sint = 104,
    PixelFormatRG32Float = 105,
    PixelFormatRGBA16Unorm = 110,
    PixelFormatRGBA16Snorm = 112,
    PixelFormatRGBA16Uint = 113,
    PixelFormatRGBA16Sint = 114,
    PixelFormatRGBA16Float = 115,
    PixelFormatRGBA32Uint = 123,
    PixelFormatRGBA32Sint = 124,
    PixelFormatRGBA32Float = 125,
    PixelFormatBC1_RGBA = 130,
    PixelFormatBC1_RGBA_sRGB = 131,
    PixelFormatBC2_RGBA = 132,
    PixelFormatBC2_RGBA_sRGB = 133,
    PixelFormatBC3_RGBA = 134,
    PixelFormatBC3_RGBA_sRGB = 135,
    PixelFormatBC4_RUnorm = 140,
    PixelFormatBC4_RSnorm = 141,
    PixelFormatBC5_RGUnorm = 142,
    PixelFormatBC5_RGSnorm = 143,
    PixelFormatBC6H_RGBFloat = 150,
    PixelFormatBC6H_RGBUfloat = 151,
    PixelFormatBC7_RGBAUnorm = 152,
    PixelFormatBC7_RGBAUnorm_sRGB = 153,
    PixelFormatPVRTC_RGB_2BPP = 160,
    PixelFormatPVRTC_RGB_2BPP_sRGB = 161,
    PixelFormatPVRTC_RGB_4BPP = 162,
    PixelFormatPVRTC_RGB_4BPP_sRGB = 163,
    PixelFormatPVRTC_RGBA_2BPP = 164,
    PixelFormatPVRTC_RGBA_2BPP_sRGB = 165,
    PixelFormatPVRTC_RGBA_4BPP = 166,
    PixelFormatPVRTC_RGBA_4BPP_sRGB = 167,
    PixelFormatEAC_R11Unorm = 170,
    PixelFormatEAC_R11Snorm = 172,
    PixelFormatEAC_RG11Unorm = 174,
    PixelFormatEAC_RG11Snorm = 176,
    PixelFormatEAC_RGBA8 = 178,
    PixelFormatEAC_RGBA8_sRGB = 179,
    PixelFormatETC2_RGB8 = 180,
    PixelFormatETC2_RGB8_sRGB = 181,
    PixelFormatETC2_RGB8A1 = 182,
    PixelFormatETC2_RGB8A1_sRGB = 183,
    PixelFormatASTC_4x4_sRGB = 186,
    PixelFormatASTC_5x4_sRGB = 187,
    PixelFormatASTC_5x5_sRGB = 188,
    PixelFormatASTC_6x5_sRGB = 189,
    PixelFormatASTC_6x6_sRGB = 190,
    PixelFormatASTC_8x5_sRGB = 192,
    PixelFormatASTC_8x6_sRGB = 193,
    PixelFormatASTC_8x8_sRGB = 194,
    PixelFormatASTC_10x5_sRGB = 195,
    PixelFormatASTC_10x6_sRGB = 196,
    PixelFormatASTC_10x8_sRGB = 197,
    PixelFormatASTC_10x10_sRGB = 198,
    PixelFormatASTC_12x10_sRGB = 199,
    PixelFormatASTC_12x12_sRGB = 200,
    PixelFormatASTC_4x4_LDR = 204,
    PixelFormatASTC_5x4_LDR = 205,
    PixelFormatASTC_5x5_LDR = 206,
    PixelFormatASTC_6x5_LDR = 207,
    PixelFormatASTC_6x6_LDR = 208,
    PixelFormatASTC_8x5_LDR = 210,
    PixelFormatASTC_8x6_LDR = 211,
    PixelFormatASTC_8x8_LDR = 212,
    PixelFormatASTC_10x5_LDR = 213,
    PixelFormatASTC_10x6_LDR = 214,
    PixelFormatASTC_10x8_LDR = 215,
    PixelFormatASTC_10x10_LDR = 216,
    PixelFormatASTC_12x10_LDR = 217,
    PixelFormatASTC_12x12_LDR = 218,
    PixelFormatASTC_4x4_HDR = 222,
    PixelFormatASTC_5x4_HDR = 223,
    PixelFormatASTC_5x5_HDR = 224,
    PixelFormatASTC_6x5_HDR = 225,
    PixelFormatASTC_6x6_HDR = 226,
    PixelFormatASTC_8x5_HDR = 228,
    PixelFormatASTC_8x6_HDR = 229,
    PixelFormatASTC_8x8_HDR = 230,
    PixelFormatASTC_10x5_HDR = 231,
    PixelFormatASTC_10x6_HDR = 232,
    PixelFormatASTC_10x8_HDR = 233,
    PixelFormatASTC_10x10_HDR = 234,
    PixelFormatASTC_12x10_HDR = 235,
    PixelFormatASTC_12x12_HDR = 236,
    PixelFormatGBGR422 = 240,
    PixelFormatBGRG422 = 241,
    PixelFormatDepth16Unorm = 250,
    PixelFormatDepth32Float = 252,
    PixelFormatStencil8 = 253,
    PixelFormatDepth24Unorm_Stencil8 = 255,
    PixelFormatDepth32Float_Stencil8 = 260,
    PixelFormatX32_Stencil8 = 261,
    PixelFormatX24_Stencil8 = 262,
    PixelFormatBGRA10_XR = 552,
    PixelFormatBGRA10_XR_sRGB = 553,
    PixelFormatBGR10_XR = 554,
    PixelFormatBGR10_XR_sRGB = 555,
};

}

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, PurgeableState) {
    PurgeableStateKeepCurrent = 1,
    PurgeableStateNonVolatile = 2,
    PurgeableStateVolatile = 3,
    PurgeableStateEmpty = 4,
};

_MTL_ENUM(NS::UInteger, CPUCacheMode) {
    CPUCacheModeDefaultCache = 0,
    CPUCacheModeWriteCombined = 1,
};

_MTL_ENUM(NS::UInteger, StorageMode) {
    StorageModeShared = 0,
    StorageModeManaged = 1,
    StorageModePrivate = 2,
    StorageModeMemoryless = 3,
};

_MTL_ENUM(NS::UInteger, HazardTrackingMode) {
    HazardTrackingModeDefault = 0,
    HazardTrackingModeUntracked = 1,
    HazardTrackingModeTracked = 2,
};

_MTL_OPTIONS(NS::UInteger, ResourceOptions) {
    ResourceStorageModeShared = 0,
    ResourceHazardTrackingModeDefault = 0,
    ResourceCPUCacheModeDefaultCache = 0,
    ResourceOptionCPUCacheModeDefault = 0,
    ResourceCPUCacheModeWriteCombined = 1,
    ResourceOptionCPUCacheModeWriteCombined = 1,
    ResourceStorageModeManaged = 16,
    ResourceStorageModePrivate = 32,
    ResourceStorageModeMemoryless = 48,
    ResourceHazardTrackingModeUntracked = 256,
    ResourceHazardTrackingModeTracked = 512,
};

class Resource : public NS::Referencing<Resource>
{
public:
    NS::String*             label() const;
    void                    setLabel(const NS::String* label);

    class Device*           device() const;

    MTL::CPUCacheMode       cpuCacheMode() const;

    MTL::StorageMode        storageMode() const;

    MTL::HazardTrackingMode hazardTrackingMode() const;

    MTL::ResourceOptions    resourceOptions() const;

    MTL::PurgeableState     setPurgeableState(MTL::PurgeableState state);

    class Heap*             heap() const;

    NS::UInteger            heapOffset() const;

    NS::UInteger            allocatedSize() const;

    void                    makeAliasable();

    bool                    isAliasable();
};

}

_MTL_INLINE NS::String* MTL::Resource::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::Resource::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::Device* MTL::Resource::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE MTL::CPUCacheMode MTL::Resource::cpuCacheMode() const
{
    return Object::sendMessage<MTL::CPUCacheMode>(this, _MTL_PRIVATE_SEL(cpuCacheMode));
}

_MTL_INLINE MTL::StorageMode MTL::Resource::storageMode() const
{
    return Object::sendMessage<MTL::StorageMode>(this, _MTL_PRIVATE_SEL(storageMode));
}

_MTL_INLINE MTL::HazardTrackingMode MTL::Resource::hazardTrackingMode() const
{
    return Object::sendMessage<MTL::HazardTrackingMode>(this, _MTL_PRIVATE_SEL(hazardTrackingMode));
}

_MTL_INLINE MTL::ResourceOptions MTL::Resource::resourceOptions() const
{
    return Object::sendMessage<MTL::ResourceOptions>(this, _MTL_PRIVATE_SEL(resourceOptions));
}

_MTL_INLINE MTL::PurgeableState MTL::Resource::setPurgeableState(MTL::PurgeableState state)
{
    return Object::sendMessage<MTL::PurgeableState>(this, _MTL_PRIVATE_SEL(setPurgeableState_), state);
}

_MTL_INLINE MTL::Heap* MTL::Resource::heap() const
{
    return Object::sendMessage<MTL::Heap*>(this, _MTL_PRIVATE_SEL(heap));
}

_MTL_INLINE NS::UInteger MTL::Resource::heapOffset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(heapOffset));
}

_MTL_INLINE NS::UInteger MTL::Resource::allocatedSize() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(allocatedSize));
}

_MTL_INLINE void MTL::Resource::makeAliasable()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(makeAliasable));
}

_MTL_INLINE bool MTL::Resource::isAliasable()
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isAliasable));
}

#pragma once

namespace MTL
{
struct Origin
{
    Origin() = default;

    Origin(NS::UInteger x, NS::UInteger y, NS::UInteger z);

    static Origin Make(NS::UInteger x, NS::UInteger y, NS::UInteger z);

    NS::UInteger  x;
    NS::UInteger  y;
    NS::UInteger  z;
} _MTL_PACKED;

struct Size
{
    Size() = default;

    Size(NS::UInteger width, NS::UInteger height, NS::UInteger depth);

    static Size  Make(NS::UInteger width, NS::UInteger height, NS::UInteger depth);

    NS::UInteger width;
    NS::UInteger height;
    NS::UInteger depth;
} _MTL_PACKED;

struct Region
{
    Region() = default;

    Region(NS::UInteger x, NS::UInteger width);

    Region(NS::UInteger x, NS::UInteger y, NS::UInteger width, NS::UInteger height);

    Region(NS::UInteger x, NS::UInteger y, NS::UInteger z, NS::UInteger width, NS::UInteger height, NS::UInteger depth);

    static Region Make1D(NS::UInteger x, NS::UInteger width);

    static Region Make2D(NS::UInteger x, NS::UInteger y, NS::UInteger width, NS::UInteger height);

    static Region Make3D(NS::UInteger x, NS::UInteger y, NS::UInteger z, NS::UInteger width, NS::UInteger height, NS::UInteger depth);

    MTL::Origin   origin;
    MTL::Size     size;
} _MTL_PACKED;

struct SamplePosition;

using Coordinate2D = SamplePosition;

struct SamplePosition
{
    SamplePosition() = default;

    SamplePosition(float _x, float _y);

    static SamplePosition Make(float x, float y);

    float                 x;
    float                 y;
} _MTL_PACKED;

}

_MTL_INLINE MTL::Origin::Origin(NS::UInteger _x, NS::UInteger _y, NS::UInteger _z)
    : x(_x)
    , y(_y)
    , z(_z)
{
}

_MTL_INLINE MTL::Origin MTL::Origin::Make(NS::UInteger x, NS::UInteger y, NS::UInteger z)
{
    return Origin(x, y, z);
}

_MTL_INLINE MTL::Size::Size(NS::UInteger _width, NS::UInteger _height, NS::UInteger _depth)
    : width(_width)
    , height(_height)
    , depth(_depth)
{
}

_MTL_INLINE MTL::Size MTL::Size::Make(NS::UInteger width, NS::UInteger height, NS::UInteger depth)
{
    return Size(width, height, depth);
}

_MTL_INLINE MTL::Region::Region(NS::UInteger x, NS::UInteger width)
    : origin(x, 0, 0)
    , size(width, 1, 1)
{
}

_MTL_INLINE MTL::Region::Region(NS::UInteger x, NS::UInteger y, NS::UInteger width, NS::UInteger height)
    : origin(x, y, 0)
    , size(width, height, 1)
{
}

_MTL_INLINE MTL::Region::Region(NS::UInteger x, NS::UInteger y, NS::UInteger z, NS::UInteger width, NS::UInteger height, NS::UInteger depth)
    : origin(x, y, z)
    , size(width, height, depth)
{
}

_MTL_INLINE MTL::Region MTL::Region::Make1D(NS::UInteger x, NS::UInteger width)
{
    return Region(x, width);
}

_MTL_INLINE MTL::Region MTL::Region::Make2D(NS::UInteger x, NS::UInteger y, NS::UInteger width, NS::UInteger height)
{
    return Region(x, y, width, height);
}

_MTL_INLINE MTL::Region MTL::Region::Make3D(NS::UInteger x, NS::UInteger y, NS::UInteger z, NS::UInteger width, NS::UInteger height, NS::UInteger depth)
{
    return Region(x, y, z, width, height, depth);
}

_MTL_INLINE MTL::SamplePosition::SamplePosition(float _x, float _y)
    : x(_x)
    , y(_y)
{
}

_MTL_INLINE MTL::SamplePosition MTL::SamplePosition::Make(float x, float y)
{
    return SamplePosition(x, y);
}

#include <IOSurface/IOSurfaceRef.h>

namespace MTL
{
_MTL_ENUM(NS::UInteger, TextureType) {
    TextureType1D = 0,
    TextureType1DArray = 1,
    TextureType2D = 2,
    TextureType2DArray = 3,
    TextureType2DMultisample = 4,
    TextureTypeCube = 5,
    TextureTypeCubeArray = 6,
    TextureType3D = 7,
    TextureType2DMultisampleArray = 8,
    TextureTypeTextureBuffer = 9,
};

_MTL_ENUM(uint8_t, TextureSwizzle) {
    TextureSwizzleZero = 0,
    TextureSwizzleOne = 1,
    TextureSwizzleRed = 2,
    TextureSwizzleGreen = 3,
    TextureSwizzleBlue = 4,
    TextureSwizzleAlpha = 5,
};

struct TextureSwizzleChannels
{
    MTL::TextureSwizzle red;
    MTL::TextureSwizzle green;
    MTL::TextureSwizzle blue;
    MTL::TextureSwizzle alpha;
} _MTL_PACKED;

class SharedTextureHandle : public NS::Referencing<SharedTextureHandle>
{
public:
    static class SharedTextureHandle* alloc();

    class SharedTextureHandle*        init();

    class Device*                     device() const;

    NS::String*                       label() const;
};

struct SharedTextureHandlePrivate
{
} _MTL_PACKED;

_MTL_OPTIONS(NS::UInteger, TextureUsage) {
    TextureUsageUnknown = 0,
    TextureUsageShaderRead = 1,
    TextureUsageShaderWrite = 2,
    TextureUsageRenderTarget = 4,
    TextureUsagePixelFormatView = 16,
};

_MTL_ENUM(NS::Integer, TextureCompressionType) {
    TextureCompressionTypeLossless = 0,
    TextureCompressionTypeLossy = 1,
};

class TextureDescriptor : public NS::Copying<TextureDescriptor>
{
public:
    static class TextureDescriptor* alloc();

    class TextureDescriptor*        init();

    static class TextureDescriptor* texture2DDescriptor(MTL::PixelFormat pixelFormat, NS::UInteger width, NS::UInteger height, bool mipmapped);

    static class TextureDescriptor* textureCubeDescriptor(MTL::PixelFormat pixelFormat, NS::UInteger size, bool mipmapped);

    static class TextureDescriptor* textureBufferDescriptor(MTL::PixelFormat pixelFormat, NS::UInteger width, MTL::ResourceOptions resourceOptions, MTL::TextureUsage usage);

    MTL::TextureType                textureType() const;
    void                            setTextureType(MTL::TextureType textureType);

    MTL::PixelFormat                pixelFormat() const;
    void                            setPixelFormat(MTL::PixelFormat pixelFormat);

    NS::UInteger                    width() const;
    void                            setWidth(NS::UInteger width);

    NS::UInteger                    height() const;
    void                            setHeight(NS::UInteger height);

    NS::UInteger                    depth() const;
    void                            setDepth(NS::UInteger depth);

    NS::UInteger                    mipmapLevelCount() const;
    void                            setMipmapLevelCount(NS::UInteger mipmapLevelCount);

    NS::UInteger                    sampleCount() const;
    void                            setSampleCount(NS::UInteger sampleCount);

    NS::UInteger                    arrayLength() const;
    void                            setArrayLength(NS::UInteger arrayLength);

    MTL::ResourceOptions            resourceOptions() const;
    void                            setResourceOptions(MTL::ResourceOptions resourceOptions);

    MTL::CPUCacheMode               cpuCacheMode() const;
    void                            setCpuCacheMode(MTL::CPUCacheMode cpuCacheMode);

    MTL::StorageMode                storageMode() const;
    void                            setStorageMode(MTL::StorageMode storageMode);

    MTL::HazardTrackingMode         hazardTrackingMode() const;
    void                            setHazardTrackingMode(MTL::HazardTrackingMode hazardTrackingMode);

    MTL::TextureUsage               usage() const;
    void                            setUsage(MTL::TextureUsage usage);

    bool                            allowGPUOptimizedContents() const;
    void                            setAllowGPUOptimizedContents(bool allowGPUOptimizedContents);

    MTL::TextureSwizzleChannels     swizzle() const;
    void                            setSwizzle(MTL::TextureSwizzleChannels swizzle);
};

class Texture : public NS::Referencing<Texture, Resource>
{
public:
    class Resource*             rootResource() const;

    class Texture*              parentTexture() const;

    NS::UInteger                parentRelativeLevel() const;

    NS::UInteger                parentRelativeSlice() const;

    class Buffer*               buffer() const;

    NS::UInteger                bufferOffset() const;

    NS::UInteger                bufferBytesPerRow() const;

    IOSurfaceRef                iosurface() const;

    NS::UInteger                iosurfacePlane() const;

    MTL::TextureType            textureType() const;

    MTL::PixelFormat            pixelFormat() const;

    NS::UInteger                width() const;

    NS::UInteger                height() const;

    NS::UInteger                depth() const;

    NS::UInteger                mipmapLevelCount() const;

    NS::UInteger                sampleCount() const;

    NS::UInteger                arrayLength() const;

    MTL::TextureUsage           usage() const;

    bool                        shareable() const;

    bool                        framebufferOnly() const;

    NS::UInteger                firstMipmapInTail() const;

    NS::UInteger                tailSizeInBytes() const;

    bool                        isSparse() const;

    bool                        allowGPUOptimizedContents() const;

    void                        getBytes(const void* pixelBytes, NS::UInteger bytesPerRow, NS::UInteger bytesPerImage, MTL::Region region, NS::UInteger level, NS::UInteger slice);

    void                        replaceRegion(MTL::Region region, NS::UInteger level, NS::UInteger slice, const void* pixelBytes, NS::UInteger bytesPerRow, NS::UInteger bytesPerImage);

    void                        getBytes(const void* pixelBytes, NS::UInteger bytesPerRow, MTL::Region region, NS::UInteger level);

    void                        replaceRegion(MTL::Region region, NS::UInteger level, const void* pixelBytes, NS::UInteger bytesPerRow);

    class Texture*              newTextureView(MTL::PixelFormat pixelFormat);

    class Texture*              newTextureView(MTL::PixelFormat pixelFormat, MTL::TextureType textureType, NS::Range levelRange, NS::Range sliceRange);

    class SharedTextureHandle*  newSharedTextureHandle();

    class Texture*              remoteStorageTexture() const;

    class Texture*              newRemoteTextureViewForDevice(const class Device* device);

    MTL::TextureSwizzleChannels swizzle() const;

    class Texture*              newTextureView(MTL::PixelFormat pixelFormat, MTL::TextureType textureType, NS::Range levelRange, NS::Range sliceRange, MTL::TextureSwizzleChannels swizzle);
};

}

_MTL_INLINE MTL::SharedTextureHandle* MTL::SharedTextureHandle::alloc()
{
    return NS::Object::alloc<MTL::SharedTextureHandle>(_MTL_PRIVATE_CLS(MTLSharedTextureHandle));
}

_MTL_INLINE MTL::SharedTextureHandle* MTL::SharedTextureHandle::init()
{
    return NS::Object::init<MTL::SharedTextureHandle>();
}

_MTL_INLINE MTL::Device* MTL::SharedTextureHandle::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::String* MTL::SharedTextureHandle::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE MTL::TextureDescriptor* MTL::TextureDescriptor::alloc()
{
    return NS::Object::alloc<MTL::TextureDescriptor>(_MTL_PRIVATE_CLS(MTLTextureDescriptor));
}

_MTL_INLINE MTL::TextureDescriptor* MTL::TextureDescriptor::init()
{
    return NS::Object::init<MTL::TextureDescriptor>();
}

_MTL_INLINE MTL::TextureDescriptor* MTL::TextureDescriptor::texture2DDescriptor(MTL::PixelFormat pixelFormat, NS::UInteger width, NS::UInteger height, bool mipmapped)
{
    return Object::sendMessage<MTL::TextureDescriptor*>(_MTL_PRIVATE_CLS(MTLTextureDescriptor), _MTL_PRIVATE_SEL(texture2DDescriptorWithPixelFormat_width_height_mipmapped_), pixelFormat, width, height, mipmapped);
}

_MTL_INLINE MTL::TextureDescriptor* MTL::TextureDescriptor::textureCubeDescriptor(MTL::PixelFormat pixelFormat, NS::UInteger size, bool mipmapped)
{
    return Object::sendMessage<MTL::TextureDescriptor*>(_MTL_PRIVATE_CLS(MTLTextureDescriptor), _MTL_PRIVATE_SEL(textureCubeDescriptorWithPixelFormat_size_mipmapped_), pixelFormat, size, mipmapped);
}

_MTL_INLINE MTL::TextureDescriptor* MTL::TextureDescriptor::textureBufferDescriptor(MTL::PixelFormat pixelFormat, NS::UInteger width, MTL::ResourceOptions resourceOptions, MTL::TextureUsage usage)
{
    return Object::sendMessage<MTL::TextureDescriptor*>(_MTL_PRIVATE_CLS(MTLTextureDescriptor), _MTL_PRIVATE_SEL(textureBufferDescriptorWithPixelFormat_width_resourceOptions_usage_), pixelFormat, width, resourceOptions, usage);
}

_MTL_INLINE MTL::TextureType MTL::TextureDescriptor::textureType() const
{
    return Object::sendMessage<MTL::TextureType>(this, _MTL_PRIVATE_SEL(textureType));
}

_MTL_INLINE void MTL::TextureDescriptor::setTextureType(MTL::TextureType textureType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTextureType_), textureType);
}

_MTL_INLINE MTL::PixelFormat MTL::TextureDescriptor::pixelFormat() const
{
    return Object::sendMessage<MTL::PixelFormat>(this, _MTL_PRIVATE_SEL(pixelFormat));
}

_MTL_INLINE void MTL::TextureDescriptor::setPixelFormat(MTL::PixelFormat pixelFormat)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setPixelFormat_), pixelFormat);
}

_MTL_INLINE NS::UInteger MTL::TextureDescriptor::width() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(width));
}

_MTL_INLINE void MTL::TextureDescriptor::setWidth(NS::UInteger width)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setWidth_), width);
}

_MTL_INLINE NS::UInteger MTL::TextureDescriptor::height() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(height));
}

_MTL_INLINE void MTL::TextureDescriptor::setHeight(NS::UInteger height)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setHeight_), height);
}

_MTL_INLINE NS::UInteger MTL::TextureDescriptor::depth() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(depth));
}

_MTL_INLINE void MTL::TextureDescriptor::setDepth(NS::UInteger depth)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepth_), depth);
}

_MTL_INLINE NS::UInteger MTL::TextureDescriptor::mipmapLevelCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(mipmapLevelCount));
}

_MTL_INLINE void MTL::TextureDescriptor::setMipmapLevelCount(NS::UInteger mipmapLevelCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMipmapLevelCount_), mipmapLevelCount);
}

_MTL_INLINE NS::UInteger MTL::TextureDescriptor::sampleCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(sampleCount));
}

_MTL_INLINE void MTL::TextureDescriptor::setSampleCount(NS::UInteger sampleCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSampleCount_), sampleCount);
}

_MTL_INLINE NS::UInteger MTL::TextureDescriptor::arrayLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(arrayLength));
}

_MTL_INLINE void MTL::TextureDescriptor::setArrayLength(NS::UInteger arrayLength)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setArrayLength_), arrayLength);
}

_MTL_INLINE MTL::ResourceOptions MTL::TextureDescriptor::resourceOptions() const
{
    return Object::sendMessage<MTL::ResourceOptions>(this, _MTL_PRIVATE_SEL(resourceOptions));
}

_MTL_INLINE void MTL::TextureDescriptor::setResourceOptions(MTL::ResourceOptions resourceOptions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setResourceOptions_), resourceOptions);
}

_MTL_INLINE MTL::CPUCacheMode MTL::TextureDescriptor::cpuCacheMode() const
{
    return Object::sendMessage<MTL::CPUCacheMode>(this, _MTL_PRIVATE_SEL(cpuCacheMode));
}

_MTL_INLINE void MTL::TextureDescriptor::setCpuCacheMode(MTL::CPUCacheMode cpuCacheMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setCpuCacheMode_), cpuCacheMode);
}

_MTL_INLINE MTL::StorageMode MTL::TextureDescriptor::storageMode() const
{
    return Object::sendMessage<MTL::StorageMode>(this, _MTL_PRIVATE_SEL(storageMode));
}

_MTL_INLINE void MTL::TextureDescriptor::setStorageMode(MTL::StorageMode storageMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStorageMode_), storageMode);
}

_MTL_INLINE MTL::HazardTrackingMode MTL::TextureDescriptor::hazardTrackingMode() const
{
    return Object::sendMessage<MTL::HazardTrackingMode>(this, _MTL_PRIVATE_SEL(hazardTrackingMode));
}

_MTL_INLINE void MTL::TextureDescriptor::setHazardTrackingMode(MTL::HazardTrackingMode hazardTrackingMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setHazardTrackingMode_), hazardTrackingMode);
}

_MTL_INLINE MTL::TextureUsage MTL::TextureDescriptor::usage() const
{
    return Object::sendMessage<MTL::TextureUsage>(this, _MTL_PRIVATE_SEL(usage));
}

_MTL_INLINE void MTL::TextureDescriptor::setUsage(MTL::TextureUsage usage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setUsage_), usage);
}

_MTL_INLINE bool MTL::TextureDescriptor::allowGPUOptimizedContents() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(allowGPUOptimizedContents));
}

_MTL_INLINE void MTL::TextureDescriptor::setAllowGPUOptimizedContents(bool allowGPUOptimizedContents)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setAllowGPUOptimizedContents_), allowGPUOptimizedContents);
}

_MTL_INLINE MTL::TextureSwizzleChannels MTL::TextureDescriptor::swizzle() const
{
    return Object::sendMessage<MTL::TextureSwizzleChannels>(this, _MTL_PRIVATE_SEL(swizzle));
}

_MTL_INLINE void MTL::TextureDescriptor::setSwizzle(MTL::TextureSwizzleChannels swizzle)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSwizzle_), swizzle);
}

_MTL_INLINE MTL::Resource* MTL::Texture::rootResource() const
{
    return Object::sendMessage<MTL::Resource*>(this, _MTL_PRIVATE_SEL(rootResource));
}

_MTL_INLINE MTL::Texture* MTL::Texture::parentTexture() const
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(parentTexture));
}

_MTL_INLINE NS::UInteger MTL::Texture::parentRelativeLevel() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(parentRelativeLevel));
}

_MTL_INLINE NS::UInteger MTL::Texture::parentRelativeSlice() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(parentRelativeSlice));
}

_MTL_INLINE MTL::Buffer* MTL::Texture::buffer() const
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(buffer));
}

_MTL_INLINE NS::UInteger MTL::Texture::bufferOffset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(bufferOffset));
}

_MTL_INLINE NS::UInteger MTL::Texture::bufferBytesPerRow() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(bufferBytesPerRow));
}

_MTL_INLINE IOSurfaceRef MTL::Texture::iosurface() const
{
    return Object::sendMessage<IOSurfaceRef>(this, _MTL_PRIVATE_SEL(iosurface));
}

_MTL_INLINE NS::UInteger MTL::Texture::iosurfacePlane() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(iosurfacePlane));
}

_MTL_INLINE MTL::TextureType MTL::Texture::textureType() const
{
    return Object::sendMessage<MTL::TextureType>(this, _MTL_PRIVATE_SEL(textureType));
}

_MTL_INLINE MTL::PixelFormat MTL::Texture::pixelFormat() const
{
    return Object::sendMessage<MTL::PixelFormat>(this, _MTL_PRIVATE_SEL(pixelFormat));
}

_MTL_INLINE NS::UInteger MTL::Texture::width() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(width));
}

_MTL_INLINE NS::UInteger MTL::Texture::height() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(height));
}

_MTL_INLINE NS::UInteger MTL::Texture::depth() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(depth));
}

_MTL_INLINE NS::UInteger MTL::Texture::mipmapLevelCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(mipmapLevelCount));
}

_MTL_INLINE NS::UInteger MTL::Texture::sampleCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(sampleCount));
}

_MTL_INLINE NS::UInteger MTL::Texture::arrayLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(arrayLength));
}

_MTL_INLINE MTL::TextureUsage MTL::Texture::usage() const
{
    return Object::sendMessage<MTL::TextureUsage>(this, _MTL_PRIVATE_SEL(usage));
}

_MTL_INLINE bool MTL::Texture::shareable() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isShareable));
}

_MTL_INLINE bool MTL::Texture::framebufferOnly() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isFramebufferOnly));
}

_MTL_INLINE NS::UInteger MTL::Texture::firstMipmapInTail() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(firstMipmapInTail));
}

_MTL_INLINE NS::UInteger MTL::Texture::tailSizeInBytes() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(tailSizeInBytes));
}

_MTL_INLINE bool MTL::Texture::isSparse() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isSparse));
}

_MTL_INLINE bool MTL::Texture::allowGPUOptimizedContents() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(allowGPUOptimizedContents));
}

_MTL_INLINE void MTL::Texture::getBytes(const void* pixelBytes, NS::UInteger bytesPerRow, NS::UInteger bytesPerImage, MTL::Region region, NS::UInteger level, NS::UInteger slice)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(getBytes_bytesPerRow_bytesPerImage_fromRegion_mipmapLevel_slice_), pixelBytes, bytesPerRow, bytesPerImage, region, level, slice);
}

_MTL_INLINE void MTL::Texture::replaceRegion(MTL::Region region, NS::UInteger level, NS::UInteger slice, const void* pixelBytes, NS::UInteger bytesPerRow, NS::UInteger bytesPerImage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(replaceRegion_mipmapLevel_slice_withBytes_bytesPerRow_bytesPerImage_), region, level, slice, pixelBytes, bytesPerRow, bytesPerImage);
}

_MTL_INLINE void MTL::Texture::getBytes(const void* pixelBytes, NS::UInteger bytesPerRow, MTL::Region region, NS::UInteger level)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(getBytes_bytesPerRow_fromRegion_mipmapLevel_), pixelBytes, bytesPerRow, region, level);
}

_MTL_INLINE void MTL::Texture::replaceRegion(MTL::Region region, NS::UInteger level, const void* pixelBytes, NS::UInteger bytesPerRow)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(replaceRegion_mipmapLevel_withBytes_bytesPerRow_), region, level, pixelBytes, bytesPerRow);
}

_MTL_INLINE MTL::Texture* MTL::Texture::newTextureView(MTL::PixelFormat pixelFormat)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newTextureViewWithPixelFormat_), pixelFormat);
}

_MTL_INLINE MTL::Texture* MTL::Texture::newTextureView(MTL::PixelFormat pixelFormat, MTL::TextureType textureType, NS::Range levelRange, NS::Range sliceRange)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newTextureViewWithPixelFormat_textureType_levels_slices_), pixelFormat, textureType, levelRange, sliceRange);
}

_MTL_INLINE MTL::SharedTextureHandle* MTL::Texture::newSharedTextureHandle()
{
    return Object::sendMessage<MTL::SharedTextureHandle*>(this, _MTL_PRIVATE_SEL(newSharedTextureHandle));
}

_MTL_INLINE MTL::Texture* MTL::Texture::remoteStorageTexture() const
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(remoteStorageTexture));
}

_MTL_INLINE MTL::Texture* MTL::Texture::newRemoteTextureViewForDevice(const MTL::Device* device)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newRemoteTextureViewForDevice_), device);
}

_MTL_INLINE MTL::TextureSwizzleChannels MTL::Texture::swizzle() const
{
    return Object::sendMessage<MTL::TextureSwizzleChannels>(this, _MTL_PRIVATE_SEL(swizzle));
}

_MTL_INLINE MTL::Texture* MTL::Texture::newTextureView(MTL::PixelFormat pixelFormat, MTL::TextureType textureType, NS::Range levelRange, NS::Range sliceRange, MTL::TextureSwizzleChannels swizzle)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newTextureViewWithPixelFormat_textureType_levels_slices_swizzle_), pixelFormat, textureType, levelRange, sliceRange, swizzle);
}

#define _CA_EXPORT _NS_EXPORT
#define _CA_EXTERN _NS_EXTERN
#define _CA_INLINE _NS_INLINE
#define _CA_PACKED _NS_PACKED

#define _CA_CONST(type, name) _NS_CONST(type, name)
#define _CA_ENUM(type, name) _NS_ENUM(type, name)
#define _CA_OPTIONS(type, name) _NS_OPTIONS(type, name)

#define _CA_VALIDATE_SIZE(ns, name) _NS_VALIDATE_SIZE(ns, name)
#define _CA_VALIDATE_ENUM(ns, name) _NS_VALIDATE_ENUM(ns, name)

#include <objc/runtime.h>

#define _CA_PRIVATE_CLS(symbol) (Private::Class::s_k##symbol)
#define _CA_PRIVATE_SEL(accessor) (Private::Selector::s_k##accessor)

#if defined(CA_PRIVATE_IMPLEMENTATION)

#define _CA_PRIVATE_VISIBILITY __attribute__((visibility("default")))
#define _CA_PRIVATE_IMPORT __attribute__((weak_import))

#if __OBJC__
#define _CA_PRIVATE_OBJC_LOOKUP_CLASS(symbol) ((__bridge void*)objc_lookUpClass(#symbol))
#else
#define _CA_PRIVATE_OBJC_LOOKUP_CLASS(symbol) objc_lookUpClass(#symbol)
#endif // __OBJC__

#define _CA_PRIVATE_DEF_CLS(symbol) void* s_k##symbol _CA_PRIVATE_VISIBILITY = _CA_PRIVATE_OBJC_LOOKUP_CLASS(symbol);
#define _CA_PRIVATE_DEF_PRO(symbol)
#define _CA_PRIVATE_DEF_SEL(accessor, symbol) SEL s_k##accessor _CA_PRIVATE_VISIBILITY = sel_registerName(symbol);
#define _CA_PRIVATE_DEF_STR(type, symbol)                \
    _CA_EXTERN type const CA##symbol _CA_PRIVATE_IMPORT; \
    type const                       CA::symbol = (nullptr != &CA##symbol) ? CA##symbol : nullptr;

#else

#define _CA_PRIVATE_DEF_CLS(symbol) extern void* s_k##symbol;
#define _CA_PRIVATE_DEF_PRO(symbol)
#define _CA_PRIVATE_DEF_SEL(accessor, symbol) extern SEL s_k##accessor;
#define _CA_PRIVATE_DEF_STR(type, symbol)

#endif // CA_PRIVATE_IMPLEMENTATION

namespace CA
{
namespace Private
{
    namespace Class
    {

    } // Class
} // Private
} // CA

namespace CA
{
namespace Private
{
    namespace Protocol
    {

        _CA_PRIVATE_DEF_PRO(CAMetalDrawable);

    } // Protocol
} // Private
} // CA

namespace CA
{
namespace Private
{
    namespace Selector
    {

        _CA_PRIVATE_DEF_SEL(layer,
            "layer");
        _CA_PRIVATE_DEF_SEL(texture,
            "texture");

    } // Class
} // Private
} // CA

namespace CA
{
class MetalDrawable : public NS::Referencing<MetalDrawable, MTL::Drawable>
{
public:
    class MetalLayer* layer() const;
    MTL::Texture*     texture() const;
};
}

_CA_INLINE CA::MetalLayer* CA::MetalDrawable::layer() const
{
    return Object::sendMessage<MetalLayer*>(this, _MTL_PRIVATE_SEL(layer));
}

_CA_INLINE MTL::Texture* CA::MetalDrawable::texture() const
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(texture));
}

#pragma once

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, AttributeFormat) {
    AttributeFormatInvalid = 0,
    AttributeFormatUChar2 = 1,
    AttributeFormatUChar3 = 2,
    AttributeFormatUChar4 = 3,
    AttributeFormatChar2 = 4,
    AttributeFormatChar3 = 5,
    AttributeFormatChar4 = 6,
    AttributeFormatUChar2Normalized = 7,
    AttributeFormatUChar3Normalized = 8,
    AttributeFormatUChar4Normalized = 9,
    AttributeFormatChar2Normalized = 10,
    AttributeFormatChar3Normalized = 11,
    AttributeFormatChar4Normalized = 12,
    AttributeFormatUShort2 = 13,
    AttributeFormatUShort3 = 14,
    AttributeFormatUShort4 = 15,
    AttributeFormatShort2 = 16,
    AttributeFormatShort3 = 17,
    AttributeFormatShort4 = 18,
    AttributeFormatUShort2Normalized = 19,
    AttributeFormatUShort3Normalized = 20,
    AttributeFormatUShort4Normalized = 21,
    AttributeFormatShort2Normalized = 22,
    AttributeFormatShort3Normalized = 23,
    AttributeFormatShort4Normalized = 24,
    AttributeFormatHalf2 = 25,
    AttributeFormatHalf3 = 26,
    AttributeFormatHalf4 = 27,
    AttributeFormatFloat = 28,
    AttributeFormatFloat2 = 29,
    AttributeFormatFloat3 = 30,
    AttributeFormatFloat4 = 31,
    AttributeFormatInt = 32,
    AttributeFormatInt2 = 33,
    AttributeFormatInt3 = 34,
    AttributeFormatInt4 = 35,
    AttributeFormatUInt = 36,
    AttributeFormatUInt2 = 37,
    AttributeFormatUInt3 = 38,
    AttributeFormatUInt4 = 39,
    AttributeFormatInt1010102Normalized = 40,
    AttributeFormatUInt1010102Normalized = 41,
    AttributeFormatUChar4Normalized_BGRA = 42,
    AttributeFormatUChar = 45,
    AttributeFormatChar = 46,
    AttributeFormatUCharNormalized = 47,
    AttributeFormatCharNormalized = 48,
    AttributeFormatUShort = 49,
    AttributeFormatShort = 50,
    AttributeFormatUShortNormalized = 51,
    AttributeFormatShortNormalized = 52,
    AttributeFormatHalf = 53,
};

_MTL_ENUM(NS::UInteger, IndexType) {
    IndexTypeUInt16 = 0,
    IndexTypeUInt32 = 1,
};

_MTL_ENUM(NS::UInteger, StepFunction) {
    StepFunctionConstant = 0,
    StepFunctionPerVertex = 1,
    StepFunctionPerInstance = 2,
    StepFunctionPerPatch = 3,
    StepFunctionPerPatchControlPoint = 4,
    StepFunctionThreadPositionInGridX = 5,
    StepFunctionThreadPositionInGridY = 6,
    StepFunctionThreadPositionInGridXIndexed = 7,
    StepFunctionThreadPositionInGridYIndexed = 8,
};

class BufferLayoutDescriptor : public NS::Copying<BufferLayoutDescriptor>
{
public:
    static class BufferLayoutDescriptor* alloc();

    class BufferLayoutDescriptor*        init();

    NS::UInteger                         stride() const;
    void                                 setStride(NS::UInteger stride);

    MTL::StepFunction                    stepFunction() const;
    void                                 setStepFunction(MTL::StepFunction stepFunction);

    NS::UInteger                         stepRate() const;
    void                                 setStepRate(NS::UInteger stepRate);
};

class BufferLayoutDescriptorArray : public NS::Referencing<BufferLayoutDescriptorArray>
{
public:
    static class BufferLayoutDescriptorArray* alloc();

    class BufferLayoutDescriptorArray*        init();

    class BufferLayoutDescriptor*             object(NS::UInteger index);

    void                                      setObject(const class BufferLayoutDescriptor* bufferDesc, NS::UInteger index);
};

class AttributeDescriptor : public NS::Copying<AttributeDescriptor>
{
public:
    static class AttributeDescriptor* alloc();

    class AttributeDescriptor*        init();

    MTL::AttributeFormat              format() const;
    void                              setFormat(MTL::AttributeFormat format);

    NS::UInteger                      offset() const;
    void                              setOffset(NS::UInteger offset);

    NS::UInteger                      bufferIndex() const;
    void                              setBufferIndex(NS::UInteger bufferIndex);
};

class AttributeDescriptorArray : public NS::Referencing<AttributeDescriptorArray>
{
public:
    static class AttributeDescriptorArray* alloc();

    class AttributeDescriptorArray*        init();

    class AttributeDescriptor*             object(NS::UInteger index);

    void                                   setObject(const class AttributeDescriptor* attributeDesc, NS::UInteger index);
};

class StageInputOutputDescriptor : public NS::Copying<StageInputOutputDescriptor>
{
public:
    static class StageInputOutputDescriptor* alloc();

    class StageInputOutputDescriptor*        init();

    static class StageInputOutputDescriptor* stageInputOutputDescriptor();

    class BufferLayoutDescriptorArray*       layouts() const;

    class AttributeDescriptorArray*          attributes() const;

    MTL::IndexType                           indexType() const;
    void                                     setIndexType(MTL::IndexType indexType);

    NS::UInteger                             indexBufferIndex() const;
    void                                     setIndexBufferIndex(NS::UInteger indexBufferIndex);

    void                                     reset();
};

}

_MTL_INLINE MTL::BufferLayoutDescriptor* MTL::BufferLayoutDescriptor::alloc()
{
    return NS::Object::alloc<MTL::BufferLayoutDescriptor>(_MTL_PRIVATE_CLS(MTLBufferLayoutDescriptor));
}

_MTL_INLINE MTL::BufferLayoutDescriptor* MTL::BufferLayoutDescriptor::init()
{
    return NS::Object::init<MTL::BufferLayoutDescriptor>();
}

_MTL_INLINE NS::UInteger MTL::BufferLayoutDescriptor::stride() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(stride));
}

_MTL_INLINE void MTL::BufferLayoutDescriptor::setStride(NS::UInteger stride)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStride_), stride);
}

_MTL_INLINE MTL::StepFunction MTL::BufferLayoutDescriptor::stepFunction() const
{
    return Object::sendMessage<MTL::StepFunction>(this, _MTL_PRIVATE_SEL(stepFunction));
}

_MTL_INLINE void MTL::BufferLayoutDescriptor::setStepFunction(MTL::StepFunction stepFunction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStepFunction_), stepFunction);
}

_MTL_INLINE NS::UInteger MTL::BufferLayoutDescriptor::stepRate() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(stepRate));
}

_MTL_INLINE void MTL::BufferLayoutDescriptor::setStepRate(NS::UInteger stepRate)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStepRate_), stepRate);
}

_MTL_INLINE MTL::BufferLayoutDescriptorArray* MTL::BufferLayoutDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::BufferLayoutDescriptorArray>(_MTL_PRIVATE_CLS(MTLBufferLayoutDescriptorArray));
}

_MTL_INLINE MTL::BufferLayoutDescriptorArray* MTL::BufferLayoutDescriptorArray::init()
{
    return NS::Object::init<MTL::BufferLayoutDescriptorArray>();
}

_MTL_INLINE MTL::BufferLayoutDescriptor* MTL::BufferLayoutDescriptorArray::object(NS::UInteger index)
{
    return Object::sendMessage<MTL::BufferLayoutDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), index);
}

_MTL_INLINE void MTL::BufferLayoutDescriptorArray::setObject(const MTL::BufferLayoutDescriptor* bufferDesc, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), bufferDesc, index);
}

_MTL_INLINE MTL::AttributeDescriptor* MTL::AttributeDescriptor::alloc()
{
    return NS::Object::alloc<MTL::AttributeDescriptor>(_MTL_PRIVATE_CLS(MTLAttributeDescriptor));
}

_MTL_INLINE MTL::AttributeDescriptor* MTL::AttributeDescriptor::init()
{
    return NS::Object::init<MTL::AttributeDescriptor>();
}

_MTL_INLINE MTL::AttributeFormat MTL::AttributeDescriptor::format() const
{
    return Object::sendMessage<MTL::AttributeFormat>(this, _MTL_PRIVATE_SEL(format));
}

_MTL_INLINE void MTL::AttributeDescriptor::setFormat(MTL::AttributeFormat format)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFormat_), format);
}

_MTL_INLINE NS::UInteger MTL::AttributeDescriptor::offset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(offset));
}

_MTL_INLINE void MTL::AttributeDescriptor::setOffset(NS::UInteger offset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setOffset_), offset);
}

_MTL_INLINE NS::UInteger MTL::AttributeDescriptor::bufferIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(bufferIndex));
}

_MTL_INLINE void MTL::AttributeDescriptor::setBufferIndex(NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBufferIndex_), bufferIndex);
}

_MTL_INLINE MTL::AttributeDescriptorArray* MTL::AttributeDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::AttributeDescriptorArray>(_MTL_PRIVATE_CLS(MTLAttributeDescriptorArray));
}

_MTL_INLINE MTL::AttributeDescriptorArray* MTL::AttributeDescriptorArray::init()
{
    return NS::Object::init<MTL::AttributeDescriptorArray>();
}

_MTL_INLINE MTL::AttributeDescriptor* MTL::AttributeDescriptorArray::object(NS::UInteger index)
{
    return Object::sendMessage<MTL::AttributeDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), index);
}

_MTL_INLINE void MTL::AttributeDescriptorArray::setObject(const MTL::AttributeDescriptor* attributeDesc, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), attributeDesc, index);
}

_MTL_INLINE MTL::StageInputOutputDescriptor* MTL::StageInputOutputDescriptor::alloc()
{
    return NS::Object::alloc<MTL::StageInputOutputDescriptor>(_MTL_PRIVATE_CLS(MTLStageInputOutputDescriptor));
}

_MTL_INLINE MTL::StageInputOutputDescriptor* MTL::StageInputOutputDescriptor::init()
{
    return NS::Object::init<MTL::StageInputOutputDescriptor>();
}

_MTL_INLINE MTL::StageInputOutputDescriptor* MTL::StageInputOutputDescriptor::stageInputOutputDescriptor()
{
    return Object::sendMessage<MTL::StageInputOutputDescriptor*>(_MTL_PRIVATE_CLS(MTLStageInputOutputDescriptor), _MTL_PRIVATE_SEL(stageInputOutputDescriptor));
}

_MTL_INLINE MTL::BufferLayoutDescriptorArray* MTL::StageInputOutputDescriptor::layouts() const
{
    return Object::sendMessage<MTL::BufferLayoutDescriptorArray*>(this, _MTL_PRIVATE_SEL(layouts));
}

_MTL_INLINE MTL::AttributeDescriptorArray* MTL::StageInputOutputDescriptor::attributes() const
{
    return Object::sendMessage<MTL::AttributeDescriptorArray*>(this, _MTL_PRIVATE_SEL(attributes));
}

_MTL_INLINE MTL::IndexType MTL::StageInputOutputDescriptor::indexType() const
{
    return Object::sendMessage<MTL::IndexType>(this, _MTL_PRIVATE_SEL(indexType));
}

_MTL_INLINE void MTL::StageInputOutputDescriptor::setIndexType(MTL::IndexType indexType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndexType_), indexType);
}

_MTL_INLINE NS::UInteger MTL::StageInputOutputDescriptor::indexBufferIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(indexBufferIndex));
}

_MTL_INLINE void MTL::StageInputOutputDescriptor::setIndexBufferIndex(NS::UInteger indexBufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndexBufferIndex_), indexBufferIndex);
}

_MTL_INLINE void MTL::StageInputOutputDescriptor::reset()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(reset));
}

namespace MTL
{
struct PackedFloat3
{
    PackedFloat3();
    PackedFloat3(float x, float y, float z);

    float& operator[](int idx);
    float  operator[](int idx) const;

    union
    {
        struct
        {
            float x;
            float y;
            float z;
        };

        float elements[3];
    };
} _MTL_PACKED;

struct PackedFloat4x3
{
    PackedFloat4x3();
    PackedFloat4x3(const PackedFloat3& col0, const PackedFloat3& col1, const PackedFloat3& col2, const PackedFloat3& col3);

    PackedFloat3&       operator[](int idx);
    const PackedFloat3& operator[](int idx) const;

    PackedFloat3        columns[4];
} _MTL_PACKED;

struct AxisAlignedBoundingBox
{
    AxisAlignedBoundingBox();
    AxisAlignedBoundingBox(PackedFloat3 p);
    AxisAlignedBoundingBox(PackedFloat3 min, PackedFloat3 max);

    PackedFloat3 min;
    PackedFloat3 max;
} _MTL_PACKED;
}

_MTL_INLINE MTL::PackedFloat3::PackedFloat3()
    : x(0.0f)
    , y(0.0f)
    , z(0.0f)
{
}

_MTL_INLINE MTL::PackedFloat3::PackedFloat3(float _x, float _y, float _z)
    : x(_x)
    , y(_y)
    , z(_z)
{
}

_MTL_INLINE float& MTL::PackedFloat3::operator[](int idx)
{
    return elements[idx];
}

_MTL_INLINE float MTL::PackedFloat3::operator[](int idx) const
{
    return elements[idx];
}

_MTL_INLINE MTL::PackedFloat4x3::PackedFloat4x3()
{
    columns[0] = PackedFloat3(0.0f, 0.0f, 0.0f);
    columns[1] = PackedFloat3(0.0f, 0.0f, 0.0f);
    columns[2] = PackedFloat3(0.0f, 0.0f, 0.0f);
    columns[3] = PackedFloat3(0.0f, 0.0f, 0.0f);
}

_MTL_INLINE MTL::PackedFloat4x3::PackedFloat4x3(const PackedFloat3& col0, const PackedFloat3& col1, const PackedFloat3& col2, const PackedFloat3& col3)
{
    columns[0] = col0;
    columns[1] = col1;
    columns[2] = col2;
    columns[3] = col3;
}

_MTL_INLINE MTL::PackedFloat3& MTL::PackedFloat4x3::operator[](int idx)
{
    return columns[idx];
}

_MTL_INLINE const MTL::PackedFloat3& MTL::PackedFloat4x3::operator[](int idx) const
{
    return columns[idx];
}

_MTL_INLINE MTL::AxisAlignedBoundingBox::AxisAlignedBoundingBox()
    : min(INFINITY, INFINITY, INFINITY)
    , max(-INFINITY, -INFINITY, -INFINITY)
{
}

_MTL_INLINE MTL::AxisAlignedBoundingBox::AxisAlignedBoundingBox(PackedFloat3 p)
    : min(p)
    , max(p)
{
}

_MTL_INLINE MTL::AxisAlignedBoundingBox::AxisAlignedBoundingBox(PackedFloat3 _min, PackedFloat3 _max)
    : min(_min)
    , max(_max)
{
}

namespace MTL
{
_MTL_OPTIONS(NS::UInteger, AccelerationStructureUsage) {
    AccelerationStructureUsageNone = 0,
    AccelerationStructureUsageRefit = 1,
    AccelerationStructureUsagePreferFastBuild = 2,
    AccelerationStructureUsageExtendedLimits = 4,
};

_MTL_OPTIONS(uint32_t, AccelerationStructureInstanceOptions) {
    AccelerationStructureInstanceOptionNone = 0,
    AccelerationStructureInstanceOptionDisableTriangleCulling = 1,
    AccelerationStructureInstanceOptionTriangleFrontFacingWindingCounterClockwise = 2,
    AccelerationStructureInstanceOptionOpaque = 4,
    AccelerationStructureInstanceOptionNonOpaque = 8,
};

class AccelerationStructureDescriptor : public NS::Copying<AccelerationStructureDescriptor>
{
public:
    static class AccelerationStructureDescriptor* alloc();

    class AccelerationStructureDescriptor*        init();

    MTL::AccelerationStructureUsage               usage() const;
    void                                          setUsage(MTL::AccelerationStructureUsage usage);
};

class AccelerationStructureGeometryDescriptor : public NS::Copying<AccelerationStructureGeometryDescriptor>
{
public:
    static class AccelerationStructureGeometryDescriptor* alloc();

    class AccelerationStructureGeometryDescriptor*        init();

    NS::UInteger                                          intersectionFunctionTableOffset() const;
    void                                                  setIntersectionFunctionTableOffset(NS::UInteger intersectionFunctionTableOffset);

    bool                                                  opaque() const;
    void                                                  setOpaque(bool opaque);

    bool                                                  allowDuplicateIntersectionFunctionInvocation() const;
    void                                                  setAllowDuplicateIntersectionFunctionInvocation(bool allowDuplicateIntersectionFunctionInvocation);

    NS::String*                                           label() const;
    void                                                  setLabel(const NS::String* label);
};

_MTL_ENUM(uint32_t, MotionBorderMode) {
    MotionBorderModeClamp = 0,
    MotionBorderModeVanish = 1,
};

class PrimitiveAccelerationStructureDescriptor : public NS::Copying<PrimitiveAccelerationStructureDescriptor, MTL::AccelerationStructureDescriptor>
{
public:
    static class PrimitiveAccelerationStructureDescriptor* alloc();

    class PrimitiveAccelerationStructureDescriptor*        init();

    NS::Array*                                             geometryDescriptors() const;
    void                                                   setGeometryDescriptors(const NS::Array* geometryDescriptors);

    MTL::MotionBorderMode                                  motionStartBorderMode() const;
    void                                                   setMotionStartBorderMode(MTL::MotionBorderMode motionStartBorderMode);

    MTL::MotionBorderMode                                  motionEndBorderMode() const;
    void                                                   setMotionEndBorderMode(MTL::MotionBorderMode motionEndBorderMode);

    float                                                  motionStartTime() const;
    void                                                   setMotionStartTime(float motionStartTime);

    float                                                  motionEndTime() const;
    void                                                   setMotionEndTime(float motionEndTime);

    NS::UInteger                                           motionKeyframeCount() const;
    void                                                   setMotionKeyframeCount(NS::UInteger motionKeyframeCount);

    static MTL::PrimitiveAccelerationStructureDescriptor*  descriptor();
};

class AccelerationStructureTriangleGeometryDescriptor : public NS::Copying<AccelerationStructureTriangleGeometryDescriptor, MTL::AccelerationStructureGeometryDescriptor>
{
public:
    static class AccelerationStructureTriangleGeometryDescriptor* alloc();

    class AccelerationStructureTriangleGeometryDescriptor*        init();

    class Buffer*                                                 vertexBuffer() const;
    void                                                          setVertexBuffer(const class Buffer* vertexBuffer);

    NS::UInteger                                                  vertexBufferOffset() const;
    void                                                          setVertexBufferOffset(NS::UInteger vertexBufferOffset);

    NS::UInteger                                                  vertexStride() const;
    void                                                          setVertexStride(NS::UInteger vertexStride);

    class Buffer*                                                 indexBuffer() const;
    void                                                          setIndexBuffer(const class Buffer* indexBuffer);

    NS::UInteger                                                  indexBufferOffset() const;
    void                                                          setIndexBufferOffset(NS::UInteger indexBufferOffset);

    MTL::IndexType                                                indexType() const;
    void                                                          setIndexType(MTL::IndexType indexType);

    NS::UInteger                                                  triangleCount() const;
    void                                                          setTriangleCount(NS::UInteger triangleCount);

    static MTL::AccelerationStructureTriangleGeometryDescriptor*  descriptor();
};

class AccelerationStructureBoundingBoxGeometryDescriptor : public NS::Copying<AccelerationStructureBoundingBoxGeometryDescriptor, MTL::AccelerationStructureGeometryDescriptor>
{
public:
    static class AccelerationStructureBoundingBoxGeometryDescriptor* alloc();

    class AccelerationStructureBoundingBoxGeometryDescriptor*        init();

    class Buffer*                                                    boundingBoxBuffer() const;
    void                                                             setBoundingBoxBuffer(const class Buffer* boundingBoxBuffer);

    NS::UInteger                                                     boundingBoxBufferOffset() const;
    void                                                             setBoundingBoxBufferOffset(NS::UInteger boundingBoxBufferOffset);

    NS::UInteger                                                     boundingBoxStride() const;
    void                                                             setBoundingBoxStride(NS::UInteger boundingBoxStride);

    NS::UInteger                                                     boundingBoxCount() const;
    void                                                             setBoundingBoxCount(NS::UInteger boundingBoxCount);

    static MTL::AccelerationStructureBoundingBoxGeometryDescriptor*  descriptor();
};

class MotionKeyframeData : public NS::Referencing<MotionKeyframeData>
{
public:
    static class MotionKeyframeData* alloc();

    class MotionKeyframeData*        init();

    class Buffer*                    buffer() const;
    void                             setBuffer(const class Buffer* buffer);

    NS::UInteger                     offset() const;
    void                             setOffset(NS::UInteger offset);

    static MTL::MotionKeyframeData*  data();
};

class AccelerationStructureMotionTriangleGeometryDescriptor : public NS::Copying<AccelerationStructureMotionTriangleGeometryDescriptor, MTL::AccelerationStructureGeometryDescriptor>
{
public:
    static class AccelerationStructureMotionTriangleGeometryDescriptor* alloc();

    class AccelerationStructureMotionTriangleGeometryDescriptor*        init();

    NS::Array*                                                          vertexBuffers() const;
    void                                                                setVertexBuffers(const NS::Array* vertexBuffers);

    NS::UInteger                                                        vertexStride() const;
    void                                                                setVertexStride(NS::UInteger vertexStride);

    class Buffer*                                                       indexBuffer() const;
    void                                                                setIndexBuffer(const class Buffer* indexBuffer);

    NS::UInteger                                                        indexBufferOffset() const;
    void                                                                setIndexBufferOffset(NS::UInteger indexBufferOffset);

    MTL::IndexType                                                      indexType() const;
    void                                                                setIndexType(MTL::IndexType indexType);

    NS::UInteger                                                        triangleCount() const;
    void                                                                setTriangleCount(NS::UInteger triangleCount);

    static MTL::AccelerationStructureMotionTriangleGeometryDescriptor*  descriptor();
};

class AccelerationStructureMotionBoundingBoxGeometryDescriptor : public NS::Copying<AccelerationStructureMotionBoundingBoxGeometryDescriptor, MTL::AccelerationStructureGeometryDescriptor>
{
public:
    static class AccelerationStructureMotionBoundingBoxGeometryDescriptor* alloc();

    class AccelerationStructureMotionBoundingBoxGeometryDescriptor*        init();

    NS::Array*                                                             boundingBoxBuffers() const;
    void                                                                   setBoundingBoxBuffers(const NS::Array* boundingBoxBuffers);

    NS::UInteger                                                           boundingBoxStride() const;
    void                                                                   setBoundingBoxStride(NS::UInteger boundingBoxStride);

    NS::UInteger                                                           boundingBoxCount() const;
    void                                                                   setBoundingBoxCount(NS::UInteger boundingBoxCount);

    static MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor*  descriptor();
};

struct AccelerationStructureInstanceDescriptor
{
    MTL::PackedFloat4x3                       transformationMatrix;
    MTL::AccelerationStructureInstanceOptions options;
    uint32_t                                  mask;
    uint32_t                                  intersectionFunctionTableOffset;
    uint32_t                                  accelerationStructureIndex;
} _MTL_PACKED;

struct AccelerationStructureUserIDInstanceDescriptor
{
    MTL::PackedFloat4x3                       transformationMatrix;
    MTL::AccelerationStructureInstanceOptions options;
    uint32_t                                  mask;
    uint32_t                                  intersectionFunctionTableOffset;
    uint32_t                                  accelerationStructureIndex;
    uint32_t                                  userID;
} _MTL_PACKED;

_MTL_ENUM(NS::UInteger, AccelerationStructureInstanceDescriptorType) {
    AccelerationStructureInstanceDescriptorTypeDefault = 0,
    AccelerationStructureInstanceDescriptorTypeUserID = 1,
    AccelerationStructureInstanceDescriptorTypeMotion = 2,
};

struct AccelerationStructureMotionInstanceDescriptor
{
    MTL::AccelerationStructureInstanceOptions options;
    uint32_t                                  mask;
    uint32_t                                  intersectionFunctionTableOffset;
    uint32_t                                  accelerationStructureIndex;
    uint32_t                                  userID;
    uint32_t                                  motionTransformsStartIndex;
    uint32_t                                  motionTransformsCount;
    MTL::MotionBorderMode                     motionStartBorderMode;
    MTL::MotionBorderMode                     motionEndBorderMode;
    float                                     motionStartTime;
    float                                     motionEndTime;
} _MTL_PACKED;

class InstanceAccelerationStructureDescriptor : public NS::Copying<InstanceAccelerationStructureDescriptor, MTL::AccelerationStructureDescriptor>
{
public:
    static class InstanceAccelerationStructureDescriptor* alloc();

    class InstanceAccelerationStructureDescriptor*        init();

    class Buffer*                                         instanceDescriptorBuffer() const;
    void                                                  setInstanceDescriptorBuffer(const class Buffer* instanceDescriptorBuffer);

    NS::UInteger                                          instanceDescriptorBufferOffset() const;
    void                                                  setInstanceDescriptorBufferOffset(NS::UInteger instanceDescriptorBufferOffset);

    NS::UInteger                                          instanceDescriptorStride() const;
    void                                                  setInstanceDescriptorStride(NS::UInteger instanceDescriptorStride);

    NS::UInteger                                          instanceCount() const;
    void                                                  setInstanceCount(NS::UInteger instanceCount);

    NS::Array*                                            instancedAccelerationStructures() const;
    void                                                  setInstancedAccelerationStructures(const NS::Array* instancedAccelerationStructures);

    MTL::AccelerationStructureInstanceDescriptorType      instanceDescriptorType() const;
    void                                                  setInstanceDescriptorType(MTL::AccelerationStructureInstanceDescriptorType instanceDescriptorType);

    class Buffer*                                         motionTransformBuffer() const;
    void                                                  setMotionTransformBuffer(const class Buffer* motionTransformBuffer);

    NS::UInteger                                          motionTransformBufferOffset() const;
    void                                                  setMotionTransformBufferOffset(NS::UInteger motionTransformBufferOffset);

    NS::UInteger                                          motionTransformCount() const;
    void                                                  setMotionTransformCount(NS::UInteger motionTransformCount);

    static MTL::InstanceAccelerationStructureDescriptor*  descriptor();
};

class AccelerationStructure : public NS::Referencing<AccelerationStructure, Resource>
{
public:
    NS::UInteger size() const;
};

}

_MTL_INLINE MTL::AccelerationStructureDescriptor* MTL::AccelerationStructureDescriptor::alloc()
{
    return NS::Object::alloc<MTL::AccelerationStructureDescriptor>(_MTL_PRIVATE_CLS(MTLAccelerationStructureDescriptor));
}

_MTL_INLINE MTL::AccelerationStructureDescriptor* MTL::AccelerationStructureDescriptor::init()
{
    return NS::Object::init<MTL::AccelerationStructureDescriptor>();
}

_MTL_INLINE MTL::AccelerationStructureUsage MTL::AccelerationStructureDescriptor::usage() const
{
    return Object::sendMessage<MTL::AccelerationStructureUsage>(this, _MTL_PRIVATE_SEL(usage));
}

_MTL_INLINE void MTL::AccelerationStructureDescriptor::setUsage(MTL::AccelerationStructureUsage usage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setUsage_), usage);
}

_MTL_INLINE MTL::AccelerationStructureGeometryDescriptor* MTL::AccelerationStructureGeometryDescriptor::alloc()
{
    return NS::Object::alloc<MTL::AccelerationStructureGeometryDescriptor>(_MTL_PRIVATE_CLS(MTLAccelerationStructureGeometryDescriptor));
}

_MTL_INLINE MTL::AccelerationStructureGeometryDescriptor* MTL::AccelerationStructureGeometryDescriptor::init()
{
    return NS::Object::init<MTL::AccelerationStructureGeometryDescriptor>();
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureGeometryDescriptor::intersectionFunctionTableOffset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(intersectionFunctionTableOffset));
}

_MTL_INLINE void MTL::AccelerationStructureGeometryDescriptor::setIntersectionFunctionTableOffset(NS::UInteger intersectionFunctionTableOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIntersectionFunctionTableOffset_), intersectionFunctionTableOffset);
}

_MTL_INLINE bool MTL::AccelerationStructureGeometryDescriptor::opaque() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(opaque));
}

_MTL_INLINE void MTL::AccelerationStructureGeometryDescriptor::setOpaque(bool opaque)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setOpaque_), opaque);
}

_MTL_INLINE bool MTL::AccelerationStructureGeometryDescriptor::allowDuplicateIntersectionFunctionInvocation() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(allowDuplicateIntersectionFunctionInvocation));
}

_MTL_INLINE void MTL::AccelerationStructureGeometryDescriptor::setAllowDuplicateIntersectionFunctionInvocation(bool allowDuplicateIntersectionFunctionInvocation)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setAllowDuplicateIntersectionFunctionInvocation_), allowDuplicateIntersectionFunctionInvocation);
}

_MTL_INLINE NS::String* MTL::AccelerationStructureGeometryDescriptor::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::AccelerationStructureGeometryDescriptor::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::PrimitiveAccelerationStructureDescriptor* MTL::PrimitiveAccelerationStructureDescriptor::alloc()
{
    return NS::Object::alloc<MTL::PrimitiveAccelerationStructureDescriptor>(_MTL_PRIVATE_CLS(MTLPrimitiveAccelerationStructureDescriptor));
}

_MTL_INLINE MTL::PrimitiveAccelerationStructureDescriptor* MTL::PrimitiveAccelerationStructureDescriptor::init()
{
    return NS::Object::init<MTL::PrimitiveAccelerationStructureDescriptor>();
}

_MTL_INLINE NS::Array* MTL::PrimitiveAccelerationStructureDescriptor::geometryDescriptors() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(geometryDescriptors));
}

_MTL_INLINE void MTL::PrimitiveAccelerationStructureDescriptor::setGeometryDescriptors(const NS::Array* geometryDescriptors)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setGeometryDescriptors_), geometryDescriptors);
}

_MTL_INLINE MTL::MotionBorderMode MTL::PrimitiveAccelerationStructureDescriptor::motionStartBorderMode() const
{
    return Object::sendMessage<MTL::MotionBorderMode>(this, _MTL_PRIVATE_SEL(motionStartBorderMode));
}

_MTL_INLINE void MTL::PrimitiveAccelerationStructureDescriptor::setMotionStartBorderMode(MTL::MotionBorderMode motionStartBorderMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMotionStartBorderMode_), motionStartBorderMode);
}

_MTL_INLINE MTL::MotionBorderMode MTL::PrimitiveAccelerationStructureDescriptor::motionEndBorderMode() const
{
    return Object::sendMessage<MTL::MotionBorderMode>(this, _MTL_PRIVATE_SEL(motionEndBorderMode));
}

_MTL_INLINE void MTL::PrimitiveAccelerationStructureDescriptor::setMotionEndBorderMode(MTL::MotionBorderMode motionEndBorderMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMotionEndBorderMode_), motionEndBorderMode);
}

_MTL_INLINE float MTL::PrimitiveAccelerationStructureDescriptor::motionStartTime() const
{
    return Object::sendMessage<float>(this, _MTL_PRIVATE_SEL(motionStartTime));
}

_MTL_INLINE void MTL::PrimitiveAccelerationStructureDescriptor::setMotionStartTime(float motionStartTime)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMotionStartTime_), motionStartTime);
}

_MTL_INLINE float MTL::PrimitiveAccelerationStructureDescriptor::motionEndTime() const
{
    return Object::sendMessage<float>(this, _MTL_PRIVATE_SEL(motionEndTime));
}

_MTL_INLINE void MTL::PrimitiveAccelerationStructureDescriptor::setMotionEndTime(float motionEndTime)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMotionEndTime_), motionEndTime);
}

_MTL_INLINE NS::UInteger MTL::PrimitiveAccelerationStructureDescriptor::motionKeyframeCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(motionKeyframeCount));
}

_MTL_INLINE void MTL::PrimitiveAccelerationStructureDescriptor::setMotionKeyframeCount(NS::UInteger motionKeyframeCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMotionKeyframeCount_), motionKeyframeCount);
}

_MTL_INLINE MTL::PrimitiveAccelerationStructureDescriptor* MTL::PrimitiveAccelerationStructureDescriptor::descriptor()
{
    return Object::sendMessage<MTL::PrimitiveAccelerationStructureDescriptor*>(_MTL_PRIVATE_CLS(MTLPrimitiveAccelerationStructureDescriptor), _MTL_PRIVATE_SEL(descriptor));
}

_MTL_INLINE MTL::AccelerationStructureTriangleGeometryDescriptor* MTL::AccelerationStructureTriangleGeometryDescriptor::alloc()
{
    return NS::Object::alloc<MTL::AccelerationStructureTriangleGeometryDescriptor>(_MTL_PRIVATE_CLS(MTLAccelerationStructureTriangleGeometryDescriptor));
}

_MTL_INLINE MTL::AccelerationStructureTriangleGeometryDescriptor* MTL::AccelerationStructureTriangleGeometryDescriptor::init()
{
    return NS::Object::init<MTL::AccelerationStructureTriangleGeometryDescriptor>();
}

_MTL_INLINE MTL::Buffer* MTL::AccelerationStructureTriangleGeometryDescriptor::vertexBuffer() const
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(vertexBuffer));
}

_MTL_INLINE void MTL::AccelerationStructureTriangleGeometryDescriptor::setVertexBuffer(const MTL::Buffer* vertexBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexBuffer_), vertexBuffer);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureTriangleGeometryDescriptor::vertexBufferOffset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(vertexBufferOffset));
}

_MTL_INLINE void MTL::AccelerationStructureTriangleGeometryDescriptor::setVertexBufferOffset(NS::UInteger vertexBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexBufferOffset_), vertexBufferOffset);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureTriangleGeometryDescriptor::vertexStride() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(vertexStride));
}

_MTL_INLINE void MTL::AccelerationStructureTriangleGeometryDescriptor::setVertexStride(NS::UInteger vertexStride)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexStride_), vertexStride);
}

_MTL_INLINE MTL::Buffer* MTL::AccelerationStructureTriangleGeometryDescriptor::indexBuffer() const
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(indexBuffer));
}

_MTL_INLINE void MTL::AccelerationStructureTriangleGeometryDescriptor::setIndexBuffer(const MTL::Buffer* indexBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndexBuffer_), indexBuffer);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureTriangleGeometryDescriptor::indexBufferOffset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(indexBufferOffset));
}

_MTL_INLINE void MTL::AccelerationStructureTriangleGeometryDescriptor::setIndexBufferOffset(NS::UInteger indexBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndexBufferOffset_), indexBufferOffset);
}

_MTL_INLINE MTL::IndexType MTL::AccelerationStructureTriangleGeometryDescriptor::indexType() const
{
    return Object::sendMessage<MTL::IndexType>(this, _MTL_PRIVATE_SEL(indexType));
}

_MTL_INLINE void MTL::AccelerationStructureTriangleGeometryDescriptor::setIndexType(MTL::IndexType indexType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndexType_), indexType);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureTriangleGeometryDescriptor::triangleCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(triangleCount));
}

_MTL_INLINE void MTL::AccelerationStructureTriangleGeometryDescriptor::setTriangleCount(NS::UInteger triangleCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTriangleCount_), triangleCount);
}

_MTL_INLINE MTL::AccelerationStructureTriangleGeometryDescriptor* MTL::AccelerationStructureTriangleGeometryDescriptor::descriptor()
{
    return Object::sendMessage<MTL::AccelerationStructureTriangleGeometryDescriptor*>(_MTL_PRIVATE_CLS(MTLAccelerationStructureTriangleGeometryDescriptor), _MTL_PRIVATE_SEL(descriptor));
}

_MTL_INLINE MTL::AccelerationStructureBoundingBoxGeometryDescriptor* MTL::AccelerationStructureBoundingBoxGeometryDescriptor::alloc()
{
    return NS::Object::alloc<MTL::AccelerationStructureBoundingBoxGeometryDescriptor>(_MTL_PRIVATE_CLS(MTLAccelerationStructureBoundingBoxGeometryDescriptor));
}

_MTL_INLINE MTL::AccelerationStructureBoundingBoxGeometryDescriptor* MTL::AccelerationStructureBoundingBoxGeometryDescriptor::init()
{
    return NS::Object::init<MTL::AccelerationStructureBoundingBoxGeometryDescriptor>();
}

_MTL_INLINE MTL::Buffer* MTL::AccelerationStructureBoundingBoxGeometryDescriptor::boundingBoxBuffer() const
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(boundingBoxBuffer));
}

_MTL_INLINE void MTL::AccelerationStructureBoundingBoxGeometryDescriptor::setBoundingBoxBuffer(const MTL::Buffer* boundingBoxBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBoundingBoxBuffer_), boundingBoxBuffer);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureBoundingBoxGeometryDescriptor::boundingBoxBufferOffset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(boundingBoxBufferOffset));
}

_MTL_INLINE void MTL::AccelerationStructureBoundingBoxGeometryDescriptor::setBoundingBoxBufferOffset(NS::UInteger boundingBoxBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBoundingBoxBufferOffset_), boundingBoxBufferOffset);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureBoundingBoxGeometryDescriptor::boundingBoxStride() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(boundingBoxStride));
}

_MTL_INLINE void MTL::AccelerationStructureBoundingBoxGeometryDescriptor::setBoundingBoxStride(NS::UInteger boundingBoxStride)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBoundingBoxStride_), boundingBoxStride);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureBoundingBoxGeometryDescriptor::boundingBoxCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(boundingBoxCount));
}

_MTL_INLINE void MTL::AccelerationStructureBoundingBoxGeometryDescriptor::setBoundingBoxCount(NS::UInteger boundingBoxCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBoundingBoxCount_), boundingBoxCount);
}

_MTL_INLINE MTL::AccelerationStructureBoundingBoxGeometryDescriptor* MTL::AccelerationStructureBoundingBoxGeometryDescriptor::descriptor()
{
    return Object::sendMessage<MTL::AccelerationStructureBoundingBoxGeometryDescriptor*>(_MTL_PRIVATE_CLS(MTLAccelerationStructureBoundingBoxGeometryDescriptor), _MTL_PRIVATE_SEL(descriptor));
}

_MTL_INLINE MTL::MotionKeyframeData* MTL::MotionKeyframeData::alloc()
{
    return NS::Object::alloc<MTL::MotionKeyframeData>(_MTL_PRIVATE_CLS(MTLMotionKeyframeData));
}

_MTL_INLINE MTL::MotionKeyframeData* MTL::MotionKeyframeData::init()
{
    return NS::Object::init<MTL::MotionKeyframeData>();
}

_MTL_INLINE MTL::Buffer* MTL::MotionKeyframeData::buffer() const
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(buffer));
}

_MTL_INLINE void MTL::MotionKeyframeData::setBuffer(const MTL::Buffer* buffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBuffer_), buffer);
}

_MTL_INLINE NS::UInteger MTL::MotionKeyframeData::offset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(offset));
}

_MTL_INLINE void MTL::MotionKeyframeData::setOffset(NS::UInteger offset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setOffset_), offset);
}

_MTL_INLINE MTL::MotionKeyframeData* MTL::MotionKeyframeData::data()
{
    return Object::sendMessage<MTL::MotionKeyframeData*>(_MTL_PRIVATE_CLS(MTLMotionKeyframeData), _MTL_PRIVATE_SEL(data));
}

_MTL_INLINE MTL::AccelerationStructureMotionTriangleGeometryDescriptor* MTL::AccelerationStructureMotionTriangleGeometryDescriptor::alloc()
{
    return NS::Object::alloc<MTL::AccelerationStructureMotionTriangleGeometryDescriptor>(_MTL_PRIVATE_CLS(MTLAccelerationStructureMotionTriangleGeometryDescriptor));
}

_MTL_INLINE MTL::AccelerationStructureMotionTriangleGeometryDescriptor* MTL::AccelerationStructureMotionTriangleGeometryDescriptor::init()
{
    return NS::Object::init<MTL::AccelerationStructureMotionTriangleGeometryDescriptor>();
}

_MTL_INLINE NS::Array* MTL::AccelerationStructureMotionTriangleGeometryDescriptor::vertexBuffers() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(vertexBuffers));
}

_MTL_INLINE void MTL::AccelerationStructureMotionTriangleGeometryDescriptor::setVertexBuffers(const NS::Array* vertexBuffers)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexBuffers_), vertexBuffers);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureMotionTriangleGeometryDescriptor::vertexStride() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(vertexStride));
}

_MTL_INLINE void MTL::AccelerationStructureMotionTriangleGeometryDescriptor::setVertexStride(NS::UInteger vertexStride)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexStride_), vertexStride);
}

_MTL_INLINE MTL::Buffer* MTL::AccelerationStructureMotionTriangleGeometryDescriptor::indexBuffer() const
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(indexBuffer));
}

_MTL_INLINE void MTL::AccelerationStructureMotionTriangleGeometryDescriptor::setIndexBuffer(const MTL::Buffer* indexBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndexBuffer_), indexBuffer);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureMotionTriangleGeometryDescriptor::indexBufferOffset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(indexBufferOffset));
}

_MTL_INLINE void MTL::AccelerationStructureMotionTriangleGeometryDescriptor::setIndexBufferOffset(NS::UInteger indexBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndexBufferOffset_), indexBufferOffset);
}

_MTL_INLINE MTL::IndexType MTL::AccelerationStructureMotionTriangleGeometryDescriptor::indexType() const
{
    return Object::sendMessage<MTL::IndexType>(this, _MTL_PRIVATE_SEL(indexType));
}

_MTL_INLINE void MTL::AccelerationStructureMotionTriangleGeometryDescriptor::setIndexType(MTL::IndexType indexType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndexType_), indexType);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureMotionTriangleGeometryDescriptor::triangleCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(triangleCount));
}

_MTL_INLINE void MTL::AccelerationStructureMotionTriangleGeometryDescriptor::setTriangleCount(NS::UInteger triangleCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTriangleCount_), triangleCount);
}

_MTL_INLINE MTL::AccelerationStructureMotionTriangleGeometryDescriptor* MTL::AccelerationStructureMotionTriangleGeometryDescriptor::descriptor()
{
    return Object::sendMessage<MTL::AccelerationStructureMotionTriangleGeometryDescriptor*>(_MTL_PRIVATE_CLS(MTLAccelerationStructureMotionTriangleGeometryDescriptor), _MTL_PRIVATE_SEL(descriptor));
}

_MTL_INLINE MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor* MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor::alloc()
{
    return NS::Object::alloc<MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor>(_MTL_PRIVATE_CLS(MTLAccelerationStructureMotionBoundingBoxGeometryDescriptor));
}

_MTL_INLINE MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor* MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor::init()
{
    return NS::Object::init<MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor>();
}

_MTL_INLINE NS::Array* MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor::boundingBoxBuffers() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(boundingBoxBuffers));
}

_MTL_INLINE void MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor::setBoundingBoxBuffers(const NS::Array* boundingBoxBuffers)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBoundingBoxBuffers_), boundingBoxBuffers);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor::boundingBoxStride() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(boundingBoxStride));
}

_MTL_INLINE void MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor::setBoundingBoxStride(NS::UInteger boundingBoxStride)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBoundingBoxStride_), boundingBoxStride);
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor::boundingBoxCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(boundingBoxCount));
}

_MTL_INLINE void MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor::setBoundingBoxCount(NS::UInteger boundingBoxCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBoundingBoxCount_), boundingBoxCount);
}

_MTL_INLINE MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor* MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor::descriptor()
{
    return Object::sendMessage<MTL::AccelerationStructureMotionBoundingBoxGeometryDescriptor*>(_MTL_PRIVATE_CLS(MTLAccelerationStructureMotionBoundingBoxGeometryDescriptor), _MTL_PRIVATE_SEL(descriptor));
}

_MTL_INLINE MTL::InstanceAccelerationStructureDescriptor* MTL::InstanceAccelerationStructureDescriptor::alloc()
{
    return NS::Object::alloc<MTL::InstanceAccelerationStructureDescriptor>(_MTL_PRIVATE_CLS(MTLInstanceAccelerationStructureDescriptor));
}

_MTL_INLINE MTL::InstanceAccelerationStructureDescriptor* MTL::InstanceAccelerationStructureDescriptor::init()
{
    return NS::Object::init<MTL::InstanceAccelerationStructureDescriptor>();
}

_MTL_INLINE MTL::Buffer* MTL::InstanceAccelerationStructureDescriptor::instanceDescriptorBuffer() const
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(instanceDescriptorBuffer));
}

_MTL_INLINE void MTL::InstanceAccelerationStructureDescriptor::setInstanceDescriptorBuffer(const MTL::Buffer* instanceDescriptorBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInstanceDescriptorBuffer_), instanceDescriptorBuffer);
}

_MTL_INLINE NS::UInteger MTL::InstanceAccelerationStructureDescriptor::instanceDescriptorBufferOffset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(instanceDescriptorBufferOffset));
}

_MTL_INLINE void MTL::InstanceAccelerationStructureDescriptor::setInstanceDescriptorBufferOffset(NS::UInteger instanceDescriptorBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInstanceDescriptorBufferOffset_), instanceDescriptorBufferOffset);
}

_MTL_INLINE NS::UInteger MTL::InstanceAccelerationStructureDescriptor::instanceDescriptorStride() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(instanceDescriptorStride));
}

_MTL_INLINE void MTL::InstanceAccelerationStructureDescriptor::setInstanceDescriptorStride(NS::UInteger instanceDescriptorStride)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInstanceDescriptorStride_), instanceDescriptorStride);
}

_MTL_INLINE NS::UInteger MTL::InstanceAccelerationStructureDescriptor::instanceCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(instanceCount));
}

_MTL_INLINE void MTL::InstanceAccelerationStructureDescriptor::setInstanceCount(NS::UInteger instanceCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInstanceCount_), instanceCount);
}

_MTL_INLINE NS::Array* MTL::InstanceAccelerationStructureDescriptor::instancedAccelerationStructures() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(instancedAccelerationStructures));
}

_MTL_INLINE void MTL::InstanceAccelerationStructureDescriptor::setInstancedAccelerationStructures(const NS::Array* instancedAccelerationStructures)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInstancedAccelerationStructures_), instancedAccelerationStructures);
}

_MTL_INLINE MTL::AccelerationStructureInstanceDescriptorType MTL::InstanceAccelerationStructureDescriptor::instanceDescriptorType() const
{
    return Object::sendMessage<MTL::AccelerationStructureInstanceDescriptorType>(this, _MTL_PRIVATE_SEL(instanceDescriptorType));
}

_MTL_INLINE void MTL::InstanceAccelerationStructureDescriptor::setInstanceDescriptorType(MTL::AccelerationStructureInstanceDescriptorType instanceDescriptorType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInstanceDescriptorType_), instanceDescriptorType);
}

_MTL_INLINE MTL::Buffer* MTL::InstanceAccelerationStructureDescriptor::motionTransformBuffer() const
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(motionTransformBuffer));
}

_MTL_INLINE void MTL::InstanceAccelerationStructureDescriptor::setMotionTransformBuffer(const MTL::Buffer* motionTransformBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMotionTransformBuffer_), motionTransformBuffer);
}

_MTL_INLINE NS::UInteger MTL::InstanceAccelerationStructureDescriptor::motionTransformBufferOffset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(motionTransformBufferOffset));
}

_MTL_INLINE void MTL::InstanceAccelerationStructureDescriptor::setMotionTransformBufferOffset(NS::UInteger motionTransformBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMotionTransformBufferOffset_), motionTransformBufferOffset);
}

_MTL_INLINE NS::UInteger MTL::InstanceAccelerationStructureDescriptor::motionTransformCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(motionTransformCount));
}

_MTL_INLINE void MTL::InstanceAccelerationStructureDescriptor::setMotionTransformCount(NS::UInteger motionTransformCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMotionTransformCount_), motionTransformCount);
}

_MTL_INLINE MTL::InstanceAccelerationStructureDescriptor* MTL::InstanceAccelerationStructureDescriptor::descriptor()
{
    return Object::sendMessage<MTL::InstanceAccelerationStructureDescriptor*>(_MTL_PRIVATE_CLS(MTLInstanceAccelerationStructureDescriptor), _MTL_PRIVATE_SEL(descriptor));
}

_MTL_INLINE NS::UInteger MTL::AccelerationStructure::size() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(size));
}

#pragma once

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, DataType) {
    DataTypeNone = 0,
    DataTypeStruct = 1,
    DataTypeArray = 2,
    DataTypeFloat = 3,
    DataTypeFloat2 = 4,
    DataTypeFloat3 = 5,
    DataTypeFloat4 = 6,
    DataTypeFloat2x2 = 7,
    DataTypeFloat2x3 = 8,
    DataTypeFloat2x4 = 9,
    DataTypeFloat3x2 = 10,
    DataTypeFloat3x3 = 11,
    DataTypeFloat3x4 = 12,
    DataTypeFloat4x2 = 13,
    DataTypeFloat4x3 = 14,
    DataTypeFloat4x4 = 15,
    DataTypeHalf = 16,
    DataTypeHalf2 = 17,
    DataTypeHalf3 = 18,
    DataTypeHalf4 = 19,
    DataTypeHalf2x2 = 20,
    DataTypeHalf2x3 = 21,
    DataTypeHalf2x4 = 22,
    DataTypeHalf3x2 = 23,
    DataTypeHalf3x3 = 24,
    DataTypeHalf3x4 = 25,
    DataTypeHalf4x2 = 26,
    DataTypeHalf4x3 = 27,
    DataTypeHalf4x4 = 28,
    DataTypeInt = 29,
    DataTypeInt2 = 30,
    DataTypeInt3 = 31,
    DataTypeInt4 = 32,
    DataTypeUInt = 33,
    DataTypeUInt2 = 34,
    DataTypeUInt3 = 35,
    DataTypeUInt4 = 36,
    DataTypeShort = 37,
    DataTypeShort2 = 38,
    DataTypeShort3 = 39,
    DataTypeShort4 = 40,
    DataTypeUShort = 41,
    DataTypeUShort2 = 42,
    DataTypeUShort3 = 43,
    DataTypeUShort4 = 44,
    DataTypeChar = 45,
    DataTypeChar2 = 46,
    DataTypeChar3 = 47,
    DataTypeChar4 = 48,
    DataTypeUChar = 49,
    DataTypeUChar2 = 50,
    DataTypeUChar3 = 51,
    DataTypeUChar4 = 52,
    DataTypeBool = 53,
    DataTypeBool2 = 54,
    DataTypeBool3 = 55,
    DataTypeBool4 = 56,
    DataTypeTexture = 58,
    DataTypeSampler = 59,
    DataTypePointer = 60,
    DataTypeR8Unorm = 62,
    DataTypeR8Snorm = 63,
    DataTypeR16Unorm = 64,
    DataTypeR16Snorm = 65,
    DataTypeRG8Unorm = 66,
    DataTypeRG8Snorm = 67,
    DataTypeRG16Unorm = 68,
    DataTypeRG16Snorm = 69,
    DataTypeRGBA8Unorm = 70,
    DataTypeRGBA8Unorm_sRGB = 71,
    DataTypeRGBA8Snorm = 72,
    DataTypeRGBA16Unorm = 73,
    DataTypeRGBA16Snorm = 74,
    DataTypeRGB10A2Unorm = 75,
    DataTypeRG11B10Float = 76,
    DataTypeRGB9E5Float = 77,
    DataTypeRenderPipeline = 78,
    DataTypeComputePipeline = 79,
    DataTypeIndirectCommandBuffer = 80,
    DataTypeLong = 81,
    DataTypeLong2 = 82,
    DataTypeLong3 = 83,
    DataTypeLong4 = 84,
    DataTypeULong = 85,
    DataTypeULong2 = 86,
    DataTypeULong3 = 87,
    DataTypeULong4 = 88,
    DataTypeVisibleFunctionTable = 115,
    DataTypeIntersectionFunctionTable = 116,
    DataTypePrimitiveAccelerationStructure = 117,
    DataTypeInstanceAccelerationStructure = 118,
};

_MTL_ENUM(NS::UInteger, ArgumentType) {
    ArgumentTypeBuffer = 0,
    ArgumentTypeThreadgroupMemory = 1,
    ArgumentTypeTexture = 2,
    ArgumentTypeSampler = 3,
    ArgumentTypeImageblockData = 16,
    ArgumentTypeImageblock = 17,
    ArgumentTypeVisibleFunctionTable = 24,
    ArgumentTypePrimitiveAccelerationStructure = 25,
    ArgumentTypeInstanceAccelerationStructure = 26,
    ArgumentTypeIntersectionFunctionTable = 27,
};

_MTL_ENUM(NS::UInteger, ArgumentAccess) {
    ArgumentAccessReadOnly = 0,
    ArgumentAccessReadWrite = 1,
    ArgumentAccessWriteOnly = 2,
};

class Type : public NS::Referencing<Type>
{
public:
    static class Type* alloc();

    class Type*        init();

    MTL::DataType      dataType() const;
};

class StructMember : public NS::Referencing<StructMember>
{
public:
    static class StructMember*  alloc();

    class StructMember*         init();

    NS::String*                 name() const;

    NS::UInteger                offset() const;

    MTL::DataType               dataType() const;

    class StructType*           structType();

    class ArrayType*            arrayType();

    class TextureReferenceType* textureReferenceType();

    class PointerType*          pointerType();

    NS::UInteger                argumentIndex() const;
};

class StructType : public NS::Referencing<StructType, Type>
{
public:
    static class StructType* alloc();

    class StructType*        init();

    NS::Array*               members() const;

    class StructMember*      memberByName(const NS::String* name);
};

class ArrayType : public NS::Referencing<ArrayType, Type>
{
public:
    static class ArrayType*     alloc();

    class ArrayType*            init();

    MTL::DataType               elementType() const;

    NS::UInteger                arrayLength() const;

    NS::UInteger                stride() const;

    NS::UInteger                argumentIndexStride() const;

    class StructType*           elementStructType();

    class ArrayType*            elementArrayType();

    class TextureReferenceType* elementTextureReferenceType();

    class PointerType*          elementPointerType();
};

class PointerType : public NS::Referencing<PointerType, Type>
{
public:
    static class PointerType* alloc();

    class PointerType*        init();

    MTL::DataType             elementType() const;

    MTL::ArgumentAccess       access() const;

    NS::UInteger              alignment() const;

    NS::UInteger              dataSize() const;

    bool                      elementIsArgumentBuffer() const;

    class StructType*         elementStructType();

    class ArrayType*          elementArrayType();
};

class TextureReferenceType : public NS::Referencing<TextureReferenceType, Type>
{
public:
    static class TextureReferenceType* alloc();

    class TextureReferenceType*        init();

    MTL::DataType                      textureDataType() const;

    MTL::TextureType                   textureType() const;

    MTL::ArgumentAccess                access() const;

    bool                               isDepthTexture() const;
};

class Argument : public NS::Referencing<Argument>
{
public:
    static class Argument* alloc();

    class Argument*        init();

    NS::String*            name() const;

    MTL::ArgumentType      type() const;

    MTL::ArgumentAccess    access() const;

    NS::UInteger           index() const;

    bool                   active() const;

    NS::UInteger           bufferAlignment() const;

    NS::UInteger           bufferDataSize() const;

    MTL::DataType          bufferDataType() const;

    class StructType*      bufferStructType() const;

    class PointerType*     bufferPointerType() const;

    NS::UInteger           threadgroupMemoryAlignment() const;

    NS::UInteger           threadgroupMemoryDataSize() const;

    MTL::TextureType       textureType() const;

    MTL::DataType          textureDataType() const;

    bool                   isDepthTexture() const;

    NS::UInteger           arrayLength() const;
};

}

_MTL_INLINE MTL::Type* MTL::Type::alloc()
{
    return NS::Object::alloc<MTL::Type>(_MTL_PRIVATE_CLS(MTLType));
}

_MTL_INLINE MTL::Type* MTL::Type::init()
{
    return NS::Object::init<MTL::Type>();
}

_MTL_INLINE MTL::DataType MTL::Type::dataType() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(dataType));
}

_MTL_INLINE MTL::StructMember* MTL::StructMember::alloc()
{
    return NS::Object::alloc<MTL::StructMember>(_MTL_PRIVATE_CLS(MTLStructMember));
}

_MTL_INLINE MTL::StructMember* MTL::StructMember::init()
{
    return NS::Object::init<MTL::StructMember>();
}

_MTL_INLINE NS::String* MTL::StructMember::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE NS::UInteger MTL::StructMember::offset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(offset));
}

_MTL_INLINE MTL::DataType MTL::StructMember::dataType() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(dataType));
}

_MTL_INLINE MTL::StructType* MTL::StructMember::structType()
{
    return Object::sendMessage<MTL::StructType*>(this, _MTL_PRIVATE_SEL(structType));
}

_MTL_INLINE MTL::ArrayType* MTL::StructMember::arrayType()
{
    return Object::sendMessage<MTL::ArrayType*>(this, _MTL_PRIVATE_SEL(arrayType));
}

_MTL_INLINE MTL::TextureReferenceType* MTL::StructMember::textureReferenceType()
{
    return Object::sendMessage<MTL::TextureReferenceType*>(this, _MTL_PRIVATE_SEL(textureReferenceType));
}

_MTL_INLINE MTL::PointerType* MTL::StructMember::pointerType()
{
    return Object::sendMessage<MTL::PointerType*>(this, _MTL_PRIVATE_SEL(pointerType));
}

_MTL_INLINE NS::UInteger MTL::StructMember::argumentIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(argumentIndex));
}

_MTL_INLINE MTL::StructType* MTL::StructType::alloc()
{
    return NS::Object::alloc<MTL::StructType>(_MTL_PRIVATE_CLS(MTLStructType));
}

_MTL_INLINE MTL::StructType* MTL::StructType::init()
{
    return NS::Object::init<MTL::StructType>();
}

_MTL_INLINE NS::Array* MTL::StructType::members() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(members));
}

_MTL_INLINE MTL::StructMember* MTL::StructType::memberByName(const NS::String* name)
{
    return Object::sendMessage<MTL::StructMember*>(this, _MTL_PRIVATE_SEL(memberByName_), name);
}

_MTL_INLINE MTL::ArrayType* MTL::ArrayType::alloc()
{
    return NS::Object::alloc<MTL::ArrayType>(_MTL_PRIVATE_CLS(MTLArrayType));
}

_MTL_INLINE MTL::ArrayType* MTL::ArrayType::init()
{
    return NS::Object::init<MTL::ArrayType>();
}

_MTL_INLINE MTL::DataType MTL::ArrayType::elementType() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(elementType));
}

_MTL_INLINE NS::UInteger MTL::ArrayType::arrayLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(arrayLength));
}

_MTL_INLINE NS::UInteger MTL::ArrayType::stride() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(stride));
}

_MTL_INLINE NS::UInteger MTL::ArrayType::argumentIndexStride() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(argumentIndexStride));
}

_MTL_INLINE MTL::StructType* MTL::ArrayType::elementStructType()
{
    return Object::sendMessage<MTL::StructType*>(this, _MTL_PRIVATE_SEL(elementStructType));
}

_MTL_INLINE MTL::ArrayType* MTL::ArrayType::elementArrayType()
{
    return Object::sendMessage<MTL::ArrayType*>(this, _MTL_PRIVATE_SEL(elementArrayType));
}

_MTL_INLINE MTL::TextureReferenceType* MTL::ArrayType::elementTextureReferenceType()
{
    return Object::sendMessage<MTL::TextureReferenceType*>(this, _MTL_PRIVATE_SEL(elementTextureReferenceType));
}

_MTL_INLINE MTL::PointerType* MTL::ArrayType::elementPointerType()
{
    return Object::sendMessage<MTL::PointerType*>(this, _MTL_PRIVATE_SEL(elementPointerType));
}

_MTL_INLINE MTL::PointerType* MTL::PointerType::alloc()
{
    return NS::Object::alloc<MTL::PointerType>(_MTL_PRIVATE_CLS(MTLPointerType));
}

_MTL_INLINE MTL::PointerType* MTL::PointerType::init()
{
    return NS::Object::init<MTL::PointerType>();
}

_MTL_INLINE MTL::DataType MTL::PointerType::elementType() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(elementType));
}

_MTL_INLINE MTL::ArgumentAccess MTL::PointerType::access() const
{
    return Object::sendMessage<MTL::ArgumentAccess>(this, _MTL_PRIVATE_SEL(access));
}

_MTL_INLINE NS::UInteger MTL::PointerType::alignment() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(alignment));
}

_MTL_INLINE NS::UInteger MTL::PointerType::dataSize() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(dataSize));
}

_MTL_INLINE bool MTL::PointerType::elementIsArgumentBuffer() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(elementIsArgumentBuffer));
}

_MTL_INLINE MTL::StructType* MTL::PointerType::elementStructType()
{
    return Object::sendMessage<MTL::StructType*>(this, _MTL_PRIVATE_SEL(elementStructType));
}

_MTL_INLINE MTL::ArrayType* MTL::PointerType::elementArrayType()
{
    return Object::sendMessage<MTL::ArrayType*>(this, _MTL_PRIVATE_SEL(elementArrayType));
}

_MTL_INLINE MTL::TextureReferenceType* MTL::TextureReferenceType::alloc()
{
    return NS::Object::alloc<MTL::TextureReferenceType>(_MTL_PRIVATE_CLS(MTLTextureReferenceType));
}

_MTL_INLINE MTL::TextureReferenceType* MTL::TextureReferenceType::init()
{
    return NS::Object::init<MTL::TextureReferenceType>();
}

_MTL_INLINE MTL::DataType MTL::TextureReferenceType::textureDataType() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(textureDataType));
}

_MTL_INLINE MTL::TextureType MTL::TextureReferenceType::textureType() const
{
    return Object::sendMessage<MTL::TextureType>(this, _MTL_PRIVATE_SEL(textureType));
}

_MTL_INLINE MTL::ArgumentAccess MTL::TextureReferenceType::access() const
{
    return Object::sendMessage<MTL::ArgumentAccess>(this, _MTL_PRIVATE_SEL(access));
}

_MTL_INLINE bool MTL::TextureReferenceType::isDepthTexture() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isDepthTexture));
}

_MTL_INLINE MTL::Argument* MTL::Argument::alloc()
{
    return NS::Object::alloc<MTL::Argument>(_MTL_PRIVATE_CLS(MTLArgument));
}

_MTL_INLINE MTL::Argument* MTL::Argument::init()
{
    return NS::Object::init<MTL::Argument>();
}

_MTL_INLINE NS::String* MTL::Argument::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE MTL::ArgumentType MTL::Argument::type() const
{
    return Object::sendMessage<MTL::ArgumentType>(this, _MTL_PRIVATE_SEL(type));
}

_MTL_INLINE MTL::ArgumentAccess MTL::Argument::access() const
{
    return Object::sendMessage<MTL::ArgumentAccess>(this, _MTL_PRIVATE_SEL(access));
}

_MTL_INLINE NS::UInteger MTL::Argument::index() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(index));
}

_MTL_INLINE bool MTL::Argument::active() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isActive));
}

_MTL_INLINE NS::UInteger MTL::Argument::bufferAlignment() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(bufferAlignment));
}

_MTL_INLINE NS::UInteger MTL::Argument::bufferDataSize() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(bufferDataSize));
}

_MTL_INLINE MTL::DataType MTL::Argument::bufferDataType() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(bufferDataType));
}

_MTL_INLINE MTL::StructType* MTL::Argument::bufferStructType() const
{
    return Object::sendMessage<MTL::StructType*>(this, _MTL_PRIVATE_SEL(bufferStructType));
}

_MTL_INLINE MTL::PointerType* MTL::Argument::bufferPointerType() const
{
    return Object::sendMessage<MTL::PointerType*>(this, _MTL_PRIVATE_SEL(bufferPointerType));
}

_MTL_INLINE NS::UInteger MTL::Argument::threadgroupMemoryAlignment() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(threadgroupMemoryAlignment));
}

_MTL_INLINE NS::UInteger MTL::Argument::threadgroupMemoryDataSize() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(threadgroupMemoryDataSize));
}

_MTL_INLINE MTL::TextureType MTL::Argument::textureType() const
{
    return Object::sendMessage<MTL::TextureType>(this, _MTL_PRIVATE_SEL(textureType));
}

_MTL_INLINE MTL::DataType MTL::Argument::textureDataType() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(textureDataType));
}

_MTL_INLINE bool MTL::Argument::isDepthTexture() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isDepthTexture));
}

_MTL_INLINE NS::UInteger MTL::Argument::arrayLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(arrayLength));
}

#pragma once

namespace MTL
{
_MTL_OPTIONS(NS::UInteger, ResourceUsage) {
    ResourceUsageRead = 1,
    ResourceUsageWrite = 2,
    ResourceUsageSample = 4,
};

_MTL_OPTIONS(NS::UInteger, BarrierScope) {
    BarrierScopeBuffers = 1,
    BarrierScopeTextures = 2,
    BarrierScopeRenderTargets = 4,
};

class CommandEncoder : public NS::Referencing<CommandEncoder>
{
public:
    class Device* device() const;

    NS::String*   label() const;
    void          setLabel(const NS::String* label);

    void          endEncoding();

    void          insertDebugSignpost(const NS::String* string);

    void          pushDebugGroup(const NS::String* string);

    void          popDebugGroup();
};

}

_MTL_INLINE MTL::Device* MTL::CommandEncoder::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::String* MTL::CommandEncoder::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::CommandEncoder::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE void MTL::CommandEncoder::endEncoding()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(endEncoding));
}

_MTL_INLINE void MTL::CommandEncoder::insertDebugSignpost(const NS::String* string)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(insertDebugSignpost_), string);
}

_MTL_INLINE void MTL::CommandEncoder::pushDebugGroup(const NS::String* string)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(pushDebugGroup_), string);
}

_MTL_INLINE void MTL::CommandEncoder::popDebugGroup()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(popDebugGroup));
}

#pragma once

namespace MTL
{
_MTL_ENUM(NS::Integer, HeapType) {
    HeapTypeAutomatic = 0,
    HeapTypePlacement = 1,
    HeapTypeSparse = 2,
};

class HeapDescriptor : public NS::Copying<HeapDescriptor>
{
public:
    static class HeapDescriptor* alloc();

    class HeapDescriptor*        init();

    NS::UInteger                 size() const;
    void                         setSize(NS::UInteger size);

    MTL::StorageMode             storageMode() const;
    void                         setStorageMode(MTL::StorageMode storageMode);

    MTL::CPUCacheMode            cpuCacheMode() const;
    void                         setCpuCacheMode(MTL::CPUCacheMode cpuCacheMode);

    MTL::HazardTrackingMode      hazardTrackingMode() const;
    void                         setHazardTrackingMode(MTL::HazardTrackingMode hazardTrackingMode);

    MTL::ResourceOptions         resourceOptions() const;
    void                         setResourceOptions(MTL::ResourceOptions resourceOptions);

    MTL::HeapType                type() const;
    void                         setType(MTL::HeapType type);
};

class Heap : public NS::Referencing<Heap>
{
public:
    NS::String*             label() const;
    void                    setLabel(const NS::String* label);

    class Device*           device() const;

    MTL::StorageMode        storageMode() const;

    MTL::CPUCacheMode       cpuCacheMode() const;

    MTL::HazardTrackingMode hazardTrackingMode() const;

    MTL::ResourceOptions    resourceOptions() const;

    NS::UInteger            size() const;

    NS::UInteger            usedSize() const;

    NS::UInteger            currentAllocatedSize() const;

    NS::UInteger            maxAvailableSize(NS::UInteger alignment);

    class Buffer*           newBuffer(NS::UInteger length, MTL::ResourceOptions options);

    class Texture*          newTexture(const class TextureDescriptor* desc);

    MTL::PurgeableState     setPurgeableState(MTL::PurgeableState state);

    MTL::HeapType           type() const;

    class Buffer*           newBuffer(NS::UInteger length, MTL::ResourceOptions options, NS::UInteger offset);

    class Texture*          newTexture(const class TextureDescriptor* descriptor, NS::UInteger offset);
};

}

_MTL_INLINE MTL::HeapDescriptor* MTL::HeapDescriptor::alloc()
{
    return NS::Object::alloc<MTL::HeapDescriptor>(_MTL_PRIVATE_CLS(MTLHeapDescriptor));
}

_MTL_INLINE MTL::HeapDescriptor* MTL::HeapDescriptor::init()
{
    return NS::Object::init<MTL::HeapDescriptor>();
}

_MTL_INLINE NS::UInteger MTL::HeapDescriptor::size() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(size));
}

_MTL_INLINE void MTL::HeapDescriptor::setSize(NS::UInteger size)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSize_), size);
}

_MTL_INLINE MTL::StorageMode MTL::HeapDescriptor::storageMode() const
{
    return Object::sendMessage<MTL::StorageMode>(this, _MTL_PRIVATE_SEL(storageMode));
}

_MTL_INLINE void MTL::HeapDescriptor::setStorageMode(MTL::StorageMode storageMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStorageMode_), storageMode);
}

_MTL_INLINE MTL::CPUCacheMode MTL::HeapDescriptor::cpuCacheMode() const
{
    return Object::sendMessage<MTL::CPUCacheMode>(this, _MTL_PRIVATE_SEL(cpuCacheMode));
}

_MTL_INLINE void MTL::HeapDescriptor::setCpuCacheMode(MTL::CPUCacheMode cpuCacheMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setCpuCacheMode_), cpuCacheMode);
}

_MTL_INLINE MTL::HazardTrackingMode MTL::HeapDescriptor::hazardTrackingMode() const
{
    return Object::sendMessage<MTL::HazardTrackingMode>(this, _MTL_PRIVATE_SEL(hazardTrackingMode));
}

_MTL_INLINE void MTL::HeapDescriptor::setHazardTrackingMode(MTL::HazardTrackingMode hazardTrackingMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setHazardTrackingMode_), hazardTrackingMode);
}

_MTL_INLINE MTL::ResourceOptions MTL::HeapDescriptor::resourceOptions() const
{
    return Object::sendMessage<MTL::ResourceOptions>(this, _MTL_PRIVATE_SEL(resourceOptions));
}

_MTL_INLINE void MTL::HeapDescriptor::setResourceOptions(MTL::ResourceOptions resourceOptions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setResourceOptions_), resourceOptions);
}

_MTL_INLINE MTL::HeapType MTL::HeapDescriptor::type() const
{
    return Object::sendMessage<MTL::HeapType>(this, _MTL_PRIVATE_SEL(type));
}

_MTL_INLINE void MTL::HeapDescriptor::setType(MTL::HeapType type)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setType_), type);
}

_MTL_INLINE NS::String* MTL::Heap::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::Heap::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::Device* MTL::Heap::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE MTL::StorageMode MTL::Heap::storageMode() const
{
    return Object::sendMessage<MTL::StorageMode>(this, _MTL_PRIVATE_SEL(storageMode));
}

_MTL_INLINE MTL::CPUCacheMode MTL::Heap::cpuCacheMode() const
{
    return Object::sendMessage<MTL::CPUCacheMode>(this, _MTL_PRIVATE_SEL(cpuCacheMode));
}

_MTL_INLINE MTL::HazardTrackingMode MTL::Heap::hazardTrackingMode() const
{
    return Object::sendMessage<MTL::HazardTrackingMode>(this, _MTL_PRIVATE_SEL(hazardTrackingMode));
}

_MTL_INLINE MTL::ResourceOptions MTL::Heap::resourceOptions() const
{
    return Object::sendMessage<MTL::ResourceOptions>(this, _MTL_PRIVATE_SEL(resourceOptions));
}

_MTL_INLINE NS::UInteger MTL::Heap::size() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(size));
}

_MTL_INLINE NS::UInteger MTL::Heap::usedSize() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(usedSize));
}

_MTL_INLINE NS::UInteger MTL::Heap::currentAllocatedSize() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(currentAllocatedSize));
}

_MTL_INLINE NS::UInteger MTL::Heap::maxAvailableSize(NS::UInteger alignment)
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxAvailableSizeWithAlignment_), alignment);
}

_MTL_INLINE MTL::Buffer* MTL::Heap::newBuffer(NS::UInteger length, MTL::ResourceOptions options)
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(newBufferWithLength_options_), length, options);
}

_MTL_INLINE MTL::Texture* MTL::Heap::newTexture(const MTL::TextureDescriptor* desc)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newTextureWithDescriptor_), desc);
}

_MTL_INLINE MTL::PurgeableState MTL::Heap::setPurgeableState(MTL::PurgeableState state)
{
    return Object::sendMessage<MTL::PurgeableState>(this, _MTL_PRIVATE_SEL(setPurgeableState_), state);
}

_MTL_INLINE MTL::HeapType MTL::Heap::type() const
{
    return Object::sendMessage<MTL::HeapType>(this, _MTL_PRIVATE_SEL(type));
}

_MTL_INLINE MTL::Buffer* MTL::Heap::newBuffer(NS::UInteger length, MTL::ResourceOptions options, NS::UInteger offset)
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(newBufferWithLength_options_offset_), length, options, offset);
}

_MTL_INLINE MTL::Texture* MTL::Heap::newTexture(const MTL::TextureDescriptor* descriptor, NS::UInteger offset)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newTextureWithDescriptor_offset_), descriptor, offset);
}

namespace MTL
{
class AccelerationStructureCommandEncoder : public NS::Referencing<AccelerationStructureCommandEncoder, CommandEncoder>
{
public:
    void buildAccelerationStructure(const class AccelerationStructure* accelerationStructure, const class AccelerationStructureDescriptor* descriptor, const class Buffer* scratchBuffer, NS::UInteger scratchBufferOffset);

    void refitAccelerationStructure(const class AccelerationStructure* sourceAccelerationStructure, const class AccelerationStructureDescriptor* descriptor, const class AccelerationStructure* destinationAccelerationStructure, const class Buffer* scratchBuffer, NS::UInteger scratchBufferOffset);

    void copyAccelerationStructure(const class AccelerationStructure* sourceAccelerationStructure, const class AccelerationStructure* destinationAccelerationStructure);

    void writeCompactedAccelerationStructureSize(const class AccelerationStructure* accelerationStructure, const class Buffer* buffer, NS::UInteger offset);

    void writeCompactedAccelerationStructureSize(const class AccelerationStructure* accelerationStructure, const class Buffer* buffer, NS::UInteger offset, MTL::DataType sizeDataType);

    void copyAndCompactAccelerationStructure(const class AccelerationStructure* sourceAccelerationStructure, const class AccelerationStructure* destinationAccelerationStructure);

    void updateFence(const class Fence* fence);

    void waitForFence(const class Fence* fence);

    void useResource(const class Resource* resource, MTL::ResourceUsage usage);

    void useResources(MTL::Resource* resources[], NS::UInteger count, MTL::ResourceUsage usage);

    void useHeap(const class Heap* heap);

    void useHeaps(MTL::Heap* heaps[], NS::UInteger count);

    void sampleCountersInBuffer(const class CounterSampleBuffer* sampleBuffer, NS::UInteger sampleIndex, bool barrier);
};

}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::buildAccelerationStructure(const MTL::AccelerationStructure* accelerationStructure, const MTL::AccelerationStructureDescriptor* descriptor, const MTL::Buffer* scratchBuffer, NS::UInteger scratchBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(buildAccelerationStructure_descriptor_scratchBuffer_scratchBufferOffset_), accelerationStructure, descriptor, scratchBuffer, scratchBufferOffset);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::refitAccelerationStructure(const MTL::AccelerationStructure* sourceAccelerationStructure, const MTL::AccelerationStructureDescriptor* descriptor, const MTL::AccelerationStructure* destinationAccelerationStructure, const MTL::Buffer* scratchBuffer, NS::UInteger scratchBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(refitAccelerationStructure_descriptor_destination_scratchBuffer_scratchBufferOffset_), sourceAccelerationStructure, descriptor, destinationAccelerationStructure, scratchBuffer, scratchBufferOffset);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::copyAccelerationStructure(const MTL::AccelerationStructure* sourceAccelerationStructure, const MTL::AccelerationStructure* destinationAccelerationStructure)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyAccelerationStructure_toAccelerationStructure_), sourceAccelerationStructure, destinationAccelerationStructure);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::writeCompactedAccelerationStructureSize(const MTL::AccelerationStructure* accelerationStructure, const MTL::Buffer* buffer, NS::UInteger offset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(writeCompactedAccelerationStructureSize_toBuffer_offset_), accelerationStructure, buffer, offset);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::writeCompactedAccelerationStructureSize(const MTL::AccelerationStructure* accelerationStructure, const MTL::Buffer* buffer, NS::UInteger offset, MTL::DataType sizeDataType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(writeCompactedAccelerationStructureSize_toBuffer_offset_sizeDataType_), accelerationStructure, buffer, offset, sizeDataType);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::copyAndCompactAccelerationStructure(const MTL::AccelerationStructure* sourceAccelerationStructure, const MTL::AccelerationStructure* destinationAccelerationStructure)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyAndCompactAccelerationStructure_toAccelerationStructure_), sourceAccelerationStructure, destinationAccelerationStructure);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::updateFence(const MTL::Fence* fence)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(updateFence_), fence);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::waitForFence(const MTL::Fence* fence)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(waitForFence_), fence);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::useResource(const MTL::Resource* resource, MTL::ResourceUsage usage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useResource_usage_), resource, usage);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::useResources(MTL::Resource* resources[], NS::UInteger count, MTL::ResourceUsage usage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useResources_count_usage_), resources, count, usage);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::useHeap(const MTL::Heap* heap)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useHeap_), heap);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::useHeaps(MTL::Heap* heaps[], NS::UInteger count)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useHeaps_count_), heaps, count);
}

_MTL_INLINE void MTL::AccelerationStructureCommandEncoder::sampleCountersInBuffer(const MTL::CounterSampleBuffer* sampleBuffer, NS::UInteger sampleIndex, bool barrier)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(sampleCountersInBuffer_atSampleIndex_withBarrier_), sampleBuffer, sampleIndex, barrier);
}

#pragma once

#pragma once

namespace MTL
{
class Buffer : public NS::Referencing<Buffer, Resource>
{
public:
    NS::UInteger   length() const;

    void*          contents();

    void           didModifyRange(NS::Range range);

    class Texture* newTexture(const class TextureDescriptor* descriptor, NS::UInteger offset, NS::UInteger bytesPerRow);

    void           addDebugMarker(const NS::String* marker, NS::Range range);

    void           removeAllDebugMarkers();

    class Buffer*  remoteStorageBuffer() const;

    class Buffer*  newRemoteBufferViewForDevice(const class Device* device);
};

}

_MTL_INLINE NS::UInteger MTL::Buffer::length() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(length));
}

_MTL_INLINE void* MTL::Buffer::contents()
{
    return Object::sendMessage<void*>(this, _MTL_PRIVATE_SEL(contents));
}

_MTL_INLINE void MTL::Buffer::didModifyRange(NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(didModifyRange_), range);
}

_MTL_INLINE MTL::Texture* MTL::Buffer::newTexture(const MTL::TextureDescriptor* descriptor, NS::UInteger offset, NS::UInteger bytesPerRow)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newTextureWithDescriptor_offset_bytesPerRow_), descriptor, offset, bytesPerRow);
}

_MTL_INLINE void MTL::Buffer::addDebugMarker(const NS::String* marker, NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(addDebugMarker_range_), marker, range);
}

_MTL_INLINE void MTL::Buffer::removeAllDebugMarkers()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(removeAllDebugMarkers));
}

_MTL_INLINE MTL::Buffer* MTL::Buffer::remoteStorageBuffer() const
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(remoteStorageBuffer));
}

_MTL_INLINE MTL::Buffer* MTL::Buffer::newRemoteBufferViewForDevice(const MTL::Device* device)
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(newRemoteBufferViewForDevice_), device);
}

#pragma once

namespace MTL
{
class ComputePipelineReflection : public NS::Referencing<ComputePipelineReflection>
{
public:
    static class ComputePipelineReflection* alloc();

    class ComputePipelineReflection*        init();

    NS::Array*                              arguments() const;
};

class ComputePipelineDescriptor : public NS::Copying<ComputePipelineDescriptor>
{
public:
    static class ComputePipelineDescriptor* alloc();

    class ComputePipelineDescriptor*        init();

    NS::String*                             label() const;
    void                                    setLabel(const NS::String* label);

    class Function*                         computeFunction() const;
    void                                    setComputeFunction(const class Function* computeFunction);

    bool                                    threadGroupSizeIsMultipleOfThreadExecutionWidth() const;
    void                                    setThreadGroupSizeIsMultipleOfThreadExecutionWidth(bool threadGroupSizeIsMultipleOfThreadExecutionWidth);

    NS::UInteger                            maxTotalThreadsPerThreadgroup() const;
    void                                    setMaxTotalThreadsPerThreadgroup(NS::UInteger maxTotalThreadsPerThreadgroup);

    class StageInputOutputDescriptor*       stageInputDescriptor() const;
    void                                    setStageInputDescriptor(const class StageInputOutputDescriptor* stageInputDescriptor);

    class PipelineBufferDescriptorArray*    buffers() const;

    bool                                    supportIndirectCommandBuffers() const;
    void                                    setSupportIndirectCommandBuffers(bool supportIndirectCommandBuffers);

    NS::Array*                              insertLibraries() const;
    void                                    setInsertLibraries(const NS::Array* insertLibraries);

    NS::Array*                              preloadedLibraries() const;
    void                                    setPreloadedLibraries(const NS::Array* preloadedLibraries);

    NS::Array*                              binaryArchives() const;
    void                                    setBinaryArchives(const NS::Array* binaryArchives);

    void                                    reset();

    class LinkedFunctions*                  linkedFunctions() const;
    void                                    setLinkedFunctions(const class LinkedFunctions* linkedFunctions);

    bool                                    supportAddingBinaryFunctions() const;
    void                                    setSupportAddingBinaryFunctions(bool supportAddingBinaryFunctions);

    NS::UInteger                            maxCallStackDepth() const;
    void                                    setMaxCallStackDepth(NS::UInteger maxCallStackDepth);
};

class ComputePipelineState : public NS::Referencing<ComputePipelineState>
{
public:
    NS::String*                      label() const;

    class Device*                    device() const;

    NS::UInteger                     maxTotalThreadsPerThreadgroup() const;

    NS::UInteger                     threadExecutionWidth() const;

    NS::UInteger                     staticThreadgroupMemoryLength() const;

    NS::UInteger                     imageblockMemoryLength(MTL::Size imageblockDimensions);

    bool                             supportIndirectCommandBuffers() const;

    class FunctionHandle*            functionHandle(const class Function* function);

    class ComputePipelineState*      newComputePipelineState(const NS::Array* functions, NS::Error** error);

    class VisibleFunctionTable*      newVisibleFunctionTable(const class VisibleFunctionTableDescriptor* descriptor);

    class IntersectionFunctionTable* newIntersectionFunctionTable(const class IntersectionFunctionTableDescriptor* descriptor);
};

}

_MTL_INLINE MTL::ComputePipelineReflection* MTL::ComputePipelineReflection::alloc()
{
    return NS::Object::alloc<MTL::ComputePipelineReflection>(_MTL_PRIVATE_CLS(MTLComputePipelineReflection));
}

_MTL_INLINE MTL::ComputePipelineReflection* MTL::ComputePipelineReflection::init()
{
    return NS::Object::init<MTL::ComputePipelineReflection>();
}

_MTL_INLINE NS::Array* MTL::ComputePipelineReflection::arguments() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(arguments));
}

_MTL_INLINE MTL::ComputePipelineDescriptor* MTL::ComputePipelineDescriptor::alloc()
{
    return NS::Object::alloc<MTL::ComputePipelineDescriptor>(_MTL_PRIVATE_CLS(MTLComputePipelineDescriptor));
}

_MTL_INLINE MTL::ComputePipelineDescriptor* MTL::ComputePipelineDescriptor::init()
{
    return NS::Object::init<MTL::ComputePipelineDescriptor>();
}

_MTL_INLINE NS::String* MTL::ComputePipelineDescriptor::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::Function* MTL::ComputePipelineDescriptor::computeFunction() const
{
    return Object::sendMessage<MTL::Function*>(this, _MTL_PRIVATE_SEL(computeFunction));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setComputeFunction(const MTL::Function* computeFunction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setComputeFunction_), computeFunction);
}

_MTL_INLINE bool MTL::ComputePipelineDescriptor::threadGroupSizeIsMultipleOfThreadExecutionWidth() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(threadGroupSizeIsMultipleOfThreadExecutionWidth));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setThreadGroupSizeIsMultipleOfThreadExecutionWidth(bool threadGroupSizeIsMultipleOfThreadExecutionWidth)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setThreadGroupSizeIsMultipleOfThreadExecutionWidth_), threadGroupSizeIsMultipleOfThreadExecutionWidth);
}

_MTL_INLINE NS::UInteger MTL::ComputePipelineDescriptor::maxTotalThreadsPerThreadgroup() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxTotalThreadsPerThreadgroup));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setMaxTotalThreadsPerThreadgroup(NS::UInteger maxTotalThreadsPerThreadgroup)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxTotalThreadsPerThreadgroup_), maxTotalThreadsPerThreadgroup);
}

_MTL_INLINE MTL::StageInputOutputDescriptor* MTL::ComputePipelineDescriptor::stageInputDescriptor() const
{
    return Object::sendMessage<MTL::StageInputOutputDescriptor*>(this, _MTL_PRIVATE_SEL(stageInputDescriptor));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setStageInputDescriptor(const MTL::StageInputOutputDescriptor* stageInputDescriptor)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStageInputDescriptor_), stageInputDescriptor);
}

_MTL_INLINE MTL::PipelineBufferDescriptorArray* MTL::ComputePipelineDescriptor::buffers() const
{
    return Object::sendMessage<MTL::PipelineBufferDescriptorArray*>(this, _MTL_PRIVATE_SEL(buffers));
}

_MTL_INLINE bool MTL::ComputePipelineDescriptor::supportIndirectCommandBuffers() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportIndirectCommandBuffers));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setSupportIndirectCommandBuffers(bool supportIndirectCommandBuffers)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSupportIndirectCommandBuffers_), supportIndirectCommandBuffers);
}

_MTL_INLINE NS::Array* MTL::ComputePipelineDescriptor::insertLibraries() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(insertLibraries));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setInsertLibraries(const NS::Array* insertLibraries)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInsertLibraries_), insertLibraries);
}

_MTL_INLINE NS::Array* MTL::ComputePipelineDescriptor::preloadedLibraries() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(preloadedLibraries));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setPreloadedLibraries(const NS::Array* preloadedLibraries)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setPreloadedLibraries_), preloadedLibraries);
}

_MTL_INLINE NS::Array* MTL::ComputePipelineDescriptor::binaryArchives() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(binaryArchives));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setBinaryArchives(const NS::Array* binaryArchives)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBinaryArchives_), binaryArchives);
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::reset()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(reset));
}

_MTL_INLINE MTL::LinkedFunctions* MTL::ComputePipelineDescriptor::linkedFunctions() const
{
    return Object::sendMessage<MTL::LinkedFunctions*>(this, _MTL_PRIVATE_SEL(linkedFunctions));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setLinkedFunctions(const MTL::LinkedFunctions* linkedFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLinkedFunctions_), linkedFunctions);
}

_MTL_INLINE bool MTL::ComputePipelineDescriptor::supportAddingBinaryFunctions() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportAddingBinaryFunctions));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setSupportAddingBinaryFunctions(bool supportAddingBinaryFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSupportAddingBinaryFunctions_), supportAddingBinaryFunctions);
}

_MTL_INLINE NS::UInteger MTL::ComputePipelineDescriptor::maxCallStackDepth() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxCallStackDepth));
}

_MTL_INLINE void MTL::ComputePipelineDescriptor::setMaxCallStackDepth(NS::UInteger maxCallStackDepth)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxCallStackDepth_), maxCallStackDepth);
}

_MTL_INLINE NS::String* MTL::ComputePipelineState::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE MTL::Device* MTL::ComputePipelineState::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::UInteger MTL::ComputePipelineState::maxTotalThreadsPerThreadgroup() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxTotalThreadsPerThreadgroup));
}

_MTL_INLINE NS::UInteger MTL::ComputePipelineState::threadExecutionWidth() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(threadExecutionWidth));
}

_MTL_INLINE NS::UInteger MTL::ComputePipelineState::staticThreadgroupMemoryLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(staticThreadgroupMemoryLength));
}

_MTL_INLINE NS::UInteger MTL::ComputePipelineState::imageblockMemoryLength(MTL::Size imageblockDimensions)
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(imageblockMemoryLengthForDimensions_), imageblockDimensions);
}

_MTL_INLINE bool MTL::ComputePipelineState::supportIndirectCommandBuffers() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportIndirectCommandBuffers));
}

_MTL_INLINE MTL::FunctionHandle* MTL::ComputePipelineState::functionHandle(const MTL::Function* function)
{
    return Object::sendMessage<MTL::FunctionHandle*>(this, _MTL_PRIVATE_SEL(functionHandleWithFunction_), function);
}

_MTL_INLINE MTL::ComputePipelineState* MTL::ComputePipelineState::newComputePipelineState(const NS::Array* functions, NS::Error** error)
{
    return Object::sendMessage<MTL::ComputePipelineState*>(this, _MTL_PRIVATE_SEL(newComputePipelineStateWithAdditionalBinaryFunctions_error_), functions, error);
}

_MTL_INLINE MTL::VisibleFunctionTable* MTL::ComputePipelineState::newVisibleFunctionTable(const MTL::VisibleFunctionTableDescriptor* descriptor)
{
    return Object::sendMessage<MTL::VisibleFunctionTable*>(this, _MTL_PRIVATE_SEL(newVisibleFunctionTableWithDescriptor_), descriptor);
}

_MTL_INLINE MTL::IntersectionFunctionTable* MTL::ComputePipelineState::newIntersectionFunctionTable(const MTL::IntersectionFunctionTableDescriptor* descriptor)
{
    return Object::sendMessage<MTL::IntersectionFunctionTable*>(this, _MTL_PRIVATE_SEL(newIntersectionFunctionTableWithDescriptor_), descriptor);
}

#pragma once

namespace MTL
{
_MTL_OPTIONS(NS::UInteger, IndirectCommandType) {
    IndirectCommandTypeDraw = 1,
    IndirectCommandTypeDrawIndexed = 2,
    IndirectCommandTypeDrawPatches = 4,
    IndirectCommandTypeDrawIndexedPatches = 8,
    IndirectCommandTypeConcurrentDispatch = 32,
    IndirectCommandTypeConcurrentDispatchThreads = 64,
};

struct IndirectCommandBufferExecutionRange
{
    uint32_t location;
    uint32_t length;
} _MTL_PACKED;

class IndirectCommandBufferDescriptor : public NS::Copying<IndirectCommandBufferDescriptor>
{
public:
    static class IndirectCommandBufferDescriptor* alloc();

    class IndirectCommandBufferDescriptor*        init();

    MTL::IndirectCommandType                      commandTypes() const;
    void                                          setCommandTypes(MTL::IndirectCommandType commandTypes);

    bool                                          inheritPipelineState() const;
    void                                          setInheritPipelineState(bool inheritPipelineState);

    bool                                          inheritBuffers() const;
    void                                          setInheritBuffers(bool inheritBuffers);

    NS::UInteger                                  maxVertexBufferBindCount() const;
    void                                          setMaxVertexBufferBindCount(NS::UInteger maxVertexBufferBindCount);

    NS::UInteger                                  maxFragmentBufferBindCount() const;
    void                                          setMaxFragmentBufferBindCount(NS::UInteger maxFragmentBufferBindCount);

    NS::UInteger                                  maxKernelBufferBindCount() const;
    void                                          setMaxKernelBufferBindCount(NS::UInteger maxKernelBufferBindCount);
};

class IndirectCommandBuffer : public NS::Referencing<IndirectCommandBuffer, Resource>
{
public:
    NS::UInteger                  size() const;

    void                          reset(NS::Range range);

    class IndirectRenderCommand*  indirectRenderCommand(NS::UInteger commandIndex);

    class IndirectComputeCommand* indirectComputeCommand(NS::UInteger commandIndex);
};

}

_MTL_INLINE MTL::IndirectCommandBufferDescriptor* MTL::IndirectCommandBufferDescriptor::alloc()
{
    return NS::Object::alloc<MTL::IndirectCommandBufferDescriptor>(_MTL_PRIVATE_CLS(MTLIndirectCommandBufferDescriptor));
}

_MTL_INLINE MTL::IndirectCommandBufferDescriptor* MTL::IndirectCommandBufferDescriptor::init()
{
    return NS::Object::init<MTL::IndirectCommandBufferDescriptor>();
}

_MTL_INLINE MTL::IndirectCommandType MTL::IndirectCommandBufferDescriptor::commandTypes() const
{
    return Object::sendMessage<MTL::IndirectCommandType>(this, _MTL_PRIVATE_SEL(commandTypes));
}

_MTL_INLINE void MTL::IndirectCommandBufferDescriptor::setCommandTypes(MTL::IndirectCommandType commandTypes)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setCommandTypes_), commandTypes);
}

_MTL_INLINE bool MTL::IndirectCommandBufferDescriptor::inheritPipelineState() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(inheritPipelineState));
}

_MTL_INLINE void MTL::IndirectCommandBufferDescriptor::setInheritPipelineState(bool inheritPipelineState)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInheritPipelineState_), inheritPipelineState);
}

_MTL_INLINE bool MTL::IndirectCommandBufferDescriptor::inheritBuffers() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(inheritBuffers));
}

_MTL_INLINE void MTL::IndirectCommandBufferDescriptor::setInheritBuffers(bool inheritBuffers)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInheritBuffers_), inheritBuffers);
}

_MTL_INLINE NS::UInteger MTL::IndirectCommandBufferDescriptor::maxVertexBufferBindCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxVertexBufferBindCount));
}

_MTL_INLINE void MTL::IndirectCommandBufferDescriptor::setMaxVertexBufferBindCount(NS::UInteger maxVertexBufferBindCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxVertexBufferBindCount_), maxVertexBufferBindCount);
}

_MTL_INLINE NS::UInteger MTL::IndirectCommandBufferDescriptor::maxFragmentBufferBindCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxFragmentBufferBindCount));
}

_MTL_INLINE void MTL::IndirectCommandBufferDescriptor::setMaxFragmentBufferBindCount(NS::UInteger maxFragmentBufferBindCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxFragmentBufferBindCount_), maxFragmentBufferBindCount);
}

_MTL_INLINE NS::UInteger MTL::IndirectCommandBufferDescriptor::maxKernelBufferBindCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxKernelBufferBindCount));
}

_MTL_INLINE void MTL::IndirectCommandBufferDescriptor::setMaxKernelBufferBindCount(NS::UInteger maxKernelBufferBindCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxKernelBufferBindCount_), maxKernelBufferBindCount);
}

_MTL_INLINE NS::UInteger MTL::IndirectCommandBuffer::size() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(size));
}

_MTL_INLINE void MTL::IndirectCommandBuffer::reset(NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(resetWithRange_), range);
}

_MTL_INLINE MTL::IndirectRenderCommand* MTL::IndirectCommandBuffer::indirectRenderCommand(NS::UInteger commandIndex)
{
    return Object::sendMessage<MTL::IndirectRenderCommand*>(this, _MTL_PRIVATE_SEL(indirectRenderCommandAtIndex_), commandIndex);
}

_MTL_INLINE MTL::IndirectComputeCommand* MTL::IndirectCommandBuffer::indirectComputeCommand(NS::UInteger commandIndex)
{
    return Object::sendMessage<MTL::IndirectComputeCommand*>(this, _MTL_PRIVATE_SEL(indirectComputeCommandAtIndex_), commandIndex);
}

#pragma once

#pragma once

#pragma once

#pragma once

namespace MTL
{
_MTL_OPTIONS(NS::UInteger, FunctionOptions) {
    FunctionOptionNone = 0,
    FunctionOptionCompileToBinary = 1,
};

class FunctionDescriptor : public NS::Copying<FunctionDescriptor>
{
public:
    static class FunctionDescriptor* alloc();

    class FunctionDescriptor*        init();

    static class FunctionDescriptor* functionDescriptor();

    NS::String*                      name() const;
    void                             setName(const NS::String* name);

    NS::String*                      specializedName() const;
    void                             setSpecializedName(const NS::String* specializedName);

    class FunctionConstantValues*    constantValues() const;
    void                             setConstantValues(const class FunctionConstantValues* constantValues);

    MTL::FunctionOptions             options() const;
    void                             setOptions(MTL::FunctionOptions options);

    NS::Array*                       binaryArchives() const;
    void                             setBinaryArchives(const NS::Array* binaryArchives);
};

class IntersectionFunctionDescriptor : public NS::Copying<IntersectionFunctionDescriptor, MTL::FunctionDescriptor>
{
public:
    static class IntersectionFunctionDescriptor* alloc();

    class IntersectionFunctionDescriptor*        init();
};

}

_MTL_INLINE MTL::FunctionDescriptor* MTL::FunctionDescriptor::alloc()
{
    return NS::Object::alloc<MTL::FunctionDescriptor>(_MTL_PRIVATE_CLS(MTLFunctionDescriptor));
}

_MTL_INLINE MTL::FunctionDescriptor* MTL::FunctionDescriptor::init()
{
    return NS::Object::init<MTL::FunctionDescriptor>();
}

_MTL_INLINE MTL::FunctionDescriptor* MTL::FunctionDescriptor::functionDescriptor()
{
    return Object::sendMessage<MTL::FunctionDescriptor*>(_MTL_PRIVATE_CLS(MTLFunctionDescriptor), _MTL_PRIVATE_SEL(functionDescriptor));
}

_MTL_INLINE NS::String* MTL::FunctionDescriptor::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE void MTL::FunctionDescriptor::setName(const NS::String* name)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setName_), name);
}

_MTL_INLINE NS::String* MTL::FunctionDescriptor::specializedName() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(specializedName));
}

_MTL_INLINE void MTL::FunctionDescriptor::setSpecializedName(const NS::String* specializedName)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSpecializedName_), specializedName);
}

_MTL_INLINE MTL::FunctionConstantValues* MTL::FunctionDescriptor::constantValues() const
{
    return Object::sendMessage<MTL::FunctionConstantValues*>(this, _MTL_PRIVATE_SEL(constantValues));
}

_MTL_INLINE void MTL::FunctionDescriptor::setConstantValues(const MTL::FunctionConstantValues* constantValues)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setConstantValues_), constantValues);
}

_MTL_INLINE MTL::FunctionOptions MTL::FunctionDescriptor::options() const
{
    return Object::sendMessage<MTL::FunctionOptions>(this, _MTL_PRIVATE_SEL(options));
}

_MTL_INLINE void MTL::FunctionDescriptor::setOptions(MTL::FunctionOptions options)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setOptions_), options);
}

_MTL_INLINE NS::Array* MTL::FunctionDescriptor::binaryArchives() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(binaryArchives));
}

_MTL_INLINE void MTL::FunctionDescriptor::setBinaryArchives(const NS::Array* binaryArchives)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBinaryArchives_), binaryArchives);
}

_MTL_INLINE MTL::IntersectionFunctionDescriptor* MTL::IntersectionFunctionDescriptor::alloc()
{
    return NS::Object::alloc<MTL::IntersectionFunctionDescriptor>(_MTL_PRIVATE_CLS(MTLIntersectionFunctionDescriptor));
}

_MTL_INLINE MTL::IntersectionFunctionDescriptor* MTL::IntersectionFunctionDescriptor::init()
{
    return NS::Object::init<MTL::IntersectionFunctionDescriptor>();
}

#include <functional>

namespace MTL
{
_MTL_ENUM(NS::UInteger, PatchType) {
    PatchTypeNone = 0,
    PatchTypeTriangle = 1,
    PatchTypeQuad = 2,
};

class VertexAttribute : public NS::Referencing<VertexAttribute>
{
public:
    static class VertexAttribute* alloc();

    class VertexAttribute*        init();

    NS::String*                   name() const;

    NS::UInteger                  attributeIndex() const;

    MTL::DataType                 attributeType() const;

    bool                          active() const;

    bool                          patchData() const;

    bool                          patchControlPointData() const;
};

class Attribute : public NS::Referencing<Attribute>
{
public:
    static class Attribute* alloc();

    class Attribute*        init();

    NS::String*             name() const;

    NS::UInteger            attributeIndex() const;

    MTL::DataType           attributeType() const;

    bool                    active() const;

    bool                    patchData() const;

    bool                    patchControlPointData() const;
};

_MTL_ENUM(NS::UInteger, FunctionType) {
    FunctionTypeVertex = 1,
    FunctionTypeFragment = 2,
    FunctionTypeKernel = 3,
    FunctionTypeVisible = 5,
    FunctionTypeIntersection = 6,
};

class FunctionConstant : public NS::Referencing<FunctionConstant>
{
public:
    static class FunctionConstant* alloc();

    class FunctionConstant*        init();

    NS::String*                    name() const;

    MTL::DataType                  type() const;

    NS::UInteger                   index() const;

    bool                           required() const;
};

using AutoreleasedArgument = class Argument*;

class Function : public NS::Referencing<Function>
{
public:
    NS::String*            label() const;
    void                   setLabel(const NS::String* label);

    class Device*          device() const;

    MTL::FunctionType      functionType() const;

    MTL::PatchType         patchType() const;

    NS::Integer            patchControlPointCount() const;

    NS::Array*             vertexAttributes() const;

    NS::Array*             stageInputAttributes() const;

    NS::String*            name() const;

    NS::Dictionary*        functionConstantsDictionary() const;

    class ArgumentEncoder* newArgumentEncoder(NS::UInteger bufferIndex);

    class ArgumentEncoder* newArgumentEncoder(NS::UInteger bufferIndex, const MTL::AutoreleasedArgument* reflection);

    MTL::FunctionOptions   options() const;
};

_MTL_ENUM(NS::UInteger, LanguageVersion) {
    LanguageVersion1_0 = 65536,
    LanguageVersion1_1 = 65537,
    LanguageVersion1_2 = 65538,
    LanguageVersion2_0 = 131072,
    LanguageVersion2_1 = 131073,
    LanguageVersion2_2 = 131074,
    LanguageVersion2_3 = 131075,
    LanguageVersion2_4 = 131076,
};

_MTL_ENUM(NS::Integer, LibraryType) {
    LibraryTypeExecutable = 0,
    LibraryTypeDynamic = 1,
};

class CompileOptions : public NS::Copying<CompileOptions>
{
public:
    static class CompileOptions* alloc();

    class CompileOptions*        init();

    NS::Dictionary*              preprocessorMacros() const;
    void                         setPreprocessorMacros(const NS::Dictionary* preprocessorMacros);

    bool                         fastMathEnabled() const;
    void                         setFastMathEnabled(bool fastMathEnabled);

    MTL::LanguageVersion         languageVersion() const;
    void                         setLanguageVersion(MTL::LanguageVersion languageVersion);

    MTL::LibraryType             libraryType() const;
    void                         setLibraryType(MTL::LibraryType libraryType);

    NS::String*                  installName() const;
    void                         setInstallName(const NS::String* installName);

    NS::Array*                   libraries() const;
    void                         setLibraries(const NS::Array* libraries);

    bool                         preserveInvariance() const;
    void                         setPreserveInvariance(bool preserveInvariance);
};

_MTL_ENUM(NS::UInteger, LibraryError) {
    LibraryErrorUnsupported = 1,
    LibraryErrorCompileFailure = 3,
    LibraryErrorCompileWarning = 4,
    LibraryErrorFunctionNotFound = 5,
    LibraryErrorFileNotFound = 6,
};

class Library : public NS::Referencing<Library>
{
public:
    void             newFunction(const NS::String* pFunctionName, const class FunctionConstantValues* pConstantValues, const std::function<void(Function* pFunction, NS::Error* pError)>& completionHandler);

    void             newFunction(const class FunctionDescriptor* pDescriptor, const std::function<void(Function* pFunction, NS::Error* pError)>& completionHandler);

    void             newIntersectionFunction(const class IntersectionFunctionDescriptor* pDescriptor, const std::function<void(Function* pFunction, NS::Error* pError)>& completionHandler);

    NS::String*      label() const;
    void             setLabel(const NS::String* label);

    class Device*    device() const;

    class Function*  newFunction(const NS::String* functionName);

    class Function*  newFunction(const NS::String* name, const class FunctionConstantValues* constantValues, NS::Error** error);

    void             newFunction(const NS::String* name, const class FunctionConstantValues* constantValues, void (^completionHandler)(MTL::Function*, NS::Error*));

    void             newFunction(const class FunctionDescriptor* descriptor, void (^completionHandler)(MTL::Function*, NS::Error*));

    class Function*  newFunction(const class FunctionDescriptor* descriptor, NS::Error** error);

    void             newIntersectionFunction(const class IntersectionFunctionDescriptor* descriptor, void (^completionHandler)(MTL::Function*, NS::Error*));

    class Function*  newIntersectionFunction(const class IntersectionFunctionDescriptor* descriptor, NS::Error** error);

    NS::Array*       functionNames() const;

    MTL::LibraryType type() const;

    NS::String*      installName() const;
};

}

_MTL_INLINE MTL::VertexAttribute* MTL::VertexAttribute::alloc()
{
    return NS::Object::alloc<MTL::VertexAttribute>(_MTL_PRIVATE_CLS(MTLVertexAttribute));
}

_MTL_INLINE MTL::VertexAttribute* MTL::VertexAttribute::init()
{
    return NS::Object::init<MTL::VertexAttribute>();
}

_MTL_INLINE NS::String* MTL::VertexAttribute::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE NS::UInteger MTL::VertexAttribute::attributeIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(attributeIndex));
}

_MTL_INLINE MTL::DataType MTL::VertexAttribute::attributeType() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(attributeType));
}

_MTL_INLINE bool MTL::VertexAttribute::active() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isActive));
}

_MTL_INLINE bool MTL::VertexAttribute::patchData() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isPatchData));
}

_MTL_INLINE bool MTL::VertexAttribute::patchControlPointData() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isPatchControlPointData));
}

_MTL_INLINE MTL::Attribute* MTL::Attribute::alloc()
{
    return NS::Object::alloc<MTL::Attribute>(_MTL_PRIVATE_CLS(MTLAttribute));
}

_MTL_INLINE MTL::Attribute* MTL::Attribute::init()
{
    return NS::Object::init<MTL::Attribute>();
}

_MTL_INLINE NS::String* MTL::Attribute::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE NS::UInteger MTL::Attribute::attributeIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(attributeIndex));
}

_MTL_INLINE MTL::DataType MTL::Attribute::attributeType() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(attributeType));
}

_MTL_INLINE bool MTL::Attribute::active() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isActive));
}

_MTL_INLINE bool MTL::Attribute::patchData() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isPatchData));
}

_MTL_INLINE bool MTL::Attribute::patchControlPointData() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isPatchControlPointData));
}

_MTL_INLINE MTL::FunctionConstant* MTL::FunctionConstant::alloc()
{
    return NS::Object::alloc<MTL::FunctionConstant>(_MTL_PRIVATE_CLS(MTLFunctionConstant));
}

_MTL_INLINE MTL::FunctionConstant* MTL::FunctionConstant::init()
{
    return NS::Object::init<MTL::FunctionConstant>();
}

_MTL_INLINE NS::String* MTL::FunctionConstant::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE MTL::DataType MTL::FunctionConstant::type() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(type));
}

_MTL_INLINE NS::UInteger MTL::FunctionConstant::index() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(index));
}

_MTL_INLINE bool MTL::FunctionConstant::required() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(required));
}

_MTL_INLINE NS::String* MTL::Function::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::Function::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::Device* MTL::Function::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE MTL::FunctionType MTL::Function::functionType() const
{
    return Object::sendMessage<MTL::FunctionType>(this, _MTL_PRIVATE_SEL(functionType));
}

_MTL_INLINE MTL::PatchType MTL::Function::patchType() const
{
    return Object::sendMessage<MTL::PatchType>(this, _MTL_PRIVATE_SEL(patchType));
}

_MTL_INLINE NS::Integer MTL::Function::patchControlPointCount() const
{
    return Object::sendMessage<NS::Integer>(this, _MTL_PRIVATE_SEL(patchControlPointCount));
}

_MTL_INLINE NS::Array* MTL::Function::vertexAttributes() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(vertexAttributes));
}

_MTL_INLINE NS::Array* MTL::Function::stageInputAttributes() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(stageInputAttributes));
}

_MTL_INLINE NS::String* MTL::Function::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE NS::Dictionary* MTL::Function::functionConstantsDictionary() const
{
    return Object::sendMessage<NS::Dictionary*>(this, _MTL_PRIVATE_SEL(functionConstantsDictionary));
}

_MTL_INLINE MTL::ArgumentEncoder* MTL::Function::newArgumentEncoder(NS::UInteger bufferIndex)
{
    return Object::sendMessage<MTL::ArgumentEncoder*>(this, _MTL_PRIVATE_SEL(newArgumentEncoderWithBufferIndex_), bufferIndex);
}

_MTL_INLINE MTL::ArgumentEncoder* MTL::Function::newArgumentEncoder(NS::UInteger bufferIndex, const MTL::AutoreleasedArgument* reflection)
{
    return Object::sendMessage<MTL::ArgumentEncoder*>(this, _MTL_PRIVATE_SEL(newArgumentEncoderWithBufferIndex_reflection_), bufferIndex, reflection);
}

_MTL_INLINE MTL::FunctionOptions MTL::Function::options() const
{
    return Object::sendMessage<MTL::FunctionOptions>(this, _MTL_PRIVATE_SEL(options));
}

_MTL_INLINE MTL::CompileOptions* MTL::CompileOptions::alloc()
{
    return NS::Object::alloc<MTL::CompileOptions>(_MTL_PRIVATE_CLS(MTLCompileOptions));
}

_MTL_INLINE MTL::CompileOptions* MTL::CompileOptions::init()
{
    return NS::Object::init<MTL::CompileOptions>();
}

_MTL_INLINE NS::Dictionary* MTL::CompileOptions::preprocessorMacros() const
{
    return Object::sendMessage<NS::Dictionary*>(this, _MTL_PRIVATE_SEL(preprocessorMacros));
}

_MTL_INLINE void MTL::CompileOptions::setPreprocessorMacros(const NS::Dictionary* preprocessorMacros)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setPreprocessorMacros_), preprocessorMacros);
}

_MTL_INLINE bool MTL::CompileOptions::fastMathEnabled() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(fastMathEnabled));
}

_MTL_INLINE void MTL::CompileOptions::setFastMathEnabled(bool fastMathEnabled)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFastMathEnabled_), fastMathEnabled);
}

_MTL_INLINE MTL::LanguageVersion MTL::CompileOptions::languageVersion() const
{
    return Object::sendMessage<MTL::LanguageVersion>(this, _MTL_PRIVATE_SEL(languageVersion));
}

_MTL_INLINE void MTL::CompileOptions::setLanguageVersion(MTL::LanguageVersion languageVersion)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLanguageVersion_), languageVersion);
}

_MTL_INLINE MTL::LibraryType MTL::CompileOptions::libraryType() const
{
    return Object::sendMessage<MTL::LibraryType>(this, _MTL_PRIVATE_SEL(libraryType));
}

_MTL_INLINE void MTL::CompileOptions::setLibraryType(MTL::LibraryType libraryType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLibraryType_), libraryType);
}

_MTL_INLINE NS::String* MTL::CompileOptions::installName() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(installName));
}

_MTL_INLINE void MTL::CompileOptions::setInstallName(const NS::String* installName)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInstallName_), installName);
}

_MTL_INLINE NS::Array* MTL::CompileOptions::libraries() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(libraries));
}

_MTL_INLINE void MTL::CompileOptions::setLibraries(const NS::Array* libraries)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLibraries_), libraries);
}

_MTL_INLINE bool MTL::CompileOptions::preserveInvariance() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(preserveInvariance));
}

_MTL_INLINE void MTL::CompileOptions::setPreserveInvariance(bool preserveInvariance)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setPreserveInvariance_), preserveInvariance);
}

_MTL_INLINE void MTL::Library::newFunction(const NS::String* pFunctionName, const FunctionConstantValues* pConstantValues, const std::function<void(Function* pFunction, NS::Error* pError)>& completionHandler)
{
    __block std::function<void(Function * pFunction, NS::Error * pError)> blockCompletionHandler = completionHandler;

    newFunction(pFunctionName, pConstantValues, ^(Function* pFunction, NS::Error* pError) { blockCompletionHandler(pFunction, pError); });
}

_MTL_INLINE void MTL::Library::newFunction(const FunctionDescriptor* pDescriptor, const std::function<void(Function* pFunction, NS::Error* pError)>& completionHandler)
{
    __block std::function<void(Function * pFunction, NS::Error * pError)> blockCompletionHandler = completionHandler;

    newFunction(pDescriptor, ^(Function* pFunction, NS::Error* pError) { blockCompletionHandler(pFunction, pError); });
}

_MTL_INLINE void MTL::Library::newIntersectionFunction(const IntersectionFunctionDescriptor* pDescriptor, const std::function<void(Function* pFunction, NS::Error* pError)>& completionHandler)
{
    __block std::function<void(Function * pFunction, NS::Error * pError)> blockCompletionHandler = completionHandler;

    newIntersectionFunction(pDescriptor, ^(Function* pFunction, NS::Error* pError) { blockCompletionHandler(pFunction, pError); });
}

_MTL_INLINE NS::String* MTL::Library::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::Library::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::Device* MTL::Library::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE MTL::Function* MTL::Library::newFunction(const NS::String* functionName)
{
    return Object::sendMessage<MTL::Function*>(this, _MTL_PRIVATE_SEL(newFunctionWithName_), functionName);
}

_MTL_INLINE MTL::Function* MTL::Library::newFunction(const NS::String* name, const MTL::FunctionConstantValues* constantValues, NS::Error** error)
{
    return Object::sendMessage<MTL::Function*>(this, _MTL_PRIVATE_SEL(newFunctionWithName_constantValues_error_), name, constantValues, error);
}

_MTL_INLINE void MTL::Library::newFunction(const NS::String* name, const MTL::FunctionConstantValues* constantValues, void (^completionHandler)(MTL::Function*, NS::Error*))
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newFunctionWithName_constantValues_completionHandler_), name, constantValues, completionHandler);
}

_MTL_INLINE void MTL::Library::newFunction(const MTL::FunctionDescriptor* descriptor, void (^completionHandler)(MTL::Function*, NS::Error*))
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newFunctionWithDescriptor_completionHandler_), descriptor, completionHandler);
}

_MTL_INLINE MTL::Function* MTL::Library::newFunction(const MTL::FunctionDescriptor* descriptor, NS::Error** error)
{
    return Object::sendMessage<MTL::Function*>(this, _MTL_PRIVATE_SEL(newFunctionWithDescriptor_error_), descriptor, error);
}

_MTL_INLINE void MTL::Library::newIntersectionFunction(const MTL::IntersectionFunctionDescriptor* descriptor, void (^completionHandler)(MTL::Function*, NS::Error*))
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newIntersectionFunctionWithDescriptor_completionHandler_), descriptor, completionHandler);
}

_MTL_INLINE MTL::Function* MTL::Library::newIntersectionFunction(const MTL::IntersectionFunctionDescriptor* descriptor, NS::Error** error)
{
    return Object::sendMessage<MTL::Function*>(this, _MTL_PRIVATE_SEL(newIntersectionFunctionWithDescriptor_error_), descriptor, error);
}

_MTL_INLINE NS::Array* MTL::Library::functionNames() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(functionNames));
}

_MTL_INLINE MTL::LibraryType MTL::Library::type() const
{
    return Object::sendMessage<MTL::LibraryType>(this, _MTL_PRIVATE_SEL(type));
}

_MTL_INLINE NS::String* MTL::Library::installName() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(installName));
}

namespace MTL
{
class FunctionHandle : public NS::Referencing<FunctionHandle>
{
public:
    MTL::FunctionType functionType() const;

    NS::String*       name() const;

    class Device*     device() const;
};

}

_MTL_INLINE MTL::FunctionType MTL::FunctionHandle::functionType() const
{
    return Object::sendMessage<MTL::FunctionType>(this, _MTL_PRIVATE_SEL(functionType));
}

_MTL_INLINE NS::String* MTL::FunctionHandle::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE MTL::Device* MTL::FunctionHandle::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

#pragma once

namespace MTL
{
class VisibleFunctionTableDescriptor : public NS::Copying<VisibleFunctionTableDescriptor>
{
public:
    static class VisibleFunctionTableDescriptor* alloc();

    class VisibleFunctionTableDescriptor*        init();

    static class VisibleFunctionTableDescriptor* visibleFunctionTableDescriptor();

    NS::UInteger                                 functionCount() const;
    void                                         setFunctionCount(NS::UInteger functionCount);
};

class VisibleFunctionTable : public NS::Referencing<VisibleFunctionTable, Resource>
{
public:
    void setFunction(const class FunctionHandle* function, NS::UInteger index);

    void setFunctions(const class FunctionHandle* functions[], NS::Range range);
};

}

_MTL_INLINE MTL::VisibleFunctionTableDescriptor* MTL::VisibleFunctionTableDescriptor::alloc()
{
    return NS::Object::alloc<MTL::VisibleFunctionTableDescriptor>(_MTL_PRIVATE_CLS(MTLVisibleFunctionTableDescriptor));
}

_MTL_INLINE MTL::VisibleFunctionTableDescriptor* MTL::VisibleFunctionTableDescriptor::init()
{
    return NS::Object::init<MTL::VisibleFunctionTableDescriptor>();
}

_MTL_INLINE MTL::VisibleFunctionTableDescriptor* MTL::VisibleFunctionTableDescriptor::visibleFunctionTableDescriptor()
{
    return Object::sendMessage<MTL::VisibleFunctionTableDescriptor*>(_MTL_PRIVATE_CLS(MTLVisibleFunctionTableDescriptor), _MTL_PRIVATE_SEL(visibleFunctionTableDescriptor));
}

_MTL_INLINE NS::UInteger MTL::VisibleFunctionTableDescriptor::functionCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(functionCount));
}

_MTL_INLINE void MTL::VisibleFunctionTableDescriptor::setFunctionCount(NS::UInteger functionCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFunctionCount_), functionCount);
}

_MTL_INLINE void MTL::VisibleFunctionTable::setFunction(const MTL::FunctionHandle* function, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFunction_atIndex_), function, index);
}

_MTL_INLINE void MTL::VisibleFunctionTable::setFunctions(const MTL::FunctionHandle* functions[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFunctions_withRange_), functions, range);
}

namespace MTL
{
_MTL_OPTIONS(NS::UInteger, IntersectionFunctionSignature) {
    IntersectionFunctionSignatureNone = 0,
    IntersectionFunctionSignatureInstancing = 1,
    IntersectionFunctionSignatureTriangleData = 2,
    IntersectionFunctionSignatureWorldSpaceData = 4,
    IntersectionFunctionSignatureInstanceMotion = 8,
    IntersectionFunctionSignaturePrimitiveMotion = 16,
    IntersectionFunctionSignatureExtendedLimits = 32,
};

class IntersectionFunctionTableDescriptor : public NS::Copying<IntersectionFunctionTableDescriptor>
{
public:
    static class IntersectionFunctionTableDescriptor* alloc();

    class IntersectionFunctionTableDescriptor*        init();

    static class IntersectionFunctionTableDescriptor* intersectionFunctionTableDescriptor();

    NS::UInteger                                      functionCount() const;
    void                                              setFunctionCount(NS::UInteger functionCount);
};

class IntersectionFunctionTable : public NS::Referencing<IntersectionFunctionTable, Resource>
{
public:
    void setBuffer(const class Buffer* buffer, NS::UInteger offset, NS::UInteger index);

    void setBuffers(const class Buffer* buffers[], const NS::UInteger offsets[], NS::Range range);

    void setFunction(const class FunctionHandle* function, NS::UInteger index);

    void setFunctions(const class FunctionHandle* functions[], NS::Range range);

    void setOpaqueTriangleIntersectionFunction(MTL::IntersectionFunctionSignature signature, NS::UInteger index);

    void setOpaqueTriangleIntersectionFunction(MTL::IntersectionFunctionSignature signature, NS::Range range);

    void setVisibleFunctionTable(const class VisibleFunctionTable* functionTable, NS::UInteger bufferIndex);

    void setVisibleFunctionTables(const class VisibleFunctionTable* functionTables[], NS::Range bufferRange);
};

}

_MTL_INLINE MTL::IntersectionFunctionTableDescriptor* MTL::IntersectionFunctionTableDescriptor::alloc()
{
    return NS::Object::alloc<MTL::IntersectionFunctionTableDescriptor>(_MTL_PRIVATE_CLS(MTLIntersectionFunctionTableDescriptor));
}

_MTL_INLINE MTL::IntersectionFunctionTableDescriptor* MTL::IntersectionFunctionTableDescriptor::init()
{
    return NS::Object::init<MTL::IntersectionFunctionTableDescriptor>();
}

_MTL_INLINE MTL::IntersectionFunctionTableDescriptor* MTL::IntersectionFunctionTableDescriptor::intersectionFunctionTableDescriptor()
{
    return Object::sendMessage<MTL::IntersectionFunctionTableDescriptor*>(_MTL_PRIVATE_CLS(MTLIntersectionFunctionTableDescriptor), _MTL_PRIVATE_SEL(intersectionFunctionTableDescriptor));
}

_MTL_INLINE NS::UInteger MTL::IntersectionFunctionTableDescriptor::functionCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(functionCount));
}

_MTL_INLINE void MTL::IntersectionFunctionTableDescriptor::setFunctionCount(NS::UInteger functionCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFunctionCount_), functionCount);
}

_MTL_INLINE void MTL::IntersectionFunctionTable::setBuffer(const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBuffer_offset_atIndex_), buffer, offset, index);
}

_MTL_INLINE void MTL::IntersectionFunctionTable::setBuffers(const MTL::Buffer* buffers[], const NS::UInteger offsets[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBuffers_offsets_withRange_), buffers, offsets, range);
}

_MTL_INLINE void MTL::IntersectionFunctionTable::setFunction(const MTL::FunctionHandle* function, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFunction_atIndex_), function, index);
}

_MTL_INLINE void MTL::IntersectionFunctionTable::setFunctions(const MTL::FunctionHandle* functions[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFunctions_withRange_), functions, range);
}

_MTL_INLINE void MTL::IntersectionFunctionTable::setOpaqueTriangleIntersectionFunction(MTL::IntersectionFunctionSignature signature, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setOpaqueTriangleIntersectionFunctionWithSignature_atIndex_), signature, index);
}

_MTL_INLINE void MTL::IntersectionFunctionTable::setOpaqueTriangleIntersectionFunction(MTL::IntersectionFunctionSignature signature, NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setOpaqueTriangleIntersectionFunctionWithSignature_withRange_), signature, range);
}

_MTL_INLINE void MTL::IntersectionFunctionTable::setVisibleFunctionTable(const MTL::VisibleFunctionTable* functionTable, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVisibleFunctionTable_atBufferIndex_), functionTable, bufferIndex);
}

_MTL_INLINE void MTL::IntersectionFunctionTable::setVisibleFunctionTables(const MTL::VisibleFunctionTable* functionTables[], NS::Range bufferRange)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVisibleFunctionTables_withBufferRange_), functionTables, bufferRange);
}

#pragma once

#pragma once

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, LoadAction) {
    LoadActionDontCare = 0,
    LoadActionLoad = 1,
    LoadActionClear = 2,
};

_MTL_ENUM(NS::UInteger, StoreAction) {
    StoreActionDontCare = 0,
    StoreActionStore = 1,
    StoreActionMultisampleResolve = 2,
    StoreActionStoreAndMultisampleResolve = 3,
    StoreActionUnknown = 4,
    StoreActionCustomSampleDepthStore = 5,
};

_MTL_OPTIONS(NS::UInteger, StoreActionOptions) {
    StoreActionOptionNone = 0,
    StoreActionOptionValidMask = 1,
    StoreActionOptionCustomSamplePositions = 1,
};

struct ClearColor
{
    static ClearColor Make(double red, double green, double blue, double alpha);

    ClearColor() = default;

    ClearColor(double red, double green, double blue, double alpha);

    double red;
    double green;
    double blue;
    double alpha;
} _MTL_PACKED;

class RenderPassAttachmentDescriptor : public NS::Copying<RenderPassAttachmentDescriptor>
{
public:
    static class RenderPassAttachmentDescriptor* alloc();

    class RenderPassAttachmentDescriptor*        init();

    class Texture*                               texture() const;
    void                                         setTexture(const class Texture* texture);

    NS::UInteger                                 level() const;
    void                                         setLevel(NS::UInteger level);

    NS::UInteger                                 slice() const;
    void                                         setSlice(NS::UInteger slice);

    NS::UInteger                                 depthPlane() const;
    void                                         setDepthPlane(NS::UInteger depthPlane);

    class Texture*                               resolveTexture() const;
    void                                         setResolveTexture(const class Texture* resolveTexture);

    NS::UInteger                                 resolveLevel() const;
    void                                         setResolveLevel(NS::UInteger resolveLevel);

    NS::UInteger                                 resolveSlice() const;
    void                                         setResolveSlice(NS::UInteger resolveSlice);

    NS::UInteger                                 resolveDepthPlane() const;
    void                                         setResolveDepthPlane(NS::UInteger resolveDepthPlane);

    MTL::LoadAction                              loadAction() const;
    void                                         setLoadAction(MTL::LoadAction loadAction);

    MTL::StoreAction                             storeAction() const;
    void                                         setStoreAction(MTL::StoreAction storeAction);

    MTL::StoreActionOptions                      storeActionOptions() const;
    void                                         setStoreActionOptions(MTL::StoreActionOptions storeActionOptions);
};

class RenderPassColorAttachmentDescriptor : public NS::Copying<RenderPassColorAttachmentDescriptor, MTL::RenderPassAttachmentDescriptor>
{
public:
    static class RenderPassColorAttachmentDescriptor* alloc();

    class RenderPassColorAttachmentDescriptor*        init();

    MTL::ClearColor                                   clearColor() const;
    void                                              setClearColor(MTL::ClearColor clearColor);
};

_MTL_ENUM(NS::UInteger, MultisampleDepthResolveFilter) {
    MultisampleDepthResolveFilterSample0 = 0,
    MultisampleDepthResolveFilterMin = 1,
    MultisampleDepthResolveFilterMax = 2,
};

class RenderPassDepthAttachmentDescriptor : public NS::Copying<RenderPassDepthAttachmentDescriptor, MTL::RenderPassAttachmentDescriptor>
{
public:
    static class RenderPassDepthAttachmentDescriptor* alloc();

    class RenderPassDepthAttachmentDescriptor*        init();

    double                                            clearDepth() const;
    void                                              setClearDepth(double clearDepth);

    MTL::MultisampleDepthResolveFilter                depthResolveFilter() const;
    void                                              setDepthResolveFilter(MTL::MultisampleDepthResolveFilter depthResolveFilter);
};

_MTL_ENUM(NS::UInteger, MultisampleStencilResolveFilter) {
    MultisampleStencilResolveFilterSample0 = 0,
    MultisampleStencilResolveFilterDepthResolvedSample = 1,
};

class RenderPassStencilAttachmentDescriptor : public NS::Copying<RenderPassStencilAttachmentDescriptor, MTL::RenderPassAttachmentDescriptor>
{
public:
    static class RenderPassStencilAttachmentDescriptor* alloc();

    class RenderPassStencilAttachmentDescriptor*        init();

    uint32_t                                            clearStencil() const;
    void                                                setClearStencil(uint32_t clearStencil);

    MTL::MultisampleStencilResolveFilter                stencilResolveFilter() const;
    void                                                setStencilResolveFilter(MTL::MultisampleStencilResolveFilter stencilResolveFilter);
};

class RenderPassColorAttachmentDescriptorArray : public NS::Referencing<RenderPassColorAttachmentDescriptorArray>
{
public:
    static class RenderPassColorAttachmentDescriptorArray* alloc();

    class RenderPassColorAttachmentDescriptorArray*        init();

    class RenderPassColorAttachmentDescriptor*             object(NS::UInteger attachmentIndex);

    void                                                   setObject(const class RenderPassColorAttachmentDescriptor* attachment, NS::UInteger attachmentIndex);
};

class RenderPassSampleBufferAttachmentDescriptor : public NS::Copying<RenderPassSampleBufferAttachmentDescriptor>
{
public:
    static class RenderPassSampleBufferAttachmentDescriptor* alloc();

    class RenderPassSampleBufferAttachmentDescriptor*        init();

    class CounterSampleBuffer*                               sampleBuffer() const;
    void                                                     setSampleBuffer(const class CounterSampleBuffer* sampleBuffer);

    NS::UInteger                                             startOfVertexSampleIndex() const;
    void                                                     setStartOfVertexSampleIndex(NS::UInteger startOfVertexSampleIndex);

    NS::UInteger                                             endOfVertexSampleIndex() const;
    void                                                     setEndOfVertexSampleIndex(NS::UInteger endOfVertexSampleIndex);

    NS::UInteger                                             startOfFragmentSampleIndex() const;
    void                                                     setStartOfFragmentSampleIndex(NS::UInteger startOfFragmentSampleIndex);

    NS::UInteger                                             endOfFragmentSampleIndex() const;
    void                                                     setEndOfFragmentSampleIndex(NS::UInteger endOfFragmentSampleIndex);
};

class RenderPassSampleBufferAttachmentDescriptorArray : public NS::Referencing<RenderPassSampleBufferAttachmentDescriptorArray>
{
public:
    static class RenderPassSampleBufferAttachmentDescriptorArray* alloc();

    class RenderPassSampleBufferAttachmentDescriptorArray*        init();

    class RenderPassSampleBufferAttachmentDescriptor*             object(NS::UInteger attachmentIndex);

    void                                                          setObject(const class RenderPassSampleBufferAttachmentDescriptor* attachment, NS::UInteger attachmentIndex);
};

class RenderPassDescriptor : public NS::Copying<RenderPassDescriptor>
{
public:
    static class RenderPassDescriptor*                     alloc();

    class RenderPassDescriptor*                            init();

    static class RenderPassDescriptor*                     renderPassDescriptor();

    class RenderPassColorAttachmentDescriptorArray*        colorAttachments() const;

    class RenderPassDepthAttachmentDescriptor*             depthAttachment() const;
    void                                                   setDepthAttachment(const class RenderPassDepthAttachmentDescriptor* depthAttachment);

    class RenderPassStencilAttachmentDescriptor*           stencilAttachment() const;
    void                                                   setStencilAttachment(const class RenderPassStencilAttachmentDescriptor* stencilAttachment);

    class Buffer*                                          visibilityResultBuffer() const;
    void                                                   setVisibilityResultBuffer(const class Buffer* visibilityResultBuffer);

    NS::UInteger                                           renderTargetArrayLength() const;
    void                                                   setRenderTargetArrayLength(NS::UInteger renderTargetArrayLength);

    NS::UInteger                                           imageblockSampleLength() const;
    void                                                   setImageblockSampleLength(NS::UInteger imageblockSampleLength);

    NS::UInteger                                           threadgroupMemoryLength() const;
    void                                                   setThreadgroupMemoryLength(NS::UInteger threadgroupMemoryLength);

    NS::UInteger                                           tileWidth() const;
    void                                                   setTileWidth(NS::UInteger tileWidth);

    NS::UInteger                                           tileHeight() const;
    void                                                   setTileHeight(NS::UInteger tileHeight);

    NS::UInteger                                           defaultRasterSampleCount() const;
    void                                                   setDefaultRasterSampleCount(NS::UInteger defaultRasterSampleCount);

    NS::UInteger                                           renderTargetWidth() const;
    void                                                   setRenderTargetWidth(NS::UInteger renderTargetWidth);

    NS::UInteger                                           renderTargetHeight() const;
    void                                                   setRenderTargetHeight(NS::UInteger renderTargetHeight);

    void                                                   setSamplePositions(const MTL::SamplePosition* positions, NS::UInteger count);

    NS::UInteger                                           getSamplePositions(MTL::SamplePosition* positions, NS::UInteger count);

    class RasterizationRateMap*                            rasterizationRateMap() const;
    void                                                   setRasterizationRateMap(const class RasterizationRateMap* rasterizationRateMap);

    class RenderPassSampleBufferAttachmentDescriptorArray* sampleBufferAttachments() const;
};

}

_MTL_INLINE MTL::ClearColor MTL::ClearColor::Make(double red, double green, double blue, double alpha)
{
    return ClearColor(red, green, blue, alpha);
}

_MTL_INLINE MTL::ClearColor::ClearColor(double _red, double _green, double _blue, double _alpha)
    : red(_red)
    , green(_green)
    , blue(_blue)
    , alpha(_alpha)
{
}

_MTL_INLINE MTL::RenderPassAttachmentDescriptor* MTL::RenderPassAttachmentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RenderPassAttachmentDescriptor>(_MTL_PRIVATE_CLS(MTLRenderPassAttachmentDescriptor));
}

_MTL_INLINE MTL::RenderPassAttachmentDescriptor* MTL::RenderPassAttachmentDescriptor::init()
{
    return NS::Object::init<MTL::RenderPassAttachmentDescriptor>();
}

_MTL_INLINE MTL::Texture* MTL::RenderPassAttachmentDescriptor::texture() const
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(texture));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setTexture(const MTL::Texture* texture)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTexture_), texture);
}

_MTL_INLINE NS::UInteger MTL::RenderPassAttachmentDescriptor::level() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(level));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setLevel(NS::UInteger level)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLevel_), level);
}

_MTL_INLINE NS::UInteger MTL::RenderPassAttachmentDescriptor::slice() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(slice));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setSlice(NS::UInteger slice)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSlice_), slice);
}

_MTL_INLINE NS::UInteger MTL::RenderPassAttachmentDescriptor::depthPlane() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(depthPlane));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setDepthPlane(NS::UInteger depthPlane)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthPlane_), depthPlane);
}

_MTL_INLINE MTL::Texture* MTL::RenderPassAttachmentDescriptor::resolveTexture() const
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(resolveTexture));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setResolveTexture(const MTL::Texture* resolveTexture)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setResolveTexture_), resolveTexture);
}

_MTL_INLINE NS::UInteger MTL::RenderPassAttachmentDescriptor::resolveLevel() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(resolveLevel));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setResolveLevel(NS::UInteger resolveLevel)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setResolveLevel_), resolveLevel);
}

_MTL_INLINE NS::UInteger MTL::RenderPassAttachmentDescriptor::resolveSlice() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(resolveSlice));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setResolveSlice(NS::UInteger resolveSlice)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setResolveSlice_), resolveSlice);
}

_MTL_INLINE NS::UInteger MTL::RenderPassAttachmentDescriptor::resolveDepthPlane() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(resolveDepthPlane));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setResolveDepthPlane(NS::UInteger resolveDepthPlane)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setResolveDepthPlane_), resolveDepthPlane);
}

_MTL_INLINE MTL::LoadAction MTL::RenderPassAttachmentDescriptor::loadAction() const
{
    return Object::sendMessage<MTL::LoadAction>(this, _MTL_PRIVATE_SEL(loadAction));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setLoadAction(MTL::LoadAction loadAction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLoadAction_), loadAction);
}

_MTL_INLINE MTL::StoreAction MTL::RenderPassAttachmentDescriptor::storeAction() const
{
    return Object::sendMessage<MTL::StoreAction>(this, _MTL_PRIVATE_SEL(storeAction));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setStoreAction(MTL::StoreAction storeAction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStoreAction_), storeAction);
}

_MTL_INLINE MTL::StoreActionOptions MTL::RenderPassAttachmentDescriptor::storeActionOptions() const
{
    return Object::sendMessage<MTL::StoreActionOptions>(this, _MTL_PRIVATE_SEL(storeActionOptions));
}

_MTL_INLINE void MTL::RenderPassAttachmentDescriptor::setStoreActionOptions(MTL::StoreActionOptions storeActionOptions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStoreActionOptions_), storeActionOptions);
}

_MTL_INLINE MTL::RenderPassColorAttachmentDescriptor* MTL::RenderPassColorAttachmentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RenderPassColorAttachmentDescriptor>(_MTL_PRIVATE_CLS(MTLRenderPassColorAttachmentDescriptor));
}

_MTL_INLINE MTL::RenderPassColorAttachmentDescriptor* MTL::RenderPassColorAttachmentDescriptor::init()
{
    return NS::Object::init<MTL::RenderPassColorAttachmentDescriptor>();
}

_MTL_INLINE MTL::ClearColor MTL::RenderPassColorAttachmentDescriptor::clearColor() const
{
    return Object::sendMessage<MTL::ClearColor>(this, _MTL_PRIVATE_SEL(clearColor));
}

_MTL_INLINE void MTL::RenderPassColorAttachmentDescriptor::setClearColor(MTL::ClearColor clearColor)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setClearColor_), clearColor);
}

_MTL_INLINE MTL::RenderPassDepthAttachmentDescriptor* MTL::RenderPassDepthAttachmentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RenderPassDepthAttachmentDescriptor>(_MTL_PRIVATE_CLS(MTLRenderPassDepthAttachmentDescriptor));
}

_MTL_INLINE MTL::RenderPassDepthAttachmentDescriptor* MTL::RenderPassDepthAttachmentDescriptor::init()
{
    return NS::Object::init<MTL::RenderPassDepthAttachmentDescriptor>();
}

_MTL_INLINE double MTL::RenderPassDepthAttachmentDescriptor::clearDepth() const
{
    return Object::sendMessage<double>(this, _MTL_PRIVATE_SEL(clearDepth));
}

_MTL_INLINE void MTL::RenderPassDepthAttachmentDescriptor::setClearDepth(double clearDepth)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setClearDepth_), clearDepth);
}

_MTL_INLINE MTL::MultisampleDepthResolveFilter MTL::RenderPassDepthAttachmentDescriptor::depthResolveFilter() const
{
    return Object::sendMessage<MTL::MultisampleDepthResolveFilter>(this, _MTL_PRIVATE_SEL(depthResolveFilter));
}

_MTL_INLINE void MTL::RenderPassDepthAttachmentDescriptor::setDepthResolveFilter(MTL::MultisampleDepthResolveFilter depthResolveFilter)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthResolveFilter_), depthResolveFilter);
}

_MTL_INLINE MTL::RenderPassStencilAttachmentDescriptor* MTL::RenderPassStencilAttachmentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RenderPassStencilAttachmentDescriptor>(_MTL_PRIVATE_CLS(MTLRenderPassStencilAttachmentDescriptor));
}

_MTL_INLINE MTL::RenderPassStencilAttachmentDescriptor* MTL::RenderPassStencilAttachmentDescriptor::init()
{
    return NS::Object::init<MTL::RenderPassStencilAttachmentDescriptor>();
}

_MTL_INLINE uint32_t MTL::RenderPassStencilAttachmentDescriptor::clearStencil() const
{
    return Object::sendMessage<uint32_t>(this, _MTL_PRIVATE_SEL(clearStencil));
}

_MTL_INLINE void MTL::RenderPassStencilAttachmentDescriptor::setClearStencil(uint32_t clearStencil)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setClearStencil_), clearStencil);
}

_MTL_INLINE MTL::MultisampleStencilResolveFilter MTL::RenderPassStencilAttachmentDescriptor::stencilResolveFilter() const
{
    return Object::sendMessage<MTL::MultisampleStencilResolveFilter>(this, _MTL_PRIVATE_SEL(stencilResolveFilter));
}

_MTL_INLINE void MTL::RenderPassStencilAttachmentDescriptor::setStencilResolveFilter(MTL::MultisampleStencilResolveFilter stencilResolveFilter)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilResolveFilter_), stencilResolveFilter);
}

_MTL_INLINE MTL::RenderPassColorAttachmentDescriptorArray* MTL::RenderPassColorAttachmentDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::RenderPassColorAttachmentDescriptorArray>(_MTL_PRIVATE_CLS(MTLRenderPassColorAttachmentDescriptorArray));
}

_MTL_INLINE MTL::RenderPassColorAttachmentDescriptorArray* MTL::RenderPassColorAttachmentDescriptorArray::init()
{
    return NS::Object::init<MTL::RenderPassColorAttachmentDescriptorArray>();
}

_MTL_INLINE MTL::RenderPassColorAttachmentDescriptor* MTL::RenderPassColorAttachmentDescriptorArray::object(NS::UInteger attachmentIndex)
{
    return Object::sendMessage<MTL::RenderPassColorAttachmentDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), attachmentIndex);
}

_MTL_INLINE void MTL::RenderPassColorAttachmentDescriptorArray::setObject(const MTL::RenderPassColorAttachmentDescriptor* attachment, NS::UInteger attachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), attachment, attachmentIndex);
}

_MTL_INLINE MTL::RenderPassSampleBufferAttachmentDescriptor* MTL::RenderPassSampleBufferAttachmentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RenderPassSampleBufferAttachmentDescriptor>(_MTL_PRIVATE_CLS(MTLRenderPassSampleBufferAttachmentDescriptor));
}

_MTL_INLINE MTL::RenderPassSampleBufferAttachmentDescriptor* MTL::RenderPassSampleBufferAttachmentDescriptor::init()
{
    return NS::Object::init<MTL::RenderPassSampleBufferAttachmentDescriptor>();
}

_MTL_INLINE MTL::CounterSampleBuffer* MTL::RenderPassSampleBufferAttachmentDescriptor::sampleBuffer() const
{
    return Object::sendMessage<MTL::CounterSampleBuffer*>(this, _MTL_PRIVATE_SEL(sampleBuffer));
}

_MTL_INLINE void MTL::RenderPassSampleBufferAttachmentDescriptor::setSampleBuffer(const MTL::CounterSampleBuffer* sampleBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSampleBuffer_), sampleBuffer);
}

_MTL_INLINE NS::UInteger MTL::RenderPassSampleBufferAttachmentDescriptor::startOfVertexSampleIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(startOfVertexSampleIndex));
}

_MTL_INLINE void MTL::RenderPassSampleBufferAttachmentDescriptor::setStartOfVertexSampleIndex(NS::UInteger startOfVertexSampleIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStartOfVertexSampleIndex_), startOfVertexSampleIndex);
}

_MTL_INLINE NS::UInteger MTL::RenderPassSampleBufferAttachmentDescriptor::endOfVertexSampleIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(endOfVertexSampleIndex));
}

_MTL_INLINE void MTL::RenderPassSampleBufferAttachmentDescriptor::setEndOfVertexSampleIndex(NS::UInteger endOfVertexSampleIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setEndOfVertexSampleIndex_), endOfVertexSampleIndex);
}

_MTL_INLINE NS::UInteger MTL::RenderPassSampleBufferAttachmentDescriptor::startOfFragmentSampleIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(startOfFragmentSampleIndex));
}

_MTL_INLINE void MTL::RenderPassSampleBufferAttachmentDescriptor::setStartOfFragmentSampleIndex(NS::UInteger startOfFragmentSampleIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStartOfFragmentSampleIndex_), startOfFragmentSampleIndex);
}

_MTL_INLINE NS::UInteger MTL::RenderPassSampleBufferAttachmentDescriptor::endOfFragmentSampleIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(endOfFragmentSampleIndex));
}

_MTL_INLINE void MTL::RenderPassSampleBufferAttachmentDescriptor::setEndOfFragmentSampleIndex(NS::UInteger endOfFragmentSampleIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setEndOfFragmentSampleIndex_), endOfFragmentSampleIndex);
}

_MTL_INLINE MTL::RenderPassSampleBufferAttachmentDescriptorArray* MTL::RenderPassSampleBufferAttachmentDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::RenderPassSampleBufferAttachmentDescriptorArray>(_MTL_PRIVATE_CLS(MTLRenderPassSampleBufferAttachmentDescriptorArray));
}

_MTL_INLINE MTL::RenderPassSampleBufferAttachmentDescriptorArray* MTL::RenderPassSampleBufferAttachmentDescriptorArray::init()
{
    return NS::Object::init<MTL::RenderPassSampleBufferAttachmentDescriptorArray>();
}

_MTL_INLINE MTL::RenderPassSampleBufferAttachmentDescriptor* MTL::RenderPassSampleBufferAttachmentDescriptorArray::object(NS::UInteger attachmentIndex)
{
    return Object::sendMessage<MTL::RenderPassSampleBufferAttachmentDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), attachmentIndex);
}

_MTL_INLINE void MTL::RenderPassSampleBufferAttachmentDescriptorArray::setObject(const MTL::RenderPassSampleBufferAttachmentDescriptor* attachment, NS::UInteger attachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), attachment, attachmentIndex);
}

_MTL_INLINE MTL::RenderPassDescriptor* MTL::RenderPassDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RenderPassDescriptor>(_MTL_PRIVATE_CLS(MTLRenderPassDescriptor));
}

_MTL_INLINE MTL::RenderPassDescriptor* MTL::RenderPassDescriptor::init()
{
    return NS::Object::init<MTL::RenderPassDescriptor>();
}

_MTL_INLINE MTL::RenderPassDescriptor* MTL::RenderPassDescriptor::renderPassDescriptor()
{
    return Object::sendMessage<MTL::RenderPassDescriptor*>(_MTL_PRIVATE_CLS(MTLRenderPassDescriptor), _MTL_PRIVATE_SEL(renderPassDescriptor));
}

_MTL_INLINE MTL::RenderPassColorAttachmentDescriptorArray* MTL::RenderPassDescriptor::colorAttachments() const
{
    return Object::sendMessage<MTL::RenderPassColorAttachmentDescriptorArray*>(this, _MTL_PRIVATE_SEL(colorAttachments));
}

_MTL_INLINE MTL::RenderPassDepthAttachmentDescriptor* MTL::RenderPassDescriptor::depthAttachment() const
{
    return Object::sendMessage<MTL::RenderPassDepthAttachmentDescriptor*>(this, _MTL_PRIVATE_SEL(depthAttachment));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setDepthAttachment(const MTL::RenderPassDepthAttachmentDescriptor* depthAttachment)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthAttachment_), depthAttachment);
}

_MTL_INLINE MTL::RenderPassStencilAttachmentDescriptor* MTL::RenderPassDescriptor::stencilAttachment() const
{
    return Object::sendMessage<MTL::RenderPassStencilAttachmentDescriptor*>(this, _MTL_PRIVATE_SEL(stencilAttachment));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setStencilAttachment(const MTL::RenderPassStencilAttachmentDescriptor* stencilAttachment)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilAttachment_), stencilAttachment);
}

_MTL_INLINE MTL::Buffer* MTL::RenderPassDescriptor::visibilityResultBuffer() const
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(visibilityResultBuffer));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setVisibilityResultBuffer(const MTL::Buffer* visibilityResultBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVisibilityResultBuffer_), visibilityResultBuffer);
}

_MTL_INLINE NS::UInteger MTL::RenderPassDescriptor::renderTargetArrayLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(renderTargetArrayLength));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setRenderTargetArrayLength(NS::UInteger renderTargetArrayLength)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRenderTargetArrayLength_), renderTargetArrayLength);
}

_MTL_INLINE NS::UInteger MTL::RenderPassDescriptor::imageblockSampleLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(imageblockSampleLength));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setImageblockSampleLength(NS::UInteger imageblockSampleLength)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setImageblockSampleLength_), imageblockSampleLength);
}

_MTL_INLINE NS::UInteger MTL::RenderPassDescriptor::threadgroupMemoryLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(threadgroupMemoryLength));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setThreadgroupMemoryLength(NS::UInteger threadgroupMemoryLength)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setThreadgroupMemoryLength_), threadgroupMemoryLength);
}

_MTL_INLINE NS::UInteger MTL::RenderPassDescriptor::tileWidth() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(tileWidth));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setTileWidth(NS::UInteger tileWidth)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileWidth_), tileWidth);
}

_MTL_INLINE NS::UInteger MTL::RenderPassDescriptor::tileHeight() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(tileHeight));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setTileHeight(NS::UInteger tileHeight)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileHeight_), tileHeight);
}

_MTL_INLINE NS::UInteger MTL::RenderPassDescriptor::defaultRasterSampleCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(defaultRasterSampleCount));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setDefaultRasterSampleCount(NS::UInteger defaultRasterSampleCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDefaultRasterSampleCount_), defaultRasterSampleCount);
}

_MTL_INLINE NS::UInteger MTL::RenderPassDescriptor::renderTargetWidth() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(renderTargetWidth));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setRenderTargetWidth(NS::UInteger renderTargetWidth)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRenderTargetWidth_), renderTargetWidth);
}

_MTL_INLINE NS::UInteger MTL::RenderPassDescriptor::renderTargetHeight() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(renderTargetHeight));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setRenderTargetHeight(NS::UInteger renderTargetHeight)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRenderTargetHeight_), renderTargetHeight);
}

_MTL_INLINE void MTL::RenderPassDescriptor::setSamplePositions(const MTL::SamplePosition* positions, NS::UInteger count)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSamplePositions_count_), positions, count);
}

_MTL_INLINE NS::UInteger MTL::RenderPassDescriptor::getSamplePositions(MTL::SamplePosition* positions, NS::UInteger count)
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(getSamplePositions_count_), positions, count);
}

_MTL_INLINE MTL::RasterizationRateMap* MTL::RenderPassDescriptor::rasterizationRateMap() const
{
    return Object::sendMessage<MTL::RasterizationRateMap*>(this, _MTL_PRIVATE_SEL(rasterizationRateMap));
}

_MTL_INLINE void MTL::RenderPassDescriptor::setRasterizationRateMap(const MTL::RasterizationRateMap* rasterizationRateMap)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRasterizationRateMap_), rasterizationRateMap);
}

_MTL_INLINE MTL::RenderPassSampleBufferAttachmentDescriptorArray* MTL::RenderPassDescriptor::sampleBufferAttachments() const
{
    return Object::sendMessage<MTL::RenderPassSampleBufferAttachmentDescriptorArray*>(this, _MTL_PRIVATE_SEL(sampleBufferAttachments));
}

#pragma once

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, CompareFunction) {
    CompareFunctionNever = 0,
    CompareFunctionLess = 1,
    CompareFunctionEqual = 2,
    CompareFunctionLessEqual = 3,
    CompareFunctionGreater = 4,
    CompareFunctionNotEqual = 5,
    CompareFunctionGreaterEqual = 6,
    CompareFunctionAlways = 7,
};

_MTL_ENUM(NS::UInteger, StencilOperation) {
    StencilOperationKeep = 0,
    StencilOperationZero = 1,
    StencilOperationReplace = 2,
    StencilOperationIncrementClamp = 3,
    StencilOperationDecrementClamp = 4,
    StencilOperationInvert = 5,
    StencilOperationIncrementWrap = 6,
    StencilOperationDecrementWrap = 7,
};

class StencilDescriptor : public NS::Copying<StencilDescriptor>
{
public:
    static class StencilDescriptor* alloc();

    class StencilDescriptor*        init();

    MTL::CompareFunction            stencilCompareFunction() const;
    void                            setStencilCompareFunction(MTL::CompareFunction stencilCompareFunction);

    MTL::StencilOperation           stencilFailureOperation() const;
    void                            setStencilFailureOperation(MTL::StencilOperation stencilFailureOperation);

    MTL::StencilOperation           depthFailureOperation() const;
    void                            setDepthFailureOperation(MTL::StencilOperation depthFailureOperation);

    MTL::StencilOperation           depthStencilPassOperation() const;
    void                            setDepthStencilPassOperation(MTL::StencilOperation depthStencilPassOperation);

    uint32_t                        readMask() const;
    void                            setReadMask(uint32_t readMask);

    uint32_t                        writeMask() const;
    void                            setWriteMask(uint32_t writeMask);
};

class DepthStencilDescriptor : public NS::Copying<DepthStencilDescriptor>
{
public:
    static class DepthStencilDescriptor* alloc();

    class DepthStencilDescriptor*        init();

    MTL::CompareFunction                 depthCompareFunction() const;
    void                                 setDepthCompareFunction(MTL::CompareFunction depthCompareFunction);

    bool                                 depthWriteEnabled() const;
    void                                 setDepthWriteEnabled(bool depthWriteEnabled);

    class StencilDescriptor*             frontFaceStencil() const;
    void                                 setFrontFaceStencil(const class StencilDescriptor* frontFaceStencil);

    class StencilDescriptor*             backFaceStencil() const;
    void                                 setBackFaceStencil(const class StencilDescriptor* backFaceStencil);

    NS::String*                          label() const;
    void                                 setLabel(const NS::String* label);
};

class DepthStencilState : public NS::Referencing<DepthStencilState>
{
public:
    NS::String*   label() const;

    class Device* device() const;
};

}

_MTL_INLINE MTL::StencilDescriptor* MTL::StencilDescriptor::alloc()
{
    return NS::Object::alloc<MTL::StencilDescriptor>(_MTL_PRIVATE_CLS(MTLStencilDescriptor));
}

_MTL_INLINE MTL::StencilDescriptor* MTL::StencilDescriptor::init()
{
    return NS::Object::init<MTL::StencilDescriptor>();
}

_MTL_INLINE MTL::CompareFunction MTL::StencilDescriptor::stencilCompareFunction() const
{
    return Object::sendMessage<MTL::CompareFunction>(this, _MTL_PRIVATE_SEL(stencilCompareFunction));
}

_MTL_INLINE void MTL::StencilDescriptor::setStencilCompareFunction(MTL::CompareFunction stencilCompareFunction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilCompareFunction_), stencilCompareFunction);
}

_MTL_INLINE MTL::StencilOperation MTL::StencilDescriptor::stencilFailureOperation() const
{
    return Object::sendMessage<MTL::StencilOperation>(this, _MTL_PRIVATE_SEL(stencilFailureOperation));
}

_MTL_INLINE void MTL::StencilDescriptor::setStencilFailureOperation(MTL::StencilOperation stencilFailureOperation)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilFailureOperation_), stencilFailureOperation);
}

_MTL_INLINE MTL::StencilOperation MTL::StencilDescriptor::depthFailureOperation() const
{
    return Object::sendMessage<MTL::StencilOperation>(this, _MTL_PRIVATE_SEL(depthFailureOperation));
}

_MTL_INLINE void MTL::StencilDescriptor::setDepthFailureOperation(MTL::StencilOperation depthFailureOperation)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthFailureOperation_), depthFailureOperation);
}

_MTL_INLINE MTL::StencilOperation MTL::StencilDescriptor::depthStencilPassOperation() const
{
    return Object::sendMessage<MTL::StencilOperation>(this, _MTL_PRIVATE_SEL(depthStencilPassOperation));
}

_MTL_INLINE void MTL::StencilDescriptor::setDepthStencilPassOperation(MTL::StencilOperation depthStencilPassOperation)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthStencilPassOperation_), depthStencilPassOperation);
}

_MTL_INLINE uint32_t MTL::StencilDescriptor::readMask() const
{
    return Object::sendMessage<uint32_t>(this, _MTL_PRIVATE_SEL(readMask));
}

_MTL_INLINE void MTL::StencilDescriptor::setReadMask(uint32_t readMask)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setReadMask_), readMask);
}

_MTL_INLINE uint32_t MTL::StencilDescriptor::writeMask() const
{
    return Object::sendMessage<uint32_t>(this, _MTL_PRIVATE_SEL(writeMask));
}

_MTL_INLINE void MTL::StencilDescriptor::setWriteMask(uint32_t writeMask)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setWriteMask_), writeMask);
}

_MTL_INLINE MTL::DepthStencilDescriptor* MTL::DepthStencilDescriptor::alloc()
{
    return NS::Object::alloc<MTL::DepthStencilDescriptor>(_MTL_PRIVATE_CLS(MTLDepthStencilDescriptor));
}

_MTL_INLINE MTL::DepthStencilDescriptor* MTL::DepthStencilDescriptor::init()
{
    return NS::Object::init<MTL::DepthStencilDescriptor>();
}

_MTL_INLINE MTL::CompareFunction MTL::DepthStencilDescriptor::depthCompareFunction() const
{
    return Object::sendMessage<MTL::CompareFunction>(this, _MTL_PRIVATE_SEL(depthCompareFunction));
}

_MTL_INLINE void MTL::DepthStencilDescriptor::setDepthCompareFunction(MTL::CompareFunction depthCompareFunction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthCompareFunction_), depthCompareFunction);
}

_MTL_INLINE bool MTL::DepthStencilDescriptor::depthWriteEnabled() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isDepthWriteEnabled));
}

_MTL_INLINE void MTL::DepthStencilDescriptor::setDepthWriteEnabled(bool depthWriteEnabled)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthWriteEnabled_), depthWriteEnabled);
}

_MTL_INLINE MTL::StencilDescriptor* MTL::DepthStencilDescriptor::frontFaceStencil() const
{
    return Object::sendMessage<MTL::StencilDescriptor*>(this, _MTL_PRIVATE_SEL(frontFaceStencil));
}

_MTL_INLINE void MTL::DepthStencilDescriptor::setFrontFaceStencil(const MTL::StencilDescriptor* frontFaceStencil)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFrontFaceStencil_), frontFaceStencil);
}

_MTL_INLINE MTL::StencilDescriptor* MTL::DepthStencilDescriptor::backFaceStencil() const
{
    return Object::sendMessage<MTL::StencilDescriptor*>(this, _MTL_PRIVATE_SEL(backFaceStencil));
}

_MTL_INLINE void MTL::DepthStencilDescriptor::setBackFaceStencil(const MTL::StencilDescriptor* backFaceStencil)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBackFaceStencil_), backFaceStencil);
}

_MTL_INLINE NS::String* MTL::DepthStencilDescriptor::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::DepthStencilDescriptor::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE NS::String* MTL::DepthStencilState::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE MTL::Device* MTL::DepthStencilState::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

namespace MTL
{
_MTL_ENUM(NS::UInteger, SamplerMinMagFilter) {
    SamplerMinMagFilterNearest = 0,
    SamplerMinMagFilterLinear = 1,
};

_MTL_ENUM(NS::UInteger, SamplerMipFilter) {
    SamplerMipFilterNotMipmapped = 0,
    SamplerMipFilterNearest = 1,
    SamplerMipFilterLinear = 2,
};

_MTL_ENUM(NS::UInteger, SamplerAddressMode) {
    SamplerAddressModeClampToEdge = 0,
    SamplerAddressModeMirrorClampToEdge = 1,
    SamplerAddressModeRepeat = 2,
    SamplerAddressModeMirrorRepeat = 3,
    SamplerAddressModeClampToZero = 4,
    SamplerAddressModeClampToBorderColor = 5,
};

_MTL_ENUM(NS::UInteger, SamplerBorderColor) {
    SamplerBorderColorTransparentBlack = 0,
    SamplerBorderColorOpaqueBlack = 1,
    SamplerBorderColorOpaqueWhite = 2,
};

class SamplerDescriptor : public NS::Copying<SamplerDescriptor>
{
public:
    static class SamplerDescriptor* alloc();

    class SamplerDescriptor*        init();

    MTL::SamplerMinMagFilter        minFilter() const;
    void                            setMinFilter(MTL::SamplerMinMagFilter minFilter);

    MTL::SamplerMinMagFilter        magFilter() const;
    void                            setMagFilter(MTL::SamplerMinMagFilter magFilter);

    MTL::SamplerMipFilter           mipFilter() const;
    void                            setMipFilter(MTL::SamplerMipFilter mipFilter);

    NS::UInteger                    maxAnisotropy() const;
    void                            setMaxAnisotropy(NS::UInteger maxAnisotropy);

    MTL::SamplerAddressMode         sAddressMode() const;
    void                            setSAddressMode(MTL::SamplerAddressMode sAddressMode);

    MTL::SamplerAddressMode         tAddressMode() const;
    void                            setTAddressMode(MTL::SamplerAddressMode tAddressMode);

    MTL::SamplerAddressMode         rAddressMode() const;
    void                            setRAddressMode(MTL::SamplerAddressMode rAddressMode);

    MTL::SamplerBorderColor         borderColor() const;
    void                            setBorderColor(MTL::SamplerBorderColor borderColor);

    bool                            normalizedCoordinates() const;
    void                            setNormalizedCoordinates(bool normalizedCoordinates);

    float                           lodMinClamp() const;
    void                            setLodMinClamp(float lodMinClamp);

    float                           lodMaxClamp() const;
    void                            setLodMaxClamp(float lodMaxClamp);

    bool                            lodAverage() const;
    void                            setLodAverage(bool lodAverage);

    MTL::CompareFunction            compareFunction() const;
    void                            setCompareFunction(MTL::CompareFunction compareFunction);

    bool                            supportArgumentBuffers() const;
    void                            setSupportArgumentBuffers(bool supportArgumentBuffers);

    NS::String*                     label() const;
    void                            setLabel(const NS::String* label);
};

class SamplerState : public NS::Referencing<SamplerState>
{
public:
    NS::String*   label() const;

    class Device* device() const;
};

}

_MTL_INLINE MTL::SamplerDescriptor* MTL::SamplerDescriptor::alloc()
{
    return NS::Object::alloc<MTL::SamplerDescriptor>(_MTL_PRIVATE_CLS(MTLSamplerDescriptor));
}

_MTL_INLINE MTL::SamplerDescriptor* MTL::SamplerDescriptor::init()
{
    return NS::Object::init<MTL::SamplerDescriptor>();
}

_MTL_INLINE MTL::SamplerMinMagFilter MTL::SamplerDescriptor::minFilter() const
{
    return Object::sendMessage<MTL::SamplerMinMagFilter>(this, _MTL_PRIVATE_SEL(minFilter));
}

_MTL_INLINE void MTL::SamplerDescriptor::setMinFilter(MTL::SamplerMinMagFilter minFilter)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMinFilter_), minFilter);
}

_MTL_INLINE MTL::SamplerMinMagFilter MTL::SamplerDescriptor::magFilter() const
{
    return Object::sendMessage<MTL::SamplerMinMagFilter>(this, _MTL_PRIVATE_SEL(magFilter));
}

_MTL_INLINE void MTL::SamplerDescriptor::setMagFilter(MTL::SamplerMinMagFilter magFilter)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMagFilter_), magFilter);
}

_MTL_INLINE MTL::SamplerMipFilter MTL::SamplerDescriptor::mipFilter() const
{
    return Object::sendMessage<MTL::SamplerMipFilter>(this, _MTL_PRIVATE_SEL(mipFilter));
}

_MTL_INLINE void MTL::SamplerDescriptor::setMipFilter(MTL::SamplerMipFilter mipFilter)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMipFilter_), mipFilter);
}

_MTL_INLINE NS::UInteger MTL::SamplerDescriptor::maxAnisotropy() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxAnisotropy));
}

_MTL_INLINE void MTL::SamplerDescriptor::setMaxAnisotropy(NS::UInteger maxAnisotropy)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxAnisotropy_), maxAnisotropy);
}

_MTL_INLINE MTL::SamplerAddressMode MTL::SamplerDescriptor::sAddressMode() const
{
    return Object::sendMessage<MTL::SamplerAddressMode>(this, _MTL_PRIVATE_SEL(sAddressMode));
}

_MTL_INLINE void MTL::SamplerDescriptor::setSAddressMode(MTL::SamplerAddressMode sAddressMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSAddressMode_), sAddressMode);
}

_MTL_INLINE MTL::SamplerAddressMode MTL::SamplerDescriptor::tAddressMode() const
{
    return Object::sendMessage<MTL::SamplerAddressMode>(this, _MTL_PRIVATE_SEL(tAddressMode));
}

_MTL_INLINE void MTL::SamplerDescriptor::setTAddressMode(MTL::SamplerAddressMode tAddressMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTAddressMode_), tAddressMode);
}

_MTL_INLINE MTL::SamplerAddressMode MTL::SamplerDescriptor::rAddressMode() const
{
    return Object::sendMessage<MTL::SamplerAddressMode>(this, _MTL_PRIVATE_SEL(rAddressMode));
}

_MTL_INLINE void MTL::SamplerDescriptor::setRAddressMode(MTL::SamplerAddressMode rAddressMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRAddressMode_), rAddressMode);
}

_MTL_INLINE MTL::SamplerBorderColor MTL::SamplerDescriptor::borderColor() const
{
    return Object::sendMessage<MTL::SamplerBorderColor>(this, _MTL_PRIVATE_SEL(borderColor));
}

_MTL_INLINE void MTL::SamplerDescriptor::setBorderColor(MTL::SamplerBorderColor borderColor)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBorderColor_), borderColor);
}

_MTL_INLINE bool MTL::SamplerDescriptor::normalizedCoordinates() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(normalizedCoordinates));
}

_MTL_INLINE void MTL::SamplerDescriptor::setNormalizedCoordinates(bool normalizedCoordinates)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setNormalizedCoordinates_), normalizedCoordinates);
}

_MTL_INLINE float MTL::SamplerDescriptor::lodMinClamp() const
{
    return Object::sendMessage<float>(this, _MTL_PRIVATE_SEL(lodMinClamp));
}

_MTL_INLINE void MTL::SamplerDescriptor::setLodMinClamp(float lodMinClamp)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLodMinClamp_), lodMinClamp);
}

_MTL_INLINE float MTL::SamplerDescriptor::lodMaxClamp() const
{
    return Object::sendMessage<float>(this, _MTL_PRIVATE_SEL(lodMaxClamp));
}

_MTL_INLINE void MTL::SamplerDescriptor::setLodMaxClamp(float lodMaxClamp)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLodMaxClamp_), lodMaxClamp);
}

_MTL_INLINE bool MTL::SamplerDescriptor::lodAverage() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(lodAverage));
}

_MTL_INLINE void MTL::SamplerDescriptor::setLodAverage(bool lodAverage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLodAverage_), lodAverage);
}

_MTL_INLINE MTL::CompareFunction MTL::SamplerDescriptor::compareFunction() const
{
    return Object::sendMessage<MTL::CompareFunction>(this, _MTL_PRIVATE_SEL(compareFunction));
}

_MTL_INLINE void MTL::SamplerDescriptor::setCompareFunction(MTL::CompareFunction compareFunction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setCompareFunction_), compareFunction);
}

_MTL_INLINE bool MTL::SamplerDescriptor::supportArgumentBuffers() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportArgumentBuffers));
}

_MTL_INLINE void MTL::SamplerDescriptor::setSupportArgumentBuffers(bool supportArgumentBuffers)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSupportArgumentBuffers_), supportArgumentBuffers);
}

_MTL_INLINE NS::String* MTL::SamplerDescriptor::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::SamplerDescriptor::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE NS::String* MTL::SamplerState::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE MTL::Device* MTL::SamplerState::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

namespace MTL
{
_MTL_ENUM(NS::UInteger, PrimitiveType) {
    PrimitiveTypePoint = 0,
    PrimitiveTypeLine = 1,
    PrimitiveTypeLineStrip = 2,
    PrimitiveTypeTriangle = 3,
    PrimitiveTypeTriangleStrip = 4,
};

_MTL_ENUM(NS::UInteger, VisibilityResultMode) {
    VisibilityResultModeDisabled = 0,
    VisibilityResultModeBoolean = 1,
    VisibilityResultModeCounting = 2,
};

struct ScissorRect
{
    NS::UInteger x;
    NS::UInteger y;
    NS::UInteger width;
    NS::UInteger height;
} _MTL_PACKED;

struct Viewport
{
    double originX;
    double originY;
    double width;
    double height;
    double znear;
    double zfar;
} _MTL_PACKED;

_MTL_ENUM(NS::UInteger, CullMode) {
    CullModeNone = 0,
    CullModeFront = 1,
    CullModeBack = 2,
};

_MTL_ENUM(NS::UInteger, Winding) {
    WindingClockwise = 0,
    WindingCounterClockwise = 1,
};

_MTL_ENUM(NS::UInteger, DepthClipMode) {
    DepthClipModeClip = 0,
    DepthClipModeClamp = 1,
};

_MTL_ENUM(NS::UInteger, TriangleFillMode) {
    TriangleFillModeFill = 0,
    TriangleFillModeLines = 1,
};

struct DrawPrimitivesIndirectArguments
{
    uint32_t vertexCount;
    uint32_t instanceCount;
    uint32_t vertexStart;
    uint32_t baseInstance;
} _MTL_PACKED;

struct DrawIndexedPrimitivesIndirectArguments
{
    uint32_t indexCount;
    uint32_t instanceCount;
    uint32_t indexStart;
    int32_t  baseVertex;
    uint32_t baseInstance;
} _MTL_PACKED;

struct VertexAmplificationViewMapping
{
    uint32_t viewportArrayIndexOffset;
    uint32_t renderTargetArrayIndexOffset;
} _MTL_PACKED;

struct DrawPatchIndirectArguments
{
    uint32_t patchCount;
    uint32_t instanceCount;
    uint32_t patchStart;
    uint32_t baseInstance;
} _MTL_PACKED;

struct QuadTessellationFactorsHalf
{
    uint16_t edgeTessellationFactor[4];
    uint16_t insideTessellationFactor[2];
} _MTL_PACKED;

struct TriangleTessellationFactorsHalf
{
    uint16_t edgeTessellationFactor[3];
    uint16_t insideTessellationFactor;
} _MTL_PACKED;

_MTL_OPTIONS(NS::UInteger, RenderStages) {
    RenderStageVertex = 1,
    RenderStageFragment = 2,
    RenderStageTile = 4,
};

class RenderCommandEncoder : public NS::Referencing<RenderCommandEncoder, CommandEncoder>
{
public:
    void         setRenderPipelineState(const class RenderPipelineState* pipelineState);

    void         setVertexBytes(const void* bytes, NS::UInteger length, NS::UInteger index);

    void         setVertexBuffer(const class Buffer* buffer, NS::UInteger offset, NS::UInteger index);

    void         setVertexBufferOffset(NS::UInteger offset, NS::UInteger index);

    void         setVertexBuffers(MTL::Buffer* buffers[], const NS::UInteger offsets[], NS::Range range);

    void         setVertexTexture(const class Texture* texture, NS::UInteger index);

    void         setVertexTextures(MTL::Texture* textures[], NS::Range range);

    void         setVertexSamplerState(const class SamplerState* sampler, NS::UInteger index);

    void         setVertexSamplerStates(MTL::SamplerState* samplers[], NS::Range range);

    void         setVertexSamplerState(const class SamplerState* sampler, float lodMinClamp, float lodMaxClamp, NS::UInteger index);

    void         setVertexSamplerStates(MTL::SamplerState* samplers[], const float lodMinClamps[], const float lodMaxClamps[], NS::Range range);

    void         setVertexVisibleFunctionTable(const class VisibleFunctionTable* functionTable, NS::UInteger bufferIndex);

    void         setVertexVisibleFunctionTables(const class VisibleFunctionTable* functionTables[], NS::Range range);

    void         setVertexIntersectionFunctionTable(const class IntersectionFunctionTable* intersectionFunctionTable, NS::UInteger bufferIndex);

    void         setVertexIntersectionFunctionTables(const class IntersectionFunctionTable* intersectionFunctionTables[], NS::Range range);

    void         setVertexAccelerationStructure(const class AccelerationStructure* accelerationStructure, NS::UInteger bufferIndex);

    void         setViewport(MTL::Viewport viewport);

    void         setViewports(const MTL::Viewport* viewports, NS::UInteger count);

    void         setFrontFacingWinding(MTL::Winding frontFacingWinding);

    void         setVertexAmplificationCount(NS::UInteger count, const MTL::VertexAmplificationViewMapping* viewMappings);

    void         setCullMode(MTL::CullMode cullMode);

    void         setDepthClipMode(MTL::DepthClipMode depthClipMode);

    void         setDepthBias(float depthBias, float slopeScale, float clamp);

    void         setScissorRect(MTL::ScissorRect rect);

    void         setScissorRects(const MTL::ScissorRect* scissorRects, NS::UInteger count);

    void         setTriangleFillMode(MTL::TriangleFillMode fillMode);

    void         setFragmentBytes(const void* bytes, NS::UInteger length, NS::UInteger index);

    void         setFragmentBuffer(const class Buffer* buffer, NS::UInteger offset, NS::UInteger index);

    void         setFragmentBufferOffset(NS::UInteger offset, NS::UInteger index);

    void         setFragmentBuffers(MTL::Buffer* buffers[], const NS::UInteger offsets[], NS::Range range);

    void         setFragmentTexture(const class Texture* texture, NS::UInteger index);

    void         setFragmentTextures(MTL::Texture* textures[], NS::Range range);

    void         setFragmentSamplerState(const class SamplerState* sampler, NS::UInteger index);

    void         setFragmentSamplerStates(MTL::SamplerState* samplers[], NS::Range range);

    void         setFragmentSamplerState(const class SamplerState* sampler, float lodMinClamp, float lodMaxClamp, NS::UInteger index);

    void         setFragmentSamplerStates(MTL::SamplerState* samplers[], const float lodMinClamps[], const float lodMaxClamps[], NS::Range range);

    void         setFragmentVisibleFunctionTable(const class VisibleFunctionTable* functionTable, NS::UInteger bufferIndex);

    void         setFragmentVisibleFunctionTables(const VisibleFunctionTable* functionTables[], NS::Range range);

    void         setFragmentIntersectionFunctionTable(const class IntersectionFunctionTable* intersectionFunctionTable, NS::UInteger bufferIndex);

    void         setFragmentIntersectionFunctionTables(const class IntersectionFunctionTable* intersectionFunctionTables[], NS::Range range);

    void         setFragmentAccelerationStructure(const class AccelerationStructure* accelerationStructure, NS::UInteger bufferIndex);

    void         setBlendColorRed(float red, float green, float blue, float alpha);

    void         setDepthStencilState(const class DepthStencilState* depthStencilState);

    void         setStencilReferenceValue(uint32_t referenceValue);

    void         setStencilFrontReferenceValue(uint32_t frontReferenceValue, uint32_t backReferenceValue);

    void         setVisibilityResultMode(MTL::VisibilityResultMode mode, NS::UInteger offset);

    void         setColorStoreAction(MTL::StoreAction storeAction, NS::UInteger colorAttachmentIndex);

    void         setDepthStoreAction(MTL::StoreAction storeAction);

    void         setStencilStoreAction(MTL::StoreAction storeAction);

    void         setColorStoreActionOptions(MTL::StoreActionOptions storeActionOptions, NS::UInteger colorAttachmentIndex);

    void         setDepthStoreActionOptions(MTL::StoreActionOptions storeActionOptions);

    void         setStencilStoreActionOptions(MTL::StoreActionOptions storeActionOptions);

    void         drawPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger vertexStart, NS::UInteger vertexCount, NS::UInteger instanceCount);

    void         drawPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger vertexStart, NS::UInteger vertexCount);

    void         drawIndexedPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger indexCount, MTL::IndexType indexType, const class Buffer* indexBuffer, NS::UInteger indexBufferOffset, NS::UInteger instanceCount);

    void         drawIndexedPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger indexCount, MTL::IndexType indexType, const class Buffer* indexBuffer, NS::UInteger indexBufferOffset);

    void         drawPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger vertexStart, NS::UInteger vertexCount, NS::UInteger instanceCount, NS::UInteger baseInstance);

    void         drawIndexedPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger indexCount, MTL::IndexType indexType, const class Buffer* indexBuffer, NS::UInteger indexBufferOffset, NS::UInteger instanceCount, NS::Integer baseVertex, NS::UInteger baseInstance);

    void         drawPrimitives(MTL::PrimitiveType primitiveType, const class Buffer* indirectBuffer, NS::UInteger indirectBufferOffset);

    void         drawIndexedPrimitives(MTL::PrimitiveType primitiveType, MTL::IndexType indexType, const class Buffer* indexBuffer, NS::UInteger indexBufferOffset, const class Buffer* indirectBuffer, NS::UInteger indirectBufferOffset);

    void         textureBarrier();

    void         updateFence(const class Fence* fence, MTL::RenderStages stages);

    void         waitForFence(const class Fence* fence, MTL::RenderStages stages);

    void         setTessellationFactorBuffer(const class Buffer* buffer, NS::UInteger offset, NS::UInteger instanceStride);

    void         setTessellationFactorScale(float scale);

    void         drawPatches(NS::UInteger numberOfPatchControlPoints, NS::UInteger patchStart, NS::UInteger patchCount, const class Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, NS::UInteger instanceCount, NS::UInteger baseInstance);

    void         drawPatches(NS::UInteger numberOfPatchControlPoints, const class Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, const class Buffer* indirectBuffer, NS::UInteger indirectBufferOffset);

    void         drawIndexedPatches(NS::UInteger numberOfPatchControlPoints, NS::UInteger patchStart, NS::UInteger patchCount, const class Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, const class Buffer* controlPointIndexBuffer, NS::UInteger controlPointIndexBufferOffset, NS::UInteger instanceCount, NS::UInteger baseInstance);

    void         drawIndexedPatches(NS::UInteger numberOfPatchControlPoints, const class Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, const class Buffer* controlPointIndexBuffer, NS::UInteger controlPointIndexBufferOffset, const class Buffer* indirectBuffer, NS::UInteger indirectBufferOffset);

    NS::UInteger tileWidth() const;

    NS::UInteger tileHeight() const;

    void         setTileBytes(const void* bytes, NS::UInteger length, NS::UInteger index);

    void         setTileBuffer(const class Buffer* buffer, NS::UInteger offset, NS::UInteger index);

    void         setTileBufferOffset(NS::UInteger offset, NS::UInteger index);

    void         setTileBuffers(MTL::Buffer* buffers, const NS::UInteger* offsets, NS::Range range);

    void         setTileTexture(const class Texture* texture, NS::UInteger index);

    void         setTileTextures(MTL::Texture* textures[], NS::Range range);

    void         setTileSamplerState(const class SamplerState* sampler, NS::UInteger index);

    void         setTileSamplerStates(MTL::SamplerState* samplers[], NS::Range range);

    void         setTileSamplerState(const class SamplerState* sampler, float lodMinClamp, float lodMaxClamp, NS::UInteger index);

    void         setTileSamplerStates(MTL::SamplerState* samplers[], const float lodMinClamps[], const float lodMaxClamps[], NS::Range range);

    void         setTileVisibleFunctionTable(const class VisibleFunctionTable* functionTable, NS::UInteger bufferIndex);

    void         setTileVisibleFunctionTables(const class VisibleFunctionTable* functionTables[], NS::Range range);

    void         setTileIntersectionFunctionTable(const class IntersectionFunctionTable* intersectionFunctionTable, NS::UInteger bufferIndex);

    void         setTileIntersectionFunctionTables(const class IntersectionFunctionTable* intersectionFunctionTables[], NS::Range range);

    void         setTileAccelerationStructure(const class AccelerationStructure* accelerationStructure, NS::UInteger bufferIndex);

    void         dispatchThreadsPerTile(MTL::Size threadsPerTile);

    void         setThreadgroupMemoryLength(NS::UInteger length, NS::UInteger offset, NS::UInteger index);

    void         useResource(const class Resource* resource, MTL::ResourceUsage usage);

    void         useResources(MTL::Resource* resources[], NS::UInteger count, MTL::ResourceUsage usage);

    void         useResource(const class Resource* resource, MTL::ResourceUsage usage, MTL::RenderStages stages);

    void         useResources(MTL::Resource* resources, NS::UInteger count, MTL::ResourceUsage usage, MTL::RenderStages stages);

    void         useHeap(const class Heap* heap);

    void         useHeaps(MTL::Heap* heaps[], NS::UInteger count);

    void         useHeap(const class Heap* heap, MTL::RenderStages stages);

    void         useHeaps(MTL::Heap* heaps[], NS::UInteger count, MTL::RenderStages stages);

    void         executeCommandsInBuffer(const class IndirectCommandBuffer* indirectCommandBuffer, NS::Range executionRange);

    void         executeCommandsInBuffer(const class IndirectCommandBuffer* indirectCommandbuffer, const class Buffer* indirectRangeBuffer, NS::UInteger indirectBufferOffset);

    void         memoryBarrier(MTL::BarrierScope scope, MTL::RenderStages after, MTL::RenderStages before);

    void         memoryBarrier(MTL::Resource* resources[], NS::UInteger count, MTL::RenderStages after, MTL::RenderStages before);

    void         sampleCountersInBuffer(const class CounterSampleBuffer* sampleBuffer, NS::UInteger sampleIndex, bool barrier);
};

}

_MTL_INLINE void MTL::RenderCommandEncoder::setRenderPipelineState(const MTL::RenderPipelineState* pipelineState)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRenderPipelineState_), pipelineState);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexBytes(const void* bytes, NS::UInteger length, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexBytes_length_atIndex_), bytes, length, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexBuffer(const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexBuffer_offset_atIndex_), buffer, offset, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexBufferOffset(NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexBufferOffset_atIndex_), offset, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexBuffers(MTL::Buffer* buffers[], const NS::UInteger offsets[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexBuffers_offsets_withRange_), buffers, offsets, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexTexture(const MTL::Texture* texture, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexTexture_atIndex_), texture, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexTextures(MTL::Texture* textures[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexTextures_withRange_), textures, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexSamplerState(const MTL::SamplerState* sampler, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexSamplerState_atIndex_), sampler, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexSamplerStates(MTL::SamplerState* samplers[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexSamplerStates_withRange_), samplers, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexSamplerState(const MTL::SamplerState* sampler, float lodMinClamp, float lodMaxClamp, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexSamplerState_lodMinClamp_lodMaxClamp_atIndex_), sampler, lodMinClamp, lodMaxClamp, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexSamplerStates(MTL::SamplerState* samplers[], const float lodMinClamps[], const float lodMaxClamps[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexSamplerStates_lodMinClamps_lodMaxClamps_withRange_), samplers, lodMinClamps, lodMaxClamps, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexVisibleFunctionTable(const MTL::VisibleFunctionTable* functionTable, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexVisibleFunctionTable_atBufferIndex_), functionTable, bufferIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexVisibleFunctionTables(const MTL::VisibleFunctionTable* functionTables[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexVisibleFunctionTables_withBufferRange_), functionTables, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexIntersectionFunctionTable(const MTL::IntersectionFunctionTable* intersectionFunctionTable, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexIntersectionFunctionTable_atBufferIndex_), intersectionFunctionTable, bufferIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexIntersectionFunctionTables(const MTL::IntersectionFunctionTable* intersectionFunctionTables[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexIntersectionFunctionTables_withBufferRange_), intersectionFunctionTables, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexAccelerationStructure(const MTL::AccelerationStructure* accelerationStructure, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexAccelerationStructure_atBufferIndex_), accelerationStructure, bufferIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setViewport(MTL::Viewport viewport)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setViewport_), viewport);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setViewports(const MTL::Viewport* viewports, NS::UInteger count)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setViewports_count_), viewports, count);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFrontFacingWinding(MTL::Winding frontFacingWinding)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFrontFacingWinding_), frontFacingWinding);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVertexAmplificationCount(NS::UInteger count, const MTL::VertexAmplificationViewMapping* viewMappings)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexAmplificationCount_viewMappings_), count, viewMappings);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setCullMode(MTL::CullMode cullMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setCullMode_), cullMode);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setDepthClipMode(MTL::DepthClipMode depthClipMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthClipMode_), depthClipMode);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setDepthBias(float depthBias, float slopeScale, float clamp)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthBias_slopeScale_clamp_), depthBias, slopeScale, clamp);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setScissorRect(MTL::ScissorRect rect)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setScissorRect_), rect);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setScissorRects(const MTL::ScissorRect* scissorRects, NS::UInteger count)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setScissorRects_count_), scissorRects, count);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTriangleFillMode(MTL::TriangleFillMode fillMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTriangleFillMode_), fillMode);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentBytes(const void* bytes, NS::UInteger length, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentBytes_length_atIndex_), bytes, length, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentBuffer(const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentBuffer_offset_atIndex_), buffer, offset, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentBufferOffset(NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentBufferOffset_atIndex_), offset, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentBuffers(MTL::Buffer* buffers[], const NS::UInteger offsets[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentBuffers_offsets_withRange_), buffers, offsets, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentTexture(const MTL::Texture* texture, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentTexture_atIndex_), texture, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentTextures(MTL::Texture* textures[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentTextures_withRange_), textures, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentSamplerState(const MTL::SamplerState* sampler, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentSamplerState_atIndex_), sampler, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentSamplerStates(MTL::SamplerState* samplers[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentSamplerStates_withRange_), samplers, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentSamplerState(const MTL::SamplerState* sampler, float lodMinClamp, float lodMaxClamp, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentSamplerState_lodMinClamp_lodMaxClamp_atIndex_), sampler, lodMinClamp, lodMaxClamp, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentSamplerStates(MTL::SamplerState* samplers[], const float lodMinClamps[], const float lodMaxClamps[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentSamplerStates_lodMinClamps_lodMaxClamps_withRange_), samplers, lodMinClamps, lodMaxClamps, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentVisibleFunctionTable(const MTL::VisibleFunctionTable* functionTable, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentVisibleFunctionTable_atBufferIndex_), functionTable, bufferIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentVisibleFunctionTables(const MTL::VisibleFunctionTable* functionTables[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentVisibleFunctionTables_withBufferRange_), functionTables, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentIntersectionFunctionTable(const MTL::IntersectionFunctionTable* intersectionFunctionTable, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentIntersectionFunctionTable_atBufferIndex_), intersectionFunctionTable, bufferIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentIntersectionFunctionTables(const MTL::IntersectionFunctionTable* intersectionFunctionTables[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentIntersectionFunctionTables_withBufferRange_), intersectionFunctionTables, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setFragmentAccelerationStructure(const MTL::AccelerationStructure* accelerationStructure, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentAccelerationStructure_atBufferIndex_), accelerationStructure, bufferIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setBlendColorRed(float red, float green, float blue, float alpha)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBlendColorRed_green_blue_alpha_), red, green, blue, alpha);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setDepthStencilState(const MTL::DepthStencilState* depthStencilState)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthStencilState_), depthStencilState);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setStencilReferenceValue(uint32_t referenceValue)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilReferenceValue_), referenceValue);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setStencilFrontReferenceValue(uint32_t frontReferenceValue, uint32_t backReferenceValue)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilFrontReferenceValue_backReferenceValue_), frontReferenceValue, backReferenceValue);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setVisibilityResultMode(MTL::VisibilityResultMode mode, NS::UInteger offset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVisibilityResultMode_offset_), mode, offset);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setColorStoreAction(MTL::StoreAction storeAction, NS::UInteger colorAttachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setColorStoreAction_atIndex_), storeAction, colorAttachmentIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setDepthStoreAction(MTL::StoreAction storeAction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthStoreAction_), storeAction);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setStencilStoreAction(MTL::StoreAction storeAction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilStoreAction_), storeAction);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setColorStoreActionOptions(MTL::StoreActionOptions storeActionOptions, NS::UInteger colorAttachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setColorStoreActionOptions_atIndex_), storeActionOptions, colorAttachmentIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setDepthStoreActionOptions(MTL::StoreActionOptions storeActionOptions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthStoreActionOptions_), storeActionOptions);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setStencilStoreActionOptions(MTL::StoreActionOptions storeActionOptions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilStoreActionOptions_), storeActionOptions);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger vertexStart, NS::UInteger vertexCount, NS::UInteger instanceCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawPrimitives_vertexStart_vertexCount_instanceCount_), primitiveType, vertexStart, vertexCount, instanceCount);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger vertexStart, NS::UInteger vertexCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawPrimitives_vertexStart_vertexCount_), primitiveType, vertexStart, vertexCount);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawIndexedPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger indexCount, MTL::IndexType indexType, const MTL::Buffer* indexBuffer, NS::UInteger indexBufferOffset, NS::UInteger instanceCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawIndexedPrimitives_indexCount_indexType_indexBuffer_indexBufferOffset_instanceCount_), primitiveType, indexCount, indexType, indexBuffer, indexBufferOffset, instanceCount);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawIndexedPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger indexCount, MTL::IndexType indexType, const MTL::Buffer* indexBuffer, NS::UInteger indexBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawIndexedPrimitives_indexCount_indexType_indexBuffer_indexBufferOffset_), primitiveType, indexCount, indexType, indexBuffer, indexBufferOffset);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger vertexStart, NS::UInteger vertexCount, NS::UInteger instanceCount, NS::UInteger baseInstance)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawPrimitives_vertexStart_vertexCount_instanceCount_baseInstance_), primitiveType, vertexStart, vertexCount, instanceCount, baseInstance);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawIndexedPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger indexCount, MTL::IndexType indexType, const MTL::Buffer* indexBuffer, NS::UInteger indexBufferOffset, NS::UInteger instanceCount, NS::Integer baseVertex, NS::UInteger baseInstance)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawIndexedPrimitives_indexCount_indexType_indexBuffer_indexBufferOffset_instanceCount_baseVertex_baseInstance_), primitiveType, indexCount, indexType, indexBuffer, indexBufferOffset, instanceCount, baseVertex, baseInstance);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawPrimitives(MTL::PrimitiveType primitiveType, const MTL::Buffer* indirectBuffer, NS::UInteger indirectBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawPrimitives_indirectBuffer_indirectBufferOffset_), primitiveType, indirectBuffer, indirectBufferOffset);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawIndexedPrimitives(MTL::PrimitiveType primitiveType, MTL::IndexType indexType, const MTL::Buffer* indexBuffer, NS::UInteger indexBufferOffset, const MTL::Buffer* indirectBuffer, NS::UInteger indirectBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawIndexedPrimitives_indexType_indexBuffer_indexBufferOffset_indirectBuffer_indirectBufferOffset_), primitiveType, indexType, indexBuffer, indexBufferOffset, indirectBuffer, indirectBufferOffset);
}

_MTL_INLINE void MTL::RenderCommandEncoder::textureBarrier()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(textureBarrier));
}

_MTL_INLINE void MTL::RenderCommandEncoder::updateFence(const MTL::Fence* fence, MTL::RenderStages stages)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(updateFence_afterStages_), fence, stages);
}

_MTL_INLINE void MTL::RenderCommandEncoder::waitForFence(const MTL::Fence* fence, MTL::RenderStages stages)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(waitForFence_beforeStages_), fence, stages);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTessellationFactorBuffer(const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger instanceStride)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTessellationFactorBuffer_offset_instanceStride_), buffer, offset, instanceStride);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTessellationFactorScale(float scale)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTessellationFactorScale_), scale);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawPatches(NS::UInteger numberOfPatchControlPoints, NS::UInteger patchStart, NS::UInteger patchCount, const MTL::Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, NS::UInteger instanceCount, NS::UInteger baseInstance)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawPatches_patchStart_patchCount_patchIndexBuffer_patchIndexBufferOffset_instanceCount_baseInstance_), numberOfPatchControlPoints, patchStart, patchCount, patchIndexBuffer, patchIndexBufferOffset, instanceCount, baseInstance);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawPatches(NS::UInteger numberOfPatchControlPoints, const MTL::Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, const MTL::Buffer* indirectBuffer, NS::UInteger indirectBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawPatches_patchIndexBuffer_patchIndexBufferOffset_indirectBuffer_indirectBufferOffset_), numberOfPatchControlPoints, patchIndexBuffer, patchIndexBufferOffset, indirectBuffer, indirectBufferOffset);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawIndexedPatches(NS::UInteger numberOfPatchControlPoints, NS::UInteger patchStart, NS::UInteger patchCount, const MTL::Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, const MTL::Buffer* controlPointIndexBuffer, NS::UInteger controlPointIndexBufferOffset, NS::UInteger instanceCount, NS::UInteger baseInstance)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawIndexedPatches_patchStart_patchCount_patchIndexBuffer_patchIndexBufferOffset_controlPointIndexBuffer_controlPointIndexBufferOffset_instanceCount_baseInstance_), numberOfPatchControlPoints, patchStart, patchCount, patchIndexBuffer, patchIndexBufferOffset, controlPointIndexBuffer, controlPointIndexBufferOffset, instanceCount, baseInstance);
}

_MTL_INLINE void MTL::RenderCommandEncoder::drawIndexedPatches(NS::UInteger numberOfPatchControlPoints, const MTL::Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, const MTL::Buffer* controlPointIndexBuffer, NS::UInteger controlPointIndexBufferOffset, const MTL::Buffer* indirectBuffer, NS::UInteger indirectBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawIndexedPatches_patchIndexBuffer_patchIndexBufferOffset_controlPointIndexBuffer_controlPointIndexBufferOffset_indirectBuffer_indirectBufferOffset_), numberOfPatchControlPoints, patchIndexBuffer, patchIndexBufferOffset, controlPointIndexBuffer, controlPointIndexBufferOffset, indirectBuffer, indirectBufferOffset);
}

_MTL_INLINE NS::UInteger MTL::RenderCommandEncoder::tileWidth() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(tileWidth));
}

_MTL_INLINE NS::UInteger MTL::RenderCommandEncoder::tileHeight() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(tileHeight));
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileBytes(const void* bytes, NS::UInteger length, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileBytes_length_atIndex_), bytes, length, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileBuffer(const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileBuffer_offset_atIndex_), buffer, offset, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileBufferOffset(NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileBufferOffset_atIndex_), offset, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileBuffers(MTL::Buffer* buffers, const NS::UInteger* offsets, NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileBuffers_offsets_withRange_), buffers, offsets, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileTexture(const MTL::Texture* texture, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileTexture_atIndex_), texture, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileTextures(MTL::Texture* textures[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileTextures_withRange_), textures, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileSamplerState(const MTL::SamplerState* sampler, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileSamplerState_atIndex_), sampler, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileSamplerStates(MTL::SamplerState* samplers[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileSamplerStates_withRange_), samplers, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileSamplerState(const MTL::SamplerState* sampler, float lodMinClamp, float lodMaxClamp, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileSamplerState_lodMinClamp_lodMaxClamp_atIndex_), sampler, lodMinClamp, lodMaxClamp, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileSamplerStates(MTL::SamplerState* samplers[], const float lodMinClamps[], const float lodMaxClamps[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileSamplerStates_lodMinClamps_lodMaxClamps_withRange_), samplers, lodMinClamps, lodMaxClamps, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileVisibleFunctionTable(const MTL::VisibleFunctionTable* functionTable, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileVisibleFunctionTable_atBufferIndex_), functionTable, bufferIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileVisibleFunctionTables(const MTL::VisibleFunctionTable* functionTables[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileVisibleFunctionTables_withBufferRange_), functionTables, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileIntersectionFunctionTable(const MTL::IntersectionFunctionTable* intersectionFunctionTable, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileIntersectionFunctionTable_atBufferIndex_), intersectionFunctionTable, bufferIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileIntersectionFunctionTables(const MTL::IntersectionFunctionTable* intersectionFunctionTables[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileIntersectionFunctionTables_withBufferRange_), intersectionFunctionTables, range);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setTileAccelerationStructure(const MTL::AccelerationStructure* accelerationStructure, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileAccelerationStructure_atBufferIndex_), accelerationStructure, bufferIndex);
}

_MTL_INLINE void MTL::RenderCommandEncoder::dispatchThreadsPerTile(MTL::Size threadsPerTile)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(dispatchThreadsPerTile_), threadsPerTile);
}

_MTL_INLINE void MTL::RenderCommandEncoder::setThreadgroupMemoryLength(NS::UInteger length, NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setThreadgroupMemoryLength_offset_atIndex_), length, offset, index);
}

_MTL_INLINE void MTL::RenderCommandEncoder::useResource(const MTL::Resource* resource, MTL::ResourceUsage usage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useResource_usage_), resource, usage);
}

_MTL_INLINE void MTL::RenderCommandEncoder::useResources(MTL::Resource* resources[], NS::UInteger count, MTL::ResourceUsage usage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useResources_count_usage_), resources, count, usage);
}

_MTL_INLINE void MTL::RenderCommandEncoder::useResource(const MTL::Resource* resource, MTL::ResourceUsage usage, MTL::RenderStages stages)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useResource_usage_stages_), resource, usage, stages);
}

_MTL_INLINE void MTL::RenderCommandEncoder::useResources(MTL::Resource* resources, NS::UInteger count, MTL::ResourceUsage usage, MTL::RenderStages stages)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useResources_count_usage_stages_), resources, count, usage, stages);
}

_MTL_INLINE void MTL::RenderCommandEncoder::useHeap(const MTL::Heap* heap)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useHeap_), heap);
}

_MTL_INLINE void MTL::RenderCommandEncoder::useHeaps(MTL::Heap* heaps[], NS::UInteger count)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useHeaps_count_), heaps, count);
}

_MTL_INLINE void MTL::RenderCommandEncoder::useHeap(const MTL::Heap* heap, MTL::RenderStages stages)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useHeap_stages_), heap, stages);
}

_MTL_INLINE void MTL::RenderCommandEncoder::useHeaps(MTL::Heap* heaps[], NS::UInteger count, MTL::RenderStages stages)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useHeaps_count_stages_), heaps, count, stages);
}

_MTL_INLINE void MTL::RenderCommandEncoder::executeCommandsInBuffer(const MTL::IndirectCommandBuffer* indirectCommandBuffer, NS::Range executionRange)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(executeCommandsInBuffer_withRange_), indirectCommandBuffer, executionRange);
}

_MTL_INLINE void MTL::RenderCommandEncoder::executeCommandsInBuffer(const MTL::IndirectCommandBuffer* indirectCommandbuffer, const MTL::Buffer* indirectRangeBuffer, NS::UInteger indirectBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(executeCommandsInBuffer_indirectBuffer_indirectBufferOffset_), indirectCommandbuffer, indirectRangeBuffer, indirectBufferOffset);
}

_MTL_INLINE void MTL::RenderCommandEncoder::memoryBarrier(MTL::BarrierScope scope, MTL::RenderStages after, MTL::RenderStages before)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(memoryBarrierWithScope_afterStages_beforeStages_), scope, after, before);
}

_MTL_INLINE void MTL::RenderCommandEncoder::memoryBarrier(MTL::Resource* resources[], NS::UInteger count, MTL::RenderStages after, MTL::RenderStages before)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(memoryBarrierWithResources_count_afterStages_beforeStages_), resources, count, after, before);
}

_MTL_INLINE void MTL::RenderCommandEncoder::sampleCountersInBuffer(const MTL::CounterSampleBuffer* sampleBuffer, NS::UInteger sampleIndex, bool barrier)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(sampleCountersInBuffer_atSampleIndex_withBarrier_), sampleBuffer, sampleIndex, barrier);
}

namespace MTL
{
_MTL_ENUM(NS::UInteger, BlendFactor) {
    BlendFactorZero = 0,
    BlendFactorOne = 1,
    BlendFactorSourceColor = 2,
    BlendFactorOneMinusSourceColor = 3,
    BlendFactorSourceAlpha = 4,
    BlendFactorOneMinusSourceAlpha = 5,
    BlendFactorDestinationColor = 6,
    BlendFactorOneMinusDestinationColor = 7,
    BlendFactorDestinationAlpha = 8,
    BlendFactorOneMinusDestinationAlpha = 9,
    BlendFactorSourceAlphaSaturated = 10,
    BlendFactorBlendColor = 11,
    BlendFactorOneMinusBlendColor = 12,
    BlendFactorBlendAlpha = 13,
    BlendFactorOneMinusBlendAlpha = 14,
    BlendFactorSource1Color = 15,
    BlendFactorOneMinusSource1Color = 16,
    BlendFactorSource1Alpha = 17,
    BlendFactorOneMinusSource1Alpha = 18,
};

_MTL_ENUM(NS::UInteger, BlendOperation) {
    BlendOperationAdd = 0,
    BlendOperationSubtract = 1,
    BlendOperationReverseSubtract = 2,
    BlendOperationMin = 3,
    BlendOperationMax = 4,
};

_MTL_OPTIONS(NS::UInteger, ColorWriteMask) {
    ColorWriteMaskNone = 0,
    ColorWriteMaskAlpha = 1,
    ColorWriteMaskBlue = 2,
    ColorWriteMaskGreen = 4,
    ColorWriteMaskRed = 8,
    ColorWriteMaskAll = 15,
};

_MTL_ENUM(NS::UInteger, PrimitiveTopologyClass) {
    PrimitiveTopologyClassUnspecified = 0,
    PrimitiveTopologyClassPoint = 1,
    PrimitiveTopologyClassLine = 2,
    PrimitiveTopologyClassTriangle = 3,
};

_MTL_ENUM(NS::UInteger, TessellationPartitionMode) {
    TessellationPartitionModePow2 = 0,
    TessellationPartitionModeInteger = 1,
    TessellationPartitionModeFractionalOdd = 2,
    TessellationPartitionModeFractionalEven = 3,
};

_MTL_ENUM(NS::UInteger, TessellationFactorStepFunction) {
    TessellationFactorStepFunctionConstant = 0,
    TessellationFactorStepFunctionPerPatch = 1,
    TessellationFactorStepFunctionPerInstance = 2,
    TessellationFactorStepFunctionPerPatchAndPerInstance = 3,
};

_MTL_ENUM(NS::UInteger, TessellationFactorFormat) {
    TessellationFactorFormatHalf = 0,
};

_MTL_ENUM(NS::UInteger, TessellationControlPointIndexType) {
    TessellationControlPointIndexTypeNone = 0,
    TessellationControlPointIndexTypeUInt16 = 1,
    TessellationControlPointIndexTypeUInt32 = 2,
};

class RenderPipelineColorAttachmentDescriptor : public NS::Copying<RenderPipelineColorAttachmentDescriptor>
{
public:
    static class RenderPipelineColorAttachmentDescriptor* alloc();

    class RenderPipelineColorAttachmentDescriptor*        init();

    MTL::PixelFormat                                      pixelFormat() const;
    void                                                  setPixelFormat(MTL::PixelFormat pixelFormat);

    bool                                                  blendingEnabled() const;
    void                                                  setBlendingEnabled(bool blendingEnabled);

    MTL::BlendFactor                                      sourceRGBBlendFactor() const;
    void                                                  setSourceRGBBlendFactor(MTL::BlendFactor sourceRGBBlendFactor);

    MTL::BlendFactor                                      destinationRGBBlendFactor() const;
    void                                                  setDestinationRGBBlendFactor(MTL::BlendFactor destinationRGBBlendFactor);

    MTL::BlendOperation                                   rgbBlendOperation() const;
    void                                                  setRgbBlendOperation(MTL::BlendOperation rgbBlendOperation);

    MTL::BlendFactor                                      sourceAlphaBlendFactor() const;
    void                                                  setSourceAlphaBlendFactor(MTL::BlendFactor sourceAlphaBlendFactor);

    MTL::BlendFactor                                      destinationAlphaBlendFactor() const;
    void                                                  setDestinationAlphaBlendFactor(MTL::BlendFactor destinationAlphaBlendFactor);

    MTL::BlendOperation                                   alphaBlendOperation() const;
    void                                                  setAlphaBlendOperation(MTL::BlendOperation alphaBlendOperation);

    MTL::ColorWriteMask                                   writeMask() const;
    void                                                  setWriteMask(MTL::ColorWriteMask writeMask);
};

class RenderPipelineReflection : public NS::Referencing<RenderPipelineReflection>
{
public:
    static class RenderPipelineReflection* alloc();

    class RenderPipelineReflection*        init();

    NS::Array*                             vertexArguments() const;

    NS::Array*                             fragmentArguments() const;

    NS::Array*                             tileArguments() const;
};

class RenderPipelineDescriptor : public NS::Copying<RenderPipelineDescriptor>
{
public:
    static class RenderPipelineDescriptor*              alloc();

    class RenderPipelineDescriptor*                     init();

    NS::String*                                         label() const;
    void                                                setLabel(const NS::String* label);

    class Function*                                     vertexFunction() const;
    void                                                setVertexFunction(const class Function* vertexFunction);

    class Function*                                     fragmentFunction() const;
    void                                                setFragmentFunction(const class Function* fragmentFunction);

    class VertexDescriptor*                             vertexDescriptor() const;
    void                                                setVertexDescriptor(const class VertexDescriptor* vertexDescriptor);

    NS::UInteger                                        sampleCount() const;
    void                                                setSampleCount(NS::UInteger sampleCount);

    NS::UInteger                                        rasterSampleCount() const;
    void                                                setRasterSampleCount(NS::UInteger rasterSampleCount);

    bool                                                alphaToCoverageEnabled() const;
    void                                                setAlphaToCoverageEnabled(bool alphaToCoverageEnabled);

    bool                                                alphaToOneEnabled() const;
    void                                                setAlphaToOneEnabled(bool alphaToOneEnabled);

    bool                                                rasterizationEnabled() const;
    void                                                setRasterizationEnabled(bool rasterizationEnabled);

    NS::UInteger                                        maxVertexAmplificationCount() const;
    void                                                setMaxVertexAmplificationCount(NS::UInteger maxVertexAmplificationCount);

    class RenderPipelineColorAttachmentDescriptorArray* colorAttachments() const;

    MTL::PixelFormat                                    depthAttachmentPixelFormat() const;
    void                                                setDepthAttachmentPixelFormat(MTL::PixelFormat depthAttachmentPixelFormat);

    MTL::PixelFormat                                    stencilAttachmentPixelFormat() const;
    void                                                setStencilAttachmentPixelFormat(MTL::PixelFormat stencilAttachmentPixelFormat);

    MTL::PrimitiveTopologyClass                         inputPrimitiveTopology() const;
    void                                                setInputPrimitiveTopology(MTL::PrimitiveTopologyClass inputPrimitiveTopology);

    MTL::TessellationPartitionMode                      tessellationPartitionMode() const;
    void                                                setTessellationPartitionMode(MTL::TessellationPartitionMode tessellationPartitionMode);

    NS::UInteger                                        maxTessellationFactor() const;
    void                                                setMaxTessellationFactor(NS::UInteger maxTessellationFactor);

    bool                                                tessellationFactorScaleEnabled() const;
    void                                                setTessellationFactorScaleEnabled(bool tessellationFactorScaleEnabled);

    MTL::TessellationFactorFormat                       tessellationFactorFormat() const;
    void                                                setTessellationFactorFormat(MTL::TessellationFactorFormat tessellationFactorFormat);

    MTL::TessellationControlPointIndexType              tessellationControlPointIndexType() const;
    void                                                setTessellationControlPointIndexType(MTL::TessellationControlPointIndexType tessellationControlPointIndexType);

    MTL::TessellationFactorStepFunction                 tessellationFactorStepFunction() const;
    void                                                setTessellationFactorStepFunction(MTL::TessellationFactorStepFunction tessellationFactorStepFunction);

    MTL::Winding                                        tessellationOutputWindingOrder() const;
    void                                                setTessellationOutputWindingOrder(MTL::Winding tessellationOutputWindingOrder);

    class PipelineBufferDescriptorArray*                vertexBuffers() const;

    class PipelineBufferDescriptorArray*                fragmentBuffers() const;

    bool                                                supportIndirectCommandBuffers() const;
    void                                                setSupportIndirectCommandBuffers(bool supportIndirectCommandBuffers);

    NS::Array*                                          binaryArchives() const;
    void                                                setBinaryArchives(const NS::Array* binaryArchives);

    NS::Array*                                          vertexPreloadedLibraries() const;
    void                                                setVertexPreloadedLibraries(const NS::Array* vertexPreloadedLibraries);

    NS::Array*                                          fragmentPreloadedLibraries() const;
    void                                                setFragmentPreloadedLibraries(const NS::Array* fragmentPreloadedLibraries);

    class LinkedFunctions*                              vertexLinkedFunctions() const;
    void                                                setVertexLinkedFunctions(const class LinkedFunctions* vertexLinkedFunctions);

    class LinkedFunctions*                              fragmentLinkedFunctions() const;
    void                                                setFragmentLinkedFunctions(const class LinkedFunctions* fragmentLinkedFunctions);

    bool                                                supportAddingVertexBinaryFunctions() const;
    void                                                setSupportAddingVertexBinaryFunctions(bool supportAddingVertexBinaryFunctions);

    bool                                                supportAddingFragmentBinaryFunctions() const;
    void                                                setSupportAddingFragmentBinaryFunctions(bool supportAddingFragmentBinaryFunctions);

    NS::UInteger                                        maxVertexCallStackDepth() const;
    void                                                setMaxVertexCallStackDepth(NS::UInteger maxVertexCallStackDepth);

    NS::UInteger                                        maxFragmentCallStackDepth() const;
    void                                                setMaxFragmentCallStackDepth(NS::UInteger maxFragmentCallStackDepth);

    void                                                reset();
};

class RenderPipelineFunctionsDescriptor : public NS::Copying<RenderPipelineFunctionsDescriptor>
{
public:
    static class RenderPipelineFunctionsDescriptor* alloc();

    class RenderPipelineFunctionsDescriptor*        init();

    NS::Array*                                      vertexAdditionalBinaryFunctions() const;
    void                                            setVertexAdditionalBinaryFunctions(const NS::Array* vertexAdditionalBinaryFunctions);

    NS::Array*                                      fragmentAdditionalBinaryFunctions() const;
    void                                            setFragmentAdditionalBinaryFunctions(const NS::Array* fragmentAdditionalBinaryFunctions);

    NS::Array*                                      tileAdditionalBinaryFunctions() const;
    void                                            setTileAdditionalBinaryFunctions(const NS::Array* tileAdditionalBinaryFunctions);
};

class RenderPipelineState : public NS::Referencing<RenderPipelineState>
{
public:
    NS::String*                      label() const;

    class Device*                    device() const;

    NS::UInteger                     maxTotalThreadsPerThreadgroup() const;

    bool                             threadgroupSizeMatchesTileSize() const;

    NS::UInteger                     imageblockSampleLength() const;

    NS::UInteger                     imageblockMemoryLength(MTL::Size imageblockDimensions);

    bool                             supportIndirectCommandBuffers() const;

    class FunctionHandle*            functionHandle(const class Function* function, MTL::RenderStages stage);

    class VisibleFunctionTable*      newVisibleFunctionTable(const class VisibleFunctionTableDescriptor* descriptor, MTL::RenderStages stage);

    class IntersectionFunctionTable* newIntersectionFunctionTable(const class IntersectionFunctionTableDescriptor* descriptor, MTL::RenderStages stage);

    class RenderPipelineState*       newRenderPipelineState(const class RenderPipelineFunctionsDescriptor* additionalBinaryFunctions, NS::Error** error);
};

class RenderPipelineColorAttachmentDescriptorArray : public NS::Referencing<RenderPipelineColorAttachmentDescriptorArray>
{
public:
    static class RenderPipelineColorAttachmentDescriptorArray* alloc();

    class RenderPipelineColorAttachmentDescriptorArray*        init();

    class RenderPipelineColorAttachmentDescriptor*             object(NS::UInteger attachmentIndex);

    void                                                       setObject(const class RenderPipelineColorAttachmentDescriptor* attachment, NS::UInteger attachmentIndex);
};

class TileRenderPipelineColorAttachmentDescriptor : public NS::Copying<TileRenderPipelineColorAttachmentDescriptor>
{
public:
    static class TileRenderPipelineColorAttachmentDescriptor* alloc();

    class TileRenderPipelineColorAttachmentDescriptor*        init();

    MTL::PixelFormat                                          pixelFormat() const;
    void                                                      setPixelFormat(MTL::PixelFormat pixelFormat);
};

class TileRenderPipelineColorAttachmentDescriptorArray : public NS::Referencing<TileRenderPipelineColorAttachmentDescriptorArray>
{
public:
    static class TileRenderPipelineColorAttachmentDescriptorArray* alloc();

    class TileRenderPipelineColorAttachmentDescriptorArray*        init();

    class TileRenderPipelineColorAttachmentDescriptor*             object(NS::UInteger attachmentIndex);

    void                                                           setObject(const class TileRenderPipelineColorAttachmentDescriptor* attachment, NS::UInteger attachmentIndex);
};

class TileRenderPipelineDescriptor : public NS::Copying<TileRenderPipelineDescriptor>
{
public:
    static class TileRenderPipelineDescriptor*              alloc();

    class TileRenderPipelineDescriptor*                     init();

    NS::String*                                             label() const;
    void                                                    setLabel(const NS::String* label);

    class Function*                                         tileFunction() const;
    void                                                    setTileFunction(const class Function* tileFunction);

    NS::UInteger                                            rasterSampleCount() const;
    void                                                    setRasterSampleCount(NS::UInteger rasterSampleCount);

    class TileRenderPipelineColorAttachmentDescriptorArray* colorAttachments() const;

    bool                                                    threadgroupSizeMatchesTileSize() const;
    void                                                    setThreadgroupSizeMatchesTileSize(bool threadgroupSizeMatchesTileSize);

    class PipelineBufferDescriptorArray*                    tileBuffers() const;

    NS::UInteger                                            maxTotalThreadsPerThreadgroup() const;
    void                                                    setMaxTotalThreadsPerThreadgroup(NS::UInteger maxTotalThreadsPerThreadgroup);

    NS::Array*                                              binaryArchives() const;
    void                                                    setBinaryArchives(const NS::Array* binaryArchives);

    NS::Array*                                              preloadedLibraries() const;
    void                                                    setPreloadedLibraries(const NS::Array* preloadedLibraries);

    class LinkedFunctions*                                  linkedFunctions() const;
    void                                                    setLinkedFunctions(const class LinkedFunctions* linkedFunctions);

    bool                                                    supportAddingBinaryFunctions() const;
    void                                                    setSupportAddingBinaryFunctions(bool supportAddingBinaryFunctions);

    NS::UInteger                                            maxCallStackDepth() const;
    void                                                    setMaxCallStackDepth(NS::UInteger maxCallStackDepth);

    void                                                    reset();
};

}

_MTL_INLINE MTL::RenderPipelineColorAttachmentDescriptor* MTL::RenderPipelineColorAttachmentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RenderPipelineColorAttachmentDescriptor>(_MTL_PRIVATE_CLS(MTLRenderPipelineColorAttachmentDescriptor));
}

_MTL_INLINE MTL::RenderPipelineColorAttachmentDescriptor* MTL::RenderPipelineColorAttachmentDescriptor::init()
{
    return NS::Object::init<MTL::RenderPipelineColorAttachmentDescriptor>();
}

_MTL_INLINE MTL::PixelFormat MTL::RenderPipelineColorAttachmentDescriptor::pixelFormat() const
{
    return Object::sendMessage<MTL::PixelFormat>(this, _MTL_PRIVATE_SEL(pixelFormat));
}

_MTL_INLINE void MTL::RenderPipelineColorAttachmentDescriptor::setPixelFormat(MTL::PixelFormat pixelFormat)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setPixelFormat_), pixelFormat);
}

_MTL_INLINE bool MTL::RenderPipelineColorAttachmentDescriptor::blendingEnabled() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isBlendingEnabled));
}

_MTL_INLINE void MTL::RenderPipelineColorAttachmentDescriptor::setBlendingEnabled(bool blendingEnabled)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBlendingEnabled_), blendingEnabled);
}

_MTL_INLINE MTL::BlendFactor MTL::RenderPipelineColorAttachmentDescriptor::sourceRGBBlendFactor() const
{
    return Object::sendMessage<MTL::BlendFactor>(this, _MTL_PRIVATE_SEL(sourceRGBBlendFactor));
}

_MTL_INLINE void MTL::RenderPipelineColorAttachmentDescriptor::setSourceRGBBlendFactor(MTL::BlendFactor sourceRGBBlendFactor)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSourceRGBBlendFactor_), sourceRGBBlendFactor);
}

_MTL_INLINE MTL::BlendFactor MTL::RenderPipelineColorAttachmentDescriptor::destinationRGBBlendFactor() const
{
    return Object::sendMessage<MTL::BlendFactor>(this, _MTL_PRIVATE_SEL(destinationRGBBlendFactor));
}

_MTL_INLINE void MTL::RenderPipelineColorAttachmentDescriptor::setDestinationRGBBlendFactor(MTL::BlendFactor destinationRGBBlendFactor)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDestinationRGBBlendFactor_), destinationRGBBlendFactor);
}

_MTL_INLINE MTL::BlendOperation MTL::RenderPipelineColorAttachmentDescriptor::rgbBlendOperation() const
{
    return Object::sendMessage<MTL::BlendOperation>(this, _MTL_PRIVATE_SEL(rgbBlendOperation));
}

_MTL_INLINE void MTL::RenderPipelineColorAttachmentDescriptor::setRgbBlendOperation(MTL::BlendOperation rgbBlendOperation)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRgbBlendOperation_), rgbBlendOperation);
}

_MTL_INLINE MTL::BlendFactor MTL::RenderPipelineColorAttachmentDescriptor::sourceAlphaBlendFactor() const
{
    return Object::sendMessage<MTL::BlendFactor>(this, _MTL_PRIVATE_SEL(sourceAlphaBlendFactor));
}

_MTL_INLINE void MTL::RenderPipelineColorAttachmentDescriptor::setSourceAlphaBlendFactor(MTL::BlendFactor sourceAlphaBlendFactor)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSourceAlphaBlendFactor_), sourceAlphaBlendFactor);
}

_MTL_INLINE MTL::BlendFactor MTL::RenderPipelineColorAttachmentDescriptor::destinationAlphaBlendFactor() const
{
    return Object::sendMessage<MTL::BlendFactor>(this, _MTL_PRIVATE_SEL(destinationAlphaBlendFactor));
}

_MTL_INLINE void MTL::RenderPipelineColorAttachmentDescriptor::setDestinationAlphaBlendFactor(MTL::BlendFactor destinationAlphaBlendFactor)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDestinationAlphaBlendFactor_), destinationAlphaBlendFactor);
}

_MTL_INLINE MTL::BlendOperation MTL::RenderPipelineColorAttachmentDescriptor::alphaBlendOperation() const
{
    return Object::sendMessage<MTL::BlendOperation>(this, _MTL_PRIVATE_SEL(alphaBlendOperation));
}

_MTL_INLINE void MTL::RenderPipelineColorAttachmentDescriptor::setAlphaBlendOperation(MTL::BlendOperation alphaBlendOperation)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setAlphaBlendOperation_), alphaBlendOperation);
}

_MTL_INLINE MTL::ColorWriteMask MTL::RenderPipelineColorAttachmentDescriptor::writeMask() const
{
    return Object::sendMessage<MTL::ColorWriteMask>(this, _MTL_PRIVATE_SEL(writeMask));
}

_MTL_INLINE void MTL::RenderPipelineColorAttachmentDescriptor::setWriteMask(MTL::ColorWriteMask writeMask)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setWriteMask_), writeMask);
}

_MTL_INLINE MTL::RenderPipelineReflection* MTL::RenderPipelineReflection::alloc()
{
    return NS::Object::alloc<MTL::RenderPipelineReflection>(_MTL_PRIVATE_CLS(MTLRenderPipelineReflection));
}

_MTL_INLINE MTL::RenderPipelineReflection* MTL::RenderPipelineReflection::init()
{
    return NS::Object::init<MTL::RenderPipelineReflection>();
}

_MTL_INLINE NS::Array* MTL::RenderPipelineReflection::vertexArguments() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(vertexArguments));
}

_MTL_INLINE NS::Array* MTL::RenderPipelineReflection::fragmentArguments() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(fragmentArguments));
}

_MTL_INLINE NS::Array* MTL::RenderPipelineReflection::tileArguments() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(tileArguments));
}

_MTL_INLINE MTL::RenderPipelineDescriptor* MTL::RenderPipelineDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RenderPipelineDescriptor>(_MTL_PRIVATE_CLS(MTLRenderPipelineDescriptor));
}

_MTL_INLINE MTL::RenderPipelineDescriptor* MTL::RenderPipelineDescriptor::init()
{
    return NS::Object::init<MTL::RenderPipelineDescriptor>();
}

_MTL_INLINE NS::String* MTL::RenderPipelineDescriptor::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::Function* MTL::RenderPipelineDescriptor::vertexFunction() const
{
    return Object::sendMessage<MTL::Function*>(this, _MTL_PRIVATE_SEL(vertexFunction));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setVertexFunction(const MTL::Function* vertexFunction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexFunction_), vertexFunction);
}

_MTL_INLINE MTL::Function* MTL::RenderPipelineDescriptor::fragmentFunction() const
{
    return Object::sendMessage<MTL::Function*>(this, _MTL_PRIVATE_SEL(fragmentFunction));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setFragmentFunction(const MTL::Function* fragmentFunction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentFunction_), fragmentFunction);
}

_MTL_INLINE MTL::VertexDescriptor* MTL::RenderPipelineDescriptor::vertexDescriptor() const
{
    return Object::sendMessage<MTL::VertexDescriptor*>(this, _MTL_PRIVATE_SEL(vertexDescriptor));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setVertexDescriptor(const MTL::VertexDescriptor* vertexDescriptor)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexDescriptor_), vertexDescriptor);
}

_MTL_INLINE NS::UInteger MTL::RenderPipelineDescriptor::sampleCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(sampleCount));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setSampleCount(NS::UInteger sampleCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSampleCount_), sampleCount);
}

_MTL_INLINE NS::UInteger MTL::RenderPipelineDescriptor::rasterSampleCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(rasterSampleCount));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setRasterSampleCount(NS::UInteger rasterSampleCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRasterSampleCount_), rasterSampleCount);
}

_MTL_INLINE bool MTL::RenderPipelineDescriptor::alphaToCoverageEnabled() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isAlphaToCoverageEnabled));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setAlphaToCoverageEnabled(bool alphaToCoverageEnabled)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setAlphaToCoverageEnabled_), alphaToCoverageEnabled);
}

_MTL_INLINE bool MTL::RenderPipelineDescriptor::alphaToOneEnabled() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isAlphaToOneEnabled));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setAlphaToOneEnabled(bool alphaToOneEnabled)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setAlphaToOneEnabled_), alphaToOneEnabled);
}

_MTL_INLINE bool MTL::RenderPipelineDescriptor::rasterizationEnabled() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isRasterizationEnabled));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setRasterizationEnabled(bool rasterizationEnabled)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRasterizationEnabled_), rasterizationEnabled);
}

_MTL_INLINE NS::UInteger MTL::RenderPipelineDescriptor::maxVertexAmplificationCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxVertexAmplificationCount));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setMaxVertexAmplificationCount(NS::UInteger maxVertexAmplificationCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxVertexAmplificationCount_), maxVertexAmplificationCount);
}

_MTL_INLINE MTL::RenderPipelineColorAttachmentDescriptorArray* MTL::RenderPipelineDescriptor::colorAttachments() const
{
    return Object::sendMessage<MTL::RenderPipelineColorAttachmentDescriptorArray*>(this, _MTL_PRIVATE_SEL(colorAttachments));
}

_MTL_INLINE MTL::PixelFormat MTL::RenderPipelineDescriptor::depthAttachmentPixelFormat() const
{
    return Object::sendMessage<MTL::PixelFormat>(this, _MTL_PRIVATE_SEL(depthAttachmentPixelFormat));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setDepthAttachmentPixelFormat(MTL::PixelFormat depthAttachmentPixelFormat)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthAttachmentPixelFormat_), depthAttachmentPixelFormat);
}

_MTL_INLINE MTL::PixelFormat MTL::RenderPipelineDescriptor::stencilAttachmentPixelFormat() const
{
    return Object::sendMessage<MTL::PixelFormat>(this, _MTL_PRIVATE_SEL(stencilAttachmentPixelFormat));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setStencilAttachmentPixelFormat(MTL::PixelFormat stencilAttachmentPixelFormat)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilAttachmentPixelFormat_), stencilAttachmentPixelFormat);
}

_MTL_INLINE MTL::PrimitiveTopologyClass MTL::RenderPipelineDescriptor::inputPrimitiveTopology() const
{
    return Object::sendMessage<MTL::PrimitiveTopologyClass>(this, _MTL_PRIVATE_SEL(inputPrimitiveTopology));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setInputPrimitiveTopology(MTL::PrimitiveTopologyClass inputPrimitiveTopology)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setInputPrimitiveTopology_), inputPrimitiveTopology);
}

_MTL_INLINE MTL::TessellationPartitionMode MTL::RenderPipelineDescriptor::tessellationPartitionMode() const
{
    return Object::sendMessage<MTL::TessellationPartitionMode>(this, _MTL_PRIVATE_SEL(tessellationPartitionMode));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setTessellationPartitionMode(MTL::TessellationPartitionMode tessellationPartitionMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTessellationPartitionMode_), tessellationPartitionMode);
}

_MTL_INLINE NS::UInteger MTL::RenderPipelineDescriptor::maxTessellationFactor() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxTessellationFactor));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setMaxTessellationFactor(NS::UInteger maxTessellationFactor)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxTessellationFactor_), maxTessellationFactor);
}

_MTL_INLINE bool MTL::RenderPipelineDescriptor::tessellationFactorScaleEnabled() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isTessellationFactorScaleEnabled));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setTessellationFactorScaleEnabled(bool tessellationFactorScaleEnabled)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTessellationFactorScaleEnabled_), tessellationFactorScaleEnabled);
}

_MTL_INLINE MTL::TessellationFactorFormat MTL::RenderPipelineDescriptor::tessellationFactorFormat() const
{
    return Object::sendMessage<MTL::TessellationFactorFormat>(this, _MTL_PRIVATE_SEL(tessellationFactorFormat));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setTessellationFactorFormat(MTL::TessellationFactorFormat tessellationFactorFormat)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTessellationFactorFormat_), tessellationFactorFormat);
}

_MTL_INLINE MTL::TessellationControlPointIndexType MTL::RenderPipelineDescriptor::tessellationControlPointIndexType() const
{
    return Object::sendMessage<MTL::TessellationControlPointIndexType>(this, _MTL_PRIVATE_SEL(tessellationControlPointIndexType));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setTessellationControlPointIndexType(MTL::TessellationControlPointIndexType tessellationControlPointIndexType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTessellationControlPointIndexType_), tessellationControlPointIndexType);
}

_MTL_INLINE MTL::TessellationFactorStepFunction MTL::RenderPipelineDescriptor::tessellationFactorStepFunction() const
{
    return Object::sendMessage<MTL::TessellationFactorStepFunction>(this, _MTL_PRIVATE_SEL(tessellationFactorStepFunction));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setTessellationFactorStepFunction(MTL::TessellationFactorStepFunction tessellationFactorStepFunction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTessellationFactorStepFunction_), tessellationFactorStepFunction);
}

_MTL_INLINE MTL::Winding MTL::RenderPipelineDescriptor::tessellationOutputWindingOrder() const
{
    return Object::sendMessage<MTL::Winding>(this, _MTL_PRIVATE_SEL(tessellationOutputWindingOrder));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setTessellationOutputWindingOrder(MTL::Winding tessellationOutputWindingOrder)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTessellationOutputWindingOrder_), tessellationOutputWindingOrder);
}

_MTL_INLINE MTL::PipelineBufferDescriptorArray* MTL::RenderPipelineDescriptor::vertexBuffers() const
{
    return Object::sendMessage<MTL::PipelineBufferDescriptorArray*>(this, _MTL_PRIVATE_SEL(vertexBuffers));
}

_MTL_INLINE MTL::PipelineBufferDescriptorArray* MTL::RenderPipelineDescriptor::fragmentBuffers() const
{
    return Object::sendMessage<MTL::PipelineBufferDescriptorArray*>(this, _MTL_PRIVATE_SEL(fragmentBuffers));
}

_MTL_INLINE bool MTL::RenderPipelineDescriptor::supportIndirectCommandBuffers() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportIndirectCommandBuffers));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setSupportIndirectCommandBuffers(bool supportIndirectCommandBuffers)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSupportIndirectCommandBuffers_), supportIndirectCommandBuffers);
}

_MTL_INLINE NS::Array* MTL::RenderPipelineDescriptor::binaryArchives() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(binaryArchives));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setBinaryArchives(const NS::Array* binaryArchives)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBinaryArchives_), binaryArchives);
}

_MTL_INLINE NS::Array* MTL::RenderPipelineDescriptor::vertexPreloadedLibraries() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(vertexPreloadedLibraries));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setVertexPreloadedLibraries(const NS::Array* vertexPreloadedLibraries)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexPreloadedLibraries_), vertexPreloadedLibraries);
}

_MTL_INLINE NS::Array* MTL::RenderPipelineDescriptor::fragmentPreloadedLibraries() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(fragmentPreloadedLibraries));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setFragmentPreloadedLibraries(const NS::Array* fragmentPreloadedLibraries)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentPreloadedLibraries_), fragmentPreloadedLibraries);
}

_MTL_INLINE MTL::LinkedFunctions* MTL::RenderPipelineDescriptor::vertexLinkedFunctions() const
{
    return Object::sendMessage<MTL::LinkedFunctions*>(this, _MTL_PRIVATE_SEL(vertexLinkedFunctions));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setVertexLinkedFunctions(const MTL::LinkedFunctions* vertexLinkedFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexLinkedFunctions_), vertexLinkedFunctions);
}

_MTL_INLINE MTL::LinkedFunctions* MTL::RenderPipelineDescriptor::fragmentLinkedFunctions() const
{
    return Object::sendMessage<MTL::LinkedFunctions*>(this, _MTL_PRIVATE_SEL(fragmentLinkedFunctions));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setFragmentLinkedFunctions(const MTL::LinkedFunctions* fragmentLinkedFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentLinkedFunctions_), fragmentLinkedFunctions);
}

_MTL_INLINE bool MTL::RenderPipelineDescriptor::supportAddingVertexBinaryFunctions() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportAddingVertexBinaryFunctions));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setSupportAddingVertexBinaryFunctions(bool supportAddingVertexBinaryFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSupportAddingVertexBinaryFunctions_), supportAddingVertexBinaryFunctions);
}

_MTL_INLINE bool MTL::RenderPipelineDescriptor::supportAddingFragmentBinaryFunctions() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportAddingFragmentBinaryFunctions));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setSupportAddingFragmentBinaryFunctions(bool supportAddingFragmentBinaryFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSupportAddingFragmentBinaryFunctions_), supportAddingFragmentBinaryFunctions);
}

_MTL_INLINE NS::UInteger MTL::RenderPipelineDescriptor::maxVertexCallStackDepth() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxVertexCallStackDepth));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setMaxVertexCallStackDepth(NS::UInteger maxVertexCallStackDepth)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxVertexCallStackDepth_), maxVertexCallStackDepth);
}

_MTL_INLINE NS::UInteger MTL::RenderPipelineDescriptor::maxFragmentCallStackDepth() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxFragmentCallStackDepth));
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::setMaxFragmentCallStackDepth(NS::UInteger maxFragmentCallStackDepth)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxFragmentCallStackDepth_), maxFragmentCallStackDepth);
}

_MTL_INLINE void MTL::RenderPipelineDescriptor::reset()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(reset));
}

_MTL_INLINE MTL::RenderPipelineFunctionsDescriptor* MTL::RenderPipelineFunctionsDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RenderPipelineFunctionsDescriptor>(_MTL_PRIVATE_CLS(MTLRenderPipelineFunctionsDescriptor));
}

_MTL_INLINE MTL::RenderPipelineFunctionsDescriptor* MTL::RenderPipelineFunctionsDescriptor::init()
{
    return NS::Object::init<MTL::RenderPipelineFunctionsDescriptor>();
}

_MTL_INLINE NS::Array* MTL::RenderPipelineFunctionsDescriptor::vertexAdditionalBinaryFunctions() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(vertexAdditionalBinaryFunctions));
}

_MTL_INLINE void MTL::RenderPipelineFunctionsDescriptor::setVertexAdditionalBinaryFunctions(const NS::Array* vertexAdditionalBinaryFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexAdditionalBinaryFunctions_), vertexAdditionalBinaryFunctions);
}

_MTL_INLINE NS::Array* MTL::RenderPipelineFunctionsDescriptor::fragmentAdditionalBinaryFunctions() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(fragmentAdditionalBinaryFunctions));
}

_MTL_INLINE void MTL::RenderPipelineFunctionsDescriptor::setFragmentAdditionalBinaryFunctions(const NS::Array* fragmentAdditionalBinaryFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentAdditionalBinaryFunctions_), fragmentAdditionalBinaryFunctions);
}

_MTL_INLINE NS::Array* MTL::RenderPipelineFunctionsDescriptor::tileAdditionalBinaryFunctions() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(tileAdditionalBinaryFunctions));
}

_MTL_INLINE void MTL::RenderPipelineFunctionsDescriptor::setTileAdditionalBinaryFunctions(const NS::Array* tileAdditionalBinaryFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileAdditionalBinaryFunctions_), tileAdditionalBinaryFunctions);
}

_MTL_INLINE NS::String* MTL::RenderPipelineState::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE MTL::Device* MTL::RenderPipelineState::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::UInteger MTL::RenderPipelineState::maxTotalThreadsPerThreadgroup() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxTotalThreadsPerThreadgroup));
}

_MTL_INLINE bool MTL::RenderPipelineState::threadgroupSizeMatchesTileSize() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(threadgroupSizeMatchesTileSize));
}

_MTL_INLINE NS::UInteger MTL::RenderPipelineState::imageblockSampleLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(imageblockSampleLength));
}

_MTL_INLINE NS::UInteger MTL::RenderPipelineState::imageblockMemoryLength(MTL::Size imageblockDimensions)
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(imageblockMemoryLengthForDimensions_), imageblockDimensions);
}

_MTL_INLINE bool MTL::RenderPipelineState::supportIndirectCommandBuffers() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportIndirectCommandBuffers));
}

_MTL_INLINE MTL::FunctionHandle* MTL::RenderPipelineState::functionHandle(const MTL::Function* function, MTL::RenderStages stage)
{
    return Object::sendMessage<MTL::FunctionHandle*>(this, _MTL_PRIVATE_SEL(functionHandleWithFunction_stage_), function, stage);
}

_MTL_INLINE MTL::VisibleFunctionTable* MTL::RenderPipelineState::newVisibleFunctionTable(const MTL::VisibleFunctionTableDescriptor* descriptor, MTL::RenderStages stage)
{
    return Object::sendMessage<MTL::VisibleFunctionTable*>(this, _MTL_PRIVATE_SEL(newVisibleFunctionTableWithDescriptor_stage_), descriptor, stage);
}

_MTL_INLINE MTL::IntersectionFunctionTable* MTL::RenderPipelineState::newIntersectionFunctionTable(const MTL::IntersectionFunctionTableDescriptor* descriptor, MTL::RenderStages stage)
{
    return Object::sendMessage<MTL::IntersectionFunctionTable*>(this, _MTL_PRIVATE_SEL(newIntersectionFunctionTableWithDescriptor_stage_), descriptor, stage);
}

_MTL_INLINE MTL::RenderPipelineState* MTL::RenderPipelineState::newRenderPipelineState(const MTL::RenderPipelineFunctionsDescriptor* additionalBinaryFunctions, NS::Error** error)
{
    return Object::sendMessage<MTL::RenderPipelineState*>(this, _MTL_PRIVATE_SEL(newRenderPipelineStateWithAdditionalBinaryFunctions_error_), additionalBinaryFunctions, error);
}

_MTL_INLINE MTL::RenderPipelineColorAttachmentDescriptorArray* MTL::RenderPipelineColorAttachmentDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::RenderPipelineColorAttachmentDescriptorArray>(_MTL_PRIVATE_CLS(MTLRenderPipelineColorAttachmentDescriptorArray));
}

_MTL_INLINE MTL::RenderPipelineColorAttachmentDescriptorArray* MTL::RenderPipelineColorAttachmentDescriptorArray::init()
{
    return NS::Object::init<MTL::RenderPipelineColorAttachmentDescriptorArray>();
}

_MTL_INLINE MTL::RenderPipelineColorAttachmentDescriptor* MTL::RenderPipelineColorAttachmentDescriptorArray::object(NS::UInteger attachmentIndex)
{
    return Object::sendMessage<MTL::RenderPipelineColorAttachmentDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), attachmentIndex);
}

_MTL_INLINE void MTL::RenderPipelineColorAttachmentDescriptorArray::setObject(const MTL::RenderPipelineColorAttachmentDescriptor* attachment, NS::UInteger attachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), attachment, attachmentIndex);
}

_MTL_INLINE MTL::TileRenderPipelineColorAttachmentDescriptor* MTL::TileRenderPipelineColorAttachmentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::TileRenderPipelineColorAttachmentDescriptor>(_MTL_PRIVATE_CLS(MTLTileRenderPipelineColorAttachmentDescriptor));
}

_MTL_INLINE MTL::TileRenderPipelineColorAttachmentDescriptor* MTL::TileRenderPipelineColorAttachmentDescriptor::init()
{
    return NS::Object::init<MTL::TileRenderPipelineColorAttachmentDescriptor>();
}

_MTL_INLINE MTL::PixelFormat MTL::TileRenderPipelineColorAttachmentDescriptor::pixelFormat() const
{
    return Object::sendMessage<MTL::PixelFormat>(this, _MTL_PRIVATE_SEL(pixelFormat));
}

_MTL_INLINE void MTL::TileRenderPipelineColorAttachmentDescriptor::setPixelFormat(MTL::PixelFormat pixelFormat)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setPixelFormat_), pixelFormat);
}

_MTL_INLINE MTL::TileRenderPipelineColorAttachmentDescriptorArray* MTL::TileRenderPipelineColorAttachmentDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::TileRenderPipelineColorAttachmentDescriptorArray>(_MTL_PRIVATE_CLS(MTLTileRenderPipelineColorAttachmentDescriptorArray));
}

_MTL_INLINE MTL::TileRenderPipelineColorAttachmentDescriptorArray* MTL::TileRenderPipelineColorAttachmentDescriptorArray::init()
{
    return NS::Object::init<MTL::TileRenderPipelineColorAttachmentDescriptorArray>();
}

_MTL_INLINE MTL::TileRenderPipelineColorAttachmentDescriptor* MTL::TileRenderPipelineColorAttachmentDescriptorArray::object(NS::UInteger attachmentIndex)
{
    return Object::sendMessage<MTL::TileRenderPipelineColorAttachmentDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), attachmentIndex);
}

_MTL_INLINE void MTL::TileRenderPipelineColorAttachmentDescriptorArray::setObject(const MTL::TileRenderPipelineColorAttachmentDescriptor* attachment, NS::UInteger attachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), attachment, attachmentIndex);
}

_MTL_INLINE MTL::TileRenderPipelineDescriptor* MTL::TileRenderPipelineDescriptor::alloc()
{
    return NS::Object::alloc<MTL::TileRenderPipelineDescriptor>(_MTL_PRIVATE_CLS(MTLTileRenderPipelineDescriptor));
}

_MTL_INLINE MTL::TileRenderPipelineDescriptor* MTL::TileRenderPipelineDescriptor::init()
{
    return NS::Object::init<MTL::TileRenderPipelineDescriptor>();
}

_MTL_INLINE NS::String* MTL::TileRenderPipelineDescriptor::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::Function* MTL::TileRenderPipelineDescriptor::tileFunction() const
{
    return Object::sendMessage<MTL::Function*>(this, _MTL_PRIVATE_SEL(tileFunction));
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::setTileFunction(const MTL::Function* tileFunction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTileFunction_), tileFunction);
}

_MTL_INLINE NS::UInteger MTL::TileRenderPipelineDescriptor::rasterSampleCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(rasterSampleCount));
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::setRasterSampleCount(NS::UInteger rasterSampleCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRasterSampleCount_), rasterSampleCount);
}

_MTL_INLINE MTL::TileRenderPipelineColorAttachmentDescriptorArray* MTL::TileRenderPipelineDescriptor::colorAttachments() const
{
    return Object::sendMessage<MTL::TileRenderPipelineColorAttachmentDescriptorArray*>(this, _MTL_PRIVATE_SEL(colorAttachments));
}

_MTL_INLINE bool MTL::TileRenderPipelineDescriptor::threadgroupSizeMatchesTileSize() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(threadgroupSizeMatchesTileSize));
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::setThreadgroupSizeMatchesTileSize(bool threadgroupSizeMatchesTileSize)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setThreadgroupSizeMatchesTileSize_), threadgroupSizeMatchesTileSize);
}

_MTL_INLINE MTL::PipelineBufferDescriptorArray* MTL::TileRenderPipelineDescriptor::tileBuffers() const
{
    return Object::sendMessage<MTL::PipelineBufferDescriptorArray*>(this, _MTL_PRIVATE_SEL(tileBuffers));
}

_MTL_INLINE NS::UInteger MTL::TileRenderPipelineDescriptor::maxTotalThreadsPerThreadgroup() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxTotalThreadsPerThreadgroup));
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::setMaxTotalThreadsPerThreadgroup(NS::UInteger maxTotalThreadsPerThreadgroup)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxTotalThreadsPerThreadgroup_), maxTotalThreadsPerThreadgroup);
}

_MTL_INLINE NS::Array* MTL::TileRenderPipelineDescriptor::binaryArchives() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(binaryArchives));
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::setBinaryArchives(const NS::Array* binaryArchives)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBinaryArchives_), binaryArchives);
}

_MTL_INLINE NS::Array* MTL::TileRenderPipelineDescriptor::preloadedLibraries() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(preloadedLibraries));
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::setPreloadedLibraries(const NS::Array* preloadedLibraries)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setPreloadedLibraries_), preloadedLibraries);
}

_MTL_INLINE MTL::LinkedFunctions* MTL::TileRenderPipelineDescriptor::linkedFunctions() const
{
    return Object::sendMessage<MTL::LinkedFunctions*>(this, _MTL_PRIVATE_SEL(linkedFunctions));
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::setLinkedFunctions(const MTL::LinkedFunctions* linkedFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLinkedFunctions_), linkedFunctions);
}

_MTL_INLINE bool MTL::TileRenderPipelineDescriptor::supportAddingBinaryFunctions() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportAddingBinaryFunctions));
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::setSupportAddingBinaryFunctions(bool supportAddingBinaryFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSupportAddingBinaryFunctions_), supportAddingBinaryFunctions);
}

_MTL_INLINE NS::UInteger MTL::TileRenderPipelineDescriptor::maxCallStackDepth() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxCallStackDepth));
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::setMaxCallStackDepth(NS::UInteger maxCallStackDepth)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMaxCallStackDepth_), maxCallStackDepth);
}

_MTL_INLINE void MTL::TileRenderPipelineDescriptor::reset()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(reset));
}

namespace MTL
{
class ArgumentEncoder : public NS::Referencing<ArgumentEncoder>
{
public:
    class Device*          device() const;

    NS::String*            label() const;
    void                   setLabel(const NS::String* label);

    NS::UInteger           encodedLength() const;

    NS::UInteger           alignment() const;

    void                   setArgumentBuffer(const class Buffer* argumentBuffer, NS::UInteger offset);

    void                   setArgumentBuffer(const class Buffer* argumentBuffer, NS::UInteger startOffset, NS::UInteger arrayElement);

    void                   setBuffer(const class Buffer* buffer, NS::UInteger offset, NS::UInteger index);

    void                   setBuffers(MTL::Buffer* buffers[], const NS::UInteger offsets[], NS::Range range);

    void                   setTexture(const class Texture* texture, NS::UInteger index);

    void                   setTextures(MTL::Texture* textures[], NS::Range range);

    void                   setSamplerState(const class SamplerState* sampler, NS::UInteger index);

    void                   setSamplerStates(MTL::SamplerState* samplers[], NS::Range range);

    void*                  constantData(NS::UInteger index);

    void                   setRenderPipelineState(const class RenderPipelineState* pipeline, NS::UInteger index);

    void                   setRenderPipelineStates(MTL::RenderPipelineState* pipelines, NS::Range range);

    void                   setComputePipelineState(const class ComputePipelineState* pipeline, NS::UInteger index);

    void                   setComputePipelineStates(MTL::ComputePipelineState* pipelines, NS::Range range);

    void                   setIndirectCommandBuffer(const class IndirectCommandBuffer* indirectCommandBuffer, NS::UInteger index);

    void                   setIndirectCommandBuffers(MTL::IndirectCommandBuffer* buffers, NS::Range range);

    void                   setAccelerationStructure(const class AccelerationStructure* accelerationStructure, NS::UInteger index);

    class ArgumentEncoder* newArgumentEncoder(NS::UInteger index);

    void                   setVisibleFunctionTable(const class VisibleFunctionTable* visibleFunctionTable, NS::UInteger index);

    void                   setVisibleFunctionTables(const VisibleFunctionTable* visibleFunctionTables[], NS::Range range);

    void                   setIntersectionFunctionTable(const class IntersectionFunctionTable* intersectionFunctionTable, NS::UInteger index);

    void                   setIntersectionFunctionTables(const IntersectionFunctionTable* intersectionFunctionTables[], NS::Range range);
};

}

_MTL_INLINE MTL::Device* MTL::ArgumentEncoder::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::String* MTL::ArgumentEncoder::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::ArgumentEncoder::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE NS::UInteger MTL::ArgumentEncoder::encodedLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(encodedLength));
}

_MTL_INLINE NS::UInteger MTL::ArgumentEncoder::alignment() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(alignment));
}

_MTL_INLINE void MTL::ArgumentEncoder::setArgumentBuffer(const MTL::Buffer* argumentBuffer, NS::UInteger offset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setArgumentBuffer_offset_), argumentBuffer, offset);
}

_MTL_INLINE void MTL::ArgumentEncoder::setArgumentBuffer(const MTL::Buffer* argumentBuffer, NS::UInteger startOffset, NS::UInteger arrayElement)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setArgumentBuffer_startOffset_arrayElement_), argumentBuffer, startOffset, arrayElement);
}

_MTL_INLINE void MTL::ArgumentEncoder::setBuffer(const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBuffer_offset_atIndex_), buffer, offset, index);
}

_MTL_INLINE void MTL::ArgumentEncoder::setBuffers(MTL::Buffer* buffers[], const NS::UInteger offsets[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBuffers_offsets_withRange_), buffers, offsets, range);
}

_MTL_INLINE void MTL::ArgumentEncoder::setTexture(const MTL::Texture* texture, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTexture_atIndex_), texture, index);
}

_MTL_INLINE void MTL::ArgumentEncoder::setTextures(MTL::Texture* textures[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTextures_withRange_), textures, range);
}

_MTL_INLINE void MTL::ArgumentEncoder::setSamplerState(const MTL::SamplerState* sampler, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSamplerState_atIndex_), sampler, index);
}

_MTL_INLINE void MTL::ArgumentEncoder::setSamplerStates(MTL::SamplerState* samplers[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSamplerStates_withRange_), samplers, range);
}

_MTL_INLINE void* MTL::ArgumentEncoder::constantData(NS::UInteger index)
{
    return Object::sendMessage<void*>(this, _MTL_PRIVATE_SEL(constantDataAtIndex_), index);
}

_MTL_INLINE void MTL::ArgumentEncoder::setRenderPipelineState(const MTL::RenderPipelineState* pipeline, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRenderPipelineState_atIndex_), pipeline, index);
}

_MTL_INLINE void MTL::ArgumentEncoder::setRenderPipelineStates(MTL::RenderPipelineState* pipelines, NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRenderPipelineStates_withRange_), pipelines, range);
}

_MTL_INLINE void MTL::ArgumentEncoder::setComputePipelineState(const MTL::ComputePipelineState* pipeline, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setComputePipelineState_atIndex_), pipeline, index);
}

_MTL_INLINE void MTL::ArgumentEncoder::setComputePipelineStates(MTL::ComputePipelineState* pipelines, NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setComputePipelineStates_withRange_), pipelines, range);
}

_MTL_INLINE void MTL::ArgumentEncoder::setIndirectCommandBuffer(const MTL::IndirectCommandBuffer* indirectCommandBuffer, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndirectCommandBuffer_atIndex_), indirectCommandBuffer, index);
}

_MTL_INLINE void MTL::ArgumentEncoder::setIndirectCommandBuffers(MTL::IndirectCommandBuffer* buffers, NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndirectCommandBuffers_withRange_), buffers, range);
}

_MTL_INLINE void MTL::ArgumentEncoder::setAccelerationStructure(const MTL::AccelerationStructure* accelerationStructure, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setAccelerationStructure_atIndex_), accelerationStructure, index);
}

_MTL_INLINE MTL::ArgumentEncoder* MTL::ArgumentEncoder::newArgumentEncoder(NS::UInteger index)
{
    return Object::sendMessage<MTL::ArgumentEncoder*>(this, _MTL_PRIVATE_SEL(newArgumentEncoderForBufferAtIndex_), index);
}

_MTL_INLINE void MTL::ArgumentEncoder::setVisibleFunctionTable(const MTL::VisibleFunctionTable* visibleFunctionTable, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVisibleFunctionTable_atIndex_), visibleFunctionTable, index);
}

_MTL_INLINE void MTL::ArgumentEncoder::setVisibleFunctionTables(const MTL::VisibleFunctionTable* visibleFunctionTables[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVisibleFunctionTables_withRange_), visibleFunctionTables, range);
}

_MTL_INLINE void MTL::ArgumentEncoder::setIntersectionFunctionTable(const MTL::IntersectionFunctionTable* intersectionFunctionTable, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIntersectionFunctionTable_atIndex_), intersectionFunctionTable, index);
}

_MTL_INLINE void MTL::ArgumentEncoder::setIntersectionFunctionTables(const MTL::IntersectionFunctionTable* intersectionFunctionTables[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIntersectionFunctionTables_withRange_), intersectionFunctionTables, range);
}

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, BinaryArchiveError) {
    BinaryArchiveErrorNone = 0,
    BinaryArchiveErrorInvalidFile = 1,
    BinaryArchiveErrorUnexpectedElement = 2,
    BinaryArchiveErrorCompilationFailure = 3,
};

class BinaryArchiveDescriptor : public NS::Copying<BinaryArchiveDescriptor>
{
public:
    static class BinaryArchiveDescriptor* alloc();

    class BinaryArchiveDescriptor*        init();

    NS::URL*                              url() const;
    void                                  setUrl(const NS::URL* url);
};

class BinaryArchive : public NS::Referencing<BinaryArchive>
{
public:
    NS::String*   label() const;
    void          setLabel(const NS::String* label);

    class Device* device() const;

    bool          addComputePipelineFunctions(const class ComputePipelineDescriptor* descriptor, NS::Error** error);

    bool          addRenderPipelineFunctions(const class RenderPipelineDescriptor* descriptor, NS::Error** error);

    bool          addTileRenderPipelineFunctions(const class TileRenderPipelineDescriptor* descriptor, NS::Error** error);

    bool          serializeToURL(const NS::URL* url, NS::Error** error);

    bool          addFunction(const class FunctionDescriptor* descriptor, const class Library* library, NS::Error** error);
};

}

_MTL_INLINE MTL::BinaryArchiveDescriptor* MTL::BinaryArchiveDescriptor::alloc()
{
    return NS::Object::alloc<MTL::BinaryArchiveDescriptor>(_MTL_PRIVATE_CLS(MTLBinaryArchiveDescriptor));
}

_MTL_INLINE MTL::BinaryArchiveDescriptor* MTL::BinaryArchiveDescriptor::init()
{
    return NS::Object::init<MTL::BinaryArchiveDescriptor>();
}

_MTL_INLINE NS::URL* MTL::BinaryArchiveDescriptor::url() const
{
    return Object::sendMessage<NS::URL*>(this, _MTL_PRIVATE_SEL(url));
}

_MTL_INLINE void MTL::BinaryArchiveDescriptor::setUrl(const NS::URL* url)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setUrl_), url);
}

_MTL_INLINE NS::String* MTL::BinaryArchive::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::BinaryArchive::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::Device* MTL::BinaryArchive::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE bool MTL::BinaryArchive::addComputePipelineFunctions(const MTL::ComputePipelineDescriptor* descriptor, NS::Error** error)
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(addComputePipelineFunctionsWithDescriptor_error_), descriptor, error);
}

_MTL_INLINE bool MTL::BinaryArchive::addRenderPipelineFunctions(const MTL::RenderPipelineDescriptor* descriptor, NS::Error** error)
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(addRenderPipelineFunctionsWithDescriptor_error_), descriptor, error);
}

_MTL_INLINE bool MTL::BinaryArchive::addTileRenderPipelineFunctions(const MTL::TileRenderPipelineDescriptor* descriptor, NS::Error** error)
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(addTileRenderPipelineFunctionsWithDescriptor_error_), descriptor, error);
}

_MTL_INLINE bool MTL::BinaryArchive::serializeToURL(const NS::URL* url, NS::Error** error)
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(serializeToURL_error_), url, error);
}

_MTL_INLINE bool MTL::BinaryArchive::addFunction(const MTL::FunctionDescriptor* descriptor, const MTL::Library* library, NS::Error** error)
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(addFunctionWithDescriptor_library_error_), descriptor, library, error);
}

#pragma once

namespace MTL
{
_MTL_OPTIONS(NS::UInteger, BlitOption) {
    BlitOptionNone = 0,
    BlitOptionDepthFromDepthStencil = 1,
    BlitOptionStencilFromDepthStencil = 2,
    BlitOptionRowLinearPVRTC = 4,
};

class BlitCommandEncoder : public NS::Referencing<BlitCommandEncoder, CommandEncoder>
{
public:
    void synchronizeResource(const class Resource* resource);

    void synchronizeTexture(const class Texture* texture, NS::UInteger slice, NS::UInteger level);

    void copyFromTexture(const class Texture* sourceTexture, NS::UInteger sourceSlice, NS::UInteger sourceLevel, MTL::Origin sourceOrigin, MTL::Size sourceSize, const class Texture* destinationTexture, NS::UInteger destinationSlice, NS::UInteger destinationLevel, MTL::Origin destinationOrigin);

    void copyFromBuffer(const class Buffer* sourceBuffer, NS::UInteger sourceOffset, NS::UInteger sourceBytesPerRow, NS::UInteger sourceBytesPerImage, MTL::Size sourceSize, const class Texture* destinationTexture, NS::UInteger destinationSlice, NS::UInteger destinationLevel, MTL::Origin destinationOrigin);

    void copyFromBuffer(const class Buffer* sourceBuffer, NS::UInteger sourceOffset, NS::UInteger sourceBytesPerRow, NS::UInteger sourceBytesPerImage, MTL::Size sourceSize, const class Texture* destinationTexture, NS::UInteger destinationSlice, NS::UInteger destinationLevel, MTL::Origin destinationOrigin, MTL::BlitOption options);

    void copyFromTexture(const class Texture* sourceTexture, NS::UInteger sourceSlice, NS::UInteger sourceLevel, MTL::Origin sourceOrigin, MTL::Size sourceSize, const class Buffer* destinationBuffer, NS::UInteger destinationOffset, NS::UInteger destinationBytesPerRow, NS::UInteger destinationBytesPerImage);

    void copyFromTexture(const class Texture* sourceTexture, NS::UInteger sourceSlice, NS::UInteger sourceLevel, MTL::Origin sourceOrigin, MTL::Size sourceSize, const class Buffer* destinationBuffer, NS::UInteger destinationOffset, NS::UInteger destinationBytesPerRow, NS::UInteger destinationBytesPerImage, MTL::BlitOption options);

    void generateMipmaps(const class Texture* texture);

    void fillBuffer(const class Buffer* buffer, NS::Range range, uint8_t value);

    void copyFromTexture(const class Texture* sourceTexture, NS::UInteger sourceSlice, NS::UInteger sourceLevel, const class Texture* destinationTexture, NS::UInteger destinationSlice, NS::UInteger destinationLevel, NS::UInteger sliceCount, NS::UInteger levelCount);

    void copyFromTexture(const class Texture* sourceTexture, const class Texture* destinationTexture);

    void copyFromBuffer(const class Buffer* sourceBuffer, NS::UInteger sourceOffset, const class Buffer* destinationBuffer, NS::UInteger destinationOffset, NS::UInteger size);

    void updateFence(const class Fence* fence);

    void waitForFence(const class Fence* fence);

    void getTextureAccessCounters(const class Texture* texture, MTL::Region region, NS::UInteger mipLevel, NS::UInteger slice, bool resetCounters, const class Buffer* countersBuffer, NS::UInteger countersBufferOffset);

    void resetTextureAccessCounters(const class Texture* texture, MTL::Region region, NS::UInteger mipLevel, NS::UInteger slice);

    void optimizeContentsForGPUAccess(const class Texture* texture);

    void optimizeContentsForGPUAccess(const class Texture* texture, NS::UInteger slice, NS::UInteger level);

    void optimizeContentsForCPUAccess(const class Texture* texture);

    void optimizeContentsForCPUAccess(const class Texture* texture, NS::UInteger slice, NS::UInteger level);

    void resetCommandsInBuffer(const class IndirectCommandBuffer* buffer, NS::Range range);

    void copyIndirectCommandBuffer(const class IndirectCommandBuffer* source, NS::Range sourceRange, const class IndirectCommandBuffer* destination, NS::UInteger destinationIndex);

    void optimizeIndirectCommandBuffer(const class IndirectCommandBuffer* indirectCommandBuffer, NS::Range range);

    void sampleCountersInBuffer(const class CounterSampleBuffer* sampleBuffer, NS::UInteger sampleIndex, bool barrier);

    void resolveCounters(const class CounterSampleBuffer* sampleBuffer, NS::Range range, const class Buffer* destinationBuffer, NS::UInteger destinationOffset);
};

}

_MTL_INLINE void MTL::BlitCommandEncoder::synchronizeResource(const MTL::Resource* resource)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(synchronizeResource_), resource);
}

_MTL_INLINE void MTL::BlitCommandEncoder::synchronizeTexture(const MTL::Texture* texture, NS::UInteger slice, NS::UInteger level)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(synchronizeTexture_slice_level_), texture, slice, level);
}

_MTL_INLINE void MTL::BlitCommandEncoder::copyFromTexture(const MTL::Texture* sourceTexture, NS::UInteger sourceSlice, NS::UInteger sourceLevel, MTL::Origin sourceOrigin, MTL::Size sourceSize, const MTL::Texture* destinationTexture, NS::UInteger destinationSlice, NS::UInteger destinationLevel, MTL::Origin destinationOrigin)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyFromTexture_sourceSlice_sourceLevel_sourceOrigin_sourceSize_toTexture_destinationSlice_destinationLevel_destinationOrigin_), sourceTexture, sourceSlice, sourceLevel, sourceOrigin, sourceSize, destinationTexture, destinationSlice, destinationLevel, destinationOrigin);
}

_MTL_INLINE void MTL::BlitCommandEncoder::copyFromBuffer(const MTL::Buffer* sourceBuffer, NS::UInteger sourceOffset, NS::UInteger sourceBytesPerRow, NS::UInteger sourceBytesPerImage, MTL::Size sourceSize, const MTL::Texture* destinationTexture, NS::UInteger destinationSlice, NS::UInteger destinationLevel, MTL::Origin destinationOrigin)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyFromBuffer_sourceOffset_sourceBytesPerRow_sourceBytesPerImage_sourceSize_toTexture_destinationSlice_destinationLevel_destinationOrigin_), sourceBuffer, sourceOffset, sourceBytesPerRow, sourceBytesPerImage, sourceSize, destinationTexture, destinationSlice, destinationLevel, destinationOrigin);
}

_MTL_INLINE void MTL::BlitCommandEncoder::copyFromBuffer(const MTL::Buffer* sourceBuffer, NS::UInteger sourceOffset, NS::UInteger sourceBytesPerRow, NS::UInteger sourceBytesPerImage, MTL::Size sourceSize, const MTL::Texture* destinationTexture, NS::UInteger destinationSlice, NS::UInteger destinationLevel, MTL::Origin destinationOrigin, MTL::BlitOption options)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyFromBuffer_sourceOffset_sourceBytesPerRow_sourceBytesPerImage_sourceSize_toTexture_destinationSlice_destinationLevel_destinationOrigin_options_), sourceBuffer, sourceOffset, sourceBytesPerRow, sourceBytesPerImage, sourceSize, destinationTexture, destinationSlice, destinationLevel, destinationOrigin, options);
}

_MTL_INLINE void MTL::BlitCommandEncoder::copyFromTexture(const MTL::Texture* sourceTexture, NS::UInteger sourceSlice, NS::UInteger sourceLevel, MTL::Origin sourceOrigin, MTL::Size sourceSize, const MTL::Buffer* destinationBuffer, NS::UInteger destinationOffset, NS::UInteger destinationBytesPerRow, NS::UInteger destinationBytesPerImage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyFromTexture_sourceSlice_sourceLevel_sourceOrigin_sourceSize_toBuffer_destinationOffset_destinationBytesPerRow_destinationBytesPerImage_), sourceTexture, sourceSlice, sourceLevel, sourceOrigin, sourceSize, destinationBuffer, destinationOffset, destinationBytesPerRow, destinationBytesPerImage);
}

_MTL_INLINE void MTL::BlitCommandEncoder::copyFromTexture(const MTL::Texture* sourceTexture, NS::UInteger sourceSlice, NS::UInteger sourceLevel, MTL::Origin sourceOrigin, MTL::Size sourceSize, const MTL::Buffer* destinationBuffer, NS::UInteger destinationOffset, NS::UInteger destinationBytesPerRow, NS::UInteger destinationBytesPerImage, MTL::BlitOption options)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyFromTexture_sourceSlice_sourceLevel_sourceOrigin_sourceSize_toBuffer_destinationOffset_destinationBytesPerRow_destinationBytesPerImage_options_), sourceTexture, sourceSlice, sourceLevel, sourceOrigin, sourceSize, destinationBuffer, destinationOffset, destinationBytesPerRow, destinationBytesPerImage, options);
}

_MTL_INLINE void MTL::BlitCommandEncoder::generateMipmaps(const MTL::Texture* texture)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(generateMipmapsForTexture_), texture);
}

_MTL_INLINE void MTL::BlitCommandEncoder::fillBuffer(const MTL::Buffer* buffer, NS::Range range, uint8_t value)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(fillBuffer_range_value_), buffer, range, value);
}

_MTL_INLINE void MTL::BlitCommandEncoder::copyFromTexture(const MTL::Texture* sourceTexture, NS::UInteger sourceSlice, NS::UInteger sourceLevel, const MTL::Texture* destinationTexture, NS::UInteger destinationSlice, NS::UInteger destinationLevel, NS::UInteger sliceCount, NS::UInteger levelCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyFromTexture_sourceSlice_sourceLevel_toTexture_destinationSlice_destinationLevel_sliceCount_levelCount_), sourceTexture, sourceSlice, sourceLevel, destinationTexture, destinationSlice, destinationLevel, sliceCount, levelCount);
}

_MTL_INLINE void MTL::BlitCommandEncoder::copyFromTexture(const MTL::Texture* sourceTexture, const MTL::Texture* destinationTexture)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyFromTexture_toTexture_), sourceTexture, destinationTexture);
}

_MTL_INLINE void MTL::BlitCommandEncoder::copyFromBuffer(const MTL::Buffer* sourceBuffer, NS::UInteger sourceOffset, const MTL::Buffer* destinationBuffer, NS::UInteger destinationOffset, NS::UInteger size)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyFromBuffer_sourceOffset_toBuffer_destinationOffset_size_), sourceBuffer, sourceOffset, destinationBuffer, destinationOffset, size);
}

_MTL_INLINE void MTL::BlitCommandEncoder::updateFence(const MTL::Fence* fence)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(updateFence_), fence);
}

_MTL_INLINE void MTL::BlitCommandEncoder::waitForFence(const MTL::Fence* fence)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(waitForFence_), fence);
}

_MTL_INLINE void MTL::BlitCommandEncoder::getTextureAccessCounters(const MTL::Texture* texture, MTL::Region region, NS::UInteger mipLevel, NS::UInteger slice, bool resetCounters, const MTL::Buffer* countersBuffer, NS::UInteger countersBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(getTextureAccessCounters_region_mipLevel_slice_resetCounters_countersBuffer_countersBufferOffset_), texture, region, mipLevel, slice, resetCounters, countersBuffer, countersBufferOffset);
}

_MTL_INLINE void MTL::BlitCommandEncoder::resetTextureAccessCounters(const MTL::Texture* texture, MTL::Region region, NS::UInteger mipLevel, NS::UInteger slice)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(resetTextureAccessCounters_region_mipLevel_slice_), texture, region, mipLevel, slice);
}

_MTL_INLINE void MTL::BlitCommandEncoder::optimizeContentsForGPUAccess(const MTL::Texture* texture)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(optimizeContentsForGPUAccess_), texture);
}

_MTL_INLINE void MTL::BlitCommandEncoder::optimizeContentsForGPUAccess(const MTL::Texture* texture, NS::UInteger slice, NS::UInteger level)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(optimizeContentsForGPUAccess_slice_level_), texture, slice, level);
}

_MTL_INLINE void MTL::BlitCommandEncoder::optimizeContentsForCPUAccess(const MTL::Texture* texture)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(optimizeContentsForCPUAccess_), texture);
}

_MTL_INLINE void MTL::BlitCommandEncoder::optimizeContentsForCPUAccess(const MTL::Texture* texture, NS::UInteger slice, NS::UInteger level)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(optimizeContentsForCPUAccess_slice_level_), texture, slice, level);
}

_MTL_INLINE void MTL::BlitCommandEncoder::resetCommandsInBuffer(const MTL::IndirectCommandBuffer* buffer, NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(resetCommandsInBuffer_withRange_), buffer, range);
}

_MTL_INLINE void MTL::BlitCommandEncoder::copyIndirectCommandBuffer(const MTL::IndirectCommandBuffer* source, NS::Range sourceRange, const MTL::IndirectCommandBuffer* destination, NS::UInteger destinationIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyIndirectCommandBuffer_sourceRange_destination_destinationIndex_), source, sourceRange, destination, destinationIndex);
}

_MTL_INLINE void MTL::BlitCommandEncoder::optimizeIndirectCommandBuffer(const MTL::IndirectCommandBuffer* indirectCommandBuffer, NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(optimizeIndirectCommandBuffer_withRange_), indirectCommandBuffer, range);
}

_MTL_INLINE void MTL::BlitCommandEncoder::sampleCountersInBuffer(const MTL::CounterSampleBuffer* sampleBuffer, NS::UInteger sampleIndex, bool barrier)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(sampleCountersInBuffer_atSampleIndex_withBarrier_), sampleBuffer, sampleIndex, barrier);
}

_MTL_INLINE void MTL::BlitCommandEncoder::resolveCounters(const MTL::CounterSampleBuffer* sampleBuffer, NS::Range range, const MTL::Buffer* destinationBuffer, NS::UInteger destinationOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(resolveCounters_inRange_destinationBuffer_destinationOffset_), sampleBuffer, range, destinationBuffer, destinationOffset);
}

#pragma once

namespace MTL
{
class BlitPassSampleBufferAttachmentDescriptor : public NS::Copying<BlitPassSampleBufferAttachmentDescriptor>
{
public:
    static class BlitPassSampleBufferAttachmentDescriptor* alloc();

    class BlitPassSampleBufferAttachmentDescriptor*        init();

    class CounterSampleBuffer*                             sampleBuffer() const;
    void                                                   setSampleBuffer(const class CounterSampleBuffer* sampleBuffer);

    NS::UInteger                                           startOfEncoderSampleIndex() const;
    void                                                   setStartOfEncoderSampleIndex(NS::UInteger startOfEncoderSampleIndex);

    NS::UInteger                                           endOfEncoderSampleIndex() const;
    void                                                   setEndOfEncoderSampleIndex(NS::UInteger endOfEncoderSampleIndex);
};

class BlitPassSampleBufferAttachmentDescriptorArray : public NS::Referencing<BlitPassSampleBufferAttachmentDescriptorArray>
{
public:
    static class BlitPassSampleBufferAttachmentDescriptorArray* alloc();

    class BlitPassSampleBufferAttachmentDescriptorArray*        init();

    class BlitPassSampleBufferAttachmentDescriptor*             object(NS::UInteger attachmentIndex);

    void                                                        setObject(const class BlitPassSampleBufferAttachmentDescriptor* attachment, NS::UInteger attachmentIndex);
};

class BlitPassDescriptor : public NS::Copying<BlitPassDescriptor>
{
public:
    static class BlitPassDescriptor*                     alloc();

    class BlitPassDescriptor*                            init();

    static class BlitPassDescriptor*                     blitPassDescriptor();

    class BlitPassSampleBufferAttachmentDescriptorArray* sampleBufferAttachments() const;
};

}

_MTL_INLINE MTL::BlitPassSampleBufferAttachmentDescriptor* MTL::BlitPassSampleBufferAttachmentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::BlitPassSampleBufferAttachmentDescriptor>(_MTL_PRIVATE_CLS(MTLBlitPassSampleBufferAttachmentDescriptor));
}

_MTL_INLINE MTL::BlitPassSampleBufferAttachmentDescriptor* MTL::BlitPassSampleBufferAttachmentDescriptor::init()
{
    return NS::Object::init<MTL::BlitPassSampleBufferAttachmentDescriptor>();
}

_MTL_INLINE MTL::CounterSampleBuffer* MTL::BlitPassSampleBufferAttachmentDescriptor::sampleBuffer() const
{
    return Object::sendMessage<MTL::CounterSampleBuffer*>(this, _MTL_PRIVATE_SEL(sampleBuffer));
}

_MTL_INLINE void MTL::BlitPassSampleBufferAttachmentDescriptor::setSampleBuffer(const MTL::CounterSampleBuffer* sampleBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSampleBuffer_), sampleBuffer);
}

_MTL_INLINE NS::UInteger MTL::BlitPassSampleBufferAttachmentDescriptor::startOfEncoderSampleIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(startOfEncoderSampleIndex));
}

_MTL_INLINE void MTL::BlitPassSampleBufferAttachmentDescriptor::setStartOfEncoderSampleIndex(NS::UInteger startOfEncoderSampleIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStartOfEncoderSampleIndex_), startOfEncoderSampleIndex);
}

_MTL_INLINE NS::UInteger MTL::BlitPassSampleBufferAttachmentDescriptor::endOfEncoderSampleIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(endOfEncoderSampleIndex));
}

_MTL_INLINE void MTL::BlitPassSampleBufferAttachmentDescriptor::setEndOfEncoderSampleIndex(NS::UInteger endOfEncoderSampleIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setEndOfEncoderSampleIndex_), endOfEncoderSampleIndex);
}

_MTL_INLINE MTL::BlitPassSampleBufferAttachmentDescriptorArray* MTL::BlitPassSampleBufferAttachmentDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::BlitPassSampleBufferAttachmentDescriptorArray>(_MTL_PRIVATE_CLS(MTLBlitPassSampleBufferAttachmentDescriptorArray));
}

_MTL_INLINE MTL::BlitPassSampleBufferAttachmentDescriptorArray* MTL::BlitPassSampleBufferAttachmentDescriptorArray::init()
{
    return NS::Object::init<MTL::BlitPassSampleBufferAttachmentDescriptorArray>();
}

_MTL_INLINE MTL::BlitPassSampleBufferAttachmentDescriptor* MTL::BlitPassSampleBufferAttachmentDescriptorArray::object(NS::UInteger attachmentIndex)
{
    return Object::sendMessage<MTL::BlitPassSampleBufferAttachmentDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), attachmentIndex);
}

_MTL_INLINE void MTL::BlitPassSampleBufferAttachmentDescriptorArray::setObject(const MTL::BlitPassSampleBufferAttachmentDescriptor* attachment, NS::UInteger attachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), attachment, attachmentIndex);
}

_MTL_INLINE MTL::BlitPassDescriptor* MTL::BlitPassDescriptor::alloc()
{
    return NS::Object::alloc<MTL::BlitPassDescriptor>(_MTL_PRIVATE_CLS(MTLBlitPassDescriptor));
}

_MTL_INLINE MTL::BlitPassDescriptor* MTL::BlitPassDescriptor::init()
{
    return NS::Object::init<MTL::BlitPassDescriptor>();
}

_MTL_INLINE MTL::BlitPassDescriptor* MTL::BlitPassDescriptor::blitPassDescriptor()
{
    return Object::sendMessage<MTL::BlitPassDescriptor*>(_MTL_PRIVATE_CLS(MTLBlitPassDescriptor), _MTL_PRIVATE_SEL(blitPassDescriptor));
}

_MTL_INLINE MTL::BlitPassSampleBufferAttachmentDescriptorArray* MTL::BlitPassDescriptor::sampleBufferAttachments() const
{
    return Object::sendMessage<MTL::BlitPassSampleBufferAttachmentDescriptorArray*>(this, _MTL_PRIVATE_SEL(sampleBufferAttachments));
}

#pragma once

namespace MTL
{
_MTL_ENUM(NS::Integer, CaptureError) {
    CaptureErrorNotSupported = 1,
    CaptureErrorAlreadyCapturing = 2,
    CaptureErrorInvalidDescriptor = 3,
};

_MTL_ENUM(NS::Integer, CaptureDestination) {
    CaptureDestinationDeveloperTools = 1,
    CaptureDestinationGPUTraceDocument = 2,
};

class CaptureDescriptor : public NS::Copying<CaptureDescriptor>
{
public:
    static class CaptureDescriptor* alloc();

    class CaptureDescriptor*        init();

    id                              captureObject() const;
    void                            setCaptureObject(id captureObject);

    MTL::CaptureDestination         destination() const;
    void                            setDestination(MTL::CaptureDestination destination);

    NS::URL*                        outputURL() const;
    void                            setOutputURL(const NS::URL* outputURL);
};

class CaptureManager : public NS::Referencing<CaptureManager>
{
public:
    static class CaptureManager* alloc();

    static class CaptureManager* sharedCaptureManager();

    MTL::CaptureManager*         init();

    class CaptureScope*          newCaptureScope(const class Device* device);

    class CaptureScope*          newCaptureScope(const class CommandQueue* commandQueue);

    bool                         supportsDestination(MTL::CaptureDestination destination);

    bool                         startCapture(const class CaptureDescriptor* descriptor, NS::Error** error);

    void                         startCapture(const class Device* device);

    void                         startCapture(const class CommandQueue* commandQueue);

    void                         startCapture(const class CaptureScope* captureScope);

    void                         stopCapture();

    class CaptureScope*          defaultCaptureScope() const;
    void                         setDefaultCaptureScope(const class CaptureScope* defaultCaptureScope);

    bool                         isCapturing() const;
};

}

_MTL_INLINE MTL::CaptureDescriptor* MTL::CaptureDescriptor::alloc()
{
    return NS::Object::alloc<MTL::CaptureDescriptor>(_MTL_PRIVATE_CLS(MTLCaptureDescriptor));
}

_MTL_INLINE MTL::CaptureDescriptor* MTL::CaptureDescriptor::init()
{
    return NS::Object::init<MTL::CaptureDescriptor>();
}

_MTL_INLINE id MTL::CaptureDescriptor::captureObject() const
{
    return Object::sendMessage<id>(this, _MTL_PRIVATE_SEL(captureObject));
}

_MTL_INLINE void MTL::CaptureDescriptor::setCaptureObject(id captureObject)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setCaptureObject_), captureObject);
}

_MTL_INLINE MTL::CaptureDestination MTL::CaptureDescriptor::destination() const
{
    return Object::sendMessage<MTL::CaptureDestination>(this, _MTL_PRIVATE_SEL(destination));
}

_MTL_INLINE void MTL::CaptureDescriptor::setDestination(MTL::CaptureDestination destination)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDestination_), destination);
}

_MTL_INLINE NS::URL* MTL::CaptureDescriptor::outputURL() const
{
    return Object::sendMessage<NS::URL*>(this, _MTL_PRIVATE_SEL(outputURL));
}

_MTL_INLINE void MTL::CaptureDescriptor::setOutputURL(const NS::URL* outputURL)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setOutputURL_), outputURL);
}

_MTL_INLINE MTL::CaptureManager* MTL::CaptureManager::alloc()
{
    return NS::Object::alloc<MTL::CaptureManager>(_MTL_PRIVATE_CLS(MTLCaptureManager));
}

_MTL_INLINE MTL::CaptureManager* MTL::CaptureManager::sharedCaptureManager()
{
    return Object::sendMessage<MTL::CaptureManager*>(_MTL_PRIVATE_CLS(MTLCaptureManager), _MTL_PRIVATE_SEL(sharedCaptureManager));
}

_MTL_INLINE MTL::CaptureManager* MTL::CaptureManager::init()
{
    return NS::Object::init<MTL::CaptureManager>();
}

_MTL_INLINE MTL::CaptureScope* MTL::CaptureManager::newCaptureScope(const MTL::Device* device)
{
    return Object::sendMessage<MTL::CaptureScope*>(this, _MTL_PRIVATE_SEL(newCaptureScopeWithDevice_), device);
}

_MTL_INLINE MTL::CaptureScope* MTL::CaptureManager::newCaptureScope(const MTL::CommandQueue* commandQueue)
{
    return Object::sendMessage<MTL::CaptureScope*>(this, _MTL_PRIVATE_SEL(newCaptureScopeWithCommandQueue_), commandQueue);
}

_MTL_INLINE bool MTL::CaptureManager::supportsDestination(MTL::CaptureDestination destination)
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsDestination_), destination);
}

_MTL_INLINE bool MTL::CaptureManager::startCapture(const MTL::CaptureDescriptor* descriptor, NS::Error** error)
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(startCaptureWithDescriptor_error_), descriptor, error);
}

_MTL_INLINE void MTL::CaptureManager::startCapture(const MTL::Device* device)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(startCaptureWithDevice_), device);
}

_MTL_INLINE void MTL::CaptureManager::startCapture(const MTL::CommandQueue* commandQueue)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(startCaptureWithCommandQueue_), commandQueue);
}

_MTL_INLINE void MTL::CaptureManager::startCapture(const MTL::CaptureScope* captureScope)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(startCaptureWithScope_), captureScope);
}

_MTL_INLINE void MTL::CaptureManager::stopCapture()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(stopCapture));
}

_MTL_INLINE MTL::CaptureScope* MTL::CaptureManager::defaultCaptureScope() const
{
    return Object::sendMessage<MTL::CaptureScope*>(this, _MTL_PRIVATE_SEL(defaultCaptureScope));
}

_MTL_INLINE void MTL::CaptureManager::setDefaultCaptureScope(const MTL::CaptureScope* defaultCaptureScope)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDefaultCaptureScope_), defaultCaptureScope);
}

_MTL_INLINE bool MTL::CaptureManager::isCapturing() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isCapturing));
}

namespace MTL
{
class CaptureScope : public NS::Referencing<CaptureScope>
{
public:
    class Device*       device() const;

    NS::String*         label() const;
    void                setLabel(const NS::String* pLabel);

    class CommandQueue* commandQueue() const;

    void                beginScope();
    void                endScope();
};
}

_MTL_INLINE MTL::Device* MTL::CaptureScope::device() const
{
    return Object::sendMessage<Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::String* MTL::CaptureScope::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::CaptureScope::setLabel(const NS::String* pLabel)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), pLabel);
}

_MTL_INLINE MTL::CommandQueue* MTL::CaptureScope::commandQueue() const
{
    return Object::sendMessage<CommandQueue*>(this, _MTL_PRIVATE_SEL(commandQueue));
}

_MTL_INLINE void MTL::CaptureScope::beginScope()
{
    return Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(beginScope));
}

_MTL_INLINE void MTL::CaptureScope::endScope()
{
    return Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(endScope));
}

#pragma once

#include <functional>

namespace MTL
{
_MTL_ENUM(NS::UInteger, CommandBufferStatus) {
    CommandBufferStatusNotEnqueued = 0,
    CommandBufferStatusEnqueued = 1,
    CommandBufferStatusCommitted = 2,
    CommandBufferStatusScheduled = 3,
    CommandBufferStatusCompleted = 4,
    CommandBufferStatusError = 5,
};

_MTL_ENUM(NS::UInteger, CommandBufferError) {
    CommandBufferErrorNone = 0,
    CommandBufferErrorTimeout = 2,
    CommandBufferErrorPageFault = 3,
    CommandBufferErrorAccessRevoked = 4,
    CommandBufferErrorBlacklisted = 4,
    CommandBufferErrorNotPermitted = 7,
    CommandBufferErrorOutOfMemory = 8,
    CommandBufferErrorInvalidResource = 9,
    CommandBufferErrorMemoryless = 10,
    CommandBufferErrorDeviceRemoved = 11,
    CommandBufferErrorStackOverflow = 12,
};

_MTL_OPTIONS(NS::UInteger, CommandBufferErrorOption) {
    CommandBufferErrorOptionNone = 0,
    CommandBufferErrorOptionEncoderExecutionStatus = 1,
};

_MTL_ENUM(NS::Integer, CommandEncoderErrorState) {
    CommandEncoderErrorStateUnknown = 0,
    CommandEncoderErrorStateCompleted = 1,
    CommandEncoderErrorStateAffected = 2,
    CommandEncoderErrorStatePending = 3,
    CommandEncoderErrorStateFaulted = 4,
};

class CommandBufferDescriptor : public NS::Copying<CommandBufferDescriptor>
{
public:
    static class CommandBufferDescriptor* alloc();

    class CommandBufferDescriptor*        init();

    bool                                  retainedReferences() const;
    void                                  setRetainedReferences(bool retainedReferences);

    MTL::CommandBufferErrorOption         errorOptions() const;
    void                                  setErrorOptions(MTL::CommandBufferErrorOption errorOptions);
};

class CommandBufferEncoderInfo : public NS::Referencing<CommandBufferEncoderInfo>
{
public:
    NS::String*                   label() const;

    NS::Array*                    debugSignposts() const;

    MTL::CommandEncoderErrorState errorState() const;
};

_MTL_ENUM(NS::UInteger, DispatchType) {
    DispatchTypeSerial = 0,
    DispatchTypeConcurrent = 1,
};

class CommandBuffer;

using CommandBufferHandler = void (^)(CommandBuffer*);

using HandlerFunction = std::function<void(CommandBuffer*)>;

class CommandBuffer : public NS::Referencing<CommandBuffer>
{
public:
    void                                       addScheduledHandler(const HandlerFunction& function);

    void                                       addCompletedHandler(const HandlerFunction& function);

    class Device*                              device() const;

    class CommandQueue*                        commandQueue() const;

    bool                                       retainedReferences() const;

    MTL::CommandBufferErrorOption              errorOptions() const;

    NS::String*                                label() const;
    void                                       setLabel(const NS::String* label);

    CFTimeInterval                             kernelStartTime() const;

    CFTimeInterval                             kernelEndTime() const;

    class LogContainer*                        logs() const;

    CFTimeInterval                             GPUStartTime() const;

    CFTimeInterval                             GPUEndTime() const;

    void                                       enqueue();

    void                                       commit();

    void                                       addScheduledHandler(const MTL::CommandBufferHandler block);

    void                                       presentDrawable(const class Drawable* drawable);

    void                                       presentDrawableAtTime(const class Drawable* drawable, CFTimeInterval presentationTime);

    void                                       presentDrawableAfterMinimumDuration(const class Drawable* drawable, CFTimeInterval duration);

    void                                       waitUntilScheduled();

    void                                       addCompletedHandler(const MTL::CommandBufferHandler block);

    void                                       waitUntilCompleted();

    MTL::CommandBufferStatus                   status() const;

    NS::Error*                                 error() const;

    class BlitCommandEncoder*                  blitCommandEncoder();

    class RenderCommandEncoder*                renderCommandEncoder(const class RenderPassDescriptor* renderPassDescriptor);

    class ComputeCommandEncoder*               computeCommandEncoder(const class ComputePassDescriptor* computePassDescriptor);

    class BlitCommandEncoder*                  blitCommandEncoder(const class BlitPassDescriptor* blitPassDescriptor);

    class ComputeCommandEncoder*               computeCommandEncoder();

    class ComputeCommandEncoder*               computeCommandEncoder(MTL::DispatchType dispatchType);

    void                                       encodeWait(const class Event* event, uint64_t value);

    void                                       encodeSignalEvent(const class Event* event, uint64_t value);

    class ParallelRenderCommandEncoder*        parallelRenderCommandEncoder(const class RenderPassDescriptor* renderPassDescriptor);

    class ResourceStateCommandEncoder*         resourceStateCommandEncoder();

    class ResourceStateCommandEncoder*         resourceStateCommandEncoder(const class ResourceStatePassDescriptor* resourceStatePassDescriptor);

    class AccelerationStructureCommandEncoder* accelerationStructureCommandEncoder();

    void                                       pushDebugGroup(const NS::String* string);

    void                                       popDebugGroup();
};

}

_MTL_INLINE MTL::CommandBufferDescriptor* MTL::CommandBufferDescriptor::alloc()
{
    return NS::Object::alloc<MTL::CommandBufferDescriptor>(_MTL_PRIVATE_CLS(MTLCommandBufferDescriptor));
}

_MTL_INLINE MTL::CommandBufferDescriptor* MTL::CommandBufferDescriptor::init()
{
    return NS::Object::init<MTL::CommandBufferDescriptor>();
}

_MTL_INLINE bool MTL::CommandBufferDescriptor::retainedReferences() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(retainedReferences));
}

_MTL_INLINE void MTL::CommandBufferDescriptor::setRetainedReferences(bool retainedReferences)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRetainedReferences_), retainedReferences);
}

_MTL_INLINE MTL::CommandBufferErrorOption MTL::CommandBufferDescriptor::errorOptions() const
{
    return Object::sendMessage<MTL::CommandBufferErrorOption>(this, _MTL_PRIVATE_SEL(errorOptions));
}

_MTL_INLINE void MTL::CommandBufferDescriptor::setErrorOptions(MTL::CommandBufferErrorOption errorOptions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setErrorOptions_), errorOptions);
}

_MTL_INLINE NS::String* MTL::CommandBufferEncoderInfo::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE NS::Array* MTL::CommandBufferEncoderInfo::debugSignposts() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(debugSignposts));
}

_MTL_INLINE MTL::CommandEncoderErrorState MTL::CommandBufferEncoderInfo::errorState() const
{
    return Object::sendMessage<MTL::CommandEncoderErrorState>(this, _MTL_PRIVATE_SEL(errorState));
}

_MTL_INLINE void MTL::CommandBuffer::addScheduledHandler(const HandlerFunction& function)
{
    __block HandlerFunction blockFunction = function;

    addScheduledHandler(^(MTL::CommandBuffer* pCommandBuffer) { blockFunction(pCommandBuffer); });
}

_MTL_INLINE void MTL::CommandBuffer::addCompletedHandler(const HandlerFunction& function)
{
    __block HandlerFunction blockFunction = function;

    addCompletedHandler(^(MTL::CommandBuffer* pCommandBuffer) { blockFunction(pCommandBuffer); });
}

_MTL_INLINE MTL::Device* MTL::CommandBuffer::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE MTL::CommandQueue* MTL::CommandBuffer::commandQueue() const
{
    return Object::sendMessage<MTL::CommandQueue*>(this, _MTL_PRIVATE_SEL(commandQueue));
}

_MTL_INLINE bool MTL::CommandBuffer::retainedReferences() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(retainedReferences));
}

_MTL_INLINE MTL::CommandBufferErrorOption MTL::CommandBuffer::errorOptions() const
{
    return Object::sendMessage<MTL::CommandBufferErrorOption>(this, _MTL_PRIVATE_SEL(errorOptions));
}

_MTL_INLINE NS::String* MTL::CommandBuffer::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::CommandBuffer::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE CFTimeInterval MTL::CommandBuffer::kernelStartTime() const
{
    return Object::sendMessage<CFTimeInterval>(this, _MTL_PRIVATE_SEL(kernelStartTime));
}

_MTL_INLINE CFTimeInterval MTL::CommandBuffer::kernelEndTime() const
{
    return Object::sendMessage<CFTimeInterval>(this, _MTL_PRIVATE_SEL(kernelEndTime));
}

_MTL_INLINE MTL::LogContainer* MTL::CommandBuffer::logs() const
{
    return Object::sendMessage<MTL::LogContainer*>(this, _MTL_PRIVATE_SEL(logs));
}

_MTL_INLINE CFTimeInterval MTL::CommandBuffer::GPUStartTime() const
{
    return Object::sendMessage<CFTimeInterval>(this, _MTL_PRIVATE_SEL(GPUStartTime));
}

_MTL_INLINE CFTimeInterval MTL::CommandBuffer::GPUEndTime() const
{
    return Object::sendMessage<CFTimeInterval>(this, _MTL_PRIVATE_SEL(GPUEndTime));
}

_MTL_INLINE void MTL::CommandBuffer::enqueue()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(enqueue));
}

_MTL_INLINE void MTL::CommandBuffer::commit()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(commit));
}

_MTL_INLINE void MTL::CommandBuffer::addScheduledHandler(const MTL::CommandBufferHandler block)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(addScheduledHandler_), block);
}

_MTL_INLINE void MTL::CommandBuffer::presentDrawable(const MTL::Drawable* drawable)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(presentDrawable_), drawable);
}

_MTL_INLINE void MTL::CommandBuffer::presentDrawableAtTime(const MTL::Drawable* drawable, CFTimeInterval presentationTime)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(presentDrawable_atTime_), drawable, presentationTime);
}

_MTL_INLINE void MTL::CommandBuffer::presentDrawableAfterMinimumDuration(const MTL::Drawable* drawable, CFTimeInterval duration)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(presentDrawable_afterMinimumDuration_), drawable, duration);
}

_MTL_INLINE void MTL::CommandBuffer::waitUntilScheduled()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(waitUntilScheduled));
}

_MTL_INLINE void MTL::CommandBuffer::addCompletedHandler(const MTL::CommandBufferHandler block)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(addCompletedHandler_), block);
}

_MTL_INLINE void MTL::CommandBuffer::waitUntilCompleted()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(waitUntilCompleted));
}

_MTL_INLINE MTL::CommandBufferStatus MTL::CommandBuffer::status() const
{
    return Object::sendMessage<MTL::CommandBufferStatus>(this, _MTL_PRIVATE_SEL(status));
}

_MTL_INLINE NS::Error* MTL::CommandBuffer::error() const
{
    return Object::sendMessage<NS::Error*>(this, _MTL_PRIVATE_SEL(error));
}

_MTL_INLINE MTL::BlitCommandEncoder* MTL::CommandBuffer::blitCommandEncoder()
{
    return Object::sendMessage<MTL::BlitCommandEncoder*>(this, _MTL_PRIVATE_SEL(blitCommandEncoder));
}

_MTL_INLINE MTL::RenderCommandEncoder* MTL::CommandBuffer::renderCommandEncoder(const MTL::RenderPassDescriptor* renderPassDescriptor)
{
    return Object::sendMessage<MTL::RenderCommandEncoder*>(this, _MTL_PRIVATE_SEL(renderCommandEncoderWithDescriptor_), renderPassDescriptor);
}

_MTL_INLINE MTL::ComputeCommandEncoder* MTL::CommandBuffer::computeCommandEncoder(const MTL::ComputePassDescriptor* computePassDescriptor)
{
    return Object::sendMessage<MTL::ComputeCommandEncoder*>(this, _MTL_PRIVATE_SEL(computeCommandEncoderWithDescriptor_), computePassDescriptor);
}

_MTL_INLINE MTL::BlitCommandEncoder* MTL::CommandBuffer::blitCommandEncoder(const MTL::BlitPassDescriptor* blitPassDescriptor)
{
    return Object::sendMessage<MTL::BlitCommandEncoder*>(this, _MTL_PRIVATE_SEL(blitCommandEncoderWithDescriptor_), blitPassDescriptor);
}

_MTL_INLINE MTL::ComputeCommandEncoder* MTL::CommandBuffer::computeCommandEncoder()
{
    return Object::sendMessage<MTL::ComputeCommandEncoder*>(this, _MTL_PRIVATE_SEL(computeCommandEncoder));
}

_MTL_INLINE MTL::ComputeCommandEncoder* MTL::CommandBuffer::computeCommandEncoder(MTL::DispatchType dispatchType)
{
    return Object::sendMessage<MTL::ComputeCommandEncoder*>(this, _MTL_PRIVATE_SEL(computeCommandEncoderWithDispatchType_), dispatchType);
}

_MTL_INLINE void MTL::CommandBuffer::encodeWait(const MTL::Event* event, uint64_t value)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(encodeWaitForEvent_value_), event, value);
}

_MTL_INLINE void MTL::CommandBuffer::encodeSignalEvent(const MTL::Event* event, uint64_t value)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(encodeSignalEvent_value_), event, value);
}

_MTL_INLINE MTL::ParallelRenderCommandEncoder* MTL::CommandBuffer::parallelRenderCommandEncoder(const MTL::RenderPassDescriptor* renderPassDescriptor)
{
    return Object::sendMessage<MTL::ParallelRenderCommandEncoder*>(this, _MTL_PRIVATE_SEL(parallelRenderCommandEncoderWithDescriptor_), renderPassDescriptor);
}

_MTL_INLINE MTL::ResourceStateCommandEncoder* MTL::CommandBuffer::resourceStateCommandEncoder()
{
    return Object::sendMessage<MTL::ResourceStateCommandEncoder*>(this, _MTL_PRIVATE_SEL(resourceStateCommandEncoder));
}

_MTL_INLINE MTL::ResourceStateCommandEncoder* MTL::CommandBuffer::resourceStateCommandEncoder(const MTL::ResourceStatePassDescriptor* resourceStatePassDescriptor)
{
    return Object::sendMessage<MTL::ResourceStateCommandEncoder*>(this, _MTL_PRIVATE_SEL(resourceStateCommandEncoderWithDescriptor_), resourceStatePassDescriptor);
}

_MTL_INLINE MTL::AccelerationStructureCommandEncoder* MTL::CommandBuffer::accelerationStructureCommandEncoder()
{
    return Object::sendMessage<MTL::AccelerationStructureCommandEncoder*>(this, _MTL_PRIVATE_SEL(accelerationStructureCommandEncoder));
}

_MTL_INLINE void MTL::CommandBuffer::pushDebugGroup(const NS::String* string)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(pushDebugGroup_), string);
}

_MTL_INLINE void MTL::CommandBuffer::popDebugGroup()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(popDebugGroup));
}

#pragma once

namespace MTL
{
class CommandQueue : public NS::Referencing<CommandQueue>
{
public:
    NS::String*          label() const;
    void                 setLabel(const NS::String* label);

    class Device*        device() const;

    class CommandBuffer* commandBuffer();

    class CommandBuffer* commandBuffer(const class CommandBufferDescriptor* descriptor);

    class CommandBuffer* commandBufferWithUnretainedReferences();

    void                 insertDebugCaptureBoundary();
};

}

_MTL_INLINE NS::String* MTL::CommandQueue::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::CommandQueue::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::Device* MTL::CommandQueue::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE MTL::CommandBuffer* MTL::CommandQueue::commandBuffer()
{
    return Object::sendMessage<MTL::CommandBuffer*>(this, _MTL_PRIVATE_SEL(commandBuffer));
}

_MTL_INLINE MTL::CommandBuffer* MTL::CommandQueue::commandBuffer(const MTL::CommandBufferDescriptor* descriptor)
{
    return Object::sendMessage<MTL::CommandBuffer*>(this, _MTL_PRIVATE_SEL(commandBufferWithDescriptor_), descriptor);
}

_MTL_INLINE MTL::CommandBuffer* MTL::CommandQueue::commandBufferWithUnretainedReferences()
{
    return Object::sendMessage<MTL::CommandBuffer*>(this, _MTL_PRIVATE_SEL(commandBufferWithUnretainedReferences));
}

_MTL_INLINE void MTL::CommandQueue::insertDebugCaptureBoundary()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(insertDebugCaptureBoundary));
}

#pragma once

namespace MTL
{
struct DispatchThreadgroupsIndirectArguments
{
    uint32_t threadgroupsPerGrid[3];
} _MTL_PACKED;

struct StageInRegionIndirectArguments
{
    uint32_t stageInOrigin[3];
    uint32_t stageInSize[3];
} _MTL_PACKED;

class ComputeCommandEncoder : public NS::Referencing<ComputeCommandEncoder, CommandEncoder>
{
public:
    MTL::DispatchType dispatchType() const;

    void              setComputePipelineState(const class ComputePipelineState* state);

    void              setBytes(const void* bytes, NS::UInteger length, NS::UInteger index);

    void              setBuffer(const class Buffer* buffer, NS::UInteger offset, NS::UInteger index);

    void              setBufferOffset(NS::UInteger offset, NS::UInteger index);

    void              setBuffers(MTL::Buffer* buffers[], const NS::UInteger offsets[], NS::Range range);

    void              setVisibleFunctionTable(const class VisibleFunctionTable* visibleFunctionTable, NS::UInteger bufferIndex);

    void              setVisibleFunctionTables(const class VisibleFunctionTable* visibleFunctionTables[], NS::Range range);

    void              setIntersectionFunctionTable(const class IntersectionFunctionTable* intersectionFunctionTable, NS::UInteger bufferIndex);

    void              setIntersectionFunctionTables(const class IntersectionFunctionTable* intersectionFunctionTables[], NS::Range range);

    void              setAccelerationStructure(const class AccelerationStructure* accelerationStructure, NS::UInteger bufferIndex);

    void              setTexture(const class Texture* texture, NS::UInteger index);

    void              setTextures(MTL::Texture* textures[], NS::Range range);

    void              setSamplerState(const class SamplerState* sampler, NS::UInteger index);

    void              setSamplerStates(MTL::SamplerState* samplers[], NS::Range range);

    void              setSamplerState(const class SamplerState* sampler, float lodMinClamp, float lodMaxClamp, NS::UInteger index);

    void              setSamplerStates(MTL::SamplerState* samplers[], const float lodMinClamps[], const float lodMaxClamps[], NS::Range range);

    void              setThreadgroupMemoryLength(NS::UInteger length, NS::UInteger index);

    void              setImageblockWidth(NS::UInteger width, NS::UInteger height);

    void              setStageInRegion(MTL::Region region);

    void              setStageInRegion(const class Buffer* indirectBuffer, NS::UInteger indirectBufferOffset);

    void              dispatchThreadgroups(MTL::Size threadgroupsPerGrid, MTL::Size threadsPerThreadgroup);

    void              dispatchThreadgroups(const class Buffer* indirectBuffer, NS::UInteger indirectBufferOffset, MTL::Size threadsPerThreadgroup);

    void              dispatchThreads(MTL::Size threadsPerGrid, MTL::Size threadsPerThreadgroup);

    void              updateFence(const class Fence* fence);

    void              waitForFence(const class Fence* fence);

    void              useResource(const class Resource* resource, MTL::ResourceUsage usage);

    void              useResources(MTL::Resource* resources[], NS::UInteger count, MTL::ResourceUsage usage);

    void              useHeap(const class Heap* heap);

    void              useHeaps(MTL::Heap* heaps[], NS::UInteger count);

    void              executeCommandsInBuffer(const class IndirectCommandBuffer* indirectCommandBuffer, NS::Range executionRange);

    void              executeCommandsInBuffer(const class IndirectCommandBuffer* indirectCommandbuffer, const class Buffer* indirectRangeBuffer, NS::UInteger indirectBufferOffset);

    void              memoryBarrier(MTL::BarrierScope scope);

    void              memoryBarrier(MTL::Resource* resources[], NS::UInteger count);

    void              sampleCountersInBuffer(const class CounterSampleBuffer* sampleBuffer, NS::UInteger sampleIndex, bool barrier);
};

}

_MTL_INLINE MTL::DispatchType MTL::ComputeCommandEncoder::dispatchType() const
{
    return Object::sendMessage<MTL::DispatchType>(this, _MTL_PRIVATE_SEL(dispatchType));
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setComputePipelineState(const MTL::ComputePipelineState* state)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setComputePipelineState_), state);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setBytes(const void* bytes, NS::UInteger length, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBytes_length_atIndex_), bytes, length, index);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setBuffer(const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBuffer_offset_atIndex_), buffer, offset, index);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setBufferOffset(NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBufferOffset_atIndex_), offset, index);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setBuffers(MTL::Buffer* buffers[], const NS::UInteger offsets[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBuffers_offsets_withRange_), buffers, offsets, range);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setVisibleFunctionTable(const MTL::VisibleFunctionTable* visibleFunctionTable, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVisibleFunctionTable_atBufferIndex_), visibleFunctionTable, bufferIndex);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setVisibleFunctionTables(const MTL::VisibleFunctionTable* visibleFunctionTables[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVisibleFunctionTables_withBufferRange_), visibleFunctionTables, range);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setIntersectionFunctionTable(const MTL::IntersectionFunctionTable* intersectionFunctionTable, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIntersectionFunctionTable_atBufferIndex_), intersectionFunctionTable, bufferIndex);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setIntersectionFunctionTables(const MTL::IntersectionFunctionTable* intersectionFunctionTables[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIntersectionFunctionTables_withBufferRange_), intersectionFunctionTables, range);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setAccelerationStructure(const MTL::AccelerationStructure* accelerationStructure, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setAccelerationStructure_atBufferIndex_), accelerationStructure, bufferIndex);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setTexture(const MTL::Texture* texture, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTexture_atIndex_), texture, index);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setTextures(MTL::Texture* textures[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTextures_withRange_), textures, range);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setSamplerState(const MTL::SamplerState* sampler, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSamplerState_atIndex_), sampler, index);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setSamplerStates(MTL::SamplerState* samplers[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSamplerStates_withRange_), samplers, range);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setSamplerState(const MTL::SamplerState* sampler, float lodMinClamp, float lodMaxClamp, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSamplerState_lodMinClamp_lodMaxClamp_atIndex_), sampler, lodMinClamp, lodMaxClamp, index);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setSamplerStates(MTL::SamplerState* samplers[], const float lodMinClamps[], const float lodMaxClamps[], NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSamplerStates_lodMinClamps_lodMaxClamps_withRange_), samplers, lodMinClamps, lodMaxClamps, range);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setThreadgroupMemoryLength(NS::UInteger length, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setThreadgroupMemoryLength_atIndex_), length, index);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setImageblockWidth(NS::UInteger width, NS::UInteger height)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setImageblockWidth_height_), width, height);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setStageInRegion(MTL::Region region)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStageInRegion_), region);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::setStageInRegion(const MTL::Buffer* indirectBuffer, NS::UInteger indirectBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStageInRegionWithIndirectBuffer_indirectBufferOffset_), indirectBuffer, indirectBufferOffset);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::dispatchThreadgroups(MTL::Size threadgroupsPerGrid, MTL::Size threadsPerThreadgroup)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(dispatchThreadgroups_threadsPerThreadgroup_), threadgroupsPerGrid, threadsPerThreadgroup);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::dispatchThreadgroups(const MTL::Buffer* indirectBuffer, NS::UInteger indirectBufferOffset, MTL::Size threadsPerThreadgroup)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(dispatchThreadgroupsWithIndirectBuffer_indirectBufferOffset_threadsPerThreadgroup_), indirectBuffer, indirectBufferOffset, threadsPerThreadgroup);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::dispatchThreads(MTL::Size threadsPerGrid, MTL::Size threadsPerThreadgroup)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(dispatchThreads_threadsPerThreadgroup_), threadsPerGrid, threadsPerThreadgroup);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::updateFence(const MTL::Fence* fence)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(updateFence_), fence);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::waitForFence(const MTL::Fence* fence)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(waitForFence_), fence);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::useResource(const MTL::Resource* resource, MTL::ResourceUsage usage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useResource_usage_), resource, usage);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::useResources(MTL::Resource* resources[], NS::UInteger count, MTL::ResourceUsage usage)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useResources_count_usage_), resources, count, usage);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::useHeap(const MTL::Heap* heap)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useHeap_), heap);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::useHeaps(MTL::Heap* heaps[], NS::UInteger count)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(useHeaps_count_), heaps, count);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::executeCommandsInBuffer(const MTL::IndirectCommandBuffer* indirectCommandBuffer, NS::Range executionRange)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(executeCommandsInBuffer_withRange_), indirectCommandBuffer, executionRange);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::executeCommandsInBuffer(const MTL::IndirectCommandBuffer* indirectCommandbuffer, const MTL::Buffer* indirectRangeBuffer, NS::UInteger indirectBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(executeCommandsInBuffer_indirectBuffer_indirectBufferOffset_), indirectCommandbuffer, indirectRangeBuffer, indirectBufferOffset);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::memoryBarrier(MTL::BarrierScope scope)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(memoryBarrierWithScope_), scope);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::memoryBarrier(MTL::Resource* resources[], NS::UInteger count)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(memoryBarrierWithResources_count_), resources, count);
}

_MTL_INLINE void MTL::ComputeCommandEncoder::sampleCountersInBuffer(const MTL::CounterSampleBuffer* sampleBuffer, NS::UInteger sampleIndex, bool barrier)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(sampleCountersInBuffer_atSampleIndex_withBarrier_), sampleBuffer, sampleIndex, barrier);
}

#pragma once

namespace MTL
{
class ComputePassSampleBufferAttachmentDescriptor : public NS::Copying<ComputePassSampleBufferAttachmentDescriptor>
{
public:
    static class ComputePassSampleBufferAttachmentDescriptor* alloc();

    class ComputePassSampleBufferAttachmentDescriptor*        init();

    class CounterSampleBuffer*                                sampleBuffer() const;
    void                                                      setSampleBuffer(const class CounterSampleBuffer* sampleBuffer);

    NS::UInteger                                              startOfEncoderSampleIndex() const;
    void                                                      setStartOfEncoderSampleIndex(NS::UInteger startOfEncoderSampleIndex);

    NS::UInteger                                              endOfEncoderSampleIndex() const;
    void                                                      setEndOfEncoderSampleIndex(NS::UInteger endOfEncoderSampleIndex);
};

class ComputePassSampleBufferAttachmentDescriptorArray : public NS::Referencing<ComputePassSampleBufferAttachmentDescriptorArray>
{
public:
    static class ComputePassSampleBufferAttachmentDescriptorArray* alloc();

    class ComputePassSampleBufferAttachmentDescriptorArray*        init();

    class ComputePassSampleBufferAttachmentDescriptor*             object(NS::UInteger attachmentIndex);

    void                                                           setObject(const class ComputePassSampleBufferAttachmentDescriptor* attachment, NS::UInteger attachmentIndex);
};

class ComputePassDescriptor : public NS::Copying<ComputePassDescriptor>
{
public:
    static class ComputePassDescriptor*                     alloc();

    class ComputePassDescriptor*                            init();

    static class ComputePassDescriptor*                     computePassDescriptor();

    MTL::DispatchType                                       dispatchType() const;
    void                                                    setDispatchType(MTL::DispatchType dispatchType);

    class ComputePassSampleBufferAttachmentDescriptorArray* sampleBufferAttachments() const;
};

}

_MTL_INLINE MTL::ComputePassSampleBufferAttachmentDescriptor* MTL::ComputePassSampleBufferAttachmentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::ComputePassSampleBufferAttachmentDescriptor>(_MTL_PRIVATE_CLS(MTLComputePassSampleBufferAttachmentDescriptor));
}

_MTL_INLINE MTL::ComputePassSampleBufferAttachmentDescriptor* MTL::ComputePassSampleBufferAttachmentDescriptor::init()
{
    return NS::Object::init<MTL::ComputePassSampleBufferAttachmentDescriptor>();
}

_MTL_INLINE MTL::CounterSampleBuffer* MTL::ComputePassSampleBufferAttachmentDescriptor::sampleBuffer() const
{
    return Object::sendMessage<MTL::CounterSampleBuffer*>(this, _MTL_PRIVATE_SEL(sampleBuffer));
}

_MTL_INLINE void MTL::ComputePassSampleBufferAttachmentDescriptor::setSampleBuffer(const MTL::CounterSampleBuffer* sampleBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSampleBuffer_), sampleBuffer);
}

_MTL_INLINE NS::UInteger MTL::ComputePassSampleBufferAttachmentDescriptor::startOfEncoderSampleIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(startOfEncoderSampleIndex));
}

_MTL_INLINE void MTL::ComputePassSampleBufferAttachmentDescriptor::setStartOfEncoderSampleIndex(NS::UInteger startOfEncoderSampleIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStartOfEncoderSampleIndex_), startOfEncoderSampleIndex);
}

_MTL_INLINE NS::UInteger MTL::ComputePassSampleBufferAttachmentDescriptor::endOfEncoderSampleIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(endOfEncoderSampleIndex));
}

_MTL_INLINE void MTL::ComputePassSampleBufferAttachmentDescriptor::setEndOfEncoderSampleIndex(NS::UInteger endOfEncoderSampleIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setEndOfEncoderSampleIndex_), endOfEncoderSampleIndex);
}

_MTL_INLINE MTL::ComputePassSampleBufferAttachmentDescriptorArray* MTL::ComputePassSampleBufferAttachmentDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::ComputePassSampleBufferAttachmentDescriptorArray>(_MTL_PRIVATE_CLS(MTLComputePassSampleBufferAttachmentDescriptorArray));
}

_MTL_INLINE MTL::ComputePassSampleBufferAttachmentDescriptorArray* MTL::ComputePassSampleBufferAttachmentDescriptorArray::init()
{
    return NS::Object::init<MTL::ComputePassSampleBufferAttachmentDescriptorArray>();
}

_MTL_INLINE MTL::ComputePassSampleBufferAttachmentDescriptor* MTL::ComputePassSampleBufferAttachmentDescriptorArray::object(NS::UInteger attachmentIndex)
{
    return Object::sendMessage<MTL::ComputePassSampleBufferAttachmentDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), attachmentIndex);
}

_MTL_INLINE void MTL::ComputePassSampleBufferAttachmentDescriptorArray::setObject(const MTL::ComputePassSampleBufferAttachmentDescriptor* attachment, NS::UInteger attachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), attachment, attachmentIndex);
}

_MTL_INLINE MTL::ComputePassDescriptor* MTL::ComputePassDescriptor::alloc()
{
    return NS::Object::alloc<MTL::ComputePassDescriptor>(_MTL_PRIVATE_CLS(MTLComputePassDescriptor));
}

_MTL_INLINE MTL::ComputePassDescriptor* MTL::ComputePassDescriptor::init()
{
    return NS::Object::init<MTL::ComputePassDescriptor>();
}

_MTL_INLINE MTL::ComputePassDescriptor* MTL::ComputePassDescriptor::computePassDescriptor()
{
    return Object::sendMessage<MTL::ComputePassDescriptor*>(_MTL_PRIVATE_CLS(MTLComputePassDescriptor), _MTL_PRIVATE_SEL(computePassDescriptor));
}

_MTL_INLINE MTL::DispatchType MTL::ComputePassDescriptor::dispatchType() const
{
    return Object::sendMessage<MTL::DispatchType>(this, _MTL_PRIVATE_SEL(dispatchType));
}

_MTL_INLINE void MTL::ComputePassDescriptor::setDispatchType(MTL::DispatchType dispatchType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDispatchType_), dispatchType);
}

_MTL_INLINE MTL::ComputePassSampleBufferAttachmentDescriptorArray* MTL::ComputePassDescriptor::sampleBufferAttachments() const
{
    return Object::sendMessage<MTL::ComputePassSampleBufferAttachmentDescriptorArray*>(this, _MTL_PRIVATE_SEL(sampleBufferAttachments));
}

#pragma once

namespace MTL
{

_MTL_CONST( NS::ErrorDomain, CounterErrorDomain );

using CommonCounter = NS::String*;

_MTL_CONST( CommonCounter, CommonCounterTimestamp );
_MTL_CONST( CommonCounter, CommonCounterTessellationInputPatches );
_MTL_CONST( CommonCounter, CommonCounterVertexInvocations );
_MTL_CONST( CommonCounter, CommonCounterPostTessellationVertexInvocations );
_MTL_CONST( CommonCounter, CommonCounterClipperInvocations );
_MTL_CONST( CommonCounter, CommonCounterClipperPrimitivesOut );
_MTL_CONST( CommonCounter, CommonCounterFragmentInvocations );
_MTL_CONST( CommonCounter, CommonCounterFragmentsPassed );
_MTL_CONST( CommonCounter, CommonCounterComputeKernelInvocations );
_MTL_CONST( CommonCounter, CommonCounterTotalCycles );
_MTL_CONST( CommonCounter, CommonCounterVertexCycles );
_MTL_CONST( CommonCounter, CommonCounterTessellationCycles );
_MTL_CONST( CommonCounter, CommonCounterPostTessellationVertexCycles );
_MTL_CONST( CommonCounter, CommonCounterFragmentCycles );
_MTL_CONST( CommonCounter, CommonCounterRenderTargetWriteCycles );

using CommonCounterSet = NS::String*;

_MTL_CONST( CommonCounterSet, CommonCounterSetTimestamp );
_MTL_CONST( CommonCounterSet, CommonCounterSetStageUtilization );
_MTL_CONST( CommonCounterSet, CommonCounterSetStatistic );

struct CounterResultTimestamp
{
    uint64_t timestamp;
} _MTL_PACKED;

struct CounterResultStageUtilization
{
    uint64_t totalCycles;
    uint64_t vertexCycles;
    uint64_t tessellationCycles;
    uint64_t postTessellationVertexCycles;
    uint64_t fragmentCycles;
    uint64_t renderTargetCycles;
} _MTL_PACKED;

struct CounterResultStatistic
{
    uint64_t tessellationInputPatches;
    uint64_t vertexInvocations;
    uint64_t postTessellationVertexInvocations;
    uint64_t clipperInvocations;
    uint64_t clipperPrimitivesOut;
    uint64_t fragmentInvocations;
    uint64_t fragmentsPassed;
    uint64_t computeKernelInvocations;
} _MTL_PACKED;

class Counter : public NS::Referencing<Counter>
{
public:
    NS::String* name() const;
};

class CounterSet : public NS::Referencing<CounterSet>
{
public:
    NS::String* name() const;

    NS::Array*  counters() const;
};

class CounterSampleBufferDescriptor : public NS::Copying<CounterSampleBufferDescriptor>
{
public:
    static class CounterSampleBufferDescriptor* alloc();

    class CounterSampleBufferDescriptor*        init();

    class CounterSet*                           counterSet() const;
    void                                        setCounterSet(const class CounterSet* counterSet);

    NS::String*                                 label() const;
    void                                        setLabel(const NS::String* label);

    MTL::StorageMode                            storageMode() const;
    void                                        setStorageMode(MTL::StorageMode storageMode);

    NS::UInteger                                sampleCount() const;
    void                                        setSampleCount(NS::UInteger sampleCount);
};

class CounterSampleBuffer : public NS::Referencing<CounterSampleBuffer>
{
public:
    class Device* device() const;

    NS::String*   label() const;

    NS::UInteger  sampleCount() const;

    NS::Data*     resolveCounterRange(NS::Range range);
};

_MTL_ENUM(NS::Integer, CounterSampleBufferError) {
    CounterSampleBufferErrorOutOfMemory = 0,
    CounterSampleBufferErrorInvalid = 1,
};

}

_MTL_PRIVATE_DEF_STR( NS::ErrorDomain, CounterErrorDomain );

_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterTimestamp );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterTessellationInputPatches );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterVertexInvocations );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterPostTessellationVertexInvocations );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterClipperInvocations );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterClipperPrimitivesOut );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterFragmentInvocations );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterFragmentsPassed );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterComputeKernelInvocations );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterTotalCycles );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterVertexCycles );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterTessellationCycles );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterPostTessellationVertexCycles );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterFragmentCycles );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounter, CommonCounterRenderTargetWriteCycles );

_MTL_PRIVATE_DEF_STR( MTL::CommonCounterSet, CommonCounterSetTimestamp );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounterSet, CommonCounterSetStageUtilization );
_MTL_PRIVATE_DEF_STR( MTL::CommonCounterSet, CommonCounterSetStatistic );

_MTL_INLINE NS::String* MTL::Counter::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE NS::String* MTL::CounterSet::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE NS::Array* MTL::CounterSet::counters() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(counters));
}

_MTL_INLINE MTL::CounterSampleBufferDescriptor* MTL::CounterSampleBufferDescriptor::alloc()
{
    return NS::Object::alloc<MTL::CounterSampleBufferDescriptor>(_MTL_PRIVATE_CLS(MTLCounterSampleBufferDescriptor));
}

_MTL_INLINE MTL::CounterSampleBufferDescriptor* MTL::CounterSampleBufferDescriptor::init()
{
    return NS::Object::init<MTL::CounterSampleBufferDescriptor>();
}

_MTL_INLINE MTL::CounterSet* MTL::CounterSampleBufferDescriptor::counterSet() const
{
    return Object::sendMessage<MTL::CounterSet*>(this, _MTL_PRIVATE_SEL(counterSet));
}

_MTL_INLINE void MTL::CounterSampleBufferDescriptor::setCounterSet(const MTL::CounterSet* counterSet)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setCounterSet_), counterSet);
}

_MTL_INLINE NS::String* MTL::CounterSampleBufferDescriptor::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::CounterSampleBufferDescriptor::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::StorageMode MTL::CounterSampleBufferDescriptor::storageMode() const
{
    return Object::sendMessage<MTL::StorageMode>(this, _MTL_PRIVATE_SEL(storageMode));
}

_MTL_INLINE void MTL::CounterSampleBufferDescriptor::setStorageMode(MTL::StorageMode storageMode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStorageMode_), storageMode);
}

_MTL_INLINE NS::UInteger MTL::CounterSampleBufferDescriptor::sampleCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(sampleCount));
}

_MTL_INLINE void MTL::CounterSampleBufferDescriptor::setSampleCount(NS::UInteger sampleCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSampleCount_), sampleCount);
}

_MTL_INLINE MTL::Device* MTL::CounterSampleBuffer::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::String* MTL::CounterSampleBuffer::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE NS::UInteger MTL::CounterSampleBuffer::sampleCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(sampleCount));
}

_MTL_INLINE NS::Data* MTL::CounterSampleBuffer::resolveCounterRange(NS::Range range)
{
    return Object::sendMessage<NS::Data*>(this, _MTL_PRIVATE_SEL(resolveCounterRange_), range);
}

#pragma once

#include <IOSurface/IOSurfaceRef.h>
#include <functional>

namespace MTL
{
_MTL_ENUM(NS::UInteger, FeatureSet) {
    FeatureSet_iOS_GPUFamily1_v1 = 0,
    FeatureSet_iOS_GPUFamily2_v1 = 1,
    FeatureSet_iOS_GPUFamily1_v2 = 2,
    FeatureSet_iOS_GPUFamily2_v2 = 3,
    FeatureSet_iOS_GPUFamily3_v1 = 4,
    FeatureSet_iOS_GPUFamily1_v3 = 5,
    FeatureSet_iOS_GPUFamily2_v3 = 6,
    FeatureSet_iOS_GPUFamily3_v2 = 7,
    FeatureSet_iOS_GPUFamily1_v4 = 8,
    FeatureSet_iOS_GPUFamily2_v4 = 9,
    FeatureSet_iOS_GPUFamily3_v3 = 10,
    FeatureSet_iOS_GPUFamily4_v1 = 11,
    FeatureSet_iOS_GPUFamily1_v5 = 12,
    FeatureSet_iOS_GPUFamily2_v5 = 13,
    FeatureSet_iOS_GPUFamily3_v4 = 14,
    FeatureSet_iOS_GPUFamily4_v2 = 15,
    FeatureSet_iOS_GPUFamily5_v1 = 16,
    FeatureSet_macOS_GPUFamily1_v1 = 10000,
    FeatureSet_OSX_GPUFamily1_v1 = 10000,
    FeatureSet_macOS_GPUFamily1_v2 = 10001,
    FeatureSet_OSX_GPUFamily1_v2 = 10001,
    FeatureSet_OSX_ReadWriteTextureTier2 = 10002,
    FeatureSet_macOS_ReadWriteTextureTier2 = 10002,
    FeatureSet_macOS_GPUFamily1_v3 = 10003,
    FeatureSet_macOS_GPUFamily1_v4 = 10004,
    FeatureSet_macOS_GPUFamily2_v1 = 10005,
    FeatureSet_watchOS_GPUFamily1_v1 = 20000,
    FeatureSet_WatchOS_GPUFamily1_v1 = 20000,
    FeatureSet_watchOS_GPUFamily2_v1 = 20001,
    FeatureSet_WatchOS_GPUFamily2_v1 = 20001,
    FeatureSet_tvOS_GPUFamily1_v1 = 30000,
    FeatureSet_TVOS_GPUFamily1_v1 = 30000,
    FeatureSet_tvOS_GPUFamily1_v2 = 30001,
    FeatureSet_tvOS_GPUFamily1_v3 = 30002,
    FeatureSet_tvOS_GPUFamily2_v1 = 30003,
    FeatureSet_tvOS_GPUFamily1_v4 = 30004,
    FeatureSet_tvOS_GPUFamily2_v2 = 30005,
};

_MTL_ENUM(NS::Integer, GPUFamily) {
    GPUFamilyApple1 = 1001,
    GPUFamilyApple2 = 1002,
    GPUFamilyApple3 = 1003,
    GPUFamilyApple4 = 1004,
    GPUFamilyApple5 = 1005,
    GPUFamilyApple6 = 1006,
    GPUFamilyApple7 = 1007,
    GPUFamilyApple8 = 1008,
    GPUFamilyMac1 = 2001,
    GPUFamilyMac2 = 2002,
    GPUFamilyCommon1 = 3001,
    GPUFamilyCommon2 = 3002,
    GPUFamilyCommon3 = 3003,
    GPUFamilyMacCatalyst1 = 4001,
    GPUFamilyMacCatalyst2 = 4002,
};

_MTL_ENUM(NS::UInteger, DeviceLocation) {
    DeviceLocationBuiltIn = 0,
    DeviceLocationSlot = 1,
    DeviceLocationExternal = 2,
    DeviceLocationUnspecified = NS::UIntegerMax,
};

_MTL_OPTIONS(NS::UInteger, PipelineOption) {
    PipelineOptionNone = 0,
    PipelineOptionArgumentInfo = 1,
    PipelineOptionBufferTypeInfo = 2,
    PipelineOptionFailOnBinaryArchiveMiss = 4,
};

_MTL_ENUM(NS::UInteger, ReadWriteTextureTier) {
    ReadWriteTextureTierNone = 0,
    ReadWriteTextureTier1 = 1,
    ReadWriteTextureTier2 = 2,
};

_MTL_ENUM(NS::UInteger, ArgumentBuffersTier) {
    ArgumentBuffersTier1 = 0,
    ArgumentBuffersTier2 = 1,
};

_MTL_ENUM(NS::UInteger, SparseTextureRegionAlignmentMode) {
    SparseTextureRegionAlignmentModeOutward = 0,
    SparseTextureRegionAlignmentModeInward = 1,
};

struct AccelerationStructureSizes
{
    NS::UInteger accelerationStructureSize;
    NS::UInteger buildScratchBufferSize;
    NS::UInteger refitScratchBufferSize;
} _MTL_PACKED;

_MTL_ENUM(NS::UInteger, CounterSamplingPoint) {
    CounterSamplingPointAtStageBoundary = 0,
    CounterSamplingPointAtDrawBoundary = 1,
    CounterSamplingPointAtDispatchBoundary = 2,
    CounterSamplingPointAtTileDispatchBoundary = 3,
    CounterSamplingPointAtBlitBoundary = 4,
};

struct SizeAndAlign
{
    NS::UInteger size;
    NS::UInteger align;
} _MTL_PACKED;

class ArgumentDescriptor : public NS::Copying<ArgumentDescriptor>
{
public:
    static class ArgumentDescriptor* alloc();

    class ArgumentDescriptor*        init();

    static class ArgumentDescriptor* argumentDescriptor();

    MTL::DataType                    dataType() const;
    void                             setDataType(MTL::DataType dataType);

    NS::UInteger                     index() const;
    void                             setIndex(NS::UInteger index);

    NS::UInteger                     arrayLength() const;
    void                             setArrayLength(NS::UInteger arrayLength);

    MTL::ArgumentAccess              access() const;
    void                             setAccess(MTL::ArgumentAccess access);

    MTL::TextureType                 textureType() const;
    void                             setTextureType(MTL::TextureType textureType);

    NS::UInteger                     constantBlockAlignment() const;
    void                             setConstantBlockAlignment(NS::UInteger constantBlockAlignment);
};

using DeviceNotificationName = NS::String*;

_MTL_CONST(DeviceNotificationName, DeviceWasAddedNotification);

_MTL_CONST(DeviceNotificationName, DeviceRemovalRequestedNotification);

_MTL_CONST(DeviceNotificationName, DeviceWasRemovedNotification);

using DeviceNotificationHandlerBlock = void (^)(class Device* pDevice, DeviceNotificationName notifyName);

using DeviceNotificationHandlerFunction = std::function<void(class Device* pDevice, DeviceNotificationName notifyName)>;

using AutoreleasedComputePipelineReflection = class ComputePipelineReflection*;

using AutoreleasedRenderPipelineReflection = class RenderPipelineReflection*;

using NewLibraryCompletionHandler = void (^)(class Library*, NS::Error*);

using NewLibraryCompletionHandlerFunction = std::function<void(class Library*, NS::Error*)>;

using NewRenderPipelineStateCompletionHandler = void (^)(class RenderPipelineState*, NS::Error*);

using NewRenderPipelineStateCompletionHandlerFunction = std::function<void(class RenderPipelineState*, NS::Error*)>;

using NewRenderPipelineStateWithReflectionCompletionHandler = void (^)(class RenderPipelineState*, class RenderPipelineReflection*, NS::Error*);

using NewRenderPipelineStateWithReflectionCompletionHandlerFunction = std::function<void(class RenderPipelineState*, class RenderPipelineReflection*, NS::Error*)>;

using NewComputePipelineStateCompletionHandler = void (^)(class ComputePipelineState*, NS::Error*);

using NewComputePipelineStateCompletionHandlerFunction = std::function<void(class ComputePipelineState*, NS::Error*)>;

using NewComputePipelineStateWithReflectionCompletionHandler = void (^)(class ComputePipelineState*, class ComputePipelineReflection*, NS::Error*);

using NewComputePipelineStateWithReflectionCompletionHandlerFunction = std::function<void(class ComputePipelineState*, class ComputePipelineReflection*, NS::Error*)>;

using Timestamp = std::uint64_t;

MTL::Device* CreateSystemDefaultDevice();

NS::Array*   CopyAllDevices();

NS::Array*   CopyAllDevicesWithObserver(NS::Object** pOutObserver, DeviceNotificationHandlerBlock handler);

NS::Array*   CopyAllDevicesWithObserver(NS::Object** pOutObserver, const DeviceNotificationHandlerFunction& handler);

void         RemoveDeviceObserver(const NS::Object* pObserver);

class Device : public NS::Referencing<Device>
{
public:
    void                            newLibrary(const NS::String* pSource, const class CompileOptions* pOptions, const NewLibraryCompletionHandlerFunction& completionHandler);

    void                            newLibrary(const class StitchedLibraryDescriptor* pDescriptor, const MTL::NewLibraryCompletionHandlerFunction& completionHandler);

    void                            newRenderPipelineState(const class RenderPipelineDescriptor* pDescriptor, const NewRenderPipelineStateCompletionHandlerFunction& completionHandler);

    void                            newRenderPipelineState(const class RenderPipelineDescriptor* pDescriptor, PipelineOption options, const NewRenderPipelineStateWithReflectionCompletionHandlerFunction& completionHandler);

    void                            newRenderPipelineState(const class TileRenderPipelineDescriptor* pDescriptor, PipelineOption options, const NewRenderPipelineStateWithReflectionCompletionHandlerFunction& completionHandler);

    void                            newComputePipelineState(const class Function* pFunction, const NewComputePipelineStateCompletionHandlerFunction& completionHandler);

    void                            newComputePipelineState(const class Function* pFunction, PipelineOption options, const NewComputePipelineStateWithReflectionCompletionHandlerFunction& completionHandler);

    void                            newComputePipelineState(const class ComputePipelineDescriptor* pDescriptor, PipelineOption options, const NewComputePipelineStateWithReflectionCompletionHandlerFunction& completionHandler);

    bool                            isHeadless() const;

    NS::String*                     name() const;

    uint64_t                        registryID() const;

    MTL::Size                       maxThreadsPerThreadgroup() const;

    bool                            lowPower() const;

    bool                            headless() const;

    bool                            removable() const;

    bool                            hasUnifiedMemory() const;

    uint64_t                        recommendedMaxWorkingSetSize() const;

    MTL::DeviceLocation             location() const;

    NS::UInteger                    locationNumber() const;

    uint64_t                        maxTransferRate() const;

    bool                            depth24Stencil8PixelFormatSupported() const;

    MTL::ReadWriteTextureTier       readWriteTextureSupport() const;

    MTL::ArgumentBuffersTier        argumentBuffersSupport() const;

    bool                            rasterOrderGroupsSupported() const;

    bool                            supports32BitFloatFiltering() const;

    bool                            supports32BitMSAA() const;

    bool                            supportsQueryTextureLOD() const;

    bool                            supportsBCTextureCompression() const;

    bool                            supportsPullModelInterpolation() const;

    bool                            barycentricCoordsSupported() const;

    bool                            supportsShaderBarycentricCoordinates() const;

    NS::UInteger                    currentAllocatedSize() const;

    class CommandQueue*             newCommandQueue();

    class CommandQueue*             newCommandQueue(NS::UInteger maxCommandBufferCount);

    MTL::SizeAndAlign               heapTextureSizeAndAlign(const class TextureDescriptor* desc);

    MTL::SizeAndAlign               heapBufferSizeAndAlign(NS::UInteger length, MTL::ResourceOptions options);

    class Heap*                     newHeap(const class HeapDescriptor* descriptor);

    class Buffer*                   newBuffer(NS::UInteger length, MTL::ResourceOptions options);

    class Buffer*                   newBuffer(const void* pointer, NS::UInteger length, MTL::ResourceOptions options);

    class Buffer*                   newBuffer(const void* pointer, NS::UInteger length, MTL::ResourceOptions options, void (^deallocator)(void*, NS::UInteger));

    class DepthStencilState*        newDepthStencilState(const class DepthStencilDescriptor* descriptor);

    class Texture*                  newTexture(const class TextureDescriptor* descriptor);

    class Texture*                  newTexture(const class TextureDescriptor* descriptor, const IOSurfaceRef iosurface, NS::UInteger plane);

    class Texture*                  newSharedTexture(const class TextureDescriptor* descriptor);

    class Texture*                  newSharedTexture(const class SharedTextureHandle* sharedHandle);

    class SamplerState*             newSamplerState(const class SamplerDescriptor* descriptor);

    class Library*                  newDefaultLibrary();

    class Library*                  newDefaultLibrary(const NS::Bundle* bundle, NS::Error** error);

    class Library*                  newLibrary(const NS::String* filepath, NS::Error** error);

    class Library*                  newLibrary(const NS::URL* url, NS::Error** error);

    class Library*                  newLibrary(const dispatch_data_t data, NS::Error** error);

    class Library*                  newLibrary(const NS::String* source, const class CompileOptions* options, NS::Error** error);

    void                            newLibrary(const NS::String* source, const class CompileOptions* options, const MTL::NewLibraryCompletionHandler completionHandler);

    class Library*                  newLibrary(const class StitchedLibraryDescriptor* descriptor, NS::Error** error);

    void                            newLibrary(const class StitchedLibraryDescriptor* descriptor, const MTL::NewLibraryCompletionHandler completionHandler);

    class RenderPipelineState*      newRenderPipelineState(const class RenderPipelineDescriptor* descriptor, NS::Error** error);

    class RenderPipelineState*      newRenderPipelineState(const class RenderPipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::AutoreleasedRenderPipelineReflection* reflection, NS::Error** error);

    void                            newRenderPipelineState(const class RenderPipelineDescriptor* descriptor, const MTL::NewRenderPipelineStateCompletionHandler completionHandler);

    void                            newRenderPipelineState(const class RenderPipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::NewRenderPipelineStateWithReflectionCompletionHandler completionHandler);

    class ComputePipelineState*     newComputePipelineState(const class Function* computeFunction, NS::Error** error);

    class ComputePipelineState*     newComputePipelineState(const class Function* computeFunction, MTL::PipelineOption options, const MTL::AutoreleasedComputePipelineReflection* reflection, NS::Error** error);

    void                            newComputePipelineState(const class Function* computeFunction, const MTL::NewComputePipelineStateCompletionHandler completionHandler);

    void                            newComputePipelineState(const class Function* computeFunction, MTL::PipelineOption options, const MTL::NewComputePipelineStateWithReflectionCompletionHandler completionHandler);

    class ComputePipelineState*     newComputePipelineState(const class ComputePipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::AutoreleasedComputePipelineReflection* reflection, NS::Error** error);

    void                            newComputePipelineState(const class ComputePipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::NewComputePipelineStateWithReflectionCompletionHandler completionHandler);

    class Fence*                    newFence();

    bool                            supportsFeatureSet(MTL::FeatureSet featureSet);

    bool                            supportsFamily(MTL::GPUFamily gpuFamily);

    bool                            supportsTextureSampleCount(NS::UInteger sampleCount);

    NS::UInteger                    minimumLinearTextureAlignmentForPixelFormat(MTL::PixelFormat format);

    NS::UInteger                    minimumTextureBufferAlignmentForPixelFormat(MTL::PixelFormat format);

    class RenderPipelineState*      newRenderPipelineState(const class TileRenderPipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::AutoreleasedRenderPipelineReflection* reflection, NS::Error** error);

    void                            newRenderPipelineState(const class TileRenderPipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::NewRenderPipelineStateWithReflectionCompletionHandler completionHandler);

    NS::UInteger                    maxThreadgroupMemoryLength() const;

    NS::UInteger                    maxArgumentBufferSamplerCount() const;

    bool                            programmableSamplePositionsSupported() const;

    void                            getDefaultSamplePositions(MTL::SamplePosition* positions, NS::UInteger count);

    class ArgumentEncoder*          newArgumentEncoder(const NS::Array* arguments);

    bool                            supportsRasterizationRateMap(NS::UInteger layerCount);

    class RasterizationRateMap*     newRasterizationRateMap(const class RasterizationRateMapDescriptor* descriptor);

    class IndirectCommandBuffer*    newIndirectCommandBuffer(const class IndirectCommandBufferDescriptor* descriptor, NS::UInteger maxCount, MTL::ResourceOptions options);

    class Event*                    newEvent();

    class SharedEvent*              newSharedEvent();

    class SharedEvent*              newSharedEvent(const class SharedEventHandle* sharedEventHandle);

    uint64_t                        peerGroupID() const;

    uint32_t                        peerIndex() const;

    uint32_t                        peerCount() const;

    MTL::Size                       sparseTileSize(MTL::TextureType textureType, MTL::PixelFormat pixelFormat, NS::UInteger sampleCount);

    NS::UInteger                    sparseTileSizeInBytes() const;

    void                            convertSparsePixelRegions(const MTL::Region* pixelRegions, MTL::Region* tileRegions, MTL::Size tileSize, MTL::SparseTextureRegionAlignmentMode mode, NS::UInteger numRegions);

    void                            convertSparseTileRegions(const MTL::Region* tileRegions, MTL::Region* pixelRegions, MTL::Size tileSize, NS::UInteger numRegions);

    NS::UInteger                    maxBufferLength() const;

    NS::Array*                      counterSets() const;

    class CounterSampleBuffer*      newCounterSampleBuffer(const class CounterSampleBufferDescriptor* descriptor, NS::Error** error);

    void                            sampleTimestamps(MTL::Timestamp* cpuTimestamp, MTL::Timestamp* gpuTimestamp);

    bool                            supportsCounterSampling(MTL::CounterSamplingPoint samplingPoint);

    bool                            supportsVertexAmplificationCount(NS::UInteger count);

    bool                            supportsDynamicLibraries() const;

    bool                            supportsRenderDynamicLibraries() const;

    class DynamicLibrary*           newDynamicLibrary(const class Library* library, NS::Error** error);

    class DynamicLibrary*           newDynamicLibrary(const NS::URL* url, NS::Error** error);

    class BinaryArchive*            newBinaryArchive(const class BinaryArchiveDescriptor* descriptor, NS::Error** error);

    bool                            supportsRaytracing() const;

    MTL::AccelerationStructureSizes accelerationStructureSizes(const class AccelerationStructureDescriptor* descriptor);

    class AccelerationStructure*    newAccelerationStructure(NS::UInteger size);

    class AccelerationStructure*    newAccelerationStructure(const class AccelerationStructureDescriptor* descriptor);

    bool                            supportsFunctionPointers() const;

    bool                            supportsFunctionPointersFromRender() const;

    bool                            supportsRaytracingFromRender() const;

    bool                            supportsPrimitiveMotionBlur() const;
};

}

_MTL_INLINE MTL::ArgumentDescriptor* MTL::ArgumentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::ArgumentDescriptor>(_MTL_PRIVATE_CLS(MTLArgumentDescriptor));
}

_MTL_INLINE MTL::ArgumentDescriptor* MTL::ArgumentDescriptor::init()
{
    return NS::Object::init<MTL::ArgumentDescriptor>();
}

_MTL_INLINE MTL::ArgumentDescriptor* MTL::ArgumentDescriptor::argumentDescriptor()
{
    return Object::sendMessage<MTL::ArgumentDescriptor*>(_MTL_PRIVATE_CLS(MTLArgumentDescriptor), _MTL_PRIVATE_SEL(argumentDescriptor));
}

_MTL_INLINE MTL::DataType MTL::ArgumentDescriptor::dataType() const
{
    return Object::sendMessage<MTL::DataType>(this, _MTL_PRIVATE_SEL(dataType));
}

_MTL_INLINE void MTL::ArgumentDescriptor::setDataType(MTL::DataType dataType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDataType_), dataType);
}

_MTL_INLINE NS::UInteger MTL::ArgumentDescriptor::index() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(index));
}

_MTL_INLINE void MTL::ArgumentDescriptor::setIndex(NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setIndex_), index);
}

_MTL_INLINE NS::UInteger MTL::ArgumentDescriptor::arrayLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(arrayLength));
}

_MTL_INLINE void MTL::ArgumentDescriptor::setArrayLength(NS::UInteger arrayLength)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setArrayLength_), arrayLength);
}

_MTL_INLINE MTL::ArgumentAccess MTL::ArgumentDescriptor::access() const
{
    return Object::sendMessage<MTL::ArgumentAccess>(this, _MTL_PRIVATE_SEL(access));
}

_MTL_INLINE void MTL::ArgumentDescriptor::setAccess(MTL::ArgumentAccess access)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setAccess_), access);
}

_MTL_INLINE MTL::TextureType MTL::ArgumentDescriptor::textureType() const
{
    return Object::sendMessage<MTL::TextureType>(this, _MTL_PRIVATE_SEL(textureType));
}

_MTL_INLINE void MTL::ArgumentDescriptor::setTextureType(MTL::TextureType textureType)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setTextureType_), textureType);
}

_MTL_INLINE NS::UInteger MTL::ArgumentDescriptor::constantBlockAlignment() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(constantBlockAlignment));
}

_MTL_INLINE void MTL::ArgumentDescriptor::setConstantBlockAlignment(NS::UInteger constantBlockAlignment)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setConstantBlockAlignment_), constantBlockAlignment);
}

#if defined(MTL_PRIVATE_IMPLEMENTATION)

extern "C" MTL::Device* MTLCreateSystemDefaultDevice();

extern "C" NS::Array*   MTLCopyAllDevices();

extern "C" NS::Array*   MTLCopyAllDevicesWithObserver(NS::Object**, MTL::DeviceNotificationHandlerBlock);

extern "C" void         MTLRemoveDeviceObserver(const NS::Object*);

#include <TargetConditionals.h>

MTL::Device* MTL::CreateSystemDefaultDevice()
{
    return ::MTLCreateSystemDefaultDevice();
}

NS::Array* MTL::CopyAllDevices()
{
#if TARGET_OS_OSX
    return ::MTLCopyAllDevices();
#else
    return nullptr;
#endif // TARGET_OS_OSX
}

NS::Array* MTL::CopyAllDevicesWithObserver(NS::Object** pOutObserver, DeviceNotificationHandlerBlock handler)
{
#if TARGET_OS_OSX
    return ::MTLCopyAllDevicesWithObserver(pOutObserver, handler);
#else
    (void)pOutObserver;
    (void)handler;

    return nullptr;
#endif // TARGET_OS_OSX
}

NS::Array* MTL::CopyAllDevicesWithObserver(NS::Object** pOutObserver, const DeviceNotificationHandlerFunction& handler)
{
    __block DeviceNotificationHandlerFunction function = handler;

    return CopyAllDevicesWithObserver(pOutObserver, ^(Device* pDevice, DeviceNotificationName pNotificationName) { function(pDevice, pNotificationName); });
}

void MTL::RemoveDeviceObserver(const NS::Object* pObserver)
{
#if TARGET_OS_OSX
    ::MTLRemoveDeviceObserver(pObserver);
#endif // TARGET_OS_OSX
}

#endif // MTL_PRIVATE_IMPLEMENTATION

_MTL_INLINE void MTL::Device::newLibrary(const NS::String* pSource, const CompileOptions* pOptions, const NewLibraryCompletionHandlerFunction& completionHandler)
{
    __block NewLibraryCompletionHandlerFunction blockCompletionHandler = completionHandler;

    newLibrary(pSource, pOptions, ^(Library* pLibrary, NS::Error* pError) { blockCompletionHandler(pLibrary, pError); });
}

_MTL_INLINE void MTL::Device::newLibrary(const class StitchedLibraryDescriptor* pDescriptor, const MTL::NewLibraryCompletionHandlerFunction& completionHandler)
{
    __block NewLibraryCompletionHandlerFunction blockCompletionHandler = completionHandler;

    newLibrary(pDescriptor, ^(Library* pLibrary, NS::Error* pError) { blockCompletionHandler(pLibrary, pError); });
}

_MTL_INLINE void MTL::Device::newRenderPipelineState(const RenderPipelineDescriptor* pDescriptor, const NewRenderPipelineStateCompletionHandlerFunction& completionHandler)
{
    __block NewRenderPipelineStateCompletionHandlerFunction blockCompletionHandler = completionHandler;

    newRenderPipelineState(pDescriptor, ^(RenderPipelineState* pPipelineState, NS::Error* pError) { blockCompletionHandler(pPipelineState, pError); });
}

_MTL_INLINE void MTL::Device::newRenderPipelineState(const RenderPipelineDescriptor* pDescriptor, PipelineOption options, const NewRenderPipelineStateWithReflectionCompletionHandlerFunction& completionHandler)
{
    __block NewRenderPipelineStateWithReflectionCompletionHandlerFunction blockCompletionHandler = completionHandler;

    newRenderPipelineState(pDescriptor, options, ^(RenderPipelineState* pPipelineState, class RenderPipelineReflection* pReflection, NS::Error* pError) { blockCompletionHandler(pPipelineState, pReflection, pError); });
}

_MTL_INLINE void MTL::Device::newRenderPipelineState(const TileRenderPipelineDescriptor* pDescriptor, PipelineOption options, const NewRenderPipelineStateWithReflectionCompletionHandlerFunction& completionHandler)
{
    __block NewRenderPipelineStateWithReflectionCompletionHandlerFunction blockCompletionHandler = completionHandler;

    newRenderPipelineState(pDescriptor, options, ^(RenderPipelineState* pPipelineState, class RenderPipelineReflection* pReflection, NS::Error* pError) { blockCompletionHandler(pPipelineState, pReflection, pError); });
}

_MTL_INLINE void MTL::Device::newComputePipelineState(const class Function* pFunction, const NewComputePipelineStateCompletionHandlerFunction& completionHandler)
{
    __block NewComputePipelineStateCompletionHandlerFunction blockCompletionHandler = completionHandler;

    newComputePipelineState(pFunction, ^(ComputePipelineState* pPipelineState, NS::Error* pError) { blockCompletionHandler(pPipelineState, pError); });
}

_MTL_INLINE void MTL::Device::newComputePipelineState(const Function* pFunction, PipelineOption options, const NewComputePipelineStateWithReflectionCompletionHandlerFunction& completionHandler)
{
    __block NewComputePipelineStateWithReflectionCompletionHandlerFunction blockCompletionHandler = completionHandler;

    newComputePipelineState(pFunction, options, ^(ComputePipelineState* pPipelineState, ComputePipelineReflection* pReflection, NS::Error* pError) { blockCompletionHandler(pPipelineState, pReflection, pError); });
}

_MTL_INLINE void MTL::Device::newComputePipelineState(const ComputePipelineDescriptor* pDescriptor, PipelineOption options, const NewComputePipelineStateWithReflectionCompletionHandlerFunction& completionHandler)
{
    __block NewComputePipelineStateWithReflectionCompletionHandlerFunction blockCompletionHandler = completionHandler;

    newComputePipelineState(pDescriptor, options, ^(ComputePipelineState* pPipelineState, ComputePipelineReflection* pReflection, NS::Error* pError) { blockCompletionHandler(pPipelineState, pReflection, pError); });
}

_MTL_INLINE bool MTL::Device::isHeadless() const
{
    return headless();
}

_MTL_INLINE NS::String* MTL::Device::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE uint64_t MTL::Device::registryID() const
{
    return Object::sendMessage<uint64_t>(this, _MTL_PRIVATE_SEL(registryID));
}

_MTL_INLINE MTL::Size MTL::Device::maxThreadsPerThreadgroup() const
{
    return Object::sendMessage<MTL::Size>(this, _MTL_PRIVATE_SEL(maxThreadsPerThreadgroup));
}

_MTL_INLINE bool MTL::Device::lowPower() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isLowPower));
}

_MTL_INLINE bool MTL::Device::headless() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isHeadless));
}

_MTL_INLINE bool MTL::Device::removable() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(isRemovable));
}

_MTL_INLINE bool MTL::Device::hasUnifiedMemory() const
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(hasUnifiedMemory));
}

_MTL_INLINE uint64_t MTL::Device::recommendedMaxWorkingSetSize() const
{
    return Object::sendMessage<uint64_t>(this, _MTL_PRIVATE_SEL(recommendedMaxWorkingSetSize));
}

_MTL_INLINE MTL::DeviceLocation MTL::Device::location() const
{
    return Object::sendMessage<MTL::DeviceLocation>(this, _MTL_PRIVATE_SEL(location));
}

_MTL_INLINE NS::UInteger MTL::Device::locationNumber() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(locationNumber));
}

_MTL_INLINE uint64_t MTL::Device::maxTransferRate() const
{
    return Object::sendMessage<uint64_t>(this, _MTL_PRIVATE_SEL(maxTransferRate));
}

_MTL_INLINE bool MTL::Device::depth24Stencil8PixelFormatSupported() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(isDepth24Stencil8PixelFormatSupported));
}

_MTL_INLINE MTL::ReadWriteTextureTier MTL::Device::readWriteTextureSupport() const
{
    return Object::sendMessage<MTL::ReadWriteTextureTier>(this, _MTL_PRIVATE_SEL(readWriteTextureSupport));
}

_MTL_INLINE MTL::ArgumentBuffersTier MTL::Device::argumentBuffersSupport() const
{
    return Object::sendMessage<MTL::ArgumentBuffersTier>(this, _MTL_PRIVATE_SEL(argumentBuffersSupport));
}

_MTL_INLINE bool MTL::Device::rasterOrderGroupsSupported() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(areRasterOrderGroupsSupported));
}

_MTL_INLINE bool MTL::Device::supports32BitFloatFiltering() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supports32BitFloatFiltering));
}

_MTL_INLINE bool MTL::Device::supports32BitMSAA() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supports32BitMSAA));
}

_MTL_INLINE bool MTL::Device::supportsQueryTextureLOD() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsQueryTextureLOD));
}

_MTL_INLINE bool MTL::Device::supportsBCTextureCompression() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsBCTextureCompression));
}

_MTL_INLINE bool MTL::Device::supportsPullModelInterpolation() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsPullModelInterpolation));
}

_MTL_INLINE bool MTL::Device::barycentricCoordsSupported() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(areBarycentricCoordsSupported));
}

_MTL_INLINE bool MTL::Device::supportsShaderBarycentricCoordinates() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsShaderBarycentricCoordinates));
}

_MTL_INLINE NS::UInteger MTL::Device::currentAllocatedSize() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(currentAllocatedSize));
}

_MTL_INLINE MTL::CommandQueue* MTL::Device::newCommandQueue()
{
    return Object::sendMessage<MTL::CommandQueue*>(this, _MTL_PRIVATE_SEL(newCommandQueue));
}

_MTL_INLINE MTL::CommandQueue* MTL::Device::newCommandQueue(NS::UInteger maxCommandBufferCount)
{
    return Object::sendMessage<MTL::CommandQueue*>(this, _MTL_PRIVATE_SEL(newCommandQueueWithMaxCommandBufferCount_), maxCommandBufferCount);
}

_MTL_INLINE MTL::SizeAndAlign MTL::Device::heapTextureSizeAndAlign(const MTL::TextureDescriptor* desc)
{
    return Object::sendMessage<MTL::SizeAndAlign>(this, _MTL_PRIVATE_SEL(heapTextureSizeAndAlignWithDescriptor_), desc);
}

_MTL_INLINE MTL::SizeAndAlign MTL::Device::heapBufferSizeAndAlign(NS::UInteger length, MTL::ResourceOptions options)
{
    return Object::sendMessage<MTL::SizeAndAlign>(this, _MTL_PRIVATE_SEL(heapBufferSizeAndAlignWithLength_options_), length, options);
}

_MTL_INLINE MTL::Heap* MTL::Device::newHeap(const MTL::HeapDescriptor* descriptor)
{
    return Object::sendMessage<MTL::Heap*>(this, _MTL_PRIVATE_SEL(newHeapWithDescriptor_), descriptor);
}

_MTL_INLINE MTL::Buffer* MTL::Device::newBuffer(NS::UInteger length, MTL::ResourceOptions options)
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(newBufferWithLength_options_), length, options);
}

_MTL_INLINE MTL::Buffer* MTL::Device::newBuffer(const void* pointer, NS::UInteger length, MTL::ResourceOptions options)
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(newBufferWithBytes_length_options_), pointer, length, options);
}

_MTL_INLINE MTL::Buffer* MTL::Device::newBuffer(const void* pointer, NS::UInteger length, MTL::ResourceOptions options, void (^deallocator)(void*, NS::UInteger))
{
    return Object::sendMessage<MTL::Buffer*>(this, _MTL_PRIVATE_SEL(newBufferWithBytesNoCopy_length_options_deallocator_), pointer, length, options, deallocator);
}

_MTL_INLINE MTL::DepthStencilState* MTL::Device::newDepthStencilState(const MTL::DepthStencilDescriptor* descriptor)
{
    return Object::sendMessage<MTL::DepthStencilState*>(this, _MTL_PRIVATE_SEL(newDepthStencilStateWithDescriptor_), descriptor);
}

_MTL_INLINE MTL::Texture* MTL::Device::newTexture(const MTL::TextureDescriptor* descriptor)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newTextureWithDescriptor_), descriptor);
}

_MTL_INLINE MTL::Texture* MTL::Device::newTexture(const MTL::TextureDescriptor* descriptor, const IOSurfaceRef iosurface, NS::UInteger plane)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newTextureWithDescriptor_iosurface_plane_), descriptor, iosurface, plane);
}

_MTL_INLINE MTL::Texture* MTL::Device::newSharedTexture(const MTL::TextureDescriptor* descriptor)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newSharedTextureWithDescriptor_), descriptor);
}

_MTL_INLINE MTL::Texture* MTL::Device::newSharedTexture(const MTL::SharedTextureHandle* sharedHandle)
{
    return Object::sendMessage<MTL::Texture*>(this, _MTL_PRIVATE_SEL(newSharedTextureWithHandle_), sharedHandle);
}

_MTL_INLINE MTL::SamplerState* MTL::Device::newSamplerState(const MTL::SamplerDescriptor* descriptor)
{
    return Object::sendMessage<MTL::SamplerState*>(this, _MTL_PRIVATE_SEL(newSamplerStateWithDescriptor_), descriptor);
}

_MTL_INLINE MTL::Library* MTL::Device::newDefaultLibrary()
{
    return Object::sendMessage<MTL::Library*>(this, _MTL_PRIVATE_SEL(newDefaultLibrary));
}

_MTL_INLINE MTL::Library* MTL::Device::newDefaultLibrary(const NS::Bundle* bundle, NS::Error** error)
{
    return Object::sendMessage<MTL::Library*>(this, _MTL_PRIVATE_SEL(newDefaultLibraryWithBundle_error_), bundle, error);
}

_MTL_INLINE MTL::Library* MTL::Device::newLibrary(const NS::String* filepath, NS::Error** error)
{
    return Object::sendMessage<MTL::Library*>(this, _MTL_PRIVATE_SEL(newLibraryWithFile_error_), filepath, error);
}

_MTL_INLINE MTL::Library* MTL::Device::newLibrary(const NS::URL* url, NS::Error** error)
{
    return Object::sendMessage<MTL::Library*>(this, _MTL_PRIVATE_SEL(newLibraryWithURL_error_), url, error);
}

_MTL_INLINE MTL::Library* MTL::Device::newLibrary(const dispatch_data_t data, NS::Error** error)
{
    return Object::sendMessage<MTL::Library*>(this, _MTL_PRIVATE_SEL(newLibraryWithData_error_), data, error);
}

_MTL_INLINE MTL::Library* MTL::Device::newLibrary(const NS::String* source, const MTL::CompileOptions* options, NS::Error** error)
{
    return Object::sendMessage<MTL::Library*>(this, _MTL_PRIVATE_SEL(newLibraryWithSource_options_error_), source, options, error);
}

_MTL_INLINE void MTL::Device::newLibrary(const NS::String* source, const MTL::CompileOptions* options, const MTL::NewLibraryCompletionHandler completionHandler)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newLibraryWithSource_options_completionHandler_), source, options, completionHandler);
}

_MTL_INLINE MTL::Library* MTL::Device::newLibrary(const MTL::StitchedLibraryDescriptor* descriptor, NS::Error** error)
{
    return Object::sendMessage<MTL::Library*>(this, _MTL_PRIVATE_SEL(newLibraryWithStitchedDescriptor_error_), descriptor, error);
}

_MTL_INLINE void MTL::Device::newLibrary(const MTL::StitchedLibraryDescriptor* descriptor, const MTL::NewLibraryCompletionHandler completionHandler)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newLibraryWithStitchedDescriptor_completionHandler_), descriptor, completionHandler);
}

_MTL_INLINE MTL::RenderPipelineState* MTL::Device::newRenderPipelineState(const MTL::RenderPipelineDescriptor* descriptor, NS::Error** error)
{
    return Object::sendMessage<MTL::RenderPipelineState*>(this, _MTL_PRIVATE_SEL(newRenderPipelineStateWithDescriptor_error_), descriptor, error);
}

_MTL_INLINE MTL::RenderPipelineState* MTL::Device::newRenderPipelineState(const MTL::RenderPipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::AutoreleasedRenderPipelineReflection* reflection, NS::Error** error)
{
    return Object::sendMessage<MTL::RenderPipelineState*>(this, _MTL_PRIVATE_SEL(newRenderPipelineStateWithDescriptor_options_reflection_error_), descriptor, options, reflection, error);
}

_MTL_INLINE void MTL::Device::newRenderPipelineState(const MTL::RenderPipelineDescriptor* descriptor, const MTL::NewRenderPipelineStateCompletionHandler completionHandler)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newRenderPipelineStateWithDescriptor_completionHandler_), descriptor, completionHandler);
}

_MTL_INLINE void MTL::Device::newRenderPipelineState(const MTL::RenderPipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::NewRenderPipelineStateWithReflectionCompletionHandler completionHandler)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newRenderPipelineStateWithDescriptor_options_completionHandler_), descriptor, options, completionHandler);
}

_MTL_INLINE MTL::ComputePipelineState* MTL::Device::newComputePipelineState(const MTL::Function* computeFunction, NS::Error** error)
{
    return Object::sendMessage<MTL::ComputePipelineState*>(this, _MTL_PRIVATE_SEL(newComputePipelineStateWithFunction_error_), computeFunction, error);
}

_MTL_INLINE MTL::ComputePipelineState* MTL::Device::newComputePipelineState(const MTL::Function* computeFunction, MTL::PipelineOption options, const MTL::AutoreleasedComputePipelineReflection* reflection, NS::Error** error)
{
    return Object::sendMessage<MTL::ComputePipelineState*>(this, _MTL_PRIVATE_SEL(newComputePipelineStateWithFunction_options_reflection_error_), computeFunction, options, reflection, error);
}

_MTL_INLINE void MTL::Device::newComputePipelineState(const MTL::Function* computeFunction, const MTL::NewComputePipelineStateCompletionHandler completionHandler)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newComputePipelineStateWithFunction_completionHandler_), computeFunction, completionHandler);
}

_MTL_INLINE void MTL::Device::newComputePipelineState(const MTL::Function* computeFunction, MTL::PipelineOption options, const MTL::NewComputePipelineStateWithReflectionCompletionHandler completionHandler)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newComputePipelineStateWithFunction_options_completionHandler_), computeFunction, options, completionHandler);
}

_MTL_INLINE MTL::ComputePipelineState* MTL::Device::newComputePipelineState(const MTL::ComputePipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::AutoreleasedComputePipelineReflection* reflection, NS::Error** error)
{
    return Object::sendMessage<MTL::ComputePipelineState*>(this, _MTL_PRIVATE_SEL(newComputePipelineStateWithDescriptor_options_reflection_error_), descriptor, options, reflection, error);
}

_MTL_INLINE void MTL::Device::newComputePipelineState(const MTL::ComputePipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::NewComputePipelineStateWithReflectionCompletionHandler completionHandler)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newComputePipelineStateWithDescriptor_options_completionHandler_), descriptor, options, completionHandler);
}

_MTL_INLINE MTL::Fence* MTL::Device::newFence()
{
    return Object::sendMessage<MTL::Fence*>(this, _MTL_PRIVATE_SEL(newFence));
}

_MTL_INLINE bool MTL::Device::supportsFeatureSet(MTL::FeatureSet featureSet)
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsFeatureSet_), featureSet);
}

_MTL_INLINE bool MTL::Device::supportsFamily(MTL::GPUFamily gpuFamily)
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsFamily_), gpuFamily);
}

_MTL_INLINE bool MTL::Device::supportsTextureSampleCount(NS::UInteger sampleCount)
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsTextureSampleCount_), sampleCount);
}

_MTL_INLINE NS::UInteger MTL::Device::minimumLinearTextureAlignmentForPixelFormat(MTL::PixelFormat format)
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(minimumLinearTextureAlignmentForPixelFormat_), format);
}

_MTL_INLINE NS::UInteger MTL::Device::minimumTextureBufferAlignmentForPixelFormat(MTL::PixelFormat format)
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(minimumTextureBufferAlignmentForPixelFormat_), format);
}

_MTL_INLINE MTL::RenderPipelineState* MTL::Device::newRenderPipelineState(const MTL::TileRenderPipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::AutoreleasedRenderPipelineReflection* reflection, NS::Error** error)
{
    return Object::sendMessage<MTL::RenderPipelineState*>(this, _MTL_PRIVATE_SEL(newRenderPipelineStateWithTileDescriptor_options_reflection_error_), descriptor, options, reflection, error);
}

_MTL_INLINE void MTL::Device::newRenderPipelineState(const MTL::TileRenderPipelineDescriptor* descriptor, MTL::PipelineOption options, const MTL::NewRenderPipelineStateWithReflectionCompletionHandler completionHandler)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(newRenderPipelineStateWithTileDescriptor_options_completionHandler_), descriptor, options, completionHandler);
}

_MTL_INLINE NS::UInteger MTL::Device::maxThreadgroupMemoryLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxThreadgroupMemoryLength));
}

_MTL_INLINE NS::UInteger MTL::Device::maxArgumentBufferSamplerCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxArgumentBufferSamplerCount));
}

_MTL_INLINE bool MTL::Device::programmableSamplePositionsSupported() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(areProgrammableSamplePositionsSupported));
}

_MTL_INLINE void MTL::Device::getDefaultSamplePositions(MTL::SamplePosition* positions, NS::UInteger count)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(getDefaultSamplePositions_count_), positions, count);
}

_MTL_INLINE MTL::ArgumentEncoder* MTL::Device::newArgumentEncoder(const NS::Array* arguments)
{
    return Object::sendMessage<MTL::ArgumentEncoder*>(this, _MTL_PRIVATE_SEL(newArgumentEncoderWithArguments_), arguments);
}

_MTL_INLINE bool MTL::Device::supportsRasterizationRateMap(NS::UInteger layerCount)
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsRasterizationRateMapWithLayerCount_), layerCount);
}

_MTL_INLINE MTL::RasterizationRateMap* MTL::Device::newRasterizationRateMap(const MTL::RasterizationRateMapDescriptor* descriptor)
{
    return Object::sendMessage<MTL::RasterizationRateMap*>(this, _MTL_PRIVATE_SEL(newRasterizationRateMapWithDescriptor_), descriptor);
}

_MTL_INLINE MTL::IndirectCommandBuffer* MTL::Device::newIndirectCommandBuffer(const MTL::IndirectCommandBufferDescriptor* descriptor, NS::UInteger maxCount, MTL::ResourceOptions options)
{
    return Object::sendMessage<MTL::IndirectCommandBuffer*>(this, _MTL_PRIVATE_SEL(newIndirectCommandBufferWithDescriptor_maxCommandCount_options_), descriptor, maxCount, options);
}

_MTL_INLINE MTL::Event* MTL::Device::newEvent()
{
    return Object::sendMessage<MTL::Event*>(this, _MTL_PRIVATE_SEL(newEvent));
}

_MTL_INLINE MTL::SharedEvent* MTL::Device::newSharedEvent()
{
    return Object::sendMessage<MTL::SharedEvent*>(this, _MTL_PRIVATE_SEL(newSharedEvent));
}

_MTL_INLINE MTL::SharedEvent* MTL::Device::newSharedEvent(const MTL::SharedEventHandle* sharedEventHandle)
{
    return Object::sendMessage<MTL::SharedEvent*>(this, _MTL_PRIVATE_SEL(newSharedEventWithHandle_), sharedEventHandle);
}

_MTL_INLINE uint64_t MTL::Device::peerGroupID() const
{
    return Object::sendMessage<uint64_t>(this, _MTL_PRIVATE_SEL(peerGroupID));
}

_MTL_INLINE uint32_t MTL::Device::peerIndex() const
{
    return Object::sendMessage<uint32_t>(this, _MTL_PRIVATE_SEL(peerIndex));
}

_MTL_INLINE uint32_t MTL::Device::peerCount() const
{
    return Object::sendMessage<uint32_t>(this, _MTL_PRIVATE_SEL(peerCount));
}

_MTL_INLINE MTL::Size MTL::Device::sparseTileSize(MTL::TextureType textureType, MTL::PixelFormat pixelFormat, NS::UInteger sampleCount)
{
    return Object::sendMessage<MTL::Size>(this, _MTL_PRIVATE_SEL(sparseTileSizeWithTextureType_pixelFormat_sampleCount_), textureType, pixelFormat, sampleCount);
}

_MTL_INLINE NS::UInteger MTL::Device::sparseTileSizeInBytes() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(sparseTileSizeInBytes));
}

_MTL_INLINE void MTL::Device::convertSparsePixelRegions(const MTL::Region* pixelRegions, MTL::Region* tileRegions, MTL::Size tileSize, MTL::SparseTextureRegionAlignmentMode mode, NS::UInteger numRegions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(convertSparsePixelRegions_toTileRegions_withTileSize_alignmentMode_numRegions_), pixelRegions, tileRegions, tileSize, mode, numRegions);
}

_MTL_INLINE void MTL::Device::convertSparseTileRegions(const MTL::Region* tileRegions, MTL::Region* pixelRegions, MTL::Size tileSize, NS::UInteger numRegions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(convertSparseTileRegions_toPixelRegions_withTileSize_numRegions_), tileRegions, pixelRegions, tileSize, numRegions);
}

_MTL_INLINE NS::UInteger MTL::Device::maxBufferLength() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(maxBufferLength));
}

_MTL_INLINE NS::Array* MTL::Device::counterSets() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(counterSets));
}

_MTL_INLINE MTL::CounterSampleBuffer* MTL::Device::newCounterSampleBuffer(const MTL::CounterSampleBufferDescriptor* descriptor, NS::Error** error)
{
    return Object::sendMessage<MTL::CounterSampleBuffer*>(this, _MTL_PRIVATE_SEL(newCounterSampleBufferWithDescriptor_error_), descriptor, error);
}

_MTL_INLINE void MTL::Device::sampleTimestamps(MTL::Timestamp* cpuTimestamp, MTL::Timestamp* gpuTimestamp)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(sampleTimestamps_gpuTimestamp_), cpuTimestamp, gpuTimestamp);
}

_MTL_INLINE bool MTL::Device::supportsCounterSampling(MTL::CounterSamplingPoint samplingPoint)
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsCounterSampling_), samplingPoint);
}

_MTL_INLINE bool MTL::Device::supportsVertexAmplificationCount(NS::UInteger count)
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsVertexAmplificationCount_), count);
}

_MTL_INLINE bool MTL::Device::supportsDynamicLibraries() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsDynamicLibraries));
}

_MTL_INLINE bool MTL::Device::supportsRenderDynamicLibraries() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsRenderDynamicLibraries));
}

_MTL_INLINE MTL::DynamicLibrary* MTL::Device::newDynamicLibrary(const MTL::Library* library, NS::Error** error)
{
    return Object::sendMessage<MTL::DynamicLibrary*>(this, _MTL_PRIVATE_SEL(newDynamicLibrary_error_), library, error);
}

_MTL_INLINE MTL::DynamicLibrary* MTL::Device::newDynamicLibrary(const NS::URL* url, NS::Error** error)
{
    return Object::sendMessage<MTL::DynamicLibrary*>(this, _MTL_PRIVATE_SEL(newDynamicLibraryWithURL_error_), url, error);
}

_MTL_INLINE MTL::BinaryArchive* MTL::Device::newBinaryArchive(const MTL::BinaryArchiveDescriptor* descriptor, NS::Error** error)
{
    return Object::sendMessage<MTL::BinaryArchive*>(this, _MTL_PRIVATE_SEL(newBinaryArchiveWithDescriptor_error_), descriptor, error);
}

_MTL_INLINE bool MTL::Device::supportsRaytracing() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsRaytracing));
}

_MTL_INLINE MTL::AccelerationStructureSizes MTL::Device::accelerationStructureSizes(const MTL::AccelerationStructureDescriptor* descriptor)
{
    return Object::sendMessage<MTL::AccelerationStructureSizes>(this, _MTL_PRIVATE_SEL(accelerationStructureSizesWithDescriptor_), descriptor);
}

_MTL_INLINE MTL::AccelerationStructure* MTL::Device::newAccelerationStructure(NS::UInteger size)
{
    return Object::sendMessage<MTL::AccelerationStructure*>(this, _MTL_PRIVATE_SEL(newAccelerationStructureWithSize_), size);
}

_MTL_INLINE MTL::AccelerationStructure* MTL::Device::newAccelerationStructure(const MTL::AccelerationStructureDescriptor* descriptor)
{
    return Object::sendMessage<MTL::AccelerationStructure*>(this, _MTL_PRIVATE_SEL(newAccelerationStructureWithDescriptor_), descriptor);
}

_MTL_INLINE bool MTL::Device::supportsFunctionPointers() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsFunctionPointers));
}

_MTL_INLINE bool MTL::Device::supportsFunctionPointersFromRender() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsFunctionPointersFromRender));
}

_MTL_INLINE bool MTL::Device::supportsRaytracingFromRender() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsRaytracingFromRender));
}

_MTL_INLINE bool MTL::Device::supportsPrimitiveMotionBlur() const
{
    return Object::sendMessageSafe<bool>(this, _MTL_PRIVATE_SEL(supportsPrimitiveMotionBlur));
}

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, DynamicLibraryError) {
    DynamicLibraryErrorNone = 0,
    DynamicLibraryErrorInvalidFile = 1,
    DynamicLibraryErrorCompilationFailure = 2,
    DynamicLibraryErrorUnresolvedInstallName = 3,
    DynamicLibraryErrorDependencyLoadFailure = 4,
    DynamicLibraryErrorUnsupported = 5,
};

class DynamicLibrary : public NS::Referencing<DynamicLibrary>
{
public:
    NS::String*   label() const;
    void          setLabel(const NS::String* label);

    class Device* device() const;

    NS::String*   installName() const;

    bool          serializeToURL(const NS::URL* url, NS::Error** error);
};

}

_MTL_INLINE NS::String* MTL::DynamicLibrary::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::DynamicLibrary::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::Device* MTL::DynamicLibrary::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::String* MTL::DynamicLibrary::installName() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(installName));
}

_MTL_INLINE bool MTL::DynamicLibrary::serializeToURL(const NS::URL* url, NS::Error** error)
{
    return Object::sendMessage<bool>(this, _MTL_PRIVATE_SEL(serializeToURL_error_), url, error);
}

#pragma once

namespace MTL
{
class Event : public NS::Referencing<Event>
{
public:
    class Device* device() const;

    NS::String*   label() const;
    void          setLabel(const NS::String* label);
};

class SharedEventListener : public NS::Referencing<SharedEventListener>
{
public:
    static class SharedEventListener* alloc();

    MTL::SharedEventListener*         init();

    MTL::SharedEventListener*         init(const dispatch_queue_t dispatchQueue);

    dispatch_queue_t                  dispatchQueue() const;
};

using SharedEventNotificationBlock = void (^)(SharedEvent* pEvent, std::uint64_t value);

class SharedEvent : public NS::Referencing<SharedEvent, Event>
{
public:
    void                     notifyListener(const class SharedEventListener* listener, uint64_t value, const MTL::SharedEventNotificationBlock block);

    class SharedEventHandle* newSharedEventHandle();

    uint64_t                 signaledValue() const;
    void                     setSignaledValue(uint64_t signaledValue);
};

class SharedEventHandle : public NS::Referencing<SharedEventHandle>
{
public:
    static class SharedEventHandle* alloc();

    class SharedEventHandle*        init();

    NS::String*                     label() const;
};

struct SharedEventHandlePrivate
{
} _MTL_PACKED;

}

_MTL_INLINE MTL::Device* MTL::Event::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::String* MTL::Event::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::Event::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE MTL::SharedEventListener* MTL::SharedEventListener::alloc()
{
    return NS::Object::alloc<MTL::SharedEventListener>(_MTL_PRIVATE_CLS(MTLSharedEventListener));
}

_MTL_INLINE MTL::SharedEventListener* MTL::SharedEventListener::init()
{
    return NS::Object::init<MTL::SharedEventListener>();
}

_MTL_INLINE MTL::SharedEventListener* MTL::SharedEventListener::init(const dispatch_queue_t dispatchQueue)
{
    return Object::sendMessage<MTL::SharedEventListener*>(this, _MTL_PRIVATE_SEL(initWithDispatchQueue_), dispatchQueue);
}

_MTL_INLINE dispatch_queue_t MTL::SharedEventListener::dispatchQueue() const
{
    return Object::sendMessage<dispatch_queue_t>(this, _MTL_PRIVATE_SEL(dispatchQueue));
}

_MTL_INLINE void MTL::SharedEvent::notifyListener(const MTL::SharedEventListener* listener, uint64_t value, const MTL::SharedEventNotificationBlock block)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(notifyListener_atValue_block_), listener, value, block);
}

_MTL_INLINE MTL::SharedEventHandle* MTL::SharedEvent::newSharedEventHandle()
{
    return Object::sendMessage<MTL::SharedEventHandle*>(this, _MTL_PRIVATE_SEL(newSharedEventHandle));
}

_MTL_INLINE uint64_t MTL::SharedEvent::signaledValue() const
{
    return Object::sendMessage<uint64_t>(this, _MTL_PRIVATE_SEL(signaledValue));
}

_MTL_INLINE void MTL::SharedEvent::setSignaledValue(uint64_t signaledValue)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSignaledValue_), signaledValue);
}

_MTL_INLINE MTL::SharedEventHandle* MTL::SharedEventHandle::alloc()
{
    return NS::Object::alloc<MTL::SharedEventHandle>(_MTL_PRIVATE_CLS(MTLSharedEventHandle));
}

_MTL_INLINE MTL::SharedEventHandle* MTL::SharedEventHandle::init()
{
    return NS::Object::init<MTL::SharedEventHandle>();
}

_MTL_INLINE NS::String* MTL::SharedEventHandle::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

#pragma once

namespace MTL
{
class Fence : public NS::Referencing<Fence>
{
public:
    class Device* device() const;

    NS::String*   label() const;
    void          setLabel(const NS::String* label);
};

}

_MTL_INLINE MTL::Device* MTL::Fence::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::String* MTL::Fence::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::Fence::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

#pragma once

namespace MTL
{
class FunctionConstantValues : public NS::Copying<FunctionConstantValues>
{
public:
    static class FunctionConstantValues* alloc();

    class FunctionConstantValues*        init();

    void                                 setConstantValue(const void* value, MTL::DataType type, NS::UInteger index);

    void                                 setConstantValues(const void* values, MTL::DataType type, NS::Range range);

    void                                 setConstantValue(const void* value, MTL::DataType type, const NS::String* name);

    void                                 reset();
};

}

_MTL_INLINE MTL::FunctionConstantValues* MTL::FunctionConstantValues::alloc()
{
    return NS::Object::alloc<MTL::FunctionConstantValues>(_MTL_PRIVATE_CLS(MTLFunctionConstantValues));
}

_MTL_INLINE MTL::FunctionConstantValues* MTL::FunctionConstantValues::init()
{
    return NS::Object::init<MTL::FunctionConstantValues>();
}

_MTL_INLINE void MTL::FunctionConstantValues::setConstantValue(const void* value, MTL::DataType type, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setConstantValue_type_atIndex_), value, type, index);
}

_MTL_INLINE void MTL::FunctionConstantValues::setConstantValues(const void* values, MTL::DataType type, NS::Range range)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setConstantValues_type_withRange_), values, type, range);
}

_MTL_INLINE void MTL::FunctionConstantValues::setConstantValue(const void* value, MTL::DataType type, const NS::String* name)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setConstantValue_type_withName_), value, type, name);
}

_MTL_INLINE void MTL::FunctionConstantValues::reset()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(reset));
}

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, FunctionLogType) {
    FunctionLogTypeValidation = 0,
};

class LogContainer : public NS::Referencing<LogContainer, NS::FastEnumeration>
{
public:
};

class FunctionLogDebugLocation : public NS::Referencing<FunctionLogDebugLocation>
{
public:
    NS::String*  functionName() const;

    NS::URL*     URL() const;

    NS::UInteger line() const;

    NS::UInteger column() const;
};

class FunctionLog : public NS::Referencing<FunctionLog>
{
public:
    MTL::FunctionLogType            type() const;

    NS::String*                     encoderLabel() const;

    class Function*                 function() const;

    class FunctionLogDebugLocation* debugLocation() const;
};

}

_MTL_INLINE NS::String* MTL::FunctionLogDebugLocation::functionName() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(functionName));
}

_MTL_INLINE NS::URL* MTL::FunctionLogDebugLocation::URL() const
{
    return Object::sendMessage<NS::URL*>(this, _MTL_PRIVATE_SEL(URL));
}

_MTL_INLINE NS::UInteger MTL::FunctionLogDebugLocation::line() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(line));
}

_MTL_INLINE NS::UInteger MTL::FunctionLogDebugLocation::column() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(column));
}

_MTL_INLINE MTL::FunctionLogType MTL::FunctionLog::type() const
{
    return Object::sendMessage<MTL::FunctionLogType>(this, _MTL_PRIVATE_SEL(type));
}

_MTL_INLINE NS::String* MTL::FunctionLog::encoderLabel() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(encoderLabel));
}

_MTL_INLINE MTL::Function* MTL::FunctionLog::function() const
{
    return Object::sendMessage<MTL::Function*>(this, _MTL_PRIVATE_SEL(function));
}

_MTL_INLINE MTL::FunctionLogDebugLocation* MTL::FunctionLog::debugLocation() const
{
    return Object::sendMessage<MTL::FunctionLogDebugLocation*>(this, _MTL_PRIVATE_SEL(debugLocation));
}

#pragma once

namespace MTL
{
class FunctionStitchingAttribute : public NS::Referencing<FunctionStitchingAttribute>
{
};

class FunctionStitchingAttributeAlwaysInline : public NS::Referencing<FunctionStitchingAttributeAlwaysInline, FunctionStitchingAttribute>
{
public:
    static class FunctionStitchingAttributeAlwaysInline* alloc();

    class FunctionStitchingAttributeAlwaysInline*        init();
};

class FunctionStitchingNode : public NS::Copying<FunctionStitchingNode>
{
};

class FunctionStitchingInputNode : public NS::Referencing<FunctionStitchingInputNode, FunctionStitchingNode>
{
public:
    static class FunctionStitchingInputNode* alloc();

    class FunctionStitchingInputNode*        init();

    NS::UInteger                             argumentIndex() const;
    void                                     setArgumentIndex(NS::UInteger argumentIndex);

    MTL::FunctionStitchingInputNode*         init(NS::UInteger argument);
};

class FunctionStitchingFunctionNode : public NS::Referencing<FunctionStitchingFunctionNode, FunctionStitchingNode>
{
public:
    static class FunctionStitchingFunctionNode* alloc();

    class FunctionStitchingFunctionNode*        init();

    NS::String*                                 name() const;
    void                                        setName(const NS::String* name);

    NS::Array*                                  arguments() const;
    void                                        setArguments(const NS::Array* arguments);

    NS::Array*                                  controlDependencies() const;
    void                                        setControlDependencies(const NS::Array* controlDependencies);

    MTL::FunctionStitchingFunctionNode*         init(const NS::String* name, const NS::Array* arguments, const NS::Array* controlDependencies);
};

class FunctionStitchingGraph : public NS::Copying<FunctionStitchingGraph>
{
public:
    static class FunctionStitchingGraph* alloc();

    class FunctionStitchingGraph*        init();

    NS::String*                          functionName() const;
    void                                 setFunctionName(const NS::String* functionName);

    NS::Array*                           nodes() const;
    void                                 setNodes(const NS::Array* nodes);

    class FunctionStitchingFunctionNode* outputNode() const;
    void                                 setOutputNode(const class FunctionStitchingFunctionNode* outputNode);

    NS::Array*                           attributes() const;
    void                                 setAttributes(const NS::Array* attributes);

    MTL::FunctionStitchingGraph*         init(const NS::String* functionName, const NS::Array* nodes, const class FunctionStitchingFunctionNode* outputNode, const NS::Array* attributes);
};

class StitchedLibraryDescriptor : public NS::Copying<StitchedLibraryDescriptor>
{
public:
    static class StitchedLibraryDescriptor* alloc();

    class StitchedLibraryDescriptor*        init();

    NS::Array*                              functionGraphs() const;
    void                                    setFunctionGraphs(const NS::Array* functionGraphs);

    NS::Array*                              functions() const;
    void                                    setFunctions(const NS::Array* functions);
};

}

_MTL_INLINE MTL::FunctionStitchingAttributeAlwaysInline* MTL::FunctionStitchingAttributeAlwaysInline::alloc()
{
    return NS::Object::alloc<MTL::FunctionStitchingAttributeAlwaysInline>(_MTL_PRIVATE_CLS(MTLFunctionStitchingAttributeAlwaysInline));
}

_MTL_INLINE MTL::FunctionStitchingAttributeAlwaysInline* MTL::FunctionStitchingAttributeAlwaysInline::init()
{
    return NS::Object::init<MTL::FunctionStitchingAttributeAlwaysInline>();
}

_MTL_INLINE MTL::FunctionStitchingInputNode* MTL::FunctionStitchingInputNode::alloc()
{
    return NS::Object::alloc<MTL::FunctionStitchingInputNode>(_MTL_PRIVATE_CLS(MTLFunctionStitchingInputNode));
}

_MTL_INLINE MTL::FunctionStitchingInputNode* MTL::FunctionStitchingInputNode::init()
{
    return NS::Object::init<MTL::FunctionStitchingInputNode>();
}

_MTL_INLINE NS::UInteger MTL::FunctionStitchingInputNode::argumentIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(argumentIndex));
}

_MTL_INLINE void MTL::FunctionStitchingInputNode::setArgumentIndex(NS::UInteger argumentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setArgumentIndex_), argumentIndex);
}

_MTL_INLINE MTL::FunctionStitchingInputNode* MTL::FunctionStitchingInputNode::init(NS::UInteger argument)
{
    return Object::sendMessage<MTL::FunctionStitchingInputNode*>(this, _MTL_PRIVATE_SEL(initWithArgumentIndex_), argument);
}

_MTL_INLINE MTL::FunctionStitchingFunctionNode* MTL::FunctionStitchingFunctionNode::alloc()
{
    return NS::Object::alloc<MTL::FunctionStitchingFunctionNode>(_MTL_PRIVATE_CLS(MTLFunctionStitchingFunctionNode));
}

_MTL_INLINE MTL::FunctionStitchingFunctionNode* MTL::FunctionStitchingFunctionNode::init()
{
    return NS::Object::init<MTL::FunctionStitchingFunctionNode>();
}

_MTL_INLINE NS::String* MTL::FunctionStitchingFunctionNode::name() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(name));
}

_MTL_INLINE void MTL::FunctionStitchingFunctionNode::setName(const NS::String* name)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setName_), name);
}

_MTL_INLINE NS::Array* MTL::FunctionStitchingFunctionNode::arguments() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(arguments));
}

_MTL_INLINE void MTL::FunctionStitchingFunctionNode::setArguments(const NS::Array* arguments)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setArguments_), arguments);
}

_MTL_INLINE NS::Array* MTL::FunctionStitchingFunctionNode::controlDependencies() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(controlDependencies));
}

_MTL_INLINE void MTL::FunctionStitchingFunctionNode::setControlDependencies(const NS::Array* controlDependencies)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setControlDependencies_), controlDependencies);
}

_MTL_INLINE MTL::FunctionStitchingFunctionNode* MTL::FunctionStitchingFunctionNode::init(const NS::String* name, const NS::Array* arguments, const NS::Array* controlDependencies)
{
    return Object::sendMessage<MTL::FunctionStitchingFunctionNode*>(this, _MTL_PRIVATE_SEL(initWithName_arguments_controlDependencies_), name, arguments, controlDependencies);
}

_MTL_INLINE MTL::FunctionStitchingGraph* MTL::FunctionStitchingGraph::alloc()
{
    return NS::Object::alloc<MTL::FunctionStitchingGraph>(_MTL_PRIVATE_CLS(MTLFunctionStitchingGraph));
}

_MTL_INLINE MTL::FunctionStitchingGraph* MTL::FunctionStitchingGraph::init()
{
    return NS::Object::init<MTL::FunctionStitchingGraph>();
}

_MTL_INLINE NS::String* MTL::FunctionStitchingGraph::functionName() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(functionName));
}

_MTL_INLINE void MTL::FunctionStitchingGraph::setFunctionName(const NS::String* functionName)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFunctionName_), functionName);
}

_MTL_INLINE NS::Array* MTL::FunctionStitchingGraph::nodes() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(nodes));
}

_MTL_INLINE void MTL::FunctionStitchingGraph::setNodes(const NS::Array* nodes)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setNodes_), nodes);
}

_MTL_INLINE MTL::FunctionStitchingFunctionNode* MTL::FunctionStitchingGraph::outputNode() const
{
    return Object::sendMessage<MTL::FunctionStitchingFunctionNode*>(this, _MTL_PRIVATE_SEL(outputNode));
}

_MTL_INLINE void MTL::FunctionStitchingGraph::setOutputNode(const MTL::FunctionStitchingFunctionNode* outputNode)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setOutputNode_), outputNode);
}

_MTL_INLINE NS::Array* MTL::FunctionStitchingGraph::attributes() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(attributes));
}

_MTL_INLINE void MTL::FunctionStitchingGraph::setAttributes(const NS::Array* attributes)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setAttributes_), attributes);
}

_MTL_INLINE MTL::FunctionStitchingGraph* MTL::FunctionStitchingGraph::init(const NS::String* functionName, const NS::Array* nodes, const MTL::FunctionStitchingFunctionNode* outputNode, const NS::Array* attributes)
{
    return Object::sendMessage<MTL::FunctionStitchingGraph*>(this, _MTL_PRIVATE_SEL(initWithFunctionName_nodes_outputNode_attributes_), functionName, nodes, outputNode, attributes);
}

_MTL_INLINE MTL::StitchedLibraryDescriptor* MTL::StitchedLibraryDescriptor::alloc()
{
    return NS::Object::alloc<MTL::StitchedLibraryDescriptor>(_MTL_PRIVATE_CLS(MTLStitchedLibraryDescriptor));
}

_MTL_INLINE MTL::StitchedLibraryDescriptor* MTL::StitchedLibraryDescriptor::init()
{
    return NS::Object::init<MTL::StitchedLibraryDescriptor>();
}

_MTL_INLINE NS::Array* MTL::StitchedLibraryDescriptor::functionGraphs() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(functionGraphs));
}

_MTL_INLINE void MTL::StitchedLibraryDescriptor::setFunctionGraphs(const NS::Array* functionGraphs)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFunctionGraphs_), functionGraphs);
}

_MTL_INLINE NS::Array* MTL::StitchedLibraryDescriptor::functions() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(functions));
}

_MTL_INLINE void MTL::StitchedLibraryDescriptor::setFunctions(const NS::Array* functions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFunctions_), functions);
}

#pragma once

namespace MTL
{
class IndirectRenderCommand : public NS::Referencing<IndirectRenderCommand>
{
public:
    void setRenderPipelineState(const class RenderPipelineState* pipelineState);

    void setVertexBuffer(const class Buffer* buffer, NS::UInteger offset, NS::UInteger index);

    void setFragmentBuffer(const class Buffer* buffer, NS::UInteger offset, NS::UInteger index);

    void drawPatches(NS::UInteger numberOfPatchControlPoints, NS::UInteger patchStart, NS::UInteger patchCount, const class Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, NS::UInteger instanceCount, NS::UInteger baseInstance, const class Buffer* buffer, NS::UInteger offset, NS::UInteger instanceStride);

    void drawIndexedPatches(NS::UInteger numberOfPatchControlPoints, NS::UInteger patchStart, NS::UInteger patchCount, const class Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, const class Buffer* controlPointIndexBuffer, NS::UInteger controlPointIndexBufferOffset, NS::UInteger instanceCount, NS::UInteger baseInstance, const class Buffer* buffer, NS::UInteger offset, NS::UInteger instanceStride);

    void drawPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger vertexStart, NS::UInteger vertexCount, NS::UInteger instanceCount, NS::UInteger baseInstance);

    void drawIndexedPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger indexCount, MTL::IndexType indexType, const class Buffer* indexBuffer, NS::UInteger indexBufferOffset, NS::UInteger instanceCount, NS::Integer baseVertex, NS::UInteger baseInstance);

    void reset();
};

class IndirectComputeCommand : public NS::Referencing<IndirectComputeCommand>
{
public:
    void setComputePipelineState(const class ComputePipelineState* pipelineState);

    void setKernelBuffer(const class Buffer* buffer, NS::UInteger offset, NS::UInteger index);

    void concurrentDispatchThreadgroups(MTL::Size threadgroupsPerGrid, MTL::Size threadsPerThreadgroup);

    void concurrentDispatchThreads(MTL::Size threadsPerGrid, MTL::Size threadsPerThreadgroup);

    void setBarrier();

    void clearBarrier();

    void setImageblockWidth(NS::UInteger width, NS::UInteger height);

    void reset();

    void setThreadgroupMemoryLength(NS::UInteger length, NS::UInteger index);

    void setStageInRegion(MTL::Region region);
};

}

_MTL_INLINE void MTL::IndirectRenderCommand::setRenderPipelineState(const MTL::RenderPipelineState* pipelineState)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setRenderPipelineState_), pipelineState);
}

_MTL_INLINE void MTL::IndirectRenderCommand::setVertexBuffer(const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setVertexBuffer_offset_atIndex_), buffer, offset, index);
}

_MTL_INLINE void MTL::IndirectRenderCommand::setFragmentBuffer(const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFragmentBuffer_offset_atIndex_), buffer, offset, index);
}

_MTL_INLINE void MTL::IndirectRenderCommand::drawPatches(NS::UInteger numberOfPatchControlPoints, NS::UInteger patchStart, NS::UInteger patchCount, const MTL::Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, NS::UInteger instanceCount, NS::UInteger baseInstance, const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger instanceStride)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawPatches_patchStart_patchCount_patchIndexBuffer_patchIndexBufferOffset_instanceCount_baseInstance_tessellationFactorBuffer_tessellationFactorBufferOffset_tessellationFactorBufferInstanceStride_), numberOfPatchControlPoints, patchStart, patchCount, patchIndexBuffer, patchIndexBufferOffset, instanceCount, baseInstance, buffer, offset, instanceStride);
}

_MTL_INLINE void MTL::IndirectRenderCommand::drawIndexedPatches(NS::UInteger numberOfPatchControlPoints, NS::UInteger patchStart, NS::UInteger patchCount, const MTL::Buffer* patchIndexBuffer, NS::UInteger patchIndexBufferOffset, const MTL::Buffer* controlPointIndexBuffer, NS::UInteger controlPointIndexBufferOffset, NS::UInteger instanceCount, NS::UInteger baseInstance, const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger instanceStride)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawIndexedPatches_patchStart_patchCount_patchIndexBuffer_patchIndexBufferOffset_controlPointIndexBuffer_controlPointIndexBufferOffset_instanceCount_baseInstance_tessellationFactorBuffer_tessellationFactorBufferOffset_tessellationFactorBufferInstanceStride_), numberOfPatchControlPoints, patchStart, patchCount, patchIndexBuffer, patchIndexBufferOffset, controlPointIndexBuffer, controlPointIndexBufferOffset, instanceCount, baseInstance, buffer, offset, instanceStride);
}

_MTL_INLINE void MTL::IndirectRenderCommand::drawPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger vertexStart, NS::UInteger vertexCount, NS::UInteger instanceCount, NS::UInteger baseInstance)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawPrimitives_vertexStart_vertexCount_instanceCount_baseInstance_), primitiveType, vertexStart, vertexCount, instanceCount, baseInstance);
}

_MTL_INLINE void MTL::IndirectRenderCommand::drawIndexedPrimitives(MTL::PrimitiveType primitiveType, NS::UInteger indexCount, MTL::IndexType indexType, const MTL::Buffer* indexBuffer, NS::UInteger indexBufferOffset, NS::UInteger instanceCount, NS::Integer baseVertex, NS::UInteger baseInstance)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(drawIndexedPrimitives_indexCount_indexType_indexBuffer_indexBufferOffset_instanceCount_baseVertex_baseInstance_), primitiveType, indexCount, indexType, indexBuffer, indexBufferOffset, instanceCount, baseVertex, baseInstance);
}

_MTL_INLINE void MTL::IndirectRenderCommand::reset()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(reset));
}

_MTL_INLINE void MTL::IndirectComputeCommand::setComputePipelineState(const MTL::ComputePipelineState* pipelineState)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setComputePipelineState_), pipelineState);
}

_MTL_INLINE void MTL::IndirectComputeCommand::setKernelBuffer(const MTL::Buffer* buffer, NS::UInteger offset, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setKernelBuffer_offset_atIndex_), buffer, offset, index);
}

_MTL_INLINE void MTL::IndirectComputeCommand::concurrentDispatchThreadgroups(MTL::Size threadgroupsPerGrid, MTL::Size threadsPerThreadgroup)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(concurrentDispatchThreadgroups_threadsPerThreadgroup_), threadgroupsPerGrid, threadsPerThreadgroup);
}

_MTL_INLINE void MTL::IndirectComputeCommand::concurrentDispatchThreads(MTL::Size threadsPerGrid, MTL::Size threadsPerThreadgroup)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(concurrentDispatchThreads_threadsPerThreadgroup_), threadsPerGrid, threadsPerThreadgroup);
}

_MTL_INLINE void MTL::IndirectComputeCommand::setBarrier()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBarrier));
}

_MTL_INLINE void MTL::IndirectComputeCommand::clearBarrier()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(clearBarrier));
}

_MTL_INLINE void MTL::IndirectComputeCommand::setImageblockWidth(NS::UInteger width, NS::UInteger height)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setImageblockWidth_height_), width, height);
}

_MTL_INLINE void MTL::IndirectComputeCommand::reset()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(reset));
}

_MTL_INLINE void MTL::IndirectComputeCommand::setThreadgroupMemoryLength(NS::UInteger length, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setThreadgroupMemoryLength_atIndex_), length, index);
}

_MTL_INLINE void MTL::IndirectComputeCommand::setStageInRegion(MTL::Region region)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStageInRegion_), region);
}

#pragma once

namespace MTL
{
class LinkedFunctions : public NS::Copying<LinkedFunctions>
{
public:
    static class LinkedFunctions* alloc();

    class LinkedFunctions*        init();

    static class LinkedFunctions* linkedFunctions();

    NS::Array*                    functions() const;
    void                          setFunctions(const NS::Array* functions);

    NS::Array*                    binaryFunctions() const;
    void                          setBinaryFunctions(const NS::Array* binaryFunctions);

    NS::Dictionary*               groups() const;
    void                          setGroups(const NS::Dictionary* groups);

    NS::Array*                    privateFunctions() const;
    void                          setPrivateFunctions(const NS::Array* privateFunctions);
};

}

_MTL_INLINE MTL::LinkedFunctions* MTL::LinkedFunctions::alloc()
{
    return NS::Object::alloc<MTL::LinkedFunctions>(_MTL_PRIVATE_CLS(MTLLinkedFunctions));
}

_MTL_INLINE MTL::LinkedFunctions* MTL::LinkedFunctions::init()
{
    return NS::Object::init<MTL::LinkedFunctions>();
}

_MTL_INLINE MTL::LinkedFunctions* MTL::LinkedFunctions::linkedFunctions()
{
    return Object::sendMessage<MTL::LinkedFunctions*>(_MTL_PRIVATE_CLS(MTLLinkedFunctions), _MTL_PRIVATE_SEL(linkedFunctions));
}

_MTL_INLINE NS::Array* MTL::LinkedFunctions::functions() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(functions));
}

_MTL_INLINE void MTL::LinkedFunctions::setFunctions(const NS::Array* functions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFunctions_), functions);
}

_MTL_INLINE NS::Array* MTL::LinkedFunctions::binaryFunctions() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(binaryFunctions));
}

_MTL_INLINE void MTL::LinkedFunctions::setBinaryFunctions(const NS::Array* binaryFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBinaryFunctions_), binaryFunctions);
}

_MTL_INLINE NS::Dictionary* MTL::LinkedFunctions::groups() const
{
    return Object::sendMessage<NS::Dictionary*>(this, _MTL_PRIVATE_SEL(groups));
}

_MTL_INLINE void MTL::LinkedFunctions::setGroups(const NS::Dictionary* groups)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setGroups_), groups);
}

_MTL_INLINE NS::Array* MTL::LinkedFunctions::privateFunctions() const
{
    return Object::sendMessage<NS::Array*>(this, _MTL_PRIVATE_SEL(privateFunctions));
}

_MTL_INLINE void MTL::LinkedFunctions::setPrivateFunctions(const NS::Array* privateFunctions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setPrivateFunctions_), privateFunctions);
}

#pragma once

namespace MTL
{
class ParallelRenderCommandEncoder : public NS::Referencing<ParallelRenderCommandEncoder, CommandEncoder>
{
public:
    class RenderCommandEncoder* renderCommandEncoder();

    void                        setColorStoreAction(MTL::StoreAction storeAction, NS::UInteger colorAttachmentIndex);

    void                        setDepthStoreAction(MTL::StoreAction storeAction);

    void                        setStencilStoreAction(MTL::StoreAction storeAction);

    void                        setColorStoreActionOptions(MTL::StoreActionOptions storeActionOptions, NS::UInteger colorAttachmentIndex);

    void                        setDepthStoreActionOptions(MTL::StoreActionOptions storeActionOptions);

    void                        setStencilStoreActionOptions(MTL::StoreActionOptions storeActionOptions);
};

}

_MTL_INLINE MTL::RenderCommandEncoder* MTL::ParallelRenderCommandEncoder::renderCommandEncoder()
{
    return Object::sendMessage<MTL::RenderCommandEncoder*>(this, _MTL_PRIVATE_SEL(renderCommandEncoder));
}

_MTL_INLINE void MTL::ParallelRenderCommandEncoder::setColorStoreAction(MTL::StoreAction storeAction, NS::UInteger colorAttachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setColorStoreAction_atIndex_), storeAction, colorAttachmentIndex);
}

_MTL_INLINE void MTL::ParallelRenderCommandEncoder::setDepthStoreAction(MTL::StoreAction storeAction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthStoreAction_), storeAction);
}

_MTL_INLINE void MTL::ParallelRenderCommandEncoder::setStencilStoreAction(MTL::StoreAction storeAction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilStoreAction_), storeAction);
}

_MTL_INLINE void MTL::ParallelRenderCommandEncoder::setColorStoreActionOptions(MTL::StoreActionOptions storeActionOptions, NS::UInteger colorAttachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setColorStoreActionOptions_atIndex_), storeActionOptions, colorAttachmentIndex);
}

_MTL_INLINE void MTL::ParallelRenderCommandEncoder::setDepthStoreActionOptions(MTL::StoreActionOptions storeActionOptions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setDepthStoreActionOptions_), storeActionOptions);
}

_MTL_INLINE void MTL::ParallelRenderCommandEncoder::setStencilStoreActionOptions(MTL::StoreActionOptions storeActionOptions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStencilStoreActionOptions_), storeActionOptions);
}

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, Mutability) {
    MutabilityDefault = 0,
    MutabilityMutable = 1,
    MutabilityImmutable = 2,
};

class PipelineBufferDescriptor : public NS::Copying<PipelineBufferDescriptor>
{
public:
    static class PipelineBufferDescriptor* alloc();

    class PipelineBufferDescriptor*        init();

    MTL::Mutability                        mutability() const;
    void                                   setMutability(MTL::Mutability mutability);
};

class PipelineBufferDescriptorArray : public NS::Referencing<PipelineBufferDescriptorArray>
{
public:
    static class PipelineBufferDescriptorArray* alloc();

    class PipelineBufferDescriptorArray*        init();

    class PipelineBufferDescriptor*             object(NS::UInteger bufferIndex);

    void                                        setObject(const class PipelineBufferDescriptor* buffer, NS::UInteger bufferIndex);
};

}

_MTL_INLINE MTL::PipelineBufferDescriptor* MTL::PipelineBufferDescriptor::alloc()
{
    return NS::Object::alloc<MTL::PipelineBufferDescriptor>(_MTL_PRIVATE_CLS(MTLPipelineBufferDescriptor));
}

_MTL_INLINE MTL::PipelineBufferDescriptor* MTL::PipelineBufferDescriptor::init()
{
    return NS::Object::init<MTL::PipelineBufferDescriptor>();
}

_MTL_INLINE MTL::Mutability MTL::PipelineBufferDescriptor::mutability() const
{
    return Object::sendMessage<MTL::Mutability>(this, _MTL_PRIVATE_SEL(mutability));
}

_MTL_INLINE void MTL::PipelineBufferDescriptor::setMutability(MTL::Mutability mutability)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setMutability_), mutability);
}

_MTL_INLINE MTL::PipelineBufferDescriptorArray* MTL::PipelineBufferDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::PipelineBufferDescriptorArray>(_MTL_PRIVATE_CLS(MTLPipelineBufferDescriptorArray));
}

_MTL_INLINE MTL::PipelineBufferDescriptorArray* MTL::PipelineBufferDescriptorArray::init()
{
    return NS::Object::init<MTL::PipelineBufferDescriptorArray>();
}

_MTL_INLINE MTL::PipelineBufferDescriptor* MTL::PipelineBufferDescriptorArray::object(NS::UInteger bufferIndex)
{
    return Object::sendMessage<MTL::PipelineBufferDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), bufferIndex);
}

_MTL_INLINE void MTL::PipelineBufferDescriptorArray::setObject(const MTL::PipelineBufferDescriptor* buffer, NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), buffer, bufferIndex);
}

#pragma once

namespace MTL
{
class RasterizationRateSampleArray : public NS::Referencing<RasterizationRateSampleArray>
{
public:
    static class RasterizationRateSampleArray* alloc();

    class RasterizationRateSampleArray*        init();

    NS::Number*                                object(NS::UInteger index);

    void                                       setObject(const NS::Number* value, NS::UInteger index);
};

class RasterizationRateLayerDescriptor : public NS::Copying<RasterizationRateLayerDescriptor>
{
public:
    static class RasterizationRateLayerDescriptor* alloc();

    MTL::RasterizationRateLayerDescriptor*         init();

    MTL::RasterizationRateLayerDescriptor*         init(MTL::Size sampleCount);

    MTL::RasterizationRateLayerDescriptor*         init(MTL::Size sampleCount, const float* horizontal, const float* vertical);

    MTL::Size                                      sampleCount() const;

    MTL::Size                                      maxSampleCount() const;

    float*                                         horizontalSampleStorage() const;

    float*                                         verticalSampleStorage() const;

    class RasterizationRateSampleArray*            horizontal() const;

    class RasterizationRateSampleArray*            vertical() const;

    void                                           setSampleCount(MTL::Size sampleCount);
};

class RasterizationRateLayerArray : public NS::Referencing<RasterizationRateLayerArray>
{
public:
    static class RasterizationRateLayerArray* alloc();

    class RasterizationRateLayerArray*        init();

    class RasterizationRateLayerDescriptor*   object(NS::UInteger layerIndex);

    void                                      setObject(const class RasterizationRateLayerDescriptor* layer, NS::UInteger layerIndex);
};

class RasterizationRateMapDescriptor : public NS::Copying<RasterizationRateMapDescriptor>
{
public:
    static class RasterizationRateMapDescriptor* alloc();

    class RasterizationRateMapDescriptor*        init();

    static class RasterizationRateMapDescriptor* rasterizationRateMapDescriptor(MTL::Size screenSize);

    static class RasterizationRateMapDescriptor* rasterizationRateMapDescriptor(MTL::Size screenSize, const class RasterizationRateLayerDescriptor* layer);

    static class RasterizationRateMapDescriptor* rasterizationRateMapDescriptor(MTL::Size screenSize, NS::UInteger layerCount, MTL::RasterizationRateLayerDescriptor* const* layers);

    class RasterizationRateLayerDescriptor*      layer(NS::UInteger layerIndex);

    void                                         setLayer(const class RasterizationRateLayerDescriptor* layer, NS::UInteger layerIndex);

    class RasterizationRateLayerArray*           layers() const;

    MTL::Size                                    screenSize() const;
    void                                         setScreenSize(MTL::Size screenSize);

    NS::String*                                  label() const;
    void                                         setLabel(const NS::String* label);

    NS::UInteger                                 layerCount() const;
};

class RasterizationRateMap : public NS::Referencing<RasterizationRateMap>
{
public:
    class Device*     device() const;

    NS::String*       label() const;

    MTL::Size         screenSize() const;

    MTL::Size         physicalGranularity() const;

    NS::UInteger      layerCount() const;

    MTL::SizeAndAlign parameterBufferSizeAndAlign() const;

    void              copyParameterDataToBuffer(const class Buffer* buffer, NS::UInteger offset);

    MTL::Size         physicalSize(NS::UInteger layerIndex);

    MTL::Coordinate2D mapScreenToPhysicalCoordinates(MTL::Coordinate2D screenCoordinates, NS::UInteger layerIndex);

    MTL::Coordinate2D mapPhysicalToScreenCoordinates(MTL::Coordinate2D physicalCoordinates, NS::UInteger layerIndex);
};

}

_MTL_INLINE MTL::RasterizationRateSampleArray* MTL::RasterizationRateSampleArray::alloc()
{
    return NS::Object::alloc<MTL::RasterizationRateSampleArray>(_MTL_PRIVATE_CLS(MTLRasterizationRateSampleArray));
}

_MTL_INLINE MTL::RasterizationRateSampleArray* MTL::RasterizationRateSampleArray::init()
{
    return NS::Object::init<MTL::RasterizationRateSampleArray>();
}

_MTL_INLINE NS::Number* MTL::RasterizationRateSampleArray::object(NS::UInteger index)
{
    return Object::sendMessage<NS::Number*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), index);
}

_MTL_INLINE void MTL::RasterizationRateSampleArray::setObject(const NS::Number* value, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), value, index);
}

_MTL_INLINE MTL::RasterizationRateLayerDescriptor* MTL::RasterizationRateLayerDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RasterizationRateLayerDescriptor>(_MTL_PRIVATE_CLS(MTLRasterizationRateLayerDescriptor));
}

_MTL_INLINE MTL::RasterizationRateLayerDescriptor* MTL::RasterizationRateLayerDescriptor::init()
{
    return NS::Object::init<MTL::RasterizationRateLayerDescriptor>();
}

_MTL_INLINE MTL::RasterizationRateLayerDescriptor* MTL::RasterizationRateLayerDescriptor::init(MTL::Size sampleCount)
{
    return Object::sendMessage<MTL::RasterizationRateLayerDescriptor*>(this, _MTL_PRIVATE_SEL(initWithSampleCount_), sampleCount);
}

_MTL_INLINE MTL::RasterizationRateLayerDescriptor* MTL::RasterizationRateLayerDescriptor::init(MTL::Size sampleCount, const float* horizontal, const float* vertical)
{
    return Object::sendMessage<MTL::RasterizationRateLayerDescriptor*>(this, _MTL_PRIVATE_SEL(initWithSampleCount_horizontal_vertical_), sampleCount, horizontal, vertical);
}

_MTL_INLINE MTL::Size MTL::RasterizationRateLayerDescriptor::sampleCount() const
{
    return Object::sendMessage<MTL::Size>(this, _MTL_PRIVATE_SEL(sampleCount));
}

_MTL_INLINE MTL::Size MTL::RasterizationRateLayerDescriptor::maxSampleCount() const
{
    return Object::sendMessage<MTL::Size>(this, _MTL_PRIVATE_SEL(maxSampleCount));
}

_MTL_INLINE float* MTL::RasterizationRateLayerDescriptor::horizontalSampleStorage() const
{
    return Object::sendMessage<float*>(this, _MTL_PRIVATE_SEL(horizontalSampleStorage));
}

_MTL_INLINE float* MTL::RasterizationRateLayerDescriptor::verticalSampleStorage() const
{
    return Object::sendMessage<float*>(this, _MTL_PRIVATE_SEL(verticalSampleStorage));
}

_MTL_INLINE MTL::RasterizationRateSampleArray* MTL::RasterizationRateLayerDescriptor::horizontal() const
{
    return Object::sendMessage<MTL::RasterizationRateSampleArray*>(this, _MTL_PRIVATE_SEL(horizontal));
}

_MTL_INLINE MTL::RasterizationRateSampleArray* MTL::RasterizationRateLayerDescriptor::vertical() const
{
    return Object::sendMessage<MTL::RasterizationRateSampleArray*>(this, _MTL_PRIVATE_SEL(vertical));
}

_MTL_INLINE void MTL::RasterizationRateLayerDescriptor::setSampleCount(MTL::Size sampleCount)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSampleCount_), sampleCount);
}

_MTL_INLINE MTL::RasterizationRateLayerArray* MTL::RasterizationRateLayerArray::alloc()
{
    return NS::Object::alloc<MTL::RasterizationRateLayerArray>(_MTL_PRIVATE_CLS(MTLRasterizationRateLayerArray));
}

_MTL_INLINE MTL::RasterizationRateLayerArray* MTL::RasterizationRateLayerArray::init()
{
    return NS::Object::init<MTL::RasterizationRateLayerArray>();
}

_MTL_INLINE MTL::RasterizationRateLayerDescriptor* MTL::RasterizationRateLayerArray::object(NS::UInteger layerIndex)
{
    return Object::sendMessage<MTL::RasterizationRateLayerDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), layerIndex);
}

_MTL_INLINE void MTL::RasterizationRateLayerArray::setObject(const MTL::RasterizationRateLayerDescriptor* layer, NS::UInteger layerIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), layer, layerIndex);
}

_MTL_INLINE MTL::RasterizationRateMapDescriptor* MTL::RasterizationRateMapDescriptor::alloc()
{
    return NS::Object::alloc<MTL::RasterizationRateMapDescriptor>(_MTL_PRIVATE_CLS(MTLRasterizationRateMapDescriptor));
}

_MTL_INLINE MTL::RasterizationRateMapDescriptor* MTL::RasterizationRateMapDescriptor::init()
{
    return NS::Object::init<MTL::RasterizationRateMapDescriptor>();
}

_MTL_INLINE MTL::RasterizationRateMapDescriptor* MTL::RasterizationRateMapDescriptor::rasterizationRateMapDescriptor(MTL::Size screenSize)
{
    return Object::sendMessage<MTL::RasterizationRateMapDescriptor*>(_MTL_PRIVATE_CLS(MTLRasterizationRateMapDescriptor), _MTL_PRIVATE_SEL(rasterizationRateMapDescriptorWithScreenSize_), screenSize);
}

_MTL_INLINE MTL::RasterizationRateMapDescriptor* MTL::RasterizationRateMapDescriptor::rasterizationRateMapDescriptor(MTL::Size screenSize, const MTL::RasterizationRateLayerDescriptor* layer)
{
    return Object::sendMessage<MTL::RasterizationRateMapDescriptor*>(_MTL_PRIVATE_CLS(MTLRasterizationRateMapDescriptor), _MTL_PRIVATE_SEL(rasterizationRateMapDescriptorWithScreenSize_layer_), screenSize, layer);
}

_MTL_INLINE MTL::RasterizationRateMapDescriptor* MTL::RasterizationRateMapDescriptor::rasterizationRateMapDescriptor(MTL::Size screenSize, NS::UInteger layerCount, MTL::RasterizationRateLayerDescriptor* const* layers)
{
    return Object::sendMessage<MTL::RasterizationRateMapDescriptor*>(_MTL_PRIVATE_CLS(MTLRasterizationRateMapDescriptor), _MTL_PRIVATE_SEL(rasterizationRateMapDescriptorWithScreenSize_layerCount_layers_), screenSize, layerCount, layers);
}

_MTL_INLINE MTL::RasterizationRateLayerDescriptor* MTL::RasterizationRateMapDescriptor::layer(NS::UInteger layerIndex)
{
    return Object::sendMessage<MTL::RasterizationRateLayerDescriptor*>(this, _MTL_PRIVATE_SEL(layerAtIndex_), layerIndex);
}

_MTL_INLINE void MTL::RasterizationRateMapDescriptor::setLayer(const MTL::RasterizationRateLayerDescriptor* layer, NS::UInteger layerIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLayer_atIndex_), layer, layerIndex);
}

_MTL_INLINE MTL::RasterizationRateLayerArray* MTL::RasterizationRateMapDescriptor::layers() const
{
    return Object::sendMessage<MTL::RasterizationRateLayerArray*>(this, _MTL_PRIVATE_SEL(layers));
}

_MTL_INLINE MTL::Size MTL::RasterizationRateMapDescriptor::screenSize() const
{
    return Object::sendMessage<MTL::Size>(this, _MTL_PRIVATE_SEL(screenSize));
}

_MTL_INLINE void MTL::RasterizationRateMapDescriptor::setScreenSize(MTL::Size screenSize)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setScreenSize_), screenSize);
}

_MTL_INLINE NS::String* MTL::RasterizationRateMapDescriptor::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE void MTL::RasterizationRateMapDescriptor::setLabel(const NS::String* label)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setLabel_), label);
}

_MTL_INLINE NS::UInteger MTL::RasterizationRateMapDescriptor::layerCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(layerCount));
}

_MTL_INLINE MTL::Device* MTL::RasterizationRateMap::device() const
{
    return Object::sendMessage<MTL::Device*>(this, _MTL_PRIVATE_SEL(device));
}

_MTL_INLINE NS::String* MTL::RasterizationRateMap::label() const
{
    return Object::sendMessage<NS::String*>(this, _MTL_PRIVATE_SEL(label));
}

_MTL_INLINE MTL::Size MTL::RasterizationRateMap::screenSize() const
{
    return Object::sendMessage<MTL::Size>(this, _MTL_PRIVATE_SEL(screenSize));
}

_MTL_INLINE MTL::Size MTL::RasterizationRateMap::physicalGranularity() const
{
    return Object::sendMessage<MTL::Size>(this, _MTL_PRIVATE_SEL(physicalGranularity));
}

_MTL_INLINE NS::UInteger MTL::RasterizationRateMap::layerCount() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(layerCount));
}

_MTL_INLINE MTL::SizeAndAlign MTL::RasterizationRateMap::parameterBufferSizeAndAlign() const
{
    return Object::sendMessage<MTL::SizeAndAlign>(this, _MTL_PRIVATE_SEL(parameterBufferSizeAndAlign));
}

_MTL_INLINE void MTL::RasterizationRateMap::copyParameterDataToBuffer(const MTL::Buffer* buffer, NS::UInteger offset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(copyParameterDataToBuffer_offset_), buffer, offset);
}

_MTL_INLINE MTL::Size MTL::RasterizationRateMap::physicalSize(NS::UInteger layerIndex)
{
    return Object::sendMessage<MTL::Size>(this, _MTL_PRIVATE_SEL(physicalSizeForLayer_), layerIndex);
}

_MTL_INLINE MTL::Coordinate2D MTL::RasterizationRateMap::mapScreenToPhysicalCoordinates(MTL::Coordinate2D screenCoordinates, NS::UInteger layerIndex)
{
    return Object::sendMessage<MTL::Coordinate2D>(this, _MTL_PRIVATE_SEL(mapScreenToPhysicalCoordinates_forLayer_), screenCoordinates, layerIndex);
}

_MTL_INLINE MTL::Coordinate2D MTL::RasterizationRateMap::mapPhysicalToScreenCoordinates(MTL::Coordinate2D physicalCoordinates, NS::UInteger layerIndex)
{
    return Object::sendMessage<MTL::Coordinate2D>(this, _MTL_PRIVATE_SEL(mapPhysicalToScreenCoordinates_forLayer_), physicalCoordinates, layerIndex);
}

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, SparseTextureMappingMode) {
    SparseTextureMappingModeMap = 0,
    SparseTextureMappingModeUnmap = 1,
};

struct MapIndirectArguments
{
    uint32_t regionOriginX;
    uint32_t regionOriginY;
    uint32_t regionOriginZ;
    uint32_t regionSizeWidth;
    uint32_t regionSizeHeight;
    uint32_t regionSizeDepth;
    uint32_t mipMapLevel;
    uint32_t sliceId;
} _MTL_PACKED;

class ResourceStateCommandEncoder : public NS::Referencing<ResourceStateCommandEncoder, CommandEncoder>
{
public:
    void updateTextureMappings(const class Texture* texture, const MTL::SparseTextureMappingMode mode, const MTL::Region* regions, const NS::UInteger* mipLevels, const NS::UInteger* slices, NS::UInteger numRegions);

    void updateTextureMapping(const class Texture* texture, const MTL::SparseTextureMappingMode mode, const MTL::Region region, const NS::UInteger mipLevel, const NS::UInteger slice);

    void updateTextureMapping(const class Texture* texture, const MTL::SparseTextureMappingMode mode, const class Buffer* indirectBuffer, NS::UInteger indirectBufferOffset);

    void updateFence(const class Fence* fence);

    void waitForFence(const class Fence* fence);
};

}

_MTL_INLINE void MTL::ResourceStateCommandEncoder::updateTextureMappings(const MTL::Texture* texture, const MTL::SparseTextureMappingMode mode, const MTL::Region* regions, const NS::UInteger* mipLevels, const NS::UInteger* slices, NS::UInteger numRegions)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(updateTextureMappings_mode_regions_mipLevels_slices_numRegions_), texture, mode, regions, mipLevels, slices, numRegions);
}

_MTL_INLINE void MTL::ResourceStateCommandEncoder::updateTextureMapping(const MTL::Texture* texture, const MTL::SparseTextureMappingMode mode, const MTL::Region region, const NS::UInteger mipLevel, const NS::UInteger slice)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(updateTextureMapping_mode_region_mipLevel_slice_), texture, mode, region, mipLevel, slice);
}

_MTL_INLINE void MTL::ResourceStateCommandEncoder::updateTextureMapping(const MTL::Texture* texture, const MTL::SparseTextureMappingMode mode, const MTL::Buffer* indirectBuffer, NS::UInteger indirectBufferOffset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(updateTextureMapping_mode_indirectBuffer_indirectBufferOffset_), texture, mode, indirectBuffer, indirectBufferOffset);
}

_MTL_INLINE void MTL::ResourceStateCommandEncoder::updateFence(const MTL::Fence* fence)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(updateFence_), fence);
}

_MTL_INLINE void MTL::ResourceStateCommandEncoder::waitForFence(const MTL::Fence* fence)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(waitForFence_), fence);
}

#pragma once

namespace MTL
{
class ResourceStatePassSampleBufferAttachmentDescriptor : public NS::Copying<ResourceStatePassSampleBufferAttachmentDescriptor>
{
public:
    static class ResourceStatePassSampleBufferAttachmentDescriptor* alloc();

    class ResourceStatePassSampleBufferAttachmentDescriptor*        init();

    class CounterSampleBuffer*                                      sampleBuffer() const;
    void                                                            setSampleBuffer(const class CounterSampleBuffer* sampleBuffer);

    NS::UInteger                                                    startOfEncoderSampleIndex() const;
    void                                                            setStartOfEncoderSampleIndex(NS::UInteger startOfEncoderSampleIndex);

    NS::UInteger                                                    endOfEncoderSampleIndex() const;
    void                                                            setEndOfEncoderSampleIndex(NS::UInteger endOfEncoderSampleIndex);
};

class ResourceStatePassSampleBufferAttachmentDescriptorArray : public NS::Referencing<ResourceStatePassSampleBufferAttachmentDescriptorArray>
{
public:
    static class ResourceStatePassSampleBufferAttachmentDescriptorArray* alloc();

    class ResourceStatePassSampleBufferAttachmentDescriptorArray*        init();

    class ResourceStatePassSampleBufferAttachmentDescriptor*             object(NS::UInteger attachmentIndex);

    void                                                                 setObject(const class ResourceStatePassSampleBufferAttachmentDescriptor* attachment, NS::UInteger attachmentIndex);
};

class ResourceStatePassDescriptor : public NS::Copying<ResourceStatePassDescriptor>
{
public:
    static class ResourceStatePassDescriptor*                     alloc();

    class ResourceStatePassDescriptor*                            init();

    static class ResourceStatePassDescriptor*                     resourceStatePassDescriptor();

    class ResourceStatePassSampleBufferAttachmentDescriptorArray* sampleBufferAttachments() const;
};

}

_MTL_INLINE MTL::ResourceStatePassSampleBufferAttachmentDescriptor* MTL::ResourceStatePassSampleBufferAttachmentDescriptor::alloc()
{
    return NS::Object::alloc<MTL::ResourceStatePassSampleBufferAttachmentDescriptor>(_MTL_PRIVATE_CLS(MTLResourceStatePassSampleBufferAttachmentDescriptor));
}

_MTL_INLINE MTL::ResourceStatePassSampleBufferAttachmentDescriptor* MTL::ResourceStatePassSampleBufferAttachmentDescriptor::init()
{
    return NS::Object::init<MTL::ResourceStatePassSampleBufferAttachmentDescriptor>();
}

_MTL_INLINE MTL::CounterSampleBuffer* MTL::ResourceStatePassSampleBufferAttachmentDescriptor::sampleBuffer() const
{
    return Object::sendMessage<MTL::CounterSampleBuffer*>(this, _MTL_PRIVATE_SEL(sampleBuffer));
}

_MTL_INLINE void MTL::ResourceStatePassSampleBufferAttachmentDescriptor::setSampleBuffer(const MTL::CounterSampleBuffer* sampleBuffer)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setSampleBuffer_), sampleBuffer);
}

_MTL_INLINE NS::UInteger MTL::ResourceStatePassSampleBufferAttachmentDescriptor::startOfEncoderSampleIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(startOfEncoderSampleIndex));
}

_MTL_INLINE void MTL::ResourceStatePassSampleBufferAttachmentDescriptor::setStartOfEncoderSampleIndex(NS::UInteger startOfEncoderSampleIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStartOfEncoderSampleIndex_), startOfEncoderSampleIndex);
}

_MTL_INLINE NS::UInteger MTL::ResourceStatePassSampleBufferAttachmentDescriptor::endOfEncoderSampleIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(endOfEncoderSampleIndex));
}

_MTL_INLINE void MTL::ResourceStatePassSampleBufferAttachmentDescriptor::setEndOfEncoderSampleIndex(NS::UInteger endOfEncoderSampleIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setEndOfEncoderSampleIndex_), endOfEncoderSampleIndex);
}

_MTL_INLINE MTL::ResourceStatePassSampleBufferAttachmentDescriptorArray* MTL::ResourceStatePassSampleBufferAttachmentDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::ResourceStatePassSampleBufferAttachmentDescriptorArray>(_MTL_PRIVATE_CLS(MTLResourceStatePassSampleBufferAttachmentDescriptorArray));
}

_MTL_INLINE MTL::ResourceStatePassSampleBufferAttachmentDescriptorArray* MTL::ResourceStatePassSampleBufferAttachmentDescriptorArray::init()
{
    return NS::Object::init<MTL::ResourceStatePassSampleBufferAttachmentDescriptorArray>();
}

_MTL_INLINE MTL::ResourceStatePassSampleBufferAttachmentDescriptor* MTL::ResourceStatePassSampleBufferAttachmentDescriptorArray::object(NS::UInteger attachmentIndex)
{
    return Object::sendMessage<MTL::ResourceStatePassSampleBufferAttachmentDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), attachmentIndex);
}

_MTL_INLINE void MTL::ResourceStatePassSampleBufferAttachmentDescriptorArray::setObject(const MTL::ResourceStatePassSampleBufferAttachmentDescriptor* attachment, NS::UInteger attachmentIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), attachment, attachmentIndex);
}

_MTL_INLINE MTL::ResourceStatePassDescriptor* MTL::ResourceStatePassDescriptor::alloc()
{
    return NS::Object::alloc<MTL::ResourceStatePassDescriptor>(_MTL_PRIVATE_CLS(MTLResourceStatePassDescriptor));
}

_MTL_INLINE MTL::ResourceStatePassDescriptor* MTL::ResourceStatePassDescriptor::init()
{
    return NS::Object::init<MTL::ResourceStatePassDescriptor>();
}

_MTL_INLINE MTL::ResourceStatePassDescriptor* MTL::ResourceStatePassDescriptor::resourceStatePassDescriptor()
{
    return Object::sendMessage<MTL::ResourceStatePassDescriptor*>(_MTL_PRIVATE_CLS(MTLResourceStatePassDescriptor), _MTL_PRIVATE_SEL(resourceStatePassDescriptor));
}

_MTL_INLINE MTL::ResourceStatePassSampleBufferAttachmentDescriptorArray* MTL::ResourceStatePassDescriptor::sampleBufferAttachments() const
{
    return Object::sendMessage<MTL::ResourceStatePassSampleBufferAttachmentDescriptorArray*>(this, _MTL_PRIVATE_SEL(sampleBufferAttachments));
}

#pragma once

namespace MTL
{
_MTL_ENUM(NS::UInteger, VertexFormat) {
    VertexFormatInvalid = 0,
    VertexFormatUChar2 = 1,
    VertexFormatUChar3 = 2,
    VertexFormatUChar4 = 3,
    VertexFormatChar2 = 4,
    VertexFormatChar3 = 5,
    VertexFormatChar4 = 6,
    VertexFormatUChar2Normalized = 7,
    VertexFormatUChar3Normalized = 8,
    VertexFormatUChar4Normalized = 9,
    VertexFormatChar2Normalized = 10,
    VertexFormatChar3Normalized = 11,
    VertexFormatChar4Normalized = 12,
    VertexFormatUShort2 = 13,
    VertexFormatUShort3 = 14,
    VertexFormatUShort4 = 15,
    VertexFormatShort2 = 16,
    VertexFormatShort3 = 17,
    VertexFormatShort4 = 18,
    VertexFormatUShort2Normalized = 19,
    VertexFormatUShort3Normalized = 20,
    VertexFormatUShort4Normalized = 21,
    VertexFormatShort2Normalized = 22,
    VertexFormatShort3Normalized = 23,
    VertexFormatShort4Normalized = 24,
    VertexFormatHalf2 = 25,
    VertexFormatHalf3 = 26,
    VertexFormatHalf4 = 27,
    VertexFormatFloat = 28,
    VertexFormatFloat2 = 29,
    VertexFormatFloat3 = 30,
    VertexFormatFloat4 = 31,
    VertexFormatInt = 32,
    VertexFormatInt2 = 33,
    VertexFormatInt3 = 34,
    VertexFormatInt4 = 35,
    VertexFormatUInt = 36,
    VertexFormatUInt2 = 37,
    VertexFormatUInt3 = 38,
    VertexFormatUInt4 = 39,
    VertexFormatInt1010102Normalized = 40,
    VertexFormatUInt1010102Normalized = 41,
    VertexFormatUChar4Normalized_BGRA = 42,
    VertexFormatUChar = 45,
    VertexFormatChar = 46,
    VertexFormatUCharNormalized = 47,
    VertexFormatCharNormalized = 48,
    VertexFormatUShort = 49,
    VertexFormatShort = 50,
    VertexFormatUShortNormalized = 51,
    VertexFormatShortNormalized = 52,
    VertexFormatHalf = 53,
};

_MTL_ENUM(NS::UInteger, VertexStepFunction) {
    VertexStepFunctionConstant = 0,
    VertexStepFunctionPerVertex = 1,
    VertexStepFunctionPerInstance = 2,
    VertexStepFunctionPerPatch = 3,
    VertexStepFunctionPerPatchControlPoint = 4,
};

class VertexBufferLayoutDescriptor : public NS::Copying<VertexBufferLayoutDescriptor>
{
public:
    static class VertexBufferLayoutDescriptor* alloc();

    class VertexBufferLayoutDescriptor*        init();

    NS::UInteger                               stride() const;
    void                                       setStride(NS::UInteger stride);

    MTL::VertexStepFunction                    stepFunction() const;
    void                                       setStepFunction(MTL::VertexStepFunction stepFunction);

    NS::UInteger                               stepRate() const;
    void                                       setStepRate(NS::UInteger stepRate);
};

class VertexBufferLayoutDescriptorArray : public NS::Referencing<VertexBufferLayoutDescriptorArray>
{
public:
    static class VertexBufferLayoutDescriptorArray* alloc();

    class VertexBufferLayoutDescriptorArray*        init();

    class VertexBufferLayoutDescriptor*             object(NS::UInteger index);

    void                                            setObject(const class VertexBufferLayoutDescriptor* bufferDesc, NS::UInteger index);
};

class VertexAttributeDescriptor : public NS::Copying<VertexAttributeDescriptor>
{
public:
    static class VertexAttributeDescriptor* alloc();

    class VertexAttributeDescriptor*        init();

    MTL::VertexFormat                       format() const;
    void                                    setFormat(MTL::VertexFormat format);

    NS::UInteger                            offset() const;
    void                                    setOffset(NS::UInteger offset);

    NS::UInteger                            bufferIndex() const;
    void                                    setBufferIndex(NS::UInteger bufferIndex);
};

class VertexAttributeDescriptorArray : public NS::Referencing<VertexAttributeDescriptorArray>
{
public:
    static class VertexAttributeDescriptorArray* alloc();

    class VertexAttributeDescriptorArray*        init();

    class VertexAttributeDescriptor*             object(NS::UInteger index);

    void                                         setObject(const class VertexAttributeDescriptor* attributeDesc, NS::UInteger index);
};

class VertexDescriptor : public NS::Copying<VertexDescriptor>
{
public:
    static class VertexDescriptor*           alloc();

    class VertexDescriptor*                  init();

    static class VertexDescriptor*           vertexDescriptor();

    class VertexBufferLayoutDescriptorArray* layouts() const;

    class VertexAttributeDescriptorArray*    attributes() const;

    void                                     reset();
};

}

_MTL_INLINE MTL::VertexBufferLayoutDescriptor* MTL::VertexBufferLayoutDescriptor::alloc()
{
    return NS::Object::alloc<MTL::VertexBufferLayoutDescriptor>(_MTL_PRIVATE_CLS(MTLVertexBufferLayoutDescriptor));
}

_MTL_INLINE MTL::VertexBufferLayoutDescriptor* MTL::VertexBufferLayoutDescriptor::init()
{
    return NS::Object::init<MTL::VertexBufferLayoutDescriptor>();
}

_MTL_INLINE NS::UInteger MTL::VertexBufferLayoutDescriptor::stride() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(stride));
}

_MTL_INLINE void MTL::VertexBufferLayoutDescriptor::setStride(NS::UInteger stride)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStride_), stride);
}

_MTL_INLINE MTL::VertexStepFunction MTL::VertexBufferLayoutDescriptor::stepFunction() const
{
    return Object::sendMessage<MTL::VertexStepFunction>(this, _MTL_PRIVATE_SEL(stepFunction));
}

_MTL_INLINE void MTL::VertexBufferLayoutDescriptor::setStepFunction(MTL::VertexStepFunction stepFunction)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStepFunction_), stepFunction);
}

_MTL_INLINE NS::UInteger MTL::VertexBufferLayoutDescriptor::stepRate() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(stepRate));
}

_MTL_INLINE void MTL::VertexBufferLayoutDescriptor::setStepRate(NS::UInteger stepRate)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setStepRate_), stepRate);
}

_MTL_INLINE MTL::VertexBufferLayoutDescriptorArray* MTL::VertexBufferLayoutDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::VertexBufferLayoutDescriptorArray>(_MTL_PRIVATE_CLS(MTLVertexBufferLayoutDescriptorArray));
}

_MTL_INLINE MTL::VertexBufferLayoutDescriptorArray* MTL::VertexBufferLayoutDescriptorArray::init()
{
    return NS::Object::init<MTL::VertexBufferLayoutDescriptorArray>();
}

_MTL_INLINE MTL::VertexBufferLayoutDescriptor* MTL::VertexBufferLayoutDescriptorArray::object(NS::UInteger index)
{
    return Object::sendMessage<MTL::VertexBufferLayoutDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), index);
}

_MTL_INLINE void MTL::VertexBufferLayoutDescriptorArray::setObject(const MTL::VertexBufferLayoutDescriptor* bufferDesc, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), bufferDesc, index);
}

_MTL_INLINE MTL::VertexAttributeDescriptor* MTL::VertexAttributeDescriptor::alloc()
{
    return NS::Object::alloc<MTL::VertexAttributeDescriptor>(_MTL_PRIVATE_CLS(MTLVertexAttributeDescriptor));
}

_MTL_INLINE MTL::VertexAttributeDescriptor* MTL::VertexAttributeDescriptor::init()
{
    return NS::Object::init<MTL::VertexAttributeDescriptor>();
}

_MTL_INLINE MTL::VertexFormat MTL::VertexAttributeDescriptor::format() const
{
    return Object::sendMessage<MTL::VertexFormat>(this, _MTL_PRIVATE_SEL(format));
}

_MTL_INLINE void MTL::VertexAttributeDescriptor::setFormat(MTL::VertexFormat format)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setFormat_), format);
}

_MTL_INLINE NS::UInteger MTL::VertexAttributeDescriptor::offset() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(offset));
}

_MTL_INLINE void MTL::VertexAttributeDescriptor::setOffset(NS::UInteger offset)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setOffset_), offset);
}

_MTL_INLINE NS::UInteger MTL::VertexAttributeDescriptor::bufferIndex() const
{
    return Object::sendMessage<NS::UInteger>(this, _MTL_PRIVATE_SEL(bufferIndex));
}

_MTL_INLINE void MTL::VertexAttributeDescriptor::setBufferIndex(NS::UInteger bufferIndex)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setBufferIndex_), bufferIndex);
}

_MTL_INLINE MTL::VertexAttributeDescriptorArray* MTL::VertexAttributeDescriptorArray::alloc()
{
    return NS::Object::alloc<MTL::VertexAttributeDescriptorArray>(_MTL_PRIVATE_CLS(MTLVertexAttributeDescriptorArray));
}

_MTL_INLINE MTL::VertexAttributeDescriptorArray* MTL::VertexAttributeDescriptorArray::init()
{
    return NS::Object::init<MTL::VertexAttributeDescriptorArray>();
}

_MTL_INLINE MTL::VertexAttributeDescriptor* MTL::VertexAttributeDescriptorArray::object(NS::UInteger index)
{
    return Object::sendMessage<MTL::VertexAttributeDescriptor*>(this, _MTL_PRIVATE_SEL(objectAtIndexedSubscript_), index);
}

_MTL_INLINE void MTL::VertexAttributeDescriptorArray::setObject(const MTL::VertexAttributeDescriptor* attributeDesc, NS::UInteger index)
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(setObject_atIndexedSubscript_), attributeDesc, index);
}

_MTL_INLINE MTL::VertexDescriptor* MTL::VertexDescriptor::alloc()
{
    return NS::Object::alloc<MTL::VertexDescriptor>(_MTL_PRIVATE_CLS(MTLVertexDescriptor));
}

_MTL_INLINE MTL::VertexDescriptor* MTL::VertexDescriptor::init()
{
    return NS::Object::init<MTL::VertexDescriptor>();
}

_MTL_INLINE MTL::VertexDescriptor* MTL::VertexDescriptor::vertexDescriptor()
{
    return Object::sendMessage<MTL::VertexDescriptor*>(_MTL_PRIVATE_CLS(MTLVertexDescriptor), _MTL_PRIVATE_SEL(vertexDescriptor));
}

_MTL_INLINE MTL::VertexBufferLayoutDescriptorArray* MTL::VertexDescriptor::layouts() const
{
    return Object::sendMessage<MTL::VertexBufferLayoutDescriptorArray*>(this, _MTL_PRIVATE_SEL(layouts));
}

_MTL_INLINE MTL::VertexAttributeDescriptorArray* MTL::VertexDescriptor::attributes() const
{
    return Object::sendMessage<MTL::VertexAttributeDescriptorArray*>(this, _MTL_PRIVATE_SEL(attributes));
}

_MTL_INLINE void MTL::VertexDescriptor::reset()
{
    Object::sendMessage<void>(this, _MTL_PRIVATE_SEL(reset));
}

