\name{install.packages2}
\alias{install.packages2}
\alias{remove.packages2}
\alias{update.packages2}
\alias{checkPrevRepos}
\alias{baseFileSelect}
\alias{handleDownloadedFile}
\alias{installPkg}
\alias{buildRepList}
\alias{installPkgListing}
\alias{getMaxVersReposInfo}
\title{Functions to download, install and manipulate local packages}
\description{
  These functions are designed to allow the user to
  install, update and download packages from R repositories, as well as
  remove packages from their local system.
}
\usage{
install.packages2(pkgs = NULL, repEntry = NULL, lib, versions, type,
                 method = "auto", theme= NULL, recurse = TRUE, searchOptions =
                 FALSE, getNewest = TRUE, force = FALSE, versForce =
                 TRUE, getAllDeps = FALSE, fileSelect =
                 baseFileSelect, develOK=FALSE)
update.packages2(pkgs = NULL, repEntry = NULL, theme = NULL, libs =
                 reposToolsLibPaths(), type, method = "auto",
                 prevRepos = TRUE, recurse = TRUE, searchOptions =
                 FALSE, force = FALSE, versForce = TRUE, getAllDeps =
                 FALSE, develOK=FALSE)
remove.packages2(pkgs, lib, force=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{repEntry}{A ReposEntry object specifying a particular repository}
  \item{pkgs}{A character vector of package name(s) to act upon}
  \item{theme}{A character vector of repository theme(s) to install}
  \item{versions}{A character vector of version numbers for the packages}
  \item{lib}{A path to install (or remove from) the package.  If this
    directory does not exist, it will be created (if possible).  If this
  directory is not in the user's current \code{.libPaths()}, it will be added.}
  \item{libs}{A set of library path(s) to search for packages to update}
  \item{prevRepos}{Whether or not to update a package from the
    repository it was installed from}
  \item{force}{Whether or not to ignore any dependencies}
  \item{fileSelect}{Function to determine if a package needs updating or
    not}
  \item{recurse}{Whether to search through subrepositories for desired packages}
  \item{type}{The type of package to download/install/etc (e.g. Source,
    Win32, etc)}
  \item{searchOptions}{Whether to search repositories listed in
    options("repositories") as well as specified repositories.  Default
    is FALSE which means that if one specifies a repository, *only* that
    repository is used.  If set to TRUE, and a user specifies a
    repository, then any repositories set in the user's options will
    also be used.}
  \item{versForce}{Whether or not to override R version checking on
    binary packages}
  \item{getNewest}{Whether or not to just get the newest available
    version of a package, or to provide alternate means (currently a
    menu selection) of obtaining a package}
  \item{install}{Whether or not to install the downloaded package}
  \item{update}{Whether to seek to update the package or simply install
    the requested version}
  \item{getAllDeps}{Will automatically download all dependencies if
    TRUE, otherwise will prompt the user}
  \item{method}{Defaults to "auto", identical to the same parameter used
    for \code{download.file}}
  \item{develOK}{Deprecated.  If you wish to install development
  versions of Bioconductor packages, please install a development
  version of R.}
}
\details{
  If the user uses the \code{versions} argument, the number of items in
  \code{versions} must match the number of items in \code{pkgs} and they
  are considered to be a one-to-one matching.
  
  For install.packages2, update.packages2, and remove.packages2, the
  system will by default check to insure that no dependencies from other
  packages are being broken.  This can be overridden using \code{force=TRUE}.

  Also for all packages, the \code{type} parameter's default depends on
  the user's OS.  If the user is using a windows machine, the default
  \code{type} to download from a repository is \code{Win32}, otherwise
  it is \code{Source}.
  
  \code{install.packages2}:  User can specify a ReposEntry object,
  and/or a set of packages or a set of themes.  If no package names or
  themes are specified, it is assumed the user wants everything
  available in the repository denoted by the ReposEntry.  If a theme (or
  themes) are specified, then any package directives are ignored
  (installation of themes is an all or nothing event).  Will install
  packages requested into the library directory specified.  If
  recurse==TRUE, will also search through any of the repository's listed
  subrepositories to find packages.  Likewise, if searchOptions==TRUE,
  will also look in the repositories listed by options("repositories")
  (So, if one specifies packages w/o a ReposEntry, it will only look
  here).  For more information on themes, see the help page on
  \code{\link{repositoryThemes}}.  

  \code{update.packages2}:  Used to update a user's packages.  Much like
  \code{install.packages2}, can take (or not) a \code{ReposEntry} object
  and also can be told to utilize the "repositories" option.  A set of
  packages can be specified, the packages from one or more  \code{\link{themes}} can be requested,
  or alternatively all packages in the specified 'libs' parameter will
  be used.  If prevRepos==TRUE, the system will attempt to ascertain
  where the package was actually installed from previously and will
  update from there instead. 
  
  \code{remove.packages2}: Will remove packages specified by 'pkgs' from the
  libPath noted by 'lib' and reflect this change in the local library
  listing.

  For \code{install.packages2} and \code{update.packages2}, an object of
  class \code{\link{pkgStatusList}} is returned.  This can be used to
  report (and by default, the \code{show} method is invoked if this
  output is not assigned to a variable) what packages were donwloaded
  and from where.  Also, the \code{matchesList} slot of the object can
  be referenced to find any potential matches for packages were not
  found (in the case of mispellings and the like).
}
\value{An object of class \code{\link{pkgStatusList}}}
\author{Jeff Gentry}
\seealso{\code{\link{syncLocalLibList}},\code{\link{ReposEntry}},\code{\link{genRepos}},\code{\link{pkgInfo}},
\code{\link{download.packages2}}, \code{\link{repositoryThemes}}}
\examples{
## set up a temporary directory for use with these examples
## this directory will be used with the \code{lib}
## parameter.  For normal usage, most users will be okay with using
## the defaults of \code{lib} and not need to specify manually
tmpLib <- tempfile()
dir.create(tmpLib)

## install a package from the standard repositories (listed by
## the command \code{getOption("repositories2")}
install.packages2("hu6800",lib=tmpLib)
## and another one from CRAN
install.packages2("abind",lib=tmpLib)
}
\keyword{utilities}
