\name{loadRepDD}
\alias{loadRepDD}
\title{ A function to retreive a repository data frame }
\description{
  This function will retrieve teh repository dataframe from a specified
  repository, and return it ot the user.
}
\usage{
loadRepDD(repURL, repDD = "repdatadesc.rda", method)
}
\arguments{
  \item{repURL}{The URL of the repository }
  \item{repDD}{The filename of the remote file.}
  \item{method}{Method used for file downloads.  See
    \code{download.file}, defaults to \code{auto}}
}
\details{
  Argument 'repDD' should remain the default in almost all cases.

  This function will connect to a specified repository and attempt to
  download any repdatadesc.rda file that is present.  There is not
  necessarily such a file in every repository, as some repositories are
  data-less (only containing links).

}
\value{
  A dataframe representing the 'repdatadesc' information for the
  specified repository, or NULL on failure.
}
\author{Jeff Gentry}
\seealso{\code{\link{repdatadesc-class}},\code{\link{getReposEntry}}}

\examples{
   rDf <- loadRepDD("http://www.bioconductor.org/repository/sample/package")
}
\keyword{utilities}
