### Version Number System

## Defines the VersionNumber class

## Define the class structure of the object
setClass("VersionNumber",representation(stringRep="character"),
         prototype=list(stringRep=as.character(NULL)))

## Define the accessors
if (is.null(getGeneric("stringRep")))
    setGeneric("stringRep", function(object)
               standardGeneric("stringRep"))
if (is.null(getGeneric("major")))
    setGeneric("major", function(object)
               standardGeneric("major"))
if (is.null(getGeneric("minor")))
    setGeneric("minor", function(object)
               standardGeneric("minor"))
    if(is.null(getGeneric("revision")))
    setGeneric("revision", function(object)
               standardGeneric("revision"))

setMethod("stringRep", "VersionNumber", function(object)
          object@stringRep)
setMethod("major","VersionNumber", function(object) {
    major <- getVersionPos(stringRep(object), 1)
    return(major)})
setMethod("minor", "VersionNumber", function(object) {
    minor <- getVersionPos(stringRep(object),2)
    return(minor)})
setMethod("revision", "VersionNumber", function(object) {
    revision <- getVersionPos(stringRep(object),3)
    return(revision)})
setMethod("show","VersionNumber", function(object) {
    print(stringRep(object))
    invisible(object)
})


setMethod("==","VersionNumber", function(e1,e2) {
    versVals <- getVersVals(e1,e2)
    e1 <- versVals[[1]]
    e2 <- versVals[[2]]
    for (i in seq(along=e1)) {
        if (e1[i] != e2[i])
          return(FALSE)
    }
    return(TRUE)
})

setMethod("!=","VersionNumber", function(e1,e2) {
    versVals <- getVersVals(e1,e2)
    e1 <- versVals[[1]]
    e2 <- versVals[[2]]
    for (i in seq(along=e1)) {
        if (e1[i] != e2[i])
          return(TRUE)
    }
    return(FALSE)
})

setMethod(">","VersionNumber",function(e1,e2) {
    versVals <- getVersVals(e1,e2)
    e1 <- versVals[[1]]
    e2 <- versVals[[2]]
    for (i in seq(along=e1)) {
        if (e1[i] > e2[i])
          return(TRUE)
        else if (e2[i] > e1[i])
          return(FALSE)
    }
    return(FALSE)
})

setMethod("<","VersionNumber",function(e1,e2) {
    versVals <- getVersVals(e1,e2)
    e1 <- versVals[[1]]
    e2 <- versVals[[2]]
    for (i in seq(along=e1)) {
        if (e1[i] < e2[i])
          return(TRUE)
        else if (e2[i] < e1[i])
          return(FALSE)
    }
    return(FALSE)
})

setMethod(">=", "VersionNumber",function(e1,e2) {
    versVals <- getVersVals(e1,e2)
    e1 <- versVals[[1]]
    e2 <- versVals[[2]]
    for (i in seq(along=e1)) {
        if (e1[i] > e2[i])
          return(TRUE)
        if (e1[i] < e2[i])
          return(FALSE)
    }
    return(TRUE)
})

setMethod("<=","VersionNumber", function(e1,e2) {
    versVals <- getVersVals(e1,e2)
    e1 <- versVals[[1]]
    e2 <- versVals[[2]]
    for (i in seq(along=e1)) {
        if (e1[i] < e2[i])
          return(TRUE)
        if (e1[i] > e2[i])
          return(FALSE)
    }
    return(TRUE)
})


setMethod("as.character","VersionNumber",function(x){
    return(stringRep(x))})

buildVersionNumber <- function(vers) {
    if (missing(vers))
        return(new("VersionNumber"))

    ## Check to make sure that this doesn't contain characters
    if (length(grep("[[:alpha:]]",vers)) > 0)
        vers <- "0"

    ## If the first char is a "." or "-", place a 0 in front
    if (length(grep("\\.|-",substr(vers,1,1))) > 0)
        vers <- paste("0",vers,sep="")

    ## Weed out any bad digits
    if (is.null(getDigits(vers))) {
        return(NULL)
    }
    else {
        a <- new("VersionNumber",stringRep=vers)
        if (!is(a,"VersionNumber"))
            a <- buildVersionNumber("0")
        return(a)
    }
}

getVersionPos <- function(version,pos) {
    ## Returns the digit in position pos from the version
    vers <- strsplit(version,"\\.|-")[[1]][pos]
    if ((is.na(vers))||(vers==""))
        return(0)
    else
        return(as.numeric(vers))
}

max.VersionNumber <- function(..., na.rm=FALSE) {
    versNums <- list(...)
    maxVers <- versNums[[1]]
    if (length(versNums) > 1) {
        for (i in 2:length(versNums)) {
            if (versNums[[i]] > maxVers)
                maxVers <- versNums[[i]]
        }
    }
    return(maxVers)
}

min.VersionNumber <- function(..., na.rm=FALSE) {
    versNums <- list(...)
    minVers <- versNums[[1]]
    if (length(versNums) > 1) {
        for (i in 2:length(versNums)) {
            if (versNums[[i]] < minVers)
                minVers <- versNums[[i]]
        }
    }
    return(minVers)
}


getMaxVersion <- function(x) {
    ## !!! I can't seem to find a way to get a list of VersionNumbers
    ## to be fed into max.VersionNumber, so for now ....

    maxVers <- x[[1]]
    len <- length(x)
    if (len > 1) {
        for (i in 2:len) {
            if (x[[i]] > maxVers)
                maxVers <- x[[i]]
        }
    }
    return(maxVers)
}

getMaxElement <- function(x) {
    ## Corrollary to getMaxVersion except it returns the position in
    ## the list that contains the max version
    maxPos <- 1
    len <- length(x)

    if (len > 1) {
        for (i in 2:len) {
            if (x[[i]] > x[[maxPos]])
                maxPos <- i
        }
    }
    return(maxPos)
}

getMinElement <- function(x) {
    minPos <- 1
    len <- length(x)

    if (len > 1) {
        for (i in 2:len) {
            if (x[[i]] < x[[minPos]])
                minPos <- i
        }
    }
    return(minPos)
}

getDigits <- function(vers) {
    ## Removes any . and - characters
    ## returns NULL nothing left
    xVals <- strsplit(vers,"\\.|-")[[1]]
    if (any(xVals=="")) {
        return(NULL)
    }

    xVals <- as.numeric(xVals)
    return(xVals)
}

getVersVals <- function(x,y) {
    ## Pads the shorter version with 0s, and removes any punctuation
    ## returns a list with both manipulated version numbers
    if (! is(x, "VersionNumber"))
        stop("invalid 'x' parameter, not of class VersionNumber")
    if (! is(y, "VersionNumber"))
        stop("invalid 'y' parameter, not of class VersionNumber")

    xVals <- getDigits(stringRep(x))
    yVals <- getDigits(stringRep(y))
    valDiff <- length(xVals) - length(yVals)
    if (valDiff < 0)
        xVals <- c(xVals,rep(0,abs(valDiff)))
    else if (valDiff > 0)
        yVals <- c(yVals,rep(0,valDiff))

    return(list(xVals,yVals))
}

checkVers <- function(x,op,y) {
    ## Passed two VersionNumbers x & y
    ## and a character string 'operator',
    ## will check to see if 'x op y' is TRUE or FALSE
    ## where op is coerced into the real operator.
    ret <- switch(op,
                  "==" = x==y,
                  ">" = x>y,
                  "<" = x<y,
                  ">=" = x >= y,
                  "<=" = x <= y,
                  "!=" = x != y
                  )
    return(ret)
}

buildRversnum <- function() {
    buildVersionNumber(as.character(getRversion()))
}
