.buildReposToolsOpts <- function(OST) {
    if (is.null(getOption("BioC"))) {
        BioC <- list()
        class(BioC) <- "BioCOptions"
        options("BioC"=BioC)
    }
    ReposEntry <- list()
    class(ReposEntry) <- "BioCPkg"

    ## Set the default download type
    if (OST == "windows")
        ReposEntry$type <- "Win32"
    else
        ReposEntry$type <- "Source"

    BioC <- getOption("BioC")
    BioC$reposEntry <- ReposEntry
    options("BioC"=BioC)

    ## Set up the repositories2 option
    if (!("CRAN" %in% names(getOption("repositories2")))) {
        bioCOpt <- "http://www.bioconductor.org/CRANrepository"
        names(bioCOpt) <- "CRAN"
        options("repositories2"=c(getOption("repositories2"),bioCOpt))
    }

    if (!("BIOCRel1.5" %in% names(getOption("repositories2")))) {
        bioROpt <- "http://www.bioconductor.org/repository/release1.5/package"
        names(bioROpt) <- "BIOCRel1.5"
        options("repositories2"=c(getOption("repositories2"),bioROpt))
    }

    if (!("BIOCRel1.6" %in% names(getOption("repositories2")))) {
        bioROpt <- "http://www.bioconductor.org/packages/bioc/1.6"
        names(bioROpt) <- "BIOCRel1.6"
        options("repositories2"=c(getOption("repositories2"),bioROpt))
    }

    if (!("BIOCDevel" %in% names(getOption("repositories2")))) {
        bioDOpt <- "http://www.bioconductor.org/packages/bioc/devel"
        names(bioDOpt) <- "BIOCDevel"
        options("repositories2"=c(getOption("repositories2"),bioDOpt))
    }

    if (!("BIOCData" %in% names(getOption("repositories2")))) {
        bioDaDopt <- "http://www.bioconductor.org/packages/data/annotation/stable"
        names(bioDaDopt) <- "BIOCData"
        options("repositories2"=c(getOption("repositories2"),
        bioDaDopt))
    }
    if (!("BIOCDevData" %in% names(getOption("repositories2")))) {
        bioDaDopt <- "http://www.bioconductor.org/packages/data/annotation/devel"
        names(bioDaDopt) <- "BIOCDevData"
        options("repositories2"=c(getOption("repositories2"),
        bioDaDopt))
    }


    if (!("BIOCExdata" %in% names(getOption("repositories2")))) {
        bioCexpr <- "http://www.bioconductor.org/packages/data/experiment/stable"
        names(bioCexpr) <- "BIOCExdata"
        options("repositories2"=c(getOption("repositories2"),
                bioCexpr))
    }
    if (!("BIOCCourses" %in% names(getOption("repositories2")))) {
        bioCCourse <- "http://www.bioconductor.org/repository/Courses"
        names(bioCCourse) <- "BIOCCourses"
        options("repositories2"=c(getOption("repositories2"),
                bioCCourse))
    }
    if (!("BIOCcdf" %in% names(getOption("repositories2")))) {
        bioCcdf <- "http://www.bioconductor.org/packages/data/annotation/stable"
        names(bioCcdf) <- "BIOCcdf"
        options("repositories2"=c(getOption("repositories2"),
                bioCcdf))
    }
    if (!("BIOCprobes" %in% names(getOption("repositories2")))) {
        bioCProbe <- "http://www.bioconductor.org/packages/data/annotation/stable"
        names(bioCProbe) <- "BIOCprobes"
        options("repositories2"=c(getOption("repositories2"),
                bioCProbe))
    }
    if (!("BIOCOmegahat" %in% names(getOption("repositories2")))) {
        bioCOmegahat <-
        "http://www.bioconductor.org/packages/omegahat/stable"
        names(bioCOmegahat) <- "BIOCOmegahat"
        options("repositories2"=c(getOption("repositories2"),
                bioCOmegahat))
    }

    if (!("BIOCLinds" %in% names(getOption("repositories2")))) {
        bioClindsey <-
        "http://www.bioconductor.org/packages/lindsey/stable"
        names(bioClindsey) <- "BIOCLinds"
        options("repositories2"=c(getOption("repositories2"),
                bioClindsey))
    }

}

.First.lib <- function(libname, pkgname) {
    ##.initComparisonMethods()
    OST <- .Platform$OS.type
    .buildReposToolsOpts(OST)
}

