\name{saveDfRda}
\alias{saveDfRda}
\title{A function to save a repository dataframe file}
\description{
  This function is utilized to provide a uniform name of the dataframe
  object (reposDF) stored in the repdatadesc.rda file.
}
\usage{
saveDfRda(reposDF, outFile = "repdatadesc.rda")
}
\arguments{
  \item{reposDF}{The repository data.frame }
  \item{outFile}{The name of the file to store it in}
}
\details{
  By protocol, all repository data.frames should have the name 'reposDF'
  when stored in the repdatadesc file.  As such, this function provides
  a wrapper to force this naming convention.

  Also by convention, in a repository setting the filename is
  "repdatadesc.rda", so one should not deviate from teh defaults.
}
\author{Jeff Gentry}
\seealso{\code{\link{buildPkgDf}}}
\examples{
   z <- tempfile()
   data(sampleRepos)
   saveDfRda(reposDF,z)
   unlink(z)
}
\keyword{utilities}
