#! /bin/sh
# /etc/init.d/restartd
#
# Written by Tibor Koleszar <oldw@debian.org>.
#

set -e

DAEMON=/usr/sbin/restartd
PARAMS=""
PID="/var/run/restartd.pid"

test -x $DAEMON || exit 0

case "$1" in
  start)
    echo -n "Starting process checker: "
    $DAEMON $PARAMS
    echo "restartd."
    ;;
  stop)
    echo -n "Stopping process checker: "
    if kill `cat /var/run/restartd.pid 2> /dev/null` 2> /dev/null 1> /dev/null
    then
	rm -f /var/run/restartd.pid
    else
	echo -n "not running: "
    fi
    echo "restartd."
      ;;
  restart)
    echo -n "Stopping process checker: "
    if kill `cat /var/run/restartd.pid 2> /dev/null` 2> /dev/null 1> /dev/null
    then
	rm -f /var/run/restartd.pid
    else
	echo -n "not running: "
    fi
    echo "restartd."
    echo -n "Starting process checker: "
    $DAEMON $PARAMS
    echo "restartd."
      ;;
  reload|force-reload)
    echo "Reloading restartd configuration files"
    kill -HUP `cat /var/run/restartd.pid`
    ;;
  *)
    echo "Usage: /etc/init.d/restartd {start|stop|restart|reload|force-reload}"
    exit 1
    ;;
esac

exit 0
