#! /bin/sh

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
DB_FILE=${DB_DIR}/test1.db
TMP_DB_FILE=${DB_DIR}/${TMP_TEST_DB}.db
TMP_DB_BASE=$(basename ${TMP_DB_FILE})

cp ${DB_FILE} ${TMP_DB_FILE}

export REQUEST_URI="/~saulius/restful/website/bibliography?db=${TMP_DB_BASE}&action=template"
export QUERY_STRING=$(basename ${REQUEST_URI} | perl -pe 's/^.*?\?//; s/\d+\.db$/.db/')
export HTTP_HOST=test.domain.net
export REQUEST_METHOD=POST
export REMOTE_USER=writer

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';
echo "==="

${INPUT_SCRIPT} \
    db=${TMP_DB_BASE} \
    action=template \
    | perl -lpe 's/(tmpnewpl)[^\.]+/$1/g'

sqlite3 -nullvalue NULL ${TMP_DB_FILE} 'select * from bibliography order by id';

rm -f ${TMP_DB_FILE}
