IF (NOT TEST_BENCH)
	message(FATAL_ERROR "TEST_BENCH is not defined!")
ENDIF ()

IF (NOT TEST_BENCH_SRCFILES)
	SET(TEST_BENCH_SRCFILES main.cpp)
ENDIF ()

add_executable(${TEST_BENCH} ${TEST_BENCH_SRCFILES})

TARGET_LINK_LIBRARIES(${TEST_BENCH} PRIVATE restinio::restinio)
TARGET_INCLUDE_DIRECTORIES(${TEST_BENCH} PRIVATE ${CMAKE_SOURCE_DIR}/args)

link_threads_if_necessary(${TEST_BENCH})

IF (WIN32)
	TARGET_LINK_LIBRARIES(${TEST_BENCH} PRIVATE wsock32 ws2_32)
ENDIF ()

IF (RESTINIO_INSTALL_BENCHES)
	install(TARGETS ${TEST_BENCH} DESTINATION bin)
ENDIF ()
