/* virtual-gamepad.c generated by valac 0.35.5, the Vala compiler
 * generated from virtual-gamepad.vala, do not modify */

/* This file is part of retro-gtk. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>


#define RETRO_TYPE_INPUT_DEVICE (retro_input_device_get_type ())
#define RETRO_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDevice))
#define RETRO_IS_INPUT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_INPUT_DEVICE))
#define RETRO_INPUT_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RETRO_TYPE_INPUT_DEVICE, RetroInputDeviceIface))

typedef struct _RetroInputDevice RetroInputDevice;
typedef struct _RetroInputDeviceIface RetroInputDeviceIface;

#define RETRO_TYPE_DEVICE_TYPE (retro_device_type_get_type ())

#define RETRO_TYPE_VIRTUAL_GAMEPAD (retro_virtual_gamepad_get_type ())
#define RETRO_VIRTUAL_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepad))
#define RETRO_VIRTUAL_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepadClass))
#define RETRO_IS_VIRTUAL_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_VIRTUAL_GAMEPAD))
#define RETRO_IS_VIRTUAL_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_VIRTUAL_GAMEPAD))
#define RETRO_VIRTUAL_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepadClass))

typedef struct _RetroVirtualGamepad RetroVirtualGamepad;
typedef struct _RetroVirtualGamepadClass RetroVirtualGamepadClass;
typedef struct _RetroVirtualGamepadPrivate RetroVirtualGamepadPrivate;

#define RETRO_TYPE_GAMEPAD_CONFIGURATION (retro_gamepad_configuration_get_type ())
#define RETRO_GAMEPAD_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_GAMEPAD_CONFIGURATION, RetroGamepadConfiguration))
#define RETRO_GAMEPAD_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_GAMEPAD_CONFIGURATION, RetroGamepadConfigurationClass))
#define RETRO_IS_GAMEPAD_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_GAMEPAD_CONFIGURATION))
#define RETRO_IS_GAMEPAD_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_GAMEPAD_CONFIGURATION))
#define RETRO_GAMEPAD_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_GAMEPAD_CONFIGURATION, RetroGamepadConfigurationClass))

typedef struct _RetroGamepadConfiguration RetroGamepadConfiguration;
typedef struct _RetroGamepadConfigurationClass RetroGamepadConfigurationClass;

#define RETRO_TYPE_KEYBOARD_STATE (retro_keyboard_state_get_type ())
#define RETRO_KEYBOARD_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RETRO_TYPE_KEYBOARD_STATE, RetroKeyboardState))
#define RETRO_KEYBOARD_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RETRO_TYPE_KEYBOARD_STATE, RetroKeyboardStateClass))
#define RETRO_IS_KEYBOARD_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RETRO_TYPE_KEYBOARD_STATE))
#define RETRO_IS_KEYBOARD_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RETRO_TYPE_KEYBOARD_STATE))
#define RETRO_KEYBOARD_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RETRO_TYPE_KEYBOARD_STATE, RetroKeyboardStateClass))

typedef struct _RetroKeyboardState RetroKeyboardState;
typedef struct _RetroKeyboardStateClass RetroKeyboardStateClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RETRO_TYPE_GAMEPAD_BUTTON_TYPE (retro_gamepad_button_type_get_type ())

typedef enum  {
	RETRO_DEVICE_TYPE_TYPE_MASK = 0xff,
	RETRO_DEVICE_TYPE_NONE = 0,
	RETRO_DEVICE_TYPE_JOYPAD = 1,
	RETRO_DEVICE_TYPE_MOUSE = 2,
	RETRO_DEVICE_TYPE_KEYBOARD = 3,
	RETRO_DEVICE_TYPE_LIGHTGUN = 4,
	RETRO_DEVICE_TYPE_ANALOG = 5,
	RETRO_DEVICE_TYPE_POINTER = 6
} RetroDeviceType;

struct _RetroInputDeviceIface {
	GTypeInterface parent_iface;
	void (*poll) (RetroInputDevice* self);
	gint16 (*get_input_state) (RetroInputDevice* self, RetroDeviceType device, guint index, guint id);
	RetroDeviceType (*get_device_type) (RetroInputDevice* self);
	guint64 (*get_device_capabilities) (RetroInputDevice* self);
};

struct _RetroVirtualGamepad {
	GObject parent_instance;
	RetroVirtualGamepadPrivate * priv;
};

struct _RetroVirtualGamepadClass {
	GObjectClass parent_class;
};

struct _RetroVirtualGamepadPrivate {
	GtkWidget* _widget;
	RetroGamepadConfiguration* _configuration;
	RetroKeyboardState* keyboard;
};

typedef enum  {
	RETRO_GAMEPAD_BUTTON_TYPE_ACTION_DOWN,
	RETRO_GAMEPAD_BUTTON_TYPE_ACTION_LEFT,
	RETRO_GAMEPAD_BUTTON_TYPE_SELECT,
	RETRO_GAMEPAD_BUTTON_TYPE_START,
	RETRO_GAMEPAD_BUTTON_TYPE_DIRECTION_UP,
	RETRO_GAMEPAD_BUTTON_TYPE_DIRECTION_DOWN,
	RETRO_GAMEPAD_BUTTON_TYPE_DIRECTION_LEFT,
	RETRO_GAMEPAD_BUTTON_TYPE_DIRECTION_RIGHT,
	RETRO_GAMEPAD_BUTTON_TYPE_ACTION_RIGHT,
	RETRO_GAMEPAD_BUTTON_TYPE_ACTION_UP,
	RETRO_GAMEPAD_BUTTON_TYPE_SHOULDER_L,
	RETRO_GAMEPAD_BUTTON_TYPE_SHOULDER_R,
	RETRO_GAMEPAD_BUTTON_TYPE_SHOULDER_L2,
	RETRO_GAMEPAD_BUTTON_TYPE_SHOULDER_R2,
	RETRO_GAMEPAD_BUTTON_TYPE_STICK_L,
	RETRO_GAMEPAD_BUTTON_TYPE_STICK_R,
	RETRO_GAMEPAD_BUTTON_TYPE_HOME
} RetroGamepadButtonType;


static gpointer retro_virtual_gamepad_parent_class = NULL;
static RetroInputDeviceIface * retro_virtual_gamepad_retro_input_device_parent_iface = NULL;

GType retro_device_type_get_type (void) G_GNUC_CONST;
GType retro_input_device_get_type (void) G_GNUC_CONST;
GType retro_virtual_gamepad_get_type (void) G_GNUC_CONST;
GType retro_gamepad_configuration_get_type (void) G_GNUC_CONST;
GType retro_keyboard_state_get_type (void) G_GNUC_CONST;
#define RETRO_VIRTUAL_GAMEPAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepadPrivate))
enum  {
	RETRO_VIRTUAL_GAMEPAD_DUMMY_PROPERTY,
	RETRO_VIRTUAL_GAMEPAD_WIDGET,
	RETRO_VIRTUAL_GAMEPAD_CONFIGURATION
};
RetroVirtualGamepad* retro_virtual_gamepad_new (GtkWidget* widget);
RetroVirtualGamepad* retro_virtual_gamepad_construct (GType object_type, GtkWidget* widget);
RetroVirtualGamepad* retro_virtual_gamepad_new_with_configuration (GtkWidget* widget, RetroGamepadConfiguration* configuration);
RetroVirtualGamepad* retro_virtual_gamepad_construct_with_configuration (GType object_type, GtkWidget* widget, RetroGamepadConfiguration* configuration);
static void retro_virtual_gamepad_real_poll (RetroInputDevice* base);
static gint16 retro_virtual_gamepad_real_get_input_state (RetroInputDevice* base, RetroDeviceType device, guint index, guint id);
GType retro_gamepad_button_type_get_type (void) G_GNUC_CONST;
gboolean retro_virtual_gamepad_get_button_pressed (RetroVirtualGamepad* self, RetroGamepadButtonType button);
static RetroDeviceType retro_virtual_gamepad_real_get_device_type (RetroInputDevice* base);
static guint64 retro_virtual_gamepad_real_get_device_capabilities (RetroInputDevice* base);
gboolean retro_keyboard_state_get_key_state (RetroKeyboardState* self, guint16 hardware_keycode);
RetroGamepadConfiguration* retro_virtual_gamepad_get_configuration (RetroVirtualGamepad* self);
guint16 retro_gamepad_configuration_get_button_key (RetroGamepadConfiguration* self, RetroGamepadButtonType button);
GtkWidget* retro_virtual_gamepad_get_widget (RetroVirtualGamepad* self);
static void retro_virtual_gamepad_set_widget (RetroVirtualGamepad* self, GtkWidget* value);
void retro_virtual_gamepad_set_configuration (RetroVirtualGamepad* self, RetroGamepadConfiguration* value);
static GObject * retro_virtual_gamepad_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
RetroKeyboardState* retro_keyboard_state_new (GtkWidget* widget);
RetroKeyboardState* retro_keyboard_state_construct (GType object_type, GtkWidget* widget);
RetroGamepadConfiguration* retro_gamepad_configuration_new (void);
RetroGamepadConfiguration* retro_gamepad_configuration_construct (GType object_type);
void retro_gamepad_configuration_set_to_default (RetroGamepadConfiguration* self);
static void retro_virtual_gamepad_finalize (GObject * obj);
static void _vala_retro_virtual_gamepad_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_retro_virtual_gamepad_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RetroVirtualGamepad* retro_virtual_gamepad_construct (GType object_type, GtkWidget* widget) {
	RetroVirtualGamepad * self = NULL;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = widget;
	self = (RetroVirtualGamepad*) g_object_new (object_type, "widget", _tmp0_, NULL);
	return self;
}


RetroVirtualGamepad* retro_virtual_gamepad_new (GtkWidget* widget) {
	return retro_virtual_gamepad_construct (RETRO_TYPE_VIRTUAL_GAMEPAD, widget);
}


RetroVirtualGamepad* retro_virtual_gamepad_construct_with_configuration (GType object_type, GtkWidget* widget, RetroGamepadConfiguration* configuration) {
	RetroVirtualGamepad * self = NULL;
	GtkWidget* _tmp0_;
	RetroGamepadConfiguration* _tmp1_;
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (configuration != NULL, NULL);
	_tmp0_ = widget;
	_tmp1_ = configuration;
	self = (RetroVirtualGamepad*) g_object_new (object_type, "widget", _tmp0_, "configuration", _tmp1_, NULL);
	return self;
}


RetroVirtualGamepad* retro_virtual_gamepad_new_with_configuration (GtkWidget* widget, RetroGamepadConfiguration* configuration) {
	return retro_virtual_gamepad_construct_with_configuration (RETRO_TYPE_VIRTUAL_GAMEPAD, widget, configuration);
}


static void retro_virtual_gamepad_real_poll (RetroInputDevice* base) {
	RetroVirtualGamepad * self;
	self = (RetroVirtualGamepad*) base;
}


static gint16 retro_virtual_gamepad_real_get_input_state (RetroInputDevice* base, RetroDeviceType device, guint index, guint id) {
	RetroVirtualGamepad * self;
	gint16 result = 0;
	RetroDeviceType _tmp0_;
	gint16 _tmp1_ = 0;
	guint _tmp2_;
	gboolean _tmp3_;
	self = (RetroVirtualGamepad*) base;
	_tmp0_ = device;
	if (((RetroDeviceType) _tmp0_) != RETRO_DEVICE_TYPE_JOYPAD) {
		result = (gint16) 0;
		return result;
	}
	_tmp2_ = id;
	_tmp3_ = retro_virtual_gamepad_get_button_pressed (self, (RetroGamepadButtonType) _tmp2_);
	if (_tmp3_) {
		_tmp1_ = G_MAXINT16;
	} else {
		_tmp1_ = (gint16) 0;
	}
	result = _tmp1_;
	return result;
}


static RetroDeviceType retro_virtual_gamepad_real_get_device_type (RetroInputDevice* base) {
	RetroVirtualGamepad * self;
	RetroDeviceType result = 0;
	self = (RetroVirtualGamepad*) base;
	result = RETRO_DEVICE_TYPE_JOYPAD;
	return result;
}


static guint64 retro_virtual_gamepad_real_get_device_capabilities (RetroInputDevice* base) {
	RetroVirtualGamepad * self;
	guint64 result = 0ULL;
	self = (RetroVirtualGamepad*) base;
	result = (guint64) (1 << RETRO_DEVICE_TYPE_JOYPAD);
	return result;
}


gboolean retro_virtual_gamepad_get_button_pressed (RetroVirtualGamepad* self, RetroGamepadButtonType button) {
	gboolean result = FALSE;
	RetroKeyboardState* _tmp0_;
	RetroGamepadConfiguration* _tmp1_;
	RetroGamepadButtonType _tmp2_;
	guint16 _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->keyboard;
	_tmp1_ = self->priv->_configuration;
	_tmp2_ = button;
	_tmp3_ = retro_gamepad_configuration_get_button_key (_tmp1_, _tmp2_);
	_tmp4_ = retro_keyboard_state_get_key_state (_tmp0_, _tmp3_);
	result = _tmp4_;
	return result;
}


GtkWidget* retro_virtual_gamepad_get_widget (RetroVirtualGamepad* self) {
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void retro_virtual_gamepad_set_widget (RetroVirtualGamepad* self, GtkWidget* value) {
	g_return_if_fail (self != NULL);
	if (retro_virtual_gamepad_get_widget (self) != value) {
		GtkWidget* _tmp0_;
		GtkWidget* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_widget);
		self->priv->_widget = _tmp1_;
		g_object_notify ((GObject *) self, "widget");
	}
}


RetroGamepadConfiguration* retro_virtual_gamepad_get_configuration (RetroVirtualGamepad* self) {
	RetroGamepadConfiguration* result;
	RetroGamepadConfiguration* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_configuration;
	result = _tmp0_;
	return result;
}


void retro_virtual_gamepad_set_configuration (RetroVirtualGamepad* self, RetroGamepadConfiguration* value) {
	g_return_if_fail (self != NULL);
	if (retro_virtual_gamepad_get_configuration (self) != value) {
		RetroGamepadConfiguration* _tmp0_;
		RetroGamepadConfiguration* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_configuration);
		self->priv->_configuration = _tmp1_;
		g_object_notify ((GObject *) self, "configuration");
	}
}


static GObject * retro_virtual_gamepad_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RetroVirtualGamepad * self;
	GtkWidget* _tmp0_;
	RetroKeyboardState* _tmp1_;
	RetroGamepadConfiguration* _tmp2_;
	parent_class = G_OBJECT_CLASS (retro_virtual_gamepad_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepad);
	_tmp0_ = self->priv->_widget;
	_tmp1_ = retro_keyboard_state_new (_tmp0_);
	_g_object_unref0 (self->priv->keyboard);
	self->priv->keyboard = _tmp1_;
	_tmp2_ = self->priv->_configuration;
	if (_tmp2_ == NULL) {
		RetroGamepadConfiguration* _tmp3_;
		RetroGamepadConfiguration* _tmp4_;
		RetroGamepadConfiguration* _tmp5_;
		_tmp3_ = retro_gamepad_configuration_new ();
		_tmp4_ = _tmp3_;
		retro_virtual_gamepad_set_configuration (self, _tmp4_);
		_g_object_unref0 (_tmp4_);
		_tmp5_ = self->priv->_configuration;
		retro_gamepad_configuration_set_to_default (_tmp5_);
	}
	return obj;
}


static void retro_virtual_gamepad_class_init (RetroVirtualGamepadClass * klass) {
	retro_virtual_gamepad_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RetroVirtualGamepadPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_retro_virtual_gamepad_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_retro_virtual_gamepad_set_property;
	G_OBJECT_CLASS (klass)->constructor = retro_virtual_gamepad_constructor;
	G_OBJECT_CLASS (klass)->finalize = retro_virtual_gamepad_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_VIRTUAL_GAMEPAD_WIDGET, g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RETRO_VIRTUAL_GAMEPAD_CONFIGURATION, g_param_spec_object ("configuration", "configuration", "configuration", RETRO_TYPE_GAMEPAD_CONFIGURATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void retro_virtual_gamepad_retro_input_device_interface_init (RetroInputDeviceIface * iface) {
	retro_virtual_gamepad_retro_input_device_parent_iface = g_type_interface_peek_parent (iface);
	iface->poll = (void (*) (RetroInputDevice *)) retro_virtual_gamepad_real_poll;
	iface->get_input_state = (gint16 (*) (RetroInputDevice *, RetroDeviceType, guint, guint)) retro_virtual_gamepad_real_get_input_state;
	iface->get_device_type = (RetroDeviceType (*) (RetroInputDevice *)) retro_virtual_gamepad_real_get_device_type;
	iface->get_device_capabilities = (guint64 (*) (RetroInputDevice *)) retro_virtual_gamepad_real_get_device_capabilities;
}


static void retro_virtual_gamepad_instance_init (RetroVirtualGamepad * self) {
	self->priv = RETRO_VIRTUAL_GAMEPAD_GET_PRIVATE (self);
}


static void retro_virtual_gamepad_finalize (GObject * obj) {
	RetroVirtualGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepad);
	_g_object_unref0 (self->priv->_widget);
	_g_object_unref0 (self->priv->_configuration);
	_g_object_unref0 (self->priv->keyboard);
	G_OBJECT_CLASS (retro_virtual_gamepad_parent_class)->finalize (obj);
}


GType retro_virtual_gamepad_get_type (void) {
	static volatile gsize retro_virtual_gamepad_type_id__volatile = 0;
	if (g_once_init_enter (&retro_virtual_gamepad_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RetroVirtualGamepadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) retro_virtual_gamepad_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RetroVirtualGamepad), 0, (GInstanceInitFunc) retro_virtual_gamepad_instance_init, NULL };
		static const GInterfaceInfo retro_input_device_info = { (GInterfaceInitFunc) retro_virtual_gamepad_retro_input_device_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType retro_virtual_gamepad_type_id;
		retro_virtual_gamepad_type_id = g_type_register_static (G_TYPE_OBJECT, "RetroVirtualGamepad", &g_define_type_info, 0);
		g_type_add_interface_static (retro_virtual_gamepad_type_id, RETRO_TYPE_INPUT_DEVICE, &retro_input_device_info);
		g_once_init_leave (&retro_virtual_gamepad_type_id__volatile, retro_virtual_gamepad_type_id);
	}
	return retro_virtual_gamepad_type_id__volatile;
}


static void _vala_retro_virtual_gamepad_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RetroVirtualGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepad);
	switch (property_id) {
		case RETRO_VIRTUAL_GAMEPAD_WIDGET:
		g_value_set_object (value, retro_virtual_gamepad_get_widget (self));
		break;
		case RETRO_VIRTUAL_GAMEPAD_CONFIGURATION:
		g_value_set_object (value, retro_virtual_gamepad_get_configuration (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_retro_virtual_gamepad_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RetroVirtualGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RETRO_TYPE_VIRTUAL_GAMEPAD, RetroVirtualGamepad);
	switch (property_id) {
		case RETRO_VIRTUAL_GAMEPAD_WIDGET:
		retro_virtual_gamepad_set_widget (self, g_value_get_object (value));
		break;
		case RETRO_VIRTUAL_GAMEPAD_CONFIGURATION:
		retro_virtual_gamepad_set_configuration (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



