gtkComboSetPopdownStrings <-
  #
  # strings should be a character vector
  #
function(combo, strings, .flush = TRUE)
{
  gtkCheckInherits(combo, "GtkCombo")
  strings <- as.character(strings)
  .GtkCall("R_gtkComboSetPopdownStrings", combo, strings)
}





gtkTextGetText <-
function(w)
{
 .Call("R_gtk_getTextContents", w)
}

gtkTextClearText <-
function(w, start=0, end=-1)
{
 .Call("R_gtk_clearTextContents", w, as.integer(c(start, end)))
}

gtkTextSetText <-
function(w, contents="", append = FALSE)
{
 if(append == FALSE) {
   gtkClearText(w, )
 }

 .Call("R_gtk_setTextContents", w, as.character(contents), as.logical(append))
}



gtkObjectRef =
function(obj)
{
  gtkCheckInherits(combo, "GtkObject")  
 .GtkCall("R_gtk_object_ref", obj, TRUE) 
}

gtkObjectUnref =
function(obj)
{
  gtkCheckInherits(combo, "GtkObject")  
 .GtkCall("R_gtk_object_ref", obj, FALSE) 
}



findWidgetByType =
  #
  # Recursively search a widget tree for the first occurence of
  # a widget of the specified type.
  #
function(win, gtkType = "GtkMenuBar", verbose = FALSE)
{
 if(verbose)
   print(class(win))

 if(is.function(gtkType)) {
   if(gtkType(win))
     return(win)
 } else if(as.character(gtkType) %in% class(win)) {
     return(win)
 } 

 if("GtkContainer" %in% class(win)) {
  for(i in win$GetChildren()) {
   tmp = findWidgetByType(i, gtkType, verbose = verbose)
   if(!is.null(tmp))
     return(tmp)
  }
 }
 
 return(NULL)
}


gtkWidgetSetFlags =
function(w, val, flags = .GtkWidgetFlags)
{
  if(is.character(val)) {
     which = match(val, names(flags))
     if(any(is.na(which)))
       stop("Unrecognized flags", paste(val[is.na(which)], collapse=", "))

     which = flags[which]
  } else
     which = val


  if(! ("GtkWidget" %in% class(w)))
    stop("Expecting a GtkWidget object")
  
  .Call("R_gtkWidgetSetFlags", w, as.integer(which))
}

gtkWidgetGetFlags =
function(w)
{
  gtkWidgetSetFlags(w, integer(0))
}


