gtkCheckInherits <-
#
# if critical is TRUE, an error is generated
# in the case that w does not inherit from the
# specified class.
# If it is FALSE, a warning is generated.
# If critical is a string (character vector of length 1)
# it is passed directly to stop() and used as the error message.
# This allows the caller to give more context-specific
# messages.
function(w, klass = "GtkWidget", nullOk = FALSE, critical = TRUE)
{
 if(is.null(w) && nullOk)
   return(TRUE)
 
 if(!inherits(w, klass)) {
   if(is.character(critical))
     stop(critical)
   else if(is.logical(critical) && critical)
     stop(paste("object of class", class(w), "isn't a",klass))
 }

 return(TRUE)
}


gdkFlush <-
function()
{
 .C("gdkFlush")
}


.GtkCall <-
function(name, ..., .flush = TRUE)  
{
   val <- .Call(name, ...)
   if(.flush)
     gdkFlush()

   val
}  


gtkObjectGetTypeName <-
function(w)
{
 gtkCheckInherits(w, "GtkObject")
 .Call("R_getObjectTypeName", w)
}  

gtkObjectGetClasses <-
function(w, check = TRUE)
{
 if(check)
     gtkCheckInherits(w, "GtkObject")
 .Call("R_getObjectTypeHierarchy", w)
}

gtkTypeGetClasses <-
function(type)
{
  if(is.character(type))
    type <- gtkGetType(type)

  gtkCheckInherits(type, "GtkType")
  .Call("R_getTypeHierarchy", type)
}  

gtkObjectGetType <-
function(w, check = TRUE)
{
 if(check)
    gtkCheckInherits(w, "GtkObject")
 .Call("R_getObjectType", w)
}

gtkGetType <-
  #
  # This only works after the class has been initialized
  # and that means an object has to be created or the class
  # loaded by some other means. In the future, we might try
  # some interesting generic mechanism to force this to happen
  # such as calling gtk_<name>_get_type()
function(name)
{
 .Call("R_getTypeFromName", as.character(name))
}  

# .Call("R_getSignalNames", gtkButton())

gtkObjectGetSignals <-
function(w)
{
  gtkCheckInherits(w, "GtkObject")
  els <- .Call("R_getSignalNames", w)
  names(els) <- sapply(els, function(x) names(x))

  els
}  

gtkTypeGetSignals <-
function(type)
{
  if(is.character(type))
    type <- gtkGetType(type)
  else if(inherits(type, "GtkObject")) {
    type <- gtkObjectGetType(type)
  }
  
  gtkCheckInherits(type, "GtkType")
  els <- .Call("R_getSignalNamesByType", type)

  names(els) <- sapply(els, function(x) names(x))

  els  
}  


gtkSignalGetInfo <-
function(sig)
{
 gtkCheckInherits(sig, "GtkSignalId")
 .Call("R_gtkGetSignalInfo", sig)
}  



if(FALSE) {
 bitAnd <- 
 function(value, els)
 {
  els <- as.integer(els)
  .C("Rgtk_bitAnd", as.integer(value), els, length(els), ans = logical(length(els)))$ans
 }
}
