#include "RGtk.h"

#include <gtk/gtk.h>

#ifndef WIN32
#include "R_ext/eventloop.h"
#include <gdk/gdkx.h>
#else
#include <sys/types.h>
#endif


#include "gtkUtils.h"

#ifdef G_OS_WIN32

/* This is an simple version of the event handler for windows.
   It mimicks what we do in Rggobi, namely hijacking the hook into the
   event loop that Tk uses.
   This currently doesn't handle timed and idle tasks.
   More to come later on an overhaul of the R event loop.
 */
extern  __declspec(dllimport) void (* R_tcldo)();

void
R_gtk_handle_events()
{
  gboolean block = 0;
  g_main_iteration(block);
}
#endif

void
R_gtkInit(long *rargc, char **rargv)
{
    int argc;

    argc = (int) *rargc;
#ifdef USE_GNOME
    gnome_init("R", "1.6.0", argc, rargv);
#else
    gtk_init_check(&argc, &rargv);
#endif

#ifndef G_OS_WIN32
    {
	InputHandler *h;
         h = addInputHandler(R_InputHandlers, ConnectionNumber(GDK_DISPLAY()),
                              R_gtk_eventHandler, -1);
    }
#else
    R_tcldo = R_gtk_handle_events;
#endif
}



USER_OBJECT_
R_gtk_window(USER_OBJECT_ stitle)
{
   GtkWidget *win;

    win = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    gtk_container_set_border_width (GTK_CONTAINER (win), 10);
                             
    if(GET_LENGTH(stitle))
	gtk_window_set_title(GTK_WINDOW(win), CHAR_DEREF(STRING_ELT(stitle, 0)));

    return(toRPointer(win, "GtkWindow"));
}


USER_OBJECT_
R_gtkWidgetReference(GtkWidget *w, const char *klassName)
{
    USER_OBJECT_ ans;
    PROTECT(ans = toRPointer(w, klassName));
    SET_CLASS(ans, asRCharacter(klassName));
    UNPROTECT(1);
    return(ans);
}


USER_OBJECT_
R_gtk_button(USER_OBJECT_ label)
{
  GtkWidget *w;
   w = gtk_button_new_with_label(CHAR_DEREF(STRING_ELT(label, 0)));

   return(R_gtkWidgetReference(w, "GtkButton"));
}

USER_OBJECT_
R_gtk_addWidget(USER_OBJECT_ scontainer, USER_OBJECT_ swidgets)
{

  GtkWidget *parent, *w;
  USER_OBJECT_ ans;
  int i, n;

   parent = GTK_OBJECT((GtkWidget*) getPtrValue(scontainer));
   n = GET_LENGTH(swidgets);
   PROTECT(ans = NEW_LOGICAL(n));
   for(i = 0; i < n ; i++) {
       w = (GtkWidget*) getPtrValue(VECTOR_ELT(swidgets,i));
       gtk_container_add(GTK_CONTAINER(parent), w);
       LOGICAL_DATA(ans)[i] = TRUE;
   }

   UNPROTECT(1);
   return(ans);
}

USER_OBJECT_
R_gtk_showWidget(USER_OBJECT_ widgets, USER_OBJECT_ all)
{
    GtkWidget *w;
    int i;
    USER_OBJECT_ tmp;

    for(i = 0 ; i < GET_LENGTH(widgets); i++) {
	tmp = VECTOR_ELT(widgets, i);
        w = GTK_WIDGET(getPtrValue(tmp));  
        if(LOGICAL_DATA(all)[0])
	    gtk_widget_show_all(w);
        else
	    gtk_widget_show(w);
    }

    tmp = NEW_INTEGER(1);
    INTEGER_DATA(tmp)[0] = GET_LENGTH(widgets);

    return(tmp);
}

void
R_gtk_flush()
{
    gdk_flush();
}





USER_OBJECT_
R_gtk_textView(USER_OBJECT_ contents, USER_OBJECT_ editable)
{
  GtkWidget *w;

#if 0
  w = gtk_text_view_new();
  if(GET_LENGTH(contents)) {
    GtkTextBuffer *buf;  
      buf = gtk_text_view_get_buffer(GTK_TEXT(w));
      gtk_text_buffer_set_text(CHAR_DEREF(STRING_ELT(contents, 0)));
  }
#else
  w = gtk_text_new(NULL, NULL);

  if(GET_LENGTH(contents)) {
      char *txt;
      txt = CHAR_DEREF(STRING_ELT(contents, 0));
    
      gtk_text_insert(GTK_TEXT(w), NULL, NULL, NULL, txt, strlen(txt));
  }  

  if(LOGICAL_DATA(editable)[0]) {
      gtk_text_set_editable(GTK_TEXT(w), TRUE);
  }
#endif
 
  return(R_gtkWidgetReference(w,"GtkText"));
}


USER_OBJECT_
R_gtk_clearTextContents(USER_OBJECT_ swidget, USER_OBJECT_ pos)
{
  GtkWidget *w;

    w = GTK_WIDGET(getPtrValue(swidget));
    gtk_editable_delete_text(GTK_EDITABLE(w), INTEGER_DATA(pos)[0], INTEGER_DATA(pos)[1]);
    
    return(NULL_USER_OBJECT);
}

USER_OBJECT_
R_gtk_setTextContents(USER_OBJECT_ swidget, USER_OBJECT_ text, USER_OBJECT_ append)
{
  GtkWidget *w;
  char *vals;
  USER_OBJECT_ ans = NULL_USER_OBJECT;

    w = GTK_WIDGET(getPtrValue(swidget));
    vals = CHAR_DEREF(STRING_ELT(text, 0));
    gtk_text_insert(GTK_TEXT(w), NULL, NULL, NULL, vals, strlen(vals));
   return(ans);
}


USER_OBJECT_
R_gtk_getTextContents(USER_OBJECT_ swidget, USER_OBJECT_ range, USER_OBJECT_ hidden)
{
  GtkWidget *w;
  gchar *vals;
  USER_OBJECT_ ans;

    w = GTK_WIDGET(getPtrValue(swidget));

    vals = gtk_editable_get_chars(GTK_EDITABLE(w), 0, -1);
    PROTECT(ans = NEW_CHARACTER(1));
    SET_STRING_ELT(ans, 0, COPY_TO_USER_STRING(vals));
    UNPROTECT(1);
    return(ans);

#if 0
  GtkTextBuffer *buf;  
    buf = gtk_text_view_get_buffer(GTK_TEXT(w));
    gtk_text_buffer_get_text(buf, start, end, LOGICAL_DATA(hidden)[0]);
#endif

}

/**
 
*/
USER_OBJECT_
R_gtk_newBox(USER_OBJECT_ homogeneous, USER_OBJECT_ padding, USER_OBJECT_ vertical)
{
  GtkWidget *w;
  char *klassName;

  if(LOGICAL_DATA(vertical)[0]) {
     w = gtk_vbox_new(INTEGER_DATA(homogeneous)[0], INTEGER_DATA(padding)[0]);
     klassName = "GtkVBox";
  } else {
     w = gtk_hbox_new(INTEGER_DATA(homogeneous)[0], INTEGER_DATA(padding)[0]);
     klassName = "GtkHBox";
  }

  return(R_gtkWidgetReference(w,klassName));
}

/* These two routines are needed for Windows to be explicitly exported. 
  (Could do some tricks with the EXPORTS, but why bother!
*/
void
R_gtk_main()
{
    gtk_main();
}

void
R_gtk_main_quit()
{
    gtk_main_quit();
}


void
R_gtk_eventHandler(void *userData)
{
 while (gtk_events_pending())
    gtk_main_iteration();  
}


USER_OBJECT_
R_gtk_new(USER_OBJECT_ stype)
{
   GtkType type;
   GtkObject *obj;
   USER_OBJECT_ ans;

   if(IS_CHARACTER(stype)) {
     type = gtk_type_from_name(CHAR_DEREF(STRING_ELT(stype, 0)));
   } else if(IS_NUMERIC(stype)) {
     type = (GtkType) NUMERIC_DATA(stype)[0];
   }

   obj = gtk_type_new(type);
   ans = R_gtkWidgetReference((GtkWidget *) obj, "GtkObject");

   return(ans);
}


USER_OBJECT_
R_gtk_object_ref(USER_OBJECT_ ref, USER_OBJECT_ on)
{
   GtkObject *obj = GTK_OBJECT(getPtrValue(ref));
   if(obj) {
    if(LOGICAL_DATA(on)[0]) {
     gtk_object_ref(obj);
    } else
     gtk_object_unref(obj);
   }
   return(NULL_USER_OBJECT);
}
