# Copyright (c) 2002 Red Hat, Inc. All rights reserved.
#
# This software may be freely redistributed under the terms of the
# GNU General Public License.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Lock file handling routines
#
# Written for Red Hat Inc. by Neil Padgett <npadgett@redhat.com>
#
# Component of: Red Hat Database GUI Administration tool

# Note: Currently implemented used EXCL mode. There is a race if the lockfile
# is on NFS. This shouldn't be a problem as this is an interactive tool, so
# chances of hitting the race should be miniscule. (And the consequences are 
# also minimal.)

# Grabs lock file
# Returns true if successfully acquired, else false

package require mainMisc
package provide lockfile 1.0

set lockfile_haveLock 0

proc grabLockFile {} {
    global lockfile_haveLock
    global lockfile_fileId
    global configDir

    if { [catch {open [file join $configDir ".rhdb-admin.lock"] \
	    [list WRONLY CREAT EXCL]} lockfile_fileId] } {
	set lockfile_haveLock 0
    } else {
	set lockfile_haveLock 1
    }

    return $lockfile_haveLock
}

# Returns result of last lock acquisition attempt
# True if lock is held, else false

proc haveLockFile {} {
    global lockfile_haveLock

    return $lockfile_haveLock
}

# Release the lock file, if held

proc releaseLockFile {} {
    global lockfile_haveLock
    global lockfile_fileId
    global configDir
    global applicationName
    
    if { $lockfile_haveLock } {
        
	# Lock file exists, remove it and cleanly exit
        
	if {[file exists [file join $configDir ".rhdb-admin.lock"]]} {
            
	    # This next line isn't portable and is actually nasty in general
        
	    exec /bin/rm [file join $configDir ".rhdb-admin.lock"]
	    close $lockfile_fileId
	
	} else {

	    # Else it doesn't exist, indicate the trouble to the user
	    
	    # Show error dialog
            
	    tk_messageBox -icon error -title "Error" \
		-message "Error: The lockfile, [file join $configDir .rhdb-admin.lock], was deleted while $applicationName was running. Some configuration changes may be lost."
			  	    
	    # Close the window and exit
	    
	    close $lockfile_fileId
	}
	
    }
}
