#include "rheolef/rheolef.h"
#include "rheolef/uzawa_abtb.h"
using namespace rheolef;
using namespace std;

int main(int argc, char**argv) {
  geo  omega (argv[1]);
  space Vh (omega, "P2", "vector");
  space Qh  (omega, "P1");
  Vh.block("top");  Vh.block("bottom");
  Vh.block("left"); Vh.block("right");
  if (omega.dimension() == 3)
    { Vh[2].block("front");  Vh[2].block("back"); }
  field uh (Vh);
  uh["top"] = uh["bottom"] = uh["left"] = uh["right"] = 0;
  if (omega.dimension() == 3)
    uh[2]["front"] = uh[2]["back"] = 0;
  uh[0]["top"] = 1;

  field ph (Qh, 0.);
  form a (Vh, Vh, "2D_D");
  form b (Vh, Qh, "div");
  int   max_iter  = 50;
  Float tol       = 1e-12;
  Float r         = 1e+7;
  form ar = a + r*trans(b)*b;
  ssk<Float> fact = ldlt(ar.uu);
  uzawa_abtb (ar.uu, fact, b.uu, uh.u, ph.u, -(ar.ub*uh.b), -(b.ub*uh.b), r, max_iter, tol);

  cout << catchmark("u")  << uh
       << catchmark("p")  << ph;
}
