#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"../../../rheolef/nfem/tst"}
GEODIR=${GEODIR-"../../../rheolef/nfem/data"}

RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../basis"}
RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../basis"}
RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../form_element"}
export RHEOLEF_BASIS_PATH
export RHEOLEF_NUMBERING_PATH
export RHEOLEF_FORM_ELEMENT_PATH

# -------------------------------------------
#  form(Pk,Pk,mass)
#   P1, P2 : all polynoms in [0,1]^d, d=1,2,3
#  with simplicial geo elements [e,t,T]
#  and cartesian coordinate system
# -------------------------------------------
status=0
D="1 2 3"
for d in $D; do
  case $d in
  1) input="${GEODIR}/line-21";;
  2) input="${GEODIR}/carre-v2";;
  3) input="${GEODIR}/cube-tetra-1";;
  esac
  for approx in P0 P1 P2; do
    case $approx in
      P0 | P1) case $d in
         1) L="1 x";;
         2) L="1 x y";;
         3) L="1 x y z";;
         esac;;
      P2) case $d in
	 1) L="1 x x2";;
	 2) L="1 x x2 y xy y2";;
	 3) L="1 x x2 y xy y2 xz yz z2";;
         esac;;
    esac
    for w in $L; do
        command="./form_mass_weighted_tst -app ${approx} -weight ${w} ${input}"
        echo "      $command"
        eval $command >/dev/null 2>/dev/null
        if test $? -ne 0; then status=1; echo "        => *NO*"; fi
    done
  done
done

# -------------------------------------------
#  projections:
#
#  form(Pk,Pl,mass), k!=l
#  with simplicial geo elements [e,t,T]
#  and cartesian coordinate system
# -------------------------------------------

input="${GEODIR}/carre-v2"

projections="
P0_P1 P0_P1d  P0_P2  P0_P2d
      P1_P1d  P1_P2  P1_P2d
             P1d_P2 P1d_P2d
                     P2_P2d"
for d in $D; do
  case $d in
  1) input="${GEODIR}/line-21";;
  2) input="${GEODIR}/carre-v2";;
  3) input="${GEODIR}/cube-tetra-1";;
  esac
  for pair in $projections; do
    approx1=`echo $pair | awk -v FS="_" '{print $1}'`
    approx2=`echo $pair | awk -v FS="_" '{print $2}'`
    case ${approx1} in
      P0|P1|P1d) case $d in
         1) L="1 x";;
         2) L="1 x y";;
         3) L="1 x y z";;
         esac;;
      P2|P2d) case $d in
	 1) L="1 x x2";;
	 2) L="1 x x2 y xy y2";;
	 3) L="1 x x2 y xy y2 xz yz z2";;
         esac;;
    esac
    for w in $L; do
        command="./form_mass_weighted_tst -app ${approx1} -proj ${approx2} -weight ${w} ${input}"
        echo "      $command"
        eval $command >/dev/null 2>/dev/null
        if test $? -ne 0; then status=1; echo "        => *NO*"; fi
    done
  done
done


# -------------------------------------------
#  axisymmetry:
#
#  form(Pk,Pk,mass)
#   P1, P2 : all polynoms in [0,1]^2
#  with simplicial geo elements [t]
#  and axisymmetric coordinate system
# -------------------------------------------

APPROX="P1 P1d P2 P2d"

input="${GEODIR}/carre-v2"

for d in 2; do
  case $d in
  1) input="${GEODIR}/line-21";;
  2) input="${GEODIR}/carre-v2";;
  3) input="${GEODIR}/cube-tetra-1";;
  esac
  for approx in $APPROX; do
    case $approx in
      P1|P1d) case $d in
         1) L="1 x";;
         2) L="1 x y";;
         esac;;
      P2) case $d in
	 1) L="1 x x2";;
	 2) L="1 x x2 y xy y2";;
         esac;;
    esac
    for w in $L; do
        command="./form_mass_weighted_tst -app ${approx} -weight ${w} -rz ${input}"
        echo "      $command"
        eval $command >/dev/null 2>/dev/null
        if test $? -ne 0; then status=1; echo "        => *NO*"; fi
    done
  done
done
exit $status

