#ifndef _RHEO_GEN_SOLVER_H
#define _RHEO_GEN_SOLVER_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

/*Class:gen_solver
NAME: @code{direct_solver}, @code{iterative_solver} -- tags
@clindex direct_solver
@clindex iterative_solver
DESCRIPTION: 
  @noindent
  Solvers are splitted into two categories:
  direct and iteratives.
  These classes are convenient for algorithms implementation
  purpose.
AUTHOR: 
  LMC-IMAG, 38041 Grenoble cedex 9, France
  | Nicolas.Roquet@imag.fr
DATE:   24 sept 1997
METHODS: @gen_solver
End:
*/

#include "rheolef/skit.h"
namespace rheolef { 

//<gen_solver:
struct direct_solver {};

template<class Real>
class iterative_solver {
public:
// allocators/deallocators:

    iterative_solver(
        int            n_iter_max_init,
        Real           epsilon_init = 1.e-14,
	std::ostream*  p_clog_init  = 0,
	std::ostream*  p_cres_init  = 0);

// implementation:
protected:

    int           _n_iter_max;
    Real          _epsilon;
    std::ostream* _p_clog;
    std::ostream* _p_cres;
  
    // in case of IterativeAlgo.execute(..), use this :
    void bilan(int status, int n_iter, Real residu) const;
};
//>gen_solver:

template<class Real>
inline
iterative_solver<Real>::iterative_solver(
      int            n_iter_max_init,
      Real           epsilon_init,
      std::ostream*  p_clog_init,
      std::ostream*  p_cres_init)

: _n_iter_max(n_iter_max_init),
  _epsilon(epsilon_init),
  _p_clog(p_clog_init),
  _p_cres(p_cres_init)
{
}
template<class Real>
inline
void
iterative_solver<Real>::bilan(int status, int n_iter, Real residu) const
{
    if (_p_clog)
      {
	(*_p_clog) << "\nIterative Solver :\n\n" 
		   << " --- status     : " << status << "\n"  
		   << " --- iterations : " << n_iter << "(max="     << _n_iter_max << ")\n" 
		   << " --- residu     : " << residu << "(epsilon=" << _epsilon    << ")\n" ;
      }
}
}// namespace rheolef
#endif // _RHEO_GEN_SOLVER_H

