#ifndef BOOST_PP_IS_ITERATING
#ifndef _RHEOLEF_POLYMORHIC_SCATTER_MESSAGE_H
#define _RHEOLEF_POLYMORHIC_SCATTER_MESSAGE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// create parallel to sequential scatter context for polymorphic_array
//
#include "rheolef/polymorphic_data_vector.h"

namespace rheolef {

/// @brief scatter buffer for polymorphic_array
template<class T, class V, int NV>
struct polymorphic_scatter_buffer {};

/// @brief scatter mesage area handler for polymorphic_array
template<class T, class V, int NV>
struct polymorphic_scatter_message {};

// ----------------------------------------------------------
// run here the recursive inclusion of this file:
// ----------------------------------------------------------
// _RHEOLEF_POLYMORPHIC_MAX_SIZE was defined by "polymorphic_data_vector.h"
#define BOOST_PP_ITERATION_LIMITS (0, _RHEOLEF_POLYMORPHIC_MAX_SIZE)
#define BOOST_PP_FILENAME_1    "rheolef/polymorphic_scatter_message.h" // this file
#include BOOST_PP_ITERATE()

} // namespace rheolef
#endif // _RHEOLEF_POLYMORPHIC_SCATTER_MESSAGE_H
#else // BOOST_PP_IS_ITERATING
// ----------------------------------------------------------
// here, this file is recursively included with growing "N" :
// ----------------------------------------------------------
#define N    BOOST_PP_ITERATION()

template<class T, class V>
class polymorphic_scatter_message<T,V,N> {
public:
  typedef typename polymorphic_data_vector<T,V,N>::size_type size_type;
  static const size_type                          _n_variant = N;

// data:

  std::vector<boost::array<size_type,_n_variant> > start_variant; // n_proc+1

  // not used in polymorphic case: for compatibility with msg_scatter_init generic code:
  std::vector<size_type>         		starts;	  // n_proc+1

  std::vector<size_type>         		procs;	  // n_proc

  boost::array<std::list<std::pair<size_type,mpi::request> >,
               _n_variant>                      requests; // n_proc
  std::vector<size_type>         		indices;  // n_data
  
  polymorphic_data_vector<T,V,N>                values;   // n_data
  std::vector<mpi::status>  	                sstatus;  // n_status
    
  std::vector<size_type>       	local_slots;              // n_local
  std::vector<size_type>       	local_slots_nonmatching;
  bool 		       	    	local_nonmatching_computed;// n_local_nonmatching
  size_type 		        local_n_nonmatching;
  bool                 	    	local_is_copy;
  size_type 		       	local_copy_start;
  size_type                 	local_copy_length;

// allocator:

  polymorphic_scatter_message() 
  : start_variant(),
    starts(),
    procs(), 
    requests(), 
    indices(), 
    values(), 
    sstatus(),
    local_slots(),
    local_slots_nonmatching(),
    local_nonmatching_computed(false),
    local_n_nonmatching(0),
    local_is_copy(false),
    local_copy_start(0),
    local_copy_length(0)
  {}
  void resize (size_type n_data, size_type nproc) {
        start_variant.resize (nproc+1);
	starts.resize  (nproc+1);
	procs.resize   (nproc);
	indices.resize (n_data);
#ifdef TO_CLEAN
	values.resize  (n_data);
#endif // TO_CLEAN
  }
// accessors:

  size_type n_proc() const { return procs.size(); }
  size_type n_data() const { return indices.size(); }
  size_type n_status() const { return sstatus.size(); }
  size_type n_local() const { return local_slots.size(); }
  size_type n_local_nonmatching() const { return local_slots_nonmatching.size(); }
};
#endif // _RHEOLEF_POLYMORHIC_SCATTER_MESSAGE_H
