#ifndef _SHEWCHUK_H
#define _SHEWCHUK_H

#include "predicates.h"

namespace rheolef { 
#define wrap2d(wrap_name,shewchuk_name)			\
inline 							\
int wrap_name (double x1, double y1, double x2, double y2) \
{							\
  double a[2], b[2], c[2];				\
  a[0] = x1; a[1] = y1;					\
  b[0] = x2; b[1] = y2;					\
  c[0] = 0;  c[1] = 0;					\
  double r = shewchuk_name (a, b, c);			\
  return (r > 0) ? 1 : ((r < 0) ? -1 : 0);		\
}
wrap2d (ABDPY_det2x2,           orient2d)
wrap2d (ABDPY_secure_det2x2,    orient2dexact)
wrap2d (ABDPY__not_lazy_det2x2, orient2dslow)
//wrap2d (double_det2x2,          orient2dfast)
//wrap2d (quadruple_det2x2,       orient2dfast)
#undef wrap2d

#define wrap3d(wrap_name,shewchuk_name)			\
inline 							\
int wrap_name (double x1, double y1, double z1,		\
               double x2, double y2, double z2,		\
               double x3, double y3, double z3)		\
{							\
  double a[3], b[3], c[3], d[3];				\
  a[0] = x1; a[1] = y1;	a[2] = z1;			\
  b[0] = x2; b[1] = y2;	b[2] = z2;			\
  c[0] = x3; c[1] = y3;	c[2] = z3;			\
  d[0] = 0;  d[1] = 0;  d[2] = 0;			\
  double r = shewchuk_name (a, b, c, d);			\
  return (r > 0) ? 1 : ((r < 0) ? -1 : 0);		\
}
wrap3d (ABDPY_det3x3,           orient3d)
wrap3d (ABDPY_secure_det3x3,    orient3dexact)
wrap3d (ABDPY__not_lazy_det3x3, orient3dslow)
//wrap3d (double_det3x3,          orient3dfast)
#undef wrap3d

}// namespace rheolef
#endif // _SHEWCHUK_H
