#ifndef _RHEO_D_DS_D_DS_H
#define _RHEO_D_DS_D_DS_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

/*Class:d_ds
NAME: @code{d_ds_d_ds} -- Curvilinear derivative
@bfindex d_ds_d_ds
@apindex P0
@apindex P1
@apindex P2
@apindex P1d
@clindex domain
@clindex space
@cindex  boundary conditions
SYNOPSIS:
    @example
        form(const space& V, const space& W, "d_ds_d_ds");
    @end example
DESCRIPTION:       
    @noindent
    Assembly the matrix associated to the following integral:
@iftex
    $$
   	m(u,v) = \int_\Gamma  du/ds dv/ds \, ds
    $$
@end iftex
@ifnottex
    @example
                 /
                 |
   	m(u,v) = |  du/ds dv/ds ds
                 |
                 / Gamma
    @end example
@end ifnottex
    @noindent
    The V and W space may be either a 
    @code{P0}, @code{P1}, @code{P2},
    or @code{P1d}
    finite 
    element space for building a form
    @pxref{form class}.
  
AUTHOR: 
    Spectro Grenoble--CNRS, 38402 St-Martin-d'Heres cedex, France
    | Jocelyn.Etienne@ujf-grenoble.fr
DATE:
    20 July 2007
End:
*/

#include "rheolef/form_element_rep.h"
namespace rheolef { 

class d_ds_d_ds: public form_element_rep {
public:
// allocator:

    d_ds_d_ds() : form_element_rep() {}

// virtual accessor:

    void operator() (const geo_element& K, ublas::matrix<Float>& m) const;
    void check_after_initialize () const;
};
}// namespace rheolef
#endif // _RHEO_D_DS_D_DS_H
