#ifndef _RHEO_ADAPT_OPTION_H
#define _RHEO_ADAPT_OPTION_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/compiler.h"
namespace rheolef { 

/*Class:
NAME: @@code{adapt_option_type} - options for bamg mesh generator
END: */

struct adapt_option_type {
    typedef std::vector<int>::size_type size_type;
    std::string generator;
    Float err;
    Float hcoef;
    Float hmin;
    Float hmax;
    Float ratio;
    Float cutoff;
    size_type n_vertices_max;
    size_type n_smooth_metric;
    bool splitpbedge;
    Float thetaquad;
    Float anisomax;
    bool clean;
    std::string additional;
    bool double_precision;
    adapt_option_type() :
        generator("bamg"),
	err(1e-2), hcoef(1), hmin(0.0001), hmax(0.3), ratio(0), cutoff(1e-7),
	n_vertices_max(50000), n_smooth_metric(1), 
	splitpbedge(false), thetaquad(std::numeric_limits<Float>::max()),
	anisomax(1e6), clean(false), additional("-AbsError"), double_precision(false)
     {}
};
}// namespace rheolef
#endif // _RHEO_ADAPT_OPTION_H
