///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is sequential in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/geo_domain.h"

namespace rheolef {

template <class T>
void
geo_rep<T,sequential>::build_from_domain (
    const domain_indirect_rep<sequential>&    indirect, 
    const geo_abstract_rep<T,sequential>& bgd_omega)
{
  base::_name = bgd_omega.name() + "." + indirect.name();
  base::_version = 1; // not yet connectivity
  base::_dimension     = bgd_omega.dimension();
  base::_map_dimension = indirect.map_dimension();
  size_type map_dim = base::_map_dimension;
  // -------------------------------------
  // part 1 : vertex compact re-numbering
  // -------------------------------------
  // 1.1 loop on elements and mark used vertices
  array<size_type> bgd_iv_is_on_domain     (bgd_omega.geo_element_ownership(0),     0); // logical, init to "false"
  for (size_type ioige = 0, noige = indirect.size(); ioige < noige; ioige++) {
    size_type ige = indirect.oige (ioige).index();
    const geo_element& S = bgd_omega.get_geo_element (map_dim, ige);
    for (size_type iloc = 0; iloc < S.size(); iloc++) {
      size_type bgd_dis_iv = S[iloc];
      bgd_iv_is_on_domain.dis_entry (bgd_dis_iv) = 1;
    }
  }
  // 1.2 counting & distribution for dom_iv 
  size_type dom_nv = 0;
  for (size_type bgd_iv = 0, bgd_nv = bgd_omega.geo_element_ownership(0).size(); bgd_iv < bgd_nv; bgd_iv++) {
    if (bgd_iv_is_on_domain[bgd_iv] != 0) dom_nv++ ;
  }
  // 1.3 numbering dom_iv & permutation: bgd_iv <--> dom_iv
  array<size_type> bgd_iv2dom_iv (bgd_omega.geo_element_ownership(0), std::numeric_limits<size_type>::max());
  array<size_type> dom_iv2bgd_iv (dom_nv, std::numeric_limits<size_type>::max());
  for (size_type dom_iv = 0, bgd_iv = 0, bgd_nv = bgd_omega.geo_element_ownership(0).size(); bgd_iv < bgd_nv; bgd_iv++) {
    if (bgd_iv_is_on_domain[bgd_iv] == 0) continue;
    bgd_iv2dom_iv [bgd_iv] = dom_iv;
    dom_iv2bgd_iv [dom_iv] = bgd_iv;
    dom_iv++;
  }
  //
  // 2) defines geo_element[0] and P.set_ios_dis_ie
  //
  base::_geo_element[0].resize (dom_nv);
  for (size_type dom_iv = 0; dom_iv < dom_nv; dom_iv++) {
    size_type bgd_iv = dom_iv2bgd_iv [dom_iv];
    base::_geo_element[0][dom_iv] = geo_element_p (dom_iv);
    geo_element& P = base::_geo_element[0][dom_iv];
    P.set_ios_dis_ie (dom_iv);
    P.set_dis_ie     (dom_iv);
  }
  //
  // 3) raw copy vertices  
  // TODO: use shallow copy & indirection in vertex(iv) access via bgd_omega.vertex(renum(iv))
  //
  base::_vertex.resize (dom_nv);
  for (size_type dom_iv = 0; dom_iv < dom_nv; dom_iv++) {
    size_type bgd_iv = dom_iv2bgd_iv [dom_iv];
    base::_vertex [dom_iv] = bgd_omega.vertex (bgd_iv);
  }
  //
  // 4) copy element with compact vertex numbering
  //
  if (map_dim > 0) {
    base::_geo_element[map_dim].resize (indirect.ownership());
    for (size_type ioige = 0, noige = indirect.size(); ioige < noige; ioige++) {
      size_type ige = indirect.oige (ioige).index();
      geo_element::intrusive_set (base::_geo_element[map_dim][ioige], bgd_omega.get_geo_element (map_dim, ige));
      geo_element& S = base::_geo_element[map_dim][ioige];
      // TODO: apply also orientation to S
      for (size_type iloc = 0; iloc < S.size(); iloc++) {
        size_type bgd_iv = S[iloc];
        size_type dom_iv = bgd_iv2dom_iv [bgd_iv];
        S[iloc] = dom_iv;
      }
      S.set_ios_dis_ie (ioige);
      S.set_dis_ie     (ioige);
    }
  }
  //
  // 5) size by
  //
  base::reset_size_by();
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class geo_rep<Float,sequential>;

} // namespace rheolef
