#include <iostream>
#include <vector>
#include <string>
using namespace std;
typedef string s;
struct rhs { // + - *...
  s name, ref;
  rhs(s n="", s r="") : name(n), ref(r) {} 
};
struct op { // + - *...
  s name, tag;
  op(s n="", s t="") : name(n), tag(t) {} 
};
struct aop { // assign_op: += -= ...
  s name, long_name;
  aop(s n="", s ln="") : name(n), long_name(ln) {} 
};
enum size_check_t { no_check, class_check, expr_check, expr2_check };
struct func { // abs sqrt...
  s f, std_f;
  func (s f1) : f(f1), std_f(f1) {}
  func (s f1, s std_f1) : f(f1), std_f(std_f1) {}
};
void header() {
  cout << "#ifndef _RHEOLEF_VEC_EXPR_OPS_H" << endl
       << "#define _RHEOLEF_VEC_EXPR_OPS_H" << endl
       << "// do not edit !" << endl
       << "// this file has been automatically generated by the command:" << endl
       << "// " << endl
       << "//	  ./vec_expr_ops_make > vec_expr_ops.h" << endl
       << "// " << endl
       << "// ==========================================================================" << endl
       << "//" << endl
       << "// This file is part of Rheolef." << endl
       << "//" << endl
       << "// Copyright (C) 2000-2009 Pierre Saramito " << endl
       << "//" << endl
       << "// Rheolef is free software; you can redistribute it and/or modify" << endl
       << "// it under the terms of the GNU General Public License as published by" << endl
       << "// the Free Software Foundation; either version 2 of the License, or" << endl
       << "// (at your option) any later version." << endl
       << "// " << endl
       << "// Rheolef is distributed in the hope that it will be useful," << endl
       << "// but WITHOUT ANY WARRANTY; without even the implied warranty of" << endl
       << "// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the" << endl
       << "// GNU General Public License for more details." << endl
       << "//" << endl
       << "// You should have received a copy of the GNU General Public License" << endl
       << "// along with Rheolef; if not, write to the Free Software" << endl
       << "// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA" << endl
       << "// " << endl
       << "// ==========================================================================" << endl
       << "// " << endl
       << "// vec: template expressions" << endl
       << "//" << endl
       << "// author: Pierre.Saramito@imag.fr" << endl
       << "//" << endl
       << "// date: 20 march 2011" << endl
       << "//" << endl
       << "#include \"rheolef/vec_expr.h\"" << endl
       << "#include \"rheolef/promote.h\"" << endl
       << "namespace rheolef {" << endl
       ;
}
void footer() {
  cout << "} // namespace rheolef" << endl
       << "#endif // _RHEOLEF_VEC_EXPR_OPS_H" << endl
      ;
}
// =====================================================================================
// part 1 : binary operations x+y x-y ...
// =====================================================================================
void binop_profile (s op, s tag, s trait, s domain, s left, s right) {
  cout << "typename" << endl
       << "boost::proto::detail::enable_binary<" << endl
       << "  " << domain << "," << endl
       << "  " << trait << "<" << left << " >," << endl
       << "  " << left << "," << endl
       << "  " << trait << "<" << right << " >," << endl
       << "  " << right << "," << endl
       << "  typename boost::proto::functional::make_expr<" << tag << ", " << domain << ">" << endl
       << "    ::impl<const " << left << "&,   const " << right << "&>::result_type const" << endl
       << ">::type" << endl
       << "operator" << op << " (const " << left << "& l, const " << right << "& r)" << endl
       << "{" << endl
       << "  return boost::proto::functional::make_expr<" << tag << ", " << domain << ">" << endl
       << "    ::impl<const " << left << "&,   const " << right << "&>() (l, r);" << endl
       << "}" << endl
     ;
}
// -----------------------------------------------------------------------------
/* example:			abbrev

   int 				i
   T				t	n_scalar=2

   vec<T,M>			F

   vec_expr<E>		E	expr

  => binary matrix profile :

                iF   iE
                tF   tE

	Fi Ft   FF   FE

	Ei Et   EF   EE

  template:
     xY	Xy => template<T,M>		x=i,t  X=F
	XY => template<T1,T2,M>		X,Y=F
     iE Ei => template<E>		x=i
     tE Et => template<T,E>		x=t
     XE EX => template<E,T,M>		X=F
     EE    => template<E1,E2>
*/
// -----------------------------------------------------------------------------
void binop (s op, s tag, s trait, s domain, const vector<s>& Class, s expr) {
  // xY
  for (size_t j = 0, nc = Class.size();  j < nc; j++) {
    cout << "template<class T, class M>" << endl;
    binop_profile (op, tag, trait, domain, "int", Class[j] + "<T,M>");
    cout << "template<class T, class M>" << endl;
    binop_profile (op, tag, trait, domain, "T",   Class[j] + "<T,M>");
  }
  // Xy
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template<class T, class M>" << endl;
    binop_profile (op, tag, trait, domain, Class[i] + "<T,M>", "int");
    cout << "template<class T, class M>" << endl;
    binop_profile (op, tag, trait, domain, Class[i] + "<T,M>", "T");
  }
  // XY
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
  for (size_t j = 0, nd = Class.size();  j < nd; j++) {
    cout << "template<class T1, class T2, class M>" << endl;
    binop_profile(op, tag, trait, domain, Class[i] + "<T1,M>", Class[j] + "<T2,M>");
  }}
  // xE, Ex
  cout << "template<class Expr>" << endl;
  binop_profile(op, tag, trait, domain, "int", expr + "<Expr>");
  cout << "template<class Expr>" << endl;
  binop_profile(op, tag, trait, domain, expr + "<Expr>", "int");
  cout << "template<class T, class Expr>" << endl;
  binop_profile(op, tag, trait, domain, "T", expr + "<Expr>");
  cout << "template<class T, class Expr>" << endl;
  binop_profile(op, tag, trait, domain, expr + "<Expr>", "T");
  // XE, EX
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template<class T, class M, class Expr>" << endl;
    binop_profile(op, tag, trait, domain, Class[i] + "<T,M>", expr + "<Expr>");
    cout << "template<class T, class M, class Expr>" << endl;
    binop_profile(op, tag, trait, domain, expr + "<Expr>", Class[i] + "<T,M>");
  }
  // EE
  cout << "template<class Expr1, class Expr2>" << endl;
  binop_profile(op, tag, trait, domain, expr + "<Expr1>", expr + "<Expr2>");
}
// -----------------------------------------------------------------------------
void all_binops (s trait, s domain, const vector<op>& Op, const vector<s>& Class, s expr) {
  for (size_t i = 0, nop = Op.size();  i < nop; i++) {
    binop (Op[i].name, Op[i].tag, trait, domain, Class, expr);
  }
}
// =====================================================================================
// part 2 : unary operations +x, -x
// =====================================================================================
void unop_profile (s op, s tag, s trait, s domain, s x) {
  cout << "typename boost::proto::detail::enable_unary<" << endl
       << "  " << domain << "," << endl
       << "  " << trait << "<" << x << " >," << endl
       << "  " << x << "," << endl
       << "  typename boost::proto::functional::make_expr<" << tag << ", " << domain << ">"  << endl
       << "   ::impl<const " << x << "&>::result_type" << endl
       << "  >::type const" << endl
       << "operator" << op << " (const " << x << "& arg)" << endl
       << "{" << endl
       << "  return boost::proto::functional::make_expr<" << tag << ", " << domain << ">" << endl
       << "   ::impl<const " << x << "&>()(arg);" << endl
       << "}" << endl
    ;
}
// -----------------------------------------------------------------------------
void unop (s op, s tag, s trait, s domain, const vector<s>& Class, s expr) {
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template<class T, class M>" << endl;
    unop_profile (op, tag, trait, domain, Class[i] + "<T,M>");
  }
  cout << "template<class Expr>" << endl;
  unop_profile (op, tag, trait, domain, expr + "<Expr>");
}
// -----------------------------------------------------------------------------
void all_unops (s trait, s domain, const vector<op>& Op, const vector<s>& Class, s expr) {
  for (size_t i = 0, nop = Op.size();  i < nop; i++) {
    unop (Op[i].name, Op[i].tag, trait, domain, Class, expr);
  }
}
// =====================================================================================
// part 3 : unary std math functions:
// =====================================================================================
void ufunc_declare (s f, s std_f, s details) {
  cout << "namespace " << details << " {" << endl
       << "  struct " << f << "_ {" << endl
       << "    template<class Sig>" << endl
       << "    struct result;" << endl
       << endl
       << "    template<class This, class T>" << endl
       << "    struct result<This(T)> : boost::remove_const<typename boost::remove_reference<T>::type> {};" << endl
       << endl
       << "    template<class T>" << endl
       << "    T operator() (const T& x) const { return " << std_f << "(x); }" << endl
       << "  };" << endl
       << "} // namespace " << details << endl
    ;       
}
void ufunc_profile (s f, s tag, s domain, s details, s x) {
  cout << "typename boost::proto::result_of::make_expr<" << endl
       << "    " << tag << "," << endl
       << "    " << domain << "," << endl
       << "    " << "const " << details << "::" << f << "_," << endl
       << "    " << "const " << x << "&" << endl
       << "  >::type" << endl
       << f << " (const " << x << "& x)" << endl
       << "{" << endl
       << "    return boost::proto::make_expr<" << tag << ", " << domain << "> ("
		<< details << "::" << f << "_(), boost::ref(x));" << endl
       << "}" << endl
    ;
}
void ufunc (s f, s std_f, s tag, s domain, s details, const vector<s>& Class, s expr) {
  ufunc_declare (f, std_f, details);
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template<class T, class M>" << endl;
    ufunc_profile (f, tag, domain, details, Class[i] + "<T,M>");
  }
  cout << "template<class Expr>" << endl;
  ufunc_profile (f, tag, domain, details, expr + "<Expr>");
}
void all_ufunc (s tag, s domain, s details, const vector<func>& Ufunc, const vector<s>& Class, s expr) {
  for (size_t i = 0, nf = Ufunc.size(); i < nf; i++) {
    ufunc (Ufunc[i].f, Ufunc[i].std_f, tag, domain, details, Class, expr);
  }
}
// =====================================================================================
// part 4 : binary std math functions:
// =====================================================================================
void bifunc_declare (s f, s std_f, s details) {
  cout << "namespace " << details << " {" << endl
       << "  struct " << f << "_ {" << endl
       << "    template<class Sig>" << endl
       << "    struct result;" << endl
       << endl
       << "    template<class This, class U, class V>" << endl
       << "    struct result<This(U,V)> : boost::remove_const<" << endl
       << "      typename promote<" << endl
       << "        typename boost::remove_const<typename boost::remove_reference<U>::type>::type," << endl
       << "        typename boost::remove_const<typename boost::remove_reference<V>::type>::type"  << endl
       << "      >::type> {};" << endl
       << endl
       << "    template<class U, class V>" << endl
       << "    typename promote<" << endl
       << "        typename boost::remove_const<typename boost::remove_reference<U>::type>::type," << endl
       << "        typename boost::remove_const<typename boost::remove_reference<V>::type>::type >::type" << endl
       << "    operator() (const U& x, const V& y) const { return " << std_f << "(x,y); }" << endl
       << "  };" << endl
       << "} // namespace " << details << endl
    ;       
}
void bifunc_profile (s f, s tag, s domain, s details, s x, s y) {
  cout << "typename boost::proto::result_of::make_expr<" << endl
       << "    " << tag << "," << endl
       << "    " << domain << "," << endl
       << "    " << "const " << details << "::" << f << "_," << endl
       << "    " << "const " << x << "&," << endl
       << "    " << "const " << y << "&" << endl
       << "  >::type" << endl
       << f << " (const " << x << "& x, const " << y << "& y)" << endl
       << "{" << endl
       << "    return boost::proto::make_expr<" << tag << ", " << domain << "> ("
		<< details << "::" << f << "_(), boost::ref(x), boost::ref(y));" << endl
       << "}" << endl
    ;
}
/*
  => binary profile :

                iF iG iH   iE
                tF tG tH   tE

	Fi Ft   FF FG FH   FE
	Gi Gt   GF GG GH   GE
	Hi Ht   HF HG HH   HE

	Ei Et   EF EG EH   EE
*/
void bifunc (s f, s std_f, s tag, s domain, s details, const vector<s>& Class, s expr) {
  bifunc_declare (f, std_f, details);
  // xY
  for (size_t j = 0, nd = Class.size();  j < nd; j++) {
    cout << "template<class T, class M>" << endl;
    bifunc_profile (f, tag, domain, details, "int", Class[j] + "<T,M>");
    cout << "template<class T1, class T2, class M>" << endl;
    bifunc_profile (f, tag, domain, details, "T1", Class[j] + "<T2,M>");
  }
  // Xy
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template<class T, class M>" << endl;
    bifunc_profile (f, tag, domain, details, Class[i] + "<T,M>", "int");
    cout << "template<class T1, class T2, class M>" << endl;
    bifunc_profile (f, tag, domain, details, Class[i] + "<T1,M>", "T2");
  }
  // XY
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
  for (size_t j = 0, nd = Class.size();  j < nd; j++) {
    cout << "template<class T1, class T2, class M>" << endl;
    bifunc_profile (f, tag, domain, details, Class[i] + "<T1,M>", Class[j] + "<T2,M>");
  }}
  // xE, Ey
  cout << "template<class Expr>" << endl;
  bifunc_profile (f, tag, domain, details, "int", expr + "<Expr>");
  cout << "template<class T, class Expr>" << endl;
  bifunc_profile (f, tag, domain, details, "T", expr + "<Expr>");
  cout << "template<class Expr>" << endl;
  bifunc_profile (f, tag, domain, details, expr + "<Expr>", "int");
  cout << "template<class T, class Expr>" << endl;
  bifunc_profile (f, tag, domain, details, expr + "<Expr>", "T");
  // XE, EY
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template<class T, class M, class Expr>" << endl;
    bifunc_profile (f, tag, domain, details, Class[i] + "<T,M>", expr + "<Expr>");
    cout << "template<class T, class M, class Expr>" << endl;
    bifunc_profile (f, tag, domain, details, expr + "<Expr>", Class[i] + "<T,M>");
  }
  // EE
  cout << "template<class Expr1, class Expr2>" << endl;
  bifunc_profile (f, tag, domain, details, expr + "<Expr1>", expr + "<Expr2>");
}
void all_bifunc (s tag, s domain, s details, const vector<func>& Ufunc, const vector<s>& Class, s expr) {
  for (size_t i = 0, nf = Ufunc.size(); i < nf; i++) {
    bifunc (Ufunc[i].f, Ufunc[i].std_f, tag, domain, details, Class, expr);
  }
}
// =====================================================================================
// part 5 : unary interpolate compose function: vh=compose(f,uh) aka vh = pi_h(f o uh)
// =====================================================================================
void ucompose_declare (s f, s details) {
  cout << "namespace " << details << " {" << endl
       << "  template<class Function>" << endl
       << "  struct " << f << "_ {" << endl
       << "    " << f << "_ (const Function& f) : _f(f) {}" << endl
       << "    Function _f;" << endl
       << endl
       << "    template<class Sig> struct result;" << endl
       << endl
       << "    template<class This, class T>" << endl
       << "    struct result<This(T)> : boost::remove_const<typename boost::remove_reference<T>::type> {};" << endl
       << endl
       << "    template<class T>" << endl
       << "    T operator() (const T& x) const { return _f (x); }" << endl
       << "  };" << endl
       << "  template<class Arg, class Result>" << endl
       << "  struct " << f << "_<Result(Arg)> {" << endl
       << "    " << f << "_ (Result (*f)(Arg)) : _f(std::ptr_fun(f)) {}" << endl
       << "    std::pointer_to_unary_function<Arg,Result> _f;" << endl
       << endl
       << "    template<class Sig> struct result;" << endl
       << endl
       << "    template<class This, class U>" << endl
       << "    struct result<This(U)> : boost::remove_const<typename boost::remove_reference<Result>::type> {};" << endl
       << endl
       << "    Result operator() (Arg x) const { return _f (x); }" << endl
       << "  };" << endl
       << "} // namespace " << details << endl
     ;
}
void ucompose_profile (s f, s tag, s domain, s details, s x) {
  cout << "typename boost::proto::result_of::make_expr<" << endl
       << "    " << tag << "," << endl
       << "    " << domain << "," << endl
       << "    const " << details << "::" << f << "_<Function>," << endl
       << "    const " << x << "&" << endl
       << "  >::type" << endl
       << f << " (const Function& f, const " << x << "& x)" << endl
       << "{" << endl
       << "    return boost::proto::make_expr<" << tag << ", " << domain << ">" << endl
       << "	(" << details << "::" << f << "_<Function>(f), boost::ref(x));" << endl
       << "}" << endl
    ;
}
void ucompose (s tag, s domain, s details, s f, const vector<s>& Class, s expr) {
  ucompose_declare (f, details);
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template<class Function, class T, class M>" << endl;
    ucompose_profile (f, tag, domain, details, Class[i] + "<T,M>");
  }
  cout << "template<class Function, class Expr>" << endl;
  ucompose_profile (f, tag, domain, details, expr + "<Expr>");
}
// =====================================================================================
// part 6 : binary interpolate compose function: wh=compose(f,uh,vh) aka wh = pi_h(f(uh,vh))
// =====================================================================================
void bicompose_declare (s f, s details) {
  cout << "namespace " << details << " {" << endl
       << "  template<class Function>" << endl
       << "  struct " << f << "2_ {" << endl
       << "    " << f << "2_ (const Function& f) : _f(f) {}" << endl
       << "    Function _f;" << endl
       << endl
       << "    template<class Sig> struct result;" << endl
       << endl
       << "    template<class This, class U, class V>" << endl
       << "    struct result<This(U,V)> : boost::remove_const<" << endl
       << "      typename promote<" << endl
       << "        typename boost::remove_const<typename boost::remove_reference<U>::type>::type," << endl
       << "        typename boost::remove_const<typename boost::remove_reference<V>::type>::type"  << endl
       << "      >::type> {};" << endl
       << endl
       << "    template<class U, class V>" << endl
       << "    typename promote<" << endl
       << "        typename boost::remove_const<typename boost::remove_reference<U>::type>::type," << endl
       << "        typename boost::remove_const<typename boost::remove_reference<V>::type>::type >::type" << endl
       << "    operator() (const U& x, const V& y) const { return _f (x); }" << endl
       << "  };" << endl
       << "  template<class Arg1, class Arg2, class Result>" << endl
       << "  struct " << f << "2_<Result(Arg1,Arg2)> {" << endl
       << "    " << f << "2_ (Result (*f)(Arg1,Arg2)) : _f(std::ptr_fun(f)) {}" << endl
       << "    std::pointer_to_binary_function<Arg1,Arg2,Result> _f;" << endl
       << endl
       << "    template<class Sig> struct result;" << endl
       << endl
       << "    template<class This, class U, class V>" << endl
       << "    struct result<This(U,V)> : boost::remove_const<" << endl
       << "      typename promote<" << endl
       << "        typename boost::remove_const<typename boost::remove_reference<U>::type>::type," << endl
       << "        typename boost::remove_const<typename boost::remove_reference<V>::type>::type"  << endl
       << "      >::type> {};" << endl
       << endl
       << "    Result operator() (Arg1 x, Arg2 y) const { return _f (x,y); }" << endl
       << "  };" << endl
       << "} // namespace " << details << endl
     ;
}
void bicompose_profile (s f, s tag, s domain, s details, s x, s y) {
  cout << "typename boost::proto::result_of::make_expr<" << endl
       << "    " << tag << "," << endl
       << "    " << domain << "," << endl
       << "    const " << details << "::" << f << "2_<Function>," << endl
       << "    const " << x << "&," << endl
       << "    const " << y << "&" << endl
       << "  >::type" << endl
       << f << " (const Function& f, const " << x << "& x, const " << y << "& y)" << endl
       << "{" << endl
       << "    return boost::proto::make_expr<" << tag << ", " << domain << ">" << endl
       << "	(" << details << "::" << f << "2_<Function>(f), boost::ref(x), boost::ref(y));" << endl
       << "}" << endl
    ;
}
/*
  => binary profile :

                iF iG iH   iE
                tF tG tH   tE

	Fi Ft   FF FG FH   FE
	Gi Gt   GF GG GH   GE
	Hi Ht   HF HG HH   HE

	Ei Et   EF EG EH   EE
*/
void bicompose (s tag, s domain, s details, s f, const vector<s>& Class, s expr) {
  bicompose_declare (f, details);
  // xY, Xy
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template<class Function, class T, class M>" << endl;
    bicompose_profile (f, tag, domain, details, "int", Class[i] + "<T,M>");
    cout << "template<class Function, class T, class M>" << endl;
    bicompose_profile (f, tag, domain, details, Class[i] + "<T,M>", "int");
    cout << "template<class Function, class T1, class T2, class M>" << endl;
    bicompose_profile (f, tag, domain, details, "T1", Class[i] + "<T2,M>");
    cout << "template<class Function, class T1, class T2, class M>" << endl;
    bicompose_profile (f, tag, domain, details, Class[i] + "<T1,M>", "T2");
  }
  // XY
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
  for (size_t j = 0, nd = Class.size();  j < nd; j++) {
    cout << "template<class Function, class T1, class T2, class M>" << endl;
    bicompose_profile (f, tag, domain, details, Class[i] + "<T1,M>", Class[j] + "<T2,M>");
  }}
  // xE, Ey
  cout << "template<class Function, class Expr>" << endl;
  bicompose_profile (f, tag, domain, details, "int", expr + "<Expr>");
  cout << "template<class Function, class Expr>" << endl;
  bicompose_profile (f, tag, domain, details, expr + "<Expr>", "int");
  cout << "template<class Function, class T, class Expr>" << endl;
  bicompose_profile (f, tag, domain, details, "T", expr + "<Expr>");
  cout << "template<class Function, class T, class Expr>" << endl;
  bicompose_profile (f, tag, domain, details, expr + "<Expr>", "T");
  // XE, EY
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template<class Function, class Expr, class T, class M>" << endl;
    bicompose_profile (f, tag, domain, details, Class[i] + "<T,M>", expr + "<Expr>");
    cout << "template<class Function, class Expr, class T, class M>" << endl;
    bicompose_profile (f, tag, domain, details, expr + "<Expr>", Class[i] + "<T,M>");
  }
  // EE
  cout << "template<class Function, class Expr1, class Expr2>" << endl;
  bicompose_profile (f, tag, domain, details, expr + "<Expr1>", expr + "<Expr2>");
}
// =====================================================================================
// part 7 : assign_op : x += y[dom]; y[dom] *= 2; etc
// =====================================================================================
void assign_op_declare (s op, s long_name, s details) {
  cout << "namespace " << details << " {" << endl
       << "    struct " << long_name << " {" << endl
       << "        template<class T, class U>" << endl
       << "        void operator() (T &t, const U &u) const { t " << op << " u; }" << endl
       << "    };" << endl
       << "} // namespace " << details << endl
    ;
}
void assign_op_profile (s op, s long_name, s trait, s domain, s details, s left, s right, size_check_t size_check = no_check) {
  cout << left << endl
       << "operator" << op << " (" << left << " l, const " << right << "& r)" << endl
       << "{" << endl;
  if (size_check == class_check) {
     cout << "  check_macro (l.size() == r.size(), \"incompatible spaces \" << l.size()" << endl
          << "    << \" and \" << r.size() << \" in vec " << op << " expression\");" << endl
       ;
  } else if (size_check == expr_check) {
    cout << "  const vec_check_size_context check_size (l.size());" << endl
         << "  proto::eval (proto::as_expr<vec_domain>(r), check_size);" << endl
      ;
  }
  cout << "  " << details << "::evaluate (l.begin(), l.end(), proto::as_expr<vec_domain>(r), " << details << "::" << long_name << "());" << endl
       << "  return l;" << endl
       << "}" << endl
    ;
}
/*
  The first arg may be modifiable :
  operator += (X&, const Y&) {...}

  => binary profile :
	X = vec_basic, vec_indirect
	Y = any itFGHE
*/
void assign_op_x (s op, s long_name, s trait, s domain, s details, s x, s xref, const vector<s>& Class, s expr)
{
  // Xi, Xt
  cout << "template<class T, class M>" << endl;
  assign_op_profile (op, long_name, trait, domain, details, x + "<T,M>" + xref, "int");
  cout << "template<class T1, class T2, class M>" << endl;
  assign_op_profile (op, long_name, trait, domain, details, x + "<T1,M>" + xref, "T2");
  // XY
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template<class T1, class T2, class M>" << endl;
    assign_op_profile (op, long_name, trait, domain, details, x + "<T1,M>" + xref, Class[i] + "<T2,M>", class_check);
  }
  // XE
  cout << "template<class T, class M, class Expr>" << endl;
  assign_op_profile (op, long_name, trait, domain, details, x + "<T,M>" + xref, expr + "<Expr>", expr_check);
}
// -----------------------------------------------------------------------------
void assign_op (s op, s long_name, s trait, s domain, s details, const vector<rhs>& Rhsclass, const vector<s>& Class, s expr)
{
  assign_op_declare (op, long_name, details);
  for (size_t k = 0, n = Rhsclass.size(); k < n; k++) {
    assign_op_x (op, long_name, trait, domain, details, Rhsclass[k].name, Rhsclass[k].ref, Class, expr);
  }
}
// -----------------------------------------------------------------------------
void all_assign_ops (s trait, s domain, s details, const vector<aop>& Op, const vector<rhs>& Rhsclass, const vector<s>& Class, s expr) {
  for (size_t i = 0, nop = Op.size();  i < nop; i++) {
    assign_op (Op[i].name, Op[i].long_name, trait, domain, details, Rhsclass, Class, expr);
  }
}
// =====================================================================================
// part 8 : dot(.,.)
// =====================================================================================
// TODO: when T=complex<U> ==> conjugate and return the U type
void dot_profile (s left, s right, size_check_t size_check = no_check) {
  cout << "dot (const " << left << "& x, const " << right << "& y)" << endl
       << "{" << endl
       << "  return dis_inner_product (x.begin(), y.begin(), x.size(), x.ownership().comm());" << endl
       << "}" << endl
    ;
}
void dot_profile_rscal (s left, s right) {
  cout << "dot (const " << left << "& x, const " << right << "& y)" << endl
       << "{" << endl
       << "  return y*dis_accumulate (x.begin(), x.size(), x.ownership().comm());" << endl
       << "}" << endl
    ;
}
void dot_profile_lscal (s left, s right) {
  cout << "dot (const " << left << "& x, const " << right << "& y)" << endl
       << "{" << endl
       << "  return x*dis_accumulate (y.begin(), y.size(), y.ownership().comm());" << endl
       << "}" << endl
    ;
}
/*
  => binary profile :

                iF iG iH   iE
                tF tG tH   tE

	Fi Ft   FF FG FH   FE
	Gi Gt   GF GG GH   GE
	Hi Ht   HF HG HH   HE

	Ei Et   EF EG EH   EE
*/
void dot (const vector<s>& Class, s expr) {
  // iX, Xi
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template <class T, class M>" << endl
         << "T" << endl;
    dot_profile_rscal (Class[i] + "<T,M>", "int");
    cout << "template <class T, class M>" << endl
         << "T" << endl;
    dot_profile_lscal ("int", Class[i] + "<T,M>");
    cout << "template <class T1, class T2, class M>" << endl
         << "typename promote<T1,T2>::type" << endl;
    dot_profile_rscal (Class[i] + "<T1,M>", "T2");
    cout << "template <class T1, class T2, class M>" << endl
         << "typename promote<T1,T2>::type" << endl;
    dot_profile_lscal ("T1", Class[i] + "<T2,M>");
  }
  // XY
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
  for (size_t j = 0, nd = Class.size();  j < nd; j++) {
    cout << "template <class T1, class T2, class M>" << endl
         << "typename promote<T1,T2>::type" << endl;
    dot_profile (Class[i] + "<T1,M>", Class[j] + "<T2,M>", class_check);
  }}
  // iE, Ei
  cout << "template <class Expr>" << endl
       << "typename vec_expr<Expr>::element_type" << endl;
  dot_profile_rscal (expr + "<Expr>", "int");
  cout << "template <class Expr>" << endl
       << "typename vec_expr<Expr>::element_type" << endl;
  dot_profile_lscal ("int", expr + "<Expr>");
  // tE, Et
  cout << "template <class T, class Expr>" << endl
       << "typename promote<T,typename vec_expr<Expr>::element_type>::type" << endl;
  dot_profile_rscal (expr + "<Expr>", "T");
  cout << "template <class T, class Expr>" << endl
       << "typename promote<T,typename vec_expr<Expr>::element_type>::type" << endl;
  dot_profile_lscal ("T", expr + "<Expr>");

  // XE, EY
  for (size_t i = 0, nc = Class.size();  i < nc; i++) {
    cout << "template <class T, class M, class Expr>" << endl
         << "typename promote<T,typename vec_expr<Expr>::element_type>::type" << endl;
    dot_profile (Class[i] + "<T,M>", expr + "<Expr>", expr_check);
    cout << "template <class T, class M, class Expr>" << endl
         << "typename promote<T,typename vec_expr<Expr>::element_type>::type" << endl;
    dot_profile (expr + "<Expr>", Class[i] + "<T,M>", expr_check);
  }
  // EE
  cout << "template <class Expr1, class Expr2>" << endl
       << "typename promote<" << endl
       << "  typename vec_expr<Expr1>::element_type," << endl
       << "  typename vec_expr<Expr2>::element_type"  << endl
       << ">::type" << endl;
  dot_profile (expr + "<Expr1>", expr + "<Expr2>", expr2_check);
}
// =====================================================================================
int main() {
// =====================================================================================
  s expr    = "vec_expr";
  s details = "vec_detail";
  s domain  = "vec_domain";
  s tag  = "is_vec";

  vector<rhs> Rhsclass;
  Rhsclass.push_back (rhs("vec",   "&"));

  vector<s> Class;
  Class.push_back ("vec");

  vector<op> Unop;
  Unop.push_back (op("+", "boost::proto::tag::unary_plus"));
  Unop.push_back (op("-", "boost::proto::tag::negate"));

  vector<op> Binop;
  Binop.push_back (op("+", "boost::proto::tag::plus"));
  Binop.push_back (op("-", "boost::proto::tag::minus"));
  Binop.push_back (op("*", "boost::proto::tag::multiplies"));
  Binop.push_back (op("/", "boost::proto::tag::divides"));

  vector<aop> Assign_op;
  Assign_op.push_back (aop("+=", "plus_assign"));
  Assign_op.push_back (aop("-=", "minus_assign"));
  Assign_op.push_back (aop("*=", "multiplies_assign"));
  Assign_op.push_back (aop("/=", "divides_assign"));

  vector<func> Ufunc;
  Ufunc.push_back (func("abs"));
  Ufunc.push_back (func("fabs"));
  Ufunc.push_back (func("floor"));
  Ufunc.push_back (func("ceil"));
  Ufunc.push_back (func("sqr"));	// rheolef extension

  vector<func> Bifunc;
  Bifunc.push_back (func("min"));	// std::algorithm
  Bifunc.push_back (func("max"));

  header();
  all_unops      (tag, domain, Unop,  Class, expr);
  all_binops     (tag, domain, Binop, Class, expr);
  all_assign_ops (tag, domain, details, Assign_op, Rhsclass, Class, expr);
  all_ufunc  ("boost::proto::tag::function", domain, details, Ufunc,  Class, expr);
  all_bifunc ("boost::proto::tag::function", domain, details, Bifunc, Class, expr);
  ucompose   ("boost::proto::tag::function", domain, details, "compose", Class, expr);
  bicompose  ("boost::proto::tag::function", domain, details, "compose", Class, expr);
  dot (Class, expr);
  footer();
}
