///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
# include "rheolef/asr.h"
# include <sstream>
using namespace std;
using namespace rheolef;

void
read_mm_banner(idiststream& ips)
{
  if (!ips.do_load()) return;
  istream& is = ips.is();
  bool already_have_a_spec_line = false;
  do {
    char c;
    is >> std::ws >> c;
    if (c != '%') {
      // no banner: starts directly with sizes
      check_macro (isdigit(c), "mm read: not in matrix market format");
      is.unget();
      return;
    }
    is >> std::ws >> c;
    bool have_a_spec_line = (c == '%');
    std::string line;
    getline (is, line);
    if (have_a_spec_line && ! already_have_a_spec_line) {
      std::stringstream spec (line);
      std::string head, matrix, type, valued, symmetry;
      // see http://math.nist.gov/MatrixMarket/formats.html
      // and http://math.nist.gov/MatrixMarket/reports/MMformat.ps.gz , page 7
      spec >> head >> matrix >> type >> valued >> symmetry;
      check_macro (head     == "MatrixMarket", "mm read: expect `%%MatrixMarket', get `"<<head<<"'");
      check_macro (matrix   == "matrix",       "mm read: unsupported `"<<matrix  <<"' extension: only \"matrix\" format yet supported");
      check_macro (type     == "coordinate",   "mm read: unsupported `"<<type    <<"': only \"coordinate\" format yet supported");
      check_macro (valued   == "real",         "mm read: unsupported `"<<valued  <<"': only \"real\" values yet supported");
      check_macro (symmetry == "general",      "mm read: unsupported `"<<symmetry<<"': only \"general\" format yet supported");
      already_have_a_spec_line = true;
    }
  } while (true); 
} 
int main(int argc, char**argv) {
    environment distributed(argc, argv);
    asr<Float> a;
    dcin >> a; 
    dcout << a;
}
