#include "rheolef.h"
using namespace std;
using namespace rheolef;
#include "torus.icc"
int main (int argc, char**argv) {
  environment rheolef(argc, argv);
  geo lambda (argv[1]);
  space Xh (lambda, "P1");
  field phi_h = interpolate(Xh, phi);
  band gh (phi_h);
  field phi_h_band = phi_h [gh.band()];
  space Bh (gh.band(), "P1");
  Bh.block ("isolated");
  Bh.unblock ("zero");
  form m (Bh, Bh, "mass",      gh);
  form a (Bh, Bh, "grad_grad", gh);
  size_t d = lambda.dimension();
  field lh = riesz (Bh, f(d), gh);
  vector<vec<Float> > b (gh.n_connected_component());
  vector<Float>       z (gh.n_connected_component(), 0);
  for (size_t i = 0; i < b.size(); i++) {
    const domain& cci = gh.band() ["cc"+itos(i)];
    field phi_h_cci (Bh, 0);
    phi_h_cci [cci] = phi_h_band [cci];
    b[i] = phi_h_cci.u();
  }
  field c = m*field(Bh,1);
  csr<Float> A = { { a.uu(),       trans(b), c.u()},
                   { b,            0,        0    },
                   { trans(c.u()), 0,        0    } };
  vec<Float> F =   { lh.u(),       z,        0};
  A.set_symmetry(true);
  solver sa = ldlt(A);
  vec<Float> U = sa.solve (F);
  field uh(Bh,0);
  uh.set_u() = U [range(0,uh.u().size())];
  gh.band().save();
  dout << catchmark("u")   << uh 
       << catchmark("phi") << phi_h;
}
