#ifndef _RHEOLEF_PK_H
#define _RHEOLEF_PK_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/basis.h"
#include "rheolef/tensor.h"
#include <boost/numeric/ublas/matrix.hpp>
namespace rheolef {
namespace ublas = boost::numeric::ublas;

template<class T>
class basis_Pk: public basis_rep<T> {
public:

// typedefs:

  typedef size_t size_type;

// allocators:

  basis_Pk (std::string name);
  ~basis_Pk();

// accessors:

  size_type degree () const { return _degree; }
  size_type size (reference_element hat_K) const;

// get Lagrange nodes associated to dofs:

  void hat_node (reference_element hat_K, std::vector<point_basic<T> >& hat_x) const;

// evaluation of all basis functions at hat_x:

  void eval
	(reference_element hat_K, const point_basic<T>& hat_x, std::vector<T>& values) const;
  void grad_eval
	(reference_element hat_K, const point_basic<T>& hat_x, std::vector<point_basic<T> >& values) const;
  void hessian_eval
	(reference_element hat_K, const point_basic<T>& hat_x, std::vector<tensor_basic<T> >& values) const;

protected:
// internals:
  void _initialize_guard (reference_element hat_K) const;
  void _initialize (reference_element hat_K) const;
  void _initialize_hat_node (reference_element hat_K) const;

// data:
  size_type                                                             _degree;
  mutable boost::array<bool,reference_element::max_variant>             _initialized;
  mutable boost::array<std::vector<point_basic<size_type> >,
		       reference_element::max_variant>                  _monom;
  mutable boost::array<std::vector<point_basic<T> >,
		       reference_element::max_variant>                  _hat_xnod;
  mutable boost::array<ublas::matrix<T>,reference_element::max_variant> _inv_vdm;
// working array, allocated one time for all to _degree+1 size:
  mutable std::vector<point_basic<T> >                                  _hat_xm;
};
template<class T>
inline
void
basis_Pk<T>::_initialize_guard (reference_element hat_K) const
{
  size_type variant = hat_K.variant();
  check_macro (variant < reference_element::max_variant, "unexpected element type: "<<variant);
  if (_initialized [variant]) return;
  _initialize (hat_K);
  _initialized [variant] = true;
}

} // namespace rheoef
#endif // _RHEOLEF_PK_H
