#ifndef _RHEO_TWO_D_D_H
#define _RHEO_TWO_D_D_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/form_element.h"
namespace rheolef { 

/*Class:
NAME: @code{2D_D} -- -div 2D operator
@bfindex 2D_D
@apindex P1
@apindex P2
@cindex  div(D(.)) operator
@cindex  Stokes problem
@cindex  elasticity problem
@cindex  divergence of tensor
@cindex  rate of deformation tensor
@clindex form
@clindex space
SYNOPSIS:
  @example
    	form (const space V, const space& V, "2D_D");
  @end example
DESCRIPTION:       
  @noindent
@iftex
@tex
  Assembly the form associated to the ${\bf div}(2D(.))$ components of the
  operator on the finite element space $V$:
  $$
  	a({\bf u},{\bf v}) = \int_\Omega  2 D({\bf u}) : D({\bf v}) \, dx
  $$
  where 
  $$
      D_{ij}(u) = 
       {1 \over 2} 
       \left(
	   {{\partial u_i} \over {\partial x_j}}
	   +
	   {{\partial u_j} \over {\partial x_i}}
       \right)
  $$
@end tex
@end iftex
@ifnottex
  Assembly the form associated to the @code{div(2D(.))} components of the
  operator on the finite element space @code{V}:
  @example
                 /
                 |
  	a(u,v) = |  2 D(u) : D(v) dx
                 |
                 / Omega
  @end example
  where 
  @example
                1 ( d ui   d uj )
      Dij(u) =  - ( ---- + ---- )
                2 ( d xj   d xi )
  @end example
@end ifnottex
  This form is usefull when considering elasticity or Stokes
  problems.
EXAMPLE:
  @noindent
  Here is an example of the vector-valued form:
  @example
        geo omega ("square");
        space V (omega, "P2", "vector");
        form  a (V, V, "2D_D");
  @end example
  Note that a factor two is here applied to the form.
  This factor is commonly used in practice.
AUTHOR: 
    LMC-IMAG, 38041 Grenoble cedex 9, France
    | Pierre.Saramito@imag.fr
DATE:
    28 november 1997
End:
*/

template<class T, class M>
class _2D_D: public form_element_rep<T,M> {
public:
    typedef form_element_rep<T,M>       base;
    typedef typename base::size_type    size_type;
    typedef typename base::geo_type     geo_type;
    typedef typename base::space_type   space_type;

// allocator:

    _2D_D (const space_type& X, const space_type& Y, const geo_type& omega,
        const quadrature_option_type& qopt)
	: form_element_rep<T,M> (X,Y,omega,qopt) { base::initialize_all(); }

    void operator() (const geo_element& K, ublas::matrix<T>& m) const;
    void initialize () const;
    bool is_symmetric () const { return true; }
};

}// namespace rheolef
#endif // _RHEOLEF_TWO_D_D_H
