#ifndef _RHEO_FIELD_ASSEMBLY_H
#define _RHEO_FIELD_ASSEMBLY_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/field.h"
#include "rheolef/field_element.h"
#include <boost/functional.hpp>

namespace rheolef { 

template <class T, class M, class Function, class FieldElement>
inline
void
field_assembly (
    const geo_basic<T,M>&	  domain,
    const FieldElement&           field_e,
    const Function&               fct,
    field_basic<T,M>&             lh)
{
  typedef typename field_basic<T,M>::size_type size_type;
#ifdef TO_CLEAN
  typedef typename boost::unary_traits<Function>::result_type result_type;
#endif // TO_CLEAN
  const space_basic<T,M>& X = lh.get_space();
  std::vector<T> lk;
  std::vector<size_type> dis_idx;
  size_type map_dim = domain.map_dimension();
  vec<T,M>& u = lh.set_u();
  vec<T,M>& b = lh.set_b();
  for (size_type ie = 0, ne = domain.size(map_dim); ie < ne; ie++) {
    const geo_element& K = domain.get_geo_element (map_dim, ie);
    // --------------------------------
    // compute elementary array lk on K
    // --------------------------------
    field_e (K, fct, lk);
    // --------------------------------
    // compute idofs
    // --------------------------------
    if (! field_e.is_on_band()) {
      X.dis_idof (K, dis_idx);
    } else {
      const geo_basic<T,M>& lambda = field_e.get_band().band();
      size_type L_ie = field_e.get_band().sid_ie2bnd_ie (ie);
      const geo_element& L = lambda [L_ie];
      X.dis_idof (L, dis_idx);
    }
    // ------------------------------------
    // assembly local lk in global field lh
    // ------------------------------------
    for (size_type loc_idof = 0, loc_ndof = lk.size(); loc_idof < loc_ndof; loc_idof++) {
      const T& value = lk [loc_idof];
      size_type dis_idof = dis_idx [loc_idof];
      size_type dis_iub  = X.dis_iub(dis_idof);
      if (X.dis_is_blocked(dis_idof)) b.dis_entry(dis_iub) += value;
      else                            u.dis_entry(dis_iub) += value;
    }
  }
  u.dis_entry_assembly(set_add_op<T,T>());
  b.dis_entry_assembly(set_add_op<T,T>());
}

}// namespace rheolef
#endif // _RHEO_FIELD_ASSEMBLY_H
