#include "expr_ops_make.icc"
// -----------------------------------------------------------------------------
/* example:			abbrev

   int 				i
   T				t	n_scalar=2

   field<T,M>			F
   field_indirect<T,M>		G	n_class=3
   field_indirect_const<T,M>	H

   field_expr<E>		E	expr

  => binary matrix profile :

                iF iG iH   iE
                tF tG tH   tE

	Fi Ft   FF FG FH   FE
	Gi Gt   GF GG GH   GE
	Hi Ht   HF HG HH   HE

	Ei Et   EF EG EH   EE

  template:
     xY	Xy => template<T,M>		x=i,t  X=F,G,H
	XY => template<T1,T2,M>		X,Y=F,G,H
     iE Ei => template<E>		x=i
     tE Et => template<T,E>		x=t
     XE EX => template<E,T,M>		X=F,G,H
     EE    => template<E1,E2>
*/
// -----------------------------------------------------------------------------
// =====================================================================================
int main() {
// =====================================================================================
  s expr    = "field_expr";
  s details = "field_detail";
  s domain  = "field_domain";
  s tag  = "is_field";

  vector<rhs> Rhsclass;
  Rhsclass.push_back (rhs("field_basic",   "&"));
  Rhsclass.push_back (rhs("field_indirect",""));
  Rhsclass.push_back (rhs("field_component",""));

  vector<s> Class;
  Class.push_back ("field_basic");
  Class.push_back ("field_indirect");
  Class.push_back ("field_indirect_const");
  Class.push_back ("field_component");
  Class.push_back ("field_component_const");

  vector<op> Unop;
  Unop.push_back (op("+", "boost::proto::tag::unary_plus"));
  Unop.push_back (op("-", "boost::proto::tag::negate"));

  vector<op> Binop;
  Binop.push_back (op("+", "boost::proto::tag::plus"));
  Binop.push_back (op("-", "boost::proto::tag::minus"));
  Binop.push_back (op("*", "boost::proto::tag::multiplies"));
  Binop.push_back (op("/", "boost::proto::tag::divides"));

  vector<aop> Assign_op;
  Assign_op.push_back (aop("+=", "plus_assign"));
  Assign_op.push_back (aop("-=", "minus_assign"));
  Assign_op.push_back (aop("*=", "multiplies_assign"));
  Assign_op.push_back (aop("/=", "divides_assign"));

  vector<func> Ufunc;
  Ufunc.push_back (func("cos"));	// std::cmath
  Ufunc.push_back (func("sin"));
  Ufunc.push_back (func("tan"));
  Ufunc.push_back (func("acos"));
  Ufunc.push_back (func("asin"));
  Ufunc.push_back (func("atan"));
  Ufunc.push_back (func("cosh"));
  Ufunc.push_back (func("sinh"));
  Ufunc.push_back (func("tanh"));
  Ufunc.push_back (func("exp"));
  Ufunc.push_back (func("log"));
  Ufunc.push_back (func("log10"));
  Ufunc.push_back (func("sqrt"));
  Ufunc.push_back (func("abs"));
  Ufunc.push_back (func("fabs"));
  Ufunc.push_back (func("floor"));
  Ufunc.push_back (func("ceil"));
  Ufunc.push_back (func("sqr"));	// rheolef extension

  vector<func> Bifunc;
  Bifunc.push_back (func("atan2"));	// std::cmath
  Bifunc.push_back (func("pow"));
  Bifunc.push_back (func("fmod"));
  Bifunc.push_back (func("min"));	// std::algorithm
  Bifunc.push_back (func("max"));

  header("FIELD", "field");
  all_unops      (tag, domain, Unop,  Class, expr);
  all_binops     (tag, domain, Binop, Class, expr);
  all_assign_ops ("field", "stamp", tag, domain, details, Assign_op, Rhsclass, Class, expr);
  all_ufunc  ("boost::proto::tag::function", domain, details, Ufunc,  Class, expr);
  all_bifunc ("boost::proto::tag::function", domain, details, Bifunc, Class, expr);
  ucompose   ("boost::proto::tag::function", domain, details, "compose", Class, expr);
  bicompose  ("boost::proto::tag::function", domain, details, "compose", Class, expr);
  dot ("field", Class, expr, "ndof");
  footer("FIELD", "field");
}
