#ifndef _RHEOLEF_P1D_NUMBERING_V2_H
#define _RHEOLEF_P1D_NUMBERING_V2_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/numbering.h"

namespace rheolef { 

template <class T, class M>
class numbering_P1d : public numbering_rep<T,M> {
public:
// typedefs:

  typedef numbering_rep<T,M>       base;
  typedef typename base::size_type size_type;

// allocator:

  numbering_P1d() { base::_basis = basis("P1"); }

// global method:

  std::string name() const;
  size_type degree () const;
  void set_degree (size_type degree) const;
  bool is_continuous() const;
  size_type       ndof (const geo_size& gs, size_type map_dim) const;
  size_type   dis_ndof (const geo_size& gs, size_type map_dim) const;
  size_type   dis_idof (const geo_size& gs, const geo_element& K, size_type loc_idof) const;
  void        dis_idof (const geo_size& gs, const geo_element& K, std::vector<size_type>& dis_idof) const;
  void set_ios_permutations (const geo_basic<T,M>& omega,
    		array<size_type,M>&   idof2ios_dis_idof,
    		array<size_type,M>&   ios_idof2dis_idof) const;
};

}// namespace rheolef
#endif // _RHEOLEF_P1D_NUMBERING_V2_H
