# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Numeric", "Object", "class")
aClass.addSubclasses(%w{Float Integer})
aClass.addFragment(Paragraph.new("Numeric is the fundamental base type for the concrete number classes <code>Float</code>, <code>Fixnum</code>, and <code>Bignum</code>.\n"))
m0002 = MethodDesc.new("+@", "instance", "+<i>num</i> -> <i>num</i>")
m0002.addFragment(Paragraph.new("Unary Plus---Returns the receiver's value.\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("--@", "instance", "--<i>num</i> -> <i>aNumeric</i>")
m0003.addFragment(Paragraph.new("Unary Minus---Returns the receiver's value, negated.\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("abs", "instance", "<i>num</i>.abs -> <i>aNumeric</i>")
m0004.addFragment(Paragraph.new("Returns the absolute value of <i>num</i>.\n"))
m0004.addFragment(Verbatim.new("12.abs         \#=> 12\n(-34.56).abs   \#=> 34.56\n-34.56.abs     \#=> 34.56\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("coerce", "instance", "<i>num</i>.coerce( <i>aNumeric</i> ) -> <i>anArray</i>")
m0005.addFragment(Paragraph.new("If <i>aNumeric</i> is the same type as <i>num</i>, returns an array containing <i>aNumeric</i> and <i>num</i>. Otherwise, returns an array with both <i>aNumeric</i> and <i>num</i> represented as <code>Float</code> objects.\n"))
m0005.addFragment(Verbatim.new("1.coerce(2.5)   \#=> [2.5, 1.0]\n1.2.coerce(3)   \#=> [3.0, 1.2]\n1.coerce(2)     \#=> [2, 1]\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("divmod", "instance", "<i>num</i>.divmod( <i>aNumeric</i> ) -> <i>anArray</i>")
m0006.addFragment(Paragraph.new("Returns an array containing the quotient and modulus obtained by dividing <i>num</i> by <i>aNumeric</i>. If <code>q, r = x.divmod(y)</code>,\n"))
m0006.addFragment(Paragraph.new("The quotient is rounded toward -infinity. See Table 22.6 on page 355.\n"))
m0006.addFragment(Verbatim.new("11.divmod(3)         \#=> [3, 2]\n11.divmod(-3)        \#=> [-4, -1]\n11.divmod(3.5)       \#=> [3.0, 0.5]\n(-11).divmod(3.5)    \#=> [-4.0, 3.0]\n(11.5).divmod(3.5)   \#=> [3.0, 1.0]\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("eql?", "instance", "<i>num</i>.eql?( <i>aNumeric</i> ) -> <code>true</code> or <code>false</code>")
m0007.addFragment(Paragraph.new("Returns <code>true</code> if <i>num</i> and <i>aNumeric</i> are the same type and have equal values.\n"))
m0007.addFragment(Verbatim.new("1 == 1.0          \#=> true\n1.eql?(1.0)       \#=> false\n(1.0).eql?(1.0)   \#=> true\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("integer?", "instance", "<i>num</i>.integer? -> <code>true</code> or <code>false</code>")
m0008.addFragment(Paragraph.new("Returns <code>true</code> if <i>num</i> is an <code>Integer</code> (including <code>Fixnum</code> and <code>Bignum</code>).\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("modulo", "instance", "<i>num</i>.modulo( <i>aNumeric</i> ) -> <i>aNumeric</i>")
m0009.addFragment(Paragraph.new("Equivalent to <i>num</i>.<code>divmod(</code><i>aNumeric</i><code>)[1]</code>.\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("nonzero?", "instance", "<i>num</i>.nonzero? -> <i>num</i> or <code>nil</code>")
m0010.addFragment(Paragraph.new("Returns <i>num</i> if <i>num</i> is not zero, <code>nil</code> otherwise. This behavior is useful when chaining comparisons:\n"))
m0010.addFragment(Verbatim.new("a = %w( z Bb bB bb BB a aA Aa AA A )\nb = a.sort {|a,b| (a.downcase <=> b.downcase).nonzero? || a <=> b }\nb   \#=> [\"A\", \"a\", \"AA\", \"Aa\", \"aA\", \"BB\", \"Bb\", \"bB\", \"bb\", \"z\"]\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("remainder", "instance", "<i>num</i>.remainder( <i>aNumeric</i> ) -> <i>aNumeric</i>")
m0011.addFragment(Paragraph.new("If <i>num</i> and <i>aNumeric</i> have different signs, returns <em>mod</em>-<i>aNumeric</i>; otherwise, returns <em>mod</em>. In both cases <em>mod</em> is the value <i>num</i>.<code>modulo(</code><i>aNumeric</i><code>)</code>. The differences between <code>remainder</code> and modulo (<code>%</code>) are shown in Table 22.6 on page 355.\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("zero?", "instance", "<i>num</i>.zero? -> <code>true</code> or <code>false</code>")
m0012.addFragment(Paragraph.new("Returns <code>true</code> if <i>num</i> has a zero value.\n"))
aClass.addMethod(m0012)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
