/*
 *  sort-dialog.c        -
 *
 *  Created: 20020314
 *
 *  Copyright (c) 2001, 2002 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: sort-dialog.c,v 1.10 2002/03/19 23:12:58 tomek Exp $
 *
 */

#ifndef HAVE_CONFIG_H
# include <config.h>
#endif

#include <sort-dialog.h>

#include <intl.h>
#include <globals.h>
#include <common.h>

/* Struktura zawierajca dane okienka dialogowego. */
typedef struct
{
    fields_list_type      list;
    GtkWidget             *dialog;
} sort_dialog_data;

/* Funkcja obsugujca sygna "clicked" przycisku "OK". */
static void ok_button_clicked(GtkWidget *widget, sort_dialog_data *data)
{
    gpointer entry;
    gchar *text;
    gint i;
    
    g_assert(data != NULL);
    g_assert(data->dialog != NULL);

    /* Pobieranie danych z elementw okna dialogowego. */
    entry = gtk_object_get_data(GTK_OBJECT(data->dialog), "field0");
    g_assert(entry != NULL);
    text = gtk_entry_get_text(GTK_ENTRY(entry));
    
    entry = gtk_object_get_data(GTK_OBJECT(data->dialog), "radio0");
    g_assert(entry != NULL);
    list_params[data->list].sort_growly = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(entry));
    
    list_params[data->list].sort_field = -1;
    for (i = 0; i < list_items_length(data->list); i++)
        if (strcmp(text, gettext(fields_list_items[data->list][i].name)) == 0)
	{
            list_params[data->list].sort_field = i;
	    continue;
	}
    
    /* Zamyka okienko dialogowe. */
    gtk_widget_destroy(data->dialog);
    
    /* Uaktualnianie listy kontaktw lub terminw. */
    switch (data->list)
    {
        case LT_APPOINTMENT:
	    show_fields_list(LT_APPOINTMENT, FALSE);
	    break;
	case LT_CONTACT:
            show_fields_list(LT_CONTACT, FALSE);
	    break;
	default:
	    g_assert_not_reached();
    }

    /* Zwalnianie pamici zajmowanej przez dane okienka dialogowego. */
    g_free(data);
}

/* Funkcja obsugujca sygna "clicked" przycisku "Anuluj". */
static void cancel_button_clicked(GtkWidget *widget, sort_dialog_data *data)
{
    g_assert(data != NULL);
    g_assert(data->dialog != NULL);
    
    /* Zamyka okienko dialogowe. */
    gtk_widget_destroy(data->dialog);
    
    /* Zwalnianie pami zajmowanej przez dane okienka dialogowego. */
    g_free(data);
}

/* Funkcja tworzca list elementw pola wyboru. */
static void create_fields_list(GtkWidget *combo, sort_dialog_data *data)
{
    GList *items = NULL;
    gint i;
    
    /* Tworzenie listy wybory pola wyboru. */
    items = g_list_append(items, (gpointer)_("(nothing)"));
    for (i = 0; i < list_items_length(data->list); i++)
        items = g_list_append(items, (gpointer)gettext(fields_list_items[data->list][i].name));
    
    gtk_combo_set_popdown_strings(GTK_COMBO(combo), items);
    
    g_list_free(items);
}

/* Funkcja tworzca ramk suc do ustalania sortowania. */
static GtkWidget *create_sort_frame(GtkWidget *parent, sort_dialog_data *data)
{
    GtkWidget *frame;
    GtkWidget *fixed;
    GtkWidget *combo;
    GtkWidget *entry;
    GtkWidget *radiobutton;
    
    GSList *group = NULL;
    
    /* Ramka. */
    frame = gtk_frame_new(_("Sort items by"));
    gtk_widget_show(frame);
    
    gtk_fixed_put(GTK_FIXED(parent), frame, 8, 8);
    gtk_widget_set_uposition(frame, 8, 8);
    gtk_widget_set_usize(frame, 280, 80);
    gtk_container_set_border_width(GTK_CONTAINER(frame), 4);
    gtk_frame_set_label_align(GTK_FRAME(frame), 0.05, 0.5);
		
        /* Wntrze ramki. */
        fixed = gtk_fixed_new();
        gtk_widget_show(fixed);
        
        gtk_container_add(GTK_CONTAINER(frame), fixed);
        
            /* Pole wyboru rodzaju pola. */
            combo = gtk_combo_new();
            gtk_widget_show(combo);
            
            gtk_fixed_put(GTK_FIXED(fixed), combo, 8, 8);
            gtk_widget_set_uposition(combo, 8, 8);
            gtk_widget_set_usize(combo, 160, 32);
            gtk_combo_set_value_in_list(GTK_COMBO(combo), TRUE, FALSE);

	    create_fields_list(combo, data);
	    
		/* Pole edycji pola wyboru rodzaju pola. */
		entry = GTK_COMBO(combo)->entry;
		gtk_widget_show(entry);
		
		gtk_object_set_data(GTK_OBJECT(data->dialog), "field0", entry);
		
                if (list_params[data->list].sort_field == -1)		
		    gtk_entry_set_text(GTK_ENTRY(entry), _("(nothing)"));
		else
		    gtk_entry_set_text(GTK_ENTRY(entry),
		        gettext(fields_list_items[data->list][list_params[data->list].sort_field].name));

		gtk_entry_set_editable(GTK_ENTRY(entry), FALSE);
		gtk_widget_grab_focus(entry);
		
	    /* Radiobutton "Rosnco". */
	    radiobutton = gtk_radio_button_new_with_label(group, _("Ascending"));
	    group = gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton));
	    gtk_widget_show(radiobutton);
	    
	    gtk_object_set_data(GTK_OBJECT(data->dialog), "radio0", radiobutton);
	    
	    gtk_fixed_put(GTK_FIXED(fixed), radiobutton, 176, 0);
	    gtk_widget_set_uposition(radiobutton, 176, 0);
	    gtk_widget_set_usize(radiobutton, 88, 24);
	    
	    if (list_params[data->list].sort_growly)
	        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobutton), TRUE);
	    
	    /* Radiobutton "Malejco". */
	    radiobutton = gtk_radio_button_new_with_label(group, _("Descending"));
	    group = gtk_radio_button_group(GTK_RADIO_BUTTON(radiobutton));
	    gtk_widget_show(radiobutton);
	    
	    gtk_fixed_put(GTK_FIXED(fixed), radiobutton, 176, 24);
	    gtk_widget_set_uposition(radiobutton, 176, 24);
	    gtk_widget_set_usize(radiobutton, 88, 24);
	    
	    if (!list_params[data->list].sort_growly)
	        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radiobutton), TRUE);
    
    return frame;
}

/* Funkcja tworzca okno dialogowe suce do porzdku pl wywietlanych w licie kontaktw.

   Struktura okna:
   
     GtkDialog (sort_dialog)
      +- GtkVBox (dialog_vbox)
      |   +- GtkFixed
      |       +- GtkFrame
      |           +- GtkFixed
      |               +- GtkCombo
      |               |   +- GtkEntry
      |               +- GtkRadioButton                            "Rosnco"
      |               +- GtkRadioButton                           "Malejco"
      +- GtkHBox (dialog_action_area)
          +- GtkHButtonBox
	      +- GtkButton                                              "OK"
	      +- GtkButton                                          "Anuluj"

    Klucze zwizane z okienkiem dialogowym:
    
      field0 - wskanik do pola edycji pola wyboru pola struktury danych kontaktu
      radio0 - wskanik do przycisku opcji "Rosnco"

*/
void create_sort_fields_dialog(fields_list_type list)
{
    GtkWidget *dialog_vbox;
    GtkWidget *fixed;
    GtkWidget *dialog_action_area;
    GtkWidget *hbuttonbox;
    GtkWidget *button;
    
    sort_dialog_data *data;
    
    /* Utworzenie zmiennej sucej do przechowywania danych okienka dialogowego
       i wypenienie jej danymi. */
    data = (sort_dialog_data *)g_malloc0(sizeof(sort_dialog_data));
    data->list = list;
    
    /* Utworzenie okienka dialogowego. */
    data->dialog = gtk_dialog_new();

    /* Przypisanie funkcji obsugi sygnaw do okienka dialogowego. */
    gtk_signal_connect(GTK_OBJECT(data->dialog), "delete_event",
                       GTK_SIGNAL_FUNC(cancel_button_clicked), data);
    gtk_signal_connect(GTK_OBJECT(data->dialog), "key_press_event",
                       GTK_SIGNAL_FUNC(dialog_key_press), data);
    
    /* Ustalanie tytuu i rozmiarw okna. */
    gtk_window_set_title(GTK_WINDOW(data->dialog), _("Sort..."));
    gtk_widget_set_usize(GTK_WIDGET(data->dialog), 294, 150);
    
        /* Obszar wntrza okna dialogowego. */
	dialog_vbox = GTK_DIALOG(data->dialog)->vbox;
	gtk_widget_show(dialog_vbox);
	
	    /* Wntrze okienka. */
	    fixed = gtk_fixed_new();
	    gtk_widget_show(fixed);
	    
	    gtk_box_pack_start(GTK_BOX(dialog_vbox), fixed, TRUE, TRUE, 0);

            /* Tworzenie rameki sortowania. */
	    create_sort_frame(fixed, data);
	    
	/* Obszar przyciskw okienka dialogowego. */
	dialog_action_area = GTK_DIALOG(data->dialog)->action_area;
	gtk_widget_show(dialog_action_area);
	
	gtk_container_set_border_width(GTK_CONTAINER(dialog_action_area), 10);
	
	    /* Listwa przyciskw. */
	    hbuttonbox = gtk_hbutton_box_new();
	    gtk_widget_show(hbuttonbox);
	    
	    gtk_box_pack_start(GTK_BOX(dialog_action_area), hbuttonbox, TRUE, TRUE, 0);
	    
	    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox), GTK_BUTTONBOX_END);
	    gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbuttonbox), 10);
	    
	        /* Przycisk "OK". */
		button = gtk_button_new_with_label(_("OK"));
		gtk_widget_show(button);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(ok_button_clicked), data);
		
		gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
		
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(button);
		
		/* Przycisk "Anuluj". */
		button = gtk_button_new_with_label(_("Cancel"));
		gtk_widget_show(button);
		
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
		                   GTK_SIGNAL_FUNC(cancel_button_clicked), data);
		
		gtk_container_add(GTK_CONTAINER(hbuttonbox), button);
		
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	
    /* Wywietlanie okienka dialogowego. */
    gtk_widget_show(data->dialog);
    
    /* Ustalanie modalnoci okienka. */
    gtk_window_set_modal(GTK_WINDOW(data->dialog), TRUE);
    gtk_window_set_transient_for(GTK_WINDOW(data->dialog), GTK_WINDOW(main_window));
}
