// globals

function preprocess () {
  

echo ('  require(ltm)\n');
}

function calculate () {
  
  constraint   = getValue("constraint");
  startval     = getValue("startval");
  startval_mtx = getValue("startval_mtx");
  naaction     = getValue("naaction");
  irtparam     = getValue("irtparam");
  optimeth     = getValue("optimeth");
  verbose      = getValue("verbose");
  
  ghk_3pl      = getValue("ghk_3pl");
  iterqn_3pl   = getValue("iterqn_3pl");
  type         = getValue("type");
  maxguess     = getValue("maxguess");
  optimizer    = getValue("optimizer");
  epshess      = getValue("epshess");
  

  
  
  control = array() ;
  if(optimizer != "optim")
    control[] = "optimizer=\"nlminb\"" ;
  if(iterqn_3pl != "1000")
    control[] = "iter.qN="+iterqn_3pl ;
  if(ghk_3pl != "21")
    control[] = "GHk="+ghk_3pl ;
  if(optimizer == "optim" && optimeth != "BFGS")
    control[] = "method=\""+optimeth+"\"" ;
  if(verbose == "TRUE")
    control[] = "verbose=TRUE" ;
  if(epshess != "1e-03")
    control[] = "eps.hessian="+epshess ;

echo ('estimates.3pl <<- tpm(' + getValue("x"));
                  
                  if(type == "rasch") echo (", type=\"rasch\"");
                  if(constraint) echo (", constraint="+constraint);
                  if(maxguess != "1") echo (", max.guessing="+maxguess);
                  if(irtparam != "TRUE") echo (", IRT.param=FALSE");
                  if(startval == "random") echo (", start.val=\"random\"");
                  if(startval == "matrix") echo (", start.val="+startval_mtx);
                  if(naaction) echo (", na.action="+naaction);
                  
                  if(control) echo (", control=list("+join(", ", control)+")");
 echo (')\n');
}

function printout () {
echo ('rk.header ("3PL parameter estimation")\n');
echo ('rk.print (estimates.3pl)\n');
}
