// globals

function preprocess () {
  

echo ('  require(ltm)\n');
}

function calculate () {
  
  constraint   = getValue("constraint");
  startval     = getValue("startval");
  startval_lst = getValue("startval_lst");
  hessian      = getValue("hessian");
  naaction     = getValue("naaction");
  irtparam     = getValue("irtparam");
  optimeth     = getValue("optimeth");
  verbose      = getValue("verbose");
  
  ghk_grm      = getValue("ghk_grm");
  iterqn_grm   = getValue("iterqn_grm");
  dig_abbrv    = getValue("dig_abbrv");

  
  
  control = array() ;
  if(iterqn_grm != "150")
    control[] = "iter.qN="+iterqn_grm ;
  if(ghk_grm != "21")
    control[] = "GHk="+ghk_grm ;
  if(optimeth != "BFGS")
    control[] = "method=\""+optimeth+"\"" ;
  if(verbose == "TRUE")
    control[] = "verbose=TRUE" ;
  if(dig_abbrv != "6")
    control[] = "digits.abbrv="+dig_abbrv ;

echo ('estimates.grm <<- grm(' + getValue("x"));
                  
                  if(constraint == "const_discr") echo (", constrained=TRUE");
                  if(irtparam != "TRUE") echo (", IRT.param=FALSE");
                  if(hessian == "hessian") echo (", Hessian=TRUE");
                  if(startval == "random") echo (", start.val=\"random\"");
                  if(startval == "list") echo (", start.val="+startval_lst);
                  if(naaction) echo (", na.action="+naaction);
                  
                  if(control) echo (", control=list("+join(", ", control)+")");
 echo (')\n');
}

function printout () {
echo ('rk.header ("GRM parameter estimation")\n');
echo ('rk.print (estimates.grm)\n');
}
