// globals
var options;



function printout () {
	doPrintout (true);
}

function preview () {
	preprocess ();
	calculate ();
	doPrintout (false);
}


function getContRangeParameters () {
	options['n'] = getValue ("n");
	options['min'] = getValue ("min");
	options['max'] = getValue ("max");
}


function getDiscontRangeParameters () {
	options['min'] = getValue ("min");
	options['max'] = getValue ("max");
	options['n'] = options['max'] - options['min'] + 1;
}

function doPrintout (final) {
	fun = getValue ("function");
	log = (getValue ("log") == 1);
	log_option = "";
	if (fun == "d") {
		is_density = true;
		label = "density";
		tail_option = "";
		tail_label = "";
		if (log) log_option = ", log=TRUE";
	} else {
		is_density = false;
		label = "distribution";
		if (getValue("lower") == "1") {
			tail_option = ", lower.tail = TRUE";
			tail_label = ", \"Tail\",\"Lower\"";
		} else {
			tail_option = ", lower.tail = FALSE";
			tail_label = ", \"Tail\",\"Upper\"";
		}
		if (log) log_option = ", log.p=TRUE";
	}
	if (log) log_label = ', "Scale", "logarithmic"';
	else log_label = ', "Scale", "normal"';

	options = array ();
	options['is_density'] = is_density;
	options['label'] = label;
	options['tail_option'] = tail_option;
	options['tail_label'] = tail_label;
	options['log_option'] = log_option;
	options['log_label'] = log_label;

	getParameters ();

	if (final) {
		doHeader (); 
echo ('\n');
echo ('rk.graph.on ()\n');
	}

echo ('try ({\n');
echo ('	curve ('); doFunCall (); echo (', from=' + options['min'] + ', to=' + options['max'] + ', n=' + options['n'] + getValue ("plotoptions.code.printout") + ')\n');
	
	plot_adds = getValue ("plotoptions.code.calculate");
	if (!empty (plot_adds)) { 
echo ('\n');
		printIndented ("\t", plot_adds);
	} 
echo ('})\n');
	if (final) { 
echo ('rk.graph.off ()\n');
}
}

