// globals

function preprocess () {
  

echo ('  require(eRm)\n');
}


function printout () {
        doPrintout (true);
}

function preview () {
        preprocess ();
        calculate ();
        doPrintout (false);
}

function doPrintout (final) {
        
        
        

  
  rad_splitcr      = getValue("rad_splitcr");
  splitvector      = getValue("splitvector");
  inp_items        = getValue("inp_items");
  chk_se           = getValue("chk_se");
  chk_confint      = getValue("chk_confint");
  spin_confint     = getValue("spin_confint");
  chk_ctrline      = getValue("chk_ctrline");
  spin_ctrline     = getValue("spin_ctrline");
  spin_abilfrom    = getValue("spin_abilfrom");
  spin_abilto      = getValue("spin_abilto");
  annotation       = getValue("annotation");

  
  plot_options     = getValue("plotoptions.code.printout");
  plot_ops_main    = getValue("plotoptions.main");
  plot_ops_type    = getValue("plotoptions.pointtype");
  plot_ops_xlab    = getValue("plotoptions.xlab");
  plot_ops_ylab    = getValue("plotoptions.ylab");

  
  
  
  options_lrtest = array() ;
  options_plotgof = array() ;
  
  if(inp_items) {
    
    
    inp_items = str_replace("-",":",inp_items);
    arr_items = split('[ ;]', inp_items);
    options_plotgof[] = "beta.subset=c("+join(",", arr_items)+")"; }
  if(rad_splitcr == "mean" || rad_splitcr == "all.r")
    options_lrtest[] = "splitcr=\"$rad_splitcr\"";
  if(rad_splitcr == "vector")
    options_lrtest[] = "splitcr=$splitvector";
  if(chk_se == "se")
    options_lrtest[] = "se=TRUE";
  if(chk_confint == "conf") {
    if(spin_confint != "0.95")
      options_plotgof[] = "conf=list(gamma="+round(spin_confint,2)+", col=\"red\", lty=\"dashed\", ia=FALSE)";
    else
      options_plotgof[] = "conf=list()"; }
  if(chk_ctrline == "ctrline") {
    if(spin_ctrline != "0.95")
      options_plotgof[] = "ctrline=list(gamma="+round(spin_ctrline,2)+", col=\"blue\", lty=\"solid\")";
    else
      options_plotgof[] = "ctrline=list()"; }

/*
  if( == "")
    $options[] = "=list(\"$\")" ;
*/

  
  
  if(($spin_abilfrom != "-3" || $spin_abilto != "3") && $spin_abilfrom < $spin_abilto)
    $options_plotgof[] = "xlim=c(".round($spin_abilfrom,2).",".round($spin_abilto,2).")" ;
  
  if($annotation == "number" || $annotation == "none" || $annotation == "identify")
    $options_plotgof[] = "tlab=\"$annotation\"" ;

        if ($final) { ?>
rk.header("Andersen's LR test")

rk.graph.on()
<?       }
        

        ?>
lr.res <- LRtest(<? getRK("x");
              if($options_lrtest) echo (", ".join(", ", $options_lrtest));
          ?>)
try(plotGOF(lr.res<?
              if($options_plotgof) echo (", ".join(", ", $options_plotgof));
              if($plot_options) echo ($plot_options);
          ?>))
<?
        if ($final) { ?>
rk.graph.off()
<? }
}
?>